/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils.longtask.api;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.utils.progress.ProgressTicketProvider;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public final class LongTaskExecutor {
    private final boolean inBackground;
    private boolean interruptCancel;
    private final long interruptDelay;
    private final String name;
    private ThreadPoolExecutor executor;
    private RunningLongTask currentTask;
    private Timer cancelTimer;
    private LongTaskListener listener;
    private LongTaskErrorHandler defaultErrorHandler;

    public LongTaskExecutor(boolean doInBackground, String name, int interruptDelay) {
        this.inBackground = doInBackground;
        this.name = name;
        this.interruptCancel = true;
        this.interruptDelay = interruptDelay * 1000;
    }

    public LongTaskExecutor(boolean doInBackground, String name) {
        this(doInBackground, name, 0);
        this.interruptCancel = false;
    }

    public LongTaskExecutor(boolean doInBackground) {
        this(doInBackground, "LongTaskExecutor");
    }

    public synchronized void execute(LongTask task, Runnable runnable, String taskName, LongTaskErrorHandler errorHandler) {
        if (runnable == null || taskName == null) {
            throw new NullPointerException();
        }
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(0, 1, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory());
        }
        RunningLongTask runningLongtask = new RunningLongTask(task, runnable, taskName, errorHandler);
        if (this.inBackground) {
            runningLongtask.future = this.executor.submit(runningLongtask);
        } else {
            this.currentTask = runningLongtask;
            runningLongtask.run();
        }
    }

    public synchronized void execute(LongTask task, Runnable runnable) {
        this.execute(task, runnable, "", null);
    }

    public synchronized void cancel() {
        if (this.inBackground) {
            RunningLongTask rlt;
            if (this.executor != null && (rlt = this.currentTask) != null) {
                boolean res = rlt.cancel();
                if (this.interruptCancel && !res) {
                    this.cancelTimer = new Timer(this.name + "_cancelTimer");
                    this.cancelTimer.schedule((TimerTask)new InterruptTimerTask(rlt), this.interruptDelay);
                }
            }
        } else {
            RunningLongTask rlt = this.currentTask;
            if (rlt != null) {
                boolean res = rlt.cancel();
                if (this.interruptCancel && !res) {
                    this.cancelTimer = new Timer(this.name + "_cancelTimer");
                    this.cancelTimer.schedule((TimerTask)new InterruptTimerTask(rlt), this.interruptDelay);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.currentTask != null;
    }

    public void setLongTaskListener(LongTaskListener listener) {
        this.listener = listener;
    }

    public void setDefaultErrorHandler(LongTaskErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.defaultErrorHandler = errorHandler;
        }
    }

    private synchronized void finished(RunningLongTask runningLongTask) {
        if (this.cancelTimer != null) {
            this.cancelTimer.cancel();
        }
        LongTask task = runningLongTask.task;
        this.currentTask = null;
        if (this.listener != null) {
            this.listener.taskFinished(task);
        }
    }

    private class InterruptTimerTask
    extends TimerTask {
        private final RunningLongTask task;

        public InterruptTimerTask(RunningLongTask runningLongTask) {
            this.task = runningLongTask;
        }

        @Override
        public void run() {
            if (this.task != null) {
                if (this.task.future != null) {
                    this.task.future.cancel(LongTaskExecutor.this.interruptCancel);
                }
                LongTaskExecutor.this.cancelTimer.cancel();
                LongTaskExecutor.this.cancelTimer = null;
                if (this.task.progress != null) {
                    this.task.progress.finish();
                }
                LongTaskExecutor.this.finished(this.task);
                if (!LongTaskExecutor.this.inBackground) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, LongTaskExecutor.this.name);
        }
    }

    private class RunningLongTask
    implements Runnable {
        private final LongTask task;
        private final Runnable runnable;
        private Future<?> future;
        private ProgressTicket progress;
        private LongTaskErrorHandler errorHandler;

        public RunningLongTask(LongTask task, Runnable runnable, String taskName, LongTaskErrorHandler errorHandler) {
            this.task = task;
            this.runnable = runnable;
            this.errorHandler = errorHandler;
            ProgressTicketProvider progressProvider = (ProgressTicketProvider)Lookup.getDefault().lookup(ProgressTicketProvider.class);
            if (progressProvider != null) {
                this.progress = progressProvider.createTicket(taskName, new Cancellable(){

                    public boolean cancel() {
                        LongTaskExecutor.this.cancel();
                        return true;
                    }
                });
                if (task != null) {
                    task.setProgressTicket(this.progress);
                } else {
                    this.progress.start();
                }
            }
        }

        @Override
        public void run() {
            LongTaskExecutor.this.currentTask = this;
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                LongTaskErrorHandler err = this.errorHandler;
                LongTaskExecutor.this.finished(this);
                if (this.progress != null) {
                    this.progress.finish();
                }
                if (err != null) {
                    err.fatalError(e);
                }
                if (LongTaskExecutor.this.defaultErrorHandler != null) {
                    LongTaskExecutor.this.defaultErrorHandler.fatalError(e);
                }
                Logger.getLogger("").log(Level.SEVERE, "", e);
            }
            LongTaskExecutor.this.currentTask = null;
            LongTaskExecutor.this.finished(this);
            if (this.progress != null) {
                this.progress.finish();
            }
        }

        public boolean cancel() {
            if (this.task != null) {
                return this.task.cancel();
            }
            return false;
        }
    }
}

