/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.tables.celleditors;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.gephi.desktop.datalab.utils.GraphModelProvider;
import org.gephi.desktop.datalab.utils.stringconverters.DoubleStringConverter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.joda.time.DateTimeZone;

public class AttributeTypesSupportCellEditor
extends DefaultCellEditor {
    private static final Border RED_BORDER = new LineBorder(Color.red);
    private final GraphModelProvider graphModelProvider;
    private final JTextField textField;
    private final Border originalBorder;
    private final Class<?> typeClass;
    private final boolean isTimestampSetType;
    private final boolean isTimestampMapType;
    private final boolean isIntervalSetType;
    private final boolean isIntervalMapType;
    private final boolean isArrayType;
    private final boolean isDecimalType;

    public AttributeTypesSupportCellEditor(GraphModelProvider graphModelProvider, Class<?> typeClass) {
        super(new JTextField());
        this.graphModelProvider = graphModelProvider;
        this.typeClass = typeClass;
        this.textField = new JTextField();
        this.originalBorder = this.textField.getBorder();
        this.isTimestampSetType = TimestampSet.class.isAssignableFrom(typeClass);
        this.isTimestampMapType = TimestampMap.class.isAssignableFrom(typeClass);
        this.isIntervalSetType = IntervalSet.class.isAssignableFrom(typeClass);
        this.isIntervalMapType = IntervalMap.class.isAssignableFrom(typeClass);
        this.isArrayType = typeClass.isArray();
        this.isDecimalType = typeClass.equals(Double.class) || typeClass.equals(Double.TYPE) || typeClass.equals(Float.class) || typeClass.equals(Float.TYPE);
    }

    @Override
    public boolean stopCellEditing() {
        String value = this.getCellEditorValue().toString();
        if (!value.trim().isEmpty()) {
            try {
                AttributeUtils.parse((String)value, this.typeClass);
            }
            catch (Exception e) {
                this.textField.setBorder(RED_BORDER);
                return false;
            }
        }
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        TimeFormat timeFormat = this.graphModelProvider.getGraphModel().getTimeFormat();
        DateTimeZone timeZone = this.graphModelProvider.getGraphModel().getTimeZone();
        String valueStr = value == null ? "" : (this.isTimestampSetType ? ((TimestampSet)value).toString(timeFormat, timeZone) : (this.isTimestampMapType ? ((TimestampMap)value).toString(timeFormat, timeZone) : (this.isIntervalSetType ? ((IntervalSet)value).toString(timeFormat, timeZone) : (this.isIntervalMapType ? ((IntervalMap)value).toString(timeFormat, timeZone) : (this.isArrayType ? AttributeUtils.printArray((Object)value) : (this.isDecimalType ? DoubleStringConverter.FORMAT.format(value) : AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone)))))));
        this.textField.setBorder(this.originalBorder);
        this.textField.setEditable(true);
        this.textField.setText(valueStr);
        return this.textField;
    }
}

