/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.timeline;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.gephi.timeline.api.TimelineChart;

public class TimelineChartImpl
implements TimelineChart {
    private final String column;
    private final Number[] x;
    private final Number[] y;
    private final Number minY;
    private final Number maxY;
    private final Number minX;
    private final Number maxX;

    public TimelineChartImpl(String column, Number[] x, Number[] y) {
        this.column = column;
        this.x = x;
        this.y = y;
        this.minY = this.calculateMin(y);
        this.maxY = this.calculateMax(y);
        this.minX = this.calculateMin(x);
        this.maxX = this.calculateMax(x);
    }

    @Override
    public Number[] getX() {
        return this.x;
    }

    @Override
    public Number[] getY() {
        return this.y;
    }

    @Override
    public Number getY(Number posX) {
        double pos = posX.doubleValue();
        Double value = null;
        if (pos <= this.maxX.doubleValue()) {
            for (int i = 0; i < this.x.length; ++i) {
                if (pos < this.x[i].doubleValue()) {
                    return value;
                }
                value = this.y[i].doubleValue();
            }
        }
        return value;
    }

    @Override
    public Number getMinY() {
        return this.minY;
    }

    @Override
    public Number getMaxY() {
        return this.maxY;
    }

    @Override
    public Number getMinX() {
        return this.minX;
    }

    @Override
    public Number getMaxX() {
        return this.maxX;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    private Number calculateMin(Number[] yValues) {
        double min = yValues[0].doubleValue();
        for (Number d : yValues) {
            min = Math.min(min, d.doubleValue());
        }
        Number t = yValues[0];
        if (t instanceof Double) {
            return min;
        }
        if (t instanceof Float) {
            return new Float(min);
        }
        if (t instanceof Short) {
            return (short)min;
        }
        if (t instanceof Long) {
            return (long)min;
        }
        if (t instanceof BigInteger) {
            return new BigDecimal(min);
        }
        return min;
    }

    private Number calculateMax(Number[] yValues) {
        double max = yValues[0].doubleValue();
        for (Number d : yValues) {
            max = Math.max(max, d.doubleValue());
        }
        Number t = yValues[0];
        if (t instanceof Double) {
            return max;
        }
        if (t instanceof Float) {
            return new Float(max);
        }
        if (t instanceof Short) {
            return (short)max;
        }
        if (t instanceof Long) {
            return (long)max;
        }
        if (t instanceof BigInteger) {
            return new BigDecimal(max);
        }
        return max;
    }
}

