/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general.ui;

import com.csvreader.CsvReader;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.gephi.datalab.plugin.manipulators.general.ui.ImportCSVUIVisualPanel1;
import org.gephi.datalab.plugin.manipulators.general.ui.ImportCSVUIWizardAction;
import org.gephi.datalab.plugin.manipulators.general.ui.ImportCSVUIWizardPanel2;
import org.gephi.datalab.utils.SupportedColumnTypeWrapper;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ImportCSVUIVisualPanel2
extends JPanel {
    private static final String ASSIGN_NEW_NODES_IDS_SAVED_PREFERENCES = "ImportCSVUIVisualPanel2_assign_new_nodes_ids";
    private static final String CREATE_NEW_NODES_SAVED_PREFERENCES = "ImportCSVUIVisualPanel2_create_new_nodes";
    private final ImportCSVUIWizardPanel2 wizard2;
    private Character separator;
    private File file;
    private ImportCSVUIWizardAction.Mode mode;
    private final ArrayList<JCheckBox> columnsCheckBoxes = new ArrayList();
    private final ArrayList<JComboBox> columnsComboBoxes = new ArrayList();
    private GraphModel graphModel;
    private Table table;
    private Charset charset;
    private JCheckBox assignNewNodeIds;
    private JCheckBox createNewNodes;
    private JScrollPane scroll;

    public ImportCSVUIVisualPanel2(ImportCSVUIWizardPanel2 wizard2) {
        this.initComponents();
        this.wizard2 = wizard2;
    }

    public void unSetup() {
        if (this.assignNewNodeIds != null) {
            NbPreferences.forModule(ImportCSVUIVisualPanel1.class).putBoolean(ASSIGN_NEW_NODES_IDS_SAVED_PREFERENCES, this.assignNewNodeIds.isSelected());
        }
        if (this.createNewNodes != null) {
            NbPreferences.forModule(ImportCSVUIVisualPanel1.class).putBoolean(CREATE_NEW_NODES_SAVED_PREFERENCES, this.createNewNodes.isSelected());
        }
    }

    public void reloadSettings() {
        if (this.separator != null && this.file != null && this.file.exists() && this.mode != null && this.charset != null) {
            JPanel settingsPanel = new JPanel();
            settingsPanel.setLayout((LayoutManager)new MigLayout());
            this.loadDescription(settingsPanel);
            this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
            switch (this.mode) {
                case NODES_TABLE: {
                    this.table = this.graphModel.getNodeTable();
                    this.loadColumns(settingsPanel);
                    this.loadNodesTableSettings(settingsPanel);
                    break;
                }
                case EDGES_TABLE: {
                    this.table = this.graphModel.getEdgeTable();
                    this.loadColumns(settingsPanel);
                    this.loadEdgesTableSettings(settingsPanel);
                }
            }
            this.scroll.setViewportView(settingsPanel);
        }
        this.wizard2.fireChangeEvent();
    }

    private void loadDescription(JPanel settingsPanel) {
        JLabel descriptionLabel = new JLabel();
        switch (this.mode) {
            case NODES_TABLE: {
                descriptionLabel.setText(this.getMessage("ImportCSVUIVisualPanel2.nodes.description"));
                break;
            }
            case EDGES_TABLE: {
                descriptionLabel.setText(this.getMessage("ImportCSVUIVisualPanel2.edges.description"));
            }
        }
        settingsPanel.add((Component)descriptionLabel, "wrap 15px");
    }

    private void loadColumns(JPanel settingsPanel) {
        try {
            this.columnsCheckBoxes.clear();
            this.columnsComboBoxes.clear();
            JLabel columnsLabel = new JLabel(this.getMessage("ImportCSVUIVisualPanel2.columnsLabel.text"));
            settingsPanel.add((Component)columnsLabel, "wrap");
            CsvReader reader = new CsvReader((InputStream)new FileInputStream(this.file), this.separator.charValue(), this.charset);
            reader.setTrimWhitespace(false);
            reader.readHeaders();
            String[] columns = reader.getHeaders();
            reader.close();
            boolean sourceFound = false;
            boolean targetFound = false;
            boolean typeFound = false;
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].isEmpty()) continue;
                JCheckBox columnCheckBox = new JCheckBox(columns[i], true);
                Column column = this.table.getColumn(columns[i]);
                if (column != null) {
                    columnCheckBox.setToolTipText(column.getTitle());
                }
                this.columnsCheckBoxes.add(columnCheckBox);
                settingsPanel.add((Component)columnCheckBox, "wrap");
                JComboBox columnComboBox = new JComboBox();
                this.columnsComboBoxes.add(columnComboBox);
                this.fillComboBoxWithColumnTypes(columns[i], columnComboBox);
                settingsPanel.add(columnComboBox, "wrap 15px");
                if (this.mode == ImportCSVUIWizardAction.Mode.EDGES_TABLE && columns[i].equalsIgnoreCase("source") && !sourceFound) {
                    sourceFound = true;
                    columnCheckBox.setEnabled(false);
                    columnComboBox.setEnabled(false);
                }
                if (this.mode == ImportCSVUIWizardAction.Mode.EDGES_TABLE && columns[i].equalsIgnoreCase("target") && !targetFound) {
                    targetFound = true;
                    columnCheckBox.setEnabled(false);
                    columnComboBox.setEnabled(false);
                }
                if (this.mode != ImportCSVUIWizardAction.Mode.EDGES_TABLE || !columns[i].equalsIgnoreCase("type") || typeFound) continue;
                typeFound = true;
                columnComboBox.setEnabled(false);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void fillComboBoxWithColumnTypes(String column, JComboBox comboBox) {
        comboBox.removeAllItems();
        List supportedTypesWrappers = SupportedColumnTypeWrapper.buildOrderedSupportedTypesList((GraphModel)this.graphModel);
        for (SupportedColumnTypeWrapper supportedColumnTypeWrapper : supportedTypesWrappers) {
            comboBox.addItem(supportedColumnTypeWrapper);
        }
        if (this.table.hasColumn(column)) {
            comboBox.setSelectedItem(new SupportedColumnTypeWrapper(this.table.getColumn(column).getTypeClass()));
            comboBox.setEnabled(false);
        } else {
            comboBox.setSelectedItem(new SupportedColumnTypeWrapper(String.class));
        }
    }

    private void loadNodesTableSettings(JPanel settingsPanel) {
        this.assignNewNodeIds = new JCheckBox(this.getMessage("ImportCSVUIVisualPanel2.nodes.assign-ids-checkbox"), NbPreferences.forModule(ImportCSVUIVisualPanel1.class).getBoolean(ASSIGN_NEW_NODES_IDS_SAVED_PREFERENCES, false));
        settingsPanel.add((Component)this.assignNewNodeIds, "wrap");
    }

    private void loadEdgesTableSettings(JPanel settingsPanel) {
        this.createNewNodes = new JCheckBox(this.getMessage("ImportCSVUIVisualPanel2.edges.create-new-nodes-checkbox"), NbPreferences.forModule(ImportCSVUIVisualPanel1.class).getBoolean(CREATE_NEW_NODES_SAVED_PREFERENCES, true));
        settingsPanel.add((Component)this.createNewNodes, "wrap");
    }

    public boolean isValidCSV() {
        return true;
    }

    public String[] getColumnsToImport() {
        ArrayList<String> columns = new ArrayList<String>();
        for (JCheckBox columnCheckBox : this.columnsCheckBoxes) {
            if (!columnCheckBox.isSelected()) continue;
            columns.add(columnCheckBox.getText());
        }
        return columns.toArray(new String[0]);
    }

    public Class[] getColumnsToImportTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        for (int i = 0; i < this.columnsCheckBoxes.size(); ++i) {
            if (!this.columnsCheckBoxes.get(i).isSelected()) continue;
            SupportedColumnTypeWrapper selected = (SupportedColumnTypeWrapper)this.columnsComboBoxes.get(i).getSelectedItem();
            types.add(selected.getType());
        }
        return types.toArray(new Class[0]);
    }

    public boolean getAssignNewNodeIds() {
        return this.assignNewNodeIds != null ? this.assignNewNodeIds.isSelected() : false;
    }

    public boolean getCreateNewNodes() {
        return this.createNewNodes != null ? this.createNewNodes.isSelected() : false;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ImportCSVUIVisualPanel2.class, (String)"ImportCSVUIVisualPanel2.name");
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public ImportCSVUIWizardAction.Mode getMode() {
        return this.mode;
    }

    public void setMode(ImportCSVUIWizardAction.Mode mode) {
        this.mode = mode;
    }

    public Character getSeparator() {
        return this.separator;
    }

    public void setSeparator(Character separator) {
        this.separator = separator;
    }

    public Charset getCharset() {
        return this.charset;
    }

    void setCharset(Charset charset) {
        this.charset = charset;
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(ImportCSVUIVisualPanel2.class, (String)resName);
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 290, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 320, Short.MAX_VALUE));
    }
}

