/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.splineeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.gephi.ui.components.splineeditor.Java2dHelper;
import org.gephi.ui.components.splineeditor.equation.EquationDisplay;

public class SplineDisplay
extends EquationDisplay {
    private static final double CONTROL_POINT_SIZE = 12.0;
    private Point2D control1 = new Point2D.Double(0.0, 0.0);
    private Point2D control2 = new Point2D.Double(1.0, 1.0);
    private Point2D selected = null;
    private Point dragStart = null;
    private boolean isSaving = false;
    private PropertyChangeSupport support;

    SplineDisplay() {
        super(0.0, 0.0, -0.1, 1.1, -0.1, 1.1, 0.2, 6, 0.2, 6);
        this.setEnabled(false);
        this.addMouseMotionListener(new ControlPointsHandler());
        this.addMouseListener(new SelectionHandler());
        this.support = new PropertyChangeSupport(this);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    public Point2D getControl1() {
        return (Point2D)this.control1.clone();
    }

    public Point2D getControl2() {
        return (Point2D)this.control2.clone();
    }

    public void setControl1(Point2D control1) {
        this.support.firePropertyChange("control1", this.control1.clone(), control1.clone());
        this.control1 = (Point2D)control1.clone();
        this.repaint();
    }

    public void setControl2(Point2D control2) {
        this.support.firePropertyChange("control2", this.control2.clone(), control2.clone());
        this.control2 = (Point2D)control2.clone();
        this.repaint();
    }

    synchronized void saveAsTemplate(OutputStream out) {
        BufferedImage image = Java2dHelper.createCompatibleImage(this.getWidth(), this.getHeight());
        Graphics g = image.getGraphics();
        this.isSaving = true;
        this.setDrawText(false);
        this.paint(g);
        this.setDrawText(true);
        this.isSaving = false;
        g.dispose();
        BufferedImage subImage = image.getSubimage((int)this.xPositionToPixel(0.0), (int)this.yPositionToPixel(1.0), (int)(this.xPositionToPixel(1.0) - this.xPositionToPixel(0.0)) + 1, (int)(this.yPositionToPixel(0.0) - this.yPositionToPixel(1.0)) + 1);
        try {
            ImageIO.write((RenderedImage)subImage, "PNG", out);
        }
        catch (IOException e) {
            // empty catch block
        }
        image.flush();
        subImage = null;
        image = null;
    }

    @Override
    protected void paintInformation(Graphics2D g2) {
        if (!this.isSaving) {
            this.paintControlPoints(g2);
        }
        this.paintSpline(g2);
    }

    private void paintControlPoints(Graphics2D g2) {
        this.paintControlPoint(g2, this.control1);
        this.paintControlPoint(g2, this.control2);
    }

    private void paintControlPoint(Graphics2D g2, Point2D control) {
        double origin_x = this.xPositionToPixel(control.getX());
        double origin_y = this.yPositionToPixel(control.getY());
        double pos = control == this.control1 ? 0.0 : 1.0;
        Ellipse2D outer = this.getDraggableArea(control);
        Ellipse2D.Double inner = new Ellipse2D.Double(origin_x + 2.0 - 6.0, origin_y + 2.0 - 6.0, 8.0, 8.0);
        Area circle = new Area(outer);
        circle.subtract(new Area(inner));
        Stroke stroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{5.0f, 5.0f}, 0.0f));
        g2.setColor(new Color(1.0f, 0.0f, 0.0f, 0.4f));
        g2.drawLine(0, (int)origin_y, (int)origin_x, (int)origin_y);
        g2.drawLine((int)origin_x, (int)origin_y, (int)origin_x, this.getHeight());
        g2.setStroke(stroke);
        if (this.selected == control) {
            g2.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        } else {
            g2.setColor(new Color(0.8f, 0.8f, 0.8f, 0.6f));
        }
        g2.fill(inner);
        g2.setColor(new Color(0.0f, 0.0f, 0.5f, 0.5f));
        g2.fill(circle);
        g2.drawLine((int)origin_x, (int)origin_y, (int)this.xPositionToPixel(pos), (int)this.yPositionToPixel(pos));
    }

    private Ellipse2D getDraggableArea(Point2D control) {
        Ellipse2D.Double outer = new Ellipse2D.Double(this.xPositionToPixel(control.getX()) - 6.0, this.yPositionToPixel(control.getY()) - 6.0, 12.0, 12.0);
        return outer;
    }

    private void paintSpline(Graphics2D g2) {
        CubicCurve2D.Double spline = new CubicCurve2D.Double(this.xPositionToPixel(0.0), this.yPositionToPixel(0.0), this.xPositionToPixel(this.control1.getX()), this.yPositionToPixel(this.control1.getY()), this.xPositionToPixel(this.control2.getX()), this.yPositionToPixel(this.control2.getY()), this.xPositionToPixel(1.0), this.yPositionToPixel(1.0));
        g2.setColor(new Color(0.0f, 0.3f, 0.0f, 1.0f));
        g2.draw(spline);
    }

    private void resetSelection() {
        Point2D oldSelected = this.selected;
        this.selected = null;
        if (oldSelected != null) {
            Rectangle bounds = this.getDraggableArea(oldSelected).getBounds();
            this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    private class SelectionHandler
    extends MouseAdapter {
        private SelectionHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Ellipse2D area1 = SplineDisplay.this.getDraggableArea(SplineDisplay.this.control1);
            Ellipse2D area2 = SplineDisplay.this.getDraggableArea(SplineDisplay.this.control2);
            if (area1.contains(e.getPoint())) {
                SplineDisplay.this.selected = SplineDisplay.this.control1;
                SplineDisplay.this.dragStart = e.getPoint();
                Rectangle bounds = area1.getBounds();
                SplineDisplay.this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            } else if (area2.contains(e.getPoint())) {
                SplineDisplay.this.selected = SplineDisplay.this.control2;
                SplineDisplay.this.dragStart = e.getPoint();
                Rectangle bounds = area2.getBounds();
                SplineDisplay.this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            } else {
                SplineDisplay.this.resetSelection();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SplineDisplay.this.resetSelection();
        }
    }

    private class ControlPointsHandler
    extends MouseMotionAdapter {
        private ControlPointsHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Ellipse2D area1 = SplineDisplay.this.getDraggableArea(SplineDisplay.this.control1);
            Ellipse2D area2 = SplineDisplay.this.getDraggableArea(SplineDisplay.this.control2);
            if (area1.contains(e.getPoint()) || area2.contains(e.getPoint())) {
                SplineDisplay.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                SplineDisplay.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SplineDisplay.this.selected == null) {
                return;
            }
            Point dragEnd = e.getPoint();
            double distance = SplineDisplay.this.xPixelToPosition(dragEnd.getX()) - SplineDisplay.this.xPixelToPosition(SplineDisplay.this.dragStart.getX());
            double x = SplineDisplay.this.selected.getX() + distance;
            if (x < 0.0) {
                x = 0.0;
            } else if (x > 1.0) {
                x = 1.0;
            }
            distance = SplineDisplay.this.yPixelToPosition(dragEnd.getY()) - SplineDisplay.this.yPixelToPosition(SplineDisplay.this.dragStart.getY());
            double y = SplineDisplay.this.selected.getY() + distance;
            if (y < 0.0) {
                y = 0.0;
            } else if (y > 1.0) {
                y = 1.0;
            }
            Point2D selectedCopy = (Point2D)SplineDisplay.this.selected.clone();
            SplineDisplay.this.selected.setLocation(x, y);
            SplineDisplay.this.support.firePropertyChange("control" + (SplineDisplay.this.selected == SplineDisplay.this.control1 ? "1" : "2"), selectedCopy, SplineDisplay.this.selected.clone());
            SplineDisplay.this.repaint();
            double xPos = SplineDisplay.this.xPixelToPosition(dragEnd.getX());
            double yPos = -SplineDisplay.this.yPixelToPosition(dragEnd.getY());
            if (xPos >= 0.0 && xPos <= 1.0) {
                SplineDisplay.this.dragStart.setLocation(dragEnd.getX(), SplineDisplay.this.dragStart.getY());
            }
            if (yPos >= 0.0 && yPos <= 1.0) {
                SplineDisplay.this.dragStart.setLocation(SplineDisplay.this.dragStart.getX(), dragEnd.getY());
            }
        }
    }
}

