/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gephi.io.importer.plugin.file.ImporterVNA;
import org.gephi.io.importer.spi.Importer;
import org.gephi.io.importer.spi.ImporterUI;
import org.openide.util.NbBundle;

public class ImporterVnaUI
implements ImporterUI {
    private ImporterVNA[] importers;
    private JComboBox comboBox;
    private JTextField textField;
    private JLabel messageLabel;
    private JPanel panel;
    private final String MESSAGE_LINEAR = NbBundle.getMessage(this.getClass(), (String)"ImporterVnaUI.message.linear");
    private final String MESSAGE_SQUARE_ROOT = NbBundle.getMessage(this.getClass(), (String)"ImporterVnaUI.message.square_root");
    private final String MESSAGE_LOGARITHMIC = NbBundle.getMessage(this.getClass(), (String)"ImporterVnaUI.message.logarithmic");

    public void setup(Importer[] importers) {
        this.importers = (ImporterVNA[])importers;
    }

    public JPanel getPanel() {
        this.panel = new JPanel(new GridBagLayout());
        this.comboBox = new JComboBox<ImporterVNA.EdgeWidthFunction.Function>(ImporterVNA.EdgeWidthFunction.Function.values());
        this.textField = new JTextField("1", 5);
        this.messageLabel = new JLabel(this.MESSAGE_LINEAR);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImporterVnaUI.this.comboBoxSelectionChanged(e);
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.panel.add((Component)this.comboBox, constraints);
        constraints.gridx = 1;
        this.panel.add((Component)this.textField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        this.panel.add((Component)this.messageLabel, constraints);
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.fill = 3;
        this.panel.add(new JPanel());
        this.panel.setPreferredSize(new Dimension(350, 100));
        this.panel.setSize(new Dimension(350, 100));
        return this.panel;
    }

    private void comboBoxSelectionChanged(ActionEvent e) {
        switch ((ImporterVNA.EdgeWidthFunction.Function)this.comboBox.getSelectedItem()) {
            case LINEAR: {
                this.messageLabel.setText(this.MESSAGE_LINEAR);
                this.textField.setEditable(true);
                break;
            }
            case LOGARITHMIC: {
                this.messageLabel.setText(this.MESSAGE_LOGARITHMIC);
                this.textField.setEditable(false);
                break;
            }
            case SQUARE_ROOT: {
                this.messageLabel.setText(this.MESSAGE_SQUARE_ROOT);
                this.textField.setEditable(false);
            }
        }
    }

    public void unsetup(boolean update) {
        if (update) {
            float coefficient = 1.0f;
            if (((ImporterVNA.EdgeWidthFunction.Function)this.comboBox.getSelectedItem()).equals((Object)ImporterVNA.EdgeWidthFunction.Function.LINEAR)) {
                try {
                    coefficient = Float.parseFloat(this.textField.getText());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            for (ImporterVNA importer : this.importers) {
                importer.setEdgeWidthFunction(new ImporterVNA.EdgeWidthFunction((ImporterVNA.EdgeWidthFunction.Function)this.comboBox.getSelectedItem(), coefficient));
            }
        }
        this.panel = null;
        this.importers = null;
        this.textField = null;
        this.messageLabel = null;
        this.comboBox = null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"ImporterVnaUI.displayName");
    }

    public boolean isUIForImporter(Importer importer) {
        return importer instanceof ImporterVNA;
    }
}

