/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.RangeStats;
import tim.prune.data.Selection;
import tim.prune.data.Unit;
import tim.prune.gui.DisplayUtils;
import tim.prune.gui.profile.SpeedData;

public class FullRangeDetails
extends GenericFunction {
    private JDialog _dialog = null;
    private JLabel _numPointsLabel = null;
    private JLabel _numSegsLabel = null;
    private JLabel _maxSpeedLabel = null;
    private JLabel _colTotalLabel = null;
    private JLabel _colSegmentsLabel = null;
    private JLabel _totalDistanceLabel = null;
    private JLabel _movingDistanceLabel = null;
    private JLabel _totalDurationLabel = null;
    private JLabel _movingDurationLabel = null;
    private JLabel _totalClimbLabel = null;
    private JLabel _movingClimbLabel = null;
    private JLabel _totalDescentLabel = null;
    private JLabel _movingDescentLabel = null;
    private JLabel _totalPaceLabel = null;
    private JLabel _movingPaceLabel = null;
    private JLabel _totalGradientLabel = null;
    private JLabel _movingGradientLabel = null;
    private JLabel _totalSpeedLabel;
    private JLabel _movingSpeedLabel = null;
    private JLabel _totalVertSpeedLabel;
    private JLabel _movingVertSpeedLabel = null;

    public FullRangeDetails(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.fullrangedetails";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.updateDetails();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.fullrangedetails.intro")) + ":");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 3, 6, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("details.track.points")) + ": ");
        jLabel2.setHorizontalAlignment(4);
        jPanel2.add(jLabel2);
        this._numPointsLabel = new JLabel("100");
        jPanel2.add(this._numPointsLabel);
        jPanel2.add(new JLabel(" "));
        JLabel jLabel3 = new JLabel(String.valueOf(I18nManager.getText("details.range.numsegments")) + ": ");
        jLabel3.setHorizontalAlignment(4);
        jPanel2.add(jLabel3);
        this._numSegsLabel = new JLabel("100");
        jPanel2.add(this._numSegsLabel);
        jPanel2.add(new JLabel(" "));
        JLabel jLabel4 = new JLabel(String.valueOf(I18nManager.getText("details.range.maxspeed")) + ": ");
        jLabel4.setHorizontalAlignment(4);
        jPanel2.add(jLabel4);
        this._maxSpeedLabel = new JLabel("10 km/h");
        jPanel2.add(this._maxSpeedLabel);
        jPanel2.add(new JLabel(" "));
        int n = 0;
        while (n < 3) {
            jPanel2.add(new JLabel(" "));
            ++n;
        }
        jPanel2.add(new JLabel(" "));
        this._colTotalLabel = new JLabel(I18nManager.getText("dialog.fullrangedetails.coltotal"));
        jPanel2.add(this._colTotalLabel);
        this._colSegmentsLabel = new JLabel(I18nManager.getText("dialog.fullrangedetails.colsegments"));
        jPanel2.add(this._colSegmentsLabel);
        JLabel jLabel5 = new JLabel(String.valueOf(I18nManager.getText("fieldname.distance")) + ": ");
        jLabel5.setHorizontalAlignment(4);
        jPanel2.add(jLabel5);
        this._totalDistanceLabel = new JLabel("5 km");
        jPanel2.add(this._totalDistanceLabel);
        this._movingDistanceLabel = new JLabel("5 km");
        jPanel2.add(this._movingDistanceLabel);
        JLabel jLabel6 = new JLabel(String.valueOf(I18nManager.getText("fieldname.duration")) + ": ");
        jLabel6.setHorizontalAlignment(4);
        jPanel2.add(jLabel6);
        this._totalDurationLabel = new JLabel("15 min");
        jPanel2.add(this._totalDurationLabel);
        this._movingDurationLabel = new JLabel("15 min");
        jPanel2.add(this._movingDurationLabel);
        JLabel jLabel7 = new JLabel(String.valueOf(I18nManager.getText("details.range.avespeed")) + ": ");
        jLabel7.setHorizontalAlignment(4);
        jPanel2.add(jLabel7);
        this._totalSpeedLabel = new JLabel("5.5 km/h");
        jPanel2.add(this._totalSpeedLabel);
        this._movingSpeedLabel = new JLabel("5.5 km/h");
        jPanel2.add(this._movingSpeedLabel);
        JLabel jLabel8 = new JLabel(String.valueOf(I18nManager.getText("details.range.pace")) + ": ");
        jLabel8.setHorizontalAlignment(4);
        jPanel2.add(jLabel8);
        this._totalPaceLabel = new JLabel("8 min/km");
        jPanel2.add(this._totalPaceLabel);
        this._movingPaceLabel = new JLabel("8 min/km");
        jPanel2.add(this._movingPaceLabel);
        JLabel jLabel9 = new JLabel(String.valueOf(I18nManager.getText("details.range.climb")) + ": ");
        jLabel9.setHorizontalAlignment(4);
        jPanel2.add(jLabel9);
        this._totalClimbLabel = new JLabel("1000 m");
        jPanel2.add(this._totalClimbLabel);
        this._movingClimbLabel = new JLabel("1000 m");
        jPanel2.add(this._movingClimbLabel);
        JLabel jLabel10 = new JLabel(String.valueOf(I18nManager.getText("details.range.descent")) + ": ");
        jLabel10.setHorizontalAlignment(4);
        jPanel2.add(jLabel10);
        this._totalDescentLabel = new JLabel("1000 m");
        jPanel2.add(this._totalDescentLabel);
        this._movingDescentLabel = new JLabel("1000 m");
        jPanel2.add(this._movingDescentLabel);
        JLabel jLabel11 = new JLabel(String.valueOf(I18nManager.getText("details.range.gradient")) + ": ");
        jLabel11.setHorizontalAlignment(4);
        jPanel2.add(jLabel11);
        this._totalGradientLabel = new JLabel("10 %");
        jPanel2.add(this._totalGradientLabel);
        this._movingGradientLabel = new JLabel("10 %");
        jPanel2.add(this._movingGradientLabel);
        JLabel jLabel12 = new JLabel(String.valueOf(I18nManager.getText("fieldname.verticalspeed")) + ": ");
        jLabel12.setHorizontalAlignment(4);
        jPanel2.add(jLabel12);
        this._totalVertSpeedLabel = new JLabel("1 m/s");
        jPanel2.add(this._totalVertSpeedLabel);
        this._movingVertSpeedLabel = new JLabel("1 m/s");
        jPanel2.add(this._movingVertSpeedLabel);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FullRangeDetails.this._dialog.dispose();
            }
        });
        jButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    FullRangeDetails.this._dialog.dispose();
                }
                super.keyPressed(keyEvent);
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void updateDetails() {
        Selection selection = this._app.getTrackInfo().getSelection();
        RangeStats rangeStats = new RangeStats(this._app.getTrackInfo().getTrack(), selection.getStart(), selection.getEnd());
        this._numPointsLabel.setText("" + rangeStats.getNumPoints());
        this._numSegsLabel.setText("" + rangeStats.getNumSegments());
        boolean bl = rangeStats.getNumSegments() > 1;
        this._movingDistanceLabel.setVisible(bl);
        this._movingDurationLabel.setVisible(bl || rangeStats.getTimestampsOutOfSequence());
        this._movingClimbLabel.setVisible(bl);
        this._movingDescentLabel.setVisible(bl);
        this._movingSpeedLabel.setVisible(bl);
        this._movingPaceLabel.setVisible(bl);
        this._movingGradientLabel.setVisible(bl);
        this._movingVertSpeedLabel.setVisible(bl);
        Unit unit = Config.getUnitSet().getDistanceUnit();
        String string = I18nManager.getText(unit.getShortnameKey());
        this._totalDistanceLabel.setText(String.valueOf(DisplayUtils.roundedNumber(rangeStats.getTotalDistance())) + " " + string);
        this._movingDistanceLabel.setText(String.valueOf(DisplayUtils.roundedNumber(rangeStats.getMovingDistance())) + " " + string);
        this._totalDurationLabel.setText(DisplayUtils.buildDurationString(rangeStats.getTotalDurationInSeconds()));
        this._movingDurationLabel.setText(DisplayUtils.buildDurationString(rangeStats.getMovingDurationInSeconds()));
        Unit unit2 = Config.getUnitSet().getAltitudeUnit();
        String string2 = " " + I18nManager.getText(unit2.getShortnameKey());
        if (rangeStats.getTotalAltitudeRange().hasRange()) {
            this._totalClimbLabel.setText(String.valueOf(rangeStats.getTotalAltitudeRange().getClimb(unit2)) + string2);
            this._totalDescentLabel.setText(String.valueOf(rangeStats.getTotalAltitudeRange().getDescent(unit2)) + string2);
        } else {
            this._totalClimbLabel.setText("");
            this._totalDescentLabel.setText("");
        }
        if (rangeStats.getMovingAltitudeRange().hasRange()) {
            this._movingClimbLabel.setText(String.valueOf(rangeStats.getMovingAltitudeRange().getClimb(unit2)) + string2);
            this._movingDescentLabel.setText(String.valueOf(rangeStats.getMovingAltitudeRange().getDescent(unit2)) + string2);
        } else {
            this._movingClimbLabel.setText("");
            this._movingDescentLabel.setText("");
        }
        String string3 = I18nManager.getText(Config.getUnitSet().getSpeedUnit().getShortnameKey());
        long l = rangeStats.getTotalDurationInSeconds();
        double d = rangeStats.getTotalDistance();
        if (l > 0L && d > 0.0) {
            this._totalSpeedLabel.setText(String.valueOf(DisplayUtils.roundedNumber(d / (double)l * 3600.0)) + " " + string3);
            this._totalPaceLabel.setText(String.valueOf(DisplayUtils.buildDurationString((long)((double)l / d))) + " / " + string);
        } else {
            this._totalSpeedLabel.setText("");
            this._totalPaceLabel.setText("");
        }
        l = rangeStats.getMovingDurationInSeconds();
        d = rangeStats.getMovingDistance();
        if (l > 0L && d > 0.0) {
            this._movingSpeedLabel.setText(String.valueOf(DisplayUtils.roundedNumber(d / (double)l * 3600.0)) + " " + string3);
            this._movingPaceLabel.setText(String.valueOf(DisplayUtils.buildDurationString((long)((double)l / d))) + " / " + string);
        } else {
            this._movingSpeedLabel.setText("");
            this._movingPaceLabel.setText("");
        }
        if (rangeStats.getTotalAltitudeRange().hasRange()) {
            this._totalGradientLabel.setText(String.valueOf(DisplayUtils.formatOneDp(rangeStats.getTotalGradient())) + " %");
        } else {
            this._totalGradientLabel.setText("");
        }
        if (rangeStats.getMovingAltitudeRange().hasRange()) {
            this._movingGradientLabel.setText(String.valueOf(DisplayUtils.formatOneDp(rangeStats.getMovingGradient())) + " %");
        } else {
            this._movingGradientLabel.setText("");
        }
        SpeedData speedData = new SpeedData(this._app.getTrackInfo().getTrack());
        speedData.init(Config.getUnitSet());
        double d2 = 0.0;
        int n = selection.getStart();
        while (n <= selection.getEnd()) {
            if (speedData.hasData(n) && speedData.getData(n) > d2) {
                d2 = speedData.getData(n);
            }
            ++n;
        }
        if (d2 > 0.0) {
            this._maxSpeedLabel.setText(String.valueOf(DisplayUtils.roundedNumber(d2)) + " " + string3);
        } else {
            this._maxSpeedLabel.setText("");
        }
        String string4 = I18nManager.getText(Config.getUnitSet().getVerticalSpeedUnit().getShortnameKey());
        if (rangeStats.getMovingAltitudeRange().hasRange() && rangeStats.getTotalDurationInSeconds() > 0L) {
            this._totalVertSpeedLabel.setText(String.valueOf(DisplayUtils.roundedNumber(rangeStats.getTotalVerticalSpeed())) + " " + string4);
            this._movingVertSpeedLabel.setText(String.valueOf(DisplayUtils.roundedNumber(rangeStats.getMovingVerticalSpeed())) + " " + string4);
        } else {
            this._totalVertSpeedLabel.setText("");
            this._movingVertSpeedLabel.setText("");
        }
    }
}

