/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.util.FastField;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SerializationMethodInvoker
implements Caching {
    private static final Method NO_METHOD = new Object(){

        private void noMethod() {
        }
    }.getClass().getDeclaredMethods()[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final FastField[] OBJECT_TYPE_FIELDS = new FastField[]{new FastField(Object.class, "readResolve"), new FastField(Object.class, "writeReplace"), new FastField(Object.class, "readObject"), new FastField(Object.class, "writeObject")};
    private Map cache = Collections.synchronizedMap(new HashMap());

    public SerializationMethodInvoker() {
        for (int i = 0; i < OBJECT_TYPE_FIELDS.length; ++i) {
            this.cache.put(OBJECT_TYPE_FIELDS[i], NO_METHOD);
        }
    }

    public Object callReadResolve(Object result) {
        if (result == null) {
            return null;
        }
        Method readResolveMethod = this.getMethod(result.getClass(), "readResolve", null, true);
        if (readResolveMethod != null) {
            try {
                return readResolveMethod.invoke(result, EMPTY_ARGS);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Could not call " + result.getClass().getName() + ".readResolve()", e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectAccessException("Could not call " + result.getClass().getName() + ".readResolve()", e.getTargetException());
            }
        }
        return result;
    }

    public Object callWriteReplace(Object object) {
        if (object == null) {
            return null;
        }
        Method writeReplaceMethod = this.getMethod(object.getClass(), "writeReplace", null, true);
        if (writeReplaceMethod != null) {
            try {
                return writeReplaceMethod.invoke(object, EMPTY_ARGS);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Could not call " + object.getClass().getName() + ".writeReplace()", e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectAccessException("Could not call " + object.getClass().getName() + ".writeReplace()", e.getTargetException());
            }
        }
        return object;
    }

    public boolean supportsReadObject(Class type, boolean includeBaseClasses) {
        return this.getMethod(type, "readObject", new Class[]{ObjectInputStream.class}, includeBaseClasses) != null;
    }

    public void callReadObject(Class type, Object object, ObjectInputStream stream) {
        try {
            Method readObjectMethod = this.getMethod(type, "readObject", new Class[]{ObjectInputStream.class}, false);
            readObjectMethod.invoke(object, stream);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Could not call " + object.getClass().getName() + ".readObject()", e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException("Could not call " + object.getClass().getName() + ".readObject()", e.getTargetException());
        }
    }

    public boolean supportsWriteObject(Class type, boolean includeBaseClasses) {
        return this.getMethod(type, "writeObject", new Class[]{ObjectOutputStream.class}, includeBaseClasses) != null;
    }

    public void callWriteObject(Class type, Object instance, ObjectOutputStream stream) {
        try {
            Method readObjectMethod = this.getMethod(type, "writeObject", new Class[]{ObjectOutputStream.class}, false);
            readObjectMethod.invoke(instance, stream);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Could not call " + instance.getClass().getName() + ".writeObject()", e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException("Could not call " + instance.getClass().getName() + ".writeObject()", e.getTargetException());
        }
    }

    private Method getMethod(Class type, String name, Class[] parameterTypes, boolean includeBaseclasses) {
        Method method = this.getMethod(type, name, parameterTypes);
        return method == NO_METHOD || !includeBaseclasses && !method.getDeclaringClass().equals(type) ? null : method;
    }

    private Method getMethod(Class type, String name, Class[] parameterTypes) {
        if (type == null) {
            return null;
        }
        FastField method = new FastField(type, name);
        Method result = (Method)this.cache.get(method);
        if (result == null) {
            try {
                result = type.getDeclaredMethod(name, parameterTypes);
                if (!result.isAccessible()) {
                    result.setAccessible(true);
                }
            }
            catch (NoSuchMethodException e) {
                result = this.getMethod(type.getSuperclass(), name, parameterTypes);
            }
            this.cache.put(method, result);
        }
        return result;
    }

    public void flushCache() {
        this.cache.keySet().retainAll(Arrays.asList(OBJECT_TYPE_FIELDS));
    }
}

