#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc-citeproc
version: 0.10.5.1
id: pandoc-citeproc-0.10.5.1-8ahNrpDC1d8J2S23MZEXZv
key: pandoc-citeproc-0.10.5.1-8ahNrpDC1d8J2S23MZEXZv
license: BSD3
maintainer: jgm@berkeley.edu
homepage: https://github.com/jgm/pandoc-citeproc
synopsis: Supports using pandoc with citeproc
description:
    The pandoc-citeproc library exports functions for
    using the citeproc system with pandoc.  It relies on
    citeproc-hs, a library for rendering
    bibliographic reference citations into a variety
    of styles using a macro language called Citation
    Style Language (CSL). More details on CSL can be
    found here: <http://citationstyles.org/>.
    .
    Currently this package includes a heavily revised
    copy of the citeproc-hs code. When citeproc-hs is
    updated to be compatible, this package will simply
    depend on citeproc-hs.
    .
    This package also contains an executable: pandoc-citeproc,
    which works as a pandoc filter, and
    also has a mode for converting bibliographic databases
    a YAML format suitable for inclusion in pandoc YAML
    metadata.
category: Text
author: John MacFarlane, Andrea Rossato
exposed: True
exposed-modules:
    Text.CSL.Pandoc Text.CSL Text.CSL.Reference Text.CSL.Style
    Text.CSL.Eval Text.CSL.Eval.Common Text.CSL.Eval.Date
    Text.CSL.Eval.Names Text.CSL.Eval.Output Text.CSL.Parser
    Text.CSL.Proc Text.CSL.Proc.Collapse Text.CSL.Proc.Disamb
    Text.CSL.Input.Bibutils Text.CSL.Input.Bibtex
    Text.CSL.Output.Pandoc Text.CSL.Output.Plain Text.CSL.Data
hidden-modules: Text.CSL.Util Prelude Paths_pandoc_citeproc
                Text.CSL.Compat.Pandoc
abi: 35c65e555c3a332cf4255e81507aede4
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/pandoc-citeproc-0.10.5.1
library-dirs: /usr/lib/ghc-8.0.2/site-local/pandoc-citeproc-0.10.5.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc-citeproc
hs-libraries: HSpandoc-citeproc-0.10.5.1-8ahNrpDC1d8J2S23MZEXZv
depends:
    aeson-1.2.1.0-LtwtJj4trOg6E4DiroefXf base-4.9.1.0
    bytestring-0.10.8.1 containers-0.5.7.1
    data-default-0.7.1.1-BNa3MzH41nV77yjS9K2Umq directory-1.3.0.0
    filepath-1.4.1.1 hs-bibutils-5.5-5H3O5Ryo9nP1kgdDnakEQ2
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    old-locale-1.0.0.7-KGBP1BSKxH5GCm0LnZP04j
    pandoc-1.19.2.1-ZuCGUREFWXFP7jOsWsHNL
    pandoc-types-1.17.0.5-Ib0hSG6lz3sKb2F5FwlV4S
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR
    setenv-0.1.1.3-8dEhk6JWvlmCmVyBammSpu
    split-0.2.3.2-CJl40zTyCIV16Pr60nb7CT syb-0.7-4OKdCpwGutyB1rNRmoa0ya
    tagsoup-0.14.1-A8v7iyBjfz82GOKyhT5ypk
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq
    text-icu-0.7.0.1-2iO6CBW0o3uBRiqo4I3C9q time-1.6.0.1
    unordered-containers-0.2.8.0-1tqMF698WJE3INvmpuzQZc
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
    xml-conduit-1.5.1-8Ene7jQbE5YDKtAYnsRLqh
    yaml-0.8.23.3-3BbiUBqxe192HmKg4jbbCV
haddock-interfaces: /usr/share/doc/pandoc-citeproc/html/pandoc-citeproc.haddock
haddock-html: /usr/share/doc/pandoc-citeproc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
