/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.geom.PerspectiveCameraImpl;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.scene.Camera;

public class PerspectiveCamera
extends Camera {
    private DoubleProperty fieldOfView;

    public final void setFieldOfView(double d) {
        this.fieldOfViewProperty().set(d);
    }

    public final double getFieldOfView() {
        return this.fieldOfView == null ? 30.0 : this.fieldOfView.get();
    }

    public final DoubleProperty fieldOfViewProperty() {
        if (this.fieldOfView == null) {
            this.fieldOfView = new DoublePropertyBase(30.0){

                @Override
                protected void invalidated() {
                    PerspectiveCamera.this.markDirty();
                }

                @Override
                public Object getBean() {
                    return PerspectiveCamera.this;
                }

                @Override
                public String getName() {
                    return "fieldOfView";
                }
            };
        }
        return this.fieldOfView;
    }

    public PerspectiveCamera() {
        this.markDirty();
    }

    @Override
    CameraImpl createPlatformCamera() {
        return Toolkit.getToolkit().createPerspectiveCamera();
    }

    @Override
    void update() {
        if (this.isDirty()) {
            PerspectiveCameraImpl perspectiveCameraImpl = (PerspectiveCameraImpl)this.getPlatformCamera();
            perspectiveCameraImpl.setFieldOfView((float)this.getFieldOfView());
            this.clearDirty();
        }
    }

    @Override
    Camera copy() {
        PerspectiveCamera perspectiveCamera = new PerspectiveCamera();
        perspectiveCamera.setFieldOfView(this.getFieldOfView());
        return perspectiveCamera;
    }
}

