/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import net.sf.json.JSONObject;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;

public class AntiCsrfAPI
extends ApiImplementor {
    private static final String PREFIX = "acsrf";
    private static final String OTHER_GENERATE_FORM = "genForm";
    private static final String OTHER_GENERATE_FORM_PARAM_HREFID = "hrefId";
    private ExtensionAntiCSRF extension = null;

    public AntiCsrfAPI(ExtensionAntiCSRF extensionAntiCSRF) {
        this.extension = extensionAntiCSRF;
        this.addApiOthers(new ApiOther(OTHER_GENERATE_FORM, new String[]{OTHER_GENERATE_FORM_PARAM_HREFID}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    public static String getAntiCsrfFormUrl(int n) {
        return API.getInstance().getBaseURL(API.Format.OTHER, PREFIX, API.RequestType.other, OTHER_GENERATE_FORM, false) + OTHER_GENERATE_FORM_PARAM_HREFID + "=" + n;
    }

    @Override
    public HttpMessage handleApiOther(HttpMessage httpMessage, String string, JSONObject jSONObject) throws ApiException {
        if (OTHER_GENERATE_FORM.equals(string)) {
            String string2 = jSONObject.getString(OTHER_GENERATE_FORM_PARAM_HREFID);
            if (string2 == null || string2.length() == 0) {
                throw new ApiException(ApiException.Type.MISSING_PARAMETER, OTHER_GENERATE_FORM_PARAM_HREFID);
            }
            try {
                int n = Integer.parseInt(string2);
                String string3 = this.extension.generateForm(n);
                if (string3 == null) {
                    throw new ApiException(ApiException.Type.HREF_NOT_FOUND, string2);
                }
                ExtensionHistory extensionHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
                String string4 = extensionHistory.getHistoryReference(n).getHttpMessage().getResponseHeader().getCharset();
                string4 = string4 == null || string4.length() == 0 ? "" : " charset=" + string4;
                httpMessage.setResponseHeader(API.getDefaultResponseHeader("text/html; " + string4, string3.length()));
                httpMessage.setResponseBody(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, OTHER_GENERATE_FORM_PARAM_HREFID);
            }
            catch (ApiException apiException) {
                throw apiException;
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        } else {
            throw new ApiException(ApiException.Type.BAD_OTHER, string);
        }
        return httpMessage;
    }
}

