/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.globalexcludeurl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.extension.globalexcludeurl.GlobalExcludeURLParamToken;

public class GlobalExcludeURLParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(GlobalExcludeURLParam.class);
    private static final String GLOBAL_EXCLUDE_URL_BASE_KEY = "globalexcludeurl";
    private static final String ALL_TOKENS_KEY = "globalexcludeurl.url_list.url";
    private static final String TOKEN_REGEX_KEY = "regex";
    private static final String TOKEN_DESCRIPTION_KEY = "description";
    private static final String TOKEN_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_TOKEN_KEY = "globalexcludeurl.confirmRemoveToken";
    private static ArrayList<GlobalExcludeURLParamToken> defaultList = new ArrayList();
    private List<GlobalExcludeURLParamToken> tokens = null;
    private List<String> enabledTokensNames = null;
    private boolean confirmRemoveToken = true;

    private void setDefaultList() {
        String[][] stringArrayArray;
        for (String[] stringArray : stringArrayArray = new String[][]{{"^.*\\.(gif|jpe?g|png|ico|icns|bmp)$", "Extension - Image (ends with .extension)", "false"}, {"^.*\\.(mp[34]|mpe?g|m4[ap]|aac|avi|mov|wmv|og[gav])$", "Extension - Audio/Video (ends with .extension)", "false"}, {"^.*\\.(pdf|docx?|xlsx?|pptx?)$", "Extension - PDF & Office (ends with .extension)", "false"}, {"^.*\\.(css|js)$", "Extension - Stylesheet, JavaScript (ends with .extension)", "false"}, {"^.*\\.(sw[fa]|flv)$", "Extension - Flash & related (ends with .extension)", "false"}, {"^[^\\?]*\\.(gif|jpe?g|png|ico|icns|bmp)\\?.*$", "ExtParam - Image (extension plus ?params=values)", "false"}, {"^[^\\?]*\\.(mp[34]|mpe?g|m4[ap]|aac|avi|mov|wmv|og[gav])\\?.*$", "ExtParam - Audio/Video (extension plus ?params=values)", "false"}, {"^[^\\?]*\\.(pdf|docx?|xlsx?|pptx?)\\?.*$", "ExtParam - PDF & Office (extension plus ?params=values)", "false"}, {"^[^\\?]*\\.(css|js)\\?.*$", "ExtParam - Stylesheet, JavaScript (extension plus ?params=values)", "false"}, {"^[^\\?]*\\.(sw[fa]|flv)\\?.*$", "ExtParam - Flash & related (extension plus ?params=values)", "false"}, {"^[^\\?]*/(WebResource|ScriptResource)\\.axd\\?d=.*$", "ExtParam - .NET adx resources (SR/WR.adx?d=)", "false"}, {"^https?://api\\.bing\\.com/qsml\\.aspx?query=.*$", "Site - Bing API queries", "false"}, {"^https?://(safebrowsing-cache|sb-ssl|sb|safebrowsing\\.clients)\\.google\\.com/.*$", "Site - Google malware detector updates", "false"}, {"^https?://([^/])*\\.?lastpass\\.com", "Site - Lastpass manager", "false"}, {"^https?://(.*addons|aus[0-9])\\.mozilla\\.(org|net|com)/.*$", "Site - Mozilla Firefox browser updates", "false"}, {"^https?://([^/])*\\.?(getfoxyproxy\\.org|getfirebug\\.com|noscript\\.net)", "Site - Mozilla Firefox extensions phoning home", "false"}, {"^https?://(.*update\\.microsoft|.*\\.windowsupdate)\\.com/.*$", "Site - Microsoft Windows updates", "false"}, {"^https?://clients2\\.google\\.com/service/update2/crx.*$", "Site - Google Chrome extension updates", "false"}}) {
            boolean bl = stringArray[2].equalsIgnoreCase("true");
            defaultList.add(new GlobalExcludeURLParamToken(stringArray[0], stringArray[1], bl));
        }
    }

    public GlobalExcludeURLParam() {
        this.setDefaultList();
    }

    @Override
    protected void parse() {
        try {
            List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_TOKENS_KEY);
            this.tokens = new ArrayList<GlobalExcludeURLParamToken>(list.size());
            this.enabledTokensNames = new ArrayList<String>(list.size());
            ArrayList<String> object = new ArrayList<String>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                HierarchicalConfiguration hierarchicalConfiguration = (HierarchicalConfiguration)iterator.next();
                String string = hierarchicalConfiguration.getString(TOKEN_REGEX_KEY, "");
                if ("".equals(string) || object.contains(string)) continue;
                boolean bl = hierarchicalConfiguration.getBoolean(TOKEN_ENABLED_KEY, true);
                String string2 = hierarchicalConfiguration.getString(TOKEN_DESCRIPTION_KEY, "");
                this.tokens.add(new GlobalExcludeURLParamToken(string, string2, bl));
                object.add(string);
                if (!bl) continue;
                this.enabledTokensNames.add(string);
            }
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading Global Exclude URL tokens: " + conversionException.getMessage()), (Throwable)conversionException);
            this.tokens = new ArrayList<GlobalExcludeURLParamToken>(defaultList.size());
            this.enabledTokensNames = new ArrayList<String>(defaultList.size());
        }
        if (this.tokens.size() == 0) {
            for (GlobalExcludeURLParamToken globalExcludeURLParamToken : defaultList) {
                this.tokens.add(new GlobalExcludeURLParamToken(globalExcludeURLParamToken));
            }
        }
        try {
            this.confirmRemoveToken = this.getConfig().getBoolean(CONFIRM_REMOVE_TOKEN_KEY, true);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading the confirm remove token option: " + conversionException.getMessage()), (Throwable)conversionException);
        }
    }

    public List<GlobalExcludeURLParamToken> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<GlobalExcludeURLParamToken> list) {
        this.tokens = new ArrayList<GlobalExcludeURLParamToken>(list);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_TOKENS_KEY);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = "globalexcludeurl.url_list.url(" + i + ").";
            GlobalExcludeURLParamToken globalExcludeURLParamToken = list.get(i);
            this.getConfig().setProperty(string + TOKEN_REGEX_KEY, (Object)globalExcludeURLParamToken.getRegex());
            this.getConfig().setProperty(string + TOKEN_DESCRIPTION_KEY, (Object)globalExcludeURLParamToken.getDescription());
            this.getConfig().setProperty(string + TOKEN_ENABLED_KEY, (Object)globalExcludeURLParamToken.isEnabled());
            if (!globalExcludeURLParamToken.isEnabled()) continue;
            arrayList.add(globalExcludeURLParamToken.getRegex());
        }
        arrayList.trimToSize();
        this.enabledTokensNames = arrayList;
        Model.getSingleton().getSession().forceGlobalExcludeURLRefresh();
    }

    public void addToken(String string) {
        this.tokens.add(new GlobalExcludeURLParamToken(string));
        this.enabledTokensNames.add(string);
    }

    public void removeToken(String string) {
        this.tokens.remove(new GlobalExcludeURLParamToken(string));
        this.enabledTokensNames.remove(string);
    }

    public List<String> getTokensNames() {
        return this.enabledTokensNames;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveToken() {
        return this.confirmRemoveToken;
    }

    @ZapApiIgnore
    public void setConfirmRemoveToken(boolean bl) {
        this.confirmRemoveToken = bl;
        this.getConfig().setProperty(CONFIRM_REMOVE_TOKEN_KEY, (Object)this.confirmRemoveToken);
    }
}

