/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.security.AccessController;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

public class PersistentValve
extends ValveBase {
    private static final ClassLoader MY_CLASSLOADER = PersistentValve.class.getClassLoader();
    private volatile boolean clBindRequired;
    private static final String info = "org.apache.catalina.valves.PersistentValve/1.0";

    public PersistentValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.clBindRequired = container instanceof Engine || container instanceof Host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Store store;
        Context context = request.getContext();
        if (context == null) {
            response.sendError(500, sm.getString("standardHost.noContext"));
            return;
        }
        String sessionId = request.getRequestedSessionId();
        Manager manager = context.getManager();
        if (sessionId != null && manager instanceof PersistentManager && (store = ((PersistentManager)manager).getStore()) != null) {
            Session session = null;
            try {
                session = store.load(sessionId);
            }
            catch (Exception e) {
                this.container.getLogger().error((Object)"deserializeError");
            }
            if (session != null) {
                if (!session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
                    if (this.container.getLogger().isDebugEnabled()) {
                        this.container.getLogger().debug((Object)"session swapped in is invalid or expired");
                    }
                    session.expire();
                    store.remove(sessionId);
                } else {
                    session.setManager(manager);
                    manager.add(session);
                    session.access();
                    session.endAccess();
                }
            }
        }
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug((Object)("sessionId: " + sessionId));
        }
        this.getNext().invoke(request, response);
        if (!request.isAsync()) {
            Session hsess;
            try {
                hsess = request.getSessionInternal(false);
            }
            catch (Exception ex) {
                hsess = null;
            }
            String newsessionId = null;
            if (hsess != null) {
                newsessionId = hsess.getIdInternal();
            }
            if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().debug((Object)("newsessionId: " + newsessionId));
            }
            if (newsessionId != null) {
                try {
                    this.bind(context);
                    if (manager instanceof PersistentManager) {
                        Session session = manager.findSession(newsessionId);
                        Store store2 = ((PersistentManager)manager).getStore();
                        if (store2 != null && session != null && session.isValid() && !this.isSessionStale(session, System.currentTimeMillis())) {
                            store2.save(session);
                            ((PersistentManager)manager).removeSuper(session);
                            session.recycle();
                        } else if (this.container.getLogger().isDebugEnabled()) {
                            this.container.getLogger().debug((Object)("newsessionId store: " + store2 + " session: " + session + " valid: " + (session == null ? "N/A" : Boolean.toString(session.isValid())) + " stale: " + this.isSessionStale(session, System.currentTimeMillis())));
                        }
                    } else if (this.container.getLogger().isDebugEnabled()) {
                        this.container.getLogger().debug((Object)("newsessionId Manager: " + manager));
                    }
                }
                finally {
                    this.unbind();
                }
            }
        }
    }

    protected boolean isSessionStale(Session session, long timeNow) {
        int timeIdle;
        int maxInactiveInterval;
        return session != null && (maxInactiveInterval = session.getMaxInactiveInterval()) >= 0 && (timeIdle = (int)((timeNow - session.getThisAccessedTime()) / 1000L)) >= maxInactiveInterval;
    }

    private void bind(Context context) {
        if (this.clBindRequired && context.getLoader() != null) {
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa = new PrivilegedSetTccl(context.getLoader().getClassLoader());
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
            }
        }
    }

    private void unbind() {
        if (this.clBindRequired) {
            if (Globals.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl pa = new PrivilegedSetTccl(MY_CLASSLOADER);
                AccessController.doPrivileged(pa);
            } else {
                Thread.currentThread().setContextClassLoader(MY_CLASSLOADER);
            }
        }
    }
}

