/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;

public final class Statistics {
    public static final TimeConsumer REFRESH_FOLDER = new TimeConsumer("Folder refresh");
    public static final TimeConsumer REFRESH_FILE = new TimeConsumer("File refresh");
    public static final TimeConsumer REFRESH_FS = new TimeConsumer("FileSystem refresh");
    public static final TimeConsumer LISTENERS_CALLS = new TimeConsumer("Invocation of FileChangeListeners");

    private Statistics() {
    }

    public static StopWatch getStopWatch(TimeConsumer timeConsumer) {
        return new StopWatch(timeConsumer);
    }

    public static int fileSystems() {
        return FileObjectFactory.getFactoriesSize();
    }

    public static int fileNamings() {
        return NamingFactory.getSize();
    }

    public static int fileObjects() {
        int n = 0;
        for (FileObjectFactory fileObjectFactory : FileObjectFactory.getInstances()) {
            n += Statistics.fileObjectsPerFileSystem(fileObjectFactory);
        }
        return n;
    }

    public static int fileObjectsPerFileSystem(FileObjectFactory fileObjectFactory) {
        return fileObjectFactory.getSize();
    }

    public static final class StopWatch {
        private long startTime = 0L;
        private final TimeConsumer activity;

        private StopWatch(TimeConsumer timeConsumer) {
            this.activity = timeConsumer;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public void stop() {
            assert (this.startTime != 0L);
            this.activity.elapsedTime = (int)((long)this.activity.elapsedTime + (System.currentTimeMillis() - this.startTime));
            this.activity.incrementNumerOfCalls();
            this.startTime = 0L;
        }
    }

    public static final class TimeConsumer {
        private int elapsedTime;
        private int numberOfCalls;
        private final String description;

        private TimeConsumer(String string) {
            this.description = string;
        }

        public int getConsumedTime() {
            return this.elapsedTime;
        }

        public int getNumberOfCalls() {
            return this.numberOfCalls;
        }

        public void reset() {
            this.elapsedTime = 0;
            this.numberOfCalls = 0;
        }

        public String toString() {
            return this.description + ": " + this.numberOfCalls + " calls in " + this.elapsedTime + "ms";
        }

        private void incrementNumerOfCalls() {
            ++this.numberOfCalls;
        }
    }
}

