/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.FileFolderFilter;
import common.FilenameFilterAcceptAll;
import common.FolderIteratorInfo;
import common.FolderIteratorListener;
import common.LicenseString;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class FolderIterator
implements Runnable,
LicenseString {
    private FolderIteratorInfo FII;
    private FolderIteratorListener folderIteratorListener;

    public String getLicenseString() {
        return "This file is covered by the GNU GENERAL PUBLIC LICENSE, Version 2, June 1991";
    }

    public FolderIterator() {
        this.folderIteratorListener = null;
        this.commonConstructor();
        this.FII.setStartigPath(new File(""));
    }

    public FolderIterator(FolderIteratorListener aFolderIteratorListener) {
        this.setFolderIteratorListener(aFolderIteratorListener);
        this.commonConstructor();
        this.FII.setStartigPath(new File(""));
    }

    public FolderIterator(String pathName) {
        this.folderIteratorListener = null;
        this.setStartingPath(pathName);
        this.commonConstructor();
    }

    public FolderIterator(File path) {
        this.folderIteratorListener = null;
        this.setStartingPath(path);
        this.commonConstructor();
    }

    private void commonConstructor() {
        this.FII = new FolderIteratorInfo();
        this.FII.setFileFolderFilter(new FileFolderFilter(new FilenameFilterAcceptAll()));
        this.FII.setCountFolders(0);
        this.FII.setCountFiles(0);
        this.FII.currentDeep = 0;
        this.setHowDeep(0);
    }

    public void setFolderIteratorListener(FolderIteratorListener aFolderIteratorListener) {
        if (aFolderIteratorListener == null) {
            throw new NullPointerException("FolderIteratorListener is null");
        }
        this.folderIteratorListener = aFolderIteratorListener;
    }

    public void setStartingPath(String pathName) {
        File path = new File(pathName);
        this.setStartingPath(path);
    }

    public void setStartingPath(File path) {
        if (path != null && path.isDirectory()) {
            this.FII.setStartigPath(path);
        }
    }

    public void setHowDeep(int howDeep) {
        if (howDeep > 0) {
            this.FII.setHowDeep(howDeep);
        }
    }

    public int getHowDeep() {
        return this.FII.getHowDeep();
    }

    private Vector stringsToFiles(File path, String[] list) {
        Vector<File> files = null;
        if (list != null) {
            files = new Vector<File>(0, 1);
            int j = 0;
            int i = 0;
            while (i < list.length) {
                File f = new File(path + File.separator + list[i]);
                files.add(f);
                ++j;
                ++i;
            }
        }
        return files;
    }

    private void runImpl(File path) {
        String[] list = this.FII.getFileFolderFilter() != null ? path.list(this.FII.fileFolderFilter) : path.list();
        if (list == null) {
            System.err.println("path >" + path + "< is not a Directory !!");
        } else {
            Vector files = this.stringsToFiles(path, list);
            if (files != null) {
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    File f = (File)it.next();
                    if (!f.isDirectory()) {
                        this.actionForFile(f);
                        continue;
                    }
                    this.actionForFolder(f, path);
                }
            }
        }
    }

    private void actionForFile(File file) {
        ++this.FII.countFiles;
        if (this.folderIteratorListener != null) {
            this.folderIteratorListener.actionForFile(file, this.FII);
        }
    }

    private void actionForFolder(File folder, File path) {
        ++this.FII.countFolders;
        if (this.folderIteratorListener != null) {
            this.folderIteratorListener.actionForFolder(folder, path, this.FII);
        }
        if (this.FII.currentDeep < this.getHowDeep()) {
            ++this.FII.currentDeep;
            this.runImpl(folder);
            --this.FII.currentDeep;
        } else {
            String aux = "path >" + path;
            aux = String.valueOf(aux) + "< had more folders but \"howDeep\" prevented from descending more";
            System.err.println(aux);
        }
    }

    private void actionRunInit() {
        if (this.folderIteratorListener != null) {
            this.folderIteratorListener.actionRunInit(this.FII);
        }
    }

    private void actionRunFinished() {
        if (this.folderIteratorListener != null) {
            this.folderIteratorListener.actionRunFinished(this.FII);
        }
    }

    public final void run() {
        this.actionRunInit();
        this.runImpl(this.FII.getStartigPath());
        this.actionRunFinished();
    }

    public FolderIteratorListener getFolderIteratorListener() {
        return this.folderIteratorListener;
    }

    public void setFileFolderFilter(FileFolderFilter filter) {
        if (filter != null) {
            this.FII.setFileFolderFilter(filter);
        }
    }
}

