/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.Geometry;

public final class SelectByInternalPointAction {
    private SelectByInternalPointAction() {
    }

    public static Collection<OsmPrimitive> getSurroundingObjects(EastNorth eastNorth) {
        return SelectByInternalPointAction.getSurroundingObjects(MainApplication.getLayerManager().getEditDataSet(), eastNorth, false);
    }

    public static Collection<OsmPrimitive> getSurroundingObjects(DataSet dataSet, EastNorth eastNorth, boolean bl) {
        if (dataSet == null) {
            return Collections.emptySet();
        }
        Node node = new Node(eastNorth);
        TreeMap<Double, OsmPrimitive> treeMap = new TreeMap<Double, OsmPrimitive>();
        for (Way object : dataSet.getWays()) {
            if (!object.isUsable() || !object.isClosed() || !object.isSelectable() || !Geometry.nodeInsidePolygon(node, object.getNodes())) continue;
            treeMap.put(Geometry.closedWayArea(object), object);
        }
        Projection projection = MainApplication.getMap().mapView.getProjection();
        for (Relation relation : dataSet.getRelations()) {
            if (!relation.isUsable() || !relation.isMultipolygon() || !relation.isSelectable() || !Geometry.isNodeInsideMultiPolygon(node, relation, null)) continue;
            if (!bl) {
                for (RelationMember relationMember : relation.getMembers()) {
                    if (!relationMember.isWay() || !relationMember.getWay().isClosed()) continue;
                    treeMap.values().remove(relationMember.getWay());
                }
            }
            BBox bBox = relation.getBBox();
            EastNorth eastNorth2 = projection.latlon2eastNorth(bBox.getTopLeft());
            EastNorth eastNorth3 = projection.latlon2eastNorth(bBox.getBottomRight());
            double d = Math.abs((eastNorth2.east() - eastNorth3.east()) * (eastNorth2.north() - eastNorth3.north()));
            treeMap.put(d <= 0.0 ? 1.0E8 : d, relation);
        }
        return treeMap.values();
    }

    public static OsmPrimitive getSmallestSurroundingObject(EastNorth eastNorth) {
        Collection<OsmPrimitive> collection = SelectByInternalPointAction.getSurroundingObjects(eastNorth);
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public static void performSelection(EastNorth eastNorth, boolean bl, boolean bl2) {
        Collection<OsmPrimitive> collection = SelectByInternalPointAction.getSurroundingObjects(eastNorth);
        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
        if (collection.isEmpty()) {
            return;
        }
        if (bl2) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(dataSet.getSelected());
            arrayList.removeAll(collection);
            dataSet.setSelected(arrayList);
        } else if (bl) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(dataSet.getSelected());
            arrayList.add(collection.iterator().next());
            dataSet.setSelected(arrayList);
        } else {
            dataSet.setSelected(collection.iterator().next());
        }
    }
}

