/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2Util;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class NTV2SubGrid
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String subGridName;
    private final String parentSubGridName;
    private final String created;
    private final String updated;
    private final double minLat;
    private final double maxLat;
    private final double minLon;
    private final double maxLon;
    private final double latInterval;
    private final double lonInterval;
    private final int nodeCount;
    private final int lonColumnCount;
    private final int latRowCount;
    private final float[] latShift;
    private final float[] lonShift;
    private float[] latAccuracy;
    private float[] lonAccuracy;
    private NTV2SubGrid[] subGrid;

    public NTV2SubGrid(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[1];
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.subGridName = new String(byArray, StandardCharsets.UTF_8).trim();
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.parentSubGridName = new String(byArray, StandardCharsets.UTF_8).trim();
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.created = new String(byArray, StandardCharsets.UTF_8);
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.updated = new String(byArray, StandardCharsets.UTF_8);
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.minLat = NTV2Util.getDouble(byArray, bl);
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.maxLat = NTV2Util.getDouble(byArray, bl);
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.minLon = NTV2Util.getDouble(byArray, bl);
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.maxLon = NTV2Util.getDouble(byArray, bl);
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.latInterval = NTV2Util.getDouble(byArray, bl);
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.lonInterval = NTV2Util.getDouble(byArray, bl);
        this.lonColumnCount = 1 + (int)((this.maxLon - this.minLon) / this.lonInterval);
        this.latRowCount = 1 + (int)((this.maxLat - this.minLat) / this.latInterval);
        NTV2SubGrid.readBytes(inputStream, byArray);
        NTV2SubGrid.readBytes(inputStream, byArray);
        this.nodeCount = NTV2Util.getInt(byArray, bl);
        if (this.nodeCount != this.lonColumnCount * this.latRowCount) {
            throw new IllegalStateException("SubGrid " + this.subGridName + " has inconsistent grid dimesions");
        }
        this.latShift = new float[this.nodeCount];
        this.lonShift = new float[this.nodeCount];
        if (bl2) {
            this.latAccuracy = new float[this.nodeCount];
            this.lonAccuracy = new float[this.nodeCount];
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[0] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[1] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[2] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[3] = byArray3[0];
            this.latShift[i] = NTV2Util.getFloat(byArray2, bl);
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[0] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[1] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[2] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[3] = byArray3[0];
            this.lonShift[i] = NTV2Util.getFloat(byArray2, bl);
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[0] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[1] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[2] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[3] = byArray3[0];
            if (bl2) {
                this.latAccuracy[i] = NTV2Util.getFloat(byArray2, bl);
            }
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[0] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[1] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[2] = byArray3[0];
            NTV2SubGrid.readBytes(inputStream, byArray3);
            byArray2[3] = byArray3[0];
            if (!bl2) continue;
            this.lonAccuracy[i] = NTV2Util.getFloat(byArray2, bl);
        }
    }

    private static void readBytes(InputStream inputStream, byte[] byArray) throws IOException {
        if (inputStream.read(byArray) < byArray.length) {
            Logging.error("Failed to read expected amount of bytes (" + byArray.length + ") from stream");
        }
    }

    public NTV2SubGrid getSubGridForCoord(double d, double d2) {
        if (this.isCoordWithin(d, d2)) {
            if (this.subGrid == null) {
                return this;
            }
            for (NTV2SubGrid nTV2SubGrid : this.subGrid) {
                if (!nTV2SubGrid.isCoordWithin(d, d2)) continue;
                return nTV2SubGrid.getSubGridForCoord(d, d2);
            }
            return this;
        }
        return null;
    }

    private boolean isCoordWithin(double d, double d2) {
        return d >= this.minLon && d < this.maxLon && d2 >= this.minLat && d2 < this.maxLat;
    }

    private static double interpolate(float f, float f2, float f3, float f4, double d, double d2) {
        return (double)f + ((double)f2 - (double)f) * d + ((double)f3 - (double)f) * d2 + ((double)f + (double)f4 - (double)f2 - (double)f3) * d * d2;
    }

    public void interpolateGridShift(NTV2GridShift nTV2GridShift) {
        int n = (int)((nTV2GridShift.getLonPositiveWestSeconds() - this.minLon) / this.lonInterval);
        int n2 = (int)((nTV2GridShift.getLatSeconds() - this.minLat) / this.latInterval);
        double d = (nTV2GridShift.getLonPositiveWestSeconds() - (this.minLon + this.lonInterval * (double)n)) / this.lonInterval;
        double d2 = (nTV2GridShift.getLatSeconds() - (this.minLat + this.latInterval * (double)n2)) / this.latInterval;
        int n3 = n + n2 * this.lonColumnCount;
        int n4 = n3 + 1;
        int n5 = n3 + this.lonColumnCount;
        int n6 = n5 + 1;
        nTV2GridShift.setLonShiftPositiveWestSeconds(NTV2SubGrid.interpolate(this.lonShift[n3], this.lonShift[n4], this.lonShift[n5], this.lonShift[n6], d, d2));
        nTV2GridShift.setLatShiftSeconds(NTV2SubGrid.interpolate(this.latShift[n3], this.latShift[n4], this.latShift[n5], this.latShift[n6], d, d2));
        if (this.lonAccuracy == null) {
            nTV2GridShift.setLonAccuracyAvailable(false);
        } else {
            nTV2GridShift.setLonAccuracyAvailable(true);
            nTV2GridShift.setLonAccuracySeconds(NTV2SubGrid.interpolate(this.lonAccuracy[n3], this.lonAccuracy[n4], this.lonAccuracy[n5], this.lonAccuracy[n6], d, d2));
        }
        if (this.latAccuracy == null) {
            nTV2GridShift.setLatAccuracyAvailable(false);
        } else {
            nTV2GridShift.setLatAccuracyAvailable(true);
            nTV2GridShift.setLatAccuracySeconds(NTV2SubGrid.interpolate(this.latAccuracy[n3], this.latAccuracy[n4], this.latAccuracy[n5], this.latAccuracy[n6], d, d2));
        }
    }

    public String getParentSubGridName() {
        return this.parentSubGridName;
    }

    public String getSubGridName() {
        return this.subGridName;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getSubGridCount() {
        return this.subGrid == null ? 0 : this.subGrid.length;
    }

    public void setSubGridArray(NTV2SubGrid ... nTV2SubGridArray) {
        this.subGrid = Utils.copyArray(nTV2SubGridArray);
    }

    public String toString() {
        return this.subGridName;
    }

    public String getDetails() {
        return new StringBuilder(256).append("Sub Grid : ").append(this.subGridName).append("\nParent   : ").append(this.parentSubGridName).append("\nCreated  : ").append(this.created).append("\nUpdated  : ").append(this.updated).append("\nMin Lat  : ").append(this.minLat).append("\nMax Lat  : ").append(this.maxLat).append("\nMin Lon  : ").append(this.minLon).append("\nMax Lon  : ").append(this.maxLon).append("\nLat Intvl: ").append(this.latInterval).append("\nLon Intvl: ").append(this.lonInterval).append("\nNode Cnt : ").append(this.nodeCount).toString();
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }
}

