/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class RelationEditor
extends ExtendedDialog
implements IRelationEditor {
    public static final String RELATION_PROP = RelationEditor.class.getName() + ".relation";
    public static final String RELATION_SNAPSHOT_PROP = RelationEditor.class.getName() + ".relationSnapshot";
    private static List<Class<RelationEditor>> editors = new ArrayList<Class<RelationEditor>>();
    private transient Relation relation;
    private transient Relation relationSnapshot;
    private final transient OsmDataLayer layer;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    protected RelationEditor(OsmDataLayer osmDataLayer, Relation relation) {
        super(Main.parent, "", new String[]{I18n.tr("Apply Changes", new Object[0]), I18n.tr("Cancel", new Object[0])}, false, false);
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.layer = osmDataLayer;
        this.setRelation(relation);
        osmDataLayer.removeRecentRelation(relation);
    }

    public void registerRelationEditor(Class<RelationEditor> clazz) {
        if (clazz != null && !editors.contains(clazz)) {
            editors.add(clazz);
        }
    }

    public static RelationEditor getEditor(OsmDataLayer osmDataLayer, Relation relation, Collection<RelationMember> collection) {
        for (Class<RelationEditor> clazz : editors) {
            try {
                Method method = clazz.getMethod("canEdit", Relation.class);
                Boolean bl = (Boolean)method.invoke(null, relation);
                if (!bl.booleanValue()) continue;
                return clazz.getConstructor(Relation.class, Collection.class).newInstance(osmDataLayer, relation, collection);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Logging.warn(reflectiveOperationException);
            }
        }
        if (RelationDialogManager.getRelationDialogManager().isOpenInEditor(osmDataLayer, relation)) {
            return RelationDialogManager.getRelationDialogManager().getEditorForRelation(osmDataLayer, relation);
        }
        GenericRelationEditor genericRelationEditor = new GenericRelationEditor(osmDataLayer, relation, collection);
        RelationDialogManager.getRelationDialogManager().positionOnScreen(genericRelationEditor);
        RelationDialogManager.getRelationDialogManager().register(osmDataLayer, relation, genericRelationEditor);
        return genericRelationEditor;
    }

    protected void updateTitle() {
        if (this.getRelation() == null) {
            this.setTitle(I18n.tr("Create new relation in layer ''{0}''", this.layer.getName()));
        } else if (this.getRelation().isNew()) {
            this.setTitle(I18n.tr("Edit new relation in layer ''{0}''", this.layer.getName()));
        } else {
            this.setTitle(I18n.tr("Edit relation #{0} in layer ''{1}''", this.relation.getId(), this.layer.getName()));
        }
    }

    @Override
    public final Relation getRelation() {
        return this.relation;
    }

    @Override
    public final void setRelation(Relation relation) {
        this.setRelationSnapshot(relation == null ? null : new Relation(relation));
        Relation relation2 = this.relation;
        this.relation = relation;
        if (this.relation != relation2) {
            this.support.firePropertyChange(RELATION_PROP, relation2, this.relation);
        }
        this.updateTitle();
    }

    @Override
    public final OsmDataLayer getLayer() {
        return this.layer;
    }

    @Override
    public final Relation getRelationSnapshot() {
        return this.relationSnapshot;
    }

    protected final void setRelationSnapshot(Relation relation) {
        Relation relation2 = this.relationSnapshot;
        this.relationSnapshot = relation;
        if (this.relationSnapshot != relation2) {
            this.support.firePropertyChange(RELATION_SNAPSHOT_PROP, relation2, this.relationSnapshot);
        }
    }

    @Override
    public final boolean isDirtyRelation() {
        return !this.relation.hasEqualSemanticAttributes(this.relationSnapshot);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void dispose() {
        this.layer.setRecentRelation(this.relation);
        super.dispose();
    }
}

