/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.validator;

import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreeRenderer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;

public class ValidatorTreePanel
extends JTree
implements Destroyable,
DataSetListener {
    protected DefaultTreeModel valTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private transient List<TestError> errors = new ArrayList<TestError>();
    private transient Set<? extends OsmPrimitive> filter;
    private final ListenerList<Runnable> invalidationListeners = ListenerList.create();

    public ValidatorTreePanel(List<TestError> list) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(this.valTreeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRow(0);
        this.setVisibleRowCount(8);
        this.setCellRenderer(new ValidatorTreeRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setErrorList(list);
        for (KeyListener keyListener : this.getKeyListeners()) {
            if (!"javax.swing.plaf.basic.BasicTreeUI$Handler".equals(keyListener.getClass().getName())) continue;
            this.removeKeyListener(keyListener);
        }
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof TestError) {
                TestError testError = (TestError)object;
                MultipleNameVisitor multipleNameVisitor = new MultipleNameVisitor();
                multipleNameVisitor.visit(testError.getPrimitives());
                string = "<html>" + multipleNameVisitor.getText() + "<br>" + testError.getMessage();
                String string2 = testError.getDescription();
                if (string2 != null) {
                    string = string + "<br>" + string2;
                }
                string = string + "</html>";
            } else {
                string = defaultMutableTreeNode.toString();
            }
        }
        return string;
    }

    public ValidatorTreePanel() {
        this((List<TestError>)null);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.buildTree();
        } else {
            this.valTreeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(bl);
        this.invalidationListeners.fireEvent(Runnable::run);
    }

    public void buildTree() {
        ArrayList arrayList;
        Object object;
        Object object2;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (this.errors == null || this.errors.isEmpty()) {
            GuiHelper.runInEDTAndWait(() -> this.valTreeModel.setRoot(defaultMutableTreeNode));
            return;
        }
        Collections.sort(this.errors);
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(new TreePath(this.getRoot()));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                object = (DefaultMutableTreeNode)((TreePath)object2).getLastPathComponent();
                arrayList = ((DefaultMutableTreeNode)object).getUserObject();
                if (arrayList instanceof Severity) {
                    hashSet.add(arrayList);
                    continue;
                }
                if (!(arrayList instanceof String)) continue;
                Object object3 = (String)((Object)arrayList);
                int n = ((String)object3).lastIndexOf(" (");
                if (n > 0) {
                    object3 = ((String)object3).substring(0, n);
                }
                hashSet.add(object3);
            }
        }
        object2 = testError -> !testError.isIgnored();
        if (!ValidatorPrefHelper.PREF_OTHER.get().booleanValue()) {
            object2 = object2.and(testError -> testError.getSeverity() != Severity.OTHER);
        }
        if (this.filter != null) {
            object2 = object2.and(testError -> testError.getPrimitives().stream().anyMatch(this.filter::contains));
        }
        object = OsmValidator.getErrorsBySeverityMessageDescription(this.errors, object2);
        arrayList = new ArrayList();
        object.forEach((severity, map2) -> {
            Map map3;
            GroupTreeNode groupTreeNode = new GroupTreeNode(severity);
            defaultMutableTreeNode.add(groupTreeNode);
            if (hashSet.contains(severity)) {
                arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode}));
            }
            if ((map3 = (Map)map2.get("")) != null) {
                map3.forEach((string, list2) -> {
                    String string2 = I18n.tr("{0} ({1})", string, list2.size());
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string2);
                    groupTreeNode.add(defaultMutableTreeNode3);
                    if (hashSet.contains(string)) {
                        arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode, defaultMutableTreeNode3}));
                    }
                    list2.stream().map(DefaultMutableTreeNode::new).forEach(defaultMutableTreeNode3::add);
                });
            }
            map2.forEach((string, map) -> {
                GroupTreeNode groupTreeNode;
                if (string.isEmpty()) {
                    return;
                }
                if (map.size() > 1) {
                    groupTreeNode = new GroupTreeNode(string);
                    groupTreeNode.add(groupTreeNode);
                    if (hashSet.contains(string)) {
                        arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode, groupTreeNode}));
                    }
                } else {
                    groupTreeNode = null;
                }
                map.forEach((string2, list2) -> {
                    String string3 = groupTreeNode != null ? I18n.tr("{0} ({1})", string2, list2.size()) : (string2 == null || string2.isEmpty() ? I18n.tr("{0} ({1})", string, list2.size()) : I18n.tr("{0} - {1} ({2})", string, string2, list2.size()));
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string3);
                    if (groupTreeNode != null) {
                        groupTreeNode.add(defaultMutableTreeNode4);
                    } else {
                        groupTreeNode.add(defaultMutableTreeNode4);
                    }
                    if (hashSet.contains(string2)) {
                        if (groupTreeNode != null) {
                            arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode, groupTreeNode, defaultMutableTreeNode4}));
                        } else {
                            arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode, defaultMutableTreeNode4}));
                        }
                    }
                    list2.stream().map(DefaultMutableTreeNode::new).forEach(defaultMutableTreeNode4::add);
                });
            });
        });
        this.valTreeModel.setRoot(defaultMutableTreeNode);
        for (TreePath treePath : arrayList) {
            this.expandPath(treePath);
        }
        this.invalidationListeners.fireEvent(Runnable::run);
    }

    public void addInvalidationListener(Runnable runnable) {
        this.invalidationListeners.addListener(runnable);
    }

    public void removeInvalidationListener(Runnable runnable) {
        this.invalidationListeners.removeListener(runnable);
    }

    public final void setErrorList(List<TestError> list) {
        this.errors = list;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void setErrors(List<TestError> list) {
        if (this.errors == null) {
            return;
        }
        this.clearErrors();
        for (TestError testError : list) {
            if (testError.isIgnored()) continue;
            this.errors.add(testError);
        }
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public List<TestError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public void selectRelatedErrors(Collection<OsmPrimitive> collection) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        this.walkAndSelectRelatedErrors(new TreePath(this.getRoot()), new HashSet<OsmPrimitive>(collection)::contains, arrayList);
        this.getSelectionModel().clearSelection();
        for (TreePath treePath : arrayList) {
            this.expandPath(treePath);
            this.getSelectionModel().addSelectionPath(treePath);
        }
    }

    private void walkAndSelectRelatedErrors(TreePath treePath, Predicate<OsmPrimitive> predicate, Collection<TreePath> collection) {
        int n = this.getModel().getChildCount(treePath.getLastPathComponent());
        for (int i = 0; i < n; ++i) {
            Object object = this.getModel().getChild(treePath.getLastPathComponent(), i);
            if (this.getModel().isLeaf(object) && object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() instanceof TestError) {
                TestError testError = (TestError)((DefaultMutableTreeNode)object).getUserObject();
                if (!testError.getPrimitives().stream().anyMatch(predicate)) continue;
                collection.add(treePath.pathByAddingChild(object));
                continue;
            }
            this.walkAndSelectRelatedErrors(treePath.pathByAddingChild(object), predicate, collection);
        }
    }

    public Set<? extends OsmPrimitive> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<? extends OsmPrimitive> set) {
        this.filter = set != null && set.isEmpty() ? null : set;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void resetErrors() {
        ArrayList<TestError> arrayList = new ArrayList<TestError>(this.errors);
        this.setErrors(arrayList);
    }

    public void expandAll() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getRoot();
        int n = 0;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            this.expandRow(n++);
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.valTreeModel.getRoot();
    }

    private void clearErrors() {
        if (this.errors != null) {
            this.errors.clear();
        }
    }

    @Override
    public void destroy() {
        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
        if (dataSet != null) {
            dataSet.removeDataSetListener(this);
        }
        this.clearErrors();
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        if (this.errors != null) {
            HashSet hashSet = new HashSet(primitivesRemovedEvent.getPrimitives());
            this.errors.removeIf(testError -> testError.getPrimitives().stream().anyMatch(hashSet::contains));
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
    }

    private static final class GroupTreeNode
    extends DefaultMutableTreeNode {
        GroupTreeNode(Object object) {
            super(object);
        }

        @Override
        public String toString() {
            return I18n.tr("{0} ({1})", super.toString(), this.getLeafCount());
        }
    }
}

