/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.Logging;

public class JosmPasswordField
extends JPasswordField
implements FocusListener {
    public JosmPasswordField() {
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    public JosmPasswordField(Document document, String string, int n) {
        super(document, string, n);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    public JosmPasswordField(int n) {
        super(n);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    public JosmPasswordField(String string, int n) {
        super(string, n);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    public JosmPasswordField(String string) {
        super(string);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        MapFrame mapFrame = MainApplication.getMap();
        if (mapFrame != null) {
            mapFrame.keyDetector.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        MapFrame mapFrame = MainApplication.getMap();
        if (mapFrame != null) {
            mapFrame.keyDetector.setEnabled(true);
        }
    }

    public static final void workaroundJdkBug6322854(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            jTextComponent.getActionMap().put("paste", new Action(){
                private final Action pasteAction = TransferHandler.getPasteAction();

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        this.pasteAction.actionPerformed(actionEvent);
                    }
                    catch (NullPointerException nullPointerException) {
                        Logging.log(Logging.LEVEL_ERROR, "NullPointerException occured because of JDK bug 6322854. Copy/Paste operation has not been performed. Please complain to Oracle: https://bugs.openjdk.java.net/browse/JDK-6322854", nullPointerException);
                    }
                }

                @Override
                public void setEnabled(boolean bl) {
                    this.pasteAction.setEnabled(bl);
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                    this.pasteAction.removePropertyChangeListener(propertyChangeListener);
                }

                @Override
                public void putValue(String string, Object object) {
                    this.pasteAction.putValue(string, object);
                }

                @Override
                public boolean isEnabled() {
                    return this.pasteAction.isEnabled();
                }

                @Override
                public Object getValue(String string) {
                    return this.pasteAction.getValue(string);
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                    this.pasteAction.addPropertyChangeListener(propertyChangeListener);
                }
            });
        }
    }
}

