/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.DiffResultProcessor;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmChangeBuilder;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OsmApi
extends OsmConnection {
    public static final int DEFAULT_MAX_NUM_RETRIES = 5;
    public static final int MAX_DOWNLOAD_THREADS = 2;
    public static final String DEFAULT_API_URL = "https://api.openstreetmap.org/api";
    private static Map<String, OsmApi> instances = new HashMap<String, OsmApi>();
    private URL url;
    private final String serverUrl;
    private Changeset changeset;
    private String version;
    private Capabilities capabilities;
    private boolean initialized;

    public static OsmApi getOsmApi(String string) {
        OsmApi osmApi = instances.get(string);
        if (osmApi == null) {
            osmApi = new OsmApi(string);
            OsmApi.cacheInstance(osmApi);
        }
        return osmApi;
    }

    protected static void cacheInstance(OsmApi osmApi) {
        instances.put(osmApi.getServerUrl(), osmApi);
    }

    private static String getServerUrlFromPref() {
        return Main.pref.get("osm-server.url", DEFAULT_API_URL);
    }

    public static OsmApi getOsmApi() {
        return OsmApi.getOsmApi(OsmApi.getServerUrlFromPref());
    }

    protected OsmApi(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "serverUrl");
        this.serverUrl = string;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHost() {
        String string = null;
        try {
            string = new URL(this.serverUrl).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            Logging.warn(malformedURLException);
        }
        return string;
    }

    public void initialize(ProgressMonitor progressMonitor) throws OsmTransferCanceledException, OsmApiInitializationException {
        this.initialize(progressMonitor, false);
    }

    public void initialize(ProgressMonitor progressMonitor, boolean bl) throws OsmTransferCanceledException, OsmApiInitializationException {
        if (this.initialized) {
            return;
        }
        this.cancel = false;
        try {
            CapabilitiesCache capabilitiesCache = new CapabilitiesCache(progressMonitor, bl);
            try {
                this.initializeCapabilities(capabilitiesCache.updateIfRequiredString());
            }
            catch (SAXParseException sAXParseException) {
                Logging.trace(sAXParseException);
                this.initializeCapabilities(capabilitiesCache.updateForceString());
            }
            if (this.capabilities == null) {
                if (Main.isOffline(OnlineResource.OSM_API)) {
                    Logging.warn(I18n.tr("{0} not available (offline mode)", I18n.tr("OSM API", new Object[0])));
                } else {
                    Logging.error(I18n.tr("Unable to initialize OSM API.", new Object[0]));
                }
                return;
            }
            if (!this.capabilities.supportsVersion("0.6")) {
                Logging.error(I18n.tr("This version of JOSM is incompatible with the configured server.", new Object[0]));
                Logging.error(I18n.tr("It supports protocol version 0.6, while the server says it supports {0} to {1}.", this.capabilities.get("version", "minimum"), this.capabilities.get("version", "maximum")));
                return;
            }
            this.version = "0.6";
            this.initialized = true;
            if (MainApplication.isDisplayingMapView()) {
                for (Layer layer : MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class)) {
                    if (!((ImageryLayer)layer).getInfo().isBlacklisted()) continue;
                    Logging.info(I18n.tr("Removed layer {0} because it is not allowed by the configured API.", layer.getName()));
                    MainApplication.getLayerManager().removeLayer(layer);
                }
            }
        }
        catch (OsmTransferCanceledException osmTransferCanceledException) {
            throw osmTransferCanceledException;
        }
        catch (OsmTransferException osmTransferException) {
            this.initialized = false;
            Main.addNetworkError(this.url, Utils.getRootCause(osmTransferException));
            throw new OsmApiInitializationException(osmTransferException);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            this.initialized = false;
            throw new OsmApiInitializationException(exception);
        }
    }

    private synchronized void initializeCapabilities(String string) throws SAXException, IOException, ParserConfigurationException {
        if (string != null) {
            this.capabilities = Capabilities.CapabilitiesParser.parse(new InputSource(new StringReader(string)));
        }
    }

    protected final String toXml(IPrimitive iPrimitive, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        try (OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(new PrintWriter(stringWriter), true, this.version);){
            stringWriter.getBuffer().setLength(0);
            osmWriter.setWithBody(bl);
            osmWriter.setChangeset(this.changeset);
            osmWriter.header();
            iPrimitive.accept(osmWriter);
            osmWriter.footer();
            osmWriter.flush();
        }
        catch (IOException iOException) {
            Logging.warn(iOException);
        }
        return stringWriter.toString();
    }

    protected final String toXml(Changeset changeset) {
        StringWriter stringWriter = new StringWriter();
        try (OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(new PrintWriter(stringWriter), true, this.version);){
            stringWriter.getBuffer().setLength(0);
            osmWriter.header();
            osmWriter.visit(changeset);
            osmWriter.footer();
            osmWriter.flush();
        }
        catch (IOException iOException) {
            Logging.warn(iOException);
        }
        return stringWriter.toString();
    }

    private static String getBaseUrl(String string, String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            stringBuilder.append('/').append(string2);
        }
        stringBuilder.append('/');
        while ((n = stringBuilder.indexOf("//", stringBuilder.indexOf("://") + 2)) > -1) {
            stringBuilder.delete(n, n + 1);
        }
        return stringBuilder.toString();
    }

    public String getBaseUrl() {
        return OsmApi.getBaseUrl(this.serverUrl, this.version);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void createPrimitive(IPrimitive iPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        String string = "";
        try {
            this.ensureValidChangeset();
            this.initialize(progressMonitor);
            string = this.sendRequest("PUT", OsmPrimitiveType.from(iPrimitive).getAPIName() + "/create", this.toXml(iPrimitive, true), progressMonitor);
            iPrimitive.setOsmId(Long.parseLong(string.trim()), 1);
            iPrimitive.setChangesetId(this.getChangeset().getId());
        }
        catch (NumberFormatException numberFormatException) {
            throw new OsmTransferException(I18n.tr("Unexpected format of ID replied by the server. Got ''{0}''.", string), numberFormatException);
        }
    }

    public void modifyPrimitive(IPrimitive iPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        String string = null;
        try {
            this.ensureValidChangeset();
            this.initialize(progressMonitor);
            string = this.sendRequest("PUT", OsmPrimitiveType.from(iPrimitive).getAPIName() + '/' + iPrimitive.getId(), this.toXml(iPrimitive, true), progressMonitor);
            iPrimitive.setOsmId(iPrimitive.getId(), Integer.parseInt(string.trim()));
            iPrimitive.setChangesetId(this.getChangeset().getId());
            iPrimitive.setVisible(true);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OsmTransferException(I18n.tr("Unexpected format of new version of modified primitive ''{0}''. Got ''{1}''.", iPrimitive.getId(), string), numberFormatException);
        }
    }

    public void deletePrimitive(OsmPrimitive osmPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.ensureValidChangeset();
        this.initialize(progressMonitor);
        this.uploadDiff(Collections.singleton(osmPrimitive), progressMonitor.createSubTaskMonitor(-1, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openChangeset(Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        try {
            progressMonitor.beginTask(I18n.tr("Creating changeset...", new Object[0]));
            this.initialize(progressMonitor);
            String string = "";
            try {
                string = this.sendRequest("PUT", "changeset/create", this.toXml(changeset), progressMonitor);
                changeset.setId(Integer.parseInt(string.trim()));
                changeset.setOpen(true);
            }
            catch (NumberFormatException numberFormatException) {
                throw new OsmTransferException(I18n.tr("Unexpected format of ID replied by the server. Got ''{0}''.", string), numberFormatException);
            }
            progressMonitor.setCustomText(I18n.tr("Successfully opened changeset {0}", changeset.getId()));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void updateChangeset(Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        try {
            progressMonitor.beginTask(I18n.tr("Updating changeset...", new Object[0]));
            this.initialize(progressMonitor);
            progressMonitor.setCustomText(I18n.tr("Updating changeset {0}...", changeset.getId()));
            this.sendRequest("PUT", "changeset/" + changeset.getId(), this.toXml(changeset), progressMonitor);
        }
        catch (ChangesetClosedException changesetClosedException) {
            changesetClosedException.setSource(ChangesetClosedException.Source.UPDATE_CHANGESET);
            throw changesetClosedException;
        }
        catch (OsmApiException osmApiException) {
            String string = osmApiException.getErrorHeader();
            if (osmApiException.getResponseCode() == 409 && ChangesetClosedException.errorHeaderMatchesPattern(string)) {
                throw new ChangesetClosedException(string, ChangesetClosedException.Source.UPDATE_CHANGESET);
            }
            throw osmApiException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void closeChangeset(Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        try {
            progressMonitor.beginTask(I18n.tr("Closing changeset...", new Object[0]));
            this.initialize(progressMonitor);
            this.sendRequest("PUT", "changeset/" + changeset.getId() + "/close", "\r\n", progressMonitor);
            changeset.setOpen(false);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Collection<OsmPrimitive> uploadDiff(Collection<? extends OsmPrimitive> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask("", collection.size() * 2);
            if (this.changeset == null) {
                throw new OsmTransferException(I18n.tr("No changeset present for diff upload.", new Object[0]));
            }
            this.initialize(progressMonitor);
            OsmChangeBuilder osmChangeBuilder = new OsmChangeBuilder(this.changeset);
            progressMonitor.subTask(I18n.tr("Preparing upload request...", new Object[0]));
            osmChangeBuilder.start();
            osmChangeBuilder.append(collection);
            osmChangeBuilder.finish();
            String string = osmChangeBuilder.getDocument();
            progressMonitor.indeterminateSubTask(I18n.trn("Uploading {0} object...", "Uploading {0} objects...", collection.size(), collection.size()));
            String string2 = this.sendRequest("POST", "changeset/" + this.changeset.getId() + "/upload", string, progressMonitor);
            DiffResultProcessor diffResultProcessor = new DiffResultProcessor(collection);
            diffResultProcessor.parse(string2, progressMonitor.createSubTaskMonitor(-1, false));
            Set<OsmPrimitive> set = diffResultProcessor.postProcess(this.getChangeset(), progressMonitor.createSubTaskMonitor(-1, false));
            return set;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (XmlParsingException xmlParsingException) {
            throw new OsmTransferException(xmlParsingException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private void sleepAndListen(int n, ProgressMonitor progressMonitor) throws OsmTransferCanceledException {
        Logging.info(I18n.tr("Waiting 10 seconds ... ", new Object[0]));
        for (int i = 0; i < 10; ++i) {
            if (progressMonitor != null) {
                progressMonitor.setCustomText(I18n.tr("Starting retry {0} of {1} in {2} seconds ...", this.getMaxRetries() - n, this.getMaxRetries(), 10 - i));
            }
            if (this.cancel) {
                throw new OsmTransferCanceledException("Operation canceled" + (i > 0 ? " in retry #" + i : ""));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Logging.warn("InterruptedException in " + this.getClass().getSimpleName() + " during sleep");
                Thread.currentThread().interrupt();
            }
        }
        Logging.info(I18n.tr("OK - trying again.", new Object[0]));
    }

    protected int getMaxRetries() {
        int n = Main.pref.getInteger("osm-server.max-num-retries", 5);
        return Math.max(n, 0);
    }

    public static boolean isUsingOAuth() {
        return "oauth".equals(OsmApi.getAuthMethod());
    }

    public static String getAuthMethod() {
        return Main.pref.get("osm-server.auth-method", "oauth");
    }

    protected final String sendRequest(String string, String string2, String string3, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.sendRequest(string, string2, string3, progressMonitor, true, false);
    }

    /*
     * Loose catch block
     */
    protected final String sendRequest(String string, String string2, String string3, ProgressMonitor progressMonitor, boolean bl, boolean bl2) throws OsmTransferException {
        int n = bl2 ? 0 : this.getMaxRetries();
        while (true) {
            try {
                int n2;
                HttpClient.Response response;
                while (true) {
                    HttpClient httpClient;
                    this.url = new URL(new URL(this.getBaseUrl()), string2);
                    this.activeConnection = httpClient = HttpClient.create(this.url, string).keepAlive(false);
                    if (bl2) {
                        httpClient.setConnectTimeout(1000);
                        httpClient.setReadTimeout(1000);
                    } else {
                        httpClient.setReadTimeout(0);
                    }
                    if (bl) {
                        this.addAuth(httpClient);
                    }
                    if ("PUT".equals(string) || "POST".equals(string) || "DELETE".equals(string)) {
                        httpClient.setHeader("Content-Type", "text/xml");
                        httpClient.setRequestBody((string3 != null ? string3 : "").getBytes(StandardCharsets.UTF_8));
                    }
                    response = httpClient.connect();
                    Logging.info(response.getResponseMessage());
                    n2 = response.getResponseCode();
                    if (n2 < 500 || n-- <= 0) break;
                    this.sleepAndListen(n, progressMonitor);
                    Logging.info(I18n.tr("Starting retry {0} of {1}.", this.getMaxRetries() - n, this.getMaxRetries()));
                }
                String string4 = response.fetchContent();
                String string5 = null;
                if (response.getHeaderField("Error") != null) {
                    string5 = response.getHeaderField("Error");
                    Logging.error("Error header: " + string5);
                } else if (n2 != 200 && string4.length() > 0) {
                    Logging.error("Error body: " + string4);
                }
                this.activeConnection.disconnect();
                string5 = string5 == null ? null : string5.trim();
                String string6 = string4.length() == 0 ? null : string4.trim();
                switch (n2) {
                    case 200: {
                        return string4;
                    }
                    case 410: {
                        throw new OsmApiPrimitiveGoneException(string5, string6);
                    }
                    case 409: {
                        if (ChangesetClosedException.errorHeaderMatchesPattern(string5)) {
                            throw new ChangesetClosedException(string6, ChangesetClosedException.Source.UPLOAD_DATA);
                        }
                        throw new OsmApiException(n2, string5, string6);
                    }
                    case 403: {
                        OsmApiException osmApiException = new OsmApiException(n2, string5, string6);
                        osmApiException.setAccessedUrl(this.activeConnection.getURL().toString());
                        throw osmApiException;
                    }
                }
                throw new OsmApiException(n2, string5, string6);
            }
            catch (ConnectException | SocketTimeoutException iOException) {
                if (n-- > 0) continue;
                throw new OsmTransferException(iOException);
            }
            catch (IOException iOException) {
                throw new OsmTransferException(iOException);
            }
            break;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
    }

    public synchronized Capabilities getCapabilities() {
        return this.capabilities;
    }

    protected void ensureValidChangeset() throws OsmTransferException {
        if (this.changeset == null) {
            throw new OsmTransferException(I18n.tr("Current changeset is null. Cannot upload data.", new Object[0]));
        }
        if (this.changeset.getId() <= 0) {
            throw new OsmTransferException(I18n.tr("ID of current changeset > 0 required. Current ID is {0}.", this.changeset.getId()));
        }
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    public void setChangeset(Changeset changeset) {
        if (changeset == null) {
            this.changeset = null;
            return;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        if (!changeset.isOpen()) {
            throw new IllegalArgumentException(I18n.tr("Open changeset expected. Got closed changeset with id {0}.", changeset.getId()));
        }
        this.changeset = changeset;
    }

    private static StringBuilder noteStringBuilder(Note note) {
        return new StringBuilder().append("notes/").append(note.getId());
    }

    public Note createNote(LatLon latLon, String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.initialize(progressMonitor);
        String string2 = "notes?lat=" + latLon.lat() + "&lon=" + latLon.lon() + "&text=" + Utils.encodeUrl(string);
        String string3 = this.sendRequest("POST", string2, null, progressMonitor, true, false);
        return OsmApi.parseSingleNote(string3);
    }

    public Note addCommentToNote(Note note, String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.initialize(progressMonitor);
        String string2 = OsmApi.noteStringBuilder(note).append("/comment?text=").append(Utils.encodeUrl(string)).toString();
        String string3 = this.sendRequest("POST", string2, null, progressMonitor, true, false);
        return OsmApi.parseSingleNote(string3);
    }

    public Note closeNote(Note note, String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.initialize(progressMonitor);
        String string2 = Utils.encodeUrl(string);
        StringBuilder stringBuilder = OsmApi.noteStringBuilder(note).append("/close");
        if (!string2.trim().isEmpty()) {
            stringBuilder.append("?text=");
            stringBuilder.append(string2);
        }
        String string3 = this.sendRequest("POST", stringBuilder.toString(), null, progressMonitor, true, false);
        return OsmApi.parseSingleNote(string3);
    }

    public Note reopenNote(Note note, String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.initialize(progressMonitor);
        String string2 = Utils.encodeUrl(string);
        StringBuilder stringBuilder = OsmApi.noteStringBuilder(note).append("/reopen");
        if (!string2.trim().isEmpty()) {
            stringBuilder.append("?text=");
            stringBuilder.append(string2);
        }
        String string3 = this.sendRequest("POST", stringBuilder.toString(), null, progressMonitor, true, false);
        return OsmApi.parseSingleNote(string3);
    }

    private static Note parseSingleNote(String string) throws OsmTransferException {
        try {
            List<Note> list = new NoteReader(string).parse();
            if (list.size() == 1) {
                return list.get(0);
            }
            throw new OsmTransferException(I18n.tr("Note upload failed", new Object[0]));
        }
        catch (IOException | SAXException exception) {
            Logging.error(exception);
            throw new OsmTransferException(I18n.tr("Error parsing note response from server", new Object[0]), exception);
        }
    }

    private class CapabilitiesCache
    extends CacheCustomContent<OsmTransferException> {
        private static final String CAPABILITIES = "capabilities";
        private final ProgressMonitor monitor;
        private final boolean fastFail;

        CapabilitiesCache(ProgressMonitor progressMonitor, boolean bl) {
            super(CAPABILITIES + OsmApi.this.getBaseUrl().hashCode(), CacheCustomContent.INTERVAL_WEEKLY);
            this.monitor = progressMonitor;
            this.fastFail = bl;
        }

        @Override
        protected void checkOfflineAccess() {
            OnlineResource.OSM_API.checkOfflineAccess(OsmApi.getBaseUrl(OsmApi.getServerUrlFromPref(), "0.6") + CAPABILITIES, OsmApi.getServerUrlFromPref());
        }

        @Override
        protected byte[] updateData() throws OsmTransferException {
            return OsmApi.this.sendRequest("GET", CAPABILITIES, null, this.monitor, false, this.fastFail).getBytes(StandardCharsets.UTF_8);
        }
    }
}

