/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompileError {
    private static final Pattern error_pattern = Pattern.compile(".*ERROR.*at line ([0-9]+).*\\n(.*)\\n.*\\n(.*)");
    private final int lineNr;
    private final String line;
    private final String error;

    public static List<CompileError> getListFromString(String errorString, int beforecodelines) {
        String[] splitErrors;
        ArrayList<CompileError> returnList = new ArrayList<CompileError>();
        for (String error : splitErrors = errorString.replaceAll("\r\n", "\n").split("\n----------\n")) {
            Matcher m = error_pattern.matcher(error);
            if (!m.find()) continue;
            Integer newLineNr = Integer.parseInt(m.group(1)) - beforecodelines;
            String newLine = m.group(2);
            String newError = m.group(3);
            returnList.add(new CompileError(newLineNr, newLine, newError));
        }
        return returnList;
    }

    private CompileError(int lineNr, String line, String error) {
        this.lineNr = lineNr;
        this.line = line;
        this.error = error;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getLine() {
        return this.line;
    }

    public String getError() {
        return this.error;
    }
}

