/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.diagram.DiagramHandler;
import com.baselet.gui.command.Command;
import java.util.List;
import java.util.Vector;

public class Macro
extends Command {
    private final List<Command> _commands;

    public List<Command> getCommands() {
        return this._commands;
    }

    public Macro(List<Command> v) {
        this._commands = v;
    }

    @Override
    public void execute(DiagramHandler handler) {
        for (int i = 0; i < this._commands.size(); ++i) {
            Command c = this._commands.get(i);
            c.execute(handler);
        }
    }

    @Override
    public void redo(DiagramHandler handler) {
        for (int i = 0; i < this._commands.size(); ++i) {
            Command c = this._commands.get(i);
            c.redo(handler);
        }
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        for (int i = 0; i < this._commands.size(); ++i) {
            Command c = this._commands.get(i);
            c.undo(handler);
        }
    }

    @Override
    public boolean isMergeableTo(Command c) {
        if (!(c instanceof Macro)) {
            return false;
        }
        Macro m = (Macro)c;
        List<Command> v = m.getCommands();
        if (this.getCommands().size() != v.size()) {
            return false;
        }
        for (int i = 0; i < this.getCommands().size(); ++i) {
            Command c2;
            Command c1 = this.getCommands().get(i);
            if (c1.isMergeableTo(c2 = v.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Command mergeTo(Command c) {
        Macro m = (Macro)c;
        List<Command> v = m.getCommands();
        Vector<Command> vectorOfCommands = new Vector<Command>();
        Macro ret = new Macro(vectorOfCommands);
        for (int i = 0; i < this.getCommands().size(); ++i) {
            Command c1 = this.getCommands().get(i);
            Command c2 = v.get(i);
            Command c3 = c1.mergeTo(c2);
            vectorOfCommands.add(c3);
        }
        return ret;
    }

    @Override
    public boolean isChangingDiagram() {
        for (Command c : this._commands) {
            if (!c.isChangingDiagram()) continue;
            return true;
        }
        return false;
    }
}

