/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro.statistics;

import common.Util;
import dguitar.codecs.guitarPro.GPEffectsOnBeat;
import dguitar.codecs.guitarPro.statistics.GPStats;

public class GPStatsEffectsOnBeat
extends GPStats {
    public int downStroke;
    public int upStroke;
    public int pickStrokes;
    public int tremoloBar;
    public int hasRasgueado;
    public int popping;
    public int slapping;
    public int tapping;
    private int numEffects;

    public GPStatsEffectsOnBeat() {
        this.numEffects = 0;
        this.downStroke = 0;
        this.upStroke = 0;
        this.pickStrokes = 0;
        this.tremoloBar = 0;
        this.hasRasgueado = 0;
        this.popping = 0;
        this.slapping = 0;
        this.tapping = 0;
    }

    public GPStatsEffectsOnBeat(GPEffectsOnBeat EOB) {
        this.numEffects = 1;
        this.downStroke = EOB.downStroke != null ? 1 : 0;
        this.upStroke = EOB.upStroke != null ? 1 : 0;
        this.pickStrokes = EOB.pickStrokes != null ? 1 : 0;
        this.tremoloBar = EOB.tremoloBar != null ? 1 : 0;
        this.hasRasgueado = EOB.hasRasgueado ? 1 : 0;
        this.popping = EOB.popping ? 1 : 0;
        this.slapping = EOB.slapping ? 1 : 0;
        this.tapping = EOB.tapping ? 1 : 0;
    }

    public void add(GPStatsEffectsOnBeat a) {
        if (a != null) {
            this.numEffects += a.numEffects;
            this.downStroke += a.downStroke;
            this.upStroke += a.upStroke;
            this.pickStrokes += a.pickStrokes;
            this.tremoloBar += a.tremoloBar;
            this.popping += a.popping;
            this.slapping += a.slapping;
            this.tapping += a.tapping;
        }
    }

    public String toString() {
        String aux = "effects";
        String res = String.valueOf(Util.tabs(level)) + this.numEffects + " " + aux + "\n";
        ++level;
        res = String.valueOf(res) + this.stringFor(this.downStroke, "downStrokes", this.numEffects, aux);
        res = String.valueOf(res) + this.stringFor(this.upStroke, "upStrokes", this.numEffects, aux);
        res = String.valueOf(res) + this.stringFor(this.pickStrokes, "pickStrokes", this.numEffects, aux);
        res = String.valueOf(res) + this.stringFor(this.tremoloBar, "tremoloBars", this.numEffects, aux);
        res = String.valueOf(res) + this.stringFor(this.popping, "poppin", this.numEffects, aux);
        res = String.valueOf(res) + this.stringFor(this.slapping, "slapping", this.numEffects, aux);
        res = String.valueOf(res) + this.stringFor(this.tapping, "tapping", this.numEffects, aux);
        --level;
        return res;
    }
}

