/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.ImageToolBar;
import dguitar.gui.DGDesktopPane;
import dguitar.gui.PlayPanelLabels;
import dguitar.gui.Playable;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;

public class PlayToolBar
extends JToolBar
implements ActionListener,
Playable {
    private ImageToolBar buttons;
    private PlayPanelLabels playPanel;
    private DGDesktopPane desktop;
    private short status;
    public static short BTN_INDEX_PLAY = 0;
    public static short BTN_INDEX_STOP = 1;

    public PlayToolBar(Image[] images, DGDesktopPane aDesktop, Image[] disableImages) {
        this.setFloatable(false);
        this.desktop = aDesktop;
        this.buttons = new ImageToolBar();
        this.buttons.setFloatable(false);
        this.buttons.setNumButtons(images.length);
        this.buttons.setImages(images);
        this.status = 0;
        this.playPanel = new PlayPanelLabels(this.status);
        this.playPanel.setAlignmentX(0.0f);
        this.buttons.add(this.playPanel);
        this.buttons.addActionListener(this);
        this.add(this.buttons);
        this.setStatus(this.status);
    }

    public void setStatus(short st) {
        this.status = st;
        switch (st) {
            case 0: {
                this.buttons.setButtonEnabled(BTN_INDEX_PLAY, false);
                this.buttons.setButtonEnabled(BTN_INDEX_STOP, false);
                break;
            }
            case 1: {
                this.buttons.setButtonEnabled(BTN_INDEX_PLAY, true);
                this.buttons.setButtonEnabled(BTN_INDEX_STOP, false);
                break;
            }
            case 2: {
                this.buttons.setButtonEnabled(BTN_INDEX_PLAY, false);
                this.buttons.setButtonEnabled(BTN_INDEX_STOP, true);
            }
        }
        this.playPanel.setStatus(st);
    }

    public short getStatus() {
        return this.status;
    }

    public static Playable getPlayable(JInternalFrame jif) {
        Playable p = null;
        try {
            p = (Playable)((Object)jif);
        }
        catch (ClassCastException cce) {
            System.err.println("Internal Frame is not playable");
        }
        return p;
    }

    public void actionPerformed(ActionEvent event) {
        Playable p;
        JInternalFrame JIF = this.desktop.getSelectedFrame();
        int newStatus = 0;
        if (JIF != null && (p = PlayToolBar.getPlayable(JIF)) != null) {
            if (this.status >= 1) {
                Object source = event.getSource();
                if (source.equals(this.buttons.getButtonAtIndex(BTN_INDEX_PLAY))) {
                    newStatus = 2;
                } else if (source.equals(this.buttons.getButtonAtIndex(BTN_INDEX_STOP))) {
                    newStatus = 1;
                }
            }
            p.setStatus((short)newStatus);
        }
        this.setStatus((short)newStatus);
    }

    public void setSongTitle(String s) {
        this.playPanel.setSongTitle(s);
    }

    public PlayPanelLabels getPlayPanel() {
        return this.playPanel;
    }
}

