/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.FullScreenFrameListener;
import net.sf.freecol.client.gui.WindowedFrameListener;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.client.gui.menu.InGameMenuBar;
import net.sf.freecol.client.gui.menu.MapEditorMenuBar;
import net.sf.freecol.client.gui.menu.MenuMouseMotionListener;
import net.sf.freecol.common.resources.ResourceManager;

public class FreeColFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(FreeColFrame.class.getName());
    protected final FreeColClient freeColClient;
    protected final Canvas canvas;

    public FreeColFrame(FreeColClient freeColClient, GraphicsDevice gd, JMenuBar menuBar, Canvas canvas, boolean windowed, Rectangle bounds) {
        super(FreeColFrame.getFrameName(), gd.getDefaultConfiguration());
        this.freeColClient = freeColClient;
        this.canvas = canvas;
        this.setDefaultCloseOperation(0);
        if (windowed) {
            this.setResizable(true);
        } else {
            this.setUndecorated(true);
            gd.setFullScreenWindow(this);
        }
        this.setJMenuBar(menuBar);
        this.addWindowListener(windowed ? new WindowedFrameListener(freeColClient) : new FullScreenFrameListener(freeColClient, this));
        this.setCanvas();
        this.setIconImage(ResourceManager.getImage("image.miscicon.FrameIcon"));
        this.pack();
        Insets insets = this.getInsets();
        this.setMinimumSize(new Dimension(656 + insets.left + insets.right, 480 + insets.top + insets.bottom));
        if (!windowed || bounds == null || bounds.width <= 0 || bounds.height <= 0) {
            bounds = gd.getDefaultConfiguration().getBounds();
            if (windowed) {
                Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gd.getDefaultConfiguration());
                bounds = new Rectangle(bounds.x + screenInsets.left, bounds.y + screenInsets.top, bounds.width - screenInsets.right, bounds.height - screenInsets.bottom);
            }
        }
        this.setBounds(bounds);
        logger.info("Frame created in size " + bounds.width + "x" + bounds.height);
        if (windowed) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    logger.info("Window size changes to " + FreeColFrame.this.getSize());
                }
            });
        }
    }

    public void exitFullScreen() {
        GraphicsConfiguration GraphicsConf = this.getGraphicsConfiguration();
        GraphicsDevice gd = GraphicsConf.getDevice();
        gd.setFullScreenWindow(null);
    }

    public void setInGameMenuBar() {
        this.setJMenuBar(new InGameMenuBar(this.freeColClient, new MenuMouseMotionListener(this.freeColClient, this.canvas)));
        this.validate();
    }

    public void setMapEditorMenuBar() {
        this.setJMenuBar(new MapEditorMenuBar(this.freeColClient, new MenuMouseMotionListener(this.freeColClient, this.canvas)));
    }

    public void removeMenuBar() {
        this.setJMenuBar(null);
        this.validate();
    }

    public void resetMenuBar() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar != null) {
            ((FreeColMenuBar)menuBar).reset();
        }
    }

    public void updateMenuBar() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar != null) {
            ((FreeColMenuBar)menuBar).update();
        }
    }

    private static String getFrameName() {
        return "FreeCol " + FreeCol.getVersion();
    }

    private void setCanvas() {
        try {
            this.getContentPane().add(this.canvas);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Java crash", e);
        }
    }
}

