/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RandomUtils {
    public static int randomInt(Logger logger, String logMe, Random random, int range) {
        int ret = random.nextInt(range);
        if (logger != null) {
            logger.finest(logMe + " random(" + range + ") = " + ret);
        }
        return ret;
    }

    public static int[] randomInts(Logger logger, String logMe, Random random, int range, int n) {
        int[] ret = new int[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = random.nextInt(range);
        }
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder(64);
            sb.append(logMe).append(" random(").append(range).append(") = [");
            for (int i = 0; i < n; ++i) {
                sb.append(" ").append(ret[i]);
            }
            sb.append(" ]");
            logger.finest(sb.toString());
        }
        return ret;
    }

    public static float randomFloat(Logger logger, String logMe, Random random) {
        float ret = random.nextFloat();
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            logger.finest(logMe + " random(1.0f) = " + ret);
        }
        return ret;
    }

    public static double randomDouble(Logger logger, String logMe, Random random) {
        double ret = random.nextDouble();
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            logger.finest(logMe + " random(1.0) = " + ret);
        }
        return ret;
    }

    public static <T> T getRandomMember(Logger logger, String logMe, List<T> list, Random random) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        return list.get(RandomUtils.randomInt(logger, logMe, random, list.size()));
    }

    public static void randomShuffle(Logger logger, String logMe, List<?> list, Random random) {
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            logger.finest(logMe + " shuffle.");
        }
        Collections.shuffle(list, random);
    }
}

