/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.JC;

public class CIPChirality {
    static final String RULE_2_nXX_EQ_XX = ";9Be;19F;23Na;27Al;31P;45Sc;55Mn;59Co;75As;89Y;93Nb;98Tc;103Rh;127I;133Cs;141Pr;145Pm;159Tb;165Ho;169Tm;197Au;209Bi;209Po;210At;222Rn;223Fr;226Ra;227Ac;231Pa;232Th;and all > U (atomno > 92)";
    static final String RULE_2_nXX_REV_XX = ";4He;16O;52Cr;96Mo;175Lu;";
    static final int NO_CHIRALITY = 0;
    static final int TIED = 0;
    static final int A_WINS = -1;
    static final int B_WINS = 1;
    static final int IGNORE = Integer.MIN_VALUE;
    static final int UNDETERMINED = -1;
    static final int STEREO_R = 1;
    static final int STEREO_S = 2;
    static final int STEREO_M = 17;
    static final int STEREO_P = 18;
    static final int STEREO_Z = 5;
    static final int STEREO_E = 6;
    static final int STEREO_BOTH_RS = 3;
    static final int STEREO_BOTH_EZ = 7;
    static final int RULE_1a = 1;
    static final int RULE_1b = 2;
    static final int RULE_2 = 3;
    static final int RULE_3 = 4;
    static final int RULE_4a = 5;
    static final int RULE_4b = 6;
    static final int RULE_4c = 7;
    static final int RULE_5 = 8;
    static final int RULE_6 = 9;
    static final int RULE_RS = 99;
    boolean isRule4TEST = false;
    static String prefixString = "..........";
    static Integer zero = 0;
    static final String[] ruleNames = new String[]{"", "1a", "1b", "2", "3", "4a", "4b", "4c", "5", "6"};
    static final float TRIGONALITY_MIN = 0.2f;
    static final int MAX_PATH = 50;
    static final int SMALL_RING_MAX = 7;
    int ptID;
    CIPAtom root;
    int currentRule = 1;
    Lst<BS> lstSmallRings = new Lst();
    BS bsAtropisomeric;
    BS bsKekuleAmbiguous;
    BS bsAzacyclic;
    V3 vNorm = new V3();
    V3 vNorm2 = new V3();
    V3 vTemp = new V3();
    static final int RULE_1b_TEST_OPTION_0_UNCHANGED = 0;
    static final int RULE_1b_TEST_OPTION_A_PARENT = 1;
    static final int RULE_1b_TEST_OPTION_B_SELF = 2;
    static final int RULE_1b_TEST_OPTION_C_NONE = 3;
    static final int RULE_1b_TEST_OPTION_D_SELF_KEKULE = 4;
    int rule1bOption = 1;
    boolean setAuxiliary;
    protected int rootRule;

    public String getRuleName(int rule) {
        if (rule == 99) {
            return "RS";
        }
        return ruleNames[rule];
    }

    public CIPChirality() {
        System.out.println("TESTING Rule 1b option " + this.rule1bOption);
    }

    private void init() {
        this.ptID = 0;
        this.lstSmallRings.clear();
        this.bsKekuleAmbiguous = null;
        this.bsAtropisomeric = new BS();
    }

    public void getChiralityForAtoms(SimpleNode[] atoms, BS bsAtoms, BS bsAtropisomeric, BS bsHelixM, BS bsHelixP, boolean setAuxiliary) {
        if (bsAtoms.isEmpty()) {
            return;
        }
        this.init();
        this.setAuxiliary = setAuxiliary && bsAtoms.cardinality() == 1;
        this.bsAtropisomeric = bsAtropisomeric == null ? new BS() : bsAtropisomeric;
        BS bs = BSUtil.copy((BS)bsAtoms);
        this.lstSmallRings = new Lst();
        while (!bs.isEmpty()) {
            this.getSmallRings(atoms[bs.nextSetBit(0)], bs);
        }
        this.bsKekuleAmbiguous = this.getKekule(atoms);
        this.bsAzacyclic = this.getAzacyclic(atoms, bsAtoms);
        BS bsToDo = BSUtil.copy((BS)bsAtoms);
        boolean haveAlkenes = this.preFilterAtomList(atoms, bsToDo);
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            SimpleNode a = atoms[i];
            a.setCIPChirality(0);
            this.ptID = 0;
            int c = this.getAtomChiralityLimited(a, null, null);
            a.setCIPChirality(c == 0 ? 3 : c | this.currentRule - 1 << 5);
            i = bsToDo.nextSetBit(i + 1);
        }
        if (haveAlkenes) {
            Lst lstEZ = new Lst();
            int i2 = bsToDo.nextSetBit(0);
            while (i2 >= 0) {
                this.getAtomBondChirality(atoms[i2], (Lst<int[]>)lstEZ, bsToDo);
                i2 = bsToDo.nextSetBit(i2 + 1);
            }
            if (this.lstSmallRings.size() > 0 && lstEZ.size() > 0) {
                this.clearSmallRingEZ(atoms, (Lst<int[]>)lstEZ);
            }
            if (bsHelixM != null) {
                i2 = bsHelixM.nextSetBit(0);
                while (i2 >= 0) {
                    atoms[i2].setCIPChirality(17);
                    i2 = bsHelixM.nextSetBit(i2 + 1);
                }
            }
            if (bsHelixP != null) {
                i2 = bsHelixP.nextSetBit(0);
                while (i2 >= 0) {
                    atoms[i2].setCIPChirality(18);
                    i2 = bsHelixP.nextSetBit(i2 + 1);
                }
            }
        }
        if (Logger.debugging) {
            Logger.info((String)("sp2-aromatic = " + this.bsKekuleAmbiguous));
            Logger.info((String)("smallRings = " + PT.toJSON(null, this.lstSmallRings)));
        }
    }

    private BS getAzacyclic(SimpleNode[] atoms, BS bsAtoms) {
        BS bsAza = null;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            SimpleNode atom = atoms[i];
            if (atom.getElementNumber() == 7 && atom.getCovalentBondCount() == 3 && !this.bsKekuleAmbiguous.get(i)) {
                Lst nRings = new Lst();
                int j = this.lstSmallRings.size();
                while (--j >= 0) {
                    BS bsRing = (BS)this.lstSmallRings.get(j);
                    if (!bsRing.get(i)) continue;
                    nRings.addLast((Object)bsRing);
                }
                int nr = nRings.size();
                if (nr >= 2) {
                    BS bsSubs = new BS();
                    SimpleEdge[] bonds = atom.getEdges();
                    int b = bonds.length;
                    while (--b >= 0) {
                        if (!bonds[b].isCovalent()) continue;
                        bsSubs.set(bonds[b].getOtherNode(atom).getIndex());
                    }
                    BS bsBoth = new BS();
                    BS bsAll = new BS();
                    for (int j2 = 0; j2 < nr - 1 && bsAll != null; ++j2) {
                        BS bs1 = (BS)nRings.get(j2);
                        for (int k = j2 + 1; k < nr && bsAll != null; ++k) {
                            BS bs2 = (BS)nRings.get(k);
                            BSUtil.copy2((BS)bs1, (BS)bsBoth);
                            bsBoth.and(bs2);
                            if (bsBoth.cardinality() <= 2) continue;
                            BSUtil.copy2((BS)bs1, (BS)bsAll);
                            bsAll.or(bs2);
                            bsAll.and(bsSubs);
                            if (bsAll.cardinality() != 3) continue;
                            if (bsAza == null) {
                                bsAza = new BS();
                            }
                            bsAza.set(i);
                            bsAll = null;
                        }
                    }
                }
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        return bsAza;
    }

    private boolean preFilterAtomList(SimpleNode[] atoms, BS bsToDo) {
        boolean haveAlkenes = false;
        int i = bsToDo.nextSetBit(0);
        while (i >= 0) {
            if (!this.couldBeChiralAtom(atoms[i])) {
                bsToDo.clear(i);
            } else if (!haveAlkenes && this.couldBeChiralAlkene(atoms[i], null) != -1) {
                haveAlkenes = true;
            }
            i = bsToDo.nextSetBit(i + 1);
        }
        return haveAlkenes;
    }

    private boolean couldBeChiralAtom(SimpleNode a) {
        boolean mustBePlanar = false;
        block0 : switch (a.getCovalentBondCount()) {
            default: {
                System.out.println("?? too many bonds! " + a);
                return false;
            }
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return a.getElementNumber() == 7;
            }
            case 3: {
                switch (a.getElementNumber()) {
                    case 7: {
                        if (this.bsAzacyclic != null && this.bsAzacyclic.get(a.getIndex())) break block0;
                        return false;
                    }
                    case 6: {
                        mustBePlanar = true;
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 33: 
                    case 34: 
                    case 51: 
                    case 52: 
                    case 83: 
                    case 84: {
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 4: 
        }
        SimpleEdge[] edges = a.getEdges();
        int nH = 0;
        boolean haveDouble = false;
        int j = edges.length;
        while (--j >= 0) {
            if (mustBePlanar && edges[j].getCovalentOrder() == 2) {
                haveDouble = true;
            }
            if (edges[j].getOtherNode(a).getIsotopeNumber() != 1) continue;
            ++nH;
        }
        return nH < 2 && (haveDouble || mustBePlanar == Math.abs(this.getTrigonality(a, this.vNorm)) < 0.2f);
    }

    private int couldBeChiralAlkene(SimpleNode a, SimpleNode b) {
        switch (a.getCovalentBondCount()) {
            default: {
                return -1;
            }
            case 2: {
                if (a.getElementNumber() == 7) break;
                return -1;
            }
            case 3: {
                if (this.isFirstRow(a)) break;
                return -1;
            }
        }
        SimpleEdge[] bonds = a.getEdges();
        int n = 0;
        int i = bonds.length;
        while (--i >= 0) {
            if (bonds[i].getCovalentOrder() != 2) continue;
            if (++n > 1) {
                return 17;
            }
            SimpleNode other = bonds[i].getOtherNode(a);
            if (!this.isFirstRow(other)) {
                return -1;
            }
            if (b == null || other == b && b.getCovalentBondCount() != 1) continue;
            return -1;
        }
        return 5;
    }

    boolean isFirstRow(SimpleNode a) {
        int n = a.getElementNumber();
        return n > 2 && n <= 10;
    }

    private BS getKekule(SimpleNode[] atoms) {
        int nRings = this.lstSmallRings.size();
        BS bs = new BS();
        BS bsDone = new BS();
        int i = nRings;
        while (--i >= 0) {
            if (bsDone.get(i)) continue;
            BS bsRing = (BS)this.lstSmallRings.get(i);
            if (bsRing.cardinality() != 6) {
                bsDone.set(i);
                continue;
            }
            int nPI = 0;
            int j = bsRing.nextSetBit(0);
            while (j >= 0) {
                SimpleNode a = atoms[j];
                if (bs.get(a.getIndex())) {
                    ++nPI;
                } else {
                    int nb = a.getCovalentBondCount();
                    if (nb == 3 || nb == 2) {
                        SimpleEdge[] bonds = a.getEdges();
                        int k = bonds.length;
                        while (--k >= 0) {
                            SimpleEdge b = bonds[k];
                            if (b.getCovalentOrder() != 2 || !bsRing.get(b.getOtherNode(a).getIndex())) continue;
                            ++nPI;
                            break;
                        }
                    }
                }
                j = bsRing.nextSetBit(j + 1);
            }
            if (nPI != 6) continue;
            bs.or(bsRing);
            bsDone.set(i);
            i = nRings;
        }
        return bs;
    }

    private void getSmallRings(SimpleNode atom, BS bs) {
        this.root = new CIPAtom().create(atom, null, false, false, false);
        this.root.addSmallRings(bs);
    }

    private void clearSmallRingEZ(SimpleNode[] atoms, Lst<int[]> lstEZ) {
        int j = this.lstSmallRings.size();
        while (--j >= 0) {
            ((BS)this.lstSmallRings.get(j)).andNot(this.bsAtropisomeric);
        }
        int i = lstEZ.size();
        while (--i >= 0) {
            int[] ab = (int[])lstEZ.get(i);
            int j2 = this.lstSmallRings.size();
            while (--j2 >= 0) {
                BS ring = (BS)this.lstSmallRings.get(j2);
                if (!ring.get(ab[0]) || !ring.get(ab[1])) continue;
                atoms[ab[0]].setCIPChirality(3);
                atoms[ab[1]].setCIPChirality(3);
            }
        }
    }

    float getTrigonality(SimpleNode a, V3 vNorm) {
        int n;
        P3[] pts = new P3[4];
        SimpleEdge[] bonds = a.getEdges();
        int i = n = bonds.length;
        int pt = 0;
        while (--i >= 0 && pt < 4) {
            if (!bonds[i].isCovalent()) continue;
            pts[pt++] = bonds[i].getOtherNode(a).getXYZ();
        }
        P4 plane = Measure.getPlaneThroughPoints((T3)pts[0], (T3)pts[1], (T3)pts[2], (V3)vNorm, (V3)this.vTemp, (P4)new P4());
        return Measure.distanceToPlane((P4)plane, (T3)(pts[3] == null ? a.getXYZ() : pts[3]));
    }

    private void getAtomBondChirality(SimpleNode atom, Lst<int[]> lstEZ, BS bsToDo) {
        int index = atom.getIndex();
        SimpleEdge[] bonds = atom.getEdges();
        int c = 0;
        boolean isAtropic = this.bsAtropisomeric.get(index);
        int j = bonds.length;
        while (--j >= 0) {
            int index1;
            SimpleNode atom1;
            SimpleEdge bond = bonds[j];
            if (isAtropic) {
                atom1 = bonds[j].getOtherNode(atom);
                index1 = atom1.getIndex();
                if (!this.bsAtropisomeric.get(index1)) continue;
                c = this.setBondChirality(atom, atom1, atom, atom1, true);
            } else {
                if (bond.getCovalentOrder() != 2 || (index1 = (atom1 = this.getLastCumuleneAtom(bond, atom, null, null)).getIndex()) < index) continue;
                c = this.getBondChiralityLimited(bond, atom);
            }
            if (c != 0) {
                if (!isAtropic) {
                    lstEZ.addLast((Object)new int[]{index, index1});
                }
                bsToDo.clear(index);
                bsToDo.clear(index1);
            }
            if (!isAtropic) continue;
            break;
        }
    }

    private SimpleNode getLastCumuleneAtom(SimpleEdge bond, SimpleNode atom, int[] nSP2, SimpleNode[] parents) {
        SimpleNode atom2 = bond.getOtherNode(atom);
        if (parents != null) {
            parents[0] = atom2;
            parents[1] = atom;
        }
        if (nSP2 != null) {
            nSP2[0] = 2;
        }
        boolean ppt = false;
        block0: while (atom2.getCovalentBondCount() == 2) {
            SimpleNode atom3;
            SimpleEdge[] edges = atom2.getEdges();
            int i = edges.length;
            do {
                if (--i < 0) continue block0;
            } while ((atom3 = (bond = edges[i]).getOtherNode(atom2)) == atom);
            if (bond.getCovalentOrder() != 2) {
                return atom2;
            }
            if (parents != null) {
                if (!ppt) {
                    parents[0] = atom2;
                    ppt = true;
                }
                parents[1] = atom2;
            }
            if (nSP2 != null) {
                nSP2[0] = nSP2[0] + 1;
            }
            atom = atom2;
            atom2 = atom3;
        }
        return atom2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getAtomChiralityLimited(SimpleNode atom, CIPAtom cipAtom, SimpleNode parentAtom) {
        int rs = 0;
        try {
            boolean isAlkeneEndCheck;
            boolean bl = isAlkeneEndCheck = atom == null;
            if (isAlkeneEndCheck) {
                this.root = cipAtom;
                atom = this.root.atom;
                cipAtom.parent = new CIPAtom().create(parentAtom, null, true, false, false);
                cipAtom.htPathPoints = cipAtom.parent.htPathPoints;
            } else {
                this.root = cipAtom = new CIPAtom().create(atom, null, false, false, false);
                if (!cipAtom.isSP3) {
                    return 0;
                }
            }
            if (!cipAtom.setNode()) return rs;
            this.currentRule = 1;
            while (this.currentRule <= 9) {
                block20: {
                    this.rootRule = this.currentRule;
                    if (Logger.debugging) {
                        Logger.info((String)("-Rule " + this.getRuleName(this.currentRule) + " CIPChirality for " + cipAtom + "-----"));
                    }
                    switch (this.currentRule) {
                        case 4: {
                            cipAtom.createAuxiliaryDescriptors(null, null);
                            break;
                        }
                        case 5: {
                            if (cipAtom.rule4Type == 0) {
                                this.currentRule = 8;
                                break block20;
                            } else {
                                cipAtom.sortSubstituents(Integer.MIN_VALUE);
                                break;
                            }
                        }
                        case 6: 
                        case 7: {
                            cipAtom.sortSubstituents(Integer.MIN_VALUE);
                            break;
                        }
                        case 9: {
                            if (!cipAtom.setupRule6(false)) break block20;
                        }
                    }
                    int nPrioritiesPrev = cipAtom.nPriorities;
                    if (cipAtom.sortSubstituents(0)) {
                        if (Logger.debugging) {
                            Logger.info((String)(this.currentRule + ">>>>" + cipAtom));
                            for (int i = 0; i < cipAtom.bondCount; ++i) {
                                if (cipAtom.atoms[i] == null) continue;
                                Logger.info((String)(cipAtom.atoms[i] + " " + cipAtom.priorities[i]));
                            }
                        }
                        if (isAlkeneEndCheck) {
                            if (!cipAtom.atoms[0].isDuplicate) return 1;
                            return 2;
                        }
                        rs = cipAtom.checkHandedness();
                        if (this.currentRule == 8 && (cipAtom.nPriorities != 4 || nPrioritiesPrev != 2)) {
                            rs |= 8;
                        }
                        if (!Logger.debugging) return rs;
                        Logger.info((String)(atom + " " + JC.getCIPChiralityName((int)rs) + " by Rule " + this.getRuleName(this.currentRule) + "\n----------------------------------"));
                        return rs;
                    }
                }
                ++this.currentRule;
            }
            return rs;
        }
        catch (Throwable e) {
            System.out.println(e + " in CIPChirality " + this.currentRule);
            e.printStackTrace();
            return 3;
        }
    }

    private int getBondChiralityLimited(SimpleEdge bond, SimpleNode a) {
        if (Logger.debugging) {
            Logger.info((String)("get Bond Chirality " + bond));
        }
        if (a == null) {
            a = bond.getOtherNode(null);
        }
        if (this.couldBeChiralAlkene(a, bond.getOtherNode(a)) == -1) {
            return 0;
        }
        int[] nSP2 = new int[1];
        SimpleNode[] parents = new SimpleNode[2];
        SimpleNode b = this.getLastCumuleneAtom(bond, a, nSP2, parents);
        boolean isAxial = nSP2[0] % 2 == 1;
        return this.setBondChirality(a, parents[0], parents[1], b, isAxial);
    }

    private int setBondChirality(SimpleNode a, SimpleNode pa, SimpleNode pb, SimpleNode b, boolean isAxial) {
        int c;
        CIPAtom a1 = new CIPAtom().create(a, null, true, false, false);
        int atop = this.getAtomChiralityLimited(null, a1, pa) - 1;
        int ruleA = this.currentRule;
        CIPAtom b2 = new CIPAtom().create(b, null, true, false, false);
        int btop = this.getAtomChiralityLimited(null, b2, pb) - 1;
        int ruleB = this.currentRule;
        int n = c = atop >= 0 && btop >= 0 ? this.getEneChirality(b2.atoms[btop], b2, a1, a1.atoms[atop], isAxial, true) : 0;
        if (c != 0 && (isAxial || !this.bsAtropisomeric.get(a.getIndex()) && !this.bsAtropisomeric.get(b.getIndex()))) {
            if (isAxial && ruleA == 8 != (ruleB == 8)) {
                c |= 8;
            }
            a.setCIPChirality(c | ruleA - 1 << 5);
            b.setCIPChirality(c | ruleB - 1 << 5);
            if (Logger.debugging) {
                Logger.info((String)(a + "-" + b + " " + JC.getCIPChiralityName((int)c)));
            }
        }
        return c;
    }

    int getEneChirality(CIPAtom top1, CIPAtom end1, CIPAtom end2, CIPAtom top2, boolean isAxial, boolean allowPseudo) {
        return top1 == null || top2 == null || top1.atom == null || top2.atom == null ? 0 : (isAxial ? (this.isPos(top1, end1, end2, top2) ? 18 : 17) : (this.isCis(top1, end1, end2, top2) ? 5 : 6));
    }

    boolean isCis(CIPAtom a, CIPAtom b, CIPAtom c, CIPAtom d) {
        Measure.getNormalThroughPoints((T3)a.atom.getXYZ(), (T3)b.atom.getXYZ(), (T3)c.atom.getXYZ(), (T3)this.vNorm, (T3)this.vTemp);
        V3 vNorm2 = new V3();
        Measure.getNormalThroughPoints((T3)b.atom.getXYZ(), (T3)c.atom.getXYZ(), (T3)d.atom.getXYZ(), (T3)vNorm2, (T3)this.vTemp);
        return this.vNorm.dot((T3)vNorm2) > 0.0f;
    }

    boolean isPos(CIPAtom a, CIPAtom b, CIPAtom c, CIPAtom d) {
        float angle = Measure.computeTorsion((T3)a.atom.getXYZ(), (T3)b.atom.getXYZ(), (T3)c.atom.getXYZ(), (T3)d.atom.getXYZ(), (boolean)true);
        return angle > 0.0f;
    }

    private class CIPAtom
    implements Comparable<CIPAtom>,
    Cloneable {
        private int id;
        private int sphere;
        private int rootDistance;
        private int priority;
        private boolean isSet;
        boolean isDuplicate = true;
        private boolean isTerminal;
        private boolean isAlkene;
        SimpleNode atom;
        int atomIndex;
        int bondCount;
        private float elemNo;
        private float mass = -1.0f;
        CIPAtom parent;
        private int h1Count;
        CIPAtom[] atoms = new CIPAtom[4];
        private int nAtoms;
        private BS bsPath;
        private String myPath = "";
        int[] priorities = new int[4];
        int nPriorities;
        int nRootDuplicates;
        Map<Integer, Integer> htPathPoints;
        private CIPAtom alkeneParent;
        private CIPAtom alkeneChild;
        private boolean isAlkeneAtom2;
        private boolean isKekuleAmbiguous;
        private CIPAtom nextSP2;
        private boolean multipleBondDuplicate;
        private boolean isEvenEne = true;
        private int auxEZ = -1;
        boolean isSP3 = true;
        private char auxChirality = (char)126;
        private CIPAtom nextChiralBranch;
        private String[] rule4List;
        int rule4Type;
        private BS bsTemp = new BS();
        private boolean reverseRule2;
        int rule6refIndex = -1;
        private int rule4Ref;
        private CIPAtom[] newAtoms;
        private BS bsR;
        private BS bsS;
        private Lst<CIPAtom> rule4bQueue;

        CIPAtom() {
        }

        public boolean setupRule6(boolean isAux) {
            if (this.nPriorities > 2 || (isAux ? this.countDuplicates(this.atomIndex) : this.nRootDuplicates) <= 2) {
                return false;
            }
            CIPChirality.this.root.rule6refIndex = this.atoms[this.priorities[2]].atomIndex;
            this.sortSubstituents(Integer.MIN_VALUE);
            return true;
        }

        private int countDuplicates(int index) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] == null) continue;
                if (this.atoms[i].isDuplicate) {
                    if (this.atoms[i].atomIndex != index) continue;
                    ++n;
                    continue;
                }
                n += this.atoms[i].countDuplicates(index);
            }
            return n;
        }

        CIPAtom create(SimpleNode atom, CIPAtom parent, boolean isAlkene, boolean isDuplicate, boolean isParentBond) {
            this.id = ++CIPChirality.this.ptID;
            this.parent = parent;
            if (atom == null) {
                return this;
            }
            this.isAlkene = isAlkene;
            this.atom = atom;
            this.atomIndex = atom.getIndex();
            this.isKekuleAmbiguous = CIPChirality.this.bsKekuleAmbiguous != null && CIPChirality.this.bsKekuleAmbiguous.get(this.atomIndex);
            this.elemNo = isDuplicate && this.isKekuleAmbiguous ? parent.getKekuleElementNumber() : (float)atom.getElementNumber();
            this.bondCount = atom.getCovalentBondCount();
            boolean bl = this.isSP3 = this.bondCount == 4 || this.bondCount == 3 && !isAlkene && (this.elemNo > 10.0f || CIPChirality.this.bsAzacyclic != null && CIPChirality.this.bsAzacyclic.get(this.atomIndex));
            if (parent != null) {
                this.sphere = parent.sphere + 1;
            }
            if (this.sphere == 1) {
                this.htPathPoints = new Hashtable<Integer, Integer>();
            } else if (parent != null) {
                this.htPathPoints = (Map)((Hashtable)parent.htPathPoints).clone();
            }
            this.bsPath = parent == null ? new BS() : BSUtil.copy((BS)parent.bsPath);
            this.multipleBondDuplicate = isDuplicate;
            this.rootDistance = this.sphere;
            if (parent == null) {
                this.bsPath.set(this.atomIndex);
            } else if (!this.multipleBondDuplicate || (CIPChirality.this.rule1bOption != 4 || !this.isKekuleAmbiguous) && CIPChirality.this.rule1bOption != 2) {
                if (this.multipleBondDuplicate && CIPChirality.this.rule1bOption == 1) {
                    --this.rootDistance;
                } else if (atom == CIPChirality.this.root.atom) {
                    isDuplicate = true;
                    this.rootDistance = 0;
                    ++CIPChirality.this.root.nRootDuplicates;
                } else if (this.bsPath.get(this.atomIndex)) {
                    isDuplicate = true;
                    this.rootDistance = isParentBond ? parent.sphere : this.htPathPoints.get(this.atomIndex);
                } else {
                    this.bsPath.set(this.atomIndex);
                    this.htPathPoints.put(this.atomIndex, this.rootDistance);
                }
            }
            this.isDuplicate = isDuplicate;
            if (Logger.debuggingHigh) {
                if (this.sphere < 50) {
                    this.myPath = (parent != null ? parent.myPath + "-" : "") + this;
                }
                Logger.info((String)("new CIPAtom " + this.myPath));
            }
            return this;
        }

        private float getMass() {
            if (this.mass == -1.0f && (this.mass = this.atom.getMass()) == (float)((int)this.mass)) {
                if (this.isType(CIPChirality.RULE_2_nXX_REV_XX)) {
                    this.reverseRule2 = true;
                } else if (this.elemNo > 92.0f || this.isType(CIPChirality.RULE_2_nXX_EQ_XX)) {
                    this.mass = Elements.getAtomicMass((int)((int)this.elemNo));
                }
            }
            return this.mass;
        }

        private boolean isType(String rule2Type) {
            return PT.isOneOf((String)((int)this.mass + Elements.elementSymbolFromNumber((int)((int)this.elemNo))), (String)rule2Type);
        }

        private float getKekuleElementNumber() {
            SimpleEdge[] edges = this.atom.getEdges();
            float ave = 0.0f;
            int n = 0;
            int i = edges.length;
            while (--i >= 0) {
                SimpleNode other;
                SimpleEdge bond = edges[i];
                if (!bond.isCovalent() || !CIPChirality.this.bsKekuleAmbiguous.get((other = bond.getOtherNode(this.atom)).getIndex())) continue;
                ++n;
                ave += (float)other.getElementNumber();
            }
            return ave / (float)n;
        }

        void updateRingList() {
            BS bsRing = BSUtil.newAndSetBit((int)this.atomIndex);
            CIPAtom p = this;
            int index = -1;
            while ((p = p.parent) != null && index != this.atomIndex) {
                index = p.atomIndex;
                bsRing.set(index);
            }
            if (bsRing.cardinality() <= 7) {
                int i = CIPChirality.this.lstSmallRings.size();
                while (--i >= 0) {
                    if (!((BS)CIPChirality.this.lstSmallRings.get(i)).equals((Object)bsRing)) continue;
                    return;
                }
                CIPChirality.this.lstSmallRings.addLast((Object)bsRing);
            }
        }

        boolean setNode() {
            block19: {
                block18: {
                    if (this.isSet) break block18;
                    this.isSet = true;
                    if (!true || !this.isDuplicate) break block19;
                }
                return true;
            }
            SimpleEdge[] bonds = this.atom.getEdges();
            int nBonds = bonds.length;
            if (Logger.debuggingHigh) {
                Logger.info((String)("set " + this));
            }
            int pt = 0;
            block5: for (int i = 0; i < nBonds; ++i) {
                SimpleEdge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                SimpleNode other = bond.getOtherNode(this.atom);
                boolean isParentBond = this.parent != null && this.parent.atom == other;
                int order = bond.getCovalentOrder();
                if (order == 2) {
                    if (this.elemNo > 10.0f || !CIPChirality.this.isFirstRow(other)) {
                        order = 1;
                    } else {
                        this.isAlkene = true;
                        if (isParentBond) {
                            this.setEne();
                        }
                    }
                }
                if (nBonds == 1 && order == 1 && isParentBond) {
                    this.isTerminal = true;
                    return true;
                }
                switch (order) {
                    case 3: {
                        if (this.addAtom(pt++, other, isParentBond, false, isParentBond) == null) {
                            this.isTerminal = true;
                            return !true;
                        }
                    }
                    case 2: {
                        if (this.addAtom(pt++, other, order != 2 || isParentBond, order == 2, isParentBond) == null) {
                            this.isTerminal = true;
                            return !true;
                        }
                    }
                    case 1: {
                        if (isParentBond || this.addAtom(pt++, other, order != 1 && this.elemNo <= 10.0f, false, false) != null) continue block5;
                    }
                    default: {
                        this.isTerminal = true;
                        return !true;
                    }
                }
            }
            this.nAtoms = pt;
            while (pt < this.atoms.length) {
                this.atoms[pt] = new CIPAtom().create(null, this, false, true, false);
                ++pt;
            }
            Arrays.sort(this.atoms);
            return true;
        }

        private void setEne() {
            this.parent.alkeneChild = null;
            this.alkeneParent = this.parent.alkeneParent == null ? this.parent : this.parent.alkeneParent;
            this.alkeneParent.alkeneChild = this;
            this.nextSP2 = this.parent;
            if (this.parent.alkeneParent == null) {
                this.parent.nextSP2 = this;
            }
            if (this.atom.getCovalentBondCount() == 2 && this.atom.getValence() == 4) {
                this.parent.isAlkeneAtom2 = false;
                this.alkeneParent.isEvenEne = !this.alkeneParent.isEvenEne;
            } else {
                this.isAlkeneAtom2 = true;
            }
        }

        CIPAtom addAtom(int i, SimpleNode other, boolean isDuplicate, boolean isAlkene, boolean isParentBond) {
            if (i >= this.atoms.length) {
                if (Logger.debugging) {
                    Logger.info((String)(" too many bonds on " + this.atom));
                }
                return null;
            }
            if (this.parent == null && other.getIsotopeNumber() == 1 && ++this.h1Count > 1) {
                if (Logger.debuggingHigh) {
                    Logger.info((String)(" second H atom found on " + this.atom));
                }
                return null;
            }
            this.atoms[i] = new CIPAtom().create(other, this, isAlkene, isDuplicate, isParentBond);
            return this.atoms[i];
        }

        boolean sortSubstituents(int sphere) {
            int i;
            CIPAtom a;
            int i2;
            int i3;
            boolean ignoreTies;
            if (CIPChirality.this.currentRule != 99 && this.nPriorities == (sphere < 1 ? 4 : 3)) {
                return true;
            }
            boolean bl = ignoreTies = sphere == Integer.MIN_VALUE;
            if (ignoreTies) {
                if (this.isTerminal) {
                    return false;
                }
                switch (CIPChirality.this.currentRule) {
                    case 9: {
                        int i4;
                        for (i4 = 0; i4 < 4; ++i4) {
                            if (this.atoms[i4] == null || this.atoms[i4].isDuplicate || this.atoms[i4].atom == null || !this.atoms[i4].setNode()) continue;
                            this.atoms[i4].sortSubstituents(Integer.MIN_VALUE);
                        }
                        break;
                    }
                    case 5: 
                    case 7: {
                        int i4;
                        for (i4 = 0; i4 < 4; ++i4) {
                            if (this.rule4List[i4] == null || this.atoms[i4].atom == null || this.atoms[i4].isTerminal) continue;
                            this.atoms[i4].sortSubstituents(Integer.MIN_VALUE);
                        }
                        if (this.isSP3) break;
                        return false;
                    }
                }
            }
            ignoreTies |= CIPChirality.this.currentRule == 6 || CIPChirality.this.currentRule == 8;
            int[] indices = new int[4];
            int[] prevPriorities = new int[4];
            for (i3 = 0; i3 < 4; ++i3) {
                prevPriorities[i3] = this.priorities[i3];
                this.priorities[i3] = 0;
            }
            if (Logger.debuggingHigh) {
                Logger.info((String)(CIPChirality.this.root + "---sortSubstituents---" + this));
                for (i3 = 0; i3 < 4; ++i3) {
                    Logger.info((String)(CIPChirality.this.getRuleName(CIPChirality.this.currentRule) + ": " + this + "[" + i3 + "]=" + this.atoms[i3].myPath + " " + Integer.toHexString(prevPriorities[i3])));
                }
                Logger.info((String)("---" + this.nPriorities));
            }
            if (CIPChirality.this.currentRule == 99) {
                for (i2 = 0; i2 < 4; ++i2) {
                    a = this.atoms[i2];
                    if (a.isTerminal || a.atom == null || a.isDuplicate) continue;
                    a.sortSubstituents(sphere);
                }
            }
            for (i2 = 0; i2 < 4; ++i2) {
                a = this.atoms[i2];
                for (int j = i2 + 1; j < 4; ++j) {
                    int score;
                    int loser = j;
                    CIPAtom b = this.atoms[loser];
                    switch (a.atom == null ? 1 : (b.atom == null ? -1 : (prevPriorities[i2] < prevPriorities[j] ? -1 : (prevPriorities[j] < prevPriorities[i2] ? 1 : ((score = this.checkPriority(a, b, i2, j)) != 0 ? score : (ignoreTies ? Integer.MIN_VALUE : this.sign(a.breakTie(b, sphere + 1)))))))) {
                        case 1: {
                            int n = loser = i2;
                            this.priorities[n] = this.priorities[n] + 1;
                            break;
                        }
                        case -1: {
                            int n = loser;
                            this.priorities[n] = this.priorities[n] + 1;
                            break;
                        }
                    }
                    int n = loser;
                    indices[n] = indices[n] + 1;
                }
            }
            int[] newPriorities = new int[4];
            String[] newRule4List = this.rule4List == null ? null : new String[4];
            this.bsTemp.clearAll();
            this.newAtoms = new CIPAtom[4];
            for (i = 0; i < 4; ++i) {
                int pt = indices[i];
                CIPAtom a2 = this.newAtoms[pt] = this.atoms[i];
                newPriorities[pt] = this.priorities[i];
                if (this.rule4List != null) {
                    newRule4List[pt] = this.rule4List[i];
                }
                if (a2.atom == null) continue;
                this.bsTemp.set(this.priorities[i]);
            }
            if (CIPChirality.this.currentRule == 99) {
                this.priorities = prevPriorities;
                return false;
            }
            this.atoms = this.newAtoms;
            this.priorities = newPriorities;
            this.rule4List = newRule4List;
            this.nPriorities = this.bsTemp.cardinality();
            if (Logger.debuggingHigh && this.atoms[2].atom != null && this.atoms[2].elemNo != 1.0f) {
                Logger.info((String)(this.dots() + this.atom + " nPriorities = " + this.nPriorities));
                for (i = 0; i < 4; ++i) {
                    Logger.info((String)(this.dots() + this.myPath + "[" + i + "]=" + this.atoms[i] + " " + this.priorities[i] + " " + Integer.toHexString(this.priorities[i])));
                }
                Logger.info((String)(this.dots() + "-------" + this.nPriorities));
            }
            return this.nPriorities == this.bondCount;
        }

        private String dots() {
            return ".....................".substring(0, Math.min(20, this.sphere));
        }

        private int breakTie(CIPAtom b, int sphere) {
            if (this.isDuplicate && b.isDuplicate && this.atom == b.atom && this.rootDistance == b.rootDistance) {
                return 0;
            }
            int score = this.checkIsDuplicate(b);
            if (score != 0) {
                return score * (sphere + 1);
            }
            if (!this.setNode() || !b.setNode() || this.isTerminal && b.isTerminal || this.isDuplicate && b.isDuplicate) {
                return 0;
            }
            if (this.isTerminal != b.isTerminal) {
                return (this.isTerminal ? 1 : -1) * (sphere + 1);
            }
            score = this.compareShallowly(b, sphere);
            if (score != 0) {
                return score;
            }
            this.sortSubstituents(sphere);
            b.sortSubstituents(sphere);
            int finalScore = this.nAtoms == 0 ? 1 : 0;
            int absScore = Integer.MAX_VALUE;
            for (int i = 0; i < this.nAtoms; ++i) {
                int abs;
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                score = ai.breakTie(bi, sphere + 1);
                if (score == 0 || (abs = Math.abs(score)) >= absScore) continue;
                absScore = abs;
                finalScore = score;
            }
            return finalScore;
        }

        private int compareShallowly(CIPAtom b, int sphere) {
            block4: for (int i = 0; i < this.nAtoms; ++i) {
                CIPAtom ai = this.atoms[i];
                CIPAtom bi = b.atoms[i];
                int score = ai.checkCurrentRule(bi);
                switch (score) {
                    case -2147483648: {
                        if (CIPChirality.this.currentRule != 6) continue block4;
                        return Integer.MIN_VALUE;
                    }
                    case 0: {
                        continue block4;
                    }
                    default: {
                        return score * (sphere + 1);
                    }
                }
            }
            return 0;
        }

        @Override
        public int compareTo(CIPAtom b) {
            int score;
            int n = b == null ? -1 : (this.atom == null != (b.atom == null) ? (this.atom == null ? 1 : -1) : ((score = this.checkRule1a(b)) != 0 ? score : ((score = this.checkIsDuplicate(b)) != 0 ? score : (this.isDuplicate && (score = this.checkRule1b(b)) != 0 ? score : this.checkRule2(b)))));
            return n;
        }

        private int checkPriority(CIPAtom a, CIPAtom b, int i, int j) {
            int score;
            int n = a.atom == null != (b.atom == null) ? (a.atom == null ? 1 : -1) : ((score = a.checkCurrentRule(b)) == Integer.MIN_VALUE ? 0 : score);
            return n;
        }

        private int checkIsDuplicate(CIPAtom b) {
            return b.isDuplicate == this.isDuplicate ? 0 : (b.isDuplicate ? -1 : 1);
        }

        private boolean sortByRule(int rule) {
            int current = CIPChirality.this.currentRule;
            CIPChirality.this.currentRule = rule;
            int rule6ref = CIPChirality.this.root.rule6refIndex;
            if (rule == 9) {
                this.setupRule6(true);
            }
            boolean isChiral = this.sortSubstituents(0);
            CIPChirality.this.root.rule6refIndex = rule6ref;
            CIPChirality.this.currentRule = current;
            return isChiral;
        }

        private int checkCurrentRule(CIPAtom b) {
            switch (CIPChirality.this.currentRule) {
                default: {
                    return this.checkRule1a(b);
                }
                case 2: {
                    return this.checkRule1b(b);
                }
                case 3: {
                    return this.checkRule2(b);
                }
                case 4: {
                    return this.checkRule3(b);
                }
                case 5: {
                    return this.checkRules4ac(b, " sr SR PM");
                }
                case 6: {
                    return this.checkRule4b(b);
                }
                case 7: {
                    return this.checkRules4ac(b, " s r p m");
                }
                case 8: {
                    return this.checkRule5(b);
                }
                case 9: {
                    return this.checkRule6(b);
                }
                case 99: 
            }
            return this.rule4Type == b.rule4Type ? 0 : (this.rule4Type == CIPChirality.this.root.rule4Ref ? -1 : 1);
        }

        private int checkRule1a(CIPAtom b) {
            return b.atom == null ? -1 : (this.atom == null ? 1 : (b.elemNo < this.elemNo ? -1 : (b.elemNo > this.elemNo ? 1 : 0)));
        }

        private int checkRule1b(CIPAtom b) {
            return b.isDuplicate != this.isDuplicate ? 0 : (CIPChirality.this.rule1bOption == 3 && (this.parent.isAlkene || b.parent.isAlkene) ? 0 : Integer.compare(this.rootDistance, b.rootDistance));
        }

        private int checkRule2(CIPAtom b) {
            return b.getMass() == this.getMass() ? 0 : ((this.reverseRule2 || b.reverseRule2) == b.mass > this.mass ? -1 : 1);
        }

        private int checkRule3(CIPAtom b) {
            return this.isDuplicate || b.isDuplicate || !this.parent.isAlkeneAtom2 || !b.parent.isAlkeneAtom2 || !this.parent.alkeneParent.isEvenEne || !b.parent.alkeneParent.isEvenEne || this.parent == b.parent ? 0 : Integer.compare(this.parent.auxEZ, b.parent.auxEZ);
        }

        private int checkRules4ac(CIPAtom b, String test) {
            int isRb;
            if (this.isTerminal || this.isDuplicate) {
                return 0;
            }
            int isRa = test.indexOf(this.auxChirality);
            return isRa > (isRb = test.indexOf(b.auxChirality)) + 1 ? -1 : (isRb > isRa + 1 ? 1 : 0);
        }

        private int checkRule4b(CIPAtom b) {
            BS bsB;
            if (this.isTerminal || b.isTerminal) {
                return 0;
            }
            BS bsA = this.getBS4b();
            BS lu = this.compareLikeUnlike(bsA, bsB = b.getBS4b());
            return lu == null ? Integer.MIN_VALUE : (lu == bsA ? -1 : 1);
        }

        private BS compareLikeUnlike(BS bsA, BS bsB) {
            BS bsXOR = (BS)bsB.clone();
            bsXOR.xor(bsA);
            int l = bsXOR.nextSetBit(0);
            return l < 0 ? null : (bsA.get(l) ? bsA : bsB);
        }

        private BS getBS4b() {
            BS lu;
            if (this.bsR == null) {
                this.bsR = this.getBS4bBreadth(1);
            }
            if (this.bsS == null) {
                this.bsS = this.getBS4bBreadth(2);
            }
            return (lu = this.compareLikeUnlike(this.bsR, this.bsS)) == null ? this.bsR : lu;
        }

        private BS getBS4bBreadth(int rs) {
            CIPChirality.this.root.rule4Ref = rs;
            CIPChirality.this.currentRule = 99;
            this.sortSubstituents(0);
            BS bs = this.getBreadthBitSet(rs);
            CIPChirality.this.currentRule = 6;
            return bs;
        }

        private BS getBreadthBitSet(int rs) {
            Lst queue = CIPChirality.this.root.rule4bQueue;
            if (queue == null) {
                queue = CIPChirality.this.root.rule4bQueue = new Lst();
            } else {
                queue.clear();
            }
            int nrs = 0;
            queue.addLast((Object)this);
            BS bs = new BS();
            if (this.rule4Type == rs) {
                bs.set(0);
            }
            nrs = 1;
            while (queue.size() != 0) {
                CIPAtom next = (CIPAtom)queue.removeItemAt(0);
                CIPAtom[] atoms = next.newAtoms;
                if (atoms == null) {
                    atoms = next.atoms;
                }
                if (atoms == null) continue;
                for (int i = 0; i < 4; ++i) {
                    CIPAtom ai = atoms[i];
                    if (ai == null || ai.atom == null || ai.isTerminal || ai.isDuplicate) continue;
                    queue.addLast((Object)ai);
                    if (ai.rule4Type == rs) {
                        bs.set(nrs);
                    }
                    ++nrs;
                }
            }
            return bs;
        }

        private int checkRule5(CIPAtom b) {
            if (this.bsR == null || b.bsR == null) {
                return 0;
            }
            BS lu = this.compareLikeUnlike(this.bsR, b.bsR);
            return lu == null ? Integer.MIN_VALUE : (lu == this.bsR ? -1 : 1);
        }

        private int checkRule6(CIPAtom b) {
            return this.atomIndex == CIPChirality.this.root.rule6refIndex == (b.atomIndex == CIPChirality.this.root.rule6refIndex) ? 0 : (this.atomIndex == CIPChirality.this.root.rule6refIndex ? -1 : 1);
        }

        private int getAuxEneWinnerChirality(CIPAtom end1, CIPAtom end2, boolean isAxial, int[] retRule2) {
            CIPAtom winner1 = this.getAuxEneEndWinner(end1, end1.nextSP2, null);
            CIPAtom winner2 = winner1 == null || winner1.atom == null ? null : this.getAuxEneEndWinner(end2, end2.nextSP2, retRule2);
            return CIPChirality.this.getEneChirality(winner1, end1, end2, winner2, isAxial, false);
        }

        private CIPAtom getAuxEneEndWinner(CIPAtom end, CIPAtom prevSP2, int[] retRule) {
            CIPAtom atom1 = (CIPAtom)end.clone();
            if (atom1.parent != prevSP2) {
                atom1.addReturnPath(prevSP2, end);
            }
            atom1.rule4List = end.rule4List;
            for (int rule = 1; rule <= 9; ++rule) {
                if (!atom1.sortByRule(rule)) continue;
                for (int i = 0; i < 4; ++i) {
                    CIPAtom a = atom1.atoms[i];
                    if (a.multipleBondDuplicate || atom1.priorities[i] == atom1.priorities[i + 1]) continue;
                    if (retRule != null) {
                        retRule[0] = rule;
                    }
                    return a.atom == null ? null : a;
                }
            }
            return null;
        }

        private void addReturnPath(CIPAtom newParent, CIPAtom fromAtom) {
            Lst path = new Lst();
            CIPAtom thisAtom = this;
            CIPAtom oldParent = fromAtom;
            CIPAtom oldSub = newParent;
            while (oldParent.parent != null && oldParent.parent.atoms[0] != null) {
                if (Logger.debuggingHigh) {
                    Logger.info((String)("path:" + oldParent.parent + "->" + oldParent));
                }
                oldParent = oldParent.parent;
                path.addLast((Object)oldParent);
            }
            path.addLast(null);
            int n = path.size();
            for (int i = 0; i < n; ++i) {
                oldParent = (CIPAtom)path.get(i);
                CIPAtom newSub = oldParent == null ? new CIPAtom().create(null, this, this.isAlkene, true, false) : (CIPAtom)oldParent.clone();
                newSub.sphere = thisAtom.sphere + 1;
                thisAtom.replaceParentSubstituent(oldSub, newParent, newSub);
                if (i > 0 && thisAtom.isAlkene && !thisAtom.isAlkeneAtom2) {
                    if (newParent.isAlkeneAtom2) {
                        newParent.isAlkeneAtom2 = false;
                        thisAtom.alkeneParent = newParent;
                    }
                    thisAtom.setEne();
                }
                newParent = thisAtom;
                thisAtom = newSub;
                oldSub = fromAtom;
                fromAtom = oldParent;
            }
        }

        private void replaceParentSubstituent(CIPAtom oldSub, CIPAtom newParent, CIPAtom newSub) {
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] != oldSub && (newParent != null || this.atoms[i].atom != null)) continue;
                if (Logger.debuggingHigh) {
                    Logger.info((String)("reversed: " + newParent + "->" + this + "->" + newSub));
                }
                this.parent = newParent;
                this.atoms[i] = newSub;
                Arrays.sort(this.atoms);
                break;
            }
        }

        String createAuxiliaryDescriptors(CIPAtom node1, CIPAtom[] ret) {
            String retThread = "";
            int c = 126;
            if (this.atom == null) {
                return "" + (char)c;
            }
            this.rule4List = new String[4];
            this.setNode();
            int rs = -1;
            int nRS = 0;
            CIPAtom[] ret1 = new CIPAtom[1];
            boolean skipRules4And5 = false;
            boolean prevIsChiral = true;
            boolean allowTwoSame = !this.isAlkene && this.nPriorities == (node1 == null ? 2 : 1);
            for (int i = 0; i < 4; ++i) {
                CIPAtom a = this.atoms[i];
                if (a == null || a.isDuplicate || a.isTerminal) continue;
                a.priority = this.priorities[i];
                ret1[0] = null;
                String rsPath = a.createAuxiliaryDescriptors(node1 == null ? a : node1, ret1);
                if (ret1[0] != null) {
                    a.nextChiralBranch = ret1[0];
                    if (ret != null) {
                        ret[0] = ret1[0];
                    }
                }
                this.rule4List[i] = rsPath;
                if (a.nextChiralBranch != null || rsPath.indexOf("R") >= 0 || rsPath.indexOf("S") >= 0 || rsPath.indexOf("r") >= 0 || rsPath.indexOf("s") >= 0) {
                    ++nRS;
                    retThread = rsPath;
                    prevIsChiral = true;
                    continue;
                }
                if (!allowTwoSame && !prevIsChiral && this.priorities[i] == this.priorities[i - 1]) {
                    if (node1 == null) {
                        while (i >= 0) {
                            this.rule4List[i] = null;
                            --i;
                        }
                    }
                    return "~";
                }
                prevIsChiral = false;
            }
            boolean isBranch = nRS >= 2;
            switch (nRS) {
                case 0: {
                    retThread = "";
                }
                case 1: {
                    skipRules4And5 = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    c = 126;
                    retThread = "";
                    if (ret == null) break;
                    ret[0] = this;
                }
            }
            if (this.isAlkene) {
                if (!(this.alkeneChild == null || this.isEvenEne && (this.auxEZ != 7 && this.auxEZ != -1 || this.isKekuleAmbiguous || this.alkeneChild.bondCount < 2))) {
                    int[] rule2;
                    rs = this.getAuxEneWinnerChirality(this, this.alkeneChild, !this.isEvenEne, rule2 = this.isEvenEne ? new int[1] : null);
                    if (rs == 0) {
                        this.alkeneChild.auxEZ = 7;
                        this.auxEZ = 7;
                    } else if (rule2 != null && rule2[0] != 8) {
                        this.auxEZ = this.alkeneChild.auxEZ = rs;
                    } else if (!isBranch) {
                        switch (rs) {
                            case 5: 
                            case 17: {
                                rs = 1;
                                c = 82;
                                break;
                            }
                            case 6: 
                            case 18: {
                                rs = 2;
                                c = 83;
                            }
                        }
                        this.auxChirality = c;
                        this.rule4Type = rs;
                        retThread = "";
                        if (ret != null && ret[0] == this.alkeneChild) {
                            this.nextChiralBranch = this.alkeneChild;
                            ret[0] = this;
                        }
                    }
                }
            } else if (this.isSP3) {
                CIPAtom atom1 = (CIPAtom)this.clone();
                if (atom1.setNode()) {
                    int rule;
                    atom1.addReturnPath(null, this);
                    atom1.rule4List = new String[4];
                    block11: for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            if (atom1.atoms[i] != this.atoms[j]) continue;
                            atom1.rule4List[i] = this.rule4List[j];
                            continue block11;
                        }
                    }
                    for (rule = 1; rule <= 9 && (skipRules4And5 && rule >= 5 && rule <= 8 || !atom1.sortByRule(rule)); ++rule) {
                    }
                    if (rule > 9) {
                        c = 126;
                    } else {
                        rs = atom1.checkHandedness();
                        int n = rs == 1 ? 82 : (c = rs == 2 ? 83 : 126);
                        if (rule == 8) {
                            c = c == 82 ? 114 : (c == 83 ? 115 : 126);
                        } else {
                            this.rule4Type = rs;
                        }
                    }
                }
                this.auxChirality = (char)c;
            }
            if (CIPChirality.this.setAuxiliary && this.auxChirality != '~') {
                this.atom.setCIPChirality(JC.getCIPChiralityCode((char)this.auxChirality));
            }
            if (node1 == null) {
                this.rule4Type = nRS;
            }
            retThread = (char)c + retThread;
            if (Logger.debugging && !retThread.equals("~")) {
                Logger.info((String)("creating aux " + (char)c + " for " + this + " = " + this.myPath));
            }
            return retThread;
        }

        int checkHandedness() {
            P3 p1 = this.atoms[0].atom.getXYZ();
            P3 p2 = this.atoms[1].atom.getXYZ();
            P3 p3 = this.atoms[2].atom.getXYZ();
            Measure.getNormalThroughPoints((T3)p1, (T3)p2, (T3)p3, (T3)CIPChirality.this.vNorm, (T3)CIPChirality.this.vTemp);
            CIPChirality.this.vTemp.setT((T3)(this.atoms[3].atom == null ? this.atom : this.atoms[3].atom).getXYZ());
            CIPChirality.this.vTemp.sub((T3)p1);
            return CIPChirality.this.vTemp.dot((T3)CIPChirality.this.vNorm) > 0.0f ? 1 : 2;
        }

        public int sign(int score) {
            return score < 0 ? -1 : (score > 0 ? 1 : 0);
        }

        void addSmallRings(BS bs) {
            if (this.atom == null || this.sphere > 7) {
                return;
            }
            if (bs != null) {
                bs.clear(this.atom.getIndex());
            }
            if (this.isTerminal || this.isDuplicate || this.atom.getCovalentBondCount() > 4) {
                return;
            }
            int pt = 0;
            SimpleEdge[] bonds = this.atom.getEdges();
            int i = bonds.length;
            while (--i >= 0) {
                SimpleNode atom2;
                SimpleEdge bond = bonds[i];
                if (!bond.isCovalent() || (atom2 = bond.getOtherNode(this.atom)).getCovalentBondCount() == 1 || this.parent != null && atom2 == this.parent.atom) continue;
                CIPAtom r = this.addAtom(pt++, atom2, false, false, false);
                if (!r.isDuplicate) continue;
                r.updateRingList();
            }
            for (i = 0; i < pt; ++i) {
                if (this.atoms[i] == null) continue;
                this.atoms[i].addSmallRings(bs);
            }
        }

        public Object clone() {
            CIPAtom a = null;
            try {
                a = (CIPAtom)super.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            a.id = CIPChirality.this.ptID++;
            a.atoms = new CIPAtom[4];
            a.priorities = new int[4];
            a.htPathPoints = this.htPathPoints;
            a.alkeneParent = null;
            a.rule4List = null;
            a.rule4Type = 0;
            a.auxEZ = -1;
            a.priority = 0;
            a.bsS = null;
            a.bsR = null;
            for (int i = 0; i < 4; ++i) {
                if (this.atoms[i] == null) continue;
                a.atoms[i] = this.atoms[i];
            }
            return a;
        }

        public String toString() {
            return this.atom == null ? "<null>" : "[" + CIPChirality.this.currentRule + "." + this.sphere + "." + this.priority + "," + this.id + "." + this.atom.getAtomName() + (this.isDuplicate ? "*(" + this.rootDistance + ")" : "") + (this.auxChirality == '~' ? "" : "" + this.auxChirality) + "]";
        }
    }
}

