/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DialogsToggleAction
extends ToggleAction {
    private boolean toolbarPreviouslyVisible;
    private boolean sideToolbarPreviouslyVisible;

    public DialogsToggleAction() {
        super(I18n.tr("Toggle dialogs panel", new Object[0]), (ImageProvider)null, I18n.tr("Toggle dialogs panel, maximize mapview", new Object[0]), Shortcut.registerShortcut("menu:view:dialogspanel", I18n.tr("Toggle dialogs panel", new Object[0]), 9, 5003), true, "dialogspanel", false);
        this.putValue("help", HelpUtil.ht("/ToggleDialogs"));
        this.setSelected(Main.pref.getBoolean("draw.dialogspanel", true));
        this.notifySelectedState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState(actionEvent);
        Main.pref.put("draw.dialogspanel", this.isSelected());
        this.notifySelectedState();
        this.setMode();
    }

    protected void setMode() {
        if (MainApplication.isDisplayingMapView()) {
            boolean bl = this.isSelected();
            if (!bl) {
                this.toolbarPreviouslyVisible = Main.pref.getBoolean("toolbar.visible", true);
                this.sideToolbarPreviouslyVisible = Main.pref.getBoolean("sidetoolbar.visible", true);
            }
            MapFrame mapFrame = MainApplication.getMap();
            mapFrame.setDialogsPanelVisible(bl);
            mapFrame.statusLine.setVisible(bl || Main.pref.getBoolean("statusbar.always-visible", true));
            MainApplication.getMenu().setVisible(bl || Main.pref.getBoolean("menu.always-visible", true));
            if (!(Main.pref.getBoolean("toolbar.always-visible", true) || bl && !this.toolbarPreviouslyVisible)) {
                Main.pref.put("toolbar.visible", bl);
            }
            if (!(Main.pref.getBoolean("sidetoolbar.always-visible", true) || bl && !this.sideToolbarPreviouslyVisible)) {
                Main.pref.put("sidetoolbar.visible", bl);
            }
            mapFrame.mapView.rememberLastPositionOnScreen();
        }
    }
}

