/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public final class DistributeAction
extends JosmAction {
    public DistributeAction() {
        super(I18n.tr("Distribute Nodes", new Object[0]), "distribute", I18n.tr("Distribute the selected nodes to equal distances along a line.", new Object[0]), Shortcut.registerShortcut("tools:distribute", I18n.tr("Tool: {0}", I18n.tr("Distribute Nodes", new Object[0])), 66, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/DistributeNodes"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        void var6_9;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        LinkedList<Way> linkedList = new LinkedList<Way>();
        HashSet<Node> hashSet = new HashSet<Node>();
        for (OsmPrimitive object2 : collection) {
            if (object2 instanceof Node) {
                hashSet.add((Node)object2);
                continue;
            }
            if (!(object2 instanceof Way)) continue;
            linkedList.add((Way)object2);
        }
        Set<Node> set = DistributeAction.removeNodesWithoutCoordinates(hashSet);
        if (!set.isEmpty()) {
            Logging.warn(I18n.tr("Ignoring {0} nodes with null coordinates", set.size()));
            set.clear();
        }
        if (DistributeAction.checkDistributeWay(linkedList, hashSet)) {
            Collection<Command> collection2 = DistributeAction.distributeWay(linkedList, hashSet);
        } else if (DistributeAction.checkDistributeNodes(linkedList, hashSet).booleanValue()) {
            Collection<Command> collection3 = DistributeAction.distributeNodes(hashSet);
        } else {
            new Notification(I18n.tr("Please select :\n* One no self-crossing way with at most two of its nodes;\n* Three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        if (var6_9.isEmpty()) {
            return;
        }
        MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Distribute Nodes", new Object[0]), (Collection<Command>)var6_9));
    }

    private static boolean checkDistributeWay(Collection<Way> collection, Collection<Node> collection2) {
        if (collection.size() == 1 && collection2.size() <= 2) {
            Way way = collection.iterator().next();
            HashSet<Node> hashSet = new HashSet<Node>(way.getNodes());
            if (hashSet.size() != way.getNodesCount()) {
                return false;
            }
            for (Node node : collection2) {
                if (way.containsNode(node)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Collection<Command> distributeWay(Collection<Way> collection, Collection<Node> collection2) {
        Object object;
        Node node;
        double d;
        double d2;
        double d3;
        double d4;
        Node node2;
        Object object2;
        Way way = collection.iterator().next();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        if (way.getNodesCount() == collection2.size() || way.getNodesCount() <= 2) {
            return linkedList;
        }
        if (collection2.isEmpty()) {
            object2 = way.firstNode();
            collection2.add((Node)object2);
            node2 = way.lastNode();
            collection2.add(node2);
            d4 = object2.getEastNorth().east();
            d3 = object2.getEastNorth().north();
            d2 = (node2.getEastNorth().east() - d4) / (double)(way.getNodesCount() - 1);
            d = (node2.getEastNorth().north() - d3) / (double)(way.getNodesCount() - 1);
        } else if (collection2.size() == 1) {
            object2 = collection2.iterator().next();
            int n = way.getNodes().indexOf(object2);
            node = way.firstNode();
            object = way.lastNode();
            d2 = (object.getEastNorth().east() - node.getEastNorth().east()) / (double)(way.getNodesCount() - 1);
            d = (object.getEastNorth().north() - node.getEastNorth().north()) / (double)(way.getNodesCount() - 1);
            d4 = object2.getEastNorth().east() - d2 * (double)n;
            d3 = object2.getEastNorth().north() - d * (double)n;
        } else {
            object2 = collection2.iterator();
            node2 = (Node)object2.next();
            node = (Node)object2.next();
            object = way.getNodes();
            int n = object.indexOf(node2);
            int n2 = object.indexOf(node);
            d2 = (node.getEastNorth().east() - node2.getEastNorth().east()) / (double)(n2 - n);
            d = (node.getEastNorth().north() - node2.getEastNorth().north()) / (double)(n2 - n);
            d4 = node2.getEastNorth().east() - d2 * (double)n;
            d3 = node2.getEastNorth().north() - d * (double)n;
        }
        for (int i = 0; i < way.getNodesCount(); ++i) {
            node2 = way.getNode(i);
            if (!node2.isLatLonKnown() || collection2.contains(node2)) continue;
            double d5 = d4 + (double)i * d2;
            double d6 = d3 + (double)i * d;
            linkedList.add(new MoveCommand((OsmPrimitive)node2, d5 - node2.getEastNorth().east(), d6 - node2.getEastNorth().north()));
        }
        return linkedList;
    }

    private static Boolean checkDistributeNodes(Collection<Way> collection, Collection<Node> collection2) {
        return collection.isEmpty() && collection2.size() >= 3;
    }

    private static Collection<Command> distributeNodes(Collection<Node> collection) {
        double d;
        double d2 = Double.NEGATIVE_INFINITY;
        ILatLon iLatLon = null;
        ILatLon iLatLon2 = null;
        LinkedList<Node> linkedList = new LinkedList<Node>(collection);
        for (Node node : collection) {
            linkedList.remove(node);
            for (Node node2 : linkedList) {
                d = Math.sqrt(node.getEastNorth().distance(node2.getEastNorth()));
                if (!(d > d2)) continue;
                iLatLon = node;
                iLatLon2 = node2;
                d2 = d;
            }
        }
        if (iLatLon == null || iLatLon2 == null) {
            throw new IllegalArgumentException();
        }
        collection.remove(iLatLon);
        collection.remove(iLatLon2);
        double d3 = iLatLon.getEastNorth().east();
        double d4 = iLatLon.getEastNorth().north();
        d = iLatLon2.getEastNorth().east();
        double d5 = iLatLon2.getEastNorth().north();
        LinkedList<Command> linkedList2 = new LinkedList<Command>();
        int n = collection.size() + 1;
        int n2 = 0;
        while (!collection.isEmpty()) {
            double d6;
            ++n2;
            ILatLon iLatLon3 = null;
            d2 = Double.NEGATIVE_INFINITY;
            for (Node node : collection) {
                d6 = Math.sqrt(iLatLon2.getEastNorth().distance(node.getEastNorth()));
                if (!(d6 > d2)) continue;
                iLatLon3 = node;
                d2 = d6;
            }
            if (iLatLon3 == null) continue;
            double d7 = d3 - iLatLon3.getEastNorth().east() + (d - d3) * (double)n2 / (double)n;
            d6 = d4 - iLatLon3.getEastNorth().north() + (d5 - d4) * (double)n2 / (double)n;
            linkedList2.add(new MoveCommand((OsmPrimitive)((Object)iLatLon3), d7, d6));
            collection.remove(iLatLon3);
        }
        return linkedList2;
    }

    private static Set<Node> removeNodesWithoutCoordinates(Collection<Node> collection) {
        HashSet<Node> hashSet = new HashSet<Node>();
        Iterator<Node> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (node.isLatLonKnown()) continue;
            iterator.remove();
            hashSet.add(node);
        }
        return hashSet;
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

