/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadGpsTask
extends AbstractDownloadTask<GpxData> {
    private DownloadTask downloadTask;
    private GpxLayer gpxLayer;
    protected String newLayerName;

    @Override
    public String[] getPatterns() {
        return (String[])Arrays.stream(OsmServerLocationReader.GpxUrlPattern.values()).map(OsmServerLocationReader.GpxUrlPattern::pattern).toArray(String[]::new);
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download GPS", new Object[0]);
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, new BoundingBoxDownloader(bounds), progressMonitor);
        return MainApplication.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Optional<String> optional = Stream.of(OsmServerLocationReader.GpxUrlPattern.USER_TRACE_ID, OsmServerLocationReader.GpxUrlPattern.EDIT_TRACE_ID).map(gpxUrlPattern -> Pattern.compile(gpxUrlPattern.pattern()).matcher(string)).filter(Matcher::matches).map(matcher -> "https://www.openstreetmap.org/trace/" + matcher.group(2) + "/data").findFirst();
        if (optional.isPresent()) {
            return this.loadUrl(bl, optional.get(), progressMonitor);
        }
        if (Stream.of(OsmServerLocationReader.GpxUrlPattern.TRACE_ID, OsmServerLocationReader.GpxUrlPattern.EXTERNAL_GPX_SCRIPT, OsmServerLocationReader.GpxUrlPattern.EXTERNAL_GPX_FILE).anyMatch(gpxUrlPattern -> string.matches(gpxUrlPattern.pattern()))) {
            this.downloadTask = new DownloadTask(bl, new OsmServerLocationReader(string), progressMonitor);
            Matcher matcher2 = Pattern.compile(OsmServerLocationReader.GpxUrlPattern.EXTERNAL_GPX_FILE.pattern()).matcher(string);
            this.newLayerName = matcher2.matches() ? matcher2.group(1) : null;
            return MainApplication.worker.submit(this.downloadTask);
        }
        if (string.matches(OsmServerLocationReader.GpxUrlPattern.TRACKPOINTS_BBOX.pattern())) {
            String[] stringArray = string.split("\\?|=|&");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"bbox".equals(stringArray[i]) || i >= stringArray.length - 1) continue;
                return this.download(bl, new Bounds(stringArray[i + 1], ",", Bounds.ParseMethod.LEFT_BOTTOM_RIGHT_TOP), progressMonitor);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public ProjectionBounds getDownloadProjectionBounds() {
        return this.gpxLayer != null ? this.gpxLayer.getViewProjectionBounds() : null;
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        return null;
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private final OsmServerReader reader;
        private GpxData rawData;
        private final boolean newLayer;

        DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data", new Object[0]), progressMonitor, false);
            this.reader = osmServerReader;
            this.newLayer = bl;
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                this.rawData = this.reader.parseRawGps(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (OsmTransferException osmTransferException) {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                DownloadGpsTask.this.rememberException(osmTransferException);
            }
        }

        @Override
        protected void finish() {
            DownloadGpsTask.this.rememberDownloadedData(this.rawData);
            if (this.rawData == null) {
                return;
            }
            String string = DownloadGpsTask.this.newLayerName != null ? DownloadGpsTask.this.newLayerName : I18n.tr("Downloaded GPX Data", new Object[0]);
            GpxImporter.GpxImporterData gpxImporterData = GpxImporter.loadLayers(this.rawData, this.reader.isGpxParsedProperly(), string, I18n.tr("Markers from {0}", string));
            DownloadGpsTask.this.gpxLayer = gpxImporterData.getGpxLayer();
            this.addOrMergeLayer(DownloadGpsTask.this.gpxLayer, this.findGpxMergeLayer());
            this.addOrMergeLayer(gpxImporterData.getMarkerLayer(), this.findMarkerMergeLayer(DownloadGpsTask.this.gpxLayer));
            gpxImporterData.getPostLayerTask().run();
        }

        private <L extends Layer> L addOrMergeLayer(L l, L l2) {
            if (l == null) {
                return null;
            }
            if (this.newLayer || l2 == null) {
                MainApplication.getLayerManager().addLayer(l, DownloadGpsTask.this.zoomAfterDownload);
                return l;
            }
            l2.mergeFrom(l);
            l2.invalidate();
            MapFrame mapFrame = MainApplication.getMap();
            if (mapFrame != null && DownloadGpsTask.this.zoomAfterDownload && l instanceof GpxLayer) {
                mapFrame.mapView.scheduleZoomTo(new ViewportData(l.getViewProjectionBounds()));
            }
            return l2;
        }

        private GpxLayer findGpxMergeLayer() {
            boolean bl = Main.pref.getBoolean("download.gps.mergeWithLocal", false);
            Layer layer = MainApplication.getLayerManager().getActiveLayer();
            if (layer instanceof GpxLayer && (bl || ((GpxLayer)layer).data.fromServer)) {
                return (GpxLayer)layer;
            }
            for (GpxLayer gpxLayer : MainApplication.getLayerManager().getLayersOfType(GpxLayer.class)) {
                if (!bl && !gpxLayer.data.fromServer) continue;
                return gpxLayer;
            }
            return null;
        }

        private MarkerLayer findMarkerMergeLayer(GpxLayer gpxLayer) {
            for (MarkerLayer markerLayer : MainApplication.getLayerManager().getLayersOfType(MarkerLayer.class)) {
                if (gpxLayer == null || markerLayer.fromLayer != gpxLayer) continue;
                return markerLayer;
            }
            return null;
        }

        @Override
        protected void cancel() {
            DownloadGpsTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        public ProgressTaskId canRunInBackground() {
            return ProgressTaskIds.DOWNLOAD_GPS;
        }
    }
}

