/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.tools.I18n;

public class ValidatorPrefHelper
extends SourcePrefHelper {
    public static final ValidatorPrefHelper INSTANCE = new ValidatorPrefHelper();
    public static final String PREFIX = "validator";
    public static final BooleanProperty PREF_LAYER = new BooleanProperty("validator.layer", true);
    public static final String PREF_SKIP_TESTS = "validator.skip";
    public static final BooleanProperty PREF_USE_IGNORE = new BooleanProperty("validator.ignore", true);
    public static final String PREF_SKIP_TESTS_BEFORE_UPLOAD = "validator.skipBeforeUpload";
    public static final BooleanProperty PREF_OTHER_UPLOAD = new BooleanProperty("validator.otherUpload", false);
    public static final BooleanProperty PREF_OTHER = new BooleanProperty("validator.other", false);
    public static final String PREF_FILTER_BY_SELECTION = "validator.selectionFilter";

    public ValidatorPrefHelper() {
        super(MapCSSTagChecker.ENTRIES_PREF_KEY);
    }

    @Override
    public Collection<ExtendedSourceEntry> getDefault() {
        ArrayList<ExtendedSourceEntry> arrayList = new ArrayList<ExtendedSourceEntry>();
        ValidatorPrefHelper.addDefault(arrayList, "addresses", I18n.tr("Addresses", new Object[0]), I18n.tr("Checks for errors on addresses", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "combinations", I18n.tr("Tag combinations", new Object[0]), I18n.tr("Checks for missing tag or suspicious combinations", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "deprecated", I18n.tr("Deprecated features", new Object[0]), I18n.tr("Checks for deprecated features", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "geometry", I18n.tr("Geometry", new Object[0]), I18n.tr("Checks for geometry errors", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "highway", I18n.tr("Highways", new Object[0]), I18n.tr("Checks for errors on highways", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "multiple", I18n.tr("Multiple values", new Object[0]), I18n.tr("Checks for wrong multiple values", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "numeric", I18n.tr("Numeric values", new Object[0]), I18n.tr("Checks for wrong numeric values", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "religion", I18n.tr("Religion", new Object[0]), I18n.tr("Checks for errors on religious objects", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "relation", I18n.tr("Relations", new Object[0]), I18n.tr("Checks for errors on relations", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "territories", I18n.tr("Territories", new Object[0]), I18n.tr("Checks for territories-specific features", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "unnecessary", I18n.tr("Unnecessary tags", new Object[0]), I18n.tr("Checks for unnecessary tags", new Object[0]));
        ValidatorPrefHelper.addDefault(arrayList, "wikipedia", I18n.tr("Wikipedia", new Object[0]), I18n.tr("Checks for wrong wikipedia tags", new Object[0]));
        return arrayList;
    }

    private static void addDefault(List<ExtendedSourceEntry> list, String string, String string2, String string3) {
        ExtendedSourceEntry extendedSourceEntry = new ExtendedSourceEntry(string + ".mapcss", "resource://data/validator/" + string + ".mapcss");
        extendedSourceEntry.title = string2;
        extendedSourceEntry.description = string3;
        list.add(extendedSourceEntry);
    }

    @Override
    public Map<String, String> serialize(SourceEntry sourceEntry) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("url", sourceEntry.url);
        hashMap.put("title", sourceEntry.title == null ? "" : sourceEntry.title);
        hashMap.put("active", Boolean.toString(sourceEntry.active));
        return hashMap;
    }

    @Override
    public SourceEntry deserialize(Map<String, String> map) {
        return new SourceEntry(map.get("url"), null, map.get("title"), Boolean.parseBoolean(map.get("active")));
    }
}

