/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ValidatorErrorWriter
extends XmlWriter {
    public ValidatorErrorWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    public ValidatorErrorWriter(OutputStream outputStream) {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8))));
    }

    public void write(Collection<TestError> collection) {
        Set set = collection.stream().map(TestError::getTester).collect(Collectors.toCollection(TreeSet::new));
        String string = DateUtils.fromDate(new Date());
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.println("<analysers generator='JOSM' timestamp='" + string + "'>");
        OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(this.out, true, "0.6");
        String string2 = LanguageInfo.getJOSMLocaleCode();
        for (Test test : set) {
            ArrayList arrayList;
            Object object;
            this.out.println("  <analyser timestamp='" + string + "' name='" + XmlWriter.encode(test.getName()) + "'>");
            HashMap hashMap = new HashMap();
            for (Map.Entry<Severity, Map<String, Map<String, List<TestError>>>> entry : OsmValidator.getErrorsBySeverityMessageDescription(collection, testError -> testError.getTester() == test).entrySet()) {
                for (Map.Entry<String, Map<String, List<TestError>>> entry2 : entry.getValue().entrySet()) {
                    object = new ErrorClass(entry.getKey(), entry2.getKey());
                    arrayList = (ArrayList)hashMap.get(object);
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                        hashMap.put(object, arrayList);
                    }
                    entry2.getValue().values().stream().forEach(arrayList::addAll);
                }
            }
            for (ErrorClass errorClass : hashMap.keySet()) {
                this.out.println("    <class id='" + errorClass.id + "' level='" + errorClass.severity.getLevel() + "'>");
                this.out.println("      <classtext lang='" + XmlWriter.encode(string2) + "' title='" + XmlWriter.encode(errorClass.message) + "'/>");
                this.out.println("    </class>");
            }
            for (Map.Entry<Severity, Map<String, Map<String, List<TestError>>>> entry : hashMap.entrySet()) {
                for (TestError testError2 : (List)((Object)entry.getValue())) {
                    object = testError2.getPrimitives().iterator().next().getBBox().getCenter();
                    this.out.println("    <error class='" + ((ErrorClass)((Object)entry.getKey())).id + "'>");
                    this.out.print("      <location");
                    osmWriter.writeLatLon((LatLon)object);
                    this.out.println("/>");
                    for (OsmPrimitive osmPrimitive : testError2.getPrimitives()) {
                        osmPrimitive.accept(osmWriter);
                    }
                    this.out.println("      <text lang='" + XmlWriter.encode(string2) + "' value='" + XmlWriter.encode(testError2.getDescription()) + "'/>");
                    if (testError2.isFixable()) {
                        this.out.println("      <fixes>");
                        arrayList = testError2.getFix();
                        if (arrayList instanceof AddPrimitivesCommand) {
                            Logging.info("TODO: {0}", arrayList);
                        } else if (arrayList instanceof DeleteCommand) {
                            Logging.info("TODO: {0}", arrayList);
                        } else if (arrayList instanceof ChangePropertyCommand) {
                            Logging.info("TODO: {0}", arrayList);
                        } else if (arrayList instanceof ChangePropertyKeyCommand) {
                            Logging.info("TODO: {0}", arrayList);
                        } else {
                            Logging.warn("Unsupported command type: {0}", arrayList);
                        }
                        this.out.println("      </fixes>");
                    }
                    this.out.println("    </error>");
                }
            }
            this.out.println("  </analyser>");
        }
        this.out.println("</analysers>");
        this.out.flush();
    }

    private static class ErrorClass {
        static int idCounter;
        final Severity severity;
        final String message;
        final int id;

        ErrorClass(Severity severity, String string) {
            this.severity = severity;
            this.message = string;
            this.id = ++idCounter;
        }
    }
}

