/*! elasticsearch - v13.0.1 - 2017-05-09
 * http://www.elastic.co/guide/en/elasticsearch/client/javascript-api/current/index.html
 * Copyright (c) 2017 Elasticsearch BV; Licensed Apache-2.0 */

;(function () {
/* prevent lodash from detecting external amd loaders */var define; 
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/* global jQuery */
	(function ($) {
	  process.jquery_build = true;
	  var es = __webpack_require__(2);

	  function defer() {
	    var def = $.Deferred();
	    // def.promise is usually a property (in normal implementations)
	    // we override the promise to keep things working
	    def.promise = def.promise();
	    return def;
	  }

	  $.es = $.extend({}, es);
	  $.es.Client = function (config) {
	    config = config || {};
	    config.defer = defer;
	    config.$ = $;
	    return new es.Client(config);
	  };

	}(jQuery));

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ },
/* 1 */
/***/ function(module, exports) {

	// shim for using process in browser
	var process = module.exports = {};

	// cached from whatever global is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.

	var cachedSetTimeout;
	var cachedClearTimeout;

	function defaultSetTimout() {
	    throw new Error('setTimeout has not been defined');
	}
	function defaultClearTimeout () {
	    throw new Error('clearTimeout has not been defined');
	}
	(function () {
	    try {
	        if (typeof setTimeout === 'function') {
	            cachedSetTimeout = setTimeout;
	        } else {
	            cachedSetTimeout = defaultSetTimout;
	        }
	    } catch (e) {
	        cachedSetTimeout = defaultSetTimout;
	    }
	    try {
	        if (typeof clearTimeout === 'function') {
	            cachedClearTimeout = clearTimeout;
	        } else {
	            cachedClearTimeout = defaultClearTimeout;
	        }
	    } catch (e) {
	        cachedClearTimeout = defaultClearTimeout;
	    }
	} ())
	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    // if setTimeout wasn't available but was latter defined
	    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
	        cachedSetTimeout = setTimeout;
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }


	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    // if clearTimeout wasn't available but was latter defined
	    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
	        cachedClearTimeout = clearTimeout;
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }



	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;

	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}

	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;

	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}

	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	};

	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};

	function noop() {}

	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;

	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};

	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	// In order to help people who were accidentally upgraded to this ES client,
	// throw an error when they try to instanciate the exported function.
	// previous "elasticsearch" module -> https://github.com/ncb000gt/node-es
	function es() {
	  throw new Error('Looks like you are expecting the previous "elasticsearch" module. ' +
	    'It is now the "es" module. To create a client with this module use ' +
	    '`new es.Client(params)`.');
	}

	es.Client = __webpack_require__(3);
	es.ConnectionPool = __webpack_require__(34);
	es.Transport = __webpack_require__(4);
	es.errors = __webpack_require__(18);

	module.exports = es;


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * A client that makes requests to Elasticsearch via a {{#crossLink "Transport"}}Transport{{/crossLink}}
	 *
	 * Initializing a client might look something like:
	 *
	 * ```
	 * var client = new es.Client({
	 *   hosts: [
	 *     'es1.net:9200',
	 *     {
	 *       host: 'es2.net',
	 *       port: 9200
	 *     }
	 *   ],
	 *   sniffOnStart: true,
	 *   log: {
	 *     type: 'file',
	 *     level: 'warning'
	 *   }
	 * });
	 * ```
	 *
	 * @class Client
	 * @constructor
	 */

	module.exports = Client;

	var Transport = __webpack_require__(4);
	var clientAction = __webpack_require__(47);
	var _ = __webpack_require__(5);

	function Client(config) {
	  config = config || {};

	  if (config.__reused) {
	    throw new Error('Do not reuse objects to configure the elasticsearch Client class: ' +
	      'https://github.com/elasticsearch/elasticsearch-js/issues/33');
	  } else {
	    config.__reused = true;
	  }

	  function EsApiClient() {
	    // our client will log minimally by default
	    if (!config.hasOwnProperty('log')) {
	      config.log = 'warning';
	    }

	    if (!config.hosts && !config.host) {
	      config.host = 'http://localhost:9200';
	    }

	    this.close = function () {
	      this.transport.close();
	    };

	    this.transport = new Transport(config);

	    _.each(EsApiClient.prototype, _.bind(function (Fn, prop) {
	      if (Fn.prototype instanceof clientAction.ApiNamespace) {
	        this[prop] = new Fn(this.transport, this);
	      }
	    }, this));

	    delete this._namespaces;
	  }


	  EsApiClient.prototype = _.funcEnum(config, 'apiVersion', Client.apis, '_default');
	  if (!config.sniffEndpoint && EsApiClient.prototype === Client.apis['0.90']) {
	    config.sniffEndpoint = '/_cluster/nodes';
	  }

	  var Constructor = EsApiClient;

	  if (config.plugins) {
	    Constructor.prototype = _.cloneDeep(Constructor.prototype);

	    _.each(config.plugins, function (setup) {
	      Constructor = setup(Constructor, config, {
	        apis: __webpack_require__(48),
	        connectors: __webpack_require__(38),
	        loggers: __webpack_require__(31),
	        selectors: __webpack_require__(35),
	        serializers: __webpack_require__(43),
	        Client: __webpack_require__(3),
	        clientAction: clientAction,
	        Connection: __webpack_require__(41),
	        ConnectionPool: __webpack_require__(34),
	        Errors: __webpack_require__(18),
	        Host: __webpack_require__(19),
	        Log: __webpack_require__(29),
	        Logger: __webpack_require__(33),
	        NodesToHost: __webpack_require__(46),
	        Transport: __webpack_require__(4),
	        utils: __webpack_require__(5)
	      }) || Constructor;
	    });
	  }

	  return new Constructor();
	}

	Client.apis = __webpack_require__(48);


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Class that manages making request, called by all of the API methods.
	 * @type {[type]}
	 */
	module.exports = Transport;

	var _ = __webpack_require__(5);
	var errors = __webpack_require__(18);
	var Host = __webpack_require__(19);
	var patchSniffOnConnectionFault = __webpack_require__(26);
	var findCommonProtocol = __webpack_require__(27);

	function Transport(config) {
	  var self = this;
	  config = self._config = config || {};

	  var LogClass = (typeof config.log === 'function') ? config.log : __webpack_require__(29);
	  config.log = self.log = new LogClass(config);

	  // setup the connection pool
	  var ConnectionPool = _.funcEnum(config, 'connectionPool', Transport.connectionPools, 'main');
	  self.connectionPool = new ConnectionPool(config);

	  // setup the serializer
	  var Serializer = _.funcEnum(config, 'serializer', Transport.serializers, 'json');
	  self.serializer = new Serializer(config);

	  // setup the nodesToHostCallback
	  self.nodesToHostCallback = _.funcEnum(config, 'nodesToHostCallback', Transport.nodesToHostCallbacks, 'main');

	  // setup max retries
	  self.maxRetries = config.hasOwnProperty('maxRetries') ? config.maxRetries : 3;

	  // setup endpoint to use for sniffing
	  self.sniffEndpoint = config.hasOwnProperty('sniffEndpoint') ? config.sniffEndpoint : '/_nodes/_all/http';

	  // setup requestTimeout default
	  self.requestTimeout = config.hasOwnProperty('requestTimeout') ? config.requestTimeout : 30000;

	  if (config.hasOwnProperty('defer')) {
	    self.defer = config.defer;
	  }

	  // randomizeHosts option
	  var randomizeHosts = config.hasOwnProperty('randomizeHosts') ? !!config.randomizeHosts : true;

	  if (config.host) {
	    config.hosts = config.host;
	  }

	  if (config.hosts) {
	    var hostsConfig = _.createArray(config.hosts, function (val) {
	      if (_.isPlainObject(val) || _.isString(val) || val instanceof Host) {
	        return val;
	      }
	    });

	    if (!hostsConfig) {
	      throw new TypeError('Invalid hosts config. Expected a URL, an array of urls, a host config object, ' +
	        'or an array of host config objects.');
	    }

	    if (randomizeHosts) {
	      hostsConfig = _.shuffle(hostsConfig);
	    }

	    self.setHosts(hostsConfig);
	  }

	  if (config.hasOwnProperty('sniffedNodesProtocol')) {
	    self.sniffedNodesProtocol = config.sniffedNodesProtocol || null;
	  } else {
	    self.sniffedNodesProtocol = findCommonProtocol(self.connectionPool.getAllHosts()) || null;
	  }

	  if (config.sniffOnStart) {
	    self.sniff();
	  }

	  if (config.sniffInterval) {
	    self._timeout(function doSniff() {
	      self.sniff();
	      self._timeout(doSniff, config.sniffInterval);
	    }, config.sniffInterval);
	  }

	  if (config.sniffOnConnectionFault) {
	    patchSniffOnConnectionFault(self);
	  }
	}

	Transport.connectionPools = {
	  main: __webpack_require__(34)
	};

	Transport.serializers = __webpack_require__(43);

	Transport.nodesToHostCallbacks = {
	  main: __webpack_require__(46)
	};

	Transport.prototype.defer = function () {
	  if (typeof Promise === 'undefined') {
	    throw new Error(
	      'No Promise implementation found. In order for elasticsearch-js to create promises ' +
	      'either specify the `defer` configuration or include a global Promise shim'
	    )
	  }

	  var defer = {};
	  defer.promise = new Promise(function (resolve, reject) {
	    defer.resolve = resolve;
	    defer.reject = reject;
	  });
	  return defer;
	};

	/**
	 * Perform a request with the client's transport
	 *
	 * @method request
	 * @todo async body writing
	 * @todo abort
	 * @todo access to custom headers, modifying of request in general
	 * @param {object} params
	 * @param {Number} params.requestTimeout - timeout for the entire request (inculding all retries)
	 * @param {Number} params.maxRetries - number of times to re-run request if the
	 *   original node chosen can not be connected to.
	 * @param {string} [params.path="/"] - URL pathname. Do not include query string.
	 * @param {string|object} [params.query] - Query string.
	 * @param {String} params.method - The HTTP method for the request
	 * @param {String} params.body - The body of the HTTP request
	 * @param {Function} cb - A function to call back with (error, responseBody, responseStatus)
	 */
	Transport.prototype.request = function (params, cb) {
	  var self = this;
	  var remainingRetries = this.maxRetries;
	  var requestTimeout = this.requestTimeout;

	  var connection; // set in sendReqWithConnection
	  var aborted = false; // several connector will respond with an error when the request is aborted
	  var requestAborter; // an abort function, returned by connection#request()
	  var requestTimeoutId; // the id of the ^timeout
	  var ret; // the object returned to the user, might be a promise
	  var defer; // the defer object, will be set when we are using promises.

	  var body = params.body;
	  var headers = !params.headers ? {} : _.transform(params.headers, function (headers, val, name) {
	    headers[String(name).toLowerCase()] = val;
	  });

	  self.log.debug('starting request', params);

	  // determine the response based on the presense of a callback
	  if (typeof cb === 'function') {
	    // handle callbacks within a domain
	    if (process.domain) {
	      cb = process.domain.bind(cb);
	    }
	    ret = {
	      abort: abortRequest
	    };
	  } else {
	    defer = this.defer();
	    ret = defer.promise;
	    ret.abort = abortRequest;
	  }

	  if (body && params.method === 'GET') {
	    _.nextTick(respond, new TypeError('Body can not be sent with method "GET"'));
	    return ret;
	  }

	  // serialize the body
	  if (body) {
	    var serializer = self.serializer;
	    var serializeFn = serializer[params.bulkBody ? 'bulkBody' : 'serialize'];

	    body = serializeFn.call(serializer, body);
	    if (!headers['content-type']) {
	      headers['content-type'] = serializeFn.contentType;
	    }
	  }

	  if (params.hasOwnProperty('maxRetries')) {
	    remainingRetries = params.maxRetries;
	  }

	  if (params.hasOwnProperty('requestTimeout')) {
	    requestTimeout = params.requestTimeout;
	  }

	  params.req = {
	    method: params.method,
	    path: params.path || '/',
	    query: params.query,
	    body: body,
	    headers: headers
	  };

	  function sendReqWithConnection(err, _connection) {
	    if (aborted) {
	      return;
	    }

	    if (err) {
	      respond(err);
	    } else if (_connection) {
	      connection = _connection;
	      requestAborter = connection.request(params.req, checkRespForFailure);
	    } else {
	      self.log.warning('No living connections');
	      respond(new errors.NoConnections());
	    }
	  }

	  function checkRespForFailure(err, body, status, headers) {
	    if (aborted) {
	      return;
	    }

	    requestAborter = void 0;

	    if (err instanceof errors.RequestTypeError) {
	      self.log.error('Connection refused to execute the request', err);
	      respond(err, body, status, headers);
	      return;
	    }

	    if (err) {
	      connection.setStatus('dead');

	      var errMsg = err.message || '';

	      errMsg =
	        '\n' +
	        params.req.method +
	        ' ' +
	        connection.host.makeUrl(params.req) +
	        (errMsg.length ? ' => ' : '') +
	        errMsg
	      ;

	      if (remainingRetries) {
	        remainingRetries--;
	        self.log.error('Request error, retrying' + errMsg);
	        self.connectionPool.select(sendReqWithConnection);
	      } else {
	        self.log.error('Request complete with error' + errMsg);
	        respond(new errors.ConnectionFault(err));
	      }
	    } else {
	      self.log.debug('Request complete');
	      respond(void 0, body, status, headers);
	    }
	  }

	  function respond(err, body, status, headers) {
	    if (aborted) {
	      return;
	    }

	    self._timeout(requestTimeoutId);
	    var parsedBody;
	    var isJson = !headers || (headers['content-type'] && ~headers['content-type'].indexOf('application/json'));

	    if (!err && body) {
	      if (isJson) {
	        parsedBody = self.serializer.deserialize(body);
	        if (parsedBody == null) {
	          err = new errors.Serialization();
	          parsedBody = body;
	        }
	      } else {
	        parsedBody = body;
	      }
	    }

	    // does the response represent an error?
	    if (
	      (!err || err instanceof errors.Serialization)
	      && (status < 200 || status >= 300)
	      && (!params.ignore || !_.include(params.ignore, status))
	    ) {

	      var errorMetadata = _.pick(params.req, ['path', 'query', 'body']);
	      errorMetadata.statusCode = status;
	      errorMetadata.response = body;

	      if (status === 401 && headers && headers['www-authenticate']) {
	        errorMetadata.wwwAuthenticateDirective = headers['www-authenticate'];
	      }

	      if (errors[status]) {
	        err = new errors[status](parsedBody && parsedBody.error, errorMetadata);
	      } else {
	        err = new errors.Generic('unknown error', errorMetadata);
	      }
	    }

	    // can we cast notfound to false?
	    if (params.castExists) {
	      if (err && err instanceof errors.NotFound) {
	        parsedBody = false;
	        err = void 0;
	      } else {
	        parsedBody = !err;
	      }
	    }

	    // how do we send the response?
	    if (typeof cb === 'function') {
	      if (err) {
	        cb(err, parsedBody, status);
	      } else {
	        cb(void 0, parsedBody, status);
	      }
	    } else if (err) {
	      err.body = parsedBody;
	      err.status = status;
	      defer.reject(err);
	    } else {
	      defer.resolve(parsedBody);
	    }
	  }

	  function abortRequest() {
	    if (aborted) {
	      return;
	    }

	    aborted = true;
	    remainingRetries = 0;
	    self._timeout(requestTimeoutId);
	    if (typeof requestAborter === 'function') {
	      requestAborter();
	    }
	  }

	  if (requestTimeout && requestTimeout !== Infinity) {
	    requestTimeoutId = this._timeout(function () {
	      respond(new errors.RequestTimeout('Request Timeout after ' + requestTimeout + 'ms'));
	      abortRequest();
	    }, requestTimeout);
	  }

	  if (connection) {
	    sendReqWithConnection(void 0, connection);
	  } else {
	    self.connectionPool.select(sendReqWithConnection);
	  }

	  return ret;
	};

	Transport.prototype._timeout = function (cb, delay) {
	  if (this.closed) return;

	  var id;
	  var timers = this._timers || (this._timers = []);

	  if ('function' !== typeof cb) {
	    id = cb;
	    cb = void 0;
	  }

	  if (cb) {
	    // set the timer
	    id = setTimeout(function () {
	      _.pull(timers, id);
	      cb();
	    }, delay);

	    timers.push(id);
	    return id;
	  }

	  if (id) {
	    clearTimeout(id);

	    var i = this._timers.indexOf(id);
	    if (i !== -1) {
	      this._timers.splice(i, 1);
	    }
	  }
	};

	/**
	 * Ask an ES node for a list of all the nodes, add/remove nodes from the connection
	 * pool as appropriate
	 *
	 * @param  {Function} cb - Function to call back once complete
	 */
	Transport.prototype.sniff = function (cb) {
	  var self = this;
	  var nodesToHostCallback = this.nodesToHostCallback;
	  var log = this.log;
	  var sniffedNodesProtocol = this.sniffedNodesProtocol;

	  // make cb a function if it isn't
	  cb = typeof cb === 'function' ? cb : _.noop;

	  this.request({
	    path: this.sniffEndpoint,
	    query: {
	      filter_path: [
	        'nodes.*.http.publish_address',
	        'nodes.*.name',
	        'nodes.*.hostname',
	        'nodes.*.host',
	        'nodes.*.version',
	      ].join(','),
	    },
	    method: 'GET'
	  }, function (err, resp, status) {
	    if (!err && resp && resp.nodes) {
	      var hostsConfigs;

	      try {
	        hostsConfigs = nodesToHostCallback(resp.nodes);
	      } catch (e) {
	        log.error(new Error('Unable to convert node list from ' + this.sniffEndpoint +
	          ' to hosts durring sniff. Encountered error:\n' + (e.stack || e.message)));
	        return;
	      }

	      _.forEach(hostsConfigs, function (hostConfig) {
	        if (sniffedNodesProtocol) hostConfig.protocol = sniffedNodesProtocol;
	      });

	      self.setHosts(hostsConfigs);
	    }
	    cb(err, resp, status);
	  });
	};

	/**
	 * Set the host list that the transport should use.
	 *
	 * @param {Array<HostConfig>} hostsConfigs - an array of Hosts, or configuration objects
	 *                                         that will be used to create Host objects.
	 */
	Transport.prototype.setHosts = function (hostsConfigs) {
	  var globalConfig = this._config;
	  this.connectionPool.setHosts(_.map(hostsConfigs, function (conf) {
	    return (conf instanceof Host) ? conf : new Host(conf, globalConfig);
	  }));
	};

	/**
	 * Close the Transport, which closes the logs and connection pool
	 * @return {[type]} [description]
	 */
	Transport.prototype.close = function () {
	  this.log.close();
	  this.closed = true;
	  _.each(this._timers, clearTimeout);
	  this._timers = null;
	  this.connectionPool.close();
	};

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process, Buffer) {var path = __webpack_require__(10);
	var nodeUtils = __webpack_require__(11);
	var lodash = __webpack_require__(14);

	/**
	 * Custom utils library, basically a modified version of [lodash](http://lodash.com/docs) +
	 * [node.utils](http://nodejs.org/api/util.html#util_util) that doesn't use mixins to prevent
	 * confusion when requiring lodash itself.
	 *
	 * @class utils
	 * @static
	 */
	var _ = lodash.assign({}, lodash, nodeUtils);

	/**
	 * Link to [path.join](http://nodejs.org/api/path.html#path_path_join_path1_path2)
	 *
	 * @method _.joinPath
	 * @type {function}
	 */
	_.joinPath = path.join;

	_.get = __webpack_require__(16);
	_.trimEnd = __webpack_require__(17);

	/**
	 * Recursively merge two objects, walking into each object and concating arrays. If both to and from have a value at a
	 * key, but the values' types don't match to's value is left unmodified. Only Array and Object values are merged - that
	 * it to say values with a typeof "object"
	 *
	 * @param  {Object} to - Object to merge into (no cloning, the original object
	 *   is modified)
	 * @param  {Object} from - Object to pull changed from
	 * @return {Object} - returns the modified to value
	 */
	_.deepMerge = function (to, from) {
	  _.each(from, function (fromVal, key) {
	    switch (typeof to[key]) {
	      case 'undefined':
	        to[key] = from[key];
	        break;
	      case 'object':
	        if (_.isArray(to[key]) && _.isArray(from[key])) {
	          to[key] = to[key].concat(from[key]);
	        }
	        else if (_.isPlainObject(to[key]) && _.isPlainObject(from[key])) {
	          _.deepMerge(to[key], from[key]);
	        }
	    }
	  });
	  return to;
	};

	/**
	 * Test if a value is an array and it's contents are of a specific type
	 *
	 * @method isArrayOf<Strings|Object|Array|Finite|Function|RegExp>s
	 * @param  {Array} arr - An array to check
	 * @return {Boolean}
	 */
	_.each([
	  'String',
	  'Object',
	  'PlainObject',
	  'Array',
	  'Finite',
	  'Function',
	  'RegExp'
	], function (type) {
	  var check = _['is' + type];

	  _['isArrayOf' + type + 's'] = function (arr) {
	    // quick shallow check of arrays
	    return _.isArray(arr) && _.every(arr.slice(0, 10), check);
	  };
	});


	/**
	 * Capitalize the first letter of a word
	 *
	 * @method  ucfirst
	 * @param  {string} word - The word to transform
	 * @return {string}
	 */
	_.ucfirst = function (word) {
	  return word[0].toUpperCase() + word.substring(1).toLowerCase();
	};

	/**
	 * Base algo for studlyCase and camelCase
	 * @param  {boolean} firstWordCap - Should the first character of the first word be capitalized
	 * @return {Function}
	 */
	function adjustWordCase(firstWordCap, otherWordsCap, sep) {
	  return function (string) {
	    var i = 0;
	    var words = [];
	    var word = '';
	    var code, c, upper, lower;

	    for (; i < string.length; i++) {
	      code = string.charCodeAt(i);
	      c = string.charAt(i);
	      lower = (code >= 97 && code <= 122) || (code >= 48 && code <= 57);
	      upper = code >= 65 && code <= 90;

	      if (upper || !lower) {
	        // new word
	        if (word.length) {
	          words.push(word);
	        }
	        word = '';
	      }

	      if (upper || lower) {
	        if (lower && word.length) {
	          word += c;
	        } else {
	          if ((!words.length && firstWordCap) || (words.length && otherWordsCap)) {
	            word = c.toUpperCase();
	          }
	          else {
	            word = c.toLowerCase();
	          }
	        }
	      }
	    }
	    if (word.length) {
	      words.push(word);
	    }
	    // add the leading underscore back to strings the had it originally
	    if (words.length && string.charAt(0) === '_') {
	      words[0] = '_' + words[0];
	    }
	    return words.join(sep);
	  };
	}

	/**
	 * Transform a string into StudlyCase
	 *
	 * @method studlyCase
	 * @param  {String} string
	 * @return {String}
	 */
	_.studlyCase = adjustWordCase(true, true, '');

	/**
	 * Transform a string into camelCase
	 *
	 * @method camelCase
	 * @param  {String} string
	 * @return {String}
	 */
	_.camelCase = adjustWordCase(false, true, '');

	/**
	 * Transform a string into snakeCase
	 *
	 * @method snakeCase
	 * @param  {String} string
	 * @return {String}
	 */
	_.snakeCase = adjustWordCase(false, false, '_');

	/**
	 * Lower-case a string, and return an empty string if any is not a string
	 *
	 * @param any {*} - Something or nothing
	 * @returns {string}
	 */
	_.toLowerString = function (any) {
	  if (any) {
	    if (typeof any !== 'string') {
	      any = any.toString();
	    }
	  } else {
	    any = '';
	  }
	  return any.toLowerCase();
	};

	/**
	 * Upper-case the string, return an empty string if any is not a string
	 *
	 * @param any {*} - Something or nothing
	 * @returns {string}
	 */
	_.toUpperString = function (any) {
	  if (any) {
	    if (typeof any !== 'string') {
	      any = any.toString();
	    }
	  } else {
	    any = '';
	  }
	  return any.toUpperCase();
	};

	/**
	 * Test if a value is "numeric" meaning that it can be transformed into something besides NaN
	 *
	 * @method isNumeric
	 * @param  {*} val
	 * @return {Boolean}
	 */
	_.isNumeric = function (val) {
	  return typeof val !== 'object' && val - parseFloat(val) >= 0;
	};

	// regexp to test for intervals
	var intervalRE = /^(\d+(?:\.\d+)?)(M|w|d|h|m|s|y|ms)$/;

	/**
	 * Test if a string represents an interval (eg. 1m, 2Y)
	 *
	 * @method isInterval
	 * @param {String} val
	 * @return {Boolean}
	 */
	_.isInterval = function (val) {
	  return !!(val.match && val.match(intervalRE));
	};

	/**
	 * Repeat a string n times
	 *
	 * @todo TestPerformance
	 * @method repeat
	 * @param {String} what - The string to repeat
	 * @param {Number} times - Times the string should be repeated
	 * @return {String}
	 */
	_.repeat = function (what, times) {
	  return (new Array(times + 1)).join(what);
	};

	/**
	 * Call a function, applying the arguments object to it in an optimized way, rather than always turning it into an array
	 *
	 * @param func {Function} - The function to execute
	 * @param context {*} - The context the function will be executed with
	 * @param args {Arguments} - The arguments to send to func
	 * @param [sliceIndex=0] {Integer} - The index that args should be sliced at, before feeding args to func
	 * @returns {*} - the return value of func
	 */
	_.applyArgs = function (func, context, args, sliceIndex) {
	  sliceIndex = sliceIndex || 0;
	  switch (args.length - sliceIndex) {
	    case 0:
	      return func.call(context);
	    case 1:
	      return func.call(context, args[0 + sliceIndex]);
	    case 2:
	      return func.call(context, args[0 + sliceIndex], args[1 + sliceIndex]);
	    case 3:
	      return func.call(context, args[0 + sliceIndex], args[1 + sliceIndex], args[2 + sliceIndex]);
	    case 4:
	      return func.call(context, args[0 + sliceIndex], args[1 + sliceIndex], args[2 + sliceIndex], args[3 + sliceIndex]);
	    case 5:
	      return func.call(context, args[0 + sliceIndex], args[1 + sliceIndex],
	      args[2 + sliceIndex], args[3 + sliceIndex], args[4 + sliceIndex]);
	    default:
	      return func.apply(context, Array.prototype.slice.call(args, sliceIndex));
	  }
	};

	/**
	 * Schedule a function to be called on the next tick, and supply it with these arguments
	 * when it is called.
	 * @return {[type]} [description]
	 */
	_.nextTick = function (cb) {
	  // bind the function and schedule it
	  process.nextTick(_.bindKey(_, 'applyArgs', cb, null, arguments, 1));
	};

	/**
	 * Marks a method as a handler. Currently this just makes a property on the method
	 * flagging it to be bound to the object at object creation when "makeBoundMethods" is called
	 *
	 * ```
	 * ClassName.prototype.methodName = _.handler(function () {
	 *   // this will always be bound when called via classInstance.bound.methodName
	 *   this === classInstance
	 * });
	 * ```
	 *
	 * @alias _.scheduled
	 * @param  {Function} func - The method that is being defined
	 * @return {Function}
	 */
	_.handler = function (func) {
	  func._provideBound = true;
	  return func;
	};
	_.scheduled = _.handler;

	/**
	 * Creates an "bound" property on an object, which all or a subset of methods from
	 * the object which are bound to the original object.
	 *
	 * ```
	 * var obj = {
	 *   onEvent: function () {}
	 * };
	 *
	 * _.makeBoundMethods(obj);
	 *
	 * obj.bound.onEvent() // is bound to obj, and can safely be used as an event handler.
	 * ```
	 *
	 * @param {Object} obj - The object to bind the methods to
	 */
	_.makeBoundMethods = function (obj) {
	  obj.bound = {};
	  for (var prop in obj) {
	    // dearest maintainer, we want to look through the prototype
	    if (typeof obj[prop] === 'function' && obj[prop]._provideBound === true) {
	      obj.bound[prop] = _.bind(obj[prop], obj);
	    }
	  }
	};

	_.noop = function () {};

	/**
	 * Implements the standard "string or constructor" check that I was copy/pasting everywhere
	 * @param  {String|Function} val - the value that the user passed in
	 * @param  {Object} opts - a map of the options
	 * @return {Function|undefined} - If a valid option was specified, then the constructor is returned
	 */
	_.funcEnum = function (config, name, opts, def) {
	  var val = config[name];
	  switch (typeof val) {
	    case 'undefined':
	      return opts[def];
	    case 'function':
	      return val;
	    case 'string':
	      if (opts.hasOwnProperty(val)) {
	        return opts[val];
	      }
	    /* falls through */
	    default:
	      var err = 'Invalid ' + name + ' "' + val + '", expected a function';
	      switch (_.size(opts)) {
	        case 0:
	          break;
	        case 1:
	          err += ' or ' + _.keys(opts)[0];
	          break;
	        default:
	          err += ' or one of ' + _.keys(opts).join(', ');
	          break;
	      }
	      throw new TypeError(err);
	  }
	};

	/**
	 * Accepts any object and attempts to convert it into an array. If the object passed in is not
	 * an array it will be wrapped in one. Then the transform/map function will be called for each element
	 * and create a new array that is returned. If the map function fails to return something, the loop is
	 * halted and false is returned instead of an array.
	 *
	 * @param  {*} input - The value to convert
	 * @param  {Function} transform - A function called for each element of the resulting array
	 * @return {Array|false} - an array on success, or false on failure.
	 */
	_.createArray = function (input, transform) {
	  transform = typeof transform === 'function' ? transform : _.identity;
	  var output = [];
	  var item;
	  var i;

	  if (!_.isArray(input)) {
	    input = [input];
	  }

	  for (i = 0; i < input.length; i++) {
	    item = transform(input[i]);
	    if (item === void 0) {
	      return false;
	    } else {
	      output.push(item);
	    }
	  }
	  return output;
	};

	/**
	 * Takes a WritableStream, and returns the chunks that have not successfully written, returning them as a string.
	 *
	 * ONLY WORKS FOR TEXT STREAMS
	 *
	 * @param  {WritableStream} stream - an instance of stream.Writable
	 * @return {string} - the remaining test to be written to the stream
	 */
	_.getUnwrittenFromStream = function (stream) {
	  var writeBuffer = _.getStreamWriteBuffer(stream);
	  if (!writeBuffer) return;

	  // flush the write buffer
	  var out = '';
	  if (!writeBuffer.length) return out;

	  _.each(writeBuffer, function (writeReq) {
	    if (writeReq.chunk) {
	      // 0.9.12+ uses WriteReq objects with a chunk prop
	      out += '' + writeReq.chunk;
	    } else if (_.isArray(writeReq) && (typeof writeReq[0] === 'string' || Buffer.isBuffer(writeReq[0]))) {
	      // 0.9.4 - 0.9.9 buffers are arrays of arrays like [[chunk, cb], [chunk, undef], ...].
	      out += '' + writeReq[0];
	    } else {
	      return false;
	    }
	  });
	  return out;
	};

	_.getStreamWriteBuffer = function (stream) {
	  if (!stream || !stream._writableState) return;

	  var writeState = stream._writableState;

	  if (writeState.getBuffer) {
	    return writeState.getBuffer();
	  } else if (writeState.buffer) {
	    return writeState.buffer;
	  }
	};

	_.clearWriteStreamBuffer = function (stream) {
	  var buffer = _.getStreamWriteBuffer(stream);
	  return buffer && buffer.splice(0);
	};

	/**
	 * return the current time in milliseconds since epoch
	 */
	_.now = function () {
	  return (typeof Date.now === 'function') ? Date.now() : (new Date()).getTime();
	};

	module.exports = _;

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1), __webpack_require__(6).Buffer))

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {/*!
	 * The buffer module from node.js, for the browser.
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */
	/* eslint-disable no-proto */

	'use strict'

	var base64 = __webpack_require__(7)
	var ieee754 = __webpack_require__(8)
	var isArray = __webpack_require__(9)

	exports.Buffer = Buffer
	exports.SlowBuffer = SlowBuffer
	exports.INSPECT_MAX_BYTES = 50

	/**
	 * If `Buffer.TYPED_ARRAY_SUPPORT`:
	 *   === true    Use Uint8Array implementation (fastest)
	 *   === false   Use Object implementation (most compatible, even IE6)
	 *
	 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
	 * Opera 11.6+, iOS 4.2+.
	 *
	 * Due to various browser bugs, sometimes the Object implementation will be used even
	 * when the browser supports typed arrays.
	 *
	 * Note:
	 *
	 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
	 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
	 *
	 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
	 *
	 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
	 *     incorrect length in some situations.

	 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
	 * get the Object implementation, which is slower but behaves correctly.
	 */
	Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
	  ? global.TYPED_ARRAY_SUPPORT
	  : typedArraySupport()

	/*
	 * Export kMaxLength after typed array support is determined.
	 */
	exports.kMaxLength = kMaxLength()

	function typedArraySupport () {
	  try {
	    var arr = new Uint8Array(1)
	    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
	    return arr.foo() === 42 && // typed array instances can be augmented
	        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
	        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
	  } catch (e) {
	    return false
	  }
	}

	function kMaxLength () {
	  return Buffer.TYPED_ARRAY_SUPPORT
	    ? 0x7fffffff
	    : 0x3fffffff
	}

	function createBuffer (that, length) {
	  if (kMaxLength() < length) {
	    throw new RangeError('Invalid typed array length')
	  }
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = new Uint8Array(length)
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    if (that === null) {
	      that = new Buffer(length)
	    }
	    that.length = length
	  }

	  return that
	}

	/**
	 * The Buffer constructor returns instances of `Uint8Array` that have their
	 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
	 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
	 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
	 * returns a single octet.
	 *
	 * The `Uint8Array` prototype remains unmodified.
	 */

	function Buffer (arg, encodingOrOffset, length) {
	  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
	    return new Buffer(arg, encodingOrOffset, length)
	  }

	  // Common case.
	  if (typeof arg === 'number') {
	    if (typeof encodingOrOffset === 'string') {
	      throw new Error(
	        'If encoding is specified then the first argument must be a string'
	      )
	    }
	    return allocUnsafe(this, arg)
	  }
	  return from(this, arg, encodingOrOffset, length)
	}

	Buffer.poolSize = 8192 // not used by this implementation

	// TODO: Legacy, not needed anymore. Remove in next major version.
	Buffer._augment = function (arr) {
	  arr.__proto__ = Buffer.prototype
	  return arr
	}

	function from (that, value, encodingOrOffset, length) {
	  if (typeof value === 'number') {
	    throw new TypeError('"value" argument must not be a number')
	  }

	  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
	    return fromArrayBuffer(that, value, encodingOrOffset, length)
	  }

	  if (typeof value === 'string') {
	    return fromString(that, value, encodingOrOffset)
	  }

	  return fromObject(that, value)
	}

	/**
	 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
	 * if value is a number.
	 * Buffer.from(str[, encoding])
	 * Buffer.from(array)
	 * Buffer.from(buffer)
	 * Buffer.from(arrayBuffer[, byteOffset[, length]])
	 **/
	Buffer.from = function (value, encodingOrOffset, length) {
	  return from(null, value, encodingOrOffset, length)
	}

	if (Buffer.TYPED_ARRAY_SUPPORT) {
	  Buffer.prototype.__proto__ = Uint8Array.prototype
	  Buffer.__proto__ = Uint8Array
	  if (typeof Symbol !== 'undefined' && Symbol.species &&
	      Buffer[Symbol.species] === Buffer) {
	    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
	    Object.defineProperty(Buffer, Symbol.species, {
	      value: null,
	      configurable: true
	    })
	  }
	}

	function assertSize (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be a number')
	  } else if (size < 0) {
	    throw new RangeError('"size" argument must not be negative')
	  }
	}

	function alloc (that, size, fill, encoding) {
	  assertSize(size)
	  if (size <= 0) {
	    return createBuffer(that, size)
	  }
	  if (fill !== undefined) {
	    // Only pay attention to encoding if it's a string. This
	    // prevents accidentally sending in a number that would
	    // be interpretted as a start offset.
	    return typeof encoding === 'string'
	      ? createBuffer(that, size).fill(fill, encoding)
	      : createBuffer(that, size).fill(fill)
	  }
	  return createBuffer(that, size)
	}

	/**
	 * Creates a new filled Buffer instance.
	 * alloc(size[, fill[, encoding]])
	 **/
	Buffer.alloc = function (size, fill, encoding) {
	  return alloc(null, size, fill, encoding)
	}

	function allocUnsafe (that, size) {
	  assertSize(size)
	  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) {
	    for (var i = 0; i < size; ++i) {
	      that[i] = 0
	    }
	  }
	  return that
	}

	/**
	 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
	 * */
	Buffer.allocUnsafe = function (size) {
	  return allocUnsafe(null, size)
	}
	/**
	 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
	 */
	Buffer.allocUnsafeSlow = function (size) {
	  return allocUnsafe(null, size)
	}

	function fromString (that, string, encoding) {
	  if (typeof encoding !== 'string' || encoding === '') {
	    encoding = 'utf8'
	  }

	  if (!Buffer.isEncoding(encoding)) {
	    throw new TypeError('"encoding" must be a valid string encoding')
	  }

	  var length = byteLength(string, encoding) | 0
	  that = createBuffer(that, length)

	  var actual = that.write(string, encoding)

	  if (actual !== length) {
	    // Writing a hex string, for example, that contains invalid characters will
	    // cause everything after the first invalid character to be ignored. (e.g.
	    // 'abxxcd' will be treated as 'ab')
	    that = that.slice(0, actual)
	  }

	  return that
	}

	function fromArrayLike (that, array) {
	  var length = array.length < 0 ? 0 : checked(array.length) | 0
	  that = createBuffer(that, length)
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255
	  }
	  return that
	}

	function fromArrayBuffer (that, array, byteOffset, length) {
	  array.byteLength // this throws if `array` is not a valid ArrayBuffer

	  if (byteOffset < 0 || array.byteLength < byteOffset) {
	    throw new RangeError('\'offset\' is out of bounds')
	  }

	  if (array.byteLength < byteOffset + (length || 0)) {
	    throw new RangeError('\'length\' is out of bounds')
	  }

	  if (byteOffset === undefined && length === undefined) {
	    array = new Uint8Array(array)
	  } else if (length === undefined) {
	    array = new Uint8Array(array, byteOffset)
	  } else {
	    array = new Uint8Array(array, byteOffset, length)
	  }

	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = array
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    that = fromArrayLike(that, array)
	  }
	  return that
	}

	function fromObject (that, obj) {
	  if (Buffer.isBuffer(obj)) {
	    var len = checked(obj.length) | 0
	    that = createBuffer(that, len)

	    if (that.length === 0) {
	      return that
	    }

	    obj.copy(that, 0, 0, len)
	    return that
	  }

	  if (obj) {
	    if ((typeof ArrayBuffer !== 'undefined' &&
	        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
	      if (typeof obj.length !== 'number' || isnan(obj.length)) {
	        return createBuffer(that, 0)
	      }
	      return fromArrayLike(that, obj)
	    }

	    if (obj.type === 'Buffer' && isArray(obj.data)) {
	      return fromArrayLike(that, obj.data)
	    }
	  }

	  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
	}

	function checked (length) {
	  // Note: cannot use `length < kMaxLength()` here because that fails when
	  // length is NaN (which is otherwise coerced to zero.)
	  if (length >= kMaxLength()) {
	    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
	                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
	  }
	  return length | 0
	}

	function SlowBuffer (length) {
	  if (+length != length) { // eslint-disable-line eqeqeq
	    length = 0
	  }
	  return Buffer.alloc(+length)
	}

	Buffer.isBuffer = function isBuffer (b) {
	  return !!(b != null && b._isBuffer)
	}

	Buffer.compare = function compare (a, b) {
	  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
	    throw new TypeError('Arguments must be Buffers')
	  }

	  if (a === b) return 0

	  var x = a.length
	  var y = b.length

	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i]
	      y = b[i]
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}

	Buffer.isEncoding = function isEncoding (encoding) {
	  switch (String(encoding).toLowerCase()) {
	    case 'hex':
	    case 'utf8':
	    case 'utf-8':
	    case 'ascii':
	    case 'latin1':
	    case 'binary':
	    case 'base64':
	    case 'ucs2':
	    case 'ucs-2':
	    case 'utf16le':
	    case 'utf-16le':
	      return true
	    default:
	      return false
	  }
	}

	Buffer.concat = function concat (list, length) {
	  if (!isArray(list)) {
	    throw new TypeError('"list" argument must be an Array of Buffers')
	  }

	  if (list.length === 0) {
	    return Buffer.alloc(0)
	  }

	  var i
	  if (length === undefined) {
	    length = 0
	    for (i = 0; i < list.length; ++i) {
	      length += list[i].length
	    }
	  }

	  var buffer = Buffer.allocUnsafe(length)
	  var pos = 0
	  for (i = 0; i < list.length; ++i) {
	    var buf = list[i]
	    if (!Buffer.isBuffer(buf)) {
	      throw new TypeError('"list" argument must be an Array of Buffers')
	    }
	    buf.copy(buffer, pos)
	    pos += buf.length
	  }
	  return buffer
	}

	function byteLength (string, encoding) {
	  if (Buffer.isBuffer(string)) {
	    return string.length
	  }
	  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
	      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
	    return string.byteLength
	  }
	  if (typeof string !== 'string') {
	    string = '' + string
	  }

	  var len = string.length
	  if (len === 0) return 0

	  // Use a for loop to avoid recursion
	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'ascii':
	      case 'latin1':
	      case 'binary':
	        return len
	      case 'utf8':
	      case 'utf-8':
	      case undefined:
	        return utf8ToBytes(string).length
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return len * 2
	      case 'hex':
	        return len >>> 1
	      case 'base64':
	        return base64ToBytes(string).length
	      default:
	        if (loweredCase) return utf8ToBytes(string).length // assume utf8
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	Buffer.byteLength = byteLength

	function slowToString (encoding, start, end) {
	  var loweredCase = false

	  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
	  // property of a typed array.

	  // This behaves neither like String nor Uint8Array in that we set start/end
	  // to their upper/lower bounds if the value passed is out of range.
	  // undefined is handled specially as per ECMA-262 6th Edition,
	  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
	  if (start === undefined || start < 0) {
	    start = 0
	  }
	  // Return early if start > this.length. Done here to prevent potential uint32
	  // coercion fail below.
	  if (start > this.length) {
	    return ''
	  }

	  if (end === undefined || end > this.length) {
	    end = this.length
	  }

	  if (end <= 0) {
	    return ''
	  }

	  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
	  end >>>= 0
	  start >>>= 0

	  if (end <= start) {
	    return ''
	  }

	  if (!encoding) encoding = 'utf8'

	  while (true) {
	    switch (encoding) {
	      case 'hex':
	        return hexSlice(this, start, end)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Slice(this, start, end)

	      case 'ascii':
	        return asciiSlice(this, start, end)

	      case 'latin1':
	      case 'binary':
	        return latin1Slice(this, start, end)

	      case 'base64':
	        return base64Slice(this, start, end)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return utf16leSlice(this, start, end)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = (encoding + '').toLowerCase()
	        loweredCase = true
	    }
	  }
	}

	// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
	// Buffer instances.
	Buffer.prototype._isBuffer = true

	function swap (b, n, m) {
	  var i = b[n]
	  b[n] = b[m]
	  b[m] = i
	}

	Buffer.prototype.swap16 = function swap16 () {
	  var len = this.length
	  if (len % 2 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 16-bits')
	  }
	  for (var i = 0; i < len; i += 2) {
	    swap(this, i, i + 1)
	  }
	  return this
	}

	Buffer.prototype.swap32 = function swap32 () {
	  var len = this.length
	  if (len % 4 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 32-bits')
	  }
	  for (var i = 0; i < len; i += 4) {
	    swap(this, i, i + 3)
	    swap(this, i + 1, i + 2)
	  }
	  return this
	}

	Buffer.prototype.swap64 = function swap64 () {
	  var len = this.length
	  if (len % 8 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 64-bits')
	  }
	  for (var i = 0; i < len; i += 8) {
	    swap(this, i, i + 7)
	    swap(this, i + 1, i + 6)
	    swap(this, i + 2, i + 5)
	    swap(this, i + 3, i + 4)
	  }
	  return this
	}

	Buffer.prototype.toString = function toString () {
	  var length = this.length | 0
	  if (length === 0) return ''
	  if (arguments.length === 0) return utf8Slice(this, 0, length)
	  return slowToString.apply(this, arguments)
	}

	Buffer.prototype.equals = function equals (b) {
	  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return true
	  return Buffer.compare(this, b) === 0
	}

	Buffer.prototype.inspect = function inspect () {
	  var str = ''
	  var max = exports.INSPECT_MAX_BYTES
	  if (this.length > 0) {
	    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
	    if (this.length > max) str += ' ... '
	  }
	  return '<Buffer ' + str + '>'
	}

	Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
	  if (!Buffer.isBuffer(target)) {
	    throw new TypeError('Argument must be a Buffer')
	  }

	  if (start === undefined) {
	    start = 0
	  }
	  if (end === undefined) {
	    end = target ? target.length : 0
	  }
	  if (thisStart === undefined) {
	    thisStart = 0
	  }
	  if (thisEnd === undefined) {
	    thisEnd = this.length
	  }

	  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
	    throw new RangeError('out of range index')
	  }

	  if (thisStart >= thisEnd && start >= end) {
	    return 0
	  }
	  if (thisStart >= thisEnd) {
	    return -1
	  }
	  if (start >= end) {
	    return 1
	  }

	  start >>>= 0
	  end >>>= 0
	  thisStart >>>= 0
	  thisEnd >>>= 0

	  if (this === target) return 0

	  var x = thisEnd - thisStart
	  var y = end - start
	  var len = Math.min(x, y)

	  var thisCopy = this.slice(thisStart, thisEnd)
	  var targetCopy = target.slice(start, end)

	  for (var i = 0; i < len; ++i) {
	    if (thisCopy[i] !== targetCopy[i]) {
	      x = thisCopy[i]
	      y = targetCopy[i]
	      break
	    }
	  }

	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}

	// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
	// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
	//
	// Arguments:
	// - buffer - a Buffer to search
	// - val - a string, Buffer, or number
	// - byteOffset - an index into `buffer`; will be clamped to an int32
	// - encoding - an optional encoding, relevant is val is a string
	// - dir - true for indexOf, false for lastIndexOf
	function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
	  // Empty buffer means no match
	  if (buffer.length === 0) return -1

	  // Normalize byteOffset
	  if (typeof byteOffset === 'string') {
	    encoding = byteOffset
	    byteOffset = 0
	  } else if (byteOffset > 0x7fffffff) {
	    byteOffset = 0x7fffffff
	  } else if (byteOffset < -0x80000000) {
	    byteOffset = -0x80000000
	  }
	  byteOffset = +byteOffset  // Coerce to Number.
	  if (isNaN(byteOffset)) {
	    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
	    byteOffset = dir ? 0 : (buffer.length - 1)
	  }

	  // Normalize byteOffset: negative offsets start from the end of the buffer
	  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
	  if (byteOffset >= buffer.length) {
	    if (dir) return -1
	    else byteOffset = buffer.length - 1
	  } else if (byteOffset < 0) {
	    if (dir) byteOffset = 0
	    else return -1
	  }

	  // Normalize val
	  if (typeof val === 'string') {
	    val = Buffer.from(val, encoding)
	  }

	  // Finally, search either indexOf (if dir is true) or lastIndexOf
	  if (Buffer.isBuffer(val)) {
	    // Special case: looking for empty string/buffer always fails
	    if (val.length === 0) {
	      return -1
	    }
	    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
	  } else if (typeof val === 'number') {
	    val = val & 0xFF // Search for a byte value [0-255]
	    if (Buffer.TYPED_ARRAY_SUPPORT &&
	        typeof Uint8Array.prototype.indexOf === 'function') {
	      if (dir) {
	        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
	      } else {
	        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
	      }
	    }
	    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
	  }

	  throw new TypeError('val must be string, number or Buffer')
	}

	function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
	  var indexSize = 1
	  var arrLength = arr.length
	  var valLength = val.length

	  if (encoding !== undefined) {
	    encoding = String(encoding).toLowerCase()
	    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
	        encoding === 'utf16le' || encoding === 'utf-16le') {
	      if (arr.length < 2 || val.length < 2) {
	        return -1
	      }
	      indexSize = 2
	      arrLength /= 2
	      valLength /= 2
	      byteOffset /= 2
	    }
	  }

	  function read (buf, i) {
	    if (indexSize === 1) {
	      return buf[i]
	    } else {
	      return buf.readUInt16BE(i * indexSize)
	    }
	  }

	  var i
	  if (dir) {
	    var foundIndex = -1
	    for (i = byteOffset; i < arrLength; i++) {
	      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
	        if (foundIndex === -1) foundIndex = i
	        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
	      } else {
	        if (foundIndex !== -1) i -= i - foundIndex
	        foundIndex = -1
	      }
	    }
	  } else {
	    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
	    for (i = byteOffset; i >= 0; i--) {
	      var found = true
	      for (var j = 0; j < valLength; j++) {
	        if (read(arr, i + j) !== read(val, j)) {
	          found = false
	          break
	        }
	      }
	      if (found) return i
	    }
	  }

	  return -1
	}

	Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
	  return this.indexOf(val, byteOffset, encoding) !== -1
	}

	Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
	}

	Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
	}

	function hexWrite (buf, string, offset, length) {
	  offset = Number(offset) || 0
	  var remaining = buf.length - offset
	  if (!length) {
	    length = remaining
	  } else {
	    length = Number(length)
	    if (length > remaining) {
	      length = remaining
	    }
	  }

	  // must be an even number of digits
	  var strLen = string.length
	  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

	  if (length > strLen / 2) {
	    length = strLen / 2
	  }
	  for (var i = 0; i < length; ++i) {
	    var parsed = parseInt(string.substr(i * 2, 2), 16)
	    if (isNaN(parsed)) return i
	    buf[offset + i] = parsed
	  }
	  return i
	}

	function utf8Write (buf, string, offset, length) {
	  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
	}

	function asciiWrite (buf, string, offset, length) {
	  return blitBuffer(asciiToBytes(string), buf, offset, length)
	}

	function latin1Write (buf, string, offset, length) {
	  return asciiWrite(buf, string, offset, length)
	}

	function base64Write (buf, string, offset, length) {
	  return blitBuffer(base64ToBytes(string), buf, offset, length)
	}

	function ucs2Write (buf, string, offset, length) {
	  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
	}

	Buffer.prototype.write = function write (string, offset, length, encoding) {
	  // Buffer#write(string)
	  if (offset === undefined) {
	    encoding = 'utf8'
	    length = this.length
	    offset = 0
	  // Buffer#write(string, encoding)
	  } else if (length === undefined && typeof offset === 'string') {
	    encoding = offset
	    length = this.length
	    offset = 0
	  // Buffer#write(string, offset[, length][, encoding])
	  } else if (isFinite(offset)) {
	    offset = offset | 0
	    if (isFinite(length)) {
	      length = length | 0
	      if (encoding === undefined) encoding = 'utf8'
	    } else {
	      encoding = length
	      length = undefined
	    }
	  // legacy write(string, encoding, offset, length) - remove in v0.13
	  } else {
	    throw new Error(
	      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
	    )
	  }

	  var remaining = this.length - offset
	  if (length === undefined || length > remaining) length = remaining

	  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
	    throw new RangeError('Attempt to write outside buffer bounds')
	  }

	  if (!encoding) encoding = 'utf8'

	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'hex':
	        return hexWrite(this, string, offset, length)

	      case 'utf8':
	      case 'utf-8':
	        return utf8Write(this, string, offset, length)

	      case 'ascii':
	        return asciiWrite(this, string, offset, length)

	      case 'latin1':
	      case 'binary':
	        return latin1Write(this, string, offset, length)

	      case 'base64':
	        // Warning: maxLength not taken into account in base64Write
	        return base64Write(this, string, offset, length)

	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return ucs2Write(this, string, offset, length)

	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}

	Buffer.prototype.toJSON = function toJSON () {
	  return {
	    type: 'Buffer',
	    data: Array.prototype.slice.call(this._arr || this, 0)
	  }
	}

	function base64Slice (buf, start, end) {
	  if (start === 0 && end === buf.length) {
	    return base64.fromByteArray(buf)
	  } else {
	    return base64.fromByteArray(buf.slice(start, end))
	  }
	}

	function utf8Slice (buf, start, end) {
	  end = Math.min(buf.length, end)
	  var res = []

	  var i = start
	  while (i < end) {
	    var firstByte = buf[i]
	    var codePoint = null
	    var bytesPerSequence = (firstByte > 0xEF) ? 4
	      : (firstByte > 0xDF) ? 3
	      : (firstByte > 0xBF) ? 2
	      : 1

	    if (i + bytesPerSequence <= end) {
	      var secondByte, thirdByte, fourthByte, tempCodePoint

	      switch (bytesPerSequence) {
	        case 1:
	          if (firstByte < 0x80) {
	            codePoint = firstByte
	          }
	          break
	        case 2:
	          secondByte = buf[i + 1]
	          if ((secondByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
	            if (tempCodePoint > 0x7F) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 3:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
	            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 4:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          fourthByte = buf[i + 3]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
	            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
	              codePoint = tempCodePoint
	            }
	          }
	      }
	    }

	    if (codePoint === null) {
	      // we did not generate a valid codePoint so insert a
	      // replacement char (U+FFFD) and advance only 1 byte
	      codePoint = 0xFFFD
	      bytesPerSequence = 1
	    } else if (codePoint > 0xFFFF) {
	      // encode to utf16 (surrogate pair dance)
	      codePoint -= 0x10000
	      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
	      codePoint = 0xDC00 | codePoint & 0x3FF
	    }

	    res.push(codePoint)
	    i += bytesPerSequence
	  }

	  return decodeCodePointsArray(res)
	}

	// Based on http://stackoverflow.com/a/22747272/680742, the browser with
	// the lowest limit is Chrome, with 0x10000 args.
	// We go 1 magnitude less, for safety
	var MAX_ARGUMENTS_LENGTH = 0x1000

	function decodeCodePointsArray (codePoints) {
	  var len = codePoints.length
	  if (len <= MAX_ARGUMENTS_LENGTH) {
	    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
	  }

	  // Decode in chunks to avoid "call stack size exceeded".
	  var res = ''
	  var i = 0
	  while (i < len) {
	    res += String.fromCharCode.apply(
	      String,
	      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
	    )
	  }
	  return res
	}

	function asciiSlice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i] & 0x7F)
	  }
	  return ret
	}

	function latin1Slice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)

	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i])
	  }
	  return ret
	}

	function hexSlice (buf, start, end) {
	  var len = buf.length

	  if (!start || start < 0) start = 0
	  if (!end || end < 0 || end > len) end = len

	  var out = ''
	  for (var i = start; i < end; ++i) {
	    out += toHex(buf[i])
	  }
	  return out
	}

	function utf16leSlice (buf, start, end) {
	  var bytes = buf.slice(start, end)
	  var res = ''
	  for (var i = 0; i < bytes.length; i += 2) {
	    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
	  }
	  return res
	}

	Buffer.prototype.slice = function slice (start, end) {
	  var len = this.length
	  start = ~~start
	  end = end === undefined ? len : ~~end

	  if (start < 0) {
	    start += len
	    if (start < 0) start = 0
	  } else if (start > len) {
	    start = len
	  }

	  if (end < 0) {
	    end += len
	    if (end < 0) end = 0
	  } else if (end > len) {
	    end = len
	  }

	  if (end < start) end = start

	  var newBuf
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    newBuf = this.subarray(start, end)
	    newBuf.__proto__ = Buffer.prototype
	  } else {
	    var sliceLen = end - start
	    newBuf = new Buffer(sliceLen, undefined)
	    for (var i = 0; i < sliceLen; ++i) {
	      newBuf[i] = this[i + start]
	    }
	  }

	  return newBuf
	}

	/*
	 * Need to make sure that buffer isn't trying to write out of bounds.
	 */
	function checkOffset (offset, ext, length) {
	  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
	  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
	}

	Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)

	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }

	  return val
	}

	Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    checkOffset(offset, byteLength, this.length)
	  }

	  var val = this[offset + --byteLength]
	  var mul = 1
	  while (byteLength > 0 && (mul *= 0x100)) {
	    val += this[offset + --byteLength] * mul
	  }

	  return val
	}

	Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  return this[offset]
	}

	Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return this[offset] | (this[offset + 1] << 8)
	}

	Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return (this[offset] << 8) | this[offset + 1]
	}

	Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)

	  return ((this[offset]) |
	      (this[offset + 1] << 8) |
	      (this[offset + 2] << 16)) +
	      (this[offset + 3] * 0x1000000)
	}

	Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)

	  return (this[offset] * 0x1000000) +
	    ((this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    this[offset + 3])
	}

	Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)

	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }
	  mul *= 0x80

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

	  return val
	}

	Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)

	  var i = byteLength
	  var mul = 1
	  var val = this[offset + --i]
	  while (i > 0 && (mul *= 0x100)) {
	    val += this[offset + --i] * mul
	  }
	  mul *= 0x80

	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

	  return val
	}

	Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  if (!(this[offset] & 0x80)) return (this[offset])
	  return ((0xff - this[offset] + 1) * -1)
	}

	Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset] | (this[offset + 1] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}

	Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset + 1] | (this[offset] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}

	Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)

	  return (this[offset]) |
	    (this[offset + 1] << 8) |
	    (this[offset + 2] << 16) |
	    (this[offset + 3] << 24)
	}

	Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)

	  return (this[offset] << 24) |
	    (this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    (this[offset + 3])
	}

	Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, true, 23, 4)
	}

	Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, false, 23, 4)
	}

	Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, true, 52, 8)
	}

	Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, false, 52, 8)
	}

	function checkInt (buf, value, offset, ext, max, min) {
	  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
	  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	}

	Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1
	    checkInt(this, value, offset, byteLength, maxBytes, 0)
	  }

	  var mul = 1
	  var i = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }

	  return offset + byteLength
	}

	Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1
	    checkInt(this, value, offset, byteLength, maxBytes, 0)
	  }

	  var i = byteLength - 1
	  var mul = 1
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }

	  return offset + byteLength
	}

	Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  this[offset] = (value & 0xff)
	  return offset + 1
	}

	function objectWriteUInt16 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
	    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
	      (littleEndian ? i : 1 - i) * 8
	  }
	}

	Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}

	Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}

	function objectWriteUInt32 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffffffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
	    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
	  }
	}

	Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset + 3] = (value >>> 24)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 1] = (value >>> 8)
	    this[offset] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}

	Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}

	Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)

	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }

	  var i = 0
	  var mul = 1
	  var sub = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
	      sub = 1
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }

	  return offset + byteLength
	}

	Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)

	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }

	  var i = byteLength - 1
	  var mul = 1
	  var sub = 0
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
	      sub = 1
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }

	  return offset + byteLength
	}

	Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  if (value < 0) value = 0xff + value + 1
	  this[offset] = (value & 0xff)
	  return offset + 1
	}

	Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}

	Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}

	Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 3] = (value >>> 24)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}

	Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (value < 0) value = 0xffffffff + value + 1
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}

	function checkIEEE754 (buf, value, offset, ext, max, min) {
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	  if (offset < 0) throw new RangeError('Index out of range')
	}

	function writeFloat (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 23, 4)
	  return offset + 4
	}

	Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, true, noAssert)
	}

	Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, false, noAssert)
	}

	function writeDouble (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 52, 8)
	  return offset + 8
	}

	Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, true, noAssert)
	}

	Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, false, noAssert)
	}

	// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
	Buffer.prototype.copy = function copy (target, targetStart, start, end) {
	  if (!start) start = 0
	  if (!end && end !== 0) end = this.length
	  if (targetStart >= target.length) targetStart = target.length
	  if (!targetStart) targetStart = 0
	  if (end > 0 && end < start) end = start

	  // Copy 0 bytes; we're done
	  if (end === start) return 0
	  if (target.length === 0 || this.length === 0) return 0

	  // Fatal error conditions
	  if (targetStart < 0) {
	    throw new RangeError('targetStart out of bounds')
	  }
	  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
	  if (end < 0) throw new RangeError('sourceEnd out of bounds')

	  // Are we oob?
	  if (end > this.length) end = this.length
	  if (target.length - targetStart < end - start) {
	    end = target.length - targetStart + start
	  }

	  var len = end - start
	  var i

	  if (this === target && start < targetStart && targetStart < end) {
	    // descending copy from end
	    for (i = len - 1; i >= 0; --i) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
	    // ascending copy from start
	    for (i = 0; i < len; ++i) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else {
	    Uint8Array.prototype.set.call(
	      target,
	      this.subarray(start, start + len),
	      targetStart
	    )
	  }

	  return len
	}

	// Usage:
	//    buffer.fill(number[, offset[, end]])
	//    buffer.fill(buffer[, offset[, end]])
	//    buffer.fill(string[, offset[, end]][, encoding])
	Buffer.prototype.fill = function fill (val, start, end, encoding) {
	  // Handle string cases:
	  if (typeof val === 'string') {
	    if (typeof start === 'string') {
	      encoding = start
	      start = 0
	      end = this.length
	    } else if (typeof end === 'string') {
	      encoding = end
	      end = this.length
	    }
	    if (val.length === 1) {
	      var code = val.charCodeAt(0)
	      if (code < 256) {
	        val = code
	      }
	    }
	    if (encoding !== undefined && typeof encoding !== 'string') {
	      throw new TypeError('encoding must be a string')
	    }
	    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
	      throw new TypeError('Unknown encoding: ' + encoding)
	    }
	  } else if (typeof val === 'number') {
	    val = val & 255
	  }

	  // Invalid ranges are not set to a default, so can range check early.
	  if (start < 0 || this.length < start || this.length < end) {
	    throw new RangeError('Out of range index')
	  }

	  if (end <= start) {
	    return this
	  }

	  start = start >>> 0
	  end = end === undefined ? this.length : end >>> 0

	  if (!val) val = 0

	  var i
	  if (typeof val === 'number') {
	    for (i = start; i < end; ++i) {
	      this[i] = val
	    }
	  } else {
	    var bytes = Buffer.isBuffer(val)
	      ? val
	      : utf8ToBytes(new Buffer(val, encoding).toString())
	    var len = bytes.length
	    for (i = 0; i < end - start; ++i) {
	      this[i + start] = bytes[i % len]
	    }
	  }

	  return this
	}

	// HELPER FUNCTIONS
	// ================

	var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

	function base64clean (str) {
	  // Node strips out invalid characters like \n and \t from the string, base64-js does not
	  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
	  // Node converts strings with length < 2 to ''
	  if (str.length < 2) return ''
	  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
	  while (str.length % 4 !== 0) {
	    str = str + '='
	  }
	  return str
	}

	function stringtrim (str) {
	  if (str.trim) return str.trim()
	  return str.replace(/^\s+|\s+$/g, '')
	}

	function toHex (n) {
	  if (n < 16) return '0' + n.toString(16)
	  return n.toString(16)
	}

	function utf8ToBytes (string, units) {
	  units = units || Infinity
	  var codePoint
	  var length = string.length
	  var leadSurrogate = null
	  var bytes = []

	  for (var i = 0; i < length; ++i) {
	    codePoint = string.charCodeAt(i)

	    // is surrogate component
	    if (codePoint > 0xD7FF && codePoint < 0xE000) {
	      // last char was a lead
	      if (!leadSurrogate) {
	        // no lead yet
	        if (codePoint > 0xDBFF) {
	          // unexpected trail
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        } else if (i + 1 === length) {
	          // unpaired lead
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        }

	        // valid lead
	        leadSurrogate = codePoint

	        continue
	      }

	      // 2 leads in a row
	      if (codePoint < 0xDC00) {
	        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	        leadSurrogate = codePoint
	        continue
	      }

	      // valid surrogate pair
	      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
	    } else if (leadSurrogate) {
	      // valid bmp char, but last char was a lead
	      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	    }

	    leadSurrogate = null

	    // encode utf8
	    if (codePoint < 0x80) {
	      if ((units -= 1) < 0) break
	      bytes.push(codePoint)
	    } else if (codePoint < 0x800) {
	      if ((units -= 2) < 0) break
	      bytes.push(
	        codePoint >> 0x6 | 0xC0,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x10000) {
	      if ((units -= 3) < 0) break
	      bytes.push(
	        codePoint >> 0xC | 0xE0,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x110000) {
	      if ((units -= 4) < 0) break
	      bytes.push(
	        codePoint >> 0x12 | 0xF0,
	        codePoint >> 0xC & 0x3F | 0x80,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else {
	      throw new Error('Invalid code point')
	    }
	  }

	  return bytes
	}

	function asciiToBytes (str) {
	  var byteArray = []
	  for (var i = 0; i < str.length; ++i) {
	    // Node's code seems to be doing this and not & 0x7F..
	    byteArray.push(str.charCodeAt(i) & 0xFF)
	  }
	  return byteArray
	}

	function utf16leToBytes (str, units) {
	  var c, hi, lo
	  var byteArray = []
	  for (var i = 0; i < str.length; ++i) {
	    if ((units -= 2) < 0) break

	    c = str.charCodeAt(i)
	    hi = c >> 8
	    lo = c % 256
	    byteArray.push(lo)
	    byteArray.push(hi)
	  }

	  return byteArray
	}

	function base64ToBytes (str) {
	  return base64.toByteArray(base64clean(str))
	}

	function blitBuffer (src, dst, offset, length) {
	  for (var i = 0; i < length; ++i) {
	    if ((i + offset >= dst.length) || (i >= src.length)) break
	    dst[i + offset] = src[i]
	  }
	  return i
	}

	function isnan (val) {
	  return val !== val // eslint-disable-line no-self-compare
	}

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 7 */
/***/ function(module, exports) {

	'use strict'

	exports.byteLength = byteLength
	exports.toByteArray = toByteArray
	exports.fromByteArray = fromByteArray

	var lookup = []
	var revLookup = []
	var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

	var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
	for (var i = 0, len = code.length; i < len; ++i) {
	  lookup[i] = code[i]
	  revLookup[code.charCodeAt(i)] = i
	}

	revLookup['-'.charCodeAt(0)] = 62
	revLookup['_'.charCodeAt(0)] = 63

	function placeHoldersCount (b64) {
	  var len = b64.length
	  if (len % 4 > 0) {
	    throw new Error('Invalid string. Length must be a multiple of 4')
	  }

	  // the number of equal signs (place holders)
	  // if there are two placeholders, than the two characters before it
	  // represent one byte
	  // if there is only one, then the three characters before it represent 2 bytes
	  // this is just a cheap hack to not do indexOf twice
	  return b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0
	}

	function byteLength (b64) {
	  // base64 is 4/3 + up to two characters of the original data
	  return b64.length * 3 / 4 - placeHoldersCount(b64)
	}

	function toByteArray (b64) {
	  var i, j, l, tmp, placeHolders, arr
	  var len = b64.length
	  placeHolders = placeHoldersCount(b64)

	  arr = new Arr(len * 3 / 4 - placeHolders)

	  // if there are placeholders, only get up to the last complete 4 chars
	  l = placeHolders > 0 ? len - 4 : len

	  var L = 0

	  for (i = 0, j = 0; i < l; i += 4, j += 3) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)]
	    arr[L++] = (tmp >> 16) & 0xFF
	    arr[L++] = (tmp >> 8) & 0xFF
	    arr[L++] = tmp & 0xFF
	  }

	  if (placeHolders === 2) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4)
	    arr[L++] = tmp & 0xFF
	  } else if (placeHolders === 1) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2)
	    arr[L++] = (tmp >> 8) & 0xFF
	    arr[L++] = tmp & 0xFF
	  }

	  return arr
	}

	function tripletToBase64 (num) {
	  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
	}

	function encodeChunk (uint8, start, end) {
	  var tmp
	  var output = []
	  for (var i = start; i < end; i += 3) {
	    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])
	    output.push(tripletToBase64(tmp))
	  }
	  return output.join('')
	}

	function fromByteArray (uint8) {
	  var tmp
	  var len = uint8.length
	  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
	  var output = ''
	  var parts = []
	  var maxChunkLength = 16383 // must be multiple of 3

	  // go through the array every three bytes, we'll deal with trailing stuff later
	  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
	    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
	  }

	  // pad the end with zeros, but make sure to not forget the extra bytes
	  if (extraBytes === 1) {
	    tmp = uint8[len - 1]
	    output += lookup[tmp >> 2]
	    output += lookup[(tmp << 4) & 0x3F]
	    output += '=='
	  } else if (extraBytes === 2) {
	    tmp = (uint8[len - 2] << 8) + (uint8[len - 1])
	    output += lookup[tmp >> 10]
	    output += lookup[(tmp >> 4) & 0x3F]
	    output += lookup[(tmp << 2) & 0x3F]
	    output += '='
	  }

	  parts.push(output)

	  return parts.join('')
	}


/***/ },
/* 8 */
/***/ function(module, exports) {

	exports.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var nBits = -7
	  var i = isLE ? (nBytes - 1) : 0
	  var d = isLE ? -1 : 1
	  var s = buffer[offset + i]

	  i += d

	  e = s & ((1 << (-nBits)) - 1)
	  s >>= (-nBits)
	  nBits += eLen
	  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

	  m = e & ((1 << (-nBits)) - 1)
	  e >>= (-nBits)
	  nBits += mLen
	  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

	  if (e === 0) {
	    e = 1 - eBias
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen)
	    e = e - eBias
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	}

	exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
	  var i = isLE ? 0 : (nBytes - 1)
	  var d = isLE ? 1 : -1
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0

	  value = Math.abs(value)

	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0
	    e = eMax
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2)
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--
	      c *= 2
	    }
	    if (e + eBias >= 1) {
	      value += rt / c
	    } else {
	      value += rt * Math.pow(2, 1 - eBias)
	    }
	    if (value * c >= 2) {
	      e++
	      c /= 2
	    }

	    if (e + eBias >= eMax) {
	      m = 0
	      e = eMax
	    } else if (e + eBias >= 1) {
	      m = (value * c - 1) * Math.pow(2, mLen)
	      e = e + eBias
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
	      e = 0
	    }
	  }

	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

	  e = (e << mLen) | m
	  eLen += mLen
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

	  buffer[offset + i - d] |= s * 128
	}


/***/ },
/* 9 */
/***/ function(module, exports) {

	var toString = {}.toString;

	module.exports = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};


/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	// resolves . and .. elements in a path array with directory names there
	// must be no slashes, empty elements, or device names (c:\) in the array
	// (so also no leading and trailing slashes - it does not distinguish
	// relative and absolute paths)
	function normalizeArray(parts, allowAboveRoot) {
	  // if the path tries to go above the root, `up` ends up > 0
	  var up = 0;
	  for (var i = parts.length - 1; i >= 0; i--) {
	    var last = parts[i];
	    if (last === '.') {
	      parts.splice(i, 1);
	    } else if (last === '..') {
	      parts.splice(i, 1);
	      up++;
	    } else if (up) {
	      parts.splice(i, 1);
	      up--;
	    }
	  }

	  // if the path is allowed to go above the root, restore leading ..s
	  if (allowAboveRoot) {
	    for (; up--; up) {
	      parts.unshift('..');
	    }
	  }

	  return parts;
	}

	// Split a filename into [root, dir, basename, ext], unix version
	// 'root' is just a slash, or nothing.
	var splitPathRe =
	    /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
	var splitPath = function(filename) {
	  return splitPathRe.exec(filename).slice(1);
	};

	// path.resolve([from ...], to)
	// posix version
	exports.resolve = function() {
	  var resolvedPath = '',
	      resolvedAbsolute = false;

	  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
	    var path = (i >= 0) ? arguments[i] : process.cwd();

	    // Skip empty and invalid entries
	    if (typeof path !== 'string') {
	      throw new TypeError('Arguments to path.resolve must be strings');
	    } else if (!path) {
	      continue;
	    }

	    resolvedPath = path + '/' + resolvedPath;
	    resolvedAbsolute = path.charAt(0) === '/';
	  }

	  // At this point the path should be resolved to a full absolute path, but
	  // handle relative paths to be safe (might happen when process.cwd() fails)

	  // Normalize the path
	  resolvedPath = normalizeArray(filter(resolvedPath.split('/'), function(p) {
	    return !!p;
	  }), !resolvedAbsolute).join('/');

	  return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
	};

	// path.normalize(path)
	// posix version
	exports.normalize = function(path) {
	  var isAbsolute = exports.isAbsolute(path),
	      trailingSlash = substr(path, -1) === '/';

	  // Normalize the path
	  path = normalizeArray(filter(path.split('/'), function(p) {
	    return !!p;
	  }), !isAbsolute).join('/');

	  if (!path && !isAbsolute) {
	    path = '.';
	  }
	  if (path && trailingSlash) {
	    path += '/';
	  }

	  return (isAbsolute ? '/' : '') + path;
	};

	// posix version
	exports.isAbsolute = function(path) {
	  return path.charAt(0) === '/';
	};

	// posix version
	exports.join = function() {
	  var paths = Array.prototype.slice.call(arguments, 0);
	  return exports.normalize(filter(paths, function(p, index) {
	    if (typeof p !== 'string') {
	      throw new TypeError('Arguments to path.join must be strings');
	    }
	    return p;
	  }).join('/'));
	};


	// path.relative(from, to)
	// posix version
	exports.relative = function(from, to) {
	  from = exports.resolve(from).substr(1);
	  to = exports.resolve(to).substr(1);

	  function trim(arr) {
	    var start = 0;
	    for (; start < arr.length; start++) {
	      if (arr[start] !== '') break;
	    }

	    var end = arr.length - 1;
	    for (; end >= 0; end--) {
	      if (arr[end] !== '') break;
	    }

	    if (start > end) return [];
	    return arr.slice(start, end - start + 1);
	  }

	  var fromParts = trim(from.split('/'));
	  var toParts = trim(to.split('/'));

	  var length = Math.min(fromParts.length, toParts.length);
	  var samePartsLength = length;
	  for (var i = 0; i < length; i++) {
	    if (fromParts[i] !== toParts[i]) {
	      samePartsLength = i;
	      break;
	    }
	  }

	  var outputParts = [];
	  for (var i = samePartsLength; i < fromParts.length; i++) {
	    outputParts.push('..');
	  }

	  outputParts = outputParts.concat(toParts.slice(samePartsLength));

	  return outputParts.join('/');
	};

	exports.sep = '/';
	exports.delimiter = ':';

	exports.dirname = function(path) {
	  var result = splitPath(path),
	      root = result[0],
	      dir = result[1];

	  if (!root && !dir) {
	    // No dirname whatsoever
	    return '.';
	  }

	  if (dir) {
	    // It has a dirname, strip trailing slash
	    dir = dir.substr(0, dir.length - 1);
	  }

	  return root + dir;
	};


	exports.basename = function(path, ext) {
	  var f = splitPath(path)[2];
	  // TODO: make this comparison case-insensitive on windows?
	  if (ext && f.substr(-1 * ext.length) === ext) {
	    f = f.substr(0, f.length - ext.length);
	  }
	  return f;
	};


	exports.extname = function(path) {
	  return splitPath(path)[3];
	};

	function filter (xs, f) {
	    if (xs.filter) return xs.filter(f);
	    var res = [];
	    for (var i = 0; i < xs.length; i++) {
	        if (f(xs[i], i, xs)) res.push(xs[i]);
	    }
	    return res;
	}

	// String.prototype.substr - negative index don't work in IE8
	var substr = 'ab'.substr(-1) === 'b'
	    ? function (str, start, len) { return str.substr(start, len) }
	    : function (str, start, len) {
	        if (start < 0) start = str.length + start;
	        return str.substr(start, len);
	    }
	;

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	var formatRegExp = /%[sdj%]/g;
	exports.format = function(f) {
	  if (!isString(f)) {
	    var objects = [];
	    for (var i = 0; i < arguments.length; i++) {
	      objects.push(inspect(arguments[i]));
	    }
	    return objects.join(' ');
	  }

	  var i = 1;
	  var args = arguments;
	  var len = args.length;
	  var str = String(f).replace(formatRegExp, function(x) {
	    if (x === '%%') return '%';
	    if (i >= len) return x;
	    switch (x) {
	      case '%s': return String(args[i++]);
	      case '%d': return Number(args[i++]);
	      case '%j':
	        try {
	          return JSON.stringify(args[i++]);
	        } catch (_) {
	          return '[Circular]';
	        }
	      default:
	        return x;
	    }
	  });
	  for (var x = args[i]; i < len; x = args[++i]) {
	    if (isNull(x) || !isObject(x)) {
	      str += ' ' + x;
	    } else {
	      str += ' ' + inspect(x);
	    }
	  }
	  return str;
	};


	// Mark that a method should not be used.
	// Returns a modified function which warns once by default.
	// If --no-deprecation is set, then it is a no-op.
	exports.deprecate = function(fn, msg) {
	  // Allow for deprecating things in the process of starting up.
	  if (isUndefined(global.process)) {
	    return function() {
	      return exports.deprecate(fn, msg).apply(this, arguments);
	    };
	  }

	  if (process.noDeprecation === true) {
	    return fn;
	  }

	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (process.throwDeprecation) {
	        throw new Error(msg);
	      } else if (process.traceDeprecation) {
	        console.trace(msg);
	      } else {
	        console.error(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }

	  return deprecated;
	};


	var debugs = {};
	var debugEnviron;
	exports.debuglog = function(set) {
	  if (isUndefined(debugEnviron))
	    debugEnviron = process.env.NODE_DEBUG || '';
	  set = set.toUpperCase();
	  if (!debugs[set]) {
	    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
	      var pid = process.pid;
	      debugs[set] = function() {
	        var msg = exports.format.apply(exports, arguments);
	        console.error('%s %d: %s', set, pid, msg);
	      };
	    } else {
	      debugs[set] = function() {};
	    }
	  }
	  return debugs[set];
	};


	/**
	 * Echos the value of a value. Trys to print the value out
	 * in the best way possible given the different types.
	 *
	 * @param {Object} obj The object to print out.
	 * @param {Object} opts Optional options object that alters the output.
	 */
	/* legacy: obj, showHidden, depth, colors*/
	function inspect(obj, opts) {
	  // default options
	  var ctx = {
	    seen: [],
	    stylize: stylizeNoColor
	  };
	  // legacy...
	  if (arguments.length >= 3) ctx.depth = arguments[2];
	  if (arguments.length >= 4) ctx.colors = arguments[3];
	  if (isBoolean(opts)) {
	    // legacy...
	    ctx.showHidden = opts;
	  } else if (opts) {
	    // got an "options" object
	    exports._extend(ctx, opts);
	  }
	  // set default options
	  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
	  if (isUndefined(ctx.depth)) ctx.depth = 2;
	  if (isUndefined(ctx.colors)) ctx.colors = false;
	  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  return formatValue(ctx, obj, ctx.depth);
	}
	exports.inspect = inspect;


	// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	inspect.colors = {
	  'bold' : [1, 22],
	  'italic' : [3, 23],
	  'underline' : [4, 24],
	  'inverse' : [7, 27],
	  'white' : [37, 39],
	  'grey' : [90, 39],
	  'black' : [30, 39],
	  'blue' : [34, 39],
	  'cyan' : [36, 39],
	  'green' : [32, 39],
	  'magenta' : [35, 39],
	  'red' : [31, 39],
	  'yellow' : [33, 39]
	};

	// Don't use 'blue' not visible on cmd.exe
	inspect.styles = {
	  'special': 'cyan',
	  'number': 'yellow',
	  'boolean': 'yellow',
	  'undefined': 'grey',
	  'null': 'bold',
	  'string': 'green',
	  'date': 'magenta',
	  // "name": intentionally not styling
	  'regexp': 'red'
	};


	function stylizeWithColor(str, styleType) {
	  var style = inspect.styles[styleType];

	  if (style) {
	    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
	           '\u001b[' + inspect.colors[style][1] + 'm';
	  } else {
	    return str;
	  }
	}


	function stylizeNoColor(str, styleType) {
	  return str;
	}


	function arrayToHash(array) {
	  var hash = {};

	  array.forEach(function(val, idx) {
	    hash[val] = true;
	  });

	  return hash;
	}


	function formatValue(ctx, value, recurseTimes) {
	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it
	  if (ctx.customInspect &&
	      value &&
	      isFunction(value.inspect) &&
	      // Filter out the util module, it's inspect function is special
	      value.inspect !== exports.inspect &&
	      // Also filter out any prototype objects using the circular check.
	      !(value.constructor && value.constructor.prototype === value)) {
	    var ret = value.inspect(recurseTimes, ctx);
	    if (!isString(ret)) {
	      ret = formatValue(ctx, ret, recurseTimes);
	    }
	    return ret;
	  }

	  // Primitive types cannot have properties
	  var primitive = formatPrimitive(ctx, value);
	  if (primitive) {
	    return primitive;
	  }

	  // Look up the keys of the object.
	  var keys = Object.keys(value);
	  var visibleKeys = arrayToHash(keys);

	  if (ctx.showHidden) {
	    keys = Object.getOwnPropertyNames(value);
	  }

	  // IE doesn't make error fields non-enumerable
	  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
	  if (isError(value)
	      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
	    return formatError(value);
	  }

	  // Some type of object without properties can be shortcutted.
	  if (keys.length === 0) {
	    if (isFunction(value)) {
	      var name = value.name ? ': ' + value.name : '';
	      return ctx.stylize('[Function' + name + ']', 'special');
	    }
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    }
	    if (isDate(value)) {
	      return ctx.stylize(Date.prototype.toString.call(value), 'date');
	    }
	    if (isError(value)) {
	      return formatError(value);
	    }
	  }

	  var base = '', array = false, braces = ['{', '}'];

	  // Make Array say that they are Array
	  if (isArray(value)) {
	    array = true;
	    braces = ['[', ']'];
	  }

	  // Make functions say that they are functions
	  if (isFunction(value)) {
	    var n = value.name ? ': ' + value.name : '';
	    base = ' [Function' + n + ']';
	  }

	  // Make RegExps say that they are RegExps
	  if (isRegExp(value)) {
	    base = ' ' + RegExp.prototype.toString.call(value);
	  }

	  // Make dates with properties first say the date
	  if (isDate(value)) {
	    base = ' ' + Date.prototype.toUTCString.call(value);
	  }

	  // Make error with message first say the error
	  if (isError(value)) {
	    base = ' ' + formatError(value);
	  }

	  if (keys.length === 0 && (!array || value.length == 0)) {
	    return braces[0] + base + braces[1];
	  }

	  if (recurseTimes < 0) {
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    } else {
	      return ctx.stylize('[Object]', 'special');
	    }
	  }

	  ctx.seen.push(value);

	  var output;
	  if (array) {
	    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
	  } else {
	    output = keys.map(function(key) {
	      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
	    });
	  }

	  ctx.seen.pop();

	  return reduceToSingleString(output, base, braces);
	}


	function formatPrimitive(ctx, value) {
	  if (isUndefined(value))
	    return ctx.stylize('undefined', 'undefined');
	  if (isString(value)) {
	    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
	                                             .replace(/'/g, "\\'")
	                                             .replace(/\\"/g, '"') + '\'';
	    return ctx.stylize(simple, 'string');
	  }
	  if (isNumber(value))
	    return ctx.stylize('' + value, 'number');
	  if (isBoolean(value))
	    return ctx.stylize('' + value, 'boolean');
	  // For some reason typeof null is "object", so special case here.
	  if (isNull(value))
	    return ctx.stylize('null', 'null');
	}


	function formatError(value) {
	  return '[' + Error.prototype.toString.call(value) + ']';
	}


	function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
	  var output = [];
	  for (var i = 0, l = value.length; i < l; ++i) {
	    if (hasOwnProperty(value, String(i))) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          String(i), true));
	    } else {
	      output.push('');
	    }
	  }
	  keys.forEach(function(key) {
	    if (!key.match(/^\d+$/)) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          key, true));
	    }
	  });
	  return output;
	}


	function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
	  var name, str, desc;
	  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
	  if (desc.get) {
	    if (desc.set) {
	      str = ctx.stylize('[Getter/Setter]', 'special');
	    } else {
	      str = ctx.stylize('[Getter]', 'special');
	    }
	  } else {
	    if (desc.set) {
	      str = ctx.stylize('[Setter]', 'special');
	    }
	  }
	  if (!hasOwnProperty(visibleKeys, key)) {
	    name = '[' + key + ']';
	  }
	  if (!str) {
	    if (ctx.seen.indexOf(desc.value) < 0) {
	      if (isNull(recurseTimes)) {
	        str = formatValue(ctx, desc.value, null);
	      } else {
	        str = formatValue(ctx, desc.value, recurseTimes - 1);
	      }
	      if (str.indexOf('\n') > -1) {
	        if (array) {
	          str = str.split('\n').map(function(line) {
	            return '  ' + line;
	          }).join('\n').substr(2);
	        } else {
	          str = '\n' + str.split('\n').map(function(line) {
	            return '   ' + line;
	          }).join('\n');
	        }
	      }
	    } else {
	      str = ctx.stylize('[Circular]', 'special');
	    }
	  }
	  if (isUndefined(name)) {
	    if (array && key.match(/^\d+$/)) {
	      return str;
	    }
	    name = JSON.stringify('' + key);
	    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
	      name = name.substr(1, name.length - 2);
	      name = ctx.stylize(name, 'name');
	    } else {
	      name = name.replace(/'/g, "\\'")
	                 .replace(/\\"/g, '"')
	                 .replace(/(^"|"$)/g, "'");
	      name = ctx.stylize(name, 'string');
	    }
	  }

	  return name + ': ' + str;
	}


	function reduceToSingleString(output, base, braces) {
	  var numLinesEst = 0;
	  var length = output.reduce(function(prev, cur) {
	    numLinesEst++;
	    if (cur.indexOf('\n') >= 0) numLinesEst++;
	    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
	  }, 0);

	  if (length > 60) {
	    return braces[0] +
	           (base === '' ? '' : base + '\n ') +
	           ' ' +
	           output.join(',\n  ') +
	           ' ' +
	           braces[1];
	  }

	  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
	}


	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	function isArray(ar) {
	  return Array.isArray(ar);
	}
	exports.isArray = isArray;

	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	exports.isBoolean = isBoolean;

	function isNull(arg) {
	  return arg === null;
	}
	exports.isNull = isNull;

	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	exports.isNullOrUndefined = isNullOrUndefined;

	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	exports.isNumber = isNumber;

	function isString(arg) {
	  return typeof arg === 'string';
	}
	exports.isString = isString;

	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	exports.isSymbol = isSymbol;

	function isUndefined(arg) {
	  return arg === void 0;
	}
	exports.isUndefined = isUndefined;

	function isRegExp(re) {
	  return isObject(re) && objectToString(re) === '[object RegExp]';
	}
	exports.isRegExp = isRegExp;

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	exports.isObject = isObject;

	function isDate(d) {
	  return isObject(d) && objectToString(d) === '[object Date]';
	}
	exports.isDate = isDate;

	function isError(e) {
	  return isObject(e) &&
	      (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	exports.isError = isError;

	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	exports.isFunction = isFunction;

	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	exports.isPrimitive = isPrimitive;

	exports.isBuffer = __webpack_require__(12);

	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}


	function pad(n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	}


	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
	              'Oct', 'Nov', 'Dec'];

	// 26 Feb 16:19:34
	function timestamp() {
	  var d = new Date();
	  var time = [pad(d.getHours()),
	              pad(d.getMinutes()),
	              pad(d.getSeconds())].join(':');
	  return [d.getDate(), months[d.getMonth()], time].join(' ');
	}


	// log is just a thin wrapper to console.log that prepends a timestamp
	exports.log = function() {
	  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
	};


	/**
	 * Inherit the prototype methods from one constructor into another.
	 *
	 * The Function.prototype.inherits from lang.js rewritten as a standalone
	 * function (not on Function.prototype). NOTE: If this file is to be loaded
	 * during bootstrapping this function needs to be rewritten using some native
	 * functions as prototype setup using normal JavaScript does not work as
	 * expected during bootstrapping (see mirror.js in r114903).
	 *
	 * @param {function} ctor Constructor function which needs to inherit the
	 *     prototype.
	 * @param {function} superCtor Constructor function to inherit prototype from.
	 */
	exports.inherits = __webpack_require__(13);

	exports._extend = function(origin, add) {
	  // Don't do anything if add isn't an object
	  if (!add || !isObject(add)) return origin;

	  var keys = Object.keys(add);
	  var i = keys.length;
	  while (i--) {
	    origin[keys[i]] = add[keys[i]];
	  }
	  return origin;
	};

	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(1)))

/***/ },
/* 12 */
/***/ function(module, exports) {

	module.exports = function isBuffer(arg) {
	  return arg && typeof arg === 'object'
	    && typeof arg.copy === 'function'
	    && typeof arg.fill === 'function'
	    && typeof arg.readUInt8 === 'function';
	}

/***/ },
/* 13 */
/***/ function(module, exports) {

	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  // old school shim for old browsers
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    var TempCtor = function () {}
	    TempCtor.prototype = superCtor.prototype
	    ctor.prototype = new TempCtor()
	    ctor.prototype.constructor = ctor
	  }
	}


/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(module, global) {/**
	 * @license
	 * Lo-Dash 2.4.2 (Custom Build) <https://lodash.com/>
	 * Build: `lodash -o ./dist/lodash.compat.js`
	 * Copyright 2012-2013 The Dojo Foundation <http://dojofoundation.org/>
	 * Based on Underscore.js 1.5.2 <http://underscorejs.org/LICENSE>
	 * Copyright 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 * Available under MIT license <https://lodash.com/license>
	 */
	;(function() {

	  /** Used as a safe reference for `undefined` in pre ES5 environments */
	  var undefined;

	  /** Used to pool arrays and objects used internally */
	  var arrayPool = [],
	      objectPool = [];

	  /** Used to generate unique IDs */
	  var idCounter = 0;

	  /** Used internally to indicate various things */
	  var indicatorObject = {};

	  /** Used to prefix keys to avoid issues with `__proto__` and properties on `Object.prototype` */
	  var keyPrefix = +new Date + '';

	  /** Used as the size when optimizations are enabled for large arrays */
	  var largeArraySize = 75;

	  /** Used as the max size of the `arrayPool` and `objectPool` */
	  var maxPoolSize = 40;

	  /** Used to detect and test whitespace */
	  var whitespace = (
	    // whitespace
	    ' \t\x0B\f\xA0\ufeff' +

	    // line terminators
	    '\n\r\u2028\u2029' +

	    // unicode category "Zs" space separators
	    '\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000'
	  );

	  /** Used to match empty string literals in compiled template source */
	  var reEmptyStringLeading = /\b__p \+= '';/g,
	      reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
	      reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;

	  /**
	   * Used to match ES6 template delimiters
	   * http://people.mozilla.org/~jorendorff/es6-draft.html#sec-literals-string-literals
	   */
	  var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;

	  /** Used to match regexp flags from their coerced string values */
	  var reFlags = /\w*$/;

	  /** Used to detected named functions */
	  var reFuncName = /^\s*function[ \n\r\t]+\w/;

	  /** Used to match "interpolate" template delimiters */
	  var reInterpolate = /<%=([\s\S]+?)%>/g;

	  /** Used to match leading whitespace and zeros to be removed */
	  var reLeadingSpacesAndZeros = RegExp('^[' + whitespace + ']*0+(?=.$)');

	  /** Used to ensure capturing order of template delimiters */
	  var reNoMatch = /($^)/;

	  /** Used to detect functions containing a `this` reference */
	  var reThis = /\bthis\b/;

	  /** Used to match unescaped characters in compiled string literals */
	  var reUnescapedString = /['\n\r\t\u2028\u2029\\]/g;

	  /** Used to assign default `context` object properties */
	  var contextProps = [
	    'Array', 'Boolean', 'Date', 'Error', 'Function', 'Math', 'Number', 'Object',
	    'RegExp', 'String', '_', 'attachEvent', 'clearTimeout', 'isFinite', 'isNaN',
	    'parseInt', 'setTimeout'
	  ];

	  /** Used to fix the JScript [[DontEnum]] bug */
	  var shadowedProps = [
	    'constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable',
	    'toLocaleString', 'toString', 'valueOf'
	  ];

	  /** Used to make template sourceURLs easier to identify */
	  var templateCounter = 0;

	  /** `Object#toString` result shortcuts */
	  var argsClass = '[object Arguments]',
	      arrayClass = '[object Array]',
	      boolClass = '[object Boolean]',
	      dateClass = '[object Date]',
	      errorClass = '[object Error]',
	      funcClass = '[object Function]',
	      numberClass = '[object Number]',
	      objectClass = '[object Object]',
	      regexpClass = '[object RegExp]',
	      stringClass = '[object String]';

	  /** Used to identify object classifications that `_.clone` supports */
	  var cloneableClasses = {};
	  cloneableClasses[funcClass] = false;
	  cloneableClasses[argsClass] = cloneableClasses[arrayClass] =
	  cloneableClasses[boolClass] = cloneableClasses[dateClass] =
	  cloneableClasses[numberClass] = cloneableClasses[objectClass] =
	  cloneableClasses[regexpClass] = cloneableClasses[stringClass] = true;

	  /** Used as an internal `_.debounce` options object */
	  var debounceOptions = {
	    'leading': false,
	    'maxWait': 0,
	    'trailing': false
	  };

	  /** Used as the property descriptor for `__bindData__` */
	  var descriptor = {
	    'configurable': false,
	    'enumerable': false,
	    'value': null,
	    'writable': false
	  };

	  /** Used as the data object for `iteratorTemplate` */
	  var iteratorData = {
	    'args': '',
	    'array': null,
	    'bottom': '',
	    'firstArg': '',
	    'init': '',
	    'keys': null,
	    'loop': '',
	    'shadowedProps': null,
	    'support': null,
	    'top': '',
	    'useHas': false
	  };

	  /** Used to determine if values are of the language type Object */
	  var objectTypes = {
	    'boolean': false,
	    'function': true,
	    'object': true,
	    'number': false,
	    'string': false,
	    'undefined': false
	  };

	  /** Used to escape characters for inclusion in compiled string literals */
	  var stringEscapes = {
	    '\\': '\\',
	    "'": "'",
	    '\n': 'n',
	    '\r': 'r',
	    '\t': 't',
	    '\u2028': 'u2028',
	    '\u2029': 'u2029'
	  };

	  /** Used as a reference to the global object */
	  var root = (objectTypes[typeof window] && window) || this;

	  /** Detect free variable `exports` */
	  var freeExports = objectTypes[typeof exports] && exports && !exports.nodeType && exports;

	  /** Detect free variable `module` */
	  var freeModule = objectTypes[typeof module] && module && !module.nodeType && module;

	  /** Detect the popular CommonJS extension `module.exports` */
	  var moduleExports = freeModule && freeModule.exports === freeExports && freeExports;

	  /** Detect free variable `global` from Node.js or Browserified code and use it as `root` */
	  var freeGlobal = objectTypes[typeof global] && global;
	  if (freeGlobal && (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal)) {
	    root = freeGlobal;
	  }

	  /*--------------------------------------------------------------------------*/

	  /**
	   * The base implementation of `_.indexOf` without support for binary searches
	   * or `fromIndex` constraints.
	   *
	   * @private
	   * @param {Array} array The array to search.
	   * @param {*} value The value to search for.
	   * @param {number} [fromIndex=0] The index to search from.
	   * @returns {number} Returns the index of the matched value or `-1`.
	   */
	  function baseIndexOf(array, value, fromIndex) {
	    var index = (fromIndex || 0) - 1,
	        length = array ? array.length : 0;

	    while (++index < length) {
	      if (array[index] === value) {
	        return index;
	      }
	    }
	    return -1;
	  }

	  /**
	   * An implementation of `_.contains` for cache objects that mimics the return
	   * signature of `_.indexOf` by returning `0` if the value is found, else `-1`.
	   *
	   * @private
	   * @param {Object} cache The cache object to inspect.
	   * @param {*} value The value to search for.
	   * @returns {number} Returns `0` if `value` is found, else `-1`.
	   */
	  function cacheIndexOf(cache, value) {
	    var type = typeof value;
	    cache = cache.cache;

	    if (type == 'boolean' || value == null) {
	      return cache[value] ? 0 : -1;
	    }
	    if (type != 'number' && type != 'string') {
	      type = 'object';
	    }
	    var key = type == 'number' ? value : keyPrefix + value;
	    cache = (cache = cache[type]) && cache[key];

	    return type == 'object'
	      ? (cache && baseIndexOf(cache, value) > -1 ? 0 : -1)
	      : (cache ? 0 : -1);
	  }

	  /**
	   * Adds a given value to the corresponding cache object.
	   *
	   * @private
	   * @param {*} value The value to add to the cache.
	   */
	  function cachePush(value) {
	    var cache = this.cache,
	        type = typeof value;

	    if (type == 'boolean' || value == null) {
	      cache[value] = true;
	    } else {
	      if (type != 'number' && type != 'string') {
	        type = 'object';
	      }
	      var key = type == 'number' ? value : keyPrefix + value,
	          typeCache = cache[type] || (cache[type] = {});

	      if (type == 'object') {
	        (typeCache[key] || (typeCache[key] = [])).push(value);
	      } else {
	        typeCache[key] = true;
	      }
	    }
	  }

	  /**
	   * Used by `_.max` and `_.min` as the default callback when a given
	   * collection is a string value.
	   *
	   * @private
	   * @param {string} value The character to inspect.
	   * @returns {number} Returns the code unit of given character.
	   */
	  function charAtCallback(value) {
	    return value.charCodeAt(0);
	  }

	  /**
	   * Used by `sortBy` to compare transformed `collection` elements, stable sorting
	   * them in ascending order.
	   *
	   * @private
	   * @param {Object} a The object to compare to `b`.
	   * @param {Object} b The object to compare to `a`.
	   * @returns {number} Returns the sort order indicator of `1` or `-1`.
	   */
	  function compareAscending(a, b) {
	    var ac = a.criteria,
	        bc = b.criteria,
	        index = -1,
	        length = ac.length;

	    while (++index < length) {
	      var value = ac[index],
	          other = bc[index];

	      if (value !== other) {
	        if (value > other || typeof value == 'undefined') {
	          return 1;
	        }
	        if (value < other || typeof other == 'undefined') {
	          return -1;
	        }
	      }
	    }
	    // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
	    // that causes it, under certain circumstances, to return the same value for
	    // `a` and `b`. See https://github.com/jashkenas/underscore/pull/1247
	    //
	    // This also ensures a stable sort in V8 and other engines.
	    // See http://code.google.com/p/v8/issues/detail?id=90
	    return a.index - b.index;
	  }

	  /**
	   * Creates a cache object to optimize linear searches of large arrays.
	   *
	   * @private
	   * @param {Array} [array=[]] The array to search.
	   * @returns {null|Object} Returns the cache object or `null` if caching should not be used.
	   */
	  function createCache(array) {
	    var index = -1,
	        length = array.length,
	        first = array[0],
	        mid = array[(length / 2) | 0],
	        last = array[length - 1];

	    if (first && typeof first == 'object' &&
	        mid && typeof mid == 'object' && last && typeof last == 'object') {
	      return false;
	    }
	    var cache = getObject();
	    cache['false'] = cache['null'] = cache['true'] = cache['undefined'] = false;

	    var result = getObject();
	    result.array = array;
	    result.cache = cache;
	    result.push = cachePush;

	    while (++index < length) {
	      result.push(array[index]);
	    }
	    return result;
	  }

	  /**
	   * Used by `template` to escape characters for inclusion in compiled
	   * string literals.
	   *
	   * @private
	   * @param {string} match The matched character to escape.
	   * @returns {string} Returns the escaped character.
	   */
	  function escapeStringChar(match) {
	    return '\\' + stringEscapes[match];
	  }

	  /**
	   * Gets an array from the array pool or creates a new one if the pool is empty.
	   *
	   * @private
	   * @returns {Array} The array from the pool.
	   */
	  function getArray() {
	    return arrayPool.pop() || [];
	  }

	  /**
	   * Gets an object from the object pool or creates a new one if the pool is empty.
	   *
	   * @private
	   * @returns {Object} The object from the pool.
	   */
	  function getObject() {
	    return objectPool.pop() || {
	      'array': null,
	      'cache': null,
	      'criteria': null,
	      'false': false,
	      'index': 0,
	      'null': false,
	      'number': null,
	      'object': null,
	      'push': null,
	      'string': null,
	      'true': false,
	      'undefined': false,
	      'value': null
	    };
	  }

	  /**
	   * Checks if `value` is a DOM node in IE < 9.
	   *
	   * @private
	   * @param {*} value The value to check.
	   * @returns {boolean} Returns `true` if the `value` is a DOM node, else `false`.
	   */
	  function isNode(value) {
	    // IE < 9 presents DOM nodes as `Object` objects except they have `toString`
	    // methods that are `typeof` "string" and still can coerce nodes to strings
	    return typeof value.toString != 'function' && typeof (value + '') == 'string';
	  }

	  /**
	   * Releases the given array back to the array pool.
	   *
	   * @private
	   * @param {Array} [array] The array to release.
	   */
	  function releaseArray(array) {
	    array.length = 0;
	    if (arrayPool.length < maxPoolSize) {
	      arrayPool.push(array);
	    }
	  }

	  /**
	   * Releases the given object back to the object pool.
	   *
	   * @private
	   * @param {Object} [object] The object to release.
	   */
	  function releaseObject(object) {
	    var cache = object.cache;
	    if (cache) {
	      releaseObject(cache);
	    }
	    object.array = object.cache = object.criteria = object.object = object.number = object.string = object.value = null;
	    if (objectPool.length < maxPoolSize) {
	      objectPool.push(object);
	    }
	  }

	  /**
	   * Slices the `collection` from the `start` index up to, but not including,
	   * the `end` index.
	   *
	   * Note: This function is used instead of `Array#slice` to support node lists
	   * in IE < 9 and to ensure dense arrays are returned.
	   *
	   * @private
	   * @param {Array|Object|string} collection The collection to slice.
	   * @param {number} start The start index.
	   * @param {number} end The end index.
	   * @returns {Array} Returns the new array.
	   */
	  function slice(array, start, end) {
	    start || (start = 0);
	    if (typeof end == 'undefined') {
	      end = array ? array.length : 0;
	    }
	    var index = -1,
	        length = end - start || 0,
	        result = Array(length < 0 ? 0 : length);

	    while (++index < length) {
	      result[index] = array[start + index];
	    }
	    return result;
	  }

	  /*--------------------------------------------------------------------------*/

	  /**
	   * Create a new `lodash` function using the given context object.
	   *
	   * @static
	   * @memberOf _
	   * @category Utilities
	   * @param {Object} [context=root] The context object.
	   * @returns {Function} Returns the `lodash` function.
	   */
	  function runInContext(context) {
	    // Avoid issues with some ES3 environments that attempt to use values, named
	    // after built-in constructors like `Object`, for the creation of literals.
	    // ES5 clears this up by stating that literals must use built-in constructors.
	    // See http://es5.github.io/#x11.1.5.
	    context = context ? _.defaults(root.Object(), context, _.pick(root, contextProps)) : root;

	    /** Native constructor references */
	    var Array = context.Array,
	        Boolean = context.Boolean,
	        Date = context.Date,
	        Error = context.Error,
	        Function = context.Function,
	        Math = context.Math,
	        Number = context.Number,
	        Object = context.Object,
	        RegExp = context.RegExp,
	        String = context.String,
	        TypeError = context.TypeError;

	    /**
	     * Used for `Array` method references.
	     *
	     * Normally `Array.prototype` would suffice, however, using an array literal
	     * avoids issues in Narwhal.
	     */
	    var arrayRef = [];

	    /** Used for native method references */
	    var errorProto = Error.prototype,
	        objectProto = Object.prototype,
	        stringProto = String.prototype;

	    /** Used to restore the original `_` reference in `noConflict` */
	    var oldDash = context._;

	    /** Used to resolve the internal [[Class]] of values */
	    var toString = objectProto.toString;

	    /** Used to detect if a method is native */
	    var reNative = RegExp('^' +
	      String(toString)
	        .replace(/[.*+?^${}()|[\]\\]/g, '\\$&')
	        .replace(/toString| for [^\]]+/g, '.*?') + '$'
	    );

	    /** Native method shortcuts */
	    var ceil = Math.ceil,
	        clearTimeout = context.clearTimeout,
	        floor = Math.floor,
	        fnToString = Function.prototype.toString,
	        getPrototypeOf = isNative(getPrototypeOf = Object.getPrototypeOf) && getPrototypeOf,
	        hasOwnProperty = objectProto.hasOwnProperty,
	        push = arrayRef.push,
	        propertyIsEnumerable = objectProto.propertyIsEnumerable,
	        setTimeout = context.setTimeout,
	        splice = arrayRef.splice,
	        unshift = arrayRef.unshift;

	    /** Used to set meta data on functions */
	    var defineProperty = (function() {
	      // IE 8 only accepts DOM elements
	      try {
	        var o = {},
	            func = isNative(func = Object.defineProperty) && func,
	            result = func(o, o, o) && func;
	      } catch(e) { }
	      return result;
	    }());

	    /* Native method shortcuts for methods with the same name as other `lodash` methods */
	    var nativeCreate = isNative(nativeCreate = Object.create) && nativeCreate,
	        nativeIsArray = isNative(nativeIsArray = Array.isArray) && nativeIsArray,
	        nativeIsFinite = context.isFinite,
	        nativeIsNaN = context.isNaN,
	        nativeKeys = isNative(nativeKeys = Object.keys) && nativeKeys,
	        nativeMax = Math.max,
	        nativeMin = Math.min,
	        nativeParseInt = context.parseInt,
	        nativeRandom = Math.random;

	    /** Used to lookup a built-in constructor by [[Class]] */
	    var ctorByClass = {};
	    ctorByClass[arrayClass] = Array;
	    ctorByClass[boolClass] = Boolean;
	    ctorByClass[dateClass] = Date;
	    ctorByClass[funcClass] = Function;
	    ctorByClass[objectClass] = Object;
	    ctorByClass[numberClass] = Number;
	    ctorByClass[regexpClass] = RegExp;
	    ctorByClass[stringClass] = String;

	    /** Used to avoid iterating non-enumerable properties in IE < 9 */
	    var nonEnumProps = {};
	    nonEnumProps[arrayClass] = nonEnumProps[dateClass] = nonEnumProps[numberClass] = { 'constructor': true, 'toLocaleString': true, 'toString': true, 'valueOf': true };
	    nonEnumProps[boolClass] = nonEnumProps[stringClass] = { 'constructor': true, 'toString': true, 'valueOf': true };
	    nonEnumProps[errorClass] = nonEnumProps[funcClass] = nonEnumProps[regexpClass] = { 'constructor': true, 'toString': true };
	    nonEnumProps[objectClass] = { 'constructor': true };

	    (function() {
	      var length = shadowedProps.length;
	      while (length--) {
	        var key = shadowedProps[length];
	        for (var className in nonEnumProps) {
	          if (hasOwnProperty.call(nonEnumProps, className) && !hasOwnProperty.call(nonEnumProps[className], key)) {
	            nonEnumProps[className][key] = false;
	          }
	        }
	      }
	    }());

	    /*--------------------------------------------------------------------------*/

	    /**
	     * Creates a `lodash` object which wraps the given value to enable intuitive
	     * method chaining.
	     *
	     * In addition to Lo-Dash methods, wrappers also have the following `Array` methods:
	     * `concat`, `join`, `pop`, `push`, `reverse`, `shift`, `slice`, `sort`, `splice`,
	     * and `unshift`
	     *
	     * Chaining is supported in custom builds as long as the `value` method is
	     * implicitly or explicitly included in the build.
	     *
	     * The chainable wrapper functions are:
	     * `after`, `assign`, `bind`, `bindAll`, `bindKey`, `chain`, `compact`,
	     * `compose`, `concat`, `countBy`, `create`, `createCallback`, `curry`,
	     * `debounce`, `defaults`, `defer`, `delay`, `difference`, `filter`, `flatten`,
	     * `forEach`, `forEachRight`, `forIn`, `forInRight`, `forOwn`, `forOwnRight`,
	     * `functions`, `groupBy`, `indexBy`, `initial`, `intersection`, `invert`,
	     * `invoke`, `keys`, `map`, `max`, `memoize`, `merge`, `min`, `object`, `omit`,
	     * `once`, `pairs`, `partial`, `partialRight`, `pick`, `pluck`, `pull`, `push`,
	     * `range`, `reject`, `remove`, `rest`, `reverse`, `shuffle`, `slice`, `sort`,
	     * `sortBy`, `splice`, `tap`, `throttle`, `times`, `toArray`, `transform`,
	     * `union`, `uniq`, `unshift`, `unzip`, `values`, `where`, `without`, `wrap`,
	     * and `zip`
	     *
	     * The non-chainable wrapper functions are:
	     * `clone`, `cloneDeep`, `contains`, `escape`, `every`, `find`, `findIndex`,
	     * `findKey`, `findLast`, `findLastIndex`, `findLastKey`, `has`, `identity`,
	     * `indexOf`, `isArguments`, `isArray`, `isBoolean`, `isDate`, `isElement`,
	     * `isEmpty`, `isEqual`, `isFinite`, `isFunction`, `isNaN`, `isNull`, `isNumber`,
	     * `isObject`, `isPlainObject`, `isRegExp`, `isString`, `isUndefined`, `join`,
	     * `lastIndexOf`, `mixin`, `noConflict`, `parseInt`, `pop`, `random`, `reduce`,
	     * `reduceRight`, `result`, `shift`, `size`, `some`, `sortedIndex`, `runInContext`,
	     * `template`, `unescape`, `uniqueId`, and `value`
	     *
	     * The wrapper functions `first` and `last` return wrapped values when `n` is
	     * provided, otherwise they return unwrapped values.
	     *
	     * Explicit chaining can be enabled by using the `_.chain` method.
	     *
	     * @name _
	     * @constructor
	     * @category Chaining
	     * @param {*} value The value to wrap in a `lodash` instance.
	     * @returns {Object} Returns a `lodash` instance.
	     * @example
	     *
	     * var wrapped = _([1, 2, 3]);
	     *
	     * // returns an unwrapped value
	     * wrapped.reduce(function(sum, num) {
	     *   return sum + num;
	     * });
	     * // => 6
	     *
	     * // returns a wrapped value
	     * var squares = wrapped.map(function(num) {
	     *   return num * num;
	     * });
	     *
	     * _.isArray(squares);
	     * // => false
	     *
	     * _.isArray(squares.value());
	     * // => true
	     */
	    function lodash(value) {
	      // don't wrap if already wrapped, even if wrapped by a different `lodash` constructor
	      return (value && typeof value == 'object' && !isArray(value) && hasOwnProperty.call(value, '__wrapped__'))
	       ? value
	       : new lodashWrapper(value);
	    }

	    /**
	     * A fast path for creating `lodash` wrapper objects.
	     *
	     * @private
	     * @param {*} value The value to wrap in a `lodash` instance.
	     * @param {boolean} chainAll A flag to enable chaining for all methods
	     * @returns {Object} Returns a `lodash` instance.
	     */
	    function lodashWrapper(value, chainAll) {
	      this.__chain__ = !!chainAll;
	      this.__wrapped__ = value;
	    }
	    // ensure `new lodashWrapper` is an instance of `lodash`
	    lodashWrapper.prototype = lodash.prototype;

	    /**
	     * An object used to flag environments features.
	     *
	     * @static
	     * @memberOf _
	     * @type Object
	     */
	    var support = lodash.support = {};

	    (function() {
	      var ctor = function() { this.x = 1; },
	          object = { '0': 1, 'length': 1 },
	          props = [];

	      ctor.prototype = { 'valueOf': 1, 'y': 1 };
	      for (var key in new ctor) { props.push(key); }
	      for (key in arguments) { }

	      /**
	       * Detect if an `arguments` object's [[Class]] is resolvable (all but Firefox < 4, IE < 9).
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.argsClass = toString.call(arguments) == argsClass;

	      /**
	       * Detect if `arguments` objects are `Object` objects (all but Narwhal and Opera < 10.5).
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.argsObject = arguments.constructor == Object && !(arguments instanceof Array);

	      /**
	       * Detect if `name` or `message` properties of `Error.prototype` are
	       * enumerable by default. (IE < 9, Safari < 5.1)
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.enumErrorProps = propertyIsEnumerable.call(errorProto, 'message') || propertyIsEnumerable.call(errorProto, 'name');

	      /**
	       * Detect if `prototype` properties are enumerable by default.
	       *
	       * Firefox < 3.6, Opera > 9.50 - Opera < 11.60, and Safari < 5.1
	       * (if the prototype or a property on the prototype has been set)
	       * incorrectly sets a function's `prototype` property [[Enumerable]]
	       * value to `true`.
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.enumPrototypes = propertyIsEnumerable.call(ctor, 'prototype');

	      /**
	       * Detect if functions can be decompiled by `Function#toString`
	       * (all but PS3 and older Opera mobile browsers & avoided in Windows 8 apps).
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.funcDecomp = !isNative(context.WinRTError) && reThis.test(runInContext);

	      /**
	       * Detect if `Function#name` is supported (all but IE).
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.funcNames = typeof Function.name == 'string';

	      /**
	       * Detect if `arguments` object indexes are non-enumerable
	       * (Firefox < 4, IE < 9, PhantomJS, Safari < 5.1).
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.nonEnumArgs = key != 0;

	      /**
	       * Detect if properties shadowing those on `Object.prototype` are non-enumerable.
	       *
	       * In IE < 9 an objects own properties, shadowing non-enumerable ones, are
	       * made non-enumerable as well (a.k.a the JScript [[DontEnum]] bug).
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.nonEnumShadows = !/valueOf/.test(props);

	      /**
	       * Detect if own properties are iterated after inherited properties (all but IE < 9).
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.ownLast = props[0] != 'x';

	      /**
	       * Detect if `Array#shift` and `Array#splice` augment array-like objects correctly.
	       *
	       * Firefox < 10, IE compatibility mode, and IE < 9 have buggy Array `shift()`
	       * and `splice()` functions that fail to remove the last element, `value[0]`,
	       * of array-like objects even though the `length` property is set to `0`.
	       * The `shift()` method is buggy in IE 8 compatibility mode, while `splice()`
	       * is buggy regardless of mode in IE < 9 and buggy in compatibility mode in IE 9.
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.spliceObjects = (arrayRef.splice.call(object, 0, 1), !object[0]);

	      /**
	       * Detect lack of support for accessing string characters by index.
	       *
	       * IE < 8 can't access characters by index and IE 8 can only access
	       * characters by index on string literals.
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      support.unindexedChars = ('x'[0] + Object('x')[0]) != 'xx';

	      /**
	       * Detect if a DOM node's [[Class]] is resolvable (all but IE < 9)
	       * and that the JS engine errors when attempting to coerce an object to
	       * a string without a `toString` function.
	       *
	       * @memberOf _.support
	       * @type boolean
	       */
	      try {
	        support.nodeClass = !(toString.call(document) == objectClass && !({ 'toString': 0 } + ''));
	      } catch(e) {
	        support.nodeClass = true;
	      }
	    }(1));

	    /**
	     * By default, the template delimiters used by Lo-Dash are similar to those in
	     * embedded Ruby (ERB). Change the following template settings to use alternative
	     * delimiters.
	     *
	     * @static
	     * @memberOf _
	     * @type Object
	     */
	    lodash.templateSettings = {

	      /**
	       * Used to detect `data` property values to be HTML-escaped.
	       *
	       * @memberOf _.templateSettings
	       * @type RegExp
	       */
	      'escape': /<%-([\s\S]+?)%>/g,

	      /**
	       * Used to detect code to be evaluated.
	       *
	       * @memberOf _.templateSettings
	       * @type RegExp
	       */
	      'evaluate': /<%([\s\S]+?)%>/g,

	      /**
	       * Used to detect `data` property values to inject.
	       *
	       * @memberOf _.templateSettings
	       * @type RegExp
	       */
	      'interpolate': reInterpolate,

	      /**
	       * Used to reference the data object in the template text.
	       *
	       * @memberOf _.templateSettings
	       * @type string
	       */
	      'variable': '',

	      /**
	       * Used to import variables into the compiled template.
	       *
	       * @memberOf _.templateSettings
	       * @type Object
	       */
	      'imports': {

	        /**
	         * A reference to the `lodash` function.
	         *
	         * @memberOf _.templateSettings.imports
	         * @type Function
	         */
	        '_': lodash
	      }
	    };

	    /*--------------------------------------------------------------------------*/

	    /**
	     * The template used to create iterator functions.
	     *
	     * @private
	     * @param {Object} data The data object used to populate the text.
	     * @returns {string} Returns the interpolated text.
	     */
	    var iteratorTemplate = function(obj) {

	      var __p = 'var index, iterable = ' +
	      (obj.firstArg) +
	      ', result = ' +
	      (obj.init) +
	      ';\nif (!iterable) return result;\n' +
	      (obj.top) +
	      ';';
	       if (obj.array) {
	      __p += '\nvar length = iterable.length; index = -1;\nif (' +
	      (obj.array) +
	      ') {  ';
	       if (support.unindexedChars) {
	      __p += '\n  if (isString(iterable)) {\n    iterable = iterable.split(\'\')\n  }  ';
	       }
	      __p += '\n  while (++index < length) {\n    ' +
	      (obj.loop) +
	      ';\n  }\n}\nelse {  ';
	       } else if (support.nonEnumArgs) {
	      __p += '\n  var length = iterable.length; index = -1;\n  if (length && isArguments(iterable)) {\n    while (++index < length) {\n      index += \'\';\n      ' +
	      (obj.loop) +
	      ';\n    }\n  } else {  ';
	       }

	       if (support.enumPrototypes) {
	      __p += '\n  var skipProto = typeof iterable == \'function\';\n  ';
	       }

	       if (support.enumErrorProps) {
	      __p += '\n  var skipErrorProps = iterable === errorProto || iterable instanceof Error;\n  ';
	       }

	          var conditions = [];    if (support.enumPrototypes) { conditions.push('!(skipProto && index == "prototype")'); }    if (support.enumErrorProps)  { conditions.push('!(skipErrorProps && (index == "message" || index == "name"))'); }

	       if (obj.useHas && obj.keys) {
	      __p += '\n  var ownIndex = -1,\n      ownProps = objectTypes[typeof iterable] && keys(iterable),\n      length = ownProps ? ownProps.length : 0;\n\n  while (++ownIndex < length) {\n    index = ownProps[ownIndex];\n';
	          if (conditions.length) {
	      __p += '    if (' +
	      (conditions.join(' && ')) +
	      ') {\n  ';
	       }
	      __p +=
	      (obj.loop) +
	      ';    ';
	       if (conditions.length) {
	      __p += '\n    }';
	       }
	      __p += '\n  }  ';
	       } else {
	      __p += '\n  for (index in iterable) {\n';
	          if (obj.useHas) { conditions.push("hasOwnProperty.call(iterable, index)"); }    if (conditions.length) {
	      __p += '    if (' +
	      (conditions.join(' && ')) +
	      ') {\n  ';
	       }
	      __p +=
	      (obj.loop) +
	      ';    ';
	       if (conditions.length) {
	      __p += '\n    }';
	       }
	      __p += '\n  }    ';
	       if (support.nonEnumShadows) {
	      __p += '\n\n  if (iterable !== objectProto) {\n    var ctor = iterable.constructor,\n        isProto = iterable === (ctor && ctor.prototype),\n        className = iterable === stringProto ? stringClass : iterable === errorProto ? errorClass : toString.call(iterable),\n        nonEnum = nonEnumProps[className];\n      ';
	       for (k = 0; k < 7; k++) {
	      __p += '\n    index = \'' +
	      (obj.shadowedProps[k]) +
	      '\';\n    if ((!(isProto && nonEnum[index]) && hasOwnProperty.call(iterable, index))';
	              if (!obj.useHas) {
	      __p += ' || (!nonEnum[index] && iterable[index] !== objectProto[index])';
	       }
	      __p += ') {\n      ' +
	      (obj.loop) +
	      ';\n    }      ';
	       }
	      __p += '\n  }    ';
	       }

	       }

	       if (obj.array || support.nonEnumArgs) {
	      __p += '\n}';
	       }
	      __p +=
	      (obj.bottom) +
	      ';\nreturn result';

	      return __p
	    };

	    /*--------------------------------------------------------------------------*/

	    /**
	     * The base implementation of `_.bind` that creates the bound function and
	     * sets its meta data.
	     *
	     * @private
	     * @param {Array} bindData The bind data array.
	     * @returns {Function} Returns the new bound function.
	     */
	    function baseBind(bindData) {
	      var func = bindData[0],
	          partialArgs = bindData[2],
	          thisArg = bindData[4];

	      function bound() {
	        // `Function#bind` spec
	        // http://es5.github.io/#x15.3.4.5
	        if (partialArgs) {
	          // avoid `arguments` object deoptimizations by using `slice` instead
	          // of `Array.prototype.slice.call` and not assigning `arguments` to a
	          // variable as a ternary expression
	          var args = slice(partialArgs);
	          push.apply(args, arguments);
	        }
	        // mimic the constructor's `return` behavior
	        // http://es5.github.io/#x13.2.2
	        if (this instanceof bound) {
	          // ensure `new bound` is an instance of `func`
	          var thisBinding = baseCreate(func.prototype),
	              result = func.apply(thisBinding, args || arguments);
	          return isObject(result) ? result : thisBinding;
	        }
	        return func.apply(thisArg, args || arguments);
	      }
	      setBindData(bound, bindData);
	      return bound;
	    }

	    /**
	     * The base implementation of `_.clone` without argument juggling or support
	     * for `thisArg` binding.
	     *
	     * @private
	     * @param {*} value The value to clone.
	     * @param {boolean} [isDeep=false] Specify a deep clone.
	     * @param {Function} [callback] The function to customize cloning values.
	     * @param {Array} [stackA=[]] Tracks traversed source objects.
	     * @param {Array} [stackB=[]] Associates clones with source counterparts.
	     * @returns {*} Returns the cloned value.
	     */
	    function baseClone(value, isDeep, callback, stackA, stackB) {
	      if (callback) {
	        var result = callback(value);
	        if (typeof result != 'undefined') {
	          return result;
	        }
	      }
	      // inspect [[Class]]
	      var isObj = isObject(value);
	      if (isObj) {
	        var className = toString.call(value);
	        if (!cloneableClasses[className] || (!support.nodeClass && isNode(value))) {
	          return value;
	        }
	        var ctor = ctorByClass[className];
	        switch (className) {
	          case boolClass:
	          case dateClass:
	            return new ctor(+value);

	          case numberClass:
	          case stringClass:
	            return new ctor(value);

	          case regexpClass:
	            result = ctor(value.source, reFlags.exec(value));
	            result.lastIndex = value.lastIndex;
	            return result;
	        }
	      } else {
	        return value;
	      }
	      var isArr = isArray(value);
	      if (isDeep) {
	        // check for circular references and return corresponding clone
	        var initedStack = !stackA;
	        stackA || (stackA = getArray());
	        stackB || (stackB = getArray());

	        var length = stackA.length;
	        while (length--) {
	          if (stackA[length] == value) {
	            return stackB[length];
	          }
	        }
	        result = isArr ? ctor(value.length) : {};
	      }
	      else {
	        result = isArr ? slice(value) : assign({}, value);
	      }
	      // add array properties assigned by `RegExp#exec`
	      if (isArr) {
	        if (hasOwnProperty.call(value, 'index')) {
	          result.index = value.index;
	        }
	        if (hasOwnProperty.call(value, 'input')) {
	          result.input = value.input;
	        }
	      }
	      // exit for shallow clone
	      if (!isDeep) {
	        return result;
	      }
	      // add the source value to the stack of traversed objects
	      // and associate it with its clone
	      stackA.push(value);
	      stackB.push(result);

	      // recursively populate clone (susceptible to call stack limits)
	      (isArr ? baseEach : forOwn)(value, function(objValue, key) {
	        result[key] = baseClone(objValue, isDeep, callback, stackA, stackB);
	      });

	      if (initedStack) {
	        releaseArray(stackA);
	        releaseArray(stackB);
	      }
	      return result;
	    }

	    /**
	     * The base implementation of `_.create` without support for assigning
	     * properties to the created object.
	     *
	     * @private
	     * @param {Object} prototype The object to inherit from.
	     * @returns {Object} Returns the new object.
	     */
	    function baseCreate(prototype, properties) {
	      return isObject(prototype) ? nativeCreate(prototype) : {};
	    }
	    // fallback for browsers without `Object.create`
	    if (!nativeCreate) {
	      baseCreate = (function() {
	        function Object() {}
	        return function(prototype) {
	          if (isObject(prototype)) {
	            Object.prototype = prototype;
	            var result = new Object;
	            Object.prototype = null;
	          }
	          return result || context.Object();
	        };
	      }());
	    }

	    /**
	     * The base implementation of `_.createCallback` without support for creating
	     * "_.pluck" or "_.where" style callbacks.
	     *
	     * @private
	     * @param {*} [func=identity] The value to convert to a callback.
	     * @param {*} [thisArg] The `this` binding of the created callback.
	     * @param {number} [argCount] The number of arguments the callback accepts.
	     * @returns {Function} Returns a callback function.
	     */
	    function baseCreateCallback(func, thisArg, argCount) {
	      if (typeof func != 'function') {
	        return identity;
	      }
	      // exit early for no `thisArg` or already bound by `Function#bind`
	      if (typeof thisArg == 'undefined' || !('prototype' in func)) {
	        return func;
	      }
	      var bindData = func.__bindData__;
	      if (typeof bindData == 'undefined') {
	        if (support.funcNames) {
	          bindData = !func.name;
	        }
	        bindData = bindData || !support.funcDecomp;
	        if (!bindData) {
	          var source = fnToString.call(func);
	          if (!support.funcNames) {
	            bindData = !reFuncName.test(source);
	          }
	          if (!bindData) {
	            // checks if `func` references the `this` keyword and stores the result
	            bindData = reThis.test(source);
	            setBindData(func, bindData);
	          }
	        }
	      }
	      // exit early if there are no `this` references or `func` is bound
	      if (bindData === false || (bindData !== true && bindData[1] & 1)) {
	        return func;
	      }
	      switch (argCount) {
	        case 1: return function(value) {
	          return func.call(thisArg, value);
	        };
	        case 2: return function(a, b) {
	          return func.call(thisArg, a, b);
	        };
	        case 3: return function(value, index, collection) {
	          return func.call(thisArg, value, index, collection);
	        };
	        case 4: return function(accumulator, value, index, collection) {
	          return func.call(thisArg, accumulator, value, index, collection);
	        };
	      }
	      return bind(func, thisArg);
	    }

	    /**
	     * The base implementation of `createWrapper` that creates the wrapper and
	     * sets its meta data.
	     *
	     * @private
	     * @param {Array} bindData The bind data array.
	     * @returns {Function} Returns the new function.
	     */
	    function baseCreateWrapper(bindData) {
	      var func = bindData[0],
	          bitmask = bindData[1],
	          partialArgs = bindData[2],
	          partialRightArgs = bindData[3],
	          thisArg = bindData[4],
	          arity = bindData[5];

	      var isBind = bitmask & 1,
	          isBindKey = bitmask & 2,
	          isCurry = bitmask & 4,
	          isCurryBound = bitmask & 8,
	          key = func;

	      function bound() {
	        var thisBinding = isBind ? thisArg : this;
	        if (partialArgs) {
	          var args = slice(partialArgs);
	          push.apply(args, arguments);
	        }
	        if (partialRightArgs || isCurry) {
	          args || (args = slice(arguments));
	          if (partialRightArgs) {
	            push.apply(args, partialRightArgs);
	          }
	          if (isCurry && args.length < arity) {
	            bitmask |= 16 & ~32;
	            return baseCreateWrapper([func, (isCurryBound ? bitmask : bitmask & ~3), args, null, thisArg, arity]);
	          }
	        }
	        args || (args = arguments);
	        if (isBindKey) {
	          func = thisBinding[key];
	        }
	        if (this instanceof bound) {
	          thisBinding = baseCreate(func.prototype);
	          var result = func.apply(thisBinding, args);
	          return isObject(result) ? result : thisBinding;
	        }
	        return func.apply(thisBinding, args);
	      }
	      setBindData(bound, bindData);
	      return bound;
	    }

	    /**
	     * The base implementation of `_.difference` that accepts a single array
	     * of values to exclude.
	     *
	     * @private
	     * @param {Array} array The array to process.
	     * @param {Array} [values] The array of values to exclude.
	     * @returns {Array} Returns a new array of filtered values.
	     */
	    function baseDifference(array, values) {
	      var index = -1,
	          indexOf = getIndexOf(),
	          length = array ? array.length : 0,
	          isLarge = length >= largeArraySize && indexOf === baseIndexOf,
	          result = [];

	      if (isLarge) {
	        var cache = createCache(values);
	        if (cache) {
	          indexOf = cacheIndexOf;
	          values = cache;
	        } else {
	          isLarge = false;
	        }
	      }
	      while (++index < length) {
	        var value = array[index];
	        if (indexOf(values, value) < 0) {
	          result.push(value);
	        }
	      }
	      if (isLarge) {
	        releaseObject(values);
	      }
	      return result;
	    }

	    /**
	     * The base implementation of `_.flatten` without support for callback
	     * shorthands or `thisArg` binding.
	     *
	     * @private
	     * @param {Array} array The array to flatten.
	     * @param {boolean} [isShallow=false] A flag to restrict flattening to a single level.
	     * @param {boolean} [isStrict=false] A flag to restrict flattening to arrays and `arguments` objects.
	     * @param {number} [fromIndex=0] The index to start from.
	     * @returns {Array} Returns a new flattened array.
	     */
	    function baseFlatten(array, isShallow, isStrict, fromIndex) {
	      var index = (fromIndex || 0) - 1,
	          length = array ? array.length : 0,
	          result = [];

	      while (++index < length) {
	        var value = array[index];

	        if (value && typeof value == 'object' && typeof value.length == 'number'
	            && (isArray(value) || isArguments(value))) {
	          // recursively flatten arrays (susceptible to call stack limits)
	          if (!isShallow) {
	            value = baseFlatten(value, isShallow, isStrict);
	          }
	          var valIndex = -1,
	              valLength = value.length,
	              resIndex = result.length;

	          result.length += valLength;
	          while (++valIndex < valLength) {
	            result[resIndex++] = value[valIndex];
	          }
	        } else if (!isStrict) {
	          result.push(value);
	        }
	      }
	      return result;
	    }

	    /**
	     * The base implementation of `_.isEqual`, without support for `thisArg` binding,
	     * that allows partial "_.where" style comparisons.
	     *
	     * @private
	     * @param {*} a The value to compare.
	     * @param {*} b The other value to compare.
	     * @param {Function} [callback] The function to customize comparing values.
	     * @param {Function} [isWhere=false] A flag to indicate performing partial comparisons.
	     * @param {Array} [stackA=[]] Tracks traversed `a` objects.
	     * @param {Array} [stackB=[]] Tracks traversed `b` objects.
	     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	     */
	    function baseIsEqual(a, b, callback, isWhere, stackA, stackB) {
	      // used to indicate that when comparing objects, `a` has at least the properties of `b`
	      if (callback) {
	        var result = callback(a, b);
	        if (typeof result != 'undefined') {
	          return !!result;
	        }
	      }
	      // exit early for identical values
	      if (a === b) {
	        // treat `+0` vs. `-0` as not equal
	        return a !== 0 || (1 / a == 1 / b);
	      }
	      var type = typeof a,
	          otherType = typeof b;

	      // exit early for unlike primitive values
	      if (a === a &&
	          !(a && objectTypes[type]) &&
	          !(b && objectTypes[otherType])) {
	        return false;
	      }
	      // exit early for `null` and `undefined` avoiding ES3's Function#call behavior
	      // http://es5.github.io/#x15.3.4.4
	      if (a == null || b == null) {
	        return a === b;
	      }
	      // compare [[Class]] names
	      var className = toString.call(a),
	          otherClass = toString.call(b);

	      if (className == argsClass) {
	        className = objectClass;
	      }
	      if (otherClass == argsClass) {
	        otherClass = objectClass;
	      }
	      if (className != otherClass) {
	        return false;
	      }
	      switch (className) {
	        case boolClass:
	        case dateClass:
	          // coerce dates and booleans to numbers, dates to milliseconds and booleans
	          // to `1` or `0` treating invalid dates coerced to `NaN` as not equal
	          return +a == +b;

	        case numberClass:
	          // treat `NaN` vs. `NaN` as equal
	          return (a != +a)
	            ? b != +b
	            // but treat `+0` vs. `-0` as not equal
	            : (a == 0 ? (1 / a == 1 / b) : a == +b);

	        case regexpClass:
	        case stringClass:
	          // coerce regexes to strings (http://es5.github.io/#x15.10.6.4)
	          // treat string primitives and their corresponding object instances as equal
	          return a == String(b);
	      }
	      var isArr = className == arrayClass;
	      if (!isArr) {
	        // unwrap any `lodash` wrapped values
	        var aWrapped = hasOwnProperty.call(a, '__wrapped__'),
	            bWrapped = hasOwnProperty.call(b, '__wrapped__');

	        if (aWrapped || bWrapped) {
	          return baseIsEqual(aWrapped ? a.__wrapped__ : a, bWrapped ? b.__wrapped__ : b, callback, isWhere, stackA, stackB);
	        }
	        // exit for functions and DOM nodes
	        if (className != objectClass || (!support.nodeClass && (isNode(a) || isNode(b)))) {
	          return false;
	        }
	        // in older versions of Opera, `arguments` objects have `Array` constructors
	        var ctorA = !support.argsObject && isArguments(a) ? Object : a.constructor,
	            ctorB = !support.argsObject && isArguments(b) ? Object : b.constructor;

	        // non `Object` object instances with different constructors are not equal
	        if (ctorA != ctorB &&
	              !(isFunction(ctorA) && ctorA instanceof ctorA && isFunction(ctorB) && ctorB instanceof ctorB) &&
	              ('constructor' in a && 'constructor' in b)
	            ) {
	          return false;
	        }
	      }
	      // assume cyclic structures are equal
	      // the algorithm for detecting cyclic structures is adapted from ES 5.1
	      // section 15.12.3, abstract operation `JO` (http://es5.github.io/#x15.12.3)
	      var initedStack = !stackA;
	      stackA || (stackA = getArray());
	      stackB || (stackB = getArray());

	      var length = stackA.length;
	      while (length--) {
	        if (stackA[length] == a) {
	          return stackB[length] == b;
	        }
	      }
	      var size = 0;
	      result = true;

	      // add `a` and `b` to the stack of traversed objects
	      stackA.push(a);
	      stackB.push(b);

	      // recursively compare objects and arrays (susceptible to call stack limits)
	      if (isArr) {
	        // compare lengths to determine if a deep comparison is necessary
	        length = a.length;
	        size = b.length;
	        result = size == length;

	        if (result || isWhere) {
	          // deep compare the contents, ignoring non-numeric properties
	          while (size--) {
	            var index = length,
	                value = b[size];

	            if (isWhere) {
	              while (index--) {
	                if ((result = baseIsEqual(a[index], value, callback, isWhere, stackA, stackB))) {
	                  break;
	                }
	              }
	            } else if (!(result = baseIsEqual(a[size], value, callback, isWhere, stackA, stackB))) {
	              break;
	            }
	          }
	        }
	      }
	      else {
	        // deep compare objects using `forIn`, instead of `forOwn`, to avoid `Object.keys`
	        // which, in this case, is more costly
	        forIn(b, function(value, key, b) {
	          if (hasOwnProperty.call(b, key)) {
	            // count the number of properties.
	            size++;
	            // deep compare each property value.
	            return (result = hasOwnProperty.call(a, key) && baseIsEqual(a[key], value, callback, isWhere, stackA, stackB));
	          }
	        });

	        if (result && !isWhere) {
	          // ensure both objects have the same number of properties
	          forIn(a, function(value, key, a) {
	            if (hasOwnProperty.call(a, key)) {
	              // `size` will be `-1` if `a` has more properties than `b`
	              return (result = --size > -1);
	            }
	          });
	        }
	      }
	      stackA.pop();
	      stackB.pop();

	      if (initedStack) {
	        releaseArray(stackA);
	        releaseArray(stackB);
	      }
	      return result;
	    }

	    /**
	     * The base implementation of `_.merge` without argument juggling or support
	     * for `thisArg` binding.
	     *
	     * @private
	     * @param {Object} object The destination object.
	     * @param {Object} source The source object.
	     * @param {Function} [callback] The function to customize merging properties.
	     * @param {Array} [stackA=[]] Tracks traversed source objects.
	     * @param {Array} [stackB=[]] Associates values with source counterparts.
	     */
	    function baseMerge(object, source, callback, stackA, stackB) {
	      (isArray(source) ? forEach : forOwn)(source, function(source, key) {
	        var found,
	            isArr,
	            result = source,
	            value = object[key];

	        if (source && ((isArr = isArray(source)) || isPlainObject(source))) {
	          // avoid merging previously merged cyclic sources
	          var stackLength = stackA.length;
	          while (stackLength--) {
	            if ((found = stackA[stackLength] == source)) {
	              value = stackB[stackLength];
	              break;
	            }
	          }
	          if (!found) {
	            var isShallow;
	            if (callback) {
	              result = callback(value, source);
	              if ((isShallow = typeof result != 'undefined')) {
	                value = result;
	              }
	            }
	            if (!isShallow) {
	              value = isArr
	                ? (isArray(value) ? value : [])
	                : (isPlainObject(value) ? value : {});
	            }
	            // add `source` and associated `value` to the stack of traversed objects
	            stackA.push(source);
	            stackB.push(value);

	            // recursively merge objects and arrays (susceptible to call stack limits)
	            if (!isShallow) {
	              baseMerge(value, source, callback, stackA, stackB);
	            }
	          }
	        }
	        else {
	          if (callback) {
	            result = callback(value, source);
	            if (typeof result == 'undefined') {
	              result = source;
	            }
	          }
	          if (typeof result != 'undefined') {
	            value = result;
	          }
	        }
	        object[key] = value;
	      });
	    }

	    /**
	     * The base implementation of `_.random` without argument juggling or support
	     * for returning floating-point numbers.
	     *
	     * @private
	     * @param {number} min The minimum possible value.
	     * @param {number} max The maximum possible value.
	     * @returns {number} Returns a random number.
	     */
	    function baseRandom(min, max) {
	      return min + floor(nativeRandom() * (max - min + 1));
	    }

	    /**
	     * The base implementation of `_.uniq` without support for callback shorthands
	     * or `thisArg` binding.
	     *
	     * @private
	     * @param {Array} array The array to process.
	     * @param {boolean} [isSorted=false] A flag to indicate that `array` is sorted.
	     * @param {Function} [callback] The function called per iteration.
	     * @returns {Array} Returns a duplicate-value-free array.
	     */
	    function baseUniq(array, isSorted, callback) {
	      var index = -1,
	          indexOf = getIndexOf(),
	          length = array ? array.length : 0,
	          result = [];

	      var isLarge = !isSorted && length >= largeArraySize && indexOf === baseIndexOf,
	          seen = (callback || isLarge) ? getArray() : result;

	      if (isLarge) {
	        var cache = createCache(seen);
	        indexOf = cacheIndexOf;
	        seen = cache;
	      }
	      while (++index < length) {
	        var value = array[index],
	            computed = callback ? callback(value, index, array) : value;

	        if (isSorted
	              ? !index || seen[seen.length - 1] !== computed
	              : indexOf(seen, computed) < 0
	            ) {
	          if (callback || isLarge) {
	            seen.push(computed);
	          }
	          result.push(value);
	        }
	      }
	      if (isLarge) {
	        releaseArray(seen.array);
	        releaseObject(seen);
	      } else if (callback) {
	        releaseArray(seen);
	      }
	      return result;
	    }

	    /**
	     * Creates a function that aggregates a collection, creating an object composed
	     * of keys generated from the results of running each element of the collection
	     * through a callback. The given `setter` function sets the keys and values
	     * of the composed object.
	     *
	     * @private
	     * @param {Function} setter The setter function.
	     * @returns {Function} Returns the new aggregator function.
	     */
	    function createAggregator(setter) {
	      return function(collection, callback, thisArg) {
	        var result = {};
	        callback = lodash.createCallback(callback, thisArg, 3);

	        if (isArray(collection)) {
	          var index = -1,
	              length = collection.length;

	          while (++index < length) {
	            var value = collection[index];
	            setter(result, value, callback(value, index, collection), collection);
	          }
	        } else {
	          baseEach(collection, function(value, key, collection) {
	            setter(result, value, callback(value, key, collection), collection);
	          });
	        }
	        return result;
	      };
	    }

	    /**
	     * Creates a function that, when called, either curries or invokes `func`
	     * with an optional `this` binding and partially applied arguments.
	     *
	     * @private
	     * @param {Function|string} func The function or method name to reference.
	     * @param {number} bitmask The bitmask of method flags to compose.
	     *  The bitmask may be composed of the following flags:
	     *  1 - `_.bind`
	     *  2 - `_.bindKey`
	     *  4 - `_.curry`
	     *  8 - `_.curry` (bound)
	     *  16 - `_.partial`
	     *  32 - `_.partialRight`
	     * @param {Array} [partialArgs] An array of arguments to prepend to those
	     *  provided to the new function.
	     * @param {Array} [partialRightArgs] An array of arguments to append to those
	     *  provided to the new function.
	     * @param {*} [thisArg] The `this` binding of `func`.
	     * @param {number} [arity] The arity of `func`.
	     * @returns {Function} Returns the new function.
	     */
	    function createWrapper(func, bitmask, partialArgs, partialRightArgs, thisArg, arity) {
	      var isBind = bitmask & 1,
	          isBindKey = bitmask & 2,
	          isCurry = bitmask & 4,
	          isCurryBound = bitmask & 8,
	          isPartial = bitmask & 16,
	          isPartialRight = bitmask & 32;

	      if (!isBindKey && !isFunction(func)) {
	        throw new TypeError;
	      }
	      if (isPartial && !partialArgs.length) {
	        bitmask &= ~16;
	        isPartial = partialArgs = false;
	      }
	      if (isPartialRight && !partialRightArgs.length) {
	        bitmask &= ~32;
	        isPartialRight = partialRightArgs = false;
	      }
	      var bindData = func && func.__bindData__;
	      if (bindData && bindData !== true) {
	        // clone `bindData`
	        bindData = slice(bindData);
	        if (bindData[2]) {
	          bindData[2] = slice(bindData[2]);
	        }
	        if (bindData[3]) {
	          bindData[3] = slice(bindData[3]);
	        }
	        // set `thisBinding` is not previously bound
	        if (isBind && !(bindData[1] & 1)) {
	          bindData[4] = thisArg;
	        }
	        // set if previously bound but not currently (subsequent curried functions)
	        if (!isBind && bindData[1] & 1) {
	          bitmask |= 8;
	        }
	        // set curried arity if not yet set
	        if (isCurry && !(bindData[1] & 4)) {
	          bindData[5] = arity;
	        }
	        // append partial left arguments
	        if (isPartial) {
	          push.apply(bindData[2] || (bindData[2] = []), partialArgs);
	        }
	        // append partial right arguments
	        if (isPartialRight) {
	          unshift.apply(bindData[3] || (bindData[3] = []), partialRightArgs);
	        }
	        // merge flags
	        bindData[1] |= bitmask;
	        return createWrapper.apply(null, bindData);
	      }
	      // fast path for `_.bind`
	      var creater = (bitmask == 1 || bitmask === 17) ? baseBind : baseCreateWrapper;
	      return creater([func, bitmask, partialArgs, partialRightArgs, thisArg, arity]);
	    }

	    /**
	     * Creates compiled iteration functions.
	     *
	     * @private
	     * @param {...Object} [options] The compile options object(s).
	     * @param {string} [options.array] Code to determine if the iterable is an array or array-like.
	     * @param {boolean} [options.useHas] Specify using `hasOwnProperty` checks in the object loop.
	     * @param {Function} [options.keys] A reference to `_.keys` for use in own property iteration.
	     * @param {string} [options.args] A comma separated string of iteration function arguments.
	     * @param {string} [options.top] Code to execute before the iteration branches.
	     * @param {string} [options.loop] Code to execute in the object loop.
	     * @param {string} [options.bottom] Code to execute after the iteration branches.
	     * @returns {Function} Returns the compiled function.
	     */
	    function createIterator() {
	      // data properties
	      iteratorData.shadowedProps = shadowedProps;

	      // iterator options
	      iteratorData.array = iteratorData.bottom = iteratorData.loop = iteratorData.top = '';
	      iteratorData.init = 'iterable';
	      iteratorData.useHas = true;

	      // merge options into a template data object
	      for (var object, index = 0; object = arguments[index]; index++) {
	        for (var key in object) {
	          iteratorData[key] = object[key];
	        }
	      }
	      var args = iteratorData.args;
	      iteratorData.firstArg = /^[^,]+/.exec(args)[0];

	      // create the function factory
	      var factory = Function(
	          'baseCreateCallback, errorClass, errorProto, hasOwnProperty, ' +
	          'indicatorObject, isArguments, isArray, isString, keys, objectProto, ' +
	          'objectTypes, nonEnumProps, stringClass, stringProto, toString',
	        'return function(' + args + ') {\n' + iteratorTemplate(iteratorData) + '\n}'
	      );

	      // return the compiled function
	      return factory(
	        baseCreateCallback, errorClass, errorProto, hasOwnProperty,
	        indicatorObject, isArguments, isArray, isString, iteratorData.keys, objectProto,
	        objectTypes, nonEnumProps, stringClass, stringProto, toString
	      );
	    }

	    /**
	     * Used by `escape` to convert characters to HTML entities.
	     *
	     * @private
	     * @param {string} match The matched character to escape.
	     * @returns {string} Returns the escaped character.
	     */
	    function escapeHtmlChar(match) {
	      return htmlEscapes[match];
	    }

	    /**
	     * Gets the appropriate "indexOf" function. If the `_.indexOf` method is
	     * customized, this method returns the custom method, otherwise it returns
	     * the `baseIndexOf` function.
	     *
	     * @private
	     * @returns {Function} Returns the "indexOf" function.
	     */
	    function getIndexOf() {
	      var result = (result = lodash.indexOf) === indexOf ? baseIndexOf : result;
	      return result;
	    }

	    /**
	     * Checks if `value` is a native function.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is a native function, else `false`.
	     */
	    function isNative(value) {
	      return typeof value == 'function' && reNative.test(value);
	    }

	    /**
	     * Sets `this` binding data on a given function.
	     *
	     * @private
	     * @param {Function} func The function to set data on.
	     * @param {Array} value The data array to set.
	     */
	    var setBindData = !defineProperty ? noop : function(func, value) {
	      descriptor.value = value;
	      defineProperty(func, '__bindData__', descriptor);
	      descriptor.value = null;
	    };

	    /**
	     * A fallback implementation of `isPlainObject` which checks if a given value
	     * is an object created by the `Object` constructor, assuming objects created
	     * by the `Object` constructor have no inherited enumerable properties and that
	     * there are no `Object.prototype` extensions.
	     *
	     * @private
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
	     */
	    function shimIsPlainObject(value) {
	      var ctor,
	          result;

	      // avoid non Object objects, `arguments` objects, and DOM elements
	      if (!(value && toString.call(value) == objectClass) ||
	          (ctor = value.constructor, isFunction(ctor) && !(ctor instanceof ctor)) ||
	          (!support.argsClass && isArguments(value)) ||
	          (!support.nodeClass && isNode(value))) {
	        return false;
	      }
	      // IE < 9 iterates inherited properties before own properties. If the first
	      // iterated property is an object's own property then there are no inherited
	      // enumerable properties.
	      if (support.ownLast) {
	        forIn(value, function(value, key, object) {
	          result = hasOwnProperty.call(object, key);
	          return false;
	        });
	        return result !== false;
	      }
	      // In most environments an object's own properties are iterated before
	      // its inherited properties. If the last iterated property is an object's
	      // own property then there are no inherited enumerable properties.
	      forIn(value, function(value, key) {
	        result = key;
	      });
	      return typeof result == 'undefined' || hasOwnProperty.call(value, result);
	    }

	    /**
	     * Used by `unescape` to convert HTML entities to characters.
	     *
	     * @private
	     * @param {string} match The matched character to unescape.
	     * @returns {string} Returns the unescaped character.
	     */
	    function unescapeHtmlChar(match) {
	      return htmlUnescapes[match];
	    }

	    /*--------------------------------------------------------------------------*/

	    /**
	     * Checks if `value` is an `arguments` object.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is an `arguments` object, else `false`.
	     * @example
	     *
	     * (function() { return _.isArguments(arguments); })(1, 2, 3);
	     * // => true
	     *
	     * _.isArguments([1, 2, 3]);
	     * // => false
	     */
	    function isArguments(value) {
	      return value && typeof value == 'object' && typeof value.length == 'number' &&
	        toString.call(value) == argsClass || false;
	    }
	    // fallback for browsers that can't detect `arguments` objects by [[Class]]
	    if (!support.argsClass) {
	      isArguments = function(value) {
	        return value && typeof value == 'object' && typeof value.length == 'number' &&
	          hasOwnProperty.call(value, 'callee') && !propertyIsEnumerable.call(value, 'callee') || false;
	      };
	    }

	    /**
	     * Checks if `value` is an array.
	     *
	     * @static
	     * @memberOf _
	     * @type Function
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is an array, else `false`.
	     * @example
	     *
	     * (function() { return _.isArray(arguments); })();
	     * // => false
	     *
	     * _.isArray([1, 2, 3]);
	     * // => true
	     */
	    var isArray = nativeIsArray || function(value) {
	      return value && typeof value == 'object' && typeof value.length == 'number' &&
	        toString.call(value) == arrayClass || false;
	    };

	    /**
	     * A fallback implementation of `Object.keys` which produces an array of the
	     * given object's own enumerable property names.
	     *
	     * @private
	     * @type Function
	     * @param {Object} object The object to inspect.
	     * @returns {Array} Returns an array of property names.
	     */
	    var shimKeys = createIterator({
	      'args': 'object',
	      'init': '[]',
	      'top': 'if (!(objectTypes[typeof object])) return result',
	      'loop': 'result.push(index)'
	    });

	    /**
	     * Creates an array composed of the own enumerable property names of an object.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to inspect.
	     * @returns {Array} Returns an array of property names.
	     * @example
	     *
	     * _.keys({ 'one': 1, 'two': 2, 'three': 3 });
	     * // => ['one', 'two', 'three'] (property order is not guaranteed across environments)
	     */
	    var keys = !nativeKeys ? shimKeys : function(object) {
	      if (!isObject(object)) {
	        return [];
	      }
	      if ((support.enumPrototypes && typeof object == 'function') ||
	          (support.nonEnumArgs && object.length && isArguments(object))) {
	        return shimKeys(object);
	      }
	      return nativeKeys(object);
	    };

	    /** Reusable iterator options shared by `each`, `forIn`, and `forOwn` */
	    var eachIteratorOptions = {
	      'args': 'collection, callback, thisArg',
	      'top': "callback = callback && typeof thisArg == 'undefined' ? callback : baseCreateCallback(callback, thisArg, 3)",
	      'array': "typeof length == 'number'",
	      'keys': keys,
	      'loop': 'if (callback(iterable[index], index, collection) === false) return result'
	    };

	    /** Reusable iterator options for `assign` and `defaults` */
	    var defaultsIteratorOptions = {
	      'args': 'object, source, guard',
	      'top':
	        'var args = arguments,\n' +
	        '    argsIndex = 0,\n' +
	        "    argsLength = typeof guard == 'number' ? 2 : args.length;\n" +
	        'while (++argsIndex < argsLength) {\n' +
	        '  iterable = args[argsIndex];\n' +
	        '  if (iterable && objectTypes[typeof iterable]) {',
	      'keys': keys,
	      'loop': "if (typeof result[index] == 'undefined') result[index] = iterable[index]",
	      'bottom': '  }\n}'
	    };

	    /** Reusable iterator options for `forIn` and `forOwn` */
	    var forOwnIteratorOptions = {
	      'top': 'if (!objectTypes[typeof iterable]) return result;\n' + eachIteratorOptions.top,
	      'array': false
	    };

	    /**
	     * Used to convert characters to HTML entities:
	     *
	     * Though the `>` character is escaped for symmetry, characters like `>` and `/`
	     * don't require escaping in HTML and have no special meaning unless they're part
	     * of a tag or an unquoted attribute value.
	     * http://mathiasbynens.be/notes/ambiguous-ampersands (under "semi-related fun fact")
	     */
	    var htmlEscapes = {
	      '&': '&amp;',
	      '<': '&lt;',
	      '>': '&gt;',
	      '"': '&quot;',
	      "'": '&#39;'
	    };

	    /** Used to convert HTML entities to characters */
	    var htmlUnescapes = invert(htmlEscapes);

	    /** Used to match HTML entities and HTML characters */
	    var reEscapedHtml = RegExp('(' + keys(htmlUnescapes).join('|') + ')', 'g'),
	        reUnescapedHtml = RegExp('[' + keys(htmlEscapes).join('') + ']', 'g');

	    /**
	     * A function compiled to iterate `arguments` objects, arrays, objects, and
	     * strings consistenly across environments, executing the callback for each
	     * element in the collection. The callback is bound to `thisArg` and invoked
	     * with three arguments; (value, index|key, collection). Callbacks may exit
	     * iteration early by explicitly returning `false`.
	     *
	     * @private
	     * @type Function
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array|Object|string} Returns `collection`.
	     */
	    var baseEach = createIterator(eachIteratorOptions);

	    /*--------------------------------------------------------------------------*/

	    /**
	     * Assigns own enumerable properties of source object(s) to the destination
	     * object. Subsequent sources will overwrite property assignments of previous
	     * sources. If a callback is provided it will be executed to produce the
	     * assigned values. The callback is bound to `thisArg` and invoked with two
	     * arguments; (objectValue, sourceValue).
	     *
	     * @static
	     * @memberOf _
	     * @type Function
	     * @alias extend
	     * @category Objects
	     * @param {Object} object The destination object.
	     * @param {...Object} [source] The source objects.
	     * @param {Function} [callback] The function to customize assigning values.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns the destination object.
	     * @example
	     *
	     * _.assign({ 'name': 'fred' }, { 'employer': 'slate' });
	     * // => { 'name': 'fred', 'employer': 'slate' }
	     *
	     * var defaults = _.partialRight(_.assign, function(a, b) {
	     *   return typeof a == 'undefined' ? b : a;
	     * });
	     *
	     * var object = { 'name': 'barney' };
	     * defaults(object, { 'name': 'fred', 'employer': 'slate' });
	     * // => { 'name': 'barney', 'employer': 'slate' }
	     */
	    var assign = createIterator(defaultsIteratorOptions, {
	      'top':
	        defaultsIteratorOptions.top.replace(';',
	          ';\n' +
	          "if (argsLength > 3 && typeof args[argsLength - 2] == 'function') {\n" +
	          '  var callback = baseCreateCallback(args[--argsLength - 1], args[argsLength--], 2);\n' +
	          "} else if (argsLength > 2 && typeof args[argsLength - 1] == 'function') {\n" +
	          '  callback = args[--argsLength];\n' +
	          '}'
	        ),
	      'loop': 'result[index] = callback ? callback(result[index], iterable[index]) : iterable[index]'
	    });

	    /**
	     * Creates a clone of `value`. If `isDeep` is `true` nested objects will also
	     * be cloned, otherwise they will be assigned by reference. If a callback
	     * is provided it will be executed to produce the cloned values. If the
	     * callback returns `undefined` cloning will be handled by the method instead.
	     * The callback is bound to `thisArg` and invoked with one argument; (value).
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to clone.
	     * @param {boolean} [isDeep=false] Specify a deep clone.
	     * @param {Function} [callback] The function to customize cloning values.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the cloned value.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * var shallow = _.clone(characters);
	     * shallow[0] === characters[0];
	     * // => true
	     *
	     * var deep = _.clone(characters, true);
	     * deep[0] === characters[0];
	     * // => false
	     *
	     * _.mixin({
	     *   'clone': _.partialRight(_.clone, function(value) {
	     *     return _.isElement(value) ? value.cloneNode(false) : undefined;
	     *   })
	     * });
	     *
	     * var clone = _.clone(document.body);
	     * clone.childNodes.length;
	     * // => 0
	     */
	    function clone(value, isDeep, callback, thisArg) {
	      // allows working with "Collections" methods without using their `index`
	      // and `collection` arguments for `isDeep` and `callback`
	      if (typeof isDeep != 'boolean' && isDeep != null) {
	        thisArg = callback;
	        callback = isDeep;
	        isDeep = false;
	      }
	      return baseClone(value, isDeep, typeof callback == 'function' && baseCreateCallback(callback, thisArg, 1));
	    }

	    /**
	     * Creates a deep clone of `value`. If a callback is provided it will be
	     * executed to produce the cloned values. If the callback returns `undefined`
	     * cloning will be handled by the method instead. The callback is bound to
	     * `thisArg` and invoked with one argument; (value).
	     *
	     * Note: This method is loosely based on the structured clone algorithm. Functions
	     * and DOM nodes are **not** cloned. The enumerable properties of `arguments` objects and
	     * objects created by constructors other than `Object` are cloned to plain `Object` objects.
	     * See http://www.w3.org/TR/html5/infrastructure.html#internal-structured-cloning-algorithm.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to deep clone.
	     * @param {Function} [callback] The function to customize cloning values.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the deep cloned value.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * var deep = _.cloneDeep(characters);
	     * deep[0] === characters[0];
	     * // => false
	     *
	     * var view = {
	     *   'label': 'docs',
	     *   'node': element
	     * };
	     *
	     * var clone = _.cloneDeep(view, function(value) {
	     *   return _.isElement(value) ? value.cloneNode(true) : undefined;
	     * });
	     *
	     * clone.node == view.node;
	     * // => false
	     */
	    function cloneDeep(value, callback, thisArg) {
	      return baseClone(value, true, typeof callback == 'function' && baseCreateCallback(callback, thisArg, 1));
	    }

	    /**
	     * Creates an object that inherits from the given `prototype` object. If a
	     * `properties` object is provided its own enumerable properties are assigned
	     * to the created object.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} prototype The object to inherit from.
	     * @param {Object} [properties] The properties to assign to the object.
	     * @returns {Object} Returns the new object.
	     * @example
	     *
	     * function Shape() {
	     *   this.x = 0;
	     *   this.y = 0;
	     * }
	     *
	     * function Circle() {
	     *   Shape.call(this);
	     * }
	     *
	     * Circle.prototype = _.create(Shape.prototype, { 'constructor': Circle });
	     *
	     * var circle = new Circle;
	     * circle instanceof Circle;
	     * // => true
	     *
	     * circle instanceof Shape;
	     * // => true
	     */
	    function create(prototype, properties) {
	      var result = baseCreate(prototype);
	      return properties ? assign(result, properties) : result;
	    }

	    /**
	     * Assigns own enumerable properties of source object(s) to the destination
	     * object for all destination properties that resolve to `undefined`. Once a
	     * property is set, additional defaults of the same property will be ignored.
	     *
	     * @static
	     * @memberOf _
	     * @type Function
	     * @category Objects
	     * @param {Object} object The destination object.
	     * @param {...Object} [source] The source objects.
	     * @param- {Object} [guard] Allows working with `_.reduce` without using its
	     *  `key` and `object` arguments as sources.
	     * @returns {Object} Returns the destination object.
	     * @example
	     *
	     * var object = { 'name': 'barney' };
	     * _.defaults(object, { 'name': 'fred', 'employer': 'slate' });
	     * // => { 'name': 'barney', 'employer': 'slate' }
	     */
	    var defaults = createIterator(defaultsIteratorOptions);

	    /**
	     * This method is like `_.findIndex` except that it returns the key of the
	     * first element that passes the callback check, instead of the element itself.
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to search.
	     * @param {Function|Object|string} [callback=identity] The function called per
	     *  iteration. If a property name or object is provided it will be used to
	     *  create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {string|undefined} Returns the key of the found element, else `undefined`.
	     * @example
	     *
	     * var characters = {
	     *   'barney': {  'age': 36, 'blocked': false },
	     *   'fred': {    'age': 40, 'blocked': true },
	     *   'pebbles': { 'age': 1,  'blocked': false }
	     * };
	     *
	     * _.findKey(characters, function(chr) {
	     *   return chr.age < 40;
	     * });
	     * // => 'barney' (property order is not guaranteed across environments)
	     *
	     * // using "_.where" callback shorthand
	     * _.findKey(characters, { 'age': 1 });
	     * // => 'pebbles'
	     *
	     * // using "_.pluck" callback shorthand
	     * _.findKey(characters, 'blocked');
	     * // => 'fred'
	     */
	    function findKey(object, callback, thisArg) {
	      var result;
	      callback = lodash.createCallback(callback, thisArg, 3);
	      forOwn(object, function(value, key, object) {
	        if (callback(value, key, object)) {
	          result = key;
	          return false;
	        }
	      });
	      return result;
	    }

	    /**
	     * This method is like `_.findKey` except that it iterates over elements
	     * of a `collection` in the opposite order.
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to search.
	     * @param {Function|Object|string} [callback=identity] The function called per
	     *  iteration. If a property name or object is provided it will be used to
	     *  create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {string|undefined} Returns the key of the found element, else `undefined`.
	     * @example
	     *
	     * var characters = {
	     *   'barney': {  'age': 36, 'blocked': true },
	     *   'fred': {    'age': 40, 'blocked': false },
	     *   'pebbles': { 'age': 1,  'blocked': true }
	     * };
	     *
	     * _.findLastKey(characters, function(chr) {
	     *   return chr.age < 40;
	     * });
	     * // => returns `pebbles`, assuming `_.findKey` returns `barney`
	     *
	     * // using "_.where" callback shorthand
	     * _.findLastKey(characters, { 'age': 40 });
	     * // => 'fred'
	     *
	     * // using "_.pluck" callback shorthand
	     * _.findLastKey(characters, 'blocked');
	     * // => 'pebbles'
	     */
	    function findLastKey(object, callback, thisArg) {
	      var result;
	      callback = lodash.createCallback(callback, thisArg, 3);
	      forOwnRight(object, function(value, key, object) {
	        if (callback(value, key, object)) {
	          result = key;
	          return false;
	        }
	      });
	      return result;
	    }

	    /**
	     * Iterates over own and inherited enumerable properties of an object,
	     * executing the callback for each property. The callback is bound to `thisArg`
	     * and invoked with three arguments; (value, key, object). Callbacks may exit
	     * iteration early by explicitly returning `false`.
	     *
	     * @static
	     * @memberOf _
	     * @type Function
	     * @category Objects
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * function Shape() {
	     *   this.x = 0;
	     *   this.y = 0;
	     * }
	     *
	     * Shape.prototype.move = function(x, y) {
	     *   this.x += x;
	     *   this.y += y;
	     * };
	     *
	     * _.forIn(new Shape, function(value, key) {
	     *   console.log(key);
	     * });
	     * // => logs 'x', 'y', and 'move' (property order is not guaranteed across environments)
	     */
	    var forIn = createIterator(eachIteratorOptions, forOwnIteratorOptions, {
	      'useHas': false
	    });

	    /**
	     * This method is like `_.forIn` except that it iterates over elements
	     * of a `collection` in the opposite order.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * function Shape() {
	     *   this.x = 0;
	     *   this.y = 0;
	     * }
	     *
	     * Shape.prototype.move = function(x, y) {
	     *   this.x += x;
	     *   this.y += y;
	     * };
	     *
	     * _.forInRight(new Shape, function(value, key) {
	     *   console.log(key);
	     * });
	     * // => logs 'move', 'y', and 'x' assuming `_.forIn ` logs 'x', 'y', and 'move'
	     */
	    function forInRight(object, callback, thisArg) {
	      var pairs = [];

	      forIn(object, function(value, key) {
	        pairs.push(key, value);
	      });

	      var length = pairs.length;
	      callback = baseCreateCallback(callback, thisArg, 3);
	      while (length--) {
	        if (callback(pairs[length--], pairs[length], object) === false) {
	          break;
	        }
	      }
	      return object;
	    }

	    /**
	     * Iterates over own enumerable properties of an object, executing the callback
	     * for each property. The callback is bound to `thisArg` and invoked with three
	     * arguments; (value, key, object). Callbacks may exit iteration early by
	     * explicitly returning `false`.
	     *
	     * @static
	     * @memberOf _
	     * @type Function
	     * @category Objects
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * _.forOwn({ '0': 'zero', '1': 'one', 'length': 2 }, function(num, key) {
	     *   console.log(key);
	     * });
	     * // => logs '0', '1', and 'length' (property order is not guaranteed across environments)
	     */
	    var forOwn = createIterator(eachIteratorOptions, forOwnIteratorOptions);

	    /**
	     * This method is like `_.forOwn` except that it iterates over elements
	     * of a `collection` in the opposite order.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * _.forOwnRight({ '0': 'zero', '1': 'one', 'length': 2 }, function(num, key) {
	     *   console.log(key);
	     * });
	     * // => logs 'length', '1', and '0' assuming `_.forOwn` logs '0', '1', and 'length'
	     */
	    function forOwnRight(object, callback, thisArg) {
	      var props = keys(object),
	          length = props.length;

	      callback = baseCreateCallback(callback, thisArg, 3);
	      while (length--) {
	        var key = props[length];
	        if (callback(object[key], key, object) === false) {
	          break;
	        }
	      }
	      return object;
	    }

	    /**
	     * Creates a sorted array of property names of all enumerable properties,
	     * own and inherited, of `object` that have function values.
	     *
	     * @static
	     * @memberOf _
	     * @alias methods
	     * @category Objects
	     * @param {Object} object The object to inspect.
	     * @returns {Array} Returns an array of property names that have function values.
	     * @example
	     *
	     * _.functions(_);
	     * // => ['all', 'any', 'bind', 'bindAll', 'clone', 'compact', 'compose', ...]
	     */
	    function functions(object) {
	      var result = [];
	      forIn(object, function(value, key) {
	        if (isFunction(value)) {
	          result.push(key);
	        }
	      });
	      return result.sort();
	    }

	    /**
	     * Checks if the specified property name exists as a direct property of `object`,
	     * instead of an inherited property.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to inspect.
	     * @param {string} key The name of the property to check.
	     * @returns {boolean} Returns `true` if key is a direct property, else `false`.
	     * @example
	     *
	     * _.has({ 'a': 1, 'b': 2, 'c': 3 }, 'b');
	     * // => true
	     */
	    function has(object, key) {
	      return object ? hasOwnProperty.call(object, key) : false;
	    }

	    /**
	     * Creates an object composed of the inverted keys and values of the given object.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to invert.
	     * @returns {Object} Returns the created inverted object.
	     * @example
	     *
	     * _.invert({ 'first': 'fred', 'second': 'barney' });
	     * // => { 'fred': 'first', 'barney': 'second' }
	     */
	    function invert(object) {
	      var index = -1,
	          props = keys(object),
	          length = props.length,
	          result = {};

	      while (++index < length) {
	        var key = props[index];
	        result[object[key]] = key;
	      }
	      return result;
	    }

	    /**
	     * Checks if `value` is a boolean value.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is a boolean value, else `false`.
	     * @example
	     *
	     * _.isBoolean(null);
	     * // => false
	     */
	    function isBoolean(value) {
	      return value === true || value === false ||
	        value && typeof value == 'object' && toString.call(value) == boolClass || false;
	    }

	    /**
	     * Checks if `value` is a date.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is a date, else `false`.
	     * @example
	     *
	     * _.isDate(new Date);
	     * // => true
	     */
	    function isDate(value) {
	      return value && typeof value == 'object' && toString.call(value) == dateClass || false;
	    }

	    /**
	     * Checks if `value` is a DOM element.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is a DOM element, else `false`.
	     * @example
	     *
	     * _.isElement(document.body);
	     * // => true
	     */
	    function isElement(value) {
	      return value && value.nodeType === 1 || false;
	    }

	    /**
	     * Checks if `value` is empty. Arrays, strings, or `arguments` objects with a
	     * length of `0` and objects with no own enumerable properties are considered
	     * "empty".
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Array|Object|string} value The value to inspect.
	     * @returns {boolean} Returns `true` if the `value` is empty, else `false`.
	     * @example
	     *
	     * _.isEmpty([1, 2, 3]);
	     * // => false
	     *
	     * _.isEmpty({});
	     * // => true
	     *
	     * _.isEmpty('');
	     * // => true
	     */
	    function isEmpty(value) {
	      var result = true;
	      if (!value) {
	        return result;
	      }
	      var className = toString.call(value),
	          length = value.length;

	      if ((className == arrayClass || className == stringClass ||
	          (support.argsClass ? className == argsClass : isArguments(value))) ||
	          (className == objectClass && typeof length == 'number' && isFunction(value.splice))) {
	        return !length;
	      }
	      forOwn(value, function() {
	        return (result = false);
	      });
	      return result;
	    }

	    /**
	     * Performs a deep comparison between two values to determine if they are
	     * equivalent to each other. If a callback is provided it will be executed
	     * to compare values. If the callback returns `undefined` comparisons will
	     * be handled by the method instead. The callback is bound to `thisArg` and
	     * invoked with two arguments; (a, b).
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} a The value to compare.
	     * @param {*} b The other value to compare.
	     * @param {Function} [callback] The function to customize comparing values.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	     * @example
	     *
	     * var object = { 'name': 'fred' };
	     * var copy = { 'name': 'fred' };
	     *
	     * object == copy;
	     * // => false
	     *
	     * _.isEqual(object, copy);
	     * // => true
	     *
	     * var words = ['hello', 'goodbye'];
	     * var otherWords = ['hi', 'goodbye'];
	     *
	     * _.isEqual(words, otherWords, function(a, b) {
	     *   var reGreet = /^(?:hello|hi)$/i,
	     *       aGreet = _.isString(a) && reGreet.test(a),
	     *       bGreet = _.isString(b) && reGreet.test(b);
	     *
	     *   return (aGreet || bGreet) ? (aGreet == bGreet) : undefined;
	     * });
	     * // => true
	     */
	    function isEqual(a, b, callback, thisArg) {
	      return baseIsEqual(a, b, typeof callback == 'function' && baseCreateCallback(callback, thisArg, 2));
	    }

	    /**
	     * Checks if `value` is, or can be coerced to, a finite number.
	     *
	     * Note: This is not the same as native `isFinite` which will return true for
	     * booleans and empty strings. See http://es5.github.io/#x15.1.2.5.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is finite, else `false`.
	     * @example
	     *
	     * _.isFinite(-101);
	     * // => true
	     *
	     * _.isFinite('10');
	     * // => true
	     *
	     * _.isFinite(true);
	     * // => false
	     *
	     * _.isFinite('');
	     * // => false
	     *
	     * _.isFinite(Infinity);
	     * // => false
	     */
	    function isFinite(value) {
	      return nativeIsFinite(value) && !nativeIsNaN(parseFloat(value));
	    }

	    /**
	     * Checks if `value` is a function.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is a function, else `false`.
	     * @example
	     *
	     * _.isFunction(_);
	     * // => true
	     */
	    function isFunction(value) {
	      return typeof value == 'function';
	    }
	    // fallback for older versions of Chrome and Safari
	    if (isFunction(/x/)) {
	      isFunction = function(value) {
	        return typeof value == 'function' && toString.call(value) == funcClass;
	      };
	    }

	    /**
	     * Checks if `value` is the language type of Object.
	     * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is an object, else `false`.
	     * @example
	     *
	     * _.isObject({});
	     * // => true
	     *
	     * _.isObject([1, 2, 3]);
	     * // => true
	     *
	     * _.isObject(1);
	     * // => false
	     */
	    function isObject(value) {
	      // check if the value is the ECMAScript language type of Object
	      // http://es5.github.io/#x8
	      // and avoid a V8 bug
	      // http://code.google.com/p/v8/issues/detail?id=2291
	      return !!(value && objectTypes[typeof value]);
	    }

	    /**
	     * Checks if `value` is `NaN`.
	     *
	     * Note: This is not the same as native `isNaN` which will return `true` for
	     * `undefined` and other non-numeric values. See http://es5.github.io/#x15.1.2.4.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is `NaN`, else `false`.
	     * @example
	     *
	     * _.isNaN(NaN);
	     * // => true
	     *
	     * _.isNaN(new Number(NaN));
	     * // => true
	     *
	     * isNaN(undefined);
	     * // => true
	     *
	     * _.isNaN(undefined);
	     * // => false
	     */
	    function isNaN(value) {
	      // `NaN` as a primitive is the only value that is not equal to itself
	      // (perform the [[Class]] check first to avoid errors with some host objects in IE)
	      return isNumber(value) && value != +value;
	    }

	    /**
	     * Checks if `value` is `null`.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is `null`, else `false`.
	     * @example
	     *
	     * _.isNull(null);
	     * // => true
	     *
	     * _.isNull(undefined);
	     * // => false
	     */
	    function isNull(value) {
	      return value === null;
	    }

	    /**
	     * Checks if `value` is a number.
	     *
	     * Note: `NaN` is considered a number. See http://es5.github.io/#x8.5.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is a number, else `false`.
	     * @example
	     *
	     * _.isNumber(8.4 * 5);
	     * // => true
	     */
	    function isNumber(value) {
	      return typeof value == 'number' ||
	        value && typeof value == 'object' && toString.call(value) == numberClass || false;
	    }

	    /**
	     * Checks if `value` is an object created by the `Object` constructor.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
	     * @example
	     *
	     * function Shape() {
	     *   this.x = 0;
	     *   this.y = 0;
	     * }
	     *
	     * _.isPlainObject(new Shape);
	     * // => false
	     *
	     * _.isPlainObject([1, 2, 3]);
	     * // => false
	     *
	     * _.isPlainObject({ 'x': 0, 'y': 0 });
	     * // => true
	     */
	    var isPlainObject = !getPrototypeOf ? shimIsPlainObject : function(value) {
	      if (!(value && toString.call(value) == objectClass) || (!support.argsClass && isArguments(value))) {
	        return false;
	      }
	      var valueOf = value.valueOf,
	          objProto = isNative(valueOf) && (objProto = getPrototypeOf(valueOf)) && getPrototypeOf(objProto);

	      return objProto
	        ? (value == objProto || getPrototypeOf(value) == objProto)
	        : shimIsPlainObject(value);
	    };

	    /**
	     * Checks if `value` is a regular expression.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is a regular expression, else `false`.
	     * @example
	     *
	     * _.isRegExp(/fred/);
	     * // => true
	     */
	    function isRegExp(value) {
	      return value && objectTypes[typeof value] && toString.call(value) == regexpClass || false;
	    }

	    /**
	     * Checks if `value` is a string.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is a string, else `false`.
	     * @example
	     *
	     * _.isString('fred');
	     * // => true
	     */
	    function isString(value) {
	      return typeof value == 'string' ||
	        value && typeof value == 'object' && toString.call(value) == stringClass || false;
	    }

	    /**
	     * Checks if `value` is `undefined`.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {*} value The value to check.
	     * @returns {boolean} Returns `true` if the `value` is `undefined`, else `false`.
	     * @example
	     *
	     * _.isUndefined(void 0);
	     * // => true
	     */
	    function isUndefined(value) {
	      return typeof value == 'undefined';
	    }

	    /**
	     * Creates an object with the same keys as `object` and values generated by
	     * running each own enumerable property of `object` through the callback.
	     * The callback is bound to `thisArg` and invoked with three arguments;
	     * (value, key, object).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a new object with values of the results of each `callback` execution.
	     * @example
	     *
	     * _.mapValues({ 'a': 1, 'b': 2, 'c': 3} , function(num) { return num * 3; });
	     * // => { 'a': 3, 'b': 6, 'c': 9 }
	     *
	     * var characters = {
	     *   'fred': { 'name': 'fred', 'age': 40 },
	     *   'pebbles': { 'name': 'pebbles', 'age': 1 }
	     * };
	     *
	     * // using "_.pluck" callback shorthand
	     * _.mapValues(characters, 'age');
	     * // => { 'fred': 40, 'pebbles': 1 }
	     */
	    function mapValues(object, callback, thisArg) {
	      var result = {};
	      callback = lodash.createCallback(callback, thisArg, 3);

	      forOwn(object, function(value, key, object) {
	        result[key] = callback(value, key, object);
	      });
	      return result;
	    }

	    /**
	     * Recursively merges own enumerable properties of the source object(s), that
	     * don't resolve to `undefined` into the destination object. Subsequent sources
	     * will overwrite property assignments of previous sources. If a callback is
	     * provided it will be executed to produce the merged values of the destination
	     * and source properties. If the callback returns `undefined` merging will
	     * be handled by the method instead. The callback is bound to `thisArg` and
	     * invoked with two arguments; (objectValue, sourceValue).
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The destination object.
	     * @param {...Object} [source] The source objects.
	     * @param {Function} [callback] The function to customize merging properties.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns the destination object.
	     * @example
	     *
	     * var names = {
	     *   'characters': [
	     *     { 'name': 'barney' },
	     *     { 'name': 'fred' }
	     *   ]
	     * };
	     *
	     * var ages = {
	     *   'characters': [
	     *     { 'age': 36 },
	     *     { 'age': 40 }
	     *   ]
	     * };
	     *
	     * _.merge(names, ages);
	     * // => { 'characters': [{ 'name': 'barney', 'age': 36 }, { 'name': 'fred', 'age': 40 }] }
	     *
	     * var food = {
	     *   'fruits': ['apple'],
	     *   'vegetables': ['beet']
	     * };
	     *
	     * var otherFood = {
	     *   'fruits': ['banana'],
	     *   'vegetables': ['carrot']
	     * };
	     *
	     * _.merge(food, otherFood, function(a, b) {
	     *   return _.isArray(a) ? a.concat(b) : undefined;
	     * });
	     * // => { 'fruits': ['apple', 'banana'], 'vegetables': ['beet', 'carrot] }
	     */
	    function merge(object) {
	      var args = arguments,
	          length = 2;

	      if (!isObject(object)) {
	        return object;
	      }
	      // allows working with `_.reduce` and `_.reduceRight` without using
	      // their `index` and `collection` arguments
	      if (typeof args[2] != 'number') {
	        length = args.length;
	      }
	      if (length > 3 && typeof args[length - 2] == 'function') {
	        var callback = baseCreateCallback(args[--length - 1], args[length--], 2);
	      } else if (length > 2 && typeof args[length - 1] == 'function') {
	        callback = args[--length];
	      }
	      var sources = slice(arguments, 1, length),
	          index = -1,
	          stackA = getArray(),
	          stackB = getArray();

	      while (++index < length) {
	        baseMerge(object, sources[index], callback, stackA, stackB);
	      }
	      releaseArray(stackA);
	      releaseArray(stackB);
	      return object;
	    }

	    /**
	     * Creates a shallow clone of `object` excluding the specified properties.
	     * Property names may be specified as individual arguments or as arrays of
	     * property names. If a callback is provided it will be executed for each
	     * property of `object` omitting the properties the callback returns truey
	     * for. The callback is bound to `thisArg` and invoked with three arguments;
	     * (value, key, object).
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The source object.
	     * @param {Function|...string|string[]} [callback] The properties to omit or the
	     *  function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns an object without the omitted properties.
	     * @example
	     *
	     * _.omit({ 'name': 'fred', 'age': 40 }, 'age');
	     * // => { 'name': 'fred' }
	     *
	     * _.omit({ 'name': 'fred', 'age': 40 }, function(value) {
	     *   return typeof value == 'number';
	     * });
	     * // => { 'name': 'fred' }
	     */
	    function omit(object, callback, thisArg) {
	      var result = {};
	      if (typeof callback != 'function') {
	        var props = [];
	        forIn(object, function(value, key) {
	          props.push(key);
	        });
	        props = baseDifference(props, baseFlatten(arguments, true, false, 1));

	        var index = -1,
	            length = props.length;

	        while (++index < length) {
	          var key = props[index];
	          result[key] = object[key];
	        }
	      } else {
	        callback = lodash.createCallback(callback, thisArg, 3);
	        forIn(object, function(value, key, object) {
	          if (!callback(value, key, object)) {
	            result[key] = value;
	          }
	        });
	      }
	      return result;
	    }

	    /**
	     * Creates a two dimensional array of an object's key-value pairs,
	     * i.e. `[[key1, value1], [key2, value2]]`.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to inspect.
	     * @returns {Array} Returns new array of key-value pairs.
	     * @example
	     *
	     * _.pairs({ 'barney': 36, 'fred': 40 });
	     * // => [['barney', 36], ['fred', 40]] (property order is not guaranteed across environments)
	     */
	    function pairs(object) {
	      var index = -1,
	          props = keys(object),
	          length = props.length,
	          result = Array(length);

	      while (++index < length) {
	        var key = props[index];
	        result[index] = [key, object[key]];
	      }
	      return result;
	    }

	    /**
	     * Creates a shallow clone of `object` composed of the specified properties.
	     * Property names may be specified as individual arguments or as arrays of
	     * property names. If a callback is provided it will be executed for each
	     * property of `object` picking the properties the callback returns truey
	     * for. The callback is bound to `thisArg` and invoked with three arguments;
	     * (value, key, object).
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The source object.
	     * @param {Function|...string|string[]} [callback] The function called per
	     *  iteration or property names to pick, specified as individual property
	     *  names or arrays of property names.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns an object composed of the picked properties.
	     * @example
	     *
	     * _.pick({ 'name': 'fred', '_userid': 'fred1' }, 'name');
	     * // => { 'name': 'fred' }
	     *
	     * _.pick({ 'name': 'fred', '_userid': 'fred1' }, function(value, key) {
	     *   return key.charAt(0) != '_';
	     * });
	     * // => { 'name': 'fred' }
	     */
	    function pick(object, callback, thisArg) {
	      var result = {};
	      if (typeof callback != 'function') {
	        var index = -1,
	            props = baseFlatten(arguments, true, false, 1),
	            length = isObject(object) ? props.length : 0;

	        while (++index < length) {
	          var key = props[index];
	          if (key in object) {
	            result[key] = object[key];
	          }
	        }
	      } else {
	        callback = lodash.createCallback(callback, thisArg, 3);
	        forIn(object, function(value, key, object) {
	          if (callback(value, key, object)) {
	            result[key] = value;
	          }
	        });
	      }
	      return result;
	    }

	    /**
	     * An alternative to `_.reduce` this method transforms `object` to a new
	     * `accumulator` object which is the result of running each of its own
	     * enumerable properties through a callback, with each callback execution
	     * potentially mutating the `accumulator` object. The callback is bound to
	     * `thisArg` and invoked with four arguments; (accumulator, value, key, object).
	     * Callbacks may exit iteration early by explicitly returning `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Array|Object} object The object to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [accumulator] The custom accumulator value.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the accumulated value.
	     * @example
	     *
	     * var squares = _.transform([1, 2, 3, 4, 5, 6, 7, 8, 9, 10], function(result, num) {
	     *   num *= num;
	     *   if (num % 2) {
	     *     return result.push(num) < 3;
	     *   }
	     * });
	     * // => [1, 9, 25]
	     *
	     * var mapped = _.transform({ 'a': 1, 'b': 2, 'c': 3 }, function(result, num, key) {
	     *   result[key] = num * 3;
	     * });
	     * // => { 'a': 3, 'b': 6, 'c': 9 }
	     */
	    function transform(object, callback, accumulator, thisArg) {
	      var isArr = isArray(object);
	      if (accumulator == null) {
	        if (isArr) {
	          accumulator = [];
	        } else {
	          var ctor = object && object.constructor,
	              proto = ctor && ctor.prototype;

	          accumulator = baseCreate(proto);
	        }
	      }
	      if (callback) {
	        callback = lodash.createCallback(callback, thisArg, 4);
	        (isArr ? baseEach : forOwn)(object, function(value, index, object) {
	          return callback(accumulator, value, index, object);
	        });
	      }
	      return accumulator;
	    }

	    /**
	     * Creates an array composed of the own enumerable property values of `object`.
	     *
	     * @static
	     * @memberOf _
	     * @category Objects
	     * @param {Object} object The object to inspect.
	     * @returns {Array} Returns an array of property values.
	     * @example
	     *
	     * _.values({ 'one': 1, 'two': 2, 'three': 3 });
	     * // => [1, 2, 3] (property order is not guaranteed across environments)
	     */
	    function values(object) {
	      var index = -1,
	          props = keys(object),
	          length = props.length,
	          result = Array(length);

	      while (++index < length) {
	        result[index] = object[props[index]];
	      }
	      return result;
	    }

	    /*--------------------------------------------------------------------------*/

	    /**
	     * Creates an array of elements from the specified indexes, or keys, of the
	     * `collection`. Indexes may be specified as individual arguments or as arrays
	     * of indexes.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {...(number|number[]|string|string[])} [index] The indexes of `collection`
	     *   to retrieve, specified as individual indexes or arrays of indexes.
	     * @returns {Array} Returns a new array of elements corresponding to the
	     *  provided indexes.
	     * @example
	     *
	     * _.at(['a', 'b', 'c', 'd', 'e'], [0, 2, 4]);
	     * // => ['a', 'c', 'e']
	     *
	     * _.at(['fred', 'barney', 'pebbles'], 0, 2);
	     * // => ['fred', 'pebbles']
	     */
	    function at(collection) {
	      var args = arguments,
	          index = -1,
	          props = baseFlatten(args, true, false, 1),
	          length = (args[2] && args[2][args[1]] === collection) ? 1 : props.length,
	          result = Array(length);

	      if (support.unindexedChars && isString(collection)) {
	        collection = collection.split('');
	      }
	      while(++index < length) {
	        result[index] = collection[props[index]];
	      }
	      return result;
	    }

	    /**
	     * Checks if a given value is present in a collection using strict equality
	     * for comparisons, i.e. `===`. If `fromIndex` is negative, it is used as the
	     * offset from the end of the collection.
	     *
	     * @static
	     * @memberOf _
	     * @alias include
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {*} target The value to check for.
	     * @param {number} [fromIndex=0] The index to search from.
	     * @returns {boolean} Returns `true` if the `target` element is found, else `false`.
	     * @example
	     *
	     * _.contains([1, 2, 3], 1);
	     * // => true
	     *
	     * _.contains([1, 2, 3], 1, 2);
	     * // => false
	     *
	     * _.contains({ 'name': 'fred', 'age': 40 }, 'fred');
	     * // => true
	     *
	     * _.contains('pebbles', 'eb');
	     * // => true
	     */
	    function contains(collection, target, fromIndex) {
	      var index = -1,
	          indexOf = getIndexOf(),
	          length = collection ? collection.length : 0,
	          result = false;

	      fromIndex = (fromIndex < 0 ? nativeMax(0, length + fromIndex) : fromIndex) || 0;
	      if (isArray(collection)) {
	        result = indexOf(collection, target, fromIndex) > -1;
	      } else if (typeof length == 'number') {
	        result = (isString(collection) ? collection.indexOf(target, fromIndex) : indexOf(collection, target, fromIndex)) > -1;
	      } else {
	        baseEach(collection, function(value) {
	          if (++index >= fromIndex) {
	            return !(result = value === target);
	          }
	        });
	      }
	      return result;
	    }

	    /**
	     * Creates an object composed of keys generated from the results of running
	     * each element of `collection` through the callback. The corresponding value
	     * of each key is the number of times the key was returned by the callback.
	     * The callback is bound to `thisArg` and invoked with three arguments;
	     * (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns the composed aggregate object.
	     * @example
	     *
	     * _.countBy([4.3, 6.1, 6.4], function(num) { return Math.floor(num); });
	     * // => { '4': 1, '6': 2 }
	     *
	     * _.countBy([4.3, 6.1, 6.4], function(num) { return this.floor(num); }, Math);
	     * // => { '4': 1, '6': 2 }
	     *
	     * _.countBy(['one', 'two', 'three'], 'length');
	     * // => { '3': 2, '5': 1 }
	     */
	    var countBy = createAggregator(function(result, value, key) {
	      (hasOwnProperty.call(result, key) ? result[key]++ : result[key] = 1);
	    });

	    /**
	     * Checks if the given callback returns truey value for **all** elements of
	     * a collection. The callback is bound to `thisArg` and invoked with three
	     * arguments; (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @alias all
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {boolean} Returns `true` if all elements passed the callback check,
	     *  else `false`.
	     * @example
	     *
	     * _.every([true, 1, null, 'yes']);
	     * // => false
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.every(characters, 'age');
	     * // => true
	     *
	     * // using "_.where" callback shorthand
	     * _.every(characters, { 'age': 36 });
	     * // => false
	     */
	    function every(collection, callback, thisArg) {
	      var result = true;
	      callback = lodash.createCallback(callback, thisArg, 3);

	      if (isArray(collection)) {
	        var index = -1,
	            length = collection.length;

	        while (++index < length) {
	          if (!(result = !!callback(collection[index], index, collection))) {
	            break;
	          }
	        }
	      } else {
	        baseEach(collection, function(value, index, collection) {
	          return (result = !!callback(value, index, collection));
	        });
	      }
	      return result;
	    }

	    /**
	     * Iterates over elements of a collection, returning an array of all elements
	     * the callback returns truey for. The callback is bound to `thisArg` and
	     * invoked with three arguments; (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @alias select
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a new array of elements that passed the callback check.
	     * @example
	     *
	     * var evens = _.filter([1, 2, 3, 4, 5, 6], function(num) { return num % 2 == 0; });
	     * // => [2, 4, 6]
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36, 'blocked': false },
	     *   { 'name': 'fred',   'age': 40, 'blocked': true }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.filter(characters, 'blocked');
	     * // => [{ 'name': 'fred', 'age': 40, 'blocked': true }]
	     *
	     * // using "_.where" callback shorthand
	     * _.filter(characters, { 'age': 36 });
	     * // => [{ 'name': 'barney', 'age': 36, 'blocked': false }]
	     */
	    function filter(collection, callback, thisArg) {
	      var result = [];
	      callback = lodash.createCallback(callback, thisArg, 3);

	      if (isArray(collection)) {
	        var index = -1,
	            length = collection.length;

	        while (++index < length) {
	          var value = collection[index];
	          if (callback(value, index, collection)) {
	            result.push(value);
	          }
	        }
	      } else {
	        baseEach(collection, function(value, index, collection) {
	          if (callback(value, index, collection)) {
	            result.push(value);
	          }
	        });
	      }
	      return result;
	    }

	    /**
	     * Iterates over elements of a collection, returning the first element that
	     * the callback returns truey for. The callback is bound to `thisArg` and
	     * invoked with three arguments; (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @alias detect, findWhere
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the found element, else `undefined`.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'age': 36, 'blocked': false },
	     *   { 'name': 'fred',    'age': 40, 'blocked': true },
	     *   { 'name': 'pebbles', 'age': 1,  'blocked': false }
	     * ];
	     *
	     * _.find(characters, function(chr) {
	     *   return chr.age < 40;
	     * });
	     * // => { 'name': 'barney', 'age': 36, 'blocked': false }
	     *
	     * // using "_.where" callback shorthand
	     * _.find(characters, { 'age': 1 });
	     * // =>  { 'name': 'pebbles', 'age': 1, 'blocked': false }
	     *
	     * // using "_.pluck" callback shorthand
	     * _.find(characters, 'blocked');
	     * // => { 'name': 'fred', 'age': 40, 'blocked': true }
	     */
	    function find(collection, callback, thisArg) {
	      callback = lodash.createCallback(callback, thisArg, 3);

	      if (isArray(collection)) {
	        var index = -1,
	            length = collection.length;

	        while (++index < length) {
	          var value = collection[index];
	          if (callback(value, index, collection)) {
	            return value;
	          }
	        }
	      } else {
	        var result;
	        baseEach(collection, function(value, index, collection) {
	          if (callback(value, index, collection)) {
	            result = value;
	            return false;
	          }
	        });
	        return result;
	      }
	    }

	    /**
	     * This method is like `_.find` except that it iterates over elements
	     * of a `collection` from right to left.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the found element, else `undefined`.
	     * @example
	     *
	     * _.findLast([1, 2, 3, 4], function(num) {
	     *   return num % 2 == 1;
	     * });
	     * // => 3
	     */
	    function findLast(collection, callback, thisArg) {
	      var result;
	      callback = lodash.createCallback(callback, thisArg, 3);
	      forEachRight(collection, function(value, index, collection) {
	        if (callback(value, index, collection)) {
	          result = value;
	          return false;
	        }
	      });
	      return result;
	    }

	    /**
	     * Iterates over elements of a collection, executing the callback for each
	     * element. The callback is bound to `thisArg` and invoked with three arguments;
	     * (value, index|key, collection). Callbacks may exit iteration early by
	     * explicitly returning `false`.
	     *
	     * Note: As with other "Collections" methods, objects with a `length` property
	     * are iterated like arrays. To avoid this behavior `_.forIn` or `_.forOwn`
	     * may be used for object iteration.
	     *
	     * @static
	     * @memberOf _
	     * @alias each
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array|Object|string} Returns `collection`.
	     * @example
	     *
	     * _([1, 2, 3]).forEach(function(num) { console.log(num); }).join(',');
	     * // => logs each number and returns '1,2,3'
	     *
	     * _.forEach({ 'one': 1, 'two': 2, 'three': 3 }, function(num) { console.log(num); });
	     * // => logs each number and returns the object (property order is not guaranteed across environments)
	     */
	    function forEach(collection, callback, thisArg) {
	      if (callback && typeof thisArg == 'undefined' && isArray(collection)) {
	        var index = -1,
	            length = collection.length;

	        while (++index < length) {
	          if (callback(collection[index], index, collection) === false) {
	            break;
	          }
	        }
	      } else {
	        baseEach(collection, callback, thisArg);
	      }
	      return collection;
	    }

	    /**
	     * This method is like `_.forEach` except that it iterates over elements
	     * of a `collection` from right to left.
	     *
	     * @static
	     * @memberOf _
	     * @alias eachRight
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array|Object|string} Returns `collection`.
	     * @example
	     *
	     * _([1, 2, 3]).forEachRight(function(num) { console.log(num); }).join(',');
	     * // => logs each number from right to left and returns '3,2,1'
	     */
	    function forEachRight(collection, callback, thisArg) {
	      var iterable = collection,
	          length = collection ? collection.length : 0;

	      callback = callback && typeof thisArg == 'undefined' ? callback : baseCreateCallback(callback, thisArg, 3);
	      if (isArray(collection)) {
	        while (length--) {
	          if (callback(collection[length], length, collection) === false) {
	            break;
	          }
	        }
	      } else {
	        if (typeof length != 'number') {
	          var props = keys(collection);
	          length = props.length;
	        } else if (support.unindexedChars && isString(collection)) {
	          iterable = collection.split('');
	        }
	        baseEach(collection, function(value, key, collection) {
	          key = props ? props[--length] : --length;
	          return callback(iterable[key], key, collection);
	        });
	      }
	      return collection;
	    }

	    /**
	     * Creates an object composed of keys generated from the results of running
	     * each element of a collection through the callback. The corresponding value
	     * of each key is an array of the elements responsible for generating the key.
	     * The callback is bound to `thisArg` and invoked with three arguments;
	     * (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns the composed aggregate object.
	     * @example
	     *
	     * _.groupBy([4.2, 6.1, 6.4], function(num) { return Math.floor(num); });
	     * // => { '4': [4.2], '6': [6.1, 6.4] }
	     *
	     * _.groupBy([4.2, 6.1, 6.4], function(num) { return this.floor(num); }, Math);
	     * // => { '4': [4.2], '6': [6.1, 6.4] }
	     *
	     * // using "_.pluck" callback shorthand
	     * _.groupBy(['one', 'two', 'three'], 'length');
	     * // => { '3': ['one', 'two'], '5': ['three'] }
	     */
	    var groupBy = createAggregator(function(result, value, key) {
	      (hasOwnProperty.call(result, key) ? result[key] : result[key] = []).push(value);
	    });

	    /**
	     * Creates an object composed of keys generated from the results of running
	     * each element of the collection through the given callback. The corresponding
	     * value of each key is the last element responsible for generating the key.
	     * The callback is bound to `thisArg` and invoked with three arguments;
	     * (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Object} Returns the composed aggregate object.
	     * @example
	     *
	     * var keys = [
	     *   { 'dir': 'left', 'code': 97 },
	     *   { 'dir': 'right', 'code': 100 }
	     * ];
	     *
	     * _.indexBy(keys, 'dir');
	     * // => { 'left': { 'dir': 'left', 'code': 97 }, 'right': { 'dir': 'right', 'code': 100 } }
	     *
	     * _.indexBy(keys, function(key) { return String.fromCharCode(key.code); });
	     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
	     *
	     * _.indexBy(characters, function(key) { this.fromCharCode(key.code); }, String);
	     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
	     */
	    var indexBy = createAggregator(function(result, value, key) {
	      result[key] = value;
	    });

	    /**
	     * Invokes the method named by `methodName` on each element in the `collection`
	     * returning an array of the results of each invoked method. Additional arguments
	     * will be provided to each invoked method. If `methodName` is a function it
	     * will be invoked for, and `this` bound to, each element in the `collection`.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|string} methodName The name of the method to invoke or
	     *  the function invoked per iteration.
	     * @param {...*} [arg] Arguments to invoke the method with.
	     * @returns {Array} Returns a new array of the results of each invoked method.
	     * @example
	     *
	     * _.invoke([[5, 1, 7], [3, 2, 1]], 'sort');
	     * // => [[1, 5, 7], [1, 2, 3]]
	     *
	     * _.invoke([123, 456], String.prototype.split, '');
	     * // => [['1', '2', '3'], ['4', '5', '6']]
	     */
	    function invoke(collection, methodName) {
	      var args = slice(arguments, 2),
	          index = -1,
	          isFunc = typeof methodName == 'function',
	          length = collection ? collection.length : 0,
	          result = Array(typeof length == 'number' ? length : 0);

	      forEach(collection, function(value) {
	        result[++index] = (isFunc ? methodName : value[methodName]).apply(value, args);
	      });
	      return result;
	    }

	    /**
	     * Creates an array of values by running each element in the collection
	     * through the callback. The callback is bound to `thisArg` and invoked with
	     * three arguments; (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @alias collect
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a new array of the results of each `callback` execution.
	     * @example
	     *
	     * _.map([1, 2, 3], function(num) { return num * 3; });
	     * // => [3, 6, 9]
	     *
	     * _.map({ 'one': 1, 'two': 2, 'three': 3 }, function(num) { return num * 3; });
	     * // => [3, 6, 9] (property order is not guaranteed across environments)
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.map(characters, 'name');
	     * // => ['barney', 'fred']
	     */
	    function map(collection, callback, thisArg) {
	      var index = -1,
	          length = collection ? collection.length : 0,
	          result = Array(typeof length == 'number' ? length : 0);

	      callback = lodash.createCallback(callback, thisArg, 3);
	      if (isArray(collection)) {
	        while (++index < length) {
	          result[index] = callback(collection[index], index, collection);
	        }
	      } else {
	        baseEach(collection, function(value, key, collection) {
	          result[++index] = callback(value, key, collection);
	        });
	      }
	      return result;
	    }

	    /**
	     * Retrieves the maximum value of a collection. If the collection is empty or
	     * falsey `-Infinity` is returned. If a callback is provided it will be executed
	     * for each value in the collection to generate the criterion by which the value
	     * is ranked. The callback is bound to `thisArg` and invoked with three
	     * arguments; (value, index, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the maximum value.
	     * @example
	     *
	     * _.max([4, 2, 8, 6]);
	     * // => 8
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * _.max(characters, function(chr) { return chr.age; });
	     * // => { 'name': 'fred', 'age': 40 };
	     *
	     * // using "_.pluck" callback shorthand
	     * _.max(characters, 'age');
	     * // => { 'name': 'fred', 'age': 40 };
	     */
	    function max(collection, callback, thisArg) {
	      var computed = -Infinity,
	          result = computed;

	      // allows working with functions like `_.map` without using
	      // their `index` argument as a callback
	      if (typeof callback != 'function' && thisArg && thisArg[callback] === collection) {
	        callback = null;
	      }
	      if (callback == null && isArray(collection)) {
	        var index = -1,
	            length = collection.length;

	        while (++index < length) {
	          var value = collection[index];
	          if (value > result) {
	            result = value;
	          }
	        }
	      } else {
	        callback = (callback == null && isString(collection))
	          ? charAtCallback
	          : lodash.createCallback(callback, thisArg, 3);

	        baseEach(collection, function(value, index, collection) {
	          var current = callback(value, index, collection);
	          if (current > computed) {
	            computed = current;
	            result = value;
	          }
	        });
	      }
	      return result;
	    }

	    /**
	     * Retrieves the minimum value of a collection. If the collection is empty or
	     * falsey `Infinity` is returned. If a callback is provided it will be executed
	     * for each value in the collection to generate the criterion by which the value
	     * is ranked. The callback is bound to `thisArg` and invoked with three
	     * arguments; (value, index, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the minimum value.
	     * @example
	     *
	     * _.min([4, 2, 8, 6]);
	     * // => 2
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * _.min(characters, function(chr) { return chr.age; });
	     * // => { 'name': 'barney', 'age': 36 };
	     *
	     * // using "_.pluck" callback shorthand
	     * _.min(characters, 'age');
	     * // => { 'name': 'barney', 'age': 36 };
	     */
	    function min(collection, callback, thisArg) {
	      var computed = Infinity,
	          result = computed;

	      // allows working with functions like `_.map` without using
	      // their `index` argument as a callback
	      if (typeof callback != 'function' && thisArg && thisArg[callback] === collection) {
	        callback = null;
	      }
	      if (callback == null && isArray(collection)) {
	        var index = -1,
	            length = collection.length;

	        while (++index < length) {
	          var value = collection[index];
	          if (value < result) {
	            result = value;
	          }
	        }
	      } else {
	        callback = (callback == null && isString(collection))
	          ? charAtCallback
	          : lodash.createCallback(callback, thisArg, 3);

	        baseEach(collection, function(value, index, collection) {
	          var current = callback(value, index, collection);
	          if (current < computed) {
	            computed = current;
	            result = value;
	          }
	        });
	      }
	      return result;
	    }

	    /**
	     * Retrieves the value of a specified property from all elements in the collection.
	     *
	     * @static
	     * @memberOf _
	     * @type Function
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {string} property The name of the property to pluck.
	     * @returns {Array} Returns a new array of property values.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * _.pluck(characters, 'name');
	     * // => ['barney', 'fred']
	     */
	    var pluck = map;

	    /**
	     * Reduces a collection to a value which is the accumulated result of running
	     * each element in the collection through the callback, where each successive
	     * callback execution consumes the return value of the previous execution. If
	     * `accumulator` is not provided the first element of the collection will be
	     * used as the initial `accumulator` value. The callback is bound to `thisArg`
	     * and invoked with four arguments; (accumulator, value, index|key, collection).
	     *
	     * @static
	     * @memberOf _
	     * @alias foldl, inject
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [accumulator] Initial value of the accumulator.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the accumulated value.
	     * @example
	     *
	     * var sum = _.reduce([1, 2, 3], function(sum, num) {
	     *   return sum + num;
	     * });
	     * // => 6
	     *
	     * var mapped = _.reduce({ 'a': 1, 'b': 2, 'c': 3 }, function(result, num, key) {
	     *   result[key] = num * 3;
	     *   return result;
	     * }, {});
	     * // => { 'a': 3, 'b': 6, 'c': 9 }
	     */
	    function reduce(collection, callback, accumulator, thisArg) {
	      var noaccum = arguments.length < 3;
	      callback = lodash.createCallback(callback, thisArg, 4);

	      if (isArray(collection)) {
	        var index = -1,
	            length = collection.length;

	        if (noaccum) {
	          accumulator = collection[++index];
	        }
	        while (++index < length) {
	          accumulator = callback(accumulator, collection[index], index, collection);
	        }
	      } else {
	        baseEach(collection, function(value, index, collection) {
	          accumulator = noaccum
	            ? (noaccum = false, value)
	            : callback(accumulator, value, index, collection)
	        });
	      }
	      return accumulator;
	    }

	    /**
	     * This method is like `_.reduce` except that it iterates over elements
	     * of a `collection` from right to left.
	     *
	     * @static
	     * @memberOf _
	     * @alias foldr
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function} [callback=identity] The function called per iteration.
	     * @param {*} [accumulator] Initial value of the accumulator.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the accumulated value.
	     * @example
	     *
	     * var list = [[0, 1], [2, 3], [4, 5]];
	     * var flat = _.reduceRight(list, function(a, b) { return a.concat(b); }, []);
	     * // => [4, 5, 2, 3, 0, 1]
	     */
	    function reduceRight(collection, callback, accumulator, thisArg) {
	      var noaccum = arguments.length < 3;
	      callback = lodash.createCallback(callback, thisArg, 4);
	      forEachRight(collection, function(value, index, collection) {
	        accumulator = noaccum
	          ? (noaccum = false, value)
	          : callback(accumulator, value, index, collection);
	      });
	      return accumulator;
	    }

	    /**
	     * The opposite of `_.filter` this method returns the elements of a
	     * collection that the callback does **not** return truey for.
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a new array of elements that failed the callback check.
	     * @example
	     *
	     * var odds = _.reject([1, 2, 3, 4, 5, 6], function(num) { return num % 2 == 0; });
	     * // => [1, 3, 5]
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36, 'blocked': false },
	     *   { 'name': 'fred',   'age': 40, 'blocked': true }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.reject(characters, 'blocked');
	     * // => [{ 'name': 'barney', 'age': 36, 'blocked': false }]
	     *
	     * // using "_.where" callback shorthand
	     * _.reject(characters, { 'age': 36 });
	     * // => [{ 'name': 'fred', 'age': 40, 'blocked': true }]
	     */
	    function reject(collection, callback, thisArg) {
	      callback = lodash.createCallback(callback, thisArg, 3);
	      return filter(collection, function(value, index, collection) {
	        return !callback(value, index, collection);
	      });
	    }

	    /**
	     * Retrieves a random element or `n` random elements from a collection.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to sample.
	     * @param {number} [n] The number of elements to sample.
	     * @param- {Object} [guard] Allows working with functions like `_.map`
	     *  without using their `index` arguments as `n`.
	     * @returns {Array} Returns the random sample(s) of `collection`.
	     * @example
	     *
	     * _.sample([1, 2, 3, 4]);
	     * // => 2
	     *
	     * _.sample([1, 2, 3, 4], 2);
	     * // => [3, 1]
	     */
	    function sample(collection, n, guard) {
	      if (collection && typeof collection.length != 'number') {
	        collection = values(collection);
	      } else if (support.unindexedChars && isString(collection)) {
	        collection = collection.split('');
	      }
	      if (n == null || guard) {
	        return collection ? collection[baseRandom(0, collection.length - 1)] : undefined;
	      }
	      var result = shuffle(collection);
	      result.length = nativeMin(nativeMax(0, n), result.length);
	      return result;
	    }

	    /**
	     * Creates an array of shuffled values, using a version of the Fisher-Yates
	     * shuffle. See http://en.wikipedia.org/wiki/Fisher-Yates_shuffle.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to shuffle.
	     * @returns {Array} Returns a new shuffled collection.
	     * @example
	     *
	     * _.shuffle([1, 2, 3, 4, 5, 6]);
	     * // => [4, 1, 6, 3, 5, 2]
	     */
	    function shuffle(collection) {
	      var index = -1,
	          length = collection ? collection.length : 0,
	          result = Array(typeof length == 'number' ? length : 0);

	      forEach(collection, function(value) {
	        var rand = baseRandom(0, ++index);
	        result[index] = result[rand];
	        result[rand] = value;
	      });
	      return result;
	    }

	    /**
	     * Gets the size of the `collection` by returning `collection.length` for arrays
	     * and array-like objects or the number of own enumerable properties for objects.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to inspect.
	     * @returns {number} Returns `collection.length` or number of own enumerable properties.
	     * @example
	     *
	     * _.size([1, 2]);
	     * // => 2
	     *
	     * _.size({ 'one': 1, 'two': 2, 'three': 3 });
	     * // => 3
	     *
	     * _.size('pebbles');
	     * // => 7
	     */
	    function size(collection) {
	      var length = collection ? collection.length : 0;
	      return typeof length == 'number' ? length : keys(collection).length;
	    }

	    /**
	     * Checks if the callback returns a truey value for **any** element of a
	     * collection. The function returns as soon as it finds a passing value and
	     * does not iterate over the entire collection. The callback is bound to
	     * `thisArg` and invoked with three arguments; (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @alias any
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {boolean} Returns `true` if any element passed the callback check,
	     *  else `false`.
	     * @example
	     *
	     * _.some([null, 0, 'yes', false], Boolean);
	     * // => true
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36, 'blocked': false },
	     *   { 'name': 'fred',   'age': 40, 'blocked': true }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.some(characters, 'blocked');
	     * // => true
	     *
	     * // using "_.where" callback shorthand
	     * _.some(characters, { 'age': 1 });
	     * // => false
	     */
	    function some(collection, callback, thisArg) {
	      var result;
	      callback = lodash.createCallback(callback, thisArg, 3);

	      if (isArray(collection)) {
	        var index = -1,
	            length = collection.length;

	        while (++index < length) {
	          if ((result = callback(collection[index], index, collection))) {
	            break;
	          }
	        }
	      } else {
	        baseEach(collection, function(value, index, collection) {
	          return !(result = callback(value, index, collection));
	        });
	      }
	      return !!result;
	    }

	    /**
	     * Creates an array of elements, sorted in ascending order by the results of
	     * running each element in a collection through the callback. This method
	     * performs a stable sort, that is, it will preserve the original sort order
	     * of equal elements. The callback is bound to `thisArg` and invoked with
	     * three arguments; (value, index|key, collection).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an array of property names is provided for `callback` the collection
	     * will be sorted by each property value.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Array|Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a new array of sorted elements.
	     * @example
	     *
	     * _.sortBy([1, 2, 3], function(num) { return Math.sin(num); });
	     * // => [3, 1, 2]
	     *
	     * _.sortBy([1, 2, 3], function(num) { return this.sin(num); }, Math);
	     * // => [3, 1, 2]
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'age': 36 },
	     *   { 'name': 'fred',    'age': 40 },
	     *   { 'name': 'barney',  'age': 26 },
	     *   { 'name': 'fred',    'age': 30 }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.map(_.sortBy(characters, 'age'), _.values);
	     * // => [['barney', 26], ['fred', 30], ['barney', 36], ['fred', 40]]
	     *
	     * // sorting by multiple properties
	     * _.map(_.sortBy(characters, ['name', 'age']), _.values);
	     * // = > [['barney', 26], ['barney', 36], ['fred', 30], ['fred', 40]]
	     */
	    function sortBy(collection, callback, thisArg) {
	      var index = -1,
	          isArr = isArray(callback),
	          length = collection ? collection.length : 0,
	          result = Array(typeof length == 'number' ? length : 0);

	      if (!isArr) {
	        callback = lodash.createCallback(callback, thisArg, 3);
	      }
	      forEach(collection, function(value, key, collection) {
	        var object = result[++index] = getObject();
	        if (isArr) {
	          object.criteria = map(callback, function(key) { return value[key]; });
	        } else {
	          (object.criteria = getArray())[0] = callback(value, key, collection);
	        }
	        object.index = index;
	        object.value = value;
	      });

	      length = result.length;
	      result.sort(compareAscending);
	      while (length--) {
	        var object = result[length];
	        result[length] = object.value;
	        if (!isArr) {
	          releaseArray(object.criteria);
	        }
	        releaseObject(object);
	      }
	      return result;
	    }

	    /**
	     * Converts the `collection` to an array.
	     *
	     * @static
	     * @memberOf _
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to convert.
	     * @returns {Array} Returns the new converted array.
	     * @example
	     *
	     * (function() { return _.toArray(arguments).slice(1); })(1, 2, 3, 4);
	     * // => [2, 3, 4]
	     */
	    function toArray(collection) {
	      if (collection && typeof collection.length == 'number') {
	        return (support.unindexedChars && isString(collection))
	          ? collection.split('')
	          : slice(collection);
	      }
	      return values(collection);
	    }

	    /**
	     * Performs a deep comparison of each element in a `collection` to the given
	     * `properties` object, returning an array of all elements that have equivalent
	     * property values.
	     *
	     * @static
	     * @memberOf _
	     * @type Function
	     * @category Collections
	     * @param {Array|Object|string} collection The collection to iterate over.
	     * @param {Object} props The object of property values to filter by.
	     * @returns {Array} Returns a new array of elements that have the given properties.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36, 'pets': ['hoppy'] },
	     *   { 'name': 'fred',   'age': 40, 'pets': ['baby puss', 'dino'] }
	     * ];
	     *
	     * _.where(characters, { 'age': 36 });
	     * // => [{ 'name': 'barney', 'age': 36, 'pets': ['hoppy'] }]
	     *
	     * _.where(characters, { 'pets': ['dino'] });
	     * // => [{ 'name': 'fred', 'age': 40, 'pets': ['baby puss', 'dino'] }]
	     */
	    var where = filter;

	    /*--------------------------------------------------------------------------*/

	    /**
	     * Creates an array with all falsey values removed. The values `false`, `null`,
	     * `0`, `""`, `undefined`, and `NaN` are all falsey.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to compact.
	     * @returns {Array} Returns a new array of filtered values.
	     * @example
	     *
	     * _.compact([0, 1, false, 2, '', 3]);
	     * // => [1, 2, 3]
	     */
	    function compact(array) {
	      var index = -1,
	          length = array ? array.length : 0,
	          result = [];

	      while (++index < length) {
	        var value = array[index];
	        if (value) {
	          result.push(value);
	        }
	      }
	      return result;
	    }

	    /**
	     * Creates an array excluding all values of the provided arrays using strict
	     * equality for comparisons, i.e. `===`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to process.
	     * @param {...Array} [values] The arrays of values to exclude.
	     * @returns {Array} Returns a new array of filtered values.
	     * @example
	     *
	     * _.difference([1, 2, 3, 4, 5], [5, 2, 10]);
	     * // => [1, 3, 4]
	     */
	    function difference(array) {
	      return baseDifference(array, baseFlatten(arguments, true, true, 1));
	    }

	    /**
	     * This method is like `_.find` except that it returns the index of the first
	     * element that passes the callback check, instead of the element itself.
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to search.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {number} Returns the index of the found element, else `-1`.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'age': 36, 'blocked': false },
	     *   { 'name': 'fred',    'age': 40, 'blocked': true },
	     *   { 'name': 'pebbles', 'age': 1,  'blocked': false }
	     * ];
	     *
	     * _.findIndex(characters, function(chr) {
	     *   return chr.age < 20;
	     * });
	     * // => 2
	     *
	     * // using "_.where" callback shorthand
	     * _.findIndex(characters, { 'age': 36 });
	     * // => 0
	     *
	     * // using "_.pluck" callback shorthand
	     * _.findIndex(characters, 'blocked');
	     * // => 1
	     */
	    function findIndex(array, callback, thisArg) {
	      var index = -1,
	          length = array ? array.length : 0;

	      callback = lodash.createCallback(callback, thisArg, 3);
	      while (++index < length) {
	        if (callback(array[index], index, array)) {
	          return index;
	        }
	      }
	      return -1;
	    }

	    /**
	     * This method is like `_.findIndex` except that it iterates over elements
	     * of a `collection` from right to left.
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to search.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {number} Returns the index of the found element, else `-1`.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'age': 36, 'blocked': true },
	     *   { 'name': 'fred',    'age': 40, 'blocked': false },
	     *   { 'name': 'pebbles', 'age': 1,  'blocked': true }
	     * ];
	     *
	     * _.findLastIndex(characters, function(chr) {
	     *   return chr.age > 30;
	     * });
	     * // => 1
	     *
	     * // using "_.where" callback shorthand
	     * _.findLastIndex(characters, { 'age': 36 });
	     * // => 0
	     *
	     * // using "_.pluck" callback shorthand
	     * _.findLastIndex(characters, 'blocked');
	     * // => 2
	     */
	    function findLastIndex(array, callback, thisArg) {
	      var length = array ? array.length : 0;
	      callback = lodash.createCallback(callback, thisArg, 3);
	      while (length--) {
	        if (callback(array[length], length, array)) {
	          return length;
	        }
	      }
	      return -1;
	    }

	    /**
	     * Gets the first element or first `n` elements of an array. If a callback
	     * is provided elements at the beginning of the array are returned as long
	     * as the callback returns truey. The callback is bound to `thisArg` and
	     * invoked with three arguments; (value, index, array).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @alias head, take
	     * @category Arrays
	     * @param {Array} array The array to query.
	     * @param {Function|Object|number|string} [callback] The function called
	     *  per element or the number of elements to return. If a property name or
	     *  object is provided it will be used to create a "_.pluck" or "_.where"
	     *  style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the first element(s) of `array`.
	     * @example
	     *
	     * _.first([1, 2, 3]);
	     * // => 1
	     *
	     * _.first([1, 2, 3], 2);
	     * // => [1, 2]
	     *
	     * _.first([1, 2, 3], function(num) {
	     *   return num < 3;
	     * });
	     * // => [1, 2]
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'blocked': true,  'employer': 'slate' },
	     *   { 'name': 'fred',    'blocked': false, 'employer': 'slate' },
	     *   { 'name': 'pebbles', 'blocked': true,  'employer': 'na' }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.first(characters, 'blocked');
	     * // => [{ 'name': 'barney', 'blocked': true, 'employer': 'slate' }]
	     *
	     * // using "_.where" callback shorthand
	     * _.pluck(_.first(characters, { 'employer': 'slate' }), 'name');
	     * // => ['barney', 'fred']
	     */
	    function first(array, callback, thisArg) {
	      var n = 0,
	          length = array ? array.length : 0;

	      if (typeof callback != 'number' && callback != null) {
	        var index = -1;
	        callback = lodash.createCallback(callback, thisArg, 3);
	        while (++index < length && callback(array[index], index, array)) {
	          n++;
	        }
	      } else {
	        n = callback;
	        if (n == null || thisArg) {
	          return array ? array[0] : undefined;
	        }
	      }
	      return slice(array, 0, nativeMin(nativeMax(0, n), length));
	    }

	    /**
	     * Flattens a nested array (the nesting can be to any depth). If `isShallow`
	     * is truey, the array will only be flattened a single level. If a callback
	     * is provided each element of the array is passed through the callback before
	     * flattening. The callback is bound to `thisArg` and invoked with three
	     * arguments; (value, index, array).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to flatten.
	     * @param {boolean} [isShallow=false] A flag to restrict flattening to a single level.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a new flattened array.
	     * @example
	     *
	     * _.flatten([1, [2], [3, [[4]]]]);
	     * // => [1, 2, 3, 4];
	     *
	     * _.flatten([1, [2], [3, [[4]]]], true);
	     * // => [1, 2, 3, [[4]]];
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 30, 'pets': ['hoppy'] },
	     *   { 'name': 'fred',   'age': 40, 'pets': ['baby puss', 'dino'] }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.flatten(characters, 'pets');
	     * // => ['hoppy', 'baby puss', 'dino']
	     */
	    function flatten(array, isShallow, callback, thisArg) {
	      // juggle arguments
	      if (typeof isShallow != 'boolean' && isShallow != null) {
	        thisArg = callback;
	        callback = (typeof isShallow != 'function' && thisArg && thisArg[isShallow] === array) ? null : isShallow;
	        isShallow = false;
	      }
	      if (callback != null) {
	        array = map(array, callback, thisArg);
	      }
	      return baseFlatten(array, isShallow);
	    }

	    /**
	     * Gets the index at which the first occurrence of `value` is found using
	     * strict equality for comparisons, i.e. `===`. If the array is already sorted
	     * providing `true` for `fromIndex` will run a faster binary search.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to search.
	     * @param {*} value The value to search for.
	     * @param {boolean|number} [fromIndex=0] The index to search from or `true`
	     *  to perform a binary search on a sorted array.
	     * @returns {number} Returns the index of the matched value or `-1`.
	     * @example
	     *
	     * _.indexOf([1, 2, 3, 1, 2, 3], 2);
	     * // => 1
	     *
	     * _.indexOf([1, 2, 3, 1, 2, 3], 2, 3);
	     * // => 4
	     *
	     * _.indexOf([1, 1, 2, 2, 3, 3], 2, true);
	     * // => 2
	     */
	    function indexOf(array, value, fromIndex) {
	      if (typeof fromIndex == 'number') {
	        var length = array ? array.length : 0;
	        fromIndex = (fromIndex < 0 ? nativeMax(0, length + fromIndex) : fromIndex || 0);
	      } else if (fromIndex) {
	        var index = sortedIndex(array, value);
	        return array[index] === value ? index : -1;
	      }
	      return baseIndexOf(array, value, fromIndex);
	    }

	    /**
	     * Gets all but the last element or last `n` elements of an array. If a
	     * callback is provided elements at the end of the array are excluded from
	     * the result as long as the callback returns truey. The callback is bound
	     * to `thisArg` and invoked with three arguments; (value, index, array).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to query.
	     * @param {Function|Object|number|string} [callback=1] The function called
	     *  per element or the number of elements to exclude. If a property name or
	     *  object is provided it will be used to create a "_.pluck" or "_.where"
	     *  style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a slice of `array`.
	     * @example
	     *
	     * _.initial([1, 2, 3]);
	     * // => [1, 2]
	     *
	     * _.initial([1, 2, 3], 2);
	     * // => [1]
	     *
	     * _.initial([1, 2, 3], function(num) {
	     *   return num > 1;
	     * });
	     * // => [1]
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'blocked': false, 'employer': 'slate' },
	     *   { 'name': 'fred',    'blocked': true,  'employer': 'slate' },
	     *   { 'name': 'pebbles', 'blocked': true,  'employer': 'na' }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.initial(characters, 'blocked');
	     * // => [{ 'name': 'barney',  'blocked': false, 'employer': 'slate' }]
	     *
	     * // using "_.where" callback shorthand
	     * _.pluck(_.initial(characters, { 'employer': 'na' }), 'name');
	     * // => ['barney', 'fred']
	     */
	    function initial(array, callback, thisArg) {
	      var n = 0,
	          length = array ? array.length : 0;

	      if (typeof callback != 'number' && callback != null) {
	        var index = length;
	        callback = lodash.createCallback(callback, thisArg, 3);
	        while (index-- && callback(array[index], index, array)) {
	          n++;
	        }
	      } else {
	        n = (callback == null || thisArg) ? 1 : callback || n;
	      }
	      return slice(array, 0, nativeMin(nativeMax(0, length - n), length));
	    }

	    /**
	     * Creates an array of unique values present in all provided arrays using
	     * strict equality for comparisons, i.e. `===`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {...Array} [array] The arrays to inspect.
	     * @returns {Array} Returns an array of shared values.
	     * @example
	     *
	     * _.intersection([1, 2, 3], [5, 2, 1, 4], [2, 1]);
	     * // => [1, 2]
	     */
	    function intersection() {
	      var args = [],
	          argsIndex = -1,
	          argsLength = arguments.length,
	          caches = getArray(),
	          indexOf = getIndexOf(),
	          trustIndexOf = indexOf === baseIndexOf,
	          seen = getArray();

	      while (++argsIndex < argsLength) {
	        var value = arguments[argsIndex];
	        if (isArray(value) || isArguments(value)) {
	          args.push(value);
	          caches.push(trustIndexOf && value.length >= largeArraySize &&
	            createCache(argsIndex ? args[argsIndex] : seen));
	        }
	      }
	      var array = args[0],
	          index = -1,
	          length = array ? array.length : 0,
	          result = [];

	      outer:
	      while (++index < length) {
	        var cache = caches[0];
	        value = array[index];

	        if ((cache ? cacheIndexOf(cache, value) : indexOf(seen, value)) < 0) {
	          argsIndex = argsLength;
	          (cache || seen).push(value);
	          while (--argsIndex) {
	            cache = caches[argsIndex];
	            if ((cache ? cacheIndexOf(cache, value) : indexOf(args[argsIndex], value)) < 0) {
	              continue outer;
	            }
	          }
	          result.push(value);
	        }
	      }
	      while (argsLength--) {
	        cache = caches[argsLength];
	        if (cache) {
	          releaseObject(cache);
	        }
	      }
	      releaseArray(caches);
	      releaseArray(seen);
	      return result;
	    }

	    /**
	     * Gets the last element or last `n` elements of an array. If a callback is
	     * provided elements at the end of the array are returned as long as the
	     * callback returns truey. The callback is bound to `thisArg` and invoked
	     * with three arguments; (value, index, array).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to query.
	     * @param {Function|Object|number|string} [callback] The function called
	     *  per element or the number of elements to return. If a property name or
	     *  object is provided it will be used to create a "_.pluck" or "_.where"
	     *  style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {*} Returns the last element(s) of `array`.
	     * @example
	     *
	     * _.last([1, 2, 3]);
	     * // => 3
	     *
	     * _.last([1, 2, 3], 2);
	     * // => [2, 3]
	     *
	     * _.last([1, 2, 3], function(num) {
	     *   return num > 1;
	     * });
	     * // => [2, 3]
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'blocked': false, 'employer': 'slate' },
	     *   { 'name': 'fred',    'blocked': true,  'employer': 'slate' },
	     *   { 'name': 'pebbles', 'blocked': true,  'employer': 'na' }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.pluck(_.last(characters, 'blocked'), 'name');
	     * // => ['fred', 'pebbles']
	     *
	     * // using "_.where" callback shorthand
	     * _.last(characters, { 'employer': 'na' });
	     * // => [{ 'name': 'pebbles', 'blocked': true, 'employer': 'na' }]
	     */
	    function last(array, callback, thisArg) {
	      var n = 0,
	          length = array ? array.length : 0;

	      if (typeof callback != 'number' && callback != null) {
	        var index = length;
	        callback = lodash.createCallback(callback, thisArg, 3);
	        while (index-- && callback(array[index], index, array)) {
	          n++;
	        }
	      } else {
	        n = callback;
	        if (n == null || thisArg) {
	          return array ? array[length - 1] : undefined;
	        }
	      }
	      return slice(array, nativeMax(0, length - n));
	    }

	    /**
	     * Gets the index at which the last occurrence of `value` is found using strict
	     * equality for comparisons, i.e. `===`. If `fromIndex` is negative, it is used
	     * as the offset from the end of the collection.
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to search.
	     * @param {*} value The value to search for.
	     * @param {number} [fromIndex=array.length-1] The index to search from.
	     * @returns {number} Returns the index of the matched value or `-1`.
	     * @example
	     *
	     * _.lastIndexOf([1, 2, 3, 1, 2, 3], 2);
	     * // => 4
	     *
	     * _.lastIndexOf([1, 2, 3, 1, 2, 3], 2, 3);
	     * // => 1
	     */
	    function lastIndexOf(array, value, fromIndex) {
	      var index = array ? array.length : 0;
	      if (typeof fromIndex == 'number') {
	        index = (fromIndex < 0 ? nativeMax(0, index + fromIndex) : nativeMin(fromIndex, index - 1)) + 1;
	      }
	      while (index--) {
	        if (array[index] === value) {
	          return index;
	        }
	      }
	      return -1;
	    }

	    /**
	     * Removes all provided values from the given array using strict equality for
	     * comparisons, i.e. `===`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to modify.
	     * @param {...*} [value] The values to remove.
	     * @returns {Array} Returns `array`.
	     * @example
	     *
	     * var array = [1, 2, 3, 1, 2, 3];
	     * _.pull(array, 2, 3);
	     * console.log(array);
	     * // => [1, 1]
	     */
	    function pull(array) {
	      var args = arguments,
	          argsIndex = 0,
	          argsLength = args.length,
	          length = array ? array.length : 0;

	      while (++argsIndex < argsLength) {
	        var index = -1,
	            value = args[argsIndex];
	        while (++index < length) {
	          if (array[index] === value) {
	            splice.call(array, index--, 1);
	            length--;
	          }
	        }
	      }
	      return array;
	    }

	    /**
	     * Creates an array of numbers (positive and/or negative) progressing from
	     * `start` up to but not including `end`. If `start` is less than `stop` a
	     * zero-length range is created unless a negative `step` is specified.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {number} [start=0] The start of the range.
	     * @param {number} end The end of the range.
	     * @param {number} [step=1] The value to increment or decrement by.
	     * @returns {Array} Returns a new range array.
	     * @example
	     *
	     * _.range(4);
	     * // => [0, 1, 2, 3]
	     *
	     * _.range(1, 5);
	     * // => [1, 2, 3, 4]
	     *
	     * _.range(0, 20, 5);
	     * // => [0, 5, 10, 15]
	     *
	     * _.range(0, -4, -1);
	     * // => [0, -1, -2, -3]
	     *
	     * _.range(1, 4, 0);
	     * // => [1, 1, 1]
	     *
	     * _.range(0);
	     * // => []
	     */
	    function range(start, end, step) {
	      start = +start || 0;
	      step = typeof step == 'number' ? step : (+step || 1);

	      if (end == null) {
	        end = start;
	        start = 0;
	      }
	      // use `Array(length)` so engines like Chakra and V8 avoid slower modes
	      // http://youtu.be/XAqIpGU8ZZk#t=17m25s
	      var index = -1,
	          length = nativeMax(0, ceil((end - start) / (step || 1))),
	          result = Array(length);

	      while (++index < length) {
	        result[index] = start;
	        start += step;
	      }
	      return result;
	    }

	    /**
	     * Removes all elements from an array that the callback returns truey for
	     * and returns an array of removed elements. The callback is bound to `thisArg`
	     * and invoked with three arguments; (value, index, array).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to modify.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a new array of removed elements.
	     * @example
	     *
	     * var array = [1, 2, 3, 4, 5, 6];
	     * var evens = _.remove(array, function(num) { return num % 2 == 0; });
	     *
	     * console.log(array);
	     * // => [1, 3, 5]
	     *
	     * console.log(evens);
	     * // => [2, 4, 6]
	     */
	    function remove(array, callback, thisArg) {
	      var index = -1,
	          length = array ? array.length : 0,
	          result = [];

	      callback = lodash.createCallback(callback, thisArg, 3);
	      while (++index < length) {
	        var value = array[index];
	        if (callback(value, index, array)) {
	          result.push(value);
	          splice.call(array, index--, 1);
	          length--;
	        }
	      }
	      return result;
	    }

	    /**
	     * The opposite of `_.initial` this method gets all but the first element or
	     * first `n` elements of an array. If a callback function is provided elements
	     * at the beginning of the array are excluded from the result as long as the
	     * callback returns truey. The callback is bound to `thisArg` and invoked
	     * with three arguments; (value, index, array).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @alias drop, tail
	     * @category Arrays
	     * @param {Array} array The array to query.
	     * @param {Function|Object|number|string} [callback=1] The function called
	     *  per element or the number of elements to exclude. If a property name or
	     *  object is provided it will be used to create a "_.pluck" or "_.where"
	     *  style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a slice of `array`.
	     * @example
	     *
	     * _.rest([1, 2, 3]);
	     * // => [2, 3]
	     *
	     * _.rest([1, 2, 3], 2);
	     * // => [3]
	     *
	     * _.rest([1, 2, 3], function(num) {
	     *   return num < 3;
	     * });
	     * // => [3]
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'blocked': true,  'employer': 'slate' },
	     *   { 'name': 'fred',    'blocked': false,  'employer': 'slate' },
	     *   { 'name': 'pebbles', 'blocked': true, 'employer': 'na' }
	     * ];
	     *
	     * // using "_.pluck" callback shorthand
	     * _.pluck(_.rest(characters, 'blocked'), 'name');
	     * // => ['fred', 'pebbles']
	     *
	     * // using "_.where" callback shorthand
	     * _.rest(characters, { 'employer': 'slate' });
	     * // => [{ 'name': 'pebbles', 'blocked': true, 'employer': 'na' }]
	     */
	    function rest(array, callback, thisArg) {
	      if (typeof callback != 'number' && callback != null) {
	        var n = 0,
	            index = -1,
	            length = array ? array.length : 0;

	        callback = lodash.createCallback(callback, thisArg, 3);
	        while (++index < length && callback(array[index], index, array)) {
	          n++;
	        }
	      } else {
	        n = (callback == null || thisArg) ? 1 : nativeMax(0, callback);
	      }
	      return slice(array, n);
	    }

	    /**
	     * Uses a binary search to determine the smallest index at which a value
	     * should be inserted into a given sorted array in order to maintain the sort
	     * order of the array. If a callback is provided it will be executed for
	     * `value` and each element of `array` to compute their sort ranking. The
	     * callback is bound to `thisArg` and invoked with one argument; (value).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to inspect.
	     * @param {*} value The value to evaluate.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {number} Returns the index at which `value` should be inserted
	     *  into `array`.
	     * @example
	     *
	     * _.sortedIndex([20, 30, 50], 40);
	     * // => 2
	     *
	     * // using "_.pluck" callback shorthand
	     * _.sortedIndex([{ 'x': 20 }, { 'x': 30 }, { 'x': 50 }], { 'x': 40 }, 'x');
	     * // => 2
	     *
	     * var dict = {
	     *   'wordToNumber': { 'twenty': 20, 'thirty': 30, 'fourty': 40, 'fifty': 50 }
	     * };
	     *
	     * _.sortedIndex(['twenty', 'thirty', 'fifty'], 'fourty', function(word) {
	     *   return dict.wordToNumber[word];
	     * });
	     * // => 2
	     *
	     * _.sortedIndex(['twenty', 'thirty', 'fifty'], 'fourty', function(word) {
	     *   return this.wordToNumber[word];
	     * }, dict);
	     * // => 2
	     */
	    function sortedIndex(array, value, callback, thisArg) {
	      var low = 0,
	          high = array ? array.length : low;

	      // explicitly reference `identity` for better inlining in Firefox
	      callback = callback ? lodash.createCallback(callback, thisArg, 1) : identity;
	      value = callback(value);

	      while (low < high) {
	        var mid = (low + high) >>> 1;
	        (callback(array[mid]) < value)
	          ? low = mid + 1
	          : high = mid;
	      }
	      return low;
	    }

	    /**
	     * Creates an array of unique values, in order, of the provided arrays using
	     * strict equality for comparisons, i.e. `===`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {...Array} [array] The arrays to inspect.
	     * @returns {Array} Returns an array of combined values.
	     * @example
	     *
	     * _.union([1, 2, 3], [5, 2, 1, 4], [2, 1]);
	     * // => [1, 2, 3, 5, 4]
	     */
	    function union() {
	      return baseUniq(baseFlatten(arguments, true, true));
	    }

	    /**
	     * Creates a duplicate-value-free version of an array using strict equality
	     * for comparisons, i.e. `===`. If the array is sorted, providing
	     * `true` for `isSorted` will use a faster algorithm. If a callback is provided
	     * each element of `array` is passed through the callback before uniqueness
	     * is computed. The callback is bound to `thisArg` and invoked with three
	     * arguments; (value, index, array).
	     *
	     * If a property name is provided for `callback` the created "_.pluck" style
	     * callback will return the property value of the given element.
	     *
	     * If an object is provided for `callback` the created "_.where" style callback
	     * will return `true` for elements that have the properties of the given object,
	     * else `false`.
	     *
	     * @static
	     * @memberOf _
	     * @alias unique
	     * @category Arrays
	     * @param {Array} array The array to process.
	     * @param {boolean} [isSorted=false] A flag to indicate that `array` is sorted.
	     * @param {Function|Object|string} [callback=identity] The function called
	     *  per iteration. If a property name or object is provided it will be used
	     *  to create a "_.pluck" or "_.where" style callback, respectively.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns a duplicate-value-free array.
	     * @example
	     *
	     * _.uniq([1, 2, 1, 3, 1]);
	     * // => [1, 2, 3]
	     *
	     * _.uniq([1, 1, 2, 2, 3], true);
	     * // => [1, 2, 3]
	     *
	     * _.uniq(['A', 'b', 'C', 'a', 'B', 'c'], function(letter) { return letter.toLowerCase(); });
	     * // => ['A', 'b', 'C']
	     *
	     * _.uniq([1, 2.5, 3, 1.5, 2, 3.5], function(num) { return this.floor(num); }, Math);
	     * // => [1, 2.5, 3]
	     *
	     * // using "_.pluck" callback shorthand
	     * _.uniq([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
	     * // => [{ 'x': 1 }, { 'x': 2 }]
	     */
	    function uniq(array, isSorted, callback, thisArg) {
	      // juggle arguments
	      if (typeof isSorted != 'boolean' && isSorted != null) {
	        thisArg = callback;
	        callback = (typeof isSorted != 'function' && thisArg && thisArg[isSorted] === array) ? null : isSorted;
	        isSorted = false;
	      }
	      if (callback != null) {
	        callback = lodash.createCallback(callback, thisArg, 3);
	      }
	      return baseUniq(array, isSorted, callback);
	    }

	    /**
	     * Creates an array excluding all provided values using strict equality for
	     * comparisons, i.e. `===`.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {Array} array The array to filter.
	     * @param {...*} [value] The values to exclude.
	     * @returns {Array} Returns a new array of filtered values.
	     * @example
	     *
	     * _.without([1, 2, 1, 0, 3, 1, 4], 0, 1);
	     * // => [2, 3, 4]
	     */
	    function without(array) {
	      return baseDifference(array, slice(arguments, 1));
	    }

	    /**
	     * Creates an array that is the symmetric difference of the provided arrays.
	     * See http://en.wikipedia.org/wiki/Symmetric_difference.
	     *
	     * @static
	     * @memberOf _
	     * @category Arrays
	     * @param {...Array} [array] The arrays to inspect.
	     * @returns {Array} Returns an array of values.
	     * @example
	     *
	     * _.xor([1, 2, 3], [5, 2, 1, 4]);
	     * // => [3, 5, 4]
	     *
	     * _.xor([1, 2, 5], [2, 3, 5], [3, 4, 5]);
	     * // => [1, 4, 5]
	     */
	    function xor() {
	      var index = -1,
	          length = arguments.length;

	      while (++index < length) {
	        var array = arguments[index];
	        if (isArray(array) || isArguments(array)) {
	          var result = result
	            ? baseUniq(baseDifference(result, array).concat(baseDifference(array, result)))
	            : array;
	        }
	      }
	      return result || [];
	    }

	    /**
	     * Creates an array of grouped elements, the first of which contains the first
	     * elements of the given arrays, the second of which contains the second
	     * elements of the given arrays, and so on.
	     *
	     * @static
	     * @memberOf _
	     * @alias unzip
	     * @category Arrays
	     * @param {...Array} [array] Arrays to process.
	     * @returns {Array} Returns a new array of grouped elements.
	     * @example
	     *
	     * _.zip(['fred', 'barney'], [30, 40], [true, false]);
	     * // => [['fred', 30, true], ['barney', 40, false]]
	     */
	    function zip() {
	      var array = arguments.length > 1 ? arguments : arguments[0],
	          index = -1,
	          length = array ? max(pluck(array, 'length')) : 0,
	          result = Array(length < 0 ? 0 : length);

	      while (++index < length) {
	        result[index] = pluck(array, index);
	      }
	      return result;
	    }

	    /**
	     * Creates an object composed from arrays of `keys` and `values`. Provide
	     * either a single two dimensional array, i.e. `[[key1, value1], [key2, value2]]`
	     * or two arrays, one of `keys` and one of corresponding `values`.
	     *
	     * @static
	     * @memberOf _
	     * @alias object
	     * @category Arrays
	     * @param {Array} keys The array of keys.
	     * @param {Array} [values=[]] The array of values.
	     * @returns {Object} Returns an object composed of the given keys and
	     *  corresponding values.
	     * @example
	     *
	     * _.zipObject(['fred', 'barney'], [30, 40]);
	     * // => { 'fred': 30, 'barney': 40 }
	     */
	    function zipObject(keys, values) {
	      var index = -1,
	          length = keys ? keys.length : 0,
	          result = {};

	      if (!values && length && !isArray(keys[0])) {
	        values = [];
	      }
	      while (++index < length) {
	        var key = keys[index];
	        if (values) {
	          result[key] = values[index];
	        } else if (key) {
	          result[key[0]] = key[1];
	        }
	      }
	      return result;
	    }

	    /*--------------------------------------------------------------------------*/

	    /**
	     * Creates a function that executes `func`, with  the `this` binding and
	     * arguments of the created function, only after being called `n` times.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {number} n The number of times the function must be called before
	     *  `func` is executed.
	     * @param {Function} func The function to restrict.
	     * @returns {Function} Returns the new restricted function.
	     * @example
	     *
	     * var saves = ['profile', 'settings'];
	     *
	     * var done = _.after(saves.length, function() {
	     *   console.log('Done saving!');
	     * });
	     *
	     * _.forEach(saves, function(type) {
	     *   asyncSave({ 'type': type, 'complete': done });
	     * });
	     * // => logs 'Done saving!', after all saves have completed
	     */
	    function after(n, func) {
	      if (!isFunction(func)) {
	        throw new TypeError;
	      }
	      return function() {
	        if (--n < 1) {
	          return func.apply(this, arguments);
	        }
	      };
	    }

	    /**
	     * Creates a function that, when called, invokes `func` with the `this`
	     * binding of `thisArg` and prepends any additional `bind` arguments to those
	     * provided to the bound function.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to bind.
	     * @param {*} [thisArg] The `this` binding of `func`.
	     * @param {...*} [arg] Arguments to be partially applied.
	     * @returns {Function} Returns the new bound function.
	     * @example
	     *
	     * var func = function(greeting) {
	     *   return greeting + ' ' + this.name;
	     * };
	     *
	     * func = _.bind(func, { 'name': 'fred' }, 'hi');
	     * func();
	     * // => 'hi fred'
	     */
	    function bind(func, thisArg) {
	      return arguments.length > 2
	        ? createWrapper(func, 17, slice(arguments, 2), null, thisArg)
	        : createWrapper(func, 1, null, null, thisArg);
	    }

	    /**
	     * Binds methods of an object to the object itself, overwriting the existing
	     * method. Method names may be specified as individual arguments or as arrays
	     * of method names. If no method names are provided all the function properties
	     * of `object` will be bound.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Object} object The object to bind and assign the bound methods to.
	     * @param {...string} [methodName] The object method names to
	     *  bind, specified as individual method names or arrays of method names.
	     * @returns {Object} Returns `object`.
	     * @example
	     *
	     * var view = {
	     *   'label': 'docs',
	     *   'onClick': function() { console.log('clicked ' + this.label); }
	     * };
	     *
	     * _.bindAll(view);
	     * jQuery('#docs').on('click', view.onClick);
	     * // => logs 'clicked docs', when the button is clicked
	     */
	    function bindAll(object) {
	      var funcs = arguments.length > 1 ? baseFlatten(arguments, true, false, 1) : functions(object),
	          index = -1,
	          length = funcs.length;

	      while (++index < length) {
	        var key = funcs[index];
	        object[key] = createWrapper(object[key], 1, null, null, object);
	      }
	      return object;
	    }

	    /**
	     * Creates a function that, when called, invokes the method at `object[key]`
	     * and prepends any additional `bindKey` arguments to those provided to the bound
	     * function. This method differs from `_.bind` by allowing bound functions to
	     * reference methods that will be redefined or don't yet exist.
	     * See http://michaux.ca/articles/lazy-function-definition-pattern.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Object} object The object the method belongs to.
	     * @param {string} key The key of the method.
	     * @param {...*} [arg] Arguments to be partially applied.
	     * @returns {Function} Returns the new bound function.
	     * @example
	     *
	     * var object = {
	     *   'name': 'fred',
	     *   'greet': function(greeting) {
	     *     return greeting + ' ' + this.name;
	     *   }
	     * };
	     *
	     * var func = _.bindKey(object, 'greet', 'hi');
	     * func();
	     * // => 'hi fred'
	     *
	     * object.greet = function(greeting) {
	     *   return greeting + 'ya ' + this.name + '!';
	     * };
	     *
	     * func();
	     * // => 'hiya fred!'
	     */
	    function bindKey(object, key) {
	      return arguments.length > 2
	        ? createWrapper(key, 19, slice(arguments, 2), null, object)
	        : createWrapper(key, 3, null, null, object);
	    }

	    /**
	     * Creates a function that is the composition of the provided functions,
	     * where each function consumes the return value of the function that follows.
	     * For example, composing the functions `f()`, `g()`, and `h()` produces `f(g(h()))`.
	     * Each function is executed with the `this` binding of the composed function.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {...Function} [func] Functions to compose.
	     * @returns {Function} Returns the new composed function.
	     * @example
	     *
	     * var realNameMap = {
	     *   'pebbles': 'penelope'
	     * };
	     *
	     * var format = function(name) {
	     *   name = realNameMap[name.toLowerCase()] || name;
	     *   return name.charAt(0).toUpperCase() + name.slice(1).toLowerCase();
	     * };
	     *
	     * var greet = function(formatted) {
	     *   return 'Hiya ' + formatted + '!';
	     * };
	     *
	     * var welcome = _.compose(greet, format);
	     * welcome('pebbles');
	     * // => 'Hiya Penelope!'
	     */
	    function compose() {
	      var funcs = arguments,
	          length = funcs.length;

	      while (length--) {
	        if (!isFunction(funcs[length])) {
	          throw new TypeError;
	        }
	      }
	      return function() {
	        var args = arguments,
	            length = funcs.length;

	        while (length--) {
	          args = [funcs[length].apply(this, args)];
	        }
	        return args[0];
	      };
	    }

	    /**
	     * Creates a function which accepts one or more arguments of `func` that when
	     * invoked either executes `func` returning its result, if all `func` arguments
	     * have been provided, or returns a function that accepts one or more of the
	     * remaining `func` arguments, and so on. The arity of `func` can be specified
	     * if `func.length` is not sufficient.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to curry.
	     * @param {number} [arity=func.length] The arity of `func`.
	     * @returns {Function} Returns the new curried function.
	     * @example
	     *
	     * var curried = _.curry(function(a, b, c) {
	     *   console.log(a + b + c);
	     * });
	     *
	     * curried(1)(2)(3);
	     * // => 6
	     *
	     * curried(1, 2)(3);
	     * // => 6
	     *
	     * curried(1, 2, 3);
	     * // => 6
	     */
	    function curry(func, arity) {
	      arity = typeof arity == 'number' ? arity : (+arity || func.length);
	      return createWrapper(func, 4, null, null, null, arity);
	    }

	    /**
	     * Creates a function that will delay the execution of `func` until after
	     * `wait` milliseconds have elapsed since the last time it was invoked.
	     * Provide an options object to indicate that `func` should be invoked on
	     * the leading and/or trailing edge of the `wait` timeout. Subsequent calls
	     * to the debounced function will return the result of the last `func` call.
	     *
	     * Note: If `leading` and `trailing` options are `true` `func` will be called
	     * on the trailing edge of the timeout only if the the debounced function is
	     * invoked more than once during the `wait` timeout.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to debounce.
	     * @param {number} wait The number of milliseconds to delay.
	     * @param {Object} [options] The options object.
	     * @param {boolean} [options.leading=false] Specify execution on the leading edge of the timeout.
	     * @param {number} [options.maxWait] The maximum time `func` is allowed to be delayed before it's called.
	     * @param {boolean} [options.trailing=true] Specify execution on the trailing edge of the timeout.
	     * @returns {Function} Returns the new debounced function.
	     * @example
	     *
	     * // avoid costly calculations while the window size is in flux
	     * var lazyLayout = _.debounce(calculateLayout, 150);
	     * jQuery(window).on('resize', lazyLayout);
	     *
	     * // execute `sendMail` when the click event is fired, debouncing subsequent calls
	     * jQuery('#postbox').on('click', _.debounce(sendMail, 300, {
	     *   'leading': true,
	     *   'trailing': false
	     * });
	     *
	     * // ensure `batchLog` is executed once after 1 second of debounced calls
	     * var source = new EventSource('/stream');
	     * source.addEventListener('message', _.debounce(batchLog, 250, {
	     *   'maxWait': 1000
	     * }, false);
	     */
	    function debounce(func, wait, options) {
	      var args,
	          maxTimeoutId,
	          result,
	          stamp,
	          thisArg,
	          timeoutId,
	          trailingCall,
	          lastCalled = 0,
	          maxWait = false,
	          trailing = true;

	      if (!isFunction(func)) {
	        throw new TypeError;
	      }
	      wait = nativeMax(0, wait) || 0;
	      if (options === true) {
	        var leading = true;
	        trailing = false;
	      } else if (isObject(options)) {
	        leading = options.leading;
	        maxWait = 'maxWait' in options && (nativeMax(wait, options.maxWait) || 0);
	        trailing = 'trailing' in options ? options.trailing : trailing;
	      }
	      var delayed = function() {
	        var remaining = wait - (now() - stamp);
	        if (remaining <= 0) {
	          if (maxTimeoutId) {
	            clearTimeout(maxTimeoutId);
	          }
	          var isCalled = trailingCall;
	          maxTimeoutId = timeoutId = trailingCall = undefined;
	          if (isCalled) {
	            lastCalled = now();
	            result = func.apply(thisArg, args);
	            if (!timeoutId && !maxTimeoutId) {
	              args = thisArg = null;
	            }
	          }
	        } else {
	          timeoutId = setTimeout(delayed, remaining);
	        }
	      };

	      var maxDelayed = function() {
	        if (timeoutId) {
	          clearTimeout(timeoutId);
	        }
	        maxTimeoutId = timeoutId = trailingCall = undefined;
	        if (trailing || (maxWait !== wait)) {
	          lastCalled = now();
	          result = func.apply(thisArg, args);
	          if (!timeoutId && !maxTimeoutId) {
	            args = thisArg = null;
	          }
	        }
	      };

	      return function() {
	        args = arguments;
	        stamp = now();
	        thisArg = this;
	        trailingCall = trailing && (timeoutId || !leading);

	        if (maxWait === false) {
	          var leadingCall = leading && !timeoutId;
	        } else {
	          if (!maxTimeoutId && !leading) {
	            lastCalled = stamp;
	          }
	          var remaining = maxWait - (stamp - lastCalled),
	              isCalled = remaining <= 0;

	          if (isCalled) {
	            if (maxTimeoutId) {
	              maxTimeoutId = clearTimeout(maxTimeoutId);
	            }
	            lastCalled = stamp;
	            result = func.apply(thisArg, args);
	          }
	          else if (!maxTimeoutId) {
	            maxTimeoutId = setTimeout(maxDelayed, remaining);
	          }
	        }
	        if (isCalled && timeoutId) {
	          timeoutId = clearTimeout(timeoutId);
	        }
	        else if (!timeoutId && wait !== maxWait) {
	          timeoutId = setTimeout(delayed, wait);
	        }
	        if (leadingCall) {
	          isCalled = true;
	          result = func.apply(thisArg, args);
	        }
	        if (isCalled && !timeoutId && !maxTimeoutId) {
	          args = thisArg = null;
	        }
	        return result;
	      };
	    }

	    /**
	     * Defers executing the `func` function until the current call stack has cleared.
	     * Additional arguments will be provided to `func` when it is invoked.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to defer.
	     * @param {...*} [arg] Arguments to invoke the function with.
	     * @returns {number} Returns the timer id.
	     * @example
	     *
	     * _.defer(function(text) { console.log(text); }, 'deferred');
	     * // logs 'deferred' after one or more milliseconds
	     */
	    function defer(func) {
	      if (!isFunction(func)) {
	        throw new TypeError;
	      }
	      var args = slice(arguments, 1);
	      return setTimeout(function() { func.apply(undefined, args); }, 1);
	    }

	    /**
	     * Executes the `func` function after `wait` milliseconds. Additional arguments
	     * will be provided to `func` when it is invoked.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to delay.
	     * @param {number} wait The number of milliseconds to delay execution.
	     * @param {...*} [arg] Arguments to invoke the function with.
	     * @returns {number} Returns the timer id.
	     * @example
	     *
	     * _.delay(function(text) { console.log(text); }, 1000, 'later');
	     * // => logs 'later' after one second
	     */
	    function delay(func, wait) {
	      if (!isFunction(func)) {
	        throw new TypeError;
	      }
	      var args = slice(arguments, 2);
	      return setTimeout(function() { func.apply(undefined, args); }, wait);
	    }

	    /**
	     * Creates a function that memoizes the result of `func`. If `resolver` is
	     * provided it will be used to determine the cache key for storing the result
	     * based on the arguments provided to the memoized function. By default, the
	     * first argument provided to the memoized function is used as the cache key.
	     * The `func` is executed with the `this` binding of the memoized function.
	     * The result cache is exposed as the `cache` property on the memoized function.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to have its output memoized.
	     * @param {Function} [resolver] A function used to resolve the cache key.
	     * @returns {Function} Returns the new memoizing function.
	     * @example
	     *
	     * var fibonacci = _.memoize(function(n) {
	     *   return n < 2 ? n : fibonacci(n - 1) + fibonacci(n - 2);
	     * });
	     *
	     * fibonacci(9)
	     * // => 34
	     *
	     * var data = {
	     *   'fred': { 'name': 'fred', 'age': 40 },
	     *   'pebbles': { 'name': 'pebbles', 'age': 1 }
	     * };
	     *
	     * // modifying the result cache
	     * var get = _.memoize(function(name) { return data[name]; }, _.identity);
	     * get('pebbles');
	     * // => { 'name': 'pebbles', 'age': 1 }
	     *
	     * get.cache.pebbles.name = 'penelope';
	     * get('pebbles');
	     * // => { 'name': 'penelope', 'age': 1 }
	     */
	    function memoize(func, resolver) {
	      if (!isFunction(func)) {
	        throw new TypeError;
	      }
	      var memoized = function() {
	        var cache = memoized.cache,
	            key = resolver ? resolver.apply(this, arguments) : keyPrefix + arguments[0];

	        return hasOwnProperty.call(cache, key)
	          ? cache[key]
	          : (cache[key] = func.apply(this, arguments));
	      }
	      memoized.cache = {};
	      return memoized;
	    }

	    /**
	     * Creates a function that is restricted to execute `func` once. Repeat calls to
	     * the function will return the value of the first call. The `func` is executed
	     * with the `this` binding of the created function.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to restrict.
	     * @returns {Function} Returns the new restricted function.
	     * @example
	     *
	     * var initialize = _.once(createApplication);
	     * initialize();
	     * initialize();
	     * // `initialize` executes `createApplication` once
	     */
	    function once(func) {
	      var ran,
	          result;

	      if (!isFunction(func)) {
	        throw new TypeError;
	      }
	      return function() {
	        if (ran) {
	          return result;
	        }
	        ran = true;
	        result = func.apply(this, arguments);

	        // clear the `func` variable so the function may be garbage collected
	        func = null;
	        return result;
	      };
	    }

	    /**
	     * Creates a function that, when called, invokes `func` with any additional
	     * `partial` arguments prepended to those provided to the new function. This
	     * method is similar to `_.bind` except it does **not** alter the `this` binding.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to partially apply arguments to.
	     * @param {...*} [arg] Arguments to be partially applied.
	     * @returns {Function} Returns the new partially applied function.
	     * @example
	     *
	     * var greet = function(greeting, name) { return greeting + ' ' + name; };
	     * var hi = _.partial(greet, 'hi');
	     * hi('fred');
	     * // => 'hi fred'
	     */
	    function partial(func) {
	      return createWrapper(func, 16, slice(arguments, 1));
	    }

	    /**
	     * This method is like `_.partial` except that `partial` arguments are
	     * appended to those provided to the new function.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to partially apply arguments to.
	     * @param {...*} [arg] Arguments to be partially applied.
	     * @returns {Function} Returns the new partially applied function.
	     * @example
	     *
	     * var defaultsDeep = _.partialRight(_.merge, _.defaults);
	     *
	     * var options = {
	     *   'variable': 'data',
	     *   'imports': { 'jq': $ }
	     * };
	     *
	     * defaultsDeep(options, _.templateSettings);
	     *
	     * options.variable
	     * // => 'data'
	     *
	     * options.imports
	     * // => { '_': _, 'jq': $ }
	     */
	    function partialRight(func) {
	      return createWrapper(func, 32, null, slice(arguments, 1));
	    }

	    /**
	     * Creates a function that, when executed, will only call the `func` function
	     * at most once per every `wait` milliseconds. Provide an options object to
	     * indicate that `func` should be invoked on the leading and/or trailing edge
	     * of the `wait` timeout. Subsequent calls to the throttled function will
	     * return the result of the last `func` call.
	     *
	     * Note: If `leading` and `trailing` options are `true` `func` will be called
	     * on the trailing edge of the timeout only if the the throttled function is
	     * invoked more than once during the `wait` timeout.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {Function} func The function to throttle.
	     * @param {number} wait The number of milliseconds to throttle executions to.
	     * @param {Object} [options] The options object.
	     * @param {boolean} [options.leading=true] Specify execution on the leading edge of the timeout.
	     * @param {boolean} [options.trailing=true] Specify execution on the trailing edge of the timeout.
	     * @returns {Function} Returns the new throttled function.
	     * @example
	     *
	     * // avoid excessively updating the position while scrolling
	     * var throttled = _.throttle(updatePosition, 100);
	     * jQuery(window).on('scroll', throttled);
	     *
	     * // execute `renewToken` when the click event is fired, but not more than once every 5 minutes
	     * jQuery('.interactive').on('click', _.throttle(renewToken, 300000, {
	     *   'trailing': false
	     * }));
	     */
	    function throttle(func, wait, options) {
	      var leading = true,
	          trailing = true;

	      if (!isFunction(func)) {
	        throw new TypeError;
	      }
	      if (options === false) {
	        leading = false;
	      } else if (isObject(options)) {
	        leading = 'leading' in options ? options.leading : leading;
	        trailing = 'trailing' in options ? options.trailing : trailing;
	      }
	      debounceOptions.leading = leading;
	      debounceOptions.maxWait = wait;
	      debounceOptions.trailing = trailing;

	      return debounce(func, wait, debounceOptions);
	    }

	    /**
	     * Creates a function that provides `value` to the wrapper function as its
	     * first argument. Additional arguments provided to the function are appended
	     * to those provided to the wrapper function. The wrapper is executed with
	     * the `this` binding of the created function.
	     *
	     * @static
	     * @memberOf _
	     * @category Functions
	     * @param {*} value The value to wrap.
	     * @param {Function} wrapper The wrapper function.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var p = _.wrap(_.escape, function(func, text) {
	     *   return '<p>' + func(text) + '</p>';
	     * });
	     *
	     * p('Fred, Wilma, & Pebbles');
	     * // => '<p>Fred, Wilma, &amp; Pebbles</p>'
	     */
	    function wrap(value, wrapper) {
	      return createWrapper(wrapper, 16, [value]);
	    }

	    /*--------------------------------------------------------------------------*/

	    /**
	     * Creates a function that returns `value`.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {*} value The value to return from the new function.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var object = { 'name': 'fred' };
	     * var getter = _.constant(object);
	     * getter() === object;
	     * // => true
	     */
	    function constant(value) {
	      return function() {
	        return value;
	      };
	    }

	    /**
	     * Produces a callback bound to an optional `thisArg`. If `func` is a property
	     * name the created callback will return the property value for a given element.
	     * If `func` is an object the created callback will return `true` for elements
	     * that contain the equivalent object properties, otherwise it will return `false`.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {*} [func=identity] The value to convert to a callback.
	     * @param {*} [thisArg] The `this` binding of the created callback.
	     * @param {number} [argCount] The number of arguments the callback accepts.
	     * @returns {Function} Returns a callback function.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * // wrap to create custom callback shorthands
	     * _.createCallback = _.wrap(_.createCallback, function(func, callback, thisArg) {
	     *   var match = /^(.+?)__([gl]t)(.+)$/.exec(callback);
	     *   return !match ? func(callback, thisArg) : function(object) {
	     *     return match[2] == 'gt' ? object[match[1]] > match[3] : object[match[1]] < match[3];
	     *   };
	     * });
	     *
	     * _.filter(characters, 'age__gt38');
	     * // => [{ 'name': 'fred', 'age': 40 }]
	     */
	    function createCallback(func, thisArg, argCount) {
	      var type = typeof func;
	      if (func == null || type == 'function') {
	        return baseCreateCallback(func, thisArg, argCount);
	      }
	      // handle "_.pluck" style callback shorthands
	      if (type != 'object') {
	        return property(func);
	      }
	      var props = keys(func),
	          key = props[0],
	          a = func[key];

	      // handle "_.where" style callback shorthands
	      if (props.length == 1 && a === a && !isObject(a)) {
	        // fast path the common case of providing an object with a single
	        // property containing a primitive value
	        return function(object) {
	          var b = object[key];
	          return a === b && (a !== 0 || (1 / a == 1 / b));
	        };
	      }
	      return function(object) {
	        var length = props.length,
	            result = false;

	        while (length--) {
	          if (!(result = baseIsEqual(object[props[length]], func[props[length]], null, true))) {
	            break;
	          }
	        }
	        return result;
	      };
	    }

	    /**
	     * Converts the characters `&`, `<`, `>`, `"`, and `'` in `string` to their
	     * corresponding HTML entities.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {string} string The string to escape.
	     * @returns {string} Returns the escaped string.
	     * @example
	     *
	     * _.escape('Fred, Wilma, & Pebbles');
	     * // => 'Fred, Wilma, &amp; Pebbles'
	     */
	    function escape(string) {
	      return string == null ? '' : String(string).replace(reUnescapedHtml, escapeHtmlChar);
	    }

	    /**
	     * This method returns the first argument provided to it.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {*} value Any value.
	     * @returns {*} Returns `value`.
	     * @example
	     *
	     * var object = { 'name': 'fred' };
	     * _.identity(object) === object;
	     * // => true
	     */
	    function identity(value) {
	      return value;
	    }

	    /**
	     * Adds function properties of a source object to the destination object.
	     * If `object` is a function methods will be added to its prototype as well.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {Function|Object} [object=lodash] object The destination object.
	     * @param {Object} source The object of functions to add.
	     * @param {Object} [options] The options object.
	     * @param {boolean} [options.chain=true] Specify whether the functions added are chainable.
	     * @example
	     *
	     * function capitalize(string) {
	     *   return string.charAt(0).toUpperCase() + string.slice(1).toLowerCase();
	     * }
	     *
	     * _.mixin({ 'capitalize': capitalize });
	     * _.capitalize('fred');
	     * // => 'Fred'
	     *
	     * _('fred').capitalize().value();
	     * // => 'Fred'
	     *
	     * _.mixin({ 'capitalize': capitalize }, { 'chain': false });
	     * _('fred').capitalize();
	     * // => 'Fred'
	     */
	    function mixin(object, source, options) {
	      var chain = true,
	          methodNames = source && functions(source);

	      if (!source || (!options && !methodNames.length)) {
	        if (options == null) {
	          options = source;
	        }
	        ctor = lodashWrapper;
	        source = object;
	        object = lodash;
	        methodNames = functions(source);
	      }
	      if (options === false) {
	        chain = false;
	      } else if (isObject(options) && 'chain' in options) {
	        chain = options.chain;
	      }
	      var ctor = object,
	          isFunc = isFunction(ctor);

	      forEach(methodNames, function(methodName) {
	        var func = object[methodName] = source[methodName];
	        if (isFunc) {
	          ctor.prototype[methodName] = function() {
	            var chainAll = this.__chain__,
	                value = this.__wrapped__,
	                args = [value];

	            push.apply(args, arguments);
	            var result = func.apply(object, args);
	            if (chain || chainAll) {
	              if (value === result && isObject(result)) {
	                return this;
	              }
	              result = new ctor(result);
	              result.__chain__ = chainAll;
	            }
	            return result;
	          };
	        }
	      });
	    }

	    /**
	     * Reverts the '_' variable to its previous value and returns a reference to
	     * the `lodash` function.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @returns {Function} Returns the `lodash` function.
	     * @example
	     *
	     * var lodash = _.noConflict();
	     */
	    function noConflict() {
	      context._ = oldDash;
	      return this;
	    }

	    /**
	     * A no-operation function.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @example
	     *
	     * var object = { 'name': 'fred' };
	     * _.noop(object) === undefined;
	     * // => true
	     */
	    function noop() {
	      // no operation performed
	    }

	    /**
	     * Gets the number of milliseconds that have elapsed since the Unix epoch
	     * (1 January 1970 00:00:00 UTC).
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @example
	     *
	     * var stamp = _.now();
	     * _.defer(function() { console.log(_.now() - stamp); });
	     * // => logs the number of milliseconds it took for the deferred function to be called
	     */
	    var now = isNative(now = Date.now) && now || function() {
	      return new Date().getTime();
	    };

	    /**
	     * Converts the given value into an integer of the specified radix.
	     * If `radix` is `undefined` or `0` a `radix` of `10` is used unless the
	     * `value` is a hexadecimal, in which case a `radix` of `16` is used.
	     *
	     * Note: This method avoids differences in native ES3 and ES5 `parseInt`
	     * implementations. See http://es5.github.io/#E.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {string} value The value to parse.
	     * @param {number} [radix] The radix used to interpret the value to parse.
	     * @returns {number} Returns the new integer value.
	     * @example
	     *
	     * _.parseInt('08');
	     * // => 8
	     */
	    var parseInt = nativeParseInt(whitespace + '08') == 8 ? nativeParseInt : function(value, radix) {
	      // Firefox < 21 and Opera < 15 follow the ES3 specified implementation of `parseInt`
	      return nativeParseInt(isString(value) ? value.replace(reLeadingSpacesAndZeros, '') : value, radix || 0);
	    };

	    /**
	     * Creates a "_.pluck" style function, which returns the `key` value of a
	     * given object.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {string} key The name of the property to retrieve.
	     * @returns {Function} Returns the new function.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'fred',   'age': 40 },
	     *   { 'name': 'barney', 'age': 36 }
	     * ];
	     *
	     * var getName = _.property('name');
	     *
	     * _.map(characters, getName);
	     * // => ['barney', 'fred']
	     *
	     * _.sortBy(characters, getName);
	     * // => [{ 'name': 'barney', 'age': 36 }, { 'name': 'fred',   'age': 40 }]
	     */
	    function property(key) {
	      return function(object) {
	        return object[key];
	      };
	    }

	    /**
	     * Produces a random number between `min` and `max` (inclusive). If only one
	     * argument is provided a number between `0` and the given number will be
	     * returned. If `floating` is truey or either `min` or `max` are floats a
	     * floating-point number will be returned instead of an integer.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {number} [min=0] The minimum possible value.
	     * @param {number} [max=1] The maximum possible value.
	     * @param {boolean} [floating=false] Specify returning a floating-point number.
	     * @returns {number} Returns a random number.
	     * @example
	     *
	     * _.random(0, 5);
	     * // => an integer between 0 and 5
	     *
	     * _.random(5);
	     * // => also an integer between 0 and 5
	     *
	     * _.random(5, true);
	     * // => a floating-point number between 0 and 5
	     *
	     * _.random(1.2, 5.2);
	     * // => a floating-point number between 1.2 and 5.2
	     */
	    function random(min, max, floating) {
	      var noMin = min == null,
	          noMax = max == null;

	      if (floating == null) {
	        if (typeof min == 'boolean' && noMax) {
	          floating = min;
	          min = 1;
	        }
	        else if (!noMax && typeof max == 'boolean') {
	          floating = max;
	          noMax = true;
	        }
	      }
	      if (noMin && noMax) {
	        max = 1;
	      }
	      min = +min || 0;
	      if (noMax) {
	        max = min;
	        min = 0;
	      } else {
	        max = +max || 0;
	      }
	      if (floating || min % 1 || max % 1) {
	        var rand = nativeRandom();
	        return nativeMin(min + (rand * (max - min + parseFloat('1e-' + ((rand +'').length - 1)))), max);
	      }
	      return baseRandom(min, max);
	    }

	    /**
	     * Resolves the value of property `key` on `object`. If `key` is a function
	     * it will be invoked with the `this` binding of `object` and its result returned,
	     * else the property value is returned. If `object` is falsey then `undefined`
	     * is returned.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {Object} object The object to inspect.
	     * @param {string} key The name of the property to resolve.
	     * @returns {*} Returns the resolved value.
	     * @example
	     *
	     * var object = {
	     *   'cheese': 'crumpets',
	     *   'stuff': function() {
	     *     return 'nonsense';
	     *   }
	     * };
	     *
	     * _.result(object, 'cheese');
	     * // => 'crumpets'
	     *
	     * _.result(object, 'stuff');
	     * // => 'nonsense'
	     */
	    function result(object, key) {
	      if (object) {
	        var value = object[key];
	        return isFunction(value) ? object[key]() : value;
	      }
	    }

	    /**
	     * A micro-templating method that handles arbitrary delimiters, preserves
	     * whitespace, and correctly escapes quotes within interpolated code.
	     *
	     * Note: In the development build, `_.template` utilizes sourceURLs for easier
	     * debugging. See http://www.html5rocks.com/en/tutorials/developertools/sourcemaps/#toc-sourceurl
	     *
	     * For more information on precompiling templates see:
	     * https://lodash.com/custom-builds
	     *
	     * For more information on Chrome extension sandboxes see:
	     * http://developer.chrome.com/stable/extensions/sandboxingEval.html
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {string} text The template text.
	     * @param {Object} data The data object used to populate the text.
	     * @param {Object} [options] The options object.
	     * @param {RegExp} [options.escape] The "escape" delimiter.
	     * @param {RegExp} [options.evaluate] The "evaluate" delimiter.
	     * @param {Object} [options.imports] An object to import into the template as local variables.
	     * @param {RegExp} [options.interpolate] The "interpolate" delimiter.
	     * @param {string} [sourceURL] The sourceURL of the template's compiled source.
	     * @param {string} [variable] The data object variable name.
	     * @returns {Function|string} Returns a compiled function when no `data` object
	     *  is given, else it returns the interpolated text.
	     * @example
	     *
	     * // using the "interpolate" delimiter to create a compiled template
	     * var compiled = _.template('hello <%= name %>');
	     * compiled({ 'name': 'fred' });
	     * // => 'hello fred'
	     *
	     * // using the "escape" delimiter to escape HTML in data property values
	     * _.template('<b><%- value %></b>', { 'value': '<script>' });
	     * // => '<b>&lt;script&gt;</b>'
	     *
	     * // using the "evaluate" delimiter to generate HTML
	     * var list = '<% _.forEach(people, function(name) { %><li><%- name %></li><% }); %>';
	     * _.template(list, { 'people': ['fred', 'barney'] });
	     * // => '<li>fred</li><li>barney</li>'
	     *
	     * // using the ES6 delimiter as an alternative to the default "interpolate" delimiter
	     * _.template('hello ${ name }', { 'name': 'pebbles' });
	     * // => 'hello pebbles'
	     *
	     * // using the internal `print` function in "evaluate" delimiters
	     * _.template('<% print("hello " + name); %>!', { 'name': 'barney' });
	     * // => 'hello barney!'
	     *
	     * // using a custom template delimiters
	     * _.templateSettings = {
	     *   'interpolate': /{{([\s\S]+?)}}/g
	     * };
	     *
	     * _.template('hello {{ name }}!', { 'name': 'mustache' });
	     * // => 'hello mustache!'
	     *
	     * // using the `imports` option to import jQuery
	     * var list = '<% jq.each(people, function(name) { %><li><%- name %></li><% }); %>';
	     * _.template(list, { 'people': ['fred', 'barney'] }, { 'imports': { 'jq': jQuery } });
	     * // => '<li>fred</li><li>barney</li>'
	     *
	     * // using the `sourceURL` option to specify a custom sourceURL for the template
	     * var compiled = _.template('hello <%= name %>', null, { 'sourceURL': '/basic/greeting.jst' });
	     * compiled(data);
	     * // => find the source of "greeting.jst" under the Sources tab or Resources panel of the web inspector
	     *
	     * // using the `variable` option to ensure a with-statement isn't used in the compiled template
	     * var compiled = _.template('hi <%= data.name %>!', null, { 'variable': 'data' });
	     * compiled.source;
	     * // => function(data) {
	     *   var __t, __p = '', __e = _.escape;
	     *   __p += 'hi ' + ((__t = ( data.name )) == null ? '' : __t) + '!';
	     *   return __p;
	     * }
	     *
	     * // using the `source` property to inline compiled templates for meaningful
	     * // line numbers in error messages and a stack trace
	     * fs.writeFileSync(path.join(cwd, 'jst.js'), '\
	     *   var JST = {\
	     *     "main": ' + _.template(mainText).source + '\
	     *   };\
	     * ');
	     */
	    function template(text, data, options) {
	      // based on John Resig's `tmpl` implementation
	      // http://ejohn.org/blog/javascript-micro-templating/
	      // and Laura Doktorova's doT.js
	      // https://github.com/olado/doT
	      var settings = lodash.templateSettings;
	      text = String(text || '');

	      // avoid missing dependencies when `iteratorTemplate` is not defined
	      options = defaults({}, options, settings);

	      var imports = defaults({}, options.imports, settings.imports),
	          importsKeys = keys(imports),
	          importsValues = values(imports);

	      var isEvaluating,
	          index = 0,
	          interpolate = options.interpolate || reNoMatch,
	          source = "__p += '";

	      // compile the regexp to match each delimiter
	      var reDelimiters = RegExp(
	        (options.escape || reNoMatch).source + '|' +
	        interpolate.source + '|' +
	        (interpolate === reInterpolate ? reEsTemplate : reNoMatch).source + '|' +
	        (options.evaluate || reNoMatch).source + '|$'
	      , 'g');

	      text.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
	        interpolateValue || (interpolateValue = esTemplateValue);

	        // escape characters that cannot be included in string literals
	        source += text.slice(index, offset).replace(reUnescapedString, escapeStringChar);

	        // replace delimiters with snippets
	        if (escapeValue) {
	          source += "' +\n__e(" + escapeValue + ") +\n'";
	        }
	        if (evaluateValue) {
	          isEvaluating = true;
	          source += "';\n" + evaluateValue + ";\n__p += '";
	        }
	        if (interpolateValue) {
	          source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
	        }
	        index = offset + match.length;

	        // the JS engine embedded in Adobe products requires returning the `match`
	        // string in order to produce the correct `offset` value
	        return match;
	      });

	      source += "';\n";

	      // if `variable` is not specified, wrap a with-statement around the generated
	      // code to add the data object to the top of the scope chain
	      var variable = options.variable,
	          hasVariable = variable;

	      if (!hasVariable) {
	        variable = 'obj';
	        source = 'with (' + variable + ') {\n' + source + '\n}\n';
	      }
	      // cleanup code by stripping empty strings
	      source = (isEvaluating ? source.replace(reEmptyStringLeading, '') : source)
	        .replace(reEmptyStringMiddle, '$1')
	        .replace(reEmptyStringTrailing, '$1;');

	      // frame code as the function body
	      source = 'function(' + variable + ') {\n' +
	        (hasVariable ? '' : variable + ' || (' + variable + ' = {});\n') +
	        "var __t, __p = '', __e = _.escape" +
	        (isEvaluating
	          ? ', __j = Array.prototype.join;\n' +
	            "function print() { __p += __j.call(arguments, '') }\n"
	          : ';\n'
	        ) +
	        source +
	        'return __p\n}';

	      // Use a sourceURL for easier debugging.
	      // http://www.html5rocks.com/en/tutorials/developertools/sourcemaps/#toc-sourceurl
	      var sourceURL = '\n/*\n//# sourceURL=' + (options.sourceURL || '/lodash/template/source[' + (templateCounter++) + ']') + '\n*/';

	      try {
	        var result = Function(importsKeys, 'return ' + source + sourceURL).apply(undefined, importsValues);
	      } catch(e) {
	        e.source = source;
	        throw e;
	      }
	      if (data) {
	        return result(data);
	      }
	      // provide the compiled function's source by its `toString` method, in
	      // supported environments, or the `source` property as a convenience for
	      // inlining compiled templates during the build process
	      result.source = source;
	      return result;
	    }

	    /**
	     * Executes the callback `n` times, returning an array of the results
	     * of each callback execution. The callback is bound to `thisArg` and invoked
	     * with one argument; (index).
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {number} n The number of times to execute the callback.
	     * @param {Function} callback The function called per iteration.
	     * @param {*} [thisArg] The `this` binding of `callback`.
	     * @returns {Array} Returns an array of the results of each `callback` execution.
	     * @example
	     *
	     * var diceRolls = _.times(3, _.partial(_.random, 1, 6));
	     * // => [3, 6, 4]
	     *
	     * _.times(3, function(n) { mage.castSpell(n); });
	     * // => calls `mage.castSpell(n)` three times, passing `n` of `0`, `1`, and `2` respectively
	     *
	     * _.times(3, function(n) { this.cast(n); }, mage);
	     * // => also calls `mage.castSpell(n)` three times
	     */
	    function times(n, callback, thisArg) {
	      n = (n = +n) > -1 ? n : 0;
	      var index = -1,
	          result = Array(n);

	      callback = baseCreateCallback(callback, thisArg, 1);
	      while (++index < n) {
	        result[index] = callback(index);
	      }
	      return result;
	    }

	    /**
	     * The inverse of `_.escape` this method converts the HTML entities
	     * `&amp;`, `&lt;`, `&gt;`, `&quot;`, and `&#39;` in `string` to their
	     * corresponding characters.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {string} string The string to unescape.
	     * @returns {string} Returns the unescaped string.
	     * @example
	     *
	     * _.unescape('Fred, Barney &amp; Pebbles');
	     * // => 'Fred, Barney & Pebbles'
	     */
	    function unescape(string) {
	      return string == null ? '' : String(string).replace(reEscapedHtml, unescapeHtmlChar);
	    }

	    /**
	     * Generates a unique ID. If `prefix` is provided the ID will be appended to it.
	     *
	     * @static
	     * @memberOf _
	     * @category Utilities
	     * @param {string} [prefix] The value to prefix the ID with.
	     * @returns {string} Returns the unique ID.
	     * @example
	     *
	     * _.uniqueId('contact_');
	     * // => 'contact_104'
	     *
	     * _.uniqueId();
	     * // => '105'
	     */
	    function uniqueId(prefix) {
	      var id = ++idCounter;
	      return String(prefix == null ? '' : prefix) + id;
	    }

	    /*--------------------------------------------------------------------------*/

	    /**
	     * Creates a `lodash` object that wraps the given value with explicit
	     * method chaining enabled.
	     *
	     * @static
	     * @memberOf _
	     * @category Chaining
	     * @param {*} value The value to wrap.
	     * @returns {Object} Returns the wrapper object.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney',  'age': 36 },
	     *   { 'name': 'fred',    'age': 40 },
	     *   { 'name': 'pebbles', 'age': 1 }
	     * ];
	     *
	     * var youngest = _.chain(characters)
	     *     .sortBy('age')
	     *     .map(function(chr) { return chr.name + ' is ' + chr.age; })
	     *     .first()
	     *     .value();
	     * // => 'pebbles is 1'
	     */
	    function chain(value) {
	      value = new lodashWrapper(value);
	      value.__chain__ = true;
	      return value;
	    }

	    /**
	     * Invokes `interceptor` with the `value` as the first argument and then
	     * returns `value`. The purpose of this method is to "tap into" a method
	     * chain in order to perform operations on intermediate results within
	     * the chain.
	     *
	     * @static
	     * @memberOf _
	     * @category Chaining
	     * @param {*} value The value to provide to `interceptor`.
	     * @param {Function} interceptor The function to invoke.
	     * @returns {*} Returns `value`.
	     * @example
	     *
	     * _([1, 2, 3, 4])
	     *  .tap(function(array) { array.pop(); })
	     *  .reverse()
	     *  .value();
	     * // => [3, 2, 1]
	     */
	    function tap(value, interceptor) {
	      interceptor(value);
	      return value;
	    }

	    /**
	     * Enables explicit method chaining on the wrapper object.
	     *
	     * @name chain
	     * @memberOf _
	     * @category Chaining
	     * @returns {*} Returns the wrapper object.
	     * @example
	     *
	     * var characters = [
	     *   { 'name': 'barney', 'age': 36 },
	     *   { 'name': 'fred',   'age': 40 }
	     * ];
	     *
	     * // without explicit chaining
	     * _(characters).first();
	     * // => { 'name': 'barney', 'age': 36 }
	     *
	     * // with explicit chaining
	     * _(characters).chain()
	     *   .first()
	     *   .pick('age')
	     *   .value();
	     * // => { 'age': 36 }
	     */
	    function wrapperChain() {
	      this.__chain__ = true;
	      return this;
	    }

	    /**
	     * Produces the `toString` result of the wrapped value.
	     *
	     * @name toString
	     * @memberOf _
	     * @category Chaining
	     * @returns {string} Returns the string result.
	     * @example
	     *
	     * _([1, 2, 3]).toString();
	     * // => '1,2,3'
	     */
	    function wrapperToString() {
	      return String(this.__wrapped__);
	    }

	    /**
	     * Extracts the wrapped value.
	     *
	     * @name valueOf
	     * @memberOf _
	     * @alias value
	     * @category Chaining
	     * @returns {*} Returns the wrapped value.
	     * @example
	     *
	     * _([1, 2, 3]).valueOf();
	     * // => [1, 2, 3]
	     */
	    function wrapperValueOf() {
	      return this.__wrapped__;
	    }

	    /*--------------------------------------------------------------------------*/

	    // add functions that return wrapped values when chaining
	    lodash.after = after;
	    lodash.assign = assign;
	    lodash.at = at;
	    lodash.bind = bind;
	    lodash.bindAll = bindAll;
	    lodash.bindKey = bindKey;
	    lodash.chain = chain;
	    lodash.compact = compact;
	    lodash.compose = compose;
	    lodash.constant = constant;
	    lodash.countBy = countBy;
	    lodash.create = create;
	    lodash.createCallback = createCallback;
	    lodash.curry = curry;
	    lodash.debounce = debounce;
	    lodash.defaults = defaults;
	    lodash.defer = defer;
	    lodash.delay = delay;
	    lodash.difference = difference;
	    lodash.filter = filter;
	    lodash.flatten = flatten;
	    lodash.forEach = forEach;
	    lodash.forEachRight = forEachRight;
	    lodash.forIn = forIn;
	    lodash.forInRight = forInRight;
	    lodash.forOwn = forOwn;
	    lodash.forOwnRight = forOwnRight;
	    lodash.functions = functions;
	    lodash.groupBy = groupBy;
	    lodash.indexBy = indexBy;
	    lodash.initial = initial;
	    lodash.intersection = intersection;
	    lodash.invert = invert;
	    lodash.invoke = invoke;
	    lodash.keys = keys;
	    lodash.map = map;
	    lodash.mapValues = mapValues;
	    lodash.max = max;
	    lodash.memoize = memoize;
	    lodash.merge = merge;
	    lodash.min = min;
	    lodash.omit = omit;
	    lodash.once = once;
	    lodash.pairs = pairs;
	    lodash.partial = partial;
	    lodash.partialRight = partialRight;
	    lodash.pick = pick;
	    lodash.pluck = pluck;
	    lodash.property = property;
	    lodash.pull = pull;
	    lodash.range = range;
	    lodash.reject = reject;
	    lodash.remove = remove;
	    lodash.rest = rest;
	    lodash.shuffle = shuffle;
	    lodash.sortBy = sortBy;
	    lodash.tap = tap;
	    lodash.throttle = throttle;
	    lodash.times = times;
	    lodash.toArray = toArray;
	    lodash.transform = transform;
	    lodash.union = union;
	    lodash.uniq = uniq;
	    lodash.values = values;
	    lodash.where = where;
	    lodash.without = without;
	    lodash.wrap = wrap;
	    lodash.xor = xor;
	    lodash.zip = zip;
	    lodash.zipObject = zipObject;

	    // add aliases
	    lodash.collect = map;
	    lodash.drop = rest;
	    lodash.each = forEach;
	    lodash.eachRight = forEachRight;
	    lodash.extend = assign;
	    lodash.methods = functions;
	    lodash.object = zipObject;
	    lodash.select = filter;
	    lodash.tail = rest;
	    lodash.unique = uniq;
	    lodash.unzip = zip;

	    // add functions to `lodash.prototype`
	    mixin(lodash);

	    /*--------------------------------------------------------------------------*/

	    // add functions that return unwrapped values when chaining
	    lodash.clone = clone;
	    lodash.cloneDeep = cloneDeep;
	    lodash.contains = contains;
	    lodash.escape = escape;
	    lodash.every = every;
	    lodash.find = find;
	    lodash.findIndex = findIndex;
	    lodash.findKey = findKey;
	    lodash.findLast = findLast;
	    lodash.findLastIndex = findLastIndex;
	    lodash.findLastKey = findLastKey;
	    lodash.has = has;
	    lodash.identity = identity;
	    lodash.indexOf = indexOf;
	    lodash.isArguments = isArguments;
	    lodash.isArray = isArray;
	    lodash.isBoolean = isBoolean;
	    lodash.isDate = isDate;
	    lodash.isElement = isElement;
	    lodash.isEmpty = isEmpty;
	    lodash.isEqual = isEqual;
	    lodash.isFinite = isFinite;
	    lodash.isFunction = isFunction;
	    lodash.isNaN = isNaN;
	    lodash.isNull = isNull;
	    lodash.isNumber = isNumber;
	    lodash.isObject = isObject;
	    lodash.isPlainObject = isPlainObject;
	    lodash.isRegExp = isRegExp;
	    lodash.isString = isString;
	    lodash.isUndefined = isUndefined;
	    lodash.lastIndexOf = lastIndexOf;
	    lodash.mixin = mixin;
	    lodash.noConflict = noConflict;
	    lodash.noop = noop;
	    lodash.now = now;
	    lodash.parseInt = parseInt;
	    lodash.random = random;
	    lodash.reduce = reduce;
	    lodash.reduceRight = reduceRight;
	    lodash.result = result;
	    lodash.runInContext = runInContext;
	    lodash.size = size;
	    lodash.some = some;
	    lodash.sortedIndex = sortedIndex;
	    lodash.template = template;
	    lodash.unescape = unescape;
	    lodash.uniqueId = uniqueId;

	    // add aliases
	    lodash.all = every;
	    lodash.any = some;
	    lodash.detect = find;
	    lodash.findWhere = find;
	    lodash.foldl = reduce;
	    lodash.foldr = reduceRight;
	    lodash.include = contains;
	    lodash.inject = reduce;

	    mixin(function() {
	      var source = {}
	      forOwn(lodash, function(func, methodName) {
	        if (!lodash.prototype[methodName]) {
	          source[methodName] = func;
	        }
	      });
	      return source;
	    }(), false);

	    /*--------------------------------------------------------------------------*/

	    // add functions capable of returning wrapped and unwrapped values when chaining
	    lodash.first = first;
	    lodash.last = last;
	    lodash.sample = sample;

	    // add aliases
	    lodash.take = first;
	    lodash.head = first;

	    forOwn(lodash, function(func, methodName) {
	      var callbackable = methodName !== 'sample';
	      if (!lodash.prototype[methodName]) {
	        lodash.prototype[methodName]= function(n, guard) {
	          var chainAll = this.__chain__,
	              result = func(this.__wrapped__, n, guard);

	          return !chainAll && (n == null || (guard && !(callbackable && typeof n == 'function')))
	            ? result
	            : new lodashWrapper(result, chainAll);
	        };
	      }
	    });

	    /*--------------------------------------------------------------------------*/

	    /**
	     * The semantic version number.
	     *
	     * @static
	     * @memberOf _
	     * @type string
	     */
	    lodash.VERSION = '2.4.2';

	    // add "Chaining" functions to the wrapper
	    lodash.prototype.chain = wrapperChain;
	    lodash.prototype.toString = wrapperToString;
	    lodash.prototype.value = wrapperValueOf;
	    lodash.prototype.valueOf = wrapperValueOf;

	    // add `Array` functions that return unwrapped values
	    baseEach(['join', 'pop', 'shift'], function(methodName) {
	      var func = arrayRef[methodName];
	      lodash.prototype[methodName] = function() {
	        var chainAll = this.__chain__,
	            result = func.apply(this.__wrapped__, arguments);

	        return chainAll
	          ? new lodashWrapper(result, chainAll)
	          : result;
	      };
	    });

	    // add `Array` functions that return the existing wrapped value
	    baseEach(['push', 'reverse', 'sort', 'unshift'], function(methodName) {
	      var func = arrayRef[methodName];
	      lodash.prototype[methodName] = function() {
	        func.apply(this.__wrapped__, arguments);
	        return this;
	      };
	    });

	    // add `Array` functions that return new wrapped values
	    baseEach(['concat', 'slice', 'splice'], function(methodName) {
	      var func = arrayRef[methodName];
	      lodash.prototype[methodName] = function() {
	        return new lodashWrapper(func.apply(this.__wrapped__, arguments), this.__chain__);
	      };
	    });

	    // avoid array-like object bugs with `Array#shift` and `Array#splice`
	    // in IE < 9, Firefox < 10, Narwhal, and RingoJS
	    if (!support.spliceObjects) {
	      baseEach(['pop', 'shift', 'splice'], function(methodName) {
	        var func = arrayRef[methodName],
	            isSplice = methodName == 'splice';

	        lodash.prototype[methodName] = function() {
	          var chainAll = this.__chain__,
	              value = this.__wrapped__,
	              result = func.apply(value, arguments);

	          if (value.length === 0) {
	            delete value[0];
	          }
	          return (chainAll || isSplice)
	            ? new lodashWrapper(result, chainAll)
	            : result;
	        };
	      });
	    }

	    return lodash;
	  }

	  /*--------------------------------------------------------------------------*/

	  // expose Lo-Dash
	  var _ = runInContext();

	  // some AMD build optimizers like r.js check for condition patterns like the following:
	  if (true) {
	    // Expose Lo-Dash to the global object even when an AMD loader is present in
	    // case Lo-Dash is loaded with a RequireJS shim config.
	    // See http://requirejs.org/docs/api.html#config-shim
	    root._ = _;

	    // define as an anonymous module so, through path mapping, it can be
	    // referenced as the "underscore" module
	    !(__WEBPACK_AMD_DEFINE_RESULT__ = function() {
	      return _;
	    }.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  }
	  // check for `exports` after `define` in case a build optimizer adds an `exports` object
	  else if (freeExports && freeModule) {
	    // in Node.js or RingoJS
	    if (moduleExports) {
	      (freeModule.exports = _)._ = _;
	    }
	    // in Narwhal or Rhino -require
	    else {
	      freeExports._ = _;
	    }
	  }
	  else {
	    // in a browser or Rhino
	    root._ = _;
	  }
	}.call(this));

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15)(module), (function() { return this; }())))

/***/ },
/* 15 */
/***/ function(module, exports) {

	module.exports = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ },
/* 16 */
/***/ function(module, exports) {

	/* WEBPACK VAR INJECTION */(function(global) {/**
	 * lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="npm" -o ./`
	 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */

	/** Used as the `TypeError` message for "Functions" methods. */
	var FUNC_ERROR_TEXT = 'Expected a function';

	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';

	/** Used as references for various `Number` constants. */
	var INFINITY = 1 / 0;

	/** `Object#toString` result references. */
	var funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]',
	    symbolTag = '[object Symbol]';

	/** Used to match property names within property paths. */
	var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
	    reIsPlainProp = /^\w*$/,
	    reLeadingDot = /^\./,
	    rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

	/**
	 * Used to match `RegExp`
	 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
	 */
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

	/** Used to match backslashes in property paths. */
	var reEscapeChar = /\\(\\)?/g;

	/** Used to detect host constructors (Safari). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;

	/** Detect free variable `global` from Node.js. */
	var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

	/** Detect free variable `self`. */
	var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

	/** Used as a reference to the global object. */
	var root = freeGlobal || freeSelf || Function('return this')();

	/**
	 * Gets the value at `key` of `object`.
	 *
	 * @private
	 * @param {Object} [object] The object to query.
	 * @param {string} key The key of the property to get.
	 * @returns {*} Returns the property value.
	 */
	function getValue(object, key) {
	  return object == null ? undefined : object[key];
	}

	/**
	 * Checks if `value` is a host object in IE < 9.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
	 */
	function isHostObject(value) {
	  // Many host objects are `Object` objects that can coerce to strings
	  // despite having improperly defined `toString` methods.
	  var result = false;
	  if (value != null && typeof value.toString != 'function') {
	    try {
	      result = !!(value + '');
	    } catch (e) {}
	  }
	  return result;
	}

	/** Used for built-in method references. */
	var arrayProto = Array.prototype,
	    funcProto = Function.prototype,
	    objectProto = Object.prototype;

	/** Used to detect overreaching core-js shims. */
	var coreJsData = root['__core-js_shared__'];

	/** Used to detect methods masquerading as native. */
	var maskSrcKey = (function() {
	  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
	  return uid ? ('Symbol(src)_1.' + uid) : '';
	}());

	/** Used to resolve the decompiled source of functions. */
	var funcToString = funcProto.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;

	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);

	/** Built-in value references. */
	var Symbol = root.Symbol,
	    splice = arrayProto.splice;

	/* Built-in method references that are verified to be native. */
	var Map = getNative(root, 'Map'),
	    nativeCreate = getNative(Object, 'create');

	/** Used to convert symbols to primitives and strings. */
	var symbolProto = Symbol ? Symbol.prototype : undefined,
	    symbolToString = symbolProto ? symbolProto.toString : undefined;

	/**
	 * Creates a hash object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function Hash(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the hash.
	 *
	 * @private
	 * @name clear
	 * @memberOf Hash
	 */
	function hashClear() {
	  this.__data__ = nativeCreate ? nativeCreate(null) : {};
	}

	/**
	 * Removes `key` and its value from the hash.
	 *
	 * @private
	 * @name delete
	 * @memberOf Hash
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function hashDelete(key) {
	  return this.has(key) && delete this.__data__[key];
	}

	/**
	 * Gets the hash value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Hash
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function hashGet(key) {
	  var data = this.__data__;
	  if (nativeCreate) {
	    var result = data[key];
	    return result === HASH_UNDEFINED ? undefined : result;
	  }
	  return hasOwnProperty.call(data, key) ? data[key] : undefined;
	}

	/**
	 * Checks if a hash value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Hash
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function hashHas(key) {
	  var data = this.__data__;
	  return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
	}

	/**
	 * Sets the hash `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Hash
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the hash instance.
	 */
	function hashSet(key, value) {
	  var data = this.__data__;
	  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
	  return this;
	}

	// Add methods to `Hash`.
	Hash.prototype.clear = hashClear;
	Hash.prototype['delete'] = hashDelete;
	Hash.prototype.get = hashGet;
	Hash.prototype.has = hashHas;
	Hash.prototype.set = hashSet;

	/**
	 * Creates an list cache object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function ListCache(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the list cache.
	 *
	 * @private
	 * @name clear
	 * @memberOf ListCache
	 */
	function listCacheClear() {
	  this.__data__ = [];
	}

	/**
	 * Removes `key` and its value from the list cache.
	 *
	 * @private
	 * @name delete
	 * @memberOf ListCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function listCacheDelete(key) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = data.length - 1;
	  if (index == lastIndex) {
	    data.pop();
	  } else {
	    splice.call(data, index, 1);
	  }
	  return true;
	}

	/**
	 * Gets the list cache value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf ListCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function listCacheGet(key) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  return index < 0 ? undefined : data[index][1];
	}

	/**
	 * Checks if a list cache value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf ListCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function listCacheHas(key) {
	  return assocIndexOf(this.__data__, key) > -1;
	}

	/**
	 * Sets the list cache `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf ListCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the list cache instance.
	 */
	function listCacheSet(key, value) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  if (index < 0) {
	    data.push([key, value]);
	  } else {
	    data[index][1] = value;
	  }
	  return this;
	}

	// Add methods to `ListCache`.
	ListCache.prototype.clear = listCacheClear;
	ListCache.prototype['delete'] = listCacheDelete;
	ListCache.prototype.get = listCacheGet;
	ListCache.prototype.has = listCacheHas;
	ListCache.prototype.set = listCacheSet;

	/**
	 * Creates a map cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function MapCache(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the map.
	 *
	 * @private
	 * @name clear
	 * @memberOf MapCache
	 */
	function mapCacheClear() {
	  this.__data__ = {
	    'hash': new Hash,
	    'map': new (Map || ListCache),
	    'string': new Hash
	  };
	}

	/**
	 * Removes `key` and its value from the map.
	 *
	 * @private
	 * @name delete
	 * @memberOf MapCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function mapCacheDelete(key) {
	  return getMapData(this, key)['delete'](key);
	}

	/**
	 * Gets the map value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf MapCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function mapCacheGet(key) {
	  return getMapData(this, key).get(key);
	}

	/**
	 * Checks if a map value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf MapCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function mapCacheHas(key) {
	  return getMapData(this, key).has(key);
	}

	/**
	 * Sets the map `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf MapCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the map cache instance.
	 */
	function mapCacheSet(key, value) {
	  getMapData(this, key).set(key, value);
	  return this;
	}

	// Add methods to `MapCache`.
	MapCache.prototype.clear = mapCacheClear;
	MapCache.prototype['delete'] = mapCacheDelete;
	MapCache.prototype.get = mapCacheGet;
	MapCache.prototype.has = mapCacheHas;
	MapCache.prototype.set = mapCacheSet;

	/**
	 * Gets the index at which the `key` is found in `array` of key-value pairs.
	 *
	 * @private
	 * @param {Array} array The array to inspect.
	 * @param {*} key The key to search for.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}

	/**
	 * The base implementation of `_.get` without support for default values.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {Array|string} path The path of the property to get.
	 * @returns {*} Returns the resolved value.
	 */
	function baseGet(object, path) {
	  path = isKey(path, object) ? [path] : castPath(path);

	  var index = 0,
	      length = path.length;

	  while (object != null && index < length) {
	    object = object[toKey(path[index++])];
	  }
	  return (index && index == length) ? object : undefined;
	}

	/**
	 * The base implementation of `_.isNative` without bad shim checks.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a native function,
	 *  else `false`.
	 */
	function baseIsNative(value) {
	  if (!isObject(value) || isMasked(value)) {
	    return false;
	  }
	  var pattern = (isFunction(value) || isHostObject(value)) ? reIsNative : reIsHostCtor;
	  return pattern.test(toSource(value));
	}

	/**
	 * The base implementation of `_.toString` which doesn't convert nullish
	 * values to empty strings.
	 *
	 * @private
	 * @param {*} value The value to process.
	 * @returns {string} Returns the string.
	 */
	function baseToString(value) {
	  // Exit early for strings to avoid a performance hit in some environments.
	  if (typeof value == 'string') {
	    return value;
	  }
	  if (isSymbol(value)) {
	    return symbolToString ? symbolToString.call(value) : '';
	  }
	  var result = (value + '');
	  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
	}

	/**
	 * Casts `value` to a path array if it's not one.
	 *
	 * @private
	 * @param {*} value The value to inspect.
	 * @returns {Array} Returns the cast property path array.
	 */
	function castPath(value) {
	  return isArray(value) ? value : stringToPath(value);
	}

	/**
	 * Gets the data for `map`.
	 *
	 * @private
	 * @param {Object} map The map to query.
	 * @param {string} key The reference key.
	 * @returns {*} Returns the map data.
	 */
	function getMapData(map, key) {
	  var data = map.__data__;
	  return isKeyable(key)
	    ? data[typeof key == 'string' ? 'string' : 'hash']
	    : data.map;
	}

	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = getValue(object, key);
	  return baseIsNative(value) ? value : undefined;
	}

	/**
	 * Checks if `value` is a property name and not a property path.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @param {Object} [object] The object to query keys on.
	 * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
	 */
	function isKey(value, object) {
	  if (isArray(value)) {
	    return false;
	  }
	  var type = typeof value;
	  if (type == 'number' || type == 'symbol' || type == 'boolean' ||
	      value == null || isSymbol(value)) {
	    return true;
	  }
	  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
	    (object != null && value in Object(object));
	}

	/**
	 * Checks if `value` is suitable for use as unique object key.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
	 */
	function isKeyable(value) {
	  var type = typeof value;
	  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
	    ? (value !== '__proto__')
	    : (value === null);
	}

	/**
	 * Checks if `func` has its source masked.
	 *
	 * @private
	 * @param {Function} func The function to check.
	 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
	 */
	function isMasked(func) {
	  return !!maskSrcKey && (maskSrcKey in func);
	}

	/**
	 * Converts `string` to a property path array.
	 *
	 * @private
	 * @param {string} string The string to convert.
	 * @returns {Array} Returns the property path array.
	 */
	var stringToPath = memoize(function(string) {
	  string = toString(string);

	  var result = [];
	  if (reLeadingDot.test(string)) {
	    result.push('');
	  }
	  string.replace(rePropName, function(match, number, quote, string) {
	    result.push(quote ? string.replace(reEscapeChar, '$1') : (number || match));
	  });
	  return result;
	});

	/**
	 * Converts `value` to a string key if it's not a string or symbol.
	 *
	 * @private
	 * @param {*} value The value to inspect.
	 * @returns {string|symbol} Returns the key.
	 */
	function toKey(value) {
	  if (typeof value == 'string' || isSymbol(value)) {
	    return value;
	  }
	  var result = (value + '');
	  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
	}

	/**
	 * Converts `func` to its source code.
	 *
	 * @private
	 * @param {Function} func The function to process.
	 * @returns {string} Returns the source code.
	 */
	function toSource(func) {
	  if (func != null) {
	    try {
	      return funcToString.call(func);
	    } catch (e) {}
	    try {
	      return (func + '');
	    } catch (e) {}
	  }
	  return '';
	}

	/**
	 * Creates a function that memoizes the result of `func`. If `resolver` is
	 * provided, it determines the cache key for storing the result based on the
	 * arguments provided to the memoized function. By default, the first argument
	 * provided to the memoized function is used as the map cache key. The `func`
	 * is invoked with the `this` binding of the memoized function.
	 *
	 * **Note:** The cache is exposed as the `cache` property on the memoized
	 * function. Its creation may be customized by replacing the `_.memoize.Cache`
	 * constructor with one whose instances implement the
	 * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
	 * method interface of `delete`, `get`, `has`, and `set`.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Function
	 * @param {Function} func The function to have its output memoized.
	 * @param {Function} [resolver] The function to resolve the cache key.
	 * @returns {Function} Returns the new memoized function.
	 * @example
	 *
	 * var object = { 'a': 1, 'b': 2 };
	 * var other = { 'c': 3, 'd': 4 };
	 *
	 * var values = _.memoize(_.values);
	 * values(object);
	 * // => [1, 2]
	 *
	 * values(other);
	 * // => [3, 4]
	 *
	 * object.a = 2;
	 * values(object);
	 * // => [1, 2]
	 *
	 * // Modify the result cache.
	 * values.cache.set(object, ['a', 'b']);
	 * values(object);
	 * // => ['a', 'b']
	 *
	 * // Replace `_.memoize.Cache`.
	 * _.memoize.Cache = WeakMap;
	 */
	function memoize(func, resolver) {
	  if (typeof func != 'function' || (resolver && typeof resolver != 'function')) {
	    throw new TypeError(FUNC_ERROR_TEXT);
	  }
	  var memoized = function() {
	    var args = arguments,
	        key = resolver ? resolver.apply(this, args) : args[0],
	        cache = memoized.cache;

	    if (cache.has(key)) {
	      return cache.get(key);
	    }
	    var result = func.apply(this, args);
	    memoized.cache = cache.set(key, result);
	    return result;
	  };
	  memoized.cache = new (memoize.Cache || MapCache);
	  return memoized;
	}

	// Assign cache to `_.memoize`.
	memoize.Cache = MapCache;

	/**
	 * Performs a
	 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
	 * comparison between two values to determine if they are equivalent.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to compare.
	 * @param {*} other The other value to compare.
	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	 * @example
	 *
	 * var object = { 'a': 1 };
	 * var other = { 'a': 1 };
	 *
	 * _.eq(object, object);
	 * // => true
	 *
	 * _.eq(object, other);
	 * // => false
	 *
	 * _.eq('a', 'a');
	 * // => true
	 *
	 * _.eq('a', Object('a'));
	 * // => false
	 *
	 * _.eq(NaN, NaN);
	 * // => true
	 */
	function eq(value, other) {
	  return value === other || (value !== value && other !== other);
	}

	/**
	 * Checks if `value` is classified as an `Array` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
	 * @example
	 *
	 * _.isArray([1, 2, 3]);
	 * // => true
	 *
	 * _.isArray(document.body.children);
	 * // => false
	 *
	 * _.isArray('abc');
	 * // => false
	 *
	 * _.isArray(_.noop);
	 * // => false
	 */
	var isArray = Array.isArray;

	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  // The use of `Object#toString` avoids issues with the `typeof` operator
	  // in Safari 8-9 which returns 'object' for typed array and other constructors.
	  var tag = isObject(value) ? objectToString.call(value) : '';
	  return tag == funcTag || tag == genTag;
	}

	/**
	 * Checks if `value` is the
	 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
	 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(_.noop);
	 * // => true
	 *
	 * _.isObject(null);
	 * // => false
	 */
	function isObject(value) {
	  var type = typeof value;
	  return !!value && (type == 'object' || type == 'function');
	}

	/**
	 * Checks if `value` is object-like. A value is object-like if it's not `null`
	 * and has a `typeof` result of "object".
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 * @example
	 *
	 * _.isObjectLike({});
	 * // => true
	 *
	 * _.isObjectLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isObjectLike(_.noop);
	 * // => false
	 *
	 * _.isObjectLike(null);
	 * // => false
	 */
	function isObjectLike(value) {
	  return !!value && typeof value == 'object';
	}

	/**
	 * Checks if `value` is classified as a `Symbol` primitive or object.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
	 * @example
	 *
	 * _.isSymbol(Symbol.iterator);
	 * // => true
	 *
	 * _.isSymbol('abc');
	 * // => false
	 */
	function isSymbol(value) {
	  return typeof value == 'symbol' ||
	    (isObjectLike(value) && objectToString.call(value) == symbolTag);
	}

	/**
	 * Converts `value` to a string. An empty string is returned for `null`
	 * and `undefined` values. The sign of `-0` is preserved.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to process.
	 * @returns {string} Returns the string.
	 * @example
	 *
	 * _.toString(null);
	 * // => ''
	 *
	 * _.toString(-0);
	 * // => '-0'
	 *
	 * _.toString([1, 2, 3]);
	 * // => '1,2,3'
	 */
	function toString(value) {
	  return value == null ? '' : baseToString(value);
	}

	/**
	 * Gets the value at `path` of `object`. If the resolved value is
	 * `undefined`, the `defaultValue` is returned in its place.
	 *
	 * @static
	 * @memberOf _
	 * @since 3.7.0
	 * @category Object
	 * @param {Object} object The object to query.
	 * @param {Array|string} path The path of the property to get.
	 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
	 * @returns {*} Returns the resolved value.
	 * @example
	 *
	 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
	 *
	 * _.get(object, 'a[0].b.c');
	 * // => 3
	 *
	 * _.get(object, ['a', '0', 'b', 'c']);
	 * // => 3
	 *
	 * _.get(object, 'a.b.c', 'default');
	 * // => 'default'
	 */
	function get(object, path, defaultValue) {
	  var result = object == null ? undefined : baseGet(object, path);
	  return result === undefined ? defaultValue : result;
	}

	module.exports = get;

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 17 */
/***/ function(module, exports) {

	/* WEBPACK VAR INJECTION */(function(global) {/**
	 * lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="npm" -o ./`
	 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */

	/** Used as references for various `Number` constants. */
	var INFINITY = 1 / 0;

	/** `Object#toString` result references. */
	var symbolTag = '[object Symbol]';

	/** Used to match leading and trailing whitespace. */
	var reTrimEnd = /\s+$/;

	/** Used to compose unicode character classes. */
	var rsAstralRange = '\\ud800-\\udfff',
	    rsComboMarksRange = '\\u0300-\\u036f\\ufe20-\\ufe23',
	    rsComboSymbolsRange = '\\u20d0-\\u20f0',
	    rsVarRange = '\\ufe0e\\ufe0f';

	/** Used to compose unicode capture groups. */
	var rsAstral = '[' + rsAstralRange + ']',
	    rsCombo = '[' + rsComboMarksRange + rsComboSymbolsRange + ']',
	    rsFitz = '\\ud83c[\\udffb-\\udfff]',
	    rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
	    rsNonAstral = '[^' + rsAstralRange + ']',
	    rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
	    rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
	    rsZWJ = '\\u200d';

	/** Used to compose unicode regexes. */
	var reOptMod = rsModifier + '?',
	    rsOptVar = '[' + rsVarRange + ']?',
	    rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
	    rsSeq = rsOptVar + reOptMod + rsOptJoin,
	    rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

	/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
	var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

	/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
	var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboMarksRange + rsComboSymbolsRange + rsVarRange + ']');

	/** Detect free variable `global` from Node.js. */
	var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

	/** Detect free variable `self`. */
	var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

	/** Used as a reference to the global object. */
	var root = freeGlobal || freeSelf || Function('return this')();

	/**
	 * Converts an ASCII `string` to an array.
	 *
	 * @private
	 * @param {string} string The string to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function asciiToArray(string) {
	  return string.split('');
	}

	/**
	 * The base implementation of `_.findIndex` and `_.findLastIndex` without
	 * support for iteratee shorthands.
	 *
	 * @private
	 * @param {Array} array The array to inspect.
	 * @param {Function} predicate The function invoked per iteration.
	 * @param {number} fromIndex The index to search from.
	 * @param {boolean} [fromRight] Specify iterating from right to left.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function baseFindIndex(array, predicate, fromIndex, fromRight) {
	  var length = array.length,
	      index = fromIndex + (fromRight ? 1 : -1);

	  while ((fromRight ? index-- : ++index < length)) {
	    if (predicate(array[index], index, array)) {
	      return index;
	    }
	  }
	  return -1;
	}

	/**
	 * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
	 *
	 * @private
	 * @param {Array} array The array to inspect.
	 * @param {*} value The value to search for.
	 * @param {number} fromIndex The index to search from.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function baseIndexOf(array, value, fromIndex) {
	  if (value !== value) {
	    return baseFindIndex(array, baseIsNaN, fromIndex);
	  }
	  var index = fromIndex - 1,
	      length = array.length;

	  while (++index < length) {
	    if (array[index] === value) {
	      return index;
	    }
	  }
	  return -1;
	}

	/**
	 * The base implementation of `_.isNaN` without support for number objects.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
	 */
	function baseIsNaN(value) {
	  return value !== value;
	}

	/**
	 * Used by `_.trim` and `_.trimEnd` to get the index of the last string symbol
	 * that is not found in the character symbols.
	 *
	 * @private
	 * @param {Array} strSymbols The string symbols to inspect.
	 * @param {Array} chrSymbols The character symbols to find.
	 * @returns {number} Returns the index of the last unmatched string symbol.
	 */
	function charsEndIndex(strSymbols, chrSymbols) {
	  var index = strSymbols.length;

	  while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
	  return index;
	}

	/**
	 * Checks if `string` contains Unicode symbols.
	 *
	 * @private
	 * @param {string} string The string to inspect.
	 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
	 */
	function hasUnicode(string) {
	  return reHasUnicode.test(string);
	}

	/**
	 * Converts `string` to an array.
	 *
	 * @private
	 * @param {string} string The string to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function stringToArray(string) {
	  return hasUnicode(string)
	    ? unicodeToArray(string)
	    : asciiToArray(string);
	}

	/**
	 * Converts a Unicode `string` to an array.
	 *
	 * @private
	 * @param {string} string The string to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function unicodeToArray(string) {
	  return string.match(reUnicode) || [];
	}

	/** Used for built-in method references. */
	var objectProto = Object.prototype;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;

	/** Built-in value references. */
	var Symbol = root.Symbol;

	/** Used to convert symbols to primitives and strings. */
	var symbolProto = Symbol ? Symbol.prototype : undefined,
	    symbolToString = symbolProto ? symbolProto.toString : undefined;

	/**
	 * The base implementation of `_.slice` without an iteratee call guard.
	 *
	 * @private
	 * @param {Array} array The array to slice.
	 * @param {number} [start=0] The start position.
	 * @param {number} [end=array.length] The end position.
	 * @returns {Array} Returns the slice of `array`.
	 */
	function baseSlice(array, start, end) {
	  var index = -1,
	      length = array.length;

	  if (start < 0) {
	    start = -start > length ? 0 : (length + start);
	  }
	  end = end > length ? length : end;
	  if (end < 0) {
	    end += length;
	  }
	  length = start > end ? 0 : ((end - start) >>> 0);
	  start >>>= 0;

	  var result = Array(length);
	  while (++index < length) {
	    result[index] = array[index + start];
	  }
	  return result;
	}

	/**
	 * The base implementation of `_.toString` which doesn't convert nullish
	 * values to empty strings.
	 *
	 * @private
	 * @param {*} value The value to process.
	 * @returns {string} Returns the string.
	 */
	function baseToString(value) {
	  // Exit early for strings to avoid a performance hit in some environments.
	  if (typeof value == 'string') {
	    return value;
	  }
	  if (isSymbol(value)) {
	    return symbolToString ? symbolToString.call(value) : '';
	  }
	  var result = (value + '');
	  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
	}

	/**
	 * Casts `array` to a slice if it's needed.
	 *
	 * @private
	 * @param {Array} array The array to inspect.
	 * @param {number} start The start position.
	 * @param {number} [end=array.length] The end position.
	 * @returns {Array} Returns the cast slice.
	 */
	function castSlice(array, start, end) {
	  var length = array.length;
	  end = end === undefined ? length : end;
	  return (!start && end >= length) ? array : baseSlice(array, start, end);
	}

	/**
	 * Checks if `value` is object-like. A value is object-like if it's not `null`
	 * and has a `typeof` result of "object".
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 * @example
	 *
	 * _.isObjectLike({});
	 * // => true
	 *
	 * _.isObjectLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isObjectLike(_.noop);
	 * // => false
	 *
	 * _.isObjectLike(null);
	 * // => false
	 */
	function isObjectLike(value) {
	  return !!value && typeof value == 'object';
	}

	/**
	 * Checks if `value` is classified as a `Symbol` primitive or object.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
	 * @example
	 *
	 * _.isSymbol(Symbol.iterator);
	 * // => true
	 *
	 * _.isSymbol('abc');
	 * // => false
	 */
	function isSymbol(value) {
	  return typeof value == 'symbol' ||
	    (isObjectLike(value) && objectToString.call(value) == symbolTag);
	}

	/**
	 * Converts `value` to a string. An empty string is returned for `null`
	 * and `undefined` values. The sign of `-0` is preserved.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to process.
	 * @returns {string} Returns the string.
	 * @example
	 *
	 * _.toString(null);
	 * // => ''
	 *
	 * _.toString(-0);
	 * // => '-0'
	 *
	 * _.toString([1, 2, 3]);
	 * // => '1,2,3'
	 */
	function toString(value) {
	  return value == null ? '' : baseToString(value);
	}

	/**
	 * Removes trailing whitespace or specified characters from `string`.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category String
	 * @param {string} [string=''] The string to trim.
	 * @param {string} [chars=whitespace] The characters to trim.
	 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
	 * @returns {string} Returns the trimmed string.
	 * @example
	 *
	 * _.trimEnd('  abc  ');
	 * // => '  abc'
	 *
	 * _.trimEnd('-_-abc-_-', '_-');
	 * // => '-_-abc'
	 */
	function trimEnd(string, chars, guard) {
	  string = toString(string);
	  if (string && (guard || chars === undefined)) {
	    return string.replace(reTrimEnd, '');
	  }
	  if (!string || !(chars = baseToString(chars))) {
	    return string;
	  }
	  var strSymbols = stringToArray(string),
	      end = charsEndIndex(strSymbols, stringToArray(chars)) + 1;

	  return castSlice(strSymbols, 0, end).join('');
	}

	module.exports = trimEnd;

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(5);
	var errors = module.exports;

	var canCapture = (typeof Error.captureStackTrace === 'function');
	var canStack = !!(new Error()).stack;

	function ErrorAbstract(msg, constructor, metadata) {
	  this.message = msg;

	  Error.call(this, this.message);

	  if (canCapture) {
	    Error.captureStackTrace(this, constructor);
	  }
	  else if (canStack) {
	    this.stack = (new Error()).stack;
	  }
	  else {
	    this.stack = '';
	  }

	  if (metadata) {
	    _.assign(this, metadata);

	    this.toString = function () {
	      return msg + ' :: ' + JSON.stringify(metadata);
	    };

	    this.toJSON = function () {
	      return _.assign({
	        msg: msg
	      }, metadata);
	    };
	  }
	}
	errors._Abstract = ErrorAbstract;
	_.inherits(ErrorAbstract, Error);

	/**
	 * Connection Error
	 * @param {String} [msg] - An error message that will probably end up in a log.
	 */
	errors.ConnectionFault = function ConnectionFault(msg) {
	  ErrorAbstract.call(this, msg || 'Connection Failure', errors.ConnectionFault);
	};
	_.inherits(errors.ConnectionFault, ErrorAbstract);

	/**
	 * No Living Connections
	 * @param {String} [msg] - An error message that will probably end up in a log.
	 */
	errors.NoConnections = function NoConnections(msg) {
	  ErrorAbstract.call(this, msg || 'No Living connections', errors.NoConnections);
	};
	_.inherits(errors.NoConnections, ErrorAbstract);

	/**
	 * Generic Error
	 * @param {String} [msg] - An error message that will probably end up in a log.
	 */
	errors.Generic = function Generic(msg, metadata) {
	  ErrorAbstract.call(this, msg || 'Generic Error', errors.Generic, metadata);
	};
	_.inherits(errors.Generic, ErrorAbstract);

	/**
	 * Request Timeout Error
	 * @param {String} [msg] - An error message that will probably end up in a log.
	 */
	errors.RequestTimeout = function RequestTimeout(msg) {
	  ErrorAbstract.call(this, msg || 'Request Timeout', errors.RequestTimeout);
	};
	_.inherits(errors.RequestTimeout, ErrorAbstract);


	/**
	 * Request Body could not be parsed
	 * @param {String} [msg] - An error message that will probably end up in a log.
	 */
	errors.Serialization = function Serialization(msg) {
	  ErrorAbstract.call(this, msg || 'Unable to parse/serialize body', errors.Serialization);
	};
	_.inherits(errors.Serialization, ErrorAbstract);


	/**
	 * Thrown when a browser compatability issue is detected (cough, IE, cough)
	 */
	errors.RequestTypeError = function RequestTypeError(feature) {
	  ErrorAbstract.call(this, 'Cross-domain AJAX requests ' + feature + ' are not supported', errors.RequestTypeError);
	};
	_.inherits(errors.RequestTypeError, ErrorAbstract);

	var statusCodes = [
	  [300, 'Multiple Choices'],
	  [301, 'Moved Permanently'],
	  [302, 'Found'],
	  [303, 'See Other'],
	  [304, 'Not Modified'],
	  [305, 'Use Proxy'],
	  [307, 'Temporary Redirect'],
	  [308, 'Permanent Redirect'],
	  [400, 'Bad Request'],
	  [401, 'Authentication Exception'],
	  [402, 'Payment Required'],
	  [403, ['Authorization Exception', 'Forbidden']],
	  [404, 'Not Found'],
	  [405, 'Method Not Allowed'],
	  [406, 'Not Acceptable'],
	  [407, 'Proxy Authentication Required'],
	  [408, 'Request Timeout'],
	  [409, 'Conflict'],
	  [410, 'Gone'],
	  [411, 'Length Required'],
	  [412, 'Precondition Failed'],
	  [413, 'Request Entity Too Large'],
	  [414, 'Request URIToo Long'],
	  [415, 'Unsupported Media Type'],
	  [416, 'Requested Range Not Satisfiable'],
	  [417, 'Expectation Failed'],
	  [418, 'Im ATeapot'],
	  [421, 'Too Many Connections From This IP'],
	  [426, 'Upgrade Required'],
	  [429, 'Too Many Requests'],
	  [450, 'Blocked By Windows Parental Controls'],
	  [494, 'Request Header Too Large'],
	  [497, 'HTTPTo HTTPS'],
	  [499, 'Client Closed Request'],
	  [500, 'Internal Server Error'],
	  [501, 'Not Implemented'],
	  [502, 'Bad Gateway'],
	  [503, 'Service Unavailable'],
	  [504, 'Gateway Timeout'],
	  [505, 'HTTPVersion Not Supported'],
	  [506, 'Variant Also Negotiates'],
	  [510, 'Not Extended']
	];

	_.each(statusCodes, function createStatusCodeError(tuple) {
	  var status = tuple[0];
	  var names = tuple[1];
	  var allNames = [].concat(names, status);
	  var primaryName = allNames[0];
	  var className = _.studlyCase(primaryName);
	  allNames = _.uniq(allNames.concat(className));

	  function StatusCodeError(msg, metadata) {
	    this.status = status;
	    this.displayName = className;

	    var esErrObject = null;
	    if (_.isPlainObject(msg)) {
	      esErrObject = msg;
	      msg = null;
	    }

	    if (!esErrObject) {
	      // errors from es now come in two forms, an error string < 2.0 and
	      // an object >= 2.0
	      // TODO: remove after dropping support for < 2.0
	      ErrorAbstract.call(this, msg || primaryName, StatusCodeError, metadata);
	      return this;
	    }

	    msg = [].concat(esErrObject.root_cause || []).reduce(function (memo, cause) {
	      if (memo) memo += ' (and) ';

	      memo += '[' + cause.type + '] ' + cause.reason;

	      var extraData = _.omit(cause, ['type', 'reason']);
	      if (_.size(extraData)) {
	        memo += ', with ' + prettyPrint(extraData);
	      }

	      return memo;
	    }, '');

	    if (!msg) {
	      if (esErrObject.type) msg += '[' + esErrObject.type + '] ';
	      if (esErrObject.reason) msg += esErrObject.reason;
	    }

	    ErrorAbstract.call(this, msg || primaryName, StatusCodeError, metadata);
	    return this;
	  }
	  _.inherits(StatusCodeError, ErrorAbstract);

	  allNames.forEach(function (name) {
	    errors[name] = StatusCodeError;
	  });
	});


	function prettyPrint(data) {
	  const path = []
	  return (function print(v) {
	    if (typeof v === 'object') {
	      if (path.indexOf(v) > -1) return '[circular]'
	      path.push(v)
	      try {
	        return '{ ' + _.map(v, function (subv, name) {
	          return name + '=' + print(subv)
	        }).join(' & ') + ' }'
	      } finally {
	        path.pop()
	      }
	    } else {
	      return JSON.stringify(v)
	    }
	  }(data))
	}


/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {/**
	 * Class to wrap URLS, formatting them and maintaining their separate details
	 * @type {[type]}
	 */
	module.exports = Host;

	var url = __webpack_require__(20);
	var qs = __webpack_require__(23);
	var _ = __webpack_require__(5);

	var startsWithProtocolRE = /^([a-z]+:)?\/\//;
	var defaultProto = 'http:';
	var btoa;

	if (typeof window !== 'undefined' && typeof window.location !== 'undefined') {
	  defaultProto = window.location.protocol;
	  btoa = window.btoa;
	}

	btoa = btoa || function (data) {
	  return (new Buffer(data, 'utf8')).toString('base64');
	};

	var urlParseFields = [
	  'protocol', 'hostname', 'pathname', 'port', 'auth', 'query'
	];

	var simplify = ['host', 'path'];

	var sslDefaults = {
	  pfx: null,
	  key: null,
	  passphrase: null,
	  cert: null,
	  ca: null,
	  ciphers: null,
	  rejectUnauthorized: false,
	  secureProtocol: null
	};

	// simple reference used when formatting as a url
	// and defines when parsing from a string
	Host.defaultPorts = {
	  http: 80,
	  https: 443
	};

	function Host(config, globalConfig) {
	  config = _.clone(config || {});
	  globalConfig = globalConfig || {};

	  // defaults
	  this.protocol = 'http';
	  this.host = 'localhost';
	  this.path = '';
	  this.port = 9200;
	  this.query = null;
	  this.headers = null;
	  this.suggestCompression = !!globalConfig.suggestCompression;

	  this.ssl = _.defaults({}, config.ssl || {}, globalConfig.ssl || {}, sslDefaults);

	  if (typeof config === 'string') {
	    var firstColon = config.indexOf(':');
	    var firstSlash = config.indexOf('/');
	    var noSlash = firstSlash === -1;
	    var portNoPath = firstColon > -1 && noSlash;
	    var portWithPath = !portNoPath && firstColon < firstSlash;
	    if ((noSlash || portNoPath || portWithPath) && !startsWithProtocolRE.test(config)) {
	      config = defaultProto + '//' + config;
	    }
	    config = _.pick(url.parse(config, false, true), urlParseFields);
	    // default logic for the port is to use 9200 for the default. When a string is specified though,
	    // we will use the default from the protocol of the string.
	    if (!config.port) {
	      var proto = config.protocol || 'http';
	      if (proto.charAt(proto.length - 1) === ':') {
	        proto = proto.substring(0, proto.length - 1);
	      }
	      if (Host.defaultPorts[proto]) {
	        config.port = Host.defaultPorts[proto];
	      }
	    }
	  }

	  if (_.isObject(config)) {
	    // move hostname/portname to host/port semi-intelligently.
	    _.each(simplify, function (to) {
	      var from = to + 'name';
	      if (config[from] && config[to]) {
	        if (config[to].indexOf(config[from]) === 0) {
	          config[to] = config[from];
	        }
	      } else if (config[from]) {
	        config[to] = config[from];
	      }
	      delete config[from];
	    });
	  } else {
	    config = {};
	  }

	  if (!config.auth && globalConfig.httpAuth) {
	    config.auth = globalConfig.httpAuth
	  }

	  if (config.auth) {
	    config.headers = config.headers || {};
	    config.headers.Authorization = 'Basic ' + btoa(config.auth);
	    delete config.auth;
	  }

	  _.forOwn(config, _.bind(function (val, prop) {
	    if (val != null) this[prop] = _.clone(val);
	  }, this));

	  // make sure the query string is parsed
	  if (this.query === null) {
	    // majority case
	    this.query = {};
	  } else if (!_.isPlainObject(this.query)) {
	    this.query = qs.parse(this.query);
	  }

	  // make sure that the port is a number
	  if (_.isNumeric(this.port)) {
	    this.port = parseInt(this.port, 10);
	  } else {
	    this.port = 9200;
	  }

	  // make sure the path starts with a leading slash
	  if (this.path === '/') {
	    this.path = '';
	  } else if (this.path && this.path.charAt(0) !== '/') {
	    this.path = '/' + (this.path || '');
	  }

	  // strip trailing ':' on the protocol (when config comes from url.parse)
	  if (this.protocol.substr(-1) === ':') {
	    this.protocol = this.protocol.substring(0, this.protocol.length - 1);
	  }
	}

	Host.prototype.makeUrl = function (params) {
	  params = params || {};
	  // build the port
	  var port = '';
	  if (this.port !== Host.defaultPorts[this.protocol]) {
	    // add an actual port
	    port = ':' + this.port;
	  }

	  // build the path
	  var path = '' + (this.path || '') + (params.path || '');

	  // if path doesn't start with '/' add it.
	  if (path.charAt(0) !== '/') {
	    path = '/' + path;
	  }

	  // build the query string
	  var query = qs.stringify(this.getQuery(params.query));

	  if (this.host) {
	    return this.protocol + '://' + this.host + port + path + (query ? '?' + query : '');
	  } else {
	    return path + (query ? '?' + query : '');
	  }
	};

	function objectPropertyGetter(prop, preOverride) {
	  return function (overrides) {
	    if (preOverride) {
	      overrides = preOverride.call(this, overrides);
	    }

	    var obj = this[prop];
	    if (!obj && !overrides) {
	      return null;
	    }

	    if (overrides) {
	      obj = _.assign({}, obj, overrides);
	    }

	    return _.size(obj) ? obj : null;
	  };
	}

	Host.prototype.getHeaders = objectPropertyGetter('headers', function (overrides) {
	  if (!this.suggestCompression) {
	    return overrides;
	  }

	  return _.defaults(overrides || {}, {
	    'Accept-Encoding': 'gzip,deflate'
	  });
	});

	Host.prototype.getQuery = objectPropertyGetter('query', function (query) {
	  return typeof query === 'string' ? qs.parse(query) : query;
	});

	Host.prototype.toString = function () {
	  return this.makeUrl();
	};

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6).Buffer))

/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	'use strict';

	var punycode = __webpack_require__(21);
	var util = __webpack_require__(22);

	exports.parse = urlParse;
	exports.resolve = urlResolve;
	exports.resolveObject = urlResolveObject;
	exports.format = urlFormat;

	exports.Url = Url;

	function Url() {
	  this.protocol = null;
	  this.slashes = null;
	  this.auth = null;
	  this.host = null;
	  this.port = null;
	  this.hostname = null;
	  this.hash = null;
	  this.search = null;
	  this.query = null;
	  this.pathname = null;
	  this.path = null;
	  this.href = null;
	}

	// Reference: RFC 3986, RFC 1808, RFC 2396

	// define these here so at least they only have to be
	// compiled once on the first module load.
	var protocolPattern = /^([a-z0-9.+-]+:)/i,
	    portPattern = /:[0-9]*$/,

	    // Special case for a simple path URL
	    simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,

	    // RFC 2396: characters reserved for delimiting URLs.
	    // We actually just auto-escape these.
	    delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],

	    // RFC 2396: characters not allowed for various reasons.
	    unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),

	    // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
	    autoEscape = ['\''].concat(unwise),
	    // Characters that are never ever allowed in a hostname.
	    // Note that any invalid chars are also handled, but these
	    // are the ones that are *expected* to be seen, so we fast-path
	    // them.
	    nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
	    hostEndingChars = ['/', '?', '#'],
	    hostnameMaxLen = 255,
	    hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
	    hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
	    // protocols that can allow "unsafe" and "unwise" chars.
	    unsafeProtocol = {
	      'javascript': true,
	      'javascript:': true
	    },
	    // protocols that never have a hostname.
	    hostlessProtocol = {
	      'javascript': true,
	      'javascript:': true
	    },
	    // protocols that always contain a // bit.
	    slashedProtocol = {
	      'http': true,
	      'https': true,
	      'ftp': true,
	      'gopher': true,
	      'file': true,
	      'http:': true,
	      'https:': true,
	      'ftp:': true,
	      'gopher:': true,
	      'file:': true
	    },
	    querystring = __webpack_require__(23);

	function urlParse(url, parseQueryString, slashesDenoteHost) {
	  if (url && util.isObject(url) && url instanceof Url) return url;

	  var u = new Url;
	  u.parse(url, parseQueryString, slashesDenoteHost);
	  return u;
	}

	Url.prototype.parse = function(url, parseQueryString, slashesDenoteHost) {
	  if (!util.isString(url)) {
	    throw new TypeError("Parameter 'url' must be a string, not " + typeof url);
	  }

	  // Copy chrome, IE, opera backslash-handling behavior.
	  // Back slashes before the query string get converted to forward slashes
	  // See: https://code.google.com/p/chromium/issues/detail?id=25916
	  var queryIndex = url.indexOf('?'),
	      splitter =
	          (queryIndex !== -1 && queryIndex < url.indexOf('#')) ? '?' : '#',
	      uSplit = url.split(splitter),
	      slashRegex = /\\/g;
	  uSplit[0] = uSplit[0].replace(slashRegex, '/');
	  url = uSplit.join(splitter);

	  var rest = url;

	  // trim before proceeding.
	  // This is to support parse stuff like "  http://foo.com  \n"
	  rest = rest.trim();

	  if (!slashesDenoteHost && url.split('#').length === 1) {
	    // Try fast path regexp
	    var simplePath = simplePathPattern.exec(rest);
	    if (simplePath) {
	      this.path = rest;
	      this.href = rest;
	      this.pathname = simplePath[1];
	      if (simplePath[2]) {
	        this.search = simplePath[2];
	        if (parseQueryString) {
	          this.query = querystring.parse(this.search.substr(1));
	        } else {
	          this.query = this.search.substr(1);
	        }
	      } else if (parseQueryString) {
	        this.search = '';
	        this.query = {};
	      }
	      return this;
	    }
	  }

	  var proto = protocolPattern.exec(rest);
	  if (proto) {
	    proto = proto[0];
	    var lowerProto = proto.toLowerCase();
	    this.protocol = lowerProto;
	    rest = rest.substr(proto.length);
	  }

	  // figure out if it's got a host
	  // user@server is *always* interpreted as a hostname, and url
	  // resolution will treat //foo/bar as host=foo,path=bar because that's
	  // how the browser resolves relative URLs.
	  if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
	    var slashes = rest.substr(0, 2) === '//';
	    if (slashes && !(proto && hostlessProtocol[proto])) {
	      rest = rest.substr(2);
	      this.slashes = true;
	    }
	  }

	  if (!hostlessProtocol[proto] &&
	      (slashes || (proto && !slashedProtocol[proto]))) {

	    // there's a hostname.
	    // the first instance of /, ?, ;, or # ends the host.
	    //
	    // If there is an @ in the hostname, then non-host chars *are* allowed
	    // to the left of the last @ sign, unless some host-ending character
	    // comes *before* the @-sign.
	    // URLs are obnoxious.
	    //
	    // ex:
	    // http://a@b@c/ => user:a@b host:c
	    // http://a@b?@c => user:a host:c path:/?@c

	    // v0.12 TODO(isaacs): This is not quite how Chrome does things.
	    // Review our test case against browsers more comprehensively.

	    // find the first instance of any hostEndingChars
	    var hostEnd = -1;
	    for (var i = 0; i < hostEndingChars.length; i++) {
	      var hec = rest.indexOf(hostEndingChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
	        hostEnd = hec;
	    }

	    // at this point, either we have an explicit point where the
	    // auth portion cannot go past, or the last @ char is the decider.
	    var auth, atSign;
	    if (hostEnd === -1) {
	      // atSign can be anywhere.
	      atSign = rest.lastIndexOf('@');
	    } else {
	      // atSign must be in auth portion.
	      // http://a@b/c@d => host:b auth:a path:/c@d
	      atSign = rest.lastIndexOf('@', hostEnd);
	    }

	    // Now we have a portion which is definitely the auth.
	    // Pull that off.
	    if (atSign !== -1) {
	      auth = rest.slice(0, atSign);
	      rest = rest.slice(atSign + 1);
	      this.auth = decodeURIComponent(auth);
	    }

	    // the host is the remaining to the left of the first non-host char
	    hostEnd = -1;
	    for (var i = 0; i < nonHostChars.length; i++) {
	      var hec = rest.indexOf(nonHostChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
	        hostEnd = hec;
	    }
	    // if we still have not hit it, then the entire thing is a host.
	    if (hostEnd === -1)
	      hostEnd = rest.length;

	    this.host = rest.slice(0, hostEnd);
	    rest = rest.slice(hostEnd);

	    // pull out port.
	    this.parseHost();

	    // we've indicated that there is a hostname,
	    // so even if it's empty, it has to be present.
	    this.hostname = this.hostname || '';

	    // if hostname begins with [ and ends with ]
	    // assume that it's an IPv6 address.
	    var ipv6Hostname = this.hostname[0] === '[' &&
	        this.hostname[this.hostname.length - 1] === ']';

	    // validate a little.
	    if (!ipv6Hostname) {
	      var hostparts = this.hostname.split(/\./);
	      for (var i = 0, l = hostparts.length; i < l; i++) {
	        var part = hostparts[i];
	        if (!part) continue;
	        if (!part.match(hostnamePartPattern)) {
	          var newpart = '';
	          for (var j = 0, k = part.length; j < k; j++) {
	            if (part.charCodeAt(j) > 127) {
	              // we replace non-ASCII char with a temporary placeholder
	              // we need this to make sure size of hostname is not
	              // broken by replacing non-ASCII by nothing
	              newpart += 'x';
	            } else {
	              newpart += part[j];
	            }
	          }
	          // we test again with ASCII char only
	          if (!newpart.match(hostnamePartPattern)) {
	            var validParts = hostparts.slice(0, i);
	            var notHost = hostparts.slice(i + 1);
	            var bit = part.match(hostnamePartStart);
	            if (bit) {
	              validParts.push(bit[1]);
	              notHost.unshift(bit[2]);
	            }
	            if (notHost.length) {
	              rest = '/' + notHost.join('.') + rest;
	            }
	            this.hostname = validParts.join('.');
	            break;
	          }
	        }
	      }
	    }

	    if (this.hostname.length > hostnameMaxLen) {
	      this.hostname = '';
	    } else {
	      // hostnames are always lower case.
	      this.hostname = this.hostname.toLowerCase();
	    }

	    if (!ipv6Hostname) {
	      // IDNA Support: Returns a punycoded representation of "domain".
	      // It only converts parts of the domain name that
	      // have non-ASCII characters, i.e. it doesn't matter if
	      // you call it with a domain that already is ASCII-only.
	      this.hostname = punycode.toASCII(this.hostname);
	    }

	    var p = this.port ? ':' + this.port : '';
	    var h = this.hostname || '';
	    this.host = h + p;
	    this.href += this.host;

	    // strip [ and ] from the hostname
	    // the host field still retains them, though
	    if (ipv6Hostname) {
	      this.hostname = this.hostname.substr(1, this.hostname.length - 2);
	      if (rest[0] !== '/') {
	        rest = '/' + rest;
	      }
	    }
	  }

	  // now rest is set to the post-host stuff.
	  // chop off any delim chars.
	  if (!unsafeProtocol[lowerProto]) {

	    // First, make 100% sure that any "autoEscape" chars get
	    // escaped, even if encodeURIComponent doesn't think they
	    // need to be.
	    for (var i = 0, l = autoEscape.length; i < l; i++) {
	      var ae = autoEscape[i];
	      if (rest.indexOf(ae) === -1)
	        continue;
	      var esc = encodeURIComponent(ae);
	      if (esc === ae) {
	        esc = escape(ae);
	      }
	      rest = rest.split(ae).join(esc);
	    }
	  }


	  // chop off from the tail first.
	  var hash = rest.indexOf('#');
	  if (hash !== -1) {
	    // got a fragment string.
	    this.hash = rest.substr(hash);
	    rest = rest.slice(0, hash);
	  }
	  var qm = rest.indexOf('?');
	  if (qm !== -1) {
	    this.search = rest.substr(qm);
	    this.query = rest.substr(qm + 1);
	    if (parseQueryString) {
	      this.query = querystring.parse(this.query);
	    }
	    rest = rest.slice(0, qm);
	  } else if (parseQueryString) {
	    // no query string, but parseQueryString still requested
	    this.search = '';
	    this.query = {};
	  }
	  if (rest) this.pathname = rest;
	  if (slashedProtocol[lowerProto] &&
	      this.hostname && !this.pathname) {
	    this.pathname = '/';
	  }

	  //to support http.request
	  if (this.pathname || this.search) {
	    var p = this.pathname || '';
	    var s = this.search || '';
	    this.path = p + s;
	  }

	  // finally, reconstruct the href based on what has been validated.
	  this.href = this.format();
	  return this;
	};

	// format a parsed object into a url string
	function urlFormat(obj) {
	  // ensure it's an object, and not a string url.
	  // If it's an obj, this is a no-op.
	  // this way, you can call url_format() on strings
	  // to clean up potentially wonky urls.
	  if (util.isString(obj)) obj = urlParse(obj);
	  if (!(obj instanceof Url)) return Url.prototype.format.call(obj);
	  return obj.format();
	}

	Url.prototype.format = function() {
	  var auth = this.auth || '';
	  if (auth) {
	    auth = encodeURIComponent(auth);
	    auth = auth.replace(/%3A/i, ':');
	    auth += '@';
	  }

	  var protocol = this.protocol || '',
	      pathname = this.pathname || '',
	      hash = this.hash || '',
	      host = false,
	      query = '';

	  if (this.host) {
	    host = auth + this.host;
	  } else if (this.hostname) {
	    host = auth + (this.hostname.indexOf(':') === -1 ?
	        this.hostname :
	        '[' + this.hostname + ']');
	    if (this.port) {
	      host += ':' + this.port;
	    }
	  }

	  if (this.query &&
	      util.isObject(this.query) &&
	      Object.keys(this.query).length) {
	    query = querystring.stringify(this.query);
	  }

	  var search = this.search || (query && ('?' + query)) || '';

	  if (protocol && protocol.substr(-1) !== ':') protocol += ':';

	  // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
	  // unless they had them to begin with.
	  if (this.slashes ||
	      (!protocol || slashedProtocol[protocol]) && host !== false) {
	    host = '//' + (host || '');
	    if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
	  } else if (!host) {
	    host = '';
	  }

	  if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
	  if (search && search.charAt(0) !== '?') search = '?' + search;

	  pathname = pathname.replace(/[?#]/g, function(match) {
	    return encodeURIComponent(match);
	  });
	  search = search.replace('#', '%23');

	  return protocol + host + pathname + search + hash;
	};

	function urlResolve(source, relative) {
	  return urlParse(source, false, true).resolve(relative);
	}

	Url.prototype.resolve = function(relative) {
	  return this.resolveObject(urlParse(relative, false, true)).format();
	};

	function urlResolveObject(source, relative) {
	  if (!source) return relative;
	  return urlParse(source, false, true).resolveObject(relative);
	}

	Url.prototype.resolveObject = function(relative) {
	  if (util.isString(relative)) {
	    var rel = new Url();
	    rel.parse(relative, false, true);
	    relative = rel;
	  }

	  var result = new Url();
	  var tkeys = Object.keys(this);
	  for (var tk = 0; tk < tkeys.length; tk++) {
	    var tkey = tkeys[tk];
	    result[tkey] = this[tkey];
	  }

	  // hash is always overridden, no matter what.
	  // even href="" will remove it.
	  result.hash = relative.hash;

	  // if the relative url is empty, then there's nothing left to do here.
	  if (relative.href === '') {
	    result.href = result.format();
	    return result;
	  }

	  // hrefs like //foo/bar always cut to the protocol.
	  if (relative.slashes && !relative.protocol) {
	    // take everything except the protocol from relative
	    var rkeys = Object.keys(relative);
	    for (var rk = 0; rk < rkeys.length; rk++) {
	      var rkey = rkeys[rk];
	      if (rkey !== 'protocol')
	        result[rkey] = relative[rkey];
	    }

	    //urlParse appends trailing / to urls like http://www.example.com
	    if (slashedProtocol[result.protocol] &&
	        result.hostname && !result.pathname) {
	      result.path = result.pathname = '/';
	    }

	    result.href = result.format();
	    return result;
	  }

	  if (relative.protocol && relative.protocol !== result.protocol) {
	    // if it's a known url protocol, then changing
	    // the protocol does weird things
	    // first, if it's not file:, then we MUST have a host,
	    // and if there was a path
	    // to begin with, then we MUST have a path.
	    // if it is file:, then the host is dropped,
	    // because that's known to be hostless.
	    // anything else is assumed to be absolute.
	    if (!slashedProtocol[relative.protocol]) {
	      var keys = Object.keys(relative);
	      for (var v = 0; v < keys.length; v++) {
	        var k = keys[v];
	        result[k] = relative[k];
	      }
	      result.href = result.format();
	      return result;
	    }

	    result.protocol = relative.protocol;
	    if (!relative.host && !hostlessProtocol[relative.protocol]) {
	      var relPath = (relative.pathname || '').split('/');
	      while (relPath.length && !(relative.host = relPath.shift()));
	      if (!relative.host) relative.host = '';
	      if (!relative.hostname) relative.hostname = '';
	      if (relPath[0] !== '') relPath.unshift('');
	      if (relPath.length < 2) relPath.unshift('');
	      result.pathname = relPath.join('/');
	    } else {
	      result.pathname = relative.pathname;
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    result.host = relative.host || '';
	    result.auth = relative.auth;
	    result.hostname = relative.hostname || relative.host;
	    result.port = relative.port;
	    // to support http.request
	    if (result.pathname || result.search) {
	      var p = result.pathname || '';
	      var s = result.search || '';
	      result.path = p + s;
	    }
	    result.slashes = result.slashes || relative.slashes;
	    result.href = result.format();
	    return result;
	  }

	  var isSourceAbs = (result.pathname && result.pathname.charAt(0) === '/'),
	      isRelAbs = (
	          relative.host ||
	          relative.pathname && relative.pathname.charAt(0) === '/'
	      ),
	      mustEndAbs = (isRelAbs || isSourceAbs ||
	                    (result.host && relative.pathname)),
	      removeAllDots = mustEndAbs,
	      srcPath = result.pathname && result.pathname.split('/') || [],
	      relPath = relative.pathname && relative.pathname.split('/') || [],
	      psychotic = result.protocol && !slashedProtocol[result.protocol];

	  // if the url is a non-slashed url, then relative
	  // links like ../.. should be able
	  // to crawl up to the hostname, as well.  This is strange.
	  // result.protocol has already been set by now.
	  // Later on, put the first path part into the host field.
	  if (psychotic) {
	    result.hostname = '';
	    result.port = null;
	    if (result.host) {
	      if (srcPath[0] === '') srcPath[0] = result.host;
	      else srcPath.unshift(result.host);
	    }
	    result.host = '';
	    if (relative.protocol) {
	      relative.hostname = null;
	      relative.port = null;
	      if (relative.host) {
	        if (relPath[0] === '') relPath[0] = relative.host;
	        else relPath.unshift(relative.host);
	      }
	      relative.host = null;
	    }
	    mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
	  }

	  if (isRelAbs) {
	    // it's absolute.
	    result.host = (relative.host || relative.host === '') ?
	                  relative.host : result.host;
	    result.hostname = (relative.hostname || relative.hostname === '') ?
	                      relative.hostname : result.hostname;
	    result.search = relative.search;
	    result.query = relative.query;
	    srcPath = relPath;
	    // fall through to the dot-handling below.
	  } else if (relPath.length) {
	    // it's relative
	    // throw away the existing file, and take the new path instead.
	    if (!srcPath) srcPath = [];
	    srcPath.pop();
	    srcPath = srcPath.concat(relPath);
	    result.search = relative.search;
	    result.query = relative.query;
	  } else if (!util.isNullOrUndefined(relative.search)) {
	    // just pull out the search.
	    // like href='?foo'.
	    // Put this after the other two cases because it simplifies the booleans
	    if (psychotic) {
	      result.hostname = result.host = srcPath.shift();
	      //occationaly the auth can get stuck only in host
	      //this especially happens in cases like
	      //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	      var authInHost = result.host && result.host.indexOf('@') > 0 ?
	                       result.host.split('@') : false;
	      if (authInHost) {
	        result.auth = authInHost.shift();
	        result.host = result.hostname = authInHost.shift();
	      }
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    //to support http.request
	    if (!util.isNull(result.pathname) || !util.isNull(result.search)) {
	      result.path = (result.pathname ? result.pathname : '') +
	                    (result.search ? result.search : '');
	    }
	    result.href = result.format();
	    return result;
	  }

	  if (!srcPath.length) {
	    // no path at all.  easy.
	    // we've already handled the other stuff above.
	    result.pathname = null;
	    //to support http.request
	    if (result.search) {
	      result.path = '/' + result.search;
	    } else {
	      result.path = null;
	    }
	    result.href = result.format();
	    return result;
	  }

	  // if a url ENDs in . or .., then it must get a trailing slash.
	  // however, if it ends in anything else non-slashy,
	  // then it must NOT get a trailing slash.
	  var last = srcPath.slice(-1)[0];
	  var hasTrailingSlash = (
	      (result.host || relative.host || srcPath.length > 1) &&
	      (last === '.' || last === '..') || last === '');

	  // strip single dots, resolve double dots to parent dir
	  // if the path tries to go above the root, `up` ends up > 0
	  var up = 0;
	  for (var i = srcPath.length; i >= 0; i--) {
	    last = srcPath[i];
	    if (last === '.') {
	      srcPath.splice(i, 1);
	    } else if (last === '..') {
	      srcPath.splice(i, 1);
	      up++;
	    } else if (up) {
	      srcPath.splice(i, 1);
	      up--;
	    }
	  }

	  // if the path is allowed to go above the root, restore leading ..s
	  if (!mustEndAbs && !removeAllDots) {
	    for (; up--; up) {
	      srcPath.unshift('..');
	    }
	  }

	  if (mustEndAbs && srcPath[0] !== '' &&
	      (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
	    srcPath.unshift('');
	  }

	  if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
	    srcPath.push('');
	  }

	  var isAbsolute = srcPath[0] === '' ||
	      (srcPath[0] && srcPath[0].charAt(0) === '/');

	  // put the host back
	  if (psychotic) {
	    result.hostname = result.host = isAbsolute ? '' :
	                                    srcPath.length ? srcPath.shift() : '';
	    //occationaly the auth can get stuck only in host
	    //this especially happens in cases like
	    //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	    var authInHost = result.host && result.host.indexOf('@') > 0 ?
	                     result.host.split('@') : false;
	    if (authInHost) {
	      result.auth = authInHost.shift();
	      result.host = result.hostname = authInHost.shift();
	    }
	  }

	  mustEndAbs = mustEndAbs || (result.host && srcPath.length);

	  if (mustEndAbs && !isAbsolute) {
	    srcPath.unshift('');
	  }

	  if (!srcPath.length) {
	    result.pathname = null;
	    result.path = null;
	  } else {
	    result.pathname = srcPath.join('/');
	  }

	  //to support request.http
	  if (!util.isNull(result.pathname) || !util.isNull(result.search)) {
	    result.path = (result.pathname ? result.pathname : '') +
	                  (result.search ? result.search : '');
	  }
	  result.auth = relative.auth || result.auth;
	  result.slashes = result.slashes || relative.slashes;
	  result.href = result.format();
	  return result;
	};

	Url.prototype.parseHost = function() {
	  var host = this.host;
	  var port = portPattern.exec(host);
	  if (port) {
	    port = port[0];
	    if (port !== ':') {
	      this.port = port.substr(1);
	    }
	    host = host.substr(0, host.length - port.length);
	  }
	  if (host) this.hostname = host;
	};


/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(module, global) {/*! https://mths.be/punycode v1.3.2 by @mathias */
	;(function(root) {

		/** Detect free variables */
		var freeExports = typeof exports == 'object' && exports &&
			!exports.nodeType && exports;
		var freeModule = typeof module == 'object' && module &&
			!module.nodeType && module;
		var freeGlobal = typeof global == 'object' && global;
		if (
			freeGlobal.global === freeGlobal ||
			freeGlobal.window === freeGlobal ||
			freeGlobal.self === freeGlobal
		) {
			root = freeGlobal;
		}

		/**
		 * The `punycode` object.
		 * @name punycode
		 * @type Object
		 */
		var punycode,

		/** Highest positive signed 32-bit float value */
		maxInt = 2147483647, // aka. 0x7FFFFFFF or 2^31-1

		/** Bootstring parameters */
		base = 36,
		tMin = 1,
		tMax = 26,
		skew = 38,
		damp = 700,
		initialBias = 72,
		initialN = 128, // 0x80
		delimiter = '-', // '\x2D'

		/** Regular expressions */
		regexPunycode = /^xn--/,
		regexNonASCII = /[^\x20-\x7E]/, // unprintable ASCII chars + non-ASCII chars
		regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, // RFC 3490 separators

		/** Error messages */
		errors = {
			'overflow': 'Overflow: input needs wider integers to process',
			'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
			'invalid-input': 'Invalid input'
		},

		/** Convenience shortcuts */
		baseMinusTMin = base - tMin,
		floor = Math.floor,
		stringFromCharCode = String.fromCharCode,

		/** Temporary variable */
		key;

		/*--------------------------------------------------------------------------*/

		/**
		 * A generic error utility function.
		 * @private
		 * @param {String} type The error type.
		 * @returns {Error} Throws a `RangeError` with the applicable error message.
		 */
		function error(type) {
			throw RangeError(errors[type]);
		}

		/**
		 * A generic `Array#map` utility function.
		 * @private
		 * @param {Array} array The array to iterate over.
		 * @param {Function} callback The function that gets called for every array
		 * item.
		 * @returns {Array} A new array of values returned by the callback function.
		 */
		function map(array, fn) {
			var length = array.length;
			var result = [];
			while (length--) {
				result[length] = fn(array[length]);
			}
			return result;
		}

		/**
		 * A simple `Array#map`-like wrapper to work with domain name strings or email
		 * addresses.
		 * @private
		 * @param {String} domain The domain name or email address.
		 * @param {Function} callback The function that gets called for every
		 * character.
		 * @returns {Array} A new string of characters returned by the callback
		 * function.
		 */
		function mapDomain(string, fn) {
			var parts = string.split('@');
			var result = '';
			if (parts.length > 1) {
				// In email addresses, only the domain name should be punycoded. Leave
				// the local part (i.e. everything up to `@`) intact.
				result = parts[0] + '@';
				string = parts[1];
			}
			// Avoid `split(regex)` for IE8 compatibility. See #17.
			string = string.replace(regexSeparators, '\x2E');
			var labels = string.split('.');
			var encoded = map(labels, fn).join('.');
			return result + encoded;
		}

		/**
		 * Creates an array containing the numeric code points of each Unicode
		 * character in the string. While JavaScript uses UCS-2 internally,
		 * this function will convert a pair of surrogate halves (each of which
		 * UCS-2 exposes as separate characters) into a single code point,
		 * matching UTF-16.
		 * @see `punycode.ucs2.encode`
		 * @see <https://mathiasbynens.be/notes/javascript-encoding>
		 * @memberOf punycode.ucs2
		 * @name decode
		 * @param {String} string The Unicode input string (UCS-2).
		 * @returns {Array} The new array of code points.
		 */
		function ucs2decode(string) {
			var output = [],
			    counter = 0,
			    length = string.length,
			    value,
			    extra;
			while (counter < length) {
				value = string.charCodeAt(counter++);
				if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
					// high surrogate, and there is a next character
					extra = string.charCodeAt(counter++);
					if ((extra & 0xFC00) == 0xDC00) { // low surrogate
						output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
					} else {
						// unmatched surrogate; only append this code unit, in case the next
						// code unit is the high surrogate of a surrogate pair
						output.push(value);
						counter--;
					}
				} else {
					output.push(value);
				}
			}
			return output;
		}

		/**
		 * Creates a string based on an array of numeric code points.
		 * @see `punycode.ucs2.decode`
		 * @memberOf punycode.ucs2
		 * @name encode
		 * @param {Array} codePoints The array of numeric code points.
		 * @returns {String} The new Unicode string (UCS-2).
		 */
		function ucs2encode(array) {
			return map(array, function(value) {
				var output = '';
				if (value > 0xFFFF) {
					value -= 0x10000;
					output += stringFromCharCode(value >>> 10 & 0x3FF | 0xD800);
					value = 0xDC00 | value & 0x3FF;
				}
				output += stringFromCharCode(value);
				return output;
			}).join('');
		}

		/**
		 * Converts a basic code point into a digit/integer.
		 * @see `digitToBasic()`
		 * @private
		 * @param {Number} codePoint The basic numeric code point value.
		 * @returns {Number} The numeric value of a basic code point (for use in
		 * representing integers) in the range `0` to `base - 1`, or `base` if
		 * the code point does not represent a value.
		 */
		function basicToDigit(codePoint) {
			if (codePoint - 48 < 10) {
				return codePoint - 22;
			}
			if (codePoint - 65 < 26) {
				return codePoint - 65;
			}
			if (codePoint - 97 < 26) {
				return codePoint - 97;
			}
			return base;
		}

		/**
		 * Converts a digit/integer into a basic code point.
		 * @see `basicToDigit()`
		 * @private
		 * @param {Number} digit The numeric value of a basic code point.
		 * @returns {Number} The basic code point whose value (when used for
		 * representing integers) is `digit`, which needs to be in the range
		 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
		 * used; else, the lowercase form is used. The behavior is undefined
		 * if `flag` is non-zero and `digit` has no uppercase form.
		 */
		function digitToBasic(digit, flag) {
			//  0..25 map to ASCII a..z or A..Z
			// 26..35 map to ASCII 0..9
			return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
		}

		/**
		 * Bias adaptation function as per section 3.4 of RFC 3492.
		 * http://tools.ietf.org/html/rfc3492#section-3.4
		 * @private
		 */
		function adapt(delta, numPoints, firstTime) {
			var k = 0;
			delta = firstTime ? floor(delta / damp) : delta >> 1;
			delta += floor(delta / numPoints);
			for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
				delta = floor(delta / baseMinusTMin);
			}
			return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
		}

		/**
		 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
		 * symbols.
		 * @memberOf punycode
		 * @param {String} input The Punycode string of ASCII-only symbols.
		 * @returns {String} The resulting string of Unicode symbols.
		 */
		function decode(input) {
			// Don't use UCS-2
			var output = [],
			    inputLength = input.length,
			    out,
			    i = 0,
			    n = initialN,
			    bias = initialBias,
			    basic,
			    j,
			    index,
			    oldi,
			    w,
			    k,
			    digit,
			    t,
			    /** Cached calculation results */
			    baseMinusT;

			// Handle the basic code points: let `basic` be the number of input code
			// points before the last delimiter, or `0` if there is none, then copy
			// the first basic code points to the output.

			basic = input.lastIndexOf(delimiter);
			if (basic < 0) {
				basic = 0;
			}

			for (j = 0; j < basic; ++j) {
				// if it's not a basic code point
				if (input.charCodeAt(j) >= 0x80) {
					error('not-basic');
				}
				output.push(input.charCodeAt(j));
			}

			// Main decoding loop: start just after the last delimiter if any basic code
			// points were copied; start at the beginning otherwise.

			for (index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {

				// `index` is the index of the next character to be consumed.
				// Decode a generalized variable-length integer into `delta`,
				// which gets added to `i`. The overflow checking is easier
				// if we increase `i` as we go, then subtract off its starting
				// value at the end to obtain `delta`.
				for (oldi = i, w = 1, k = base; /* no condition */; k += base) {

					if (index >= inputLength) {
						error('invalid-input');
					}

					digit = basicToDigit(input.charCodeAt(index++));

					if (digit >= base || digit > floor((maxInt - i) / w)) {
						error('overflow');
					}

					i += digit * w;
					t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);

					if (digit < t) {
						break;
					}

					baseMinusT = base - t;
					if (w > floor(maxInt / baseMinusT)) {
						error('overflow');
					}

					w *= baseMinusT;

				}

				out = output.length + 1;
				bias = adapt(i - oldi, out, oldi == 0);

				// `i` was supposed to wrap around from `out` to `0`,
				// incrementing `n` each time, so we'll fix that now:
				if (floor(i / out) > maxInt - n) {
					error('overflow');
				}

				n += floor(i / out);
				i %= out;

				// Insert `n` at position `i` of the output
				output.splice(i++, 0, n);

			}

			return ucs2encode(output);
		}

		/**
		 * Converts a string of Unicode symbols (e.g. a domain name label) to a
		 * Punycode string of ASCII-only symbols.
		 * @memberOf punycode
		 * @param {String} input The string of Unicode symbols.
		 * @returns {String} The resulting Punycode string of ASCII-only symbols.
		 */
		function encode(input) {
			var n,
			    delta,
			    handledCPCount,
			    basicLength,
			    bias,
			    j,
			    m,
			    q,
			    k,
			    t,
			    currentValue,
			    output = [],
			    /** `inputLength` will hold the number of code points in `input`. */
			    inputLength,
			    /** Cached calculation results */
			    handledCPCountPlusOne,
			    baseMinusT,
			    qMinusT;

			// Convert the input in UCS-2 to Unicode
			input = ucs2decode(input);

			// Cache the length
			inputLength = input.length;

			// Initialize the state
			n = initialN;
			delta = 0;
			bias = initialBias;

			// Handle the basic code points
			for (j = 0; j < inputLength; ++j) {
				currentValue = input[j];
				if (currentValue < 0x80) {
					output.push(stringFromCharCode(currentValue));
				}
			}

			handledCPCount = basicLength = output.length;

			// `handledCPCount` is the number of code points that have been handled;
			// `basicLength` is the number of basic code points.

			// Finish the basic string - if it is not empty - with a delimiter
			if (basicLength) {
				output.push(delimiter);
			}

			// Main encoding loop:
			while (handledCPCount < inputLength) {

				// All non-basic code points < n have been handled already. Find the next
				// larger one:
				for (m = maxInt, j = 0; j < inputLength; ++j) {
					currentValue = input[j];
					if (currentValue >= n && currentValue < m) {
						m = currentValue;
					}
				}

				// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
				// but guard against overflow
				handledCPCountPlusOne = handledCPCount + 1;
				if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
					error('overflow');
				}

				delta += (m - n) * handledCPCountPlusOne;
				n = m;

				for (j = 0; j < inputLength; ++j) {
					currentValue = input[j];

					if (currentValue < n && ++delta > maxInt) {
						error('overflow');
					}

					if (currentValue == n) {
						// Represent delta as a generalized variable-length integer
						for (q = delta, k = base; /* no condition */; k += base) {
							t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
							if (q < t) {
								break;
							}
							qMinusT = q - t;
							baseMinusT = base - t;
							output.push(
								stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
							);
							q = floor(qMinusT / baseMinusT);
						}

						output.push(stringFromCharCode(digitToBasic(q, 0)));
						bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
						delta = 0;
						++handledCPCount;
					}
				}

				++delta;
				++n;

			}
			return output.join('');
		}

		/**
		 * Converts a Punycode string representing a domain name or an email address
		 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
		 * it doesn't matter if you call it on a string that has already been
		 * converted to Unicode.
		 * @memberOf punycode
		 * @param {String} input The Punycoded domain name or email address to
		 * convert to Unicode.
		 * @returns {String} The Unicode representation of the given Punycode
		 * string.
		 */
		function toUnicode(input) {
			return mapDomain(input, function(string) {
				return regexPunycode.test(string)
					? decode(string.slice(4).toLowerCase())
					: string;
			});
		}

		/**
		 * Converts a Unicode string representing a domain name or an email address to
		 * Punycode. Only the non-ASCII parts of the domain name will be converted,
		 * i.e. it doesn't matter if you call it with a domain that's already in
		 * ASCII.
		 * @memberOf punycode
		 * @param {String} input The domain name or email address to convert, as a
		 * Unicode string.
		 * @returns {String} The Punycode representation of the given domain name or
		 * email address.
		 */
		function toASCII(input) {
			return mapDomain(input, function(string) {
				return regexNonASCII.test(string)
					? 'xn--' + encode(string)
					: string;
			});
		}

		/*--------------------------------------------------------------------------*/

		/** Define the public API */
		punycode = {
			/**
			 * A string representing the current Punycode.js version number.
			 * @memberOf punycode
			 * @type String
			 */
			'version': '1.3.2',
			/**
			 * An object of methods to convert from JavaScript's internal character
			 * representation (UCS-2) to Unicode code points, and back.
			 * @see <https://mathiasbynens.be/notes/javascript-encoding>
			 * @memberOf punycode
			 * @type Object
			 */
			'ucs2': {
				'decode': ucs2decode,
				'encode': ucs2encode
			},
			'decode': decode,
			'encode': encode,
			'toASCII': toASCII,
			'toUnicode': toUnicode
		};

		/** Expose `punycode` */
		// Some AMD build optimizers, like r.js, check for specific condition patterns
		// like the following:
		if (
			true
		) {
			!(__WEBPACK_AMD_DEFINE_RESULT__ = function() {
				return punycode;
			}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
		} else if (freeExports && freeModule) {
			if (module.exports == freeExports) { // in Node.js or RingoJS v0.8.0+
				freeModule.exports = punycode;
			} else { // in Narwhal or RingoJS v0.7.0-
				for (key in punycode) {
					punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
				}
			}
		} else { // in Rhino or a web browser
			root.punycode = punycode;
		}

	}(this));

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15)(module), (function() { return this; }())))

/***/ },
/* 22 */
/***/ function(module, exports) {

	'use strict';

	module.exports = {
	  isString: function(arg) {
	    return typeof(arg) === 'string';
	  },
	  isObject: function(arg) {
	    return typeof(arg) === 'object' && arg !== null;
	  },
	  isNull: function(arg) {
	    return arg === null;
	  },
	  isNullOrUndefined: function(arg) {
	    return arg == null;
	  }
	};


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	exports.decode = exports.parse = __webpack_require__(24);
	exports.encode = exports.stringify = __webpack_require__(25);


/***/ },
/* 24 */
/***/ function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	'use strict';

	// If obj.hasOwnProperty has been overridden, then calling
	// obj.hasOwnProperty(prop) will break.
	// See: https://github.com/joyent/node/issues/1707
	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}

	module.exports = function(qs, sep, eq, options) {
	  sep = sep || '&';
	  eq = eq || '=';
	  var obj = {};

	  if (typeof qs !== 'string' || qs.length === 0) {
	    return obj;
	  }

	  var regexp = /\+/g;
	  qs = qs.split(sep);

	  var maxKeys = 1000;
	  if (options && typeof options.maxKeys === 'number') {
	    maxKeys = options.maxKeys;
	  }

	  var len = qs.length;
	  // maxKeys <= 0 means that we should not limit keys count
	  if (maxKeys > 0 && len > maxKeys) {
	    len = maxKeys;
	  }

	  for (var i = 0; i < len; ++i) {
	    var x = qs[i].replace(regexp, '%20'),
	        idx = x.indexOf(eq),
	        kstr, vstr, k, v;

	    if (idx >= 0) {
	      kstr = x.substr(0, idx);
	      vstr = x.substr(idx + 1);
	    } else {
	      kstr = x;
	      vstr = '';
	    }

	    k = decodeURIComponent(kstr);
	    v = decodeURIComponent(vstr);

	    if (!hasOwnProperty(obj, k)) {
	      obj[k] = v;
	    } else if (Array.isArray(obj[k])) {
	      obj[k].push(v);
	    } else {
	      obj[k] = [obj[k], v];
	    }
	  }

	  return obj;
	};


/***/ },
/* 25 */
/***/ function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	'use strict';

	var stringifyPrimitive = function(v) {
	  switch (typeof v) {
	    case 'string':
	      return v;

	    case 'boolean':
	      return v ? 'true' : 'false';

	    case 'number':
	      return isFinite(v) ? v : '';

	    default:
	      return '';
	  }
	};

	module.exports = function(obj, sep, eq, name) {
	  sep = sep || '&';
	  eq = eq || '=';
	  if (obj === null) {
	    obj = undefined;
	  }

	  if (typeof obj === 'object') {
	    return Object.keys(obj).map(function(k) {
	      var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;
	      if (Array.isArray(obj[k])) {
	        return obj[k].map(function(v) {
	          return ks + encodeURIComponent(stringifyPrimitive(v));
	        }).join(sep);
	      } else {
	        return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
	      }
	    }).join(sep);

	  }

	  if (!name) return '';
	  return encodeURIComponent(stringifyPrimitive(name)) + eq +
	         encodeURIComponent(stringifyPrimitive(obj));
	};


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(5);


	/**
	 * Patch the transport's connection pool to schedule a sniff after a connection fails.
	 * When a connection fails for the first time it will schedule a sniff 1 second in the
	 * future, and increase the timeout based on the deadTimeout algorithm chosen by the
	 * connectionPool, and the number of times the sniff has failed.
	 *
	 * @param  {Transport} transport - the transport that will be using this behavior
	 * @return {undefined}
	 */
	module.exports = function setupSniffOnConnectionFault(transport) {
	  var failures = 0;
	  var pool = transport.connectionPool;
	  var originalOnDied = pool._onConnectionDied;

	  // do the actual sniff, if the sniff is unable to
	  // connect to a node this function will be called again by the connectionPool
	  var work = function () {
	    work.timerId = transport._timeout(work.timerId);
	    transport.sniff();
	  };

	  // create a function that will count down to a
	  // point n milliseconds into the future
	  var countdownTo = function (ms) {
	    var start = _.now();
	    return function () {
	      return start - ms;
	    };
	  };

	  // overwrite the function, but still call it
	  pool._onConnectionDied = function (connection, wasAlreadyDead) {
	    var ret = originalOnDied.call(pool, connection, wasAlreadyDead);

	    // clear the failures if this is the first failure we have seen
	    failures = work.timerId ? failures + 1 : 0;

	    var ms = pool.calcDeadTimeout(failures, 1000);

	    if (work.timerId && ms < work.timerId && work.countdown()) {
	      // clear the timer
	      work.timerId = transport._timeout(work.timerId);
	    }

	    if (!work.timerId) {
	      work.timerId = transport._timeout(work, ms);
	      work.countdown = countdownTo(ms);
	    }

	    return ret;
	  };

	  pool._onConnectionDied.restore = function () {
	    pool._onConnectionDied = originalOnDied;
	  };
	};


/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	var isEmpty = __webpack_require__(28);

	module.exports = function (hosts) {
	  if (isEmpty(hosts)) return false;

	  var commonProtocol = hosts.shift().protocol;
	  for (var i = 0; i < hosts.length; i++) {
	    if (commonProtocol !== hosts[i].protocol) {
	      return false;
	    }
	  }

	  return commonProtocol;
	}


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, module) {/**
	 * lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="npm" -o ./`
	 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER = 9007199254740991;

	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]',
	    funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]',
	    mapTag = '[object Map]',
	    objectTag = '[object Object]',
	    promiseTag = '[object Promise]',
	    setTag = '[object Set]',
	    weakMapTag = '[object WeakMap]';

	var dataViewTag = '[object DataView]';

	/**
	 * Used to match `RegExp`
	 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
	 */
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

	/** Used to detect host constructors (Safari). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;

	/** Detect free variable `global` from Node.js. */
	var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

	/** Detect free variable `self`. */
	var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

	/** Used as a reference to the global object. */
	var root = freeGlobal || freeSelf || Function('return this')();

	/** Detect free variable `exports`. */
	var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

	/** Detect free variable `module`. */
	var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

	/** Detect the popular CommonJS extension `module.exports`. */
	var moduleExports = freeModule && freeModule.exports === freeExports;

	/**
	 * Gets the value at `key` of `object`.
	 *
	 * @private
	 * @param {Object} [object] The object to query.
	 * @param {string} key The key of the property to get.
	 * @returns {*} Returns the property value.
	 */
	function getValue(object, key) {
	  return object == null ? undefined : object[key];
	}

	/**
	 * Checks if `value` is a host object in IE < 9.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
	 */
	function isHostObject(value) {
	  // Many host objects are `Object` objects that can coerce to strings
	  // despite having improperly defined `toString` methods.
	  var result = false;
	  if (value != null && typeof value.toString != 'function') {
	    try {
	      result = !!(value + '');
	    } catch (e) {}
	  }
	  return result;
	}

	/**
	 * Creates a unary function that invokes `func` with its argument transformed.
	 *
	 * @private
	 * @param {Function} func The function to wrap.
	 * @param {Function} transform The argument transform.
	 * @returns {Function} Returns the new function.
	 */
	function overArg(func, transform) {
	  return function(arg) {
	    return func(transform(arg));
	  };
	}

	/** Used for built-in method references. */
	var funcProto = Function.prototype,
	    objectProto = Object.prototype;

	/** Used to detect overreaching core-js shims. */
	var coreJsData = root['__core-js_shared__'];

	/** Used to detect methods masquerading as native. */
	var maskSrcKey = (function() {
	  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
	  return uid ? ('Symbol(src)_1.' + uid) : '';
	}());

	/** Used to resolve the decompiled source of functions. */
	var funcToString = funcProto.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;

	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);

	/** Built-in value references. */
	var Buffer = moduleExports ? root.Buffer : undefined,
	    propertyIsEnumerable = objectProto.propertyIsEnumerable;

	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
	    nativeKeys = overArg(Object.keys, Object);

	/* Built-in method references that are verified to be native. */
	var DataView = getNative(root, 'DataView'),
	    Map = getNative(root, 'Map'),
	    Promise = getNative(root, 'Promise'),
	    Set = getNative(root, 'Set'),
	    WeakMap = getNative(root, 'WeakMap');

	/** Detect if properties shadowing those on `Object.prototype` are non-enumerable. */
	var nonEnumShadows = !propertyIsEnumerable.call({ 'valueOf': 1 }, 'valueOf');

	/** Used to detect maps, sets, and weakmaps. */
	var dataViewCtorString = toSource(DataView),
	    mapCtorString = toSource(Map),
	    promiseCtorString = toSource(Promise),
	    setCtorString = toSource(Set),
	    weakMapCtorString = toSource(WeakMap);

	/**
	 * The base implementation of `getTag`.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the `toStringTag`.
	 */
	function baseGetTag(value) {
	  return objectToString.call(value);
	}

	/**
	 * The base implementation of `_.isNative` without bad shim checks.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a native function,
	 *  else `false`.
	 */
	function baseIsNative(value) {
	  if (!isObject(value) || isMasked(value)) {
	    return false;
	  }
	  var pattern = (isFunction(value) || isHostObject(value)) ? reIsNative : reIsHostCtor;
	  return pattern.test(toSource(value));
	}

	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = getValue(object, key);
	  return baseIsNative(value) ? value : undefined;
	}

	/**
	 * Gets the `toStringTag` of `value`.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the `toStringTag`.
	 */
	var getTag = baseGetTag;

	// Fallback for data views, maps, sets, and weak maps in IE 11,
	// for data views in Edge < 14, and promises in Node.js.
	if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
	    (Map && getTag(new Map) != mapTag) ||
	    (Promise && getTag(Promise.resolve()) != promiseTag) ||
	    (Set && getTag(new Set) != setTag) ||
	    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
	  getTag = function(value) {
	    var result = objectToString.call(value),
	        Ctor = result == objectTag ? value.constructor : undefined,
	        ctorString = Ctor ? toSource(Ctor) : undefined;

	    if (ctorString) {
	      switch (ctorString) {
	        case dataViewCtorString: return dataViewTag;
	        case mapCtorString: return mapTag;
	        case promiseCtorString: return promiseTag;
	        case setCtorString: return setTag;
	        case weakMapCtorString: return weakMapTag;
	      }
	    }
	    return result;
	  };
	}

	/**
	 * Checks if `func` has its source masked.
	 *
	 * @private
	 * @param {Function} func The function to check.
	 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
	 */
	function isMasked(func) {
	  return !!maskSrcKey && (maskSrcKey in func);
	}

	/**
	 * Checks if `value` is likely a prototype object.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
	 */
	function isPrototype(value) {
	  var Ctor = value && value.constructor,
	      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

	  return value === proto;
	}

	/**
	 * Converts `func` to its source code.
	 *
	 * @private
	 * @param {Function} func The function to process.
	 * @returns {string} Returns the source code.
	 */
	function toSource(func) {
	  if (func != null) {
	    try {
	      return funcToString.call(func);
	    } catch (e) {}
	    try {
	      return (func + '');
	    } catch (e) {}
	  }
	  return '';
	}

	/**
	 * Checks if `value` is likely an `arguments` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
	 *  else `false`.
	 * @example
	 *
	 * _.isArguments(function() { return arguments; }());
	 * // => true
	 *
	 * _.isArguments([1, 2, 3]);
	 * // => false
	 */
	function isArguments(value) {
	  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
	  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') &&
	    (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
	}

	/**
	 * Checks if `value` is classified as an `Array` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
	 * @example
	 *
	 * _.isArray([1, 2, 3]);
	 * // => true
	 *
	 * _.isArray(document.body.children);
	 * // => false
	 *
	 * _.isArray('abc');
	 * // => false
	 *
	 * _.isArray(_.noop);
	 * // => false
	 */
	var isArray = Array.isArray;

	/**
	 * Checks if `value` is array-like. A value is considered array-like if it's
	 * not a function and has a `value.length` that's an integer greater than or
	 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
	 * @example
	 *
	 * _.isArrayLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLike(document.body.children);
	 * // => true
	 *
	 * _.isArrayLike('abc');
	 * // => true
	 *
	 * _.isArrayLike(_.noop);
	 * // => false
	 */
	function isArrayLike(value) {
	  return value != null && isLength(value.length) && !isFunction(value);
	}

	/**
	 * This method is like `_.isArrayLike` except that it also checks if `value`
	 * is an object.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array-like object,
	 *  else `false`.
	 * @example
	 *
	 * _.isArrayLikeObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLikeObject(document.body.children);
	 * // => true
	 *
	 * _.isArrayLikeObject('abc');
	 * // => false
	 *
	 * _.isArrayLikeObject(_.noop);
	 * // => false
	 */
	function isArrayLikeObject(value) {
	  return isObjectLike(value) && isArrayLike(value);
	}

	/**
	 * Checks if `value` is a buffer.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.3.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
	 * @example
	 *
	 * _.isBuffer(new Buffer(2));
	 * // => true
	 *
	 * _.isBuffer(new Uint8Array(2));
	 * // => false
	 */
	var isBuffer = nativeIsBuffer || stubFalse;

	/**
	 * Checks if `value` is an empty object, collection, map, or set.
	 *
	 * Objects are considered empty if they have no own enumerable string keyed
	 * properties.
	 *
	 * Array-like values such as `arguments` objects, arrays, buffers, strings, or
	 * jQuery-like collections are considered empty if they have a `length` of `0`.
	 * Similarly, maps and sets are considered empty if they have a `size` of `0`.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is empty, else `false`.
	 * @example
	 *
	 * _.isEmpty(null);
	 * // => true
	 *
	 * _.isEmpty(true);
	 * // => true
	 *
	 * _.isEmpty(1);
	 * // => true
	 *
	 * _.isEmpty([1, 2, 3]);
	 * // => false
	 *
	 * _.isEmpty({ 'a': 1 });
	 * // => false
	 */
	function isEmpty(value) {
	  if (isArrayLike(value) &&
	      (isArray(value) || typeof value == 'string' ||
	        typeof value.splice == 'function' || isBuffer(value) || isArguments(value))) {
	    return !value.length;
	  }
	  var tag = getTag(value);
	  if (tag == mapTag || tag == setTag) {
	    return !value.size;
	  }
	  if (nonEnumShadows || isPrototype(value)) {
	    return !nativeKeys(value).length;
	  }
	  for (var key in value) {
	    if (hasOwnProperty.call(value, key)) {
	      return false;
	    }
	  }
	  return true;
	}

	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  // The use of `Object#toString` avoids issues with the `typeof` operator
	  // in Safari 8-9 which returns 'object' for typed array and other constructors.
	  var tag = isObject(value) ? objectToString.call(value) : '';
	  return tag == funcTag || tag == genTag;
	}

	/**
	 * Checks if `value` is a valid array-like length.
	 *
	 * **Note:** This method is loosely based on
	 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
	 * @example
	 *
	 * _.isLength(3);
	 * // => true
	 *
	 * _.isLength(Number.MIN_VALUE);
	 * // => false
	 *
	 * _.isLength(Infinity);
	 * // => false
	 *
	 * _.isLength('3');
	 * // => false
	 */
	function isLength(value) {
	  return typeof value == 'number' &&
	    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
	}

	/**
	 * Checks if `value` is the
	 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
	 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(_.noop);
	 * // => true
	 *
	 * _.isObject(null);
	 * // => false
	 */
	function isObject(value) {
	  var type = typeof value;
	  return !!value && (type == 'object' || type == 'function');
	}

	/**
	 * Checks if `value` is object-like. A value is object-like if it's not `null`
	 * and has a `typeof` result of "object".
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 * @example
	 *
	 * _.isObjectLike({});
	 * // => true
	 *
	 * _.isObjectLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isObjectLike(_.noop);
	 * // => false
	 *
	 * _.isObjectLike(null);
	 * // => false
	 */
	function isObjectLike(value) {
	  return !!value && typeof value == 'object';
	}

	/**
	 * This method returns `false`.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.13.0
	 * @category Util
	 * @returns {boolean} Returns `false`.
	 * @example
	 *
	 * _.times(2, _.stubFalse);
	 * // => [false, false]
	 */
	function stubFalse() {
	  return false;
	}

	module.exports = isEmpty;

	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(15)(module)))

/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {var _ = __webpack_require__(5);
	var url = __webpack_require__(20);
	var EventEmitter = __webpack_require__(30).EventEmitter;

	/**
	 * Log bridge, which is an [EventEmitter](http://nodejs.org/api/events.html#events_class_events_eventemitter)
	 * that sends events to one or more outputs/loggers. Setup these loggers by
	 * specifying their config as the first argument, or by passing it to addOutput().
	 *
	 * @class Log
	 * @uses Loggers.Stdio
	 * @constructor
	 * @param {object} config
	 * @param {string|Object|ArrayOfStrings|ArrayOfObjects} config.log - Either the level
	 *  to setup a single logger, a full config object for a logger, or an array of
	 *  config objects to use for creating log outputs.
	 * @param {string|array} config.log.level|config.log.levels - One or more keys in Log.levels (error, warning, etc.)
	 * @param {string} config.log.type - The name of the logger to use for this output
	 */
	function Log(config) {
	  config = config || {};
	  if (!config.log) return;

	  var i;
	  var outputs;

	  if (_.isArrayOfStrings(config.log)) {
	    outputs = [{
	      levels: config.log
	    }];
	  } else {
	    outputs = _.createArray(config.log, function (val) {
	      if (_.isPlainObject(val)) {
	        return val;
	      }
	      if (typeof val === 'string') {
	        return {
	          level: val
	        };
	      }
	    });
	  }

	  if (!outputs) {
	    throw new TypeError('Invalid logging output config. Expected either a log level, array of log levels, ' +
	      'a logger config object, or an array of logger config objects.');
	  }

	  for (i = 0; i < outputs.length; i++) {
	    this.addOutput(outputs[i]);
	  }
	}
	_.inherits(Log, EventEmitter);

	Log.loggers = __webpack_require__(31);

	Log.prototype.close = function () {
	  this.emit('closing');
	  if (this.listenerCount()) {
	    console.error('Something is still listening for log events, but the logger is closing.'); // eslint-disable-line no-console
	    this.clearAllListeners();
	  }
	};

	if (EventEmitter.prototype.listenerCount) {
	  // If the event emitter implements it's own listenerCount method
	  // we don't need to (newer nodes do this).
	  Log.prototype.listenerCount = EventEmitter.prototype.listenerCount;
	}
	else if (EventEmitter.listenerCount) {
	  // some versions of node expose EventEmitter::listenerCount
	  // which is more efficient the getting all listeners of a
	  // specific type
	  Log.prototype.listenerCount = function (event) {
	    return EventEmitter.listenerCount(this, event);
	  };
	}
	else {
	  // all other versions of node expose a #listeners() method, which returns
	  // and array we have to count
	  Log.prototype.listenerCount = function (event) {
	    return this.listeners(event).length;
	  };
	}

	/**
	 * Levels observed by the loggers, ordered by rank
	 *
	 * @property levels
	 * @type Array
	 * @static
	 */
	Log.levels = [
	  /**
	   * Event fired for error level log entries
	   * @event error
	   * @param {Error} error - The error object to log
	   */
	  'error',
	  /**
	   * Event fired for "warning" level log entries, which usually represent things
	   * like correctly formatted error responses from ES (400, ...) and recoverable
	   * errors (one node unresponsive)
	   *
	   * @event warning
	   * @param {String} message - A message to be logged
	   */
	  'warning',
	  /**
	   * Event fired for "info" level log entries, which usually describe what a
	   * client is doing (sniffing etc)
	   *
	   * @event info
	   * @param {String} message - A message to be logged
	   */
	  'info',
	  /**
	   * Event fired for "debug" level log entries, which will describe requests sent,
	   * including their url (no data, response codes, or exec times)
	   *
	   * @event debug
	   * @param {String} message - A message to be logged
	   */
	  'debug',
	  /**
	   * Event fired for "trace" level log entries, which provide detailed information
	   * about each request made from a client, including reponse codes, execution times,
	   * and a full curl command that can be copied and pasted into a terminal
	   *
	   * @event trace
	   * @param {String} method method, , body, responseStatus, responseBody
	   * @param {String} url - The url the request was made to
	   * @param {String} body - The body of the request
	   * @param {Integer} responseStatus - The status code returned from the response
	   * @param {String} responseBody - The body of the response
	   */
	  'trace'
	];

	/**
	 * Converts a log config value (string or array) to an array of level names which
	 * it represents
	 *
	 * @method parseLevels
	 * @static
	 * @private
	 * @param  {String|ArrayOfStrings} input - Cound be a string to specify the max
	 *   level, or an array of exact levels
	 * @return {Array} -
	 */
	Log.parseLevels = function (input) {
	  switch (typeof input) {
	    case 'string':
	      var i = _.indexOf(Log.levels, input);
	      if (i >= 0) {
	        return Log.levels.slice(0, i + 1);
	      }
	    /* fall through */
	    case 'object':
	      if (_.isArray(input)) {
	        var valid = _.intersection(input, Log.levels);
	        if (valid.length === input.length) {
	          return valid;
	        }
	      }
	    /* fall through */
	    default:
	      throw new TypeError('invalid logging level ' + input + '. Expected zero or more of these options: ' +
	      Log.levels.join(', '));
	  }
	};

	/**
	 * Combine the array-like param into a simple string
	 *
	 * @method join
	 * @static
	 * @private
	 * @param  {*} arrayish - An array like object that can be itterated by _.each
	 * @return {String} - The final string.
	 */
	Log.join = function (arrayish) {
	  return _.map(arrayish, function (item) {
	    if (_.isPlainObject(item)) {
	      return JSON.stringify(item, null, 2) + '\n';
	    } else {
	      return item.toString();
	    }
	  }).join(' ');
	};

	/**
	 * Create a new logger, based on the config.
	 *
	 * @method addOutput
	 * @param {object} config - An object with config options for the logger.
	 * @param {String} [config.type=stdio] - The name of an output/logger. Options
	 *   can be found in the `src/loggers` directory.
	 * @param {String|ArrayOfStrings} [config.level|config.levels=warning] - The levels to output
	 *   to this logger, when an array is specified no levels other than the ones
	 *   specified will be listened to. When a string is specified, that and all lower
	 *   levels will be logged.
	 * @return {Logger}
	 */
	Log.prototype.addOutput = function (config) {
	  config = config || {};

	  // force "levels" key
	  config.levels = Log.parseLevels(config.levels || config.level || 'warning');
	  delete config.level;

	  var Logger = _.funcEnum(config, 'type', Log.loggers, process.browser ? 'console' : 'stdio');
	  return new Logger(this, config);
	};

	/**
	 * Log an error
	 *
	 * @method error
	 * @param  {Error|String} error  The Error to log
	 * @return {Boolean} - True if any outputs accepted the message
	 */
	Log.prototype.error = function (e) {
	  if (this.listenerCount('error')) {
	    return this.emit('error', e instanceof Error ? e : new Error(e));
	  }
	};


	/**
	 * Log a warning message
	 *
	 * @method warning
	 * @param  {*} msg* - Any amount of messages that will be joined before logged
	 * @return {Boolean} - True if any outputs accepted the message
	 */
	Log.prototype.warning = function (/* ...msg */) {
	  if (this.listenerCount('warning')) {
	    return this.emit('warning', Log.join(arguments));
	  }
	};


	/**
	 * Log useful info about what's going on
	 *
	 * @method info
	 * @param  {*} msg* - Any amount of messages that will be joined before logged
	 * @return {Boolean} - True if any outputs accepted the message
	 */
	Log.prototype.info = function (/* ...msg */) {
	  if (this.listenerCount('info')) {
	    return this.emit('info', Log.join(arguments));
	  }
	};

	/**
	 * Log a debug level message
	 *
	 * @method debug
	 * @param  {*} msg* - Any amount of messages that will be joined before logged
	 * @return {Boolean} - True if any outputs accepted the message
	 */
	Log.prototype.debug = function (/* ...msg */) {
	  if (this.listenerCount('debug')) {
	    return this.emit('debug', Log.join(arguments));
	  }
	};

	/**
	 * Log a trace level message
	 *
	 * @method trace
	 * @param {String} method - HTTP request method
	 * @param {String|Object} requestUrl - URL requested. If the value is an object,
	 *   it is expected to be the return value of Node's url.parse()
	 * @param {String} body - The request's body
	 * @param {String} responseBody - body returned from ES
	 * @param {String} responseStatus - HTTP status code
	 * @return {Boolean} - True if any outputs accepted the message
	 */
	Log.prototype.trace = function (method, requestUrl, body, responseBody, responseStatus) {
	  if (this.listenerCount('trace')) {
	    return this.emit('trace', Log.normalizeTraceArgs(method, requestUrl, body, responseBody, responseStatus));
	  }
	};

	Log.normalizeTraceArgs = function (method, requestUrl, body, responseBody, responseStatus) {
	  if (typeof requestUrl === 'string') {
	    requestUrl = url.parse(requestUrl, true, true);
	  } else {
	    requestUrl = _.clone(requestUrl);
	    if (requestUrl.path) {
	      requestUrl.query = url.parse(requestUrl.path, true, false).query;
	    }
	    if (!requestUrl.pathname && requestUrl.path) {
	      requestUrl.pathname = requestUrl.path.split('?').shift();
	    }
	  }

	  delete requestUrl.auth;

	  return {
	    method: method,
	    url: url.format(requestUrl),
	    body: body,
	    status: responseStatus,
	    response: responseBody
	  };
	};

	module.exports = Log;

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ },
/* 30 */
/***/ function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.

	function EventEmitter() {
	  this._events = this._events || {};
	  this._maxListeners = this._maxListeners || undefined;
	}
	module.exports = EventEmitter;

	// Backwards-compat with node 0.10.x
	EventEmitter.EventEmitter = EventEmitter;

	EventEmitter.prototype._events = undefined;
	EventEmitter.prototype._maxListeners = undefined;

	// By default EventEmitters will print a warning if more than 10 listeners are
	// added to it. This is a useful default which helps finding memory leaks.
	EventEmitter.defaultMaxListeners = 10;

	// Obviously not all Emitters should be limited to 10. This function allows
	// that to be increased. Set to zero for unlimited.
	EventEmitter.prototype.setMaxListeners = function(n) {
	  if (!isNumber(n) || n < 0 || isNaN(n))
	    throw TypeError('n must be a positive number');
	  this._maxListeners = n;
	  return this;
	};

	EventEmitter.prototype.emit = function(type) {
	  var er, handler, len, args, i, listeners;

	  if (!this._events)
	    this._events = {};

	  // If there is no 'error' event listener then throw.
	  if (type === 'error') {
	    if (!this._events.error ||
	        (isObject(this._events.error) && !this._events.error.length)) {
	      er = arguments[1];
	      if (er instanceof Error) {
	        throw er; // Unhandled 'error' event
	      } else {
	        // At least give some kind of context to the user
	        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
	        err.context = er;
	        throw err;
	      }
	    }
	  }

	  handler = this._events[type];

	  if (isUndefined(handler))
	    return false;

	  if (isFunction(handler)) {
	    switch (arguments.length) {
	      // fast cases
	      case 1:
	        handler.call(this);
	        break;
	      case 2:
	        handler.call(this, arguments[1]);
	        break;
	      case 3:
	        handler.call(this, arguments[1], arguments[2]);
	        break;
	      // slower
	      default:
	        args = Array.prototype.slice.call(arguments, 1);
	        handler.apply(this, args);
	    }
	  } else if (isObject(handler)) {
	    args = Array.prototype.slice.call(arguments, 1);
	    listeners = handler.slice();
	    len = listeners.length;
	    for (i = 0; i < len; i++)
	      listeners[i].apply(this, args);
	  }

	  return true;
	};

	EventEmitter.prototype.addListener = function(type, listener) {
	  var m;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events)
	    this._events = {};

	  // To avoid recursion in the case that type === "newListener"! Before
	  // adding it to the listeners, first emit "newListener".
	  if (this._events.newListener)
	    this.emit('newListener', type,
	              isFunction(listener.listener) ?
	              listener.listener : listener);

	  if (!this._events[type])
	    // Optimize the case of one listener. Don't need the extra array object.
	    this._events[type] = listener;
	  else if (isObject(this._events[type]))
	    // If we've already got an array, just append.
	    this._events[type].push(listener);
	  else
	    // Adding the second element, need to change to array.
	    this._events[type] = [this._events[type], listener];

	  // Check for listener leak
	  if (isObject(this._events[type]) && !this._events[type].warned) {
	    if (!isUndefined(this._maxListeners)) {
	      m = this._maxListeners;
	    } else {
	      m = EventEmitter.defaultMaxListeners;
	    }

	    if (m && m > 0 && this._events[type].length > m) {
	      this._events[type].warned = true;
	      console.error('(node) warning: possible EventEmitter memory ' +
	                    'leak detected. %d listeners added. ' +
	                    'Use emitter.setMaxListeners() to increase limit.',
	                    this._events[type].length);
	      if (typeof console.trace === 'function') {
	        // not supported in IE 10
	        console.trace();
	      }
	    }
	  }

	  return this;
	};

	EventEmitter.prototype.on = EventEmitter.prototype.addListener;

	EventEmitter.prototype.once = function(type, listener) {
	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  var fired = false;

	  function g() {
	    this.removeListener(type, g);

	    if (!fired) {
	      fired = true;
	      listener.apply(this, arguments);
	    }
	  }

	  g.listener = listener;
	  this.on(type, g);

	  return this;
	};

	// emits a 'removeListener' event iff the listener was removed
	EventEmitter.prototype.removeListener = function(type, listener) {
	  var list, position, length, i;

	  if (!isFunction(listener))
	    throw TypeError('listener must be a function');

	  if (!this._events || !this._events[type])
	    return this;

	  list = this._events[type];
	  length = list.length;
	  position = -1;

	  if (list === listener ||
	      (isFunction(list.listener) && list.listener === listener)) {
	    delete this._events[type];
	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);

	  } else if (isObject(list)) {
	    for (i = length; i-- > 0;) {
	      if (list[i] === listener ||
	          (list[i].listener && list[i].listener === listener)) {
	        position = i;
	        break;
	      }
	    }

	    if (position < 0)
	      return this;

	    if (list.length === 1) {
	      list.length = 0;
	      delete this._events[type];
	    } else {
	      list.splice(position, 1);
	    }

	    if (this._events.removeListener)
	      this.emit('removeListener', type, listener);
	  }

	  return this;
	};

	EventEmitter.prototype.removeAllListeners = function(type) {
	  var key, listeners;

	  if (!this._events)
	    return this;

	  // not listening for removeListener, no need to emit
	  if (!this._events.removeListener) {
	    if (arguments.length === 0)
	      this._events = {};
	    else if (this._events[type])
	      delete this._events[type];
	    return this;
	  }

	  // emit removeListener for all listeners on all events
	  if (arguments.length === 0) {
	    for (key in this._events) {
	      if (key === 'removeListener') continue;
	      this.removeAllListeners(key);
	    }
	    this.removeAllListeners('removeListener');
	    this._events = {};
	    return this;
	  }

	  listeners = this._events[type];

	  if (isFunction(listeners)) {
	    this.removeListener(type, listeners);
	  } else if (listeners) {
	    // LIFO order
	    while (listeners.length)
	      this.removeListener(type, listeners[listeners.length - 1]);
	  }
	  delete this._events[type];

	  return this;
	};

	EventEmitter.prototype.listeners = function(type) {
	  var ret;
	  if (!this._events || !this._events[type])
	    ret = [];
	  else if (isFunction(this._events[type]))
	    ret = [this._events[type]];
	  else
	    ret = this._events[type].slice();
	  return ret;
	};

	EventEmitter.prototype.listenerCount = function(type) {
	  if (this._events) {
	    var evlistener = this._events[type];

	    if (isFunction(evlistener))
	      return 1;
	    else if (evlistener)
	      return evlistener.length;
	  }
	  return 0;
	};

	EventEmitter.listenerCount = function(emitter, type) {
	  return emitter.listenerCount(type);
	};

	function isFunction(arg) {
	  return typeof arg === 'function';
	}

	function isNumber(arg) {
	  return typeof arg === 'number';
	}

	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}

	function isUndefined(arg) {
	  return arg === void 0;
	}


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  console: __webpack_require__(32)
	};


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Special version of the Stream logger, which logs errors and warnings to stderr and all other
	 * levels to stdout.
	 *
	 * @class Loggers.Console
	 * @extends LoggerAbstract
	 * @constructor
	 * @param {Object} config - The configuration for the Logger
	 * @param {string} config.level - The highest log level for this logger to output.
	 * @param {Log} bridge - The object that triggers logging events, which we will record
	 */

	module.exports = Console;

	var LoggerAbstract = __webpack_require__(33);
	var _ = __webpack_require__(5);

	function Console(log, config) {
	  LoggerAbstract.call(this, log, config);

	  // config/state
	  this.color = _.has(config, 'color') ? !!config.color : true;
	}
	_.inherits(Console, LoggerAbstract);

	/**
	 * Override the LoggerAbstract's setup listeners to do a little extra setup
	 *
	 * @param  {Array} levels - The levels that we should be listeneing for
	 */
	Console.prototype.setupListeners = function (levels) {
	  // call the super method
	  LoggerAbstract.prototype.setupListeners.call(this, levels);
	};

	Console.prototype.write = function (label, message, to) {
	  if (console[to]) {
	    console[to](this.format(label, message));
	  }
	};

	/**
	 * Handler for the bridges "error" event
	 *
	 * @method onError
	 * @private
	 * @param  {Error} e - The Error object to log
	 * @return {undefined}
	 */
	Console.prototype.onError = _.handler(function (e) {
	  var to = console.error ? 'error' : 'log';
	  this.write(e.name === 'Error' ? 'ERROR' : e.name, e.stack || e.message, to);
	});

	/**
	 * Handler for the bridges "warning" event
	 *
	 * @method onWarning
	 * @private
	 * @param  {String} msg - The message to be logged
	 * @return {undefined}
	 */
	Console.prototype.onWarning = _.handler(function (msg) {
	  this.write('WARNING', msg, console.warn ? 'warn' : 'log');
	});

	/**
	 * Handler for the bridges "info" event
	 *
	 * @method onInfo
	 * @private
	 * @param  {String} msg - The message to be logged
	 * @return {undefined}
	 */
	Console.prototype.onInfo = _.handler(function (msg) {
	  this.write('INFO', msg, console.info ? 'info' : 'log');
	});

	/**
	 * Handler for the bridges "debug" event
	 *
	 * @method onDebug
	 * @private
	 * @param  {String} msg - The message to be logged
	 * @return {undefined}
	 */
	Console.prototype.onDebug = _.handler(function (msg) {
	  this.write('DEBUG', msg, console.debug ? 'debug' : 'log');
	});
	/**
	 * Handler for the bridges "trace" event
	 *
	 * @method onTrace
	 * @private
	 * @return {undefined}
	 */
	Console.prototype.onTrace = _.handler(function (msg) {
	  this.write('TRACE', this._formatTraceMessage(msg), 'log');
	});


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(5);

	/**
	 * Abstract class providing common functionality to loggers
	 * @param {[type]} log [description]
	 * @param {[type]} config [description]
	 */
	function LoggerAbstract(log, config) {
	  this.log = log;
	  this.listeningLevels = [];

	  _.makeBoundMethods(this);

	  // when the log closes, remove our event listeners
	  this.log.once('closing', this.bound.cleanUpListeners);

	  this.setupListeners(config.levels);
	}

	function padNumToTen(n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	}

	/**
	 * Create a timestamp string used in the format function. Defers to Log.timestamp if it is defined,
	 * Also, feel free to override this at the logger level.
	 * @return {String} - Timestamp in ISO 8601 UTC
	 */
	LoggerAbstract.prototype.timestamp = function () {
	  var d = new Date();
	  return d.getUTCFullYear() + '-' +
	    padNumToTen(d.getUTCMonth() + 1) + '-' +
	    padNumToTen(d.getUTCDate()) + 'T' +
	    padNumToTen(d.getUTCHours()) + ':' +
	    padNumToTen(d.getUTCMinutes()) + ':' +
	    padNumToTen(d.getUTCSeconds()) + 'Z';
	};

	function indent(text, spaces) {
	  var space = _.repeat(' ', spaces || 2);
	  return (text || '').split(/\r?\n/).map(function (line) {
	    return space + line;
	  }).join('\n');
	}

	LoggerAbstract.prototype.format = function (label, message) {
	  return label + ': ' + this.timestamp() + '\n' + indent(message) + '\n\n';
	};

	LoggerAbstract.prototype.write = function () {
	  throw new Error('This should be overwritten by the logger');
	};

	/**
	 * Clear the current event listeners and then re-listen for events based on the level specified
	 *
	 * @method setupListeners
	 * @private
	 * @param  {Integer} level - The max log level that this logger should listen to
	 * @return {undefined}
	 */
	LoggerAbstract.prototype.setupListeners = function (levels) {
	  this.cleanUpListeners();

	  this.listeningLevels = [];

	  _.each(levels, _.bind(function (level) {
	    var fnName = 'on' + _.ucfirst(level);
	    if (this.bound[fnName]) {
	      this.listeningLevels.push(level);
	      this.log.on(level, this.bound[fnName]);
	    } else {
	      throw new Error('Unable to listen for level "' + level + '"');
	    }
	  }, this));
	};

	/**
	 * Clear the current event listeners
	 *
	 * @method cleanUpListeners
	 * @private
	 * @return {undefined}
	 */
	LoggerAbstract.prototype.cleanUpListeners = _.handler(function () {
	  _.each(this.listeningLevels, _.bind(function (level) {
	    this.log.removeListener(level, this.bound['on' + _.ucfirst(level)]);
	  }, this));
	});

	/**
	 * Handler for the logs "error" event
	 *
	 * @method onError
	 * @private
	 * @param  {Error} e - The Error object to log
	 * @return {undefined}
	 */
	LoggerAbstract.prototype.onError = _.handler(function (e) {
	  this.write((e.name === 'Error' ? 'ERROR' : e.name), e.stack);
	});

	/**
	 * Handler for the logs "warning" event
	 *
	 * @method onWarning
	 * @private
	 * @param  {String} msg - The message to be logged
	 * @return {undefined}
	 */
	LoggerAbstract.prototype.onWarning = _.handler(function (msg) {
	  this.write('WARNING', msg);
	});

	/**
	 * Handler for the logs "info" event
	 *
	 * @method onInfo
	 * @private
	 * @param  {String} msg - The message to be logged
	 * @return {undefined}
	 */
	LoggerAbstract.prototype.onInfo = _.handler(function (msg) {
	  this.write('INFO', msg);
	});

	/**
	 * Handler for the logs "debug" event
	 *
	 * @method onDebug
	 * @private
	 * @param  {String} msg - The message to be logged
	 * @return {undefined}
	 */
	LoggerAbstract.prototype.onDebug = _.handler(function (msg) {
	  this.write('DEBUG', msg);
	});

	/**
	 * Handler for the logs "trace" event
	 *
	 * @method onTrace
	 * @private
	 * @param  {String} msg - The message to be logged
	 * @return {undefined}
	 */
	LoggerAbstract.prototype.onTrace = _.handler(function (requestDetails) {
	  this.write('TRACE', this._formatTraceMessage(requestDetails));
	});

	LoggerAbstract.prototype._formatTraceMessage = function (req) {
	  return '-> ' + req.method + ' ' + req.url + '\n' +
	    this._prettyJson(req.body) + '\n' +
	    '<- ' + req.status + '\n' +
	    this._prettyJson(req.response);
	/*
	-> GET https://sldfkjsdlfksjdf:9200/slsdkfjlxckvxhclks?sdlkj=sdlfkje
	{
	  asdflksjdf
	}

	<- 502
	{
	  sldfksjdlf
	}
	*/
	};

	LoggerAbstract.prototype._prettyJson = function (body) {
	  try {
	    if (typeof body === 'string') {
	      body = JSON.parse(body);
	    }
	    return JSON.stringify(body, null, '  ').replace(/'/g, '\\u0027');
	  } catch (e) {
	    return typeof body === 'string' ? body : '';
	  }
	};

	module.exports = LoggerAbstract;


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Manager of connections to a node(s), capable of ensuring that connections are clear and living
	 * before providing them to the application
	 *
	 * @class ConnectionPool
	 * @constructor
	 * @param {Object} config - The config object passed to the transport.
	 */

	module.exports = ConnectionPool;

	var _ = __webpack_require__(5);
	var Log = __webpack_require__(29);

	function ConnectionPool(config) {
	  config = config || {};
	  _.makeBoundMethods(this);

	  if (!config.log) {
	    this.log = new Log();
	    config.log = this.log;
	  } else {
	    this.log = config.log;
	  }

	  // we will need this when we create connections down the road
	  this._config = config;

	  // get the selector config var
	  this.selector = _.funcEnum(config, 'selector', ConnectionPool.selectors, ConnectionPool.defaultSelector);

	  // get the connection class
	  this.Connection = _.funcEnum(config, 'connectionClass', ConnectionPool.connectionClasses,
	    ConnectionPool.defaultConnectionClass);

	  // time that connections will wait before being revived
	  this.deadTimeout = config.hasOwnProperty('deadTimeout') ? config.deadTimeout : 60000;
	  this.maxDeadTimeout = config.hasOwnProperty('maxDeadTimeout') ? config.maxDeadTimeout : 18e5;
	  this.calcDeadTimeout = _.funcEnum(config, 'calcDeadTimeout', ConnectionPool.calcDeadTimeoutOptions, 'exponential');

	  // a map of connections to their "id" property, used when sniffing
	  this.index = {};

	  this._conns = {
	    alive: [],
	    dead: []
	  };

	  // information about timeouts for dead connections
	  this._timeouts = [];
	}

	// selector options
	ConnectionPool.selectors = __webpack_require__(35);
	ConnectionPool.defaultSelector = 'roundRobin';

	// get the connection options
	ConnectionPool.connectionClasses = __webpack_require__(38);
	ConnectionPool.defaultConnectionClass = ConnectionPool.connectionClasses._default;
	delete ConnectionPool.connectionClasses._default;

	// the function that calculates timeouts based on attempts
	ConnectionPool.calcDeadTimeoutOptions = {
	  flat: function (attempt, baseTimeout) {
	    return baseTimeout;
	  },
	  exponential: function (attempt, baseTimeout) {
	    return Math.min(baseTimeout * 2 * Math.pow(2, (attempt * 0.5 - 1)), this.maxDeadTimeout);
	  }
	};

	/**
	 * Selects a connection from the list using the this.selector
	 * Features:
	 *  - detects if the selector is async or not
	 *  - sync selectors should still return asynchronously
	 *  - catches errors in sync selectors
	 *  - automatically selects the first dead connection when there no living connections
	 *
	 * @param  {Function} cb [description]
	 * @return {[type]}      [description]
	 */
	ConnectionPool.prototype.select = function (cb) {
	  if (this._conns.alive.length) {
	    if (this.selector.length > 1) {
	      this.selector(this._conns.alive, cb);
	    } else {
	      try {
	        _.nextTick(cb, void 0, this.selector(this._conns.alive));
	      } catch (e) {
	        cb(e);
	      }
	    }
	  } else if (this._timeouts.length) {
	    this._selectDeadConnection(cb);
	  } else {
	    _.nextTick(cb, void 0);
	  }
	};

	/**
	 * Handler for the "set status" event emitted but the connections. It will move
	 * the connection to it's proper connection list (unless it was closed).
	 *
	 * @param  {String} status - the connection's new status
	 * @param  {String} oldStatus - the connection's old status
	 * @param  {ConnectionAbstract} connection - the connection object itself
	 */
	ConnectionPool.prototype.onStatusSet = _.handler(function (status, oldStatus, connection) {
	  var index;

	  var died = (status === 'dead');
	  var wasAlreadyDead = (died && oldStatus === 'dead');
	  var revived = (!died && oldStatus === 'dead');
	  var noChange = (oldStatus === status);
	  var from = this._conns[oldStatus];
	  var to = this._conns[status];

	  if (noChange && !died) {
	    return true;
	  }

	  if (from !== to) {
	    if (_.isArray(from)) {
	      index = from.indexOf(connection);
	      if (index !== -1) {
	        from.splice(index, 1);
	      }
	    }

	    if (_.isArray(to)) {
	      index = to.indexOf(connection);
	      if (index === -1) {
	        to.push(connection);
	      }
	    }
	  }

	  if (died) {
	    this._onConnectionDied(connection, wasAlreadyDead);
	  }

	  if (revived) {
	    this._onConnectionRevived(connection);
	  }
	});

	/**
	 * Handler used to clear the times created when a connection dies
	 * @param  {ConnectionAbstract} connection
	 */
	ConnectionPool.prototype._onConnectionRevived = function (connection) {
	  var timeout;
	  for (var i = 0; i < this._timeouts.length; i++) {
	    if (this._timeouts[i].conn === connection) {
	      timeout = this._timeouts[i];
	      if (timeout.id) {
	        clearTimeout(timeout.id);
	      }
	      this._timeouts.splice(i, 1);
	      break;
	    }
	  }
	};

	/**
	 * Handler used to update or create a timeout for the connection which has died
	 * @param  {ConnectionAbstract} connection
	 * @param  {Boolean} alreadyWasDead - If the connection was preivously dead this must be set to true
	 */
	ConnectionPool.prototype._onConnectionDied = function (connection, alreadyWasDead) {
	  var timeout;
	  if (alreadyWasDead) {
	    for (var i = 0; i < this._timeouts.length; i++) {
	      if (this._timeouts[i].conn === connection) {
	        timeout = this._timeouts[i];
	        break;
	      }
	    }
	  } else {
	    timeout = {
	      conn: connection,
	      attempt: 0,
	      revive: function (cb) {
	        timeout.attempt++;
	        connection.ping(function (err) {
	          connection.setStatus(err ? 'dead' : 'alive');
	          if (cb && typeof cb === 'function') {
	            cb(err);
	          }
	        });
	      }
	    };
	    this._timeouts.push(timeout);
	  }

	  if (timeout.id) {
	    clearTimeout(timeout.id);
	  }

	  var ms = this.calcDeadTimeout(timeout.attempt, this.deadTimeout);
	  timeout.id = setTimeout(timeout.revive, ms);
	  timeout.runAt = _.now() + ms;
	};

	ConnectionPool.prototype._selectDeadConnection = function (cb) {
	  var orderedTimeouts = _.sortBy(this._timeouts, 'runAt');
	  var log = this.log;

	  process.nextTick(function next() {
	    var timeout = orderedTimeouts.shift();
	    if (!timeout) {
	      cb(void 0);
	      return;
	    }

	    if (!timeout.conn) {
	      next();
	      return;
	    }

	    if (timeout.conn.status === 'dead') {
	      timeout.revive(function (err) {
	        if (err) {
	          log.warning('Unable to revive connection: ' + timeout.conn.id);
	          process.nextTick(next);
	        } else {
	          cb(void 0, timeout.conn);
	        }
	      });
	    } else {
	      cb(void 0, timeout.conn);
	    }
	  });
	};

	/**
	 * Returns a random list of nodes from the living connections up to the limit.
	 * If there are no living connections it will fall back to the dead connections.
	 * If there are no dead connections it will return nothing.
	 *
	 * This is used for testing (when we just want the one existing node)
	 * and sniffing, where using the selector to get all of the living connections
	 * is not reasonable.
	 *
	 * @param {string} [status] - optional status of the connection to fetch
	 * @param {Number} [limit] - optional limit on the number of connections to return
	 */
	ConnectionPool.prototype.getConnections = function (status, limit) {
	  var list;
	  if (status) {
	    list = this._conns[status];
	  } else {
	    list = this._conns[this._conns.alive.length ? 'alive' : 'dead'];
	  }

	  if (limit == null) {
	    return list.slice(0);
	  } else {
	    return _.shuffle(list).slice(0, limit);
	  }
	};

	/**
	 * Add a single connection to the pool and change it's status to "alive".
	 * The connection should inherit from ConnectionAbstract
	 *
	 * @param {ConnectionAbstract} connection - The connection to add
	 */
	ConnectionPool.prototype.addConnection = function (connection) {
	  if (!connection.id) {
	    connection.id = connection.host.toString();
	  }

	  if (!this.index[connection.id]) {
	    this.log.info('Adding connection to', connection.id);
	    this.index[connection.id] = connection;
	    connection.on('status set', this.bound.onStatusSet);
	    connection.setStatus('alive');
	  }
	};

	/**
	 * Remove a connection from the pool, and set it's status to "closed".
	 *
	 * @param  {ConnectionAbstract} connection - The connection to remove/close
	 */
	ConnectionPool.prototype.removeConnection = function (connection) {
	  if (!connection.id) {
	    connection.id = connection.host.toString();
	  }

	  if (this.index[connection.id]) {
	    delete this.index[connection.id];
	    connection.setStatus('closed');
	    connection.removeListener('status set', this.bound.onStatusSet);
	  }
	};

	/**
	 * Override the internal node list. All connections that are not in the new host
	 * list are closed and removed. Non-unique hosts are ignored.
	 *
	 * @param {Host[]} hosts - An array of Host instances.
	 */
	ConnectionPool.prototype.setHosts = function (hosts) {
	  var connection;
	  var i;
	  var id;
	  var host;
	  var toRemove = _.clone(this.index);

	  for (i = 0; i < hosts.length; i++) {
	    host = hosts[i];
	    id = host.toString();
	    if (this.index[id]) {
	      delete toRemove[id];
	    } else {
	      connection = new this.Connection(host, this._config);
	      connection.id = id;
	      this.addConnection(connection);
	    }
	  }

	  var removeIds = _.keys(toRemove);
	  for (i = 0; i < removeIds.length; i++) {
	    this.removeConnection(this.index[removeIds[i]]);
	  }
	};

	ConnectionPool.prototype.getAllHosts = function () {
	  return _.values(this.index).map(function (connection) {
	    return connection.host;
	  });
	};

	/**
	 * Close the conncetion pool, as well as all of it's connections
	 */
	ConnectionPool.prototype.close = function () {
	  this.setHosts([]);
	};
	ConnectionPool.prototype.empty = ConnectionPool.prototype.close;

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1)))

/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  random: __webpack_require__(36),
	  roundRobin: __webpack_require__(37)
	};


/***/ },
/* 36 */
/***/ function(module, exports) {

	/**
	 * Selects a connection randomly
	 *
	 * @module selectors
	 * @type {Function}
	 * @param {Array} connection - The list of connections to choose from
	 * @return {Connection} - The selected connection
	 */
	module.exports = function RandomSelector(connections) {
	  return connections[Math.floor(Math.random() * connections.length)];
	};


/***/ },
/* 37 */
/***/ function(module, exports) {

	/**
	 * Selects a connection the simplest way possible, Round Robin
	 *
	 * @module selectors
	 * @type {Function}
	 * @param {Array} connections - The list of connections that this selector needs to choose from
	 * @return {Connection} - The selected connection
	 */
	module.exports = function (connections) {
	  var connection = connections[0];
	  connections.push(connections.shift());
	  return connection;
	};


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	var opts = {
	  xhr: __webpack_require__(39),
	  jquery: __webpack_require__(40),
	  angular: __webpack_require__(42)
	};
	var _ = __webpack_require__(5);

	// remove modules that have been ignored by browserify
	_.each(opts, function (conn, name) {
	  if (typeof conn !== 'function') {
	    delete opts[name];
	  }
	});

	// custom _default specification
	if (opts.xhr) {
	  opts._default = 'xhr';
	} else if (opts.angular) {
	  opts._default = 'angular';
	} else {
	  opts._default = 'jquery';
	}

	module.exports = opts;


/***/ },
/* 39 */
/***/ function(module, exports) {

	// empty (null-loader)

/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	/* global jQuery: false */

	/**
	 * Simple connection class for using the XHR object in browsers
	 *
	 * @class {XhrConnection}
	 */
	module.exports = JqueryConnector;

	var _ = __webpack_require__(5);
	var ConnectionAbstract = __webpack_require__(41);
	var ConnectionFault = __webpack_require__(18).ConnectionFault;

	function JqueryConnector(host, config) {
	  ConnectionAbstract.call(this, host, config);
	}
	_.inherits(JqueryConnector, ConnectionAbstract);

	JqueryConnector.prototype.request = function (params, cb) {
	  var ajax = {
	    url: this.host.makeUrl(params),
	    data: params.body,
	    type: params.method,
	    dataType: 'text',
	    headers: this.host.getHeaders(params.headers),
	    done: cb
	  };

	  var jqXHR = jQuery.ajax(ajax)
	    .done(function (data) {
	      cb(null, data, jqXHR.statusCode(), {
	        'content-type': jqXHR.getResponseHeader('content-type')
	      });
	    })
	    .fail(function (a, b, err) {
	      cb(new ConnectionFault(err && err.message));
	    });

	  return function () {
	    jqXHR.abort();
	  };
	};


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = ConnectionAbstract;

	var _ = __webpack_require__(5);
	var EventEmitter = __webpack_require__(30).EventEmitter;
	var Log = __webpack_require__(29);
	var Host = __webpack_require__(19);
	var errors = __webpack_require__(18);

	/**
	 * Abstract class used for Connection classes
	 * @class ConnectionAbstract
	 * @constructor
	 */
	function ConnectionAbstract(host, config) {
	  config = config || {};
	  EventEmitter.call(this);

	  this.log = config.log || new Log();
	  this.pingTimeout = config.pingTimeout || 3000;

	  if (!host) {
	    throw new TypeError('Missing host');
	  } else if (host instanceof Host) {
	    this.host = host;
	  } else {
	    throw new TypeError('Invalid host');
	  }

	  _.makeBoundMethods(this);
	}
	_.inherits(ConnectionAbstract, EventEmitter);

	/**
	 * Make a request using this connection. Must be overridden by Connection classes, which can add whatever keys to
	 * params that they like. These are just the basics.
	 *
	 * @param [params] {Object} - The parameters for the request
	 * @param params.path {String} - The path for which you are requesting
	 * @param params.method {String} - The HTTP method for the request (GET, HEAD, etc.)
	 * @param params.requestTimeout {Integer} - The amount of time in milliseconds that this request should be allowed to run for.
	 * @param cb {Function} - A callback to be called once with `cb(err, responseBody, responseStatus)`
	 */
	ConnectionAbstract.prototype.request = function () {
	  throw new Error('Connection#request must be overwritten by the Connector');
	};

	ConnectionAbstract.prototype.ping = function (params, cb) {
	  if (typeof params === 'function') {
	    cb = params;
	    params = null;
	  } else {
	    cb = typeof cb === 'function' ? cb : null;
	  }

	  var requestTimeout = this.pingTimeout;
	  var requestTimeoutId;
	  var aborted;
	  var abort;

	  if (params && params.hasOwnProperty('requestTimeout')) {
	    requestTimeout = params.requestTimeout;
	  }

	  abort = this.request(_.defaults(params || {}, {
	    path: '/',
	    method: 'HEAD'
	  }), function (err) {
	    if (aborted) {
	      return;
	    }
	    clearTimeout(requestTimeoutId);
	    if (cb) {
	      cb(err);
	    }
	  });

	  if (requestTimeout) {
	    requestTimeoutId = setTimeout(function () {
	      if (abort) {
	        abort();
	      }
	      aborted = true;
	      if (cb) {
	        cb(new errors.RequestTimeout('Ping Timeout after ' + requestTimeout + 'ms'));
	      }
	    }, requestTimeout);
	  }
	};

	ConnectionAbstract.prototype.setStatus = function (status) {
	  var origStatus = this.status;
	  this.status = status;

	  this.emit('status set', status, origStatus, this);

	  if (status === 'closed') {
	    this.removeAllListeners();
	  }
	};


/***/ },
/* 42 */
/***/ function(module, exports) {

	// empty (null-loader)

/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  angular: __webpack_require__(44),
	  json: __webpack_require__(45)
	};


/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	/* global angular */
	var _ = __webpack_require__(5);
	var JsonSerializer = __webpack_require__(45);

	function AngularSerializer() {}
	_.inherits(AngularSerializer, JsonSerializer);

	// mimic the JsonSerializer's encode method, but use angular's toJson instead
	AngularSerializer.prototype.encode = function (val) {
	  switch (typeof val) {
	    case 'string':
	      return val;
	    case 'object':
	      if (val) return angular.toJson(val);
	    /* falls through */
	    default:
	      return;
	  }
	};

	module.exports = AngularSerializer;


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Simple JSON serializer
	 * @type {[type]}
	 */
	module.exports = Json;

	var _ = __webpack_require__(5);

	function Json() {}

	/**
	 * Converts a value into a string, or an error
	 * @param  {*} val - Any value, methods are stripped and
	 * see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/JSON/stringify about other params
	 * @return {String|Error} - A string is always returned, unless an error occured. then it will be that error.
	 */
	Json.prototype.serialize = function (val, replacer, spaces) {
	  switch (typeof val) {
	    case 'string':
	      return val;
	    case 'object':
	      if (val) {
	        return JSON.stringify(val, replacer, spaces);
	      }
	    /* falls through */
	    default:
	      return;
	  }
	};

	Json.prototype.serialize.contentType = 'application/json';

	/**
	 * Parse a JSON string, if it is already parsed it is ignored
	 * @param  {String} str - the string to parse
	 * @return {[type]}
	 */
	Json.prototype.deserialize = function (str) {
	  if (typeof str === 'string') {
	    try {
	      return JSON.parse(str);
	    } catch (e) {}
	  }
	};

	Json.prototype.bulkBody = function (val) {
	  var body = '', i;

	  if (_.isArray(val)) {
	    for (i = 0; i < val.length; i++) {
	      body += this.serialize(val[i]) + '\n';
	    }
	  } else if (typeof val === 'string') {
	    // make sure the string ends in a new line
	    body = val + (val[val.length - 1] === '\n' ? '' : '\n');
	  } else {
	    throw new TypeError('Bulk body should either be an Array of commands/string, or a String');
	  }

	  return body;
	};

	Json.prototype.bulkBody.contentType = 'application/x-ndjson';


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	var _ = __webpack_require__(5);

	var extractHostPartsRE1x = /\[(?:(.*)\/)?(.+?):(\d+)\]/;

	function makeNodeParser(hostProp) {
	  return function (nodes) {
	    return _.transform(nodes, function (hosts, node, id) {
	      var address = _.get(node, hostProp)
	      if (!address) return;

	      var host = {
	        host: undefined,
	        port: undefined,
	        _meta: {
	          id: id,
	          name: node.name,
	          version: node.version
	        }
	      };

	      var malformedError = new Error(
	        'Malformed ' + hostProp + '.' +
	        ' Got ' + JSON.stringify(address) +
	        ' and expected it to match "{hostname?}/{ip}:{port}".'
	      );

	      var matches1x = extractHostPartsRE1x.exec(address);
	      if (matches1x) {
	        host.host = matches1x[1] || matches1x[2];
	        host.port = parseInt(matches1x[3], 10);
	        hosts.push(host);
	        return;
	      }

	      if (address.indexOf('/') > -1) {
	        var withHostParts = address.split('/');
	        if (withHostParts.length !== 2) throw malformedError;

	        host.host = withHostParts.shift();
	        address = withHostParts.shift();
	      }

	      if (address.indexOf(':') < 0) {
	        throw malformedError;
	      }

	      var addressParts = address.split(':');
	      if (addressParts.length !== 2) {
	        throw malformedError;
	      }

	      host.host = host.host || addressParts[0];
	      host.port = parseInt(addressParts[1], 10);
	      hosts.push(host);
	    }, []);
	  };
	}

	module.exports = makeNodeParser('http.publish_address');


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	
	var _ = __webpack_require__(5);

	/**
	 * Constructs a client action factory that uses specific defaults
	 * @type {Function}
	 */
	exports.makeFactoryWithModifier = makeFactoryWithModifier;

	/**
	 * Constructs a function that can be called to make a request to ES
	 * @type {Function}
	 */
	exports.factory = makeFactoryWithModifier();

	/**
	 * Constructs a proxy to another api method
	 * @type {Function}
	 */
	exports.proxyFactory = exports.factory.proxy;

	// export so that we can test this
	exports._resolveUrl = resolveUrl;

	exports.ApiNamespace = function () {};
	exports.namespaceFactory = function () {
	  function ClientNamespace(transport, client) {
	    this.transport = transport;
	    this.client = client;
	  }

	  ClientNamespace.prototype = new exports.ApiNamespace();

	  return ClientNamespace;
	};

	function makeFactoryWithModifier(modifier) {
	  modifier = modifier || _.identity;

	  var factory = function (spec) {
	    spec = modifier(spec);

	    if (!_.isPlainObject(spec.params)) {
	      spec.params = {};
	    }

	    if (!spec.method) {
	      spec.method = 'GET';
	    }

	    function action(params, cb) {
	      if (typeof params === 'function') {
	        cb = params;
	        params = {};
	      } else {
	        params = params || {};
	        cb = typeof cb === 'function' ? cb : null;
	      }

	      try {
	        return exec(this.transport, spec, _.clone(params), cb);
	      } catch (e) {
	        if (typeof cb === 'function') {
	          _.nextTick(cb, e);
	        } else {
	          var def = this.transport.defer();
	          def.reject(e);
	          return def.promise;
	        }
	      }
	    }

	    action.spec = spec;

	    return action;
	  };

	  factory.proxy = function (fn, spec) {
	    return function (params, cb) {
	      if (typeof params === 'function') {
	        cb = params;
	        params = {};
	      } else {
	        params = params || {};
	        cb = typeof cb === 'function' ? cb : null;
	      }

	      if (spec.transform) {
	        spec.transform(params);
	      }

	      return fn.call(this, params, cb);
	    };
	  };

	  return factory;
	}

	var castType = {
	  'enum': function validSelection(param, val, name) {
	    if (_.isString(val) && val.indexOf(',') > -1) {
	      val = commaSepList(val);
	    }

	    if (_.isArray(val)) {
	      return val.map(function (v) {
	        return validSelection(param, v, name);
	      }).join(',');
	    }

	    for (var i = 0; i < param.options.length; i++) {
	      if (param.options[i] === String(val)) {
	        return param.options[i];
	      }
	    }
	    throw new TypeError('Invalid ' + name + ': expected ' + (
	      param.options.length > 1
	      ? 'one of ' + param.options.join(',')
	      : param.options[0]
	    ));
	  },
	  duration: function (param, val, name) {
	    if (_.isNumeric(val) || _.isInterval(val)) {
	      return val;
	    } else {
	      throw new TypeError(
	        'Invalid ' + name + ': expected a number or interval ' +
	        '(an integer followed by one of M, w, d, h, m, s, y or ms).'
	      );
	    }
	  },
	  list: function (param, val, name) {
	    switch (typeof val) {
	      case 'number':
	      case 'boolean':
	        return '' + val;
	      case 'string':
	        val = commaSepList(val);
	      /* falls through */
	      case 'object':
	        if (_.isArray(val)) {
	          return val.join(',');
	        }
	      /* falls through */
	      default:
	        throw new TypeError('Invalid ' + name + ': expected be a comma separated list, array, number or string.');
	    }
	  },
	  'boolean': function (param, val) {
	    val = _.isString(val) ? val.toLowerCase() : val;
	    return (val === 'no' || val === 'off') ? false : !!val;
	  },
	  number: function (param, val, name) {
	    if (_.isNumeric(val)) {
	      return val * 1;
	    } else {
	      throw new TypeError('Invalid ' + name + ': expected a number.');
	    }
	  },
	  string: function (param, val, name) {
	    switch (typeof val) {
	      case 'number':
	      case 'string':
	        return '' + val;
	      default:
	        throw new TypeError('Invalid ' + name + ': expected a string.');
	    }
	  },
	  time: function (param, val, name) {
	    if (typeof val === 'string') {
	      return val;
	    }
	    else if (_.isNumeric(val)) {
	      return '' + val;
	    }
	    else if (val instanceof Date) {
	      return '' + val.getTime();
	    }
	    else {
	      throw new TypeError('Invalid ' + name + ': expected some sort of time.');
	    }
	  }
	};

	function resolveUrl(url, params) {
	  var vars = {}, i, key;

	  if (url.req) {
	    // url has required params
	    if (!url.reqParamKeys) {
	      // create cached key list on demand
	      url.reqParamKeys = _.keys(url.req);
	    }

	    for (i = 0; i < url.reqParamKeys.length; i ++) {
	      key = url.reqParamKeys[i];
	      if (!params.hasOwnProperty(key) || params[key] == null) {
	        // missing a required param
	        return false;
	      } else {
	        // cast of copy required param
	        if (castType[url.req[key].type]) {
	          vars[key] = castType[url.req[key].type](url.req[key], params[key], key);
	        } else {
	          vars[key] = params[key];
	        }
	      }
	    }
	  }

	  if (url.opt) {
	    // url has optional params
	    if (!url.optParamKeys) {
	      url.optParamKeys = _.keys(url.opt);
	    }

	    for (i = 0; i < url.optParamKeys.length; i ++) {
	      key = url.optParamKeys[i];
	      if (params[key]) {
	        if (castType[url.opt[key].type] || params[key] == null) {
	          vars[key] = castType[url.opt[key].type](url.opt[key], params[key], key);
	        } else {
	          vars[key] = params[key];
	        }
	      } else {
	        vars[key] = url.opt[key]['default'];
	      }
	    }
	  }

	  if (!url.template) {
	    // compile the template on demand
	    url.template = _.template(url.fmt);
	  }

	  return url.template(_.transform(vars, function (note, val, name) {
	    // encode each value
	    note[name] = encodeURIComponent(val);
	    // remove it from the params so that it isn't sent to the final request
	    delete params[name];
	  }, {}));
	}


	function exec(transport, spec, params, cb) {
	  var request = {
	    method: spec.method
	  };
	  var query = {};
	  var i;

	  // pass the timeout from the spec
	  if (spec.requestTimeout) {
	    request.requestTimeout = spec.requestTimeout;
	  }

	  if (!params.body && spec.paramAsBody) {
	    if (typeof spec.paramAsBody === 'object') {
	      params.body = {};
	      if (spec.paramAsBody.castToArray) {
	        params.body[spec.paramAsBody.body] = [].concat(params[spec.paramAsBody.param]);
	      } else {
	        params.body[spec.paramAsBody.body] = params[spec.paramAsBody.param];
	      }
	      delete params[spec.paramAsBody.param];
	    } else {
	      params.body = params[spec.paramAsBody];
	      delete params[spec.paramAsBody];
	    }
	  }

	  // verify that we have the body if needed
	  if (spec.needsBody && !params.body) {
	    throw new TypeError('A request body is required.');
	  }

	  // control params
	  if (spec.bulkBody) {
	    request.bulkBody = true;
	  }

	  if (spec.method === 'HEAD') {
	    request.castExists = true;
	  }

	  // pick the url
	  if (spec.url) {
	    // only one url option
	    request.path = resolveUrl(spec.url, params);
	  } else {
	    for (i = 0; i < spec.urls.length; i++) {
	      if (request.path = resolveUrl(spec.urls[i], params)) {
	        break;
	      }
	    }
	  }

	  if (!request.path) {
	    // there must have been some mimimun requirements that were not met
	    var minUrl = spec.url || spec.urls[spec.urls.length - 1];
	    throw new TypeError('Unable to build a path with those params. Supply at least ' + _.keys(minUrl.req).join(', '));
	  }

	  // build the query string
	  if (!spec.paramKeys) {
	    // build a key list on demand
	    spec.paramKeys = _.keys(spec.params);
	    spec.requireParamKeys = _.transform(spec.params, function (req, param, key) {
	      if (param.required) {
	        req.push(key);
	      }
	    }, []);
	  }

	  for (var key in params) {
	    if (params.hasOwnProperty(key) && params[key] != null) {
	      switch (key) {
	        case 'body':
	        case 'headers':
	        case 'requestTimeout':
	        case 'maxRetries':
	          request[key] = params[key];
	          break;
	        case 'ignore':
	          request.ignore = _.isArray(params[key]) ? params[key] : [params[key]];
	          break;
	        case 'method':
	          request.method = _.toUpperString(params[key]);
	          break;
	        default:
	          var paramSpec = spec.params[key];
	          if (paramSpec) {
	          // param keys don't always match the param name, in those cases it's stored in the param def as "name"
	            paramSpec.name = paramSpec.name || key;
	            if (params[key] != null) {
	              if (castType[paramSpec.type]) {
	                query[paramSpec.name] = castType[paramSpec.type](paramSpec, params[key], key);
	              } else {
	                query[paramSpec.name] = params[key];
	              }

	              if (paramSpec['default'] && query[paramSpec.name] === paramSpec['default']) {
	                delete query[paramSpec.name];
	              }
	            }
	          } else {
	            query[key] = params[key];
	          }
	      }
	    }
	  }

	  for (i = 0; i < spec.requireParamKeys.length; i ++) {
	    if (!query.hasOwnProperty(spec.requireParamKeys[i])) {
	      throw new TypeError('Missing required parameter ' + spec.requireParamKeys[i]);
	    }
	  }

	  request.query = query;

	  return transport.request(request, cb);
	}

	function commaSepList(str) {
	  return str.split(',').map(function (i) {
	    return i.trim();
	  });
	}


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  '_default': __webpack_require__(49),
	  '5.3': __webpack_require__(49),
	  '5.2': __webpack_require__(50),
	  '5.1': __webpack_require__(51),
	  '5.0': __webpack_require__(52),
	  '2.4': __webpack_require__(53),
	  '5.x': __webpack_require__(54),
	  '5.4': __webpack_require__(55),
	  'master': __webpack_require__(56)
	};


/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	var ca = __webpack_require__(47).makeFactoryWithModifier(function (spec) {
	  return __webpack_require__(5).merge(spec, {
	    params: {
	      filterPath: {
	        type: 'list',
	        name: 'filter_path'
	      }
	    }
	  });
	});
	var namespace = __webpack_require__(47).namespaceFactory;
	var api = module.exports = {};

	api._namespaces = ['cat', 'cluster', 'indices', 'ingest', 'nodes', 'snapshot', 'tasks'];

	/**
	 * Perform a [bulk](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-bulk.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the bulk operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the effected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.type - Default document type for items which don't provide one
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - Default comma-separated list of fields to return in the response for updates, can be overridden on each sub-request
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or default list of fields to return, can be overridden on each sub-request
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - Default list of fields to exclude from the returned _source field, can be overridden on each sub-request
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - Default list of fields to extract and return from the _source field, can be overridden on each sub-request
	 * @param {<<api-param-type-string,`String`>>} params.pipeline - The pipeline id to preprocess incoming documents with
	 * @param {<<api-param-type-string,`String`>>} params.index - Default index for items which don't provide one
	 */
	api.bulk = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    type: {
	      type: 'string'
	    },
	    fields: {
	      type: 'list'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    pipeline: {
	      type: 'string'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_bulk',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_bulk',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_bulk'
	    }
	  ],
	  needBody: true,
	  bulkBody: true,
	  method: 'POST'
	});

	api.cat = namespace();

	/**
	 * Perform a [cat.aliases](http://www.elasticsearch.org/guide/en/elasticsearch/reference/master/cat.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - A comma-separated list of alias names to return
	 */
	api.cat.prototype.aliases = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/aliases/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/aliases'
	    }
	  ]
	});

	/**
	 * Perform a [cat.allocation](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-allocation.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.bytes - The unit in which to display byte values
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information
	 */
	api.cat.prototype.allocation = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    bytes: {
	      type: 'enum',
	      options: [
	        'b',
	        'k',
	        'kb',
	        'm',
	        'mb',
	        'g',
	        'gb',
	        't',
	        'tb',
	        'p',
	        'pb'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/allocation/<%=nodeId%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/allocation'
	    }
	  ]
	});

	/**
	 * Perform a [cat.count](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-count.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.count = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/count/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/count'
	    }
	  ]
	});

	/**
	 * Perform a [cat.fielddata](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-fielddata.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.bytes - The unit in which to display byte values
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields to return the fielddata size
	 */
	api.cat.prototype.fielddata = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    bytes: {
	      type: 'enum',
	      options: [
	        'b',
	        'k',
	        'kb',
	        'm',
	        'mb',
	        'g',
	        'gb',
	        't',
	        'tb',
	        'p',
	        'pb'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    },
	    fields: {
	      type: 'list'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/fielddata/<%=fields%>',
	      req: {
	        fields: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/fielddata'
	    }
	  ]
	});

	/**
	 * Perform a [cat.health](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-health.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.ts=true] - Set to false to disable timestamping
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.health = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    ts: {
	      type: 'boolean',
	      'default': true
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/health'
	  }
	});

	/**
	 * Perform a [cat.help](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 */
	api.cat.prototype.help = ca({
	  params: {
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    }
	  },
	  url: {
	    fmt: '/_cat'
	  }
	});

	/**
	 * Perform a [cat.indices](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-indices.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.bytes - The unit in which to display byte values
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-string,`String`>>} params.health - A health status ("green", "yellow", or "red" to filter only indices matching the specified health status
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.pri - Set to true to return stats only for primary shards
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.indices = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    bytes: {
	      type: 'enum',
	      options: [
	        'b',
	        'k',
	        'm',
	        'g'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    health: {
	      type: 'enum',
	      'default': null,
	      options: [
	        'green',
	        'yellow',
	        'red'
	      ]
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    pri: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/indices/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/indices'
	    }
	  ]
	});

	/**
	 * Perform a [cat.master](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-master.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.master = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/master'
	  }
	});

	/**
	 * Perform a [cat.nodeattrs](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-nodeattrs.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.nodeattrs = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/nodeattrs'
	  }
	});

	/**
	 * Perform a [cat.nodes](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-nodes.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.fullId - Return the full node ID instead of the shortened version (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.nodes = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    fullId: {
	      type: 'boolean',
	      name: 'full_id'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/nodes'
	  }
	});

	/**
	 * Perform a [cat.pendingTasks](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-pending-tasks.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.pendingTasks = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/pending_tasks'
	  }
	});

	/**
	 * Perform a [cat.plugins](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-plugins.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.plugins = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/plugins'
	  }
	});

	/**
	 * Perform a [cat.recovery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-recovery.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.bytes - The unit in which to display byte values
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.recovery = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    bytes: {
	      type: 'enum',
	      options: [
	        'b',
	        'k',
	        'kb',
	        'm',
	        'mb',
	        'g',
	        'gb',
	        't',
	        'tb',
	        'p',
	        'pb'
	      ]
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/recovery/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/recovery'
	    }
	  ]
	});

	/**
	 * Perform a [cat.repositories](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-repositories.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.repositories = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean',
	      'default': false
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/repositories'
	  }
	});

	/**
	 * Perform a [cat.segments](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-segments.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.segments = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/segments/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/segments'
	    }
	  ]
	});

	/**
	 * Perform a [cat.shards](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-shards.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.shards = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/shards/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/shards'
	    }
	  ]
	});

	/**
	 * Perform a [cat.snapshots](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Set to true to ignore unavailable snapshots
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.repository - Name of repository from which to fetch the snapshot information
	 */
	api.cat.prototype.snapshots = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      'default': false,
	      name: 'ignore_unavailable'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/snapshots/<%=repository%>',
	      req: {
	        repository: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/snapshots'
	    }
	  ]
	});

	/**
	 * Perform a [cat.tasks](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/tasks.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.actions - A comma-separated list of actions that should be returned. Leave empty to return all.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.detailed - Return detailed task information (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.parentNode - Return tasks with specified parent node.
	 * @param {<<api-param-type-number,`Number`>>} params.parentTask - Return tasks with specified parent task id. Set to -1 to return all.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.tasks = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    nodeId: {
	      type: 'list',
	      name: 'node_id'
	    },
	    actions: {
	      type: 'list'
	    },
	    detailed: {
	      type: 'boolean'
	    },
	    parentNode: {
	      type: 'string',
	      name: 'parent_node'
	    },
	    parentTask: {
	      type: 'number',
	      name: 'parent_task'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/tasks'
	  }
	});

	/**
	 * Perform a [cat.templates](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>} params.name - A pattern that returned template names must match
	 */
	api.cat.prototype.templates = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/templates/<%=name%>',
	      req: {
	        name: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/templates'
	    }
	  ]
	});

	/**
	 * Perform a [cat.threadPool](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-thread-pool.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.size - The multiplier in which to display values
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.threadPoolPatterns - A comma-separated list of regular-expressions to filter the thread pools in the output
	 */
	api.cat.prototype.threadPool = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    size: {
	      type: 'enum',
	      options: [
	        '',
	        'k',
	        'm',
	        'g',
	        't',
	        'p'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/thread_pool/<%=threadPoolPatterns%>',
	      req: {
	        threadPoolPatterns: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/thread_pool'
	    }
	  ]
	});

	/**
	 * Perform a [clearScroll](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-request-scroll.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.scrollId - A comma-separated list of scroll IDs to clear
	 */
	api.clearScroll = ca({
	  urls: [
	    {
	      fmt: '/_search/scroll/<%=scrollId%>',
	      req: {
	        scrollId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_search/scroll'
	    }
	  ],
	  paramAsBody: {
	    param: 'scrollId',
	    body: 'scroll_id'
	  },
	  method: 'DELETE'
	});

	api.cluster = namespace();

	/**
	 * Perform a [cluster.allocationExplain](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-allocation-explain.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeYesDecisions - Return 'YES' decisions in explanation (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDiskInfo - Return information about disk usage and shard sizes (default: false)
	 */
	api.cluster.prototype.allocationExplain = ca({
	  params: {
	    includeYesDecisions: {
	      type: 'boolean',
	      name: 'include_yes_decisions'
	    },
	    includeDiskInfo: {
	      type: 'boolean',
	      name: 'include_disk_info'
	    }
	  },
	  url: {
	    fmt: '/_cluster/allocation/explain'
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [cluster.getSettings](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-update-settings.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDefaults - Whether to return all default clusters setting.
	 */
	api.cluster.prototype.getSettings = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    },
	    includeDefaults: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_defaults'
	    }
	  },
	  url: {
	    fmt: '/_cluster/settings'
	  }
	});

	/**
	 * Perform a [cluster.health](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-health.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} [params.level=cluster] - Specify the level of detail for returned information
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Wait until the specified number of shards is active
	 * @param {<<api-param-type-string,`String`>>} params.waitForNodes - Wait until the specified number of nodes is available
	 * @param {<<api-param-type-string,`String`>>} params.waitForEvents - Wait until all currently queued events with the given priority are processed
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForNoRelocatingShards - Whether to wait until there are no relocating shards in the cluster
	 * @param {<<api-param-type-string,`String`>>} params.waitForStatus - Wait until cluster is in a specific state
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - Limit the information returned to a specific index
	 */
	api.cluster.prototype.health = ca({
	  params: {
	    level: {
	      type: 'enum',
	      'default': 'cluster',
	      options: [
	        'cluster',
	        'indices',
	        'shards'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    waitForNodes: {
	      type: 'string',
	      name: 'wait_for_nodes'
	    },
	    waitForEvents: {
	      type: 'enum',
	      options: [
	        'immediate',
	        'urgent',
	        'high',
	        'normal',
	        'low',
	        'languid'
	      ],
	      name: 'wait_for_events'
	    },
	    waitForNoRelocatingShards: {
	      type: 'boolean',
	      name: 'wait_for_no_relocating_shards'
	    },
	    waitForStatus: {
	      type: 'enum',
	      'default': null,
	      options: [
	        'green',
	        'yellow',
	        'red'
	      ],
	      name: 'wait_for_status'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cluster/health/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cluster/health'
	    }
	  ]
	});

	/**
	 * Perform a [cluster.pendingTasks](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-pending.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 */
	api.cluster.prototype.pendingTasks = ca({
	  params: {
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/_cluster/pending_tasks'
	  }
	});

	/**
	 * Perform a [cluster.putSettings](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-update-settings.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 */
	api.cluster.prototype.putSettings = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_cluster/settings'
	  },
	  method: 'PUT'
	});

	/**
	 * Perform a [cluster.reroute](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-reroute.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.dryRun - Simulate the operation only and return the resulting state
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.explain - Return an explanation of why the commands can or cannot be executed
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.retryFailed - Retries allocation of shards that are blocked due to too many subsequent allocation failures
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - Limit the information returned to the specified metrics. Defaults to all but metadata
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 */
	api.cluster.prototype.reroute = ca({
	  params: {
	    dryRun: {
	      type: 'boolean',
	      name: 'dry_run'
	    },
	    explain: {
	      type: 'boolean'
	    },
	    retryFailed: {
	      type: 'boolean',
	      name: 'retry_failed'
	    },
	    metric: {
	      type: 'list',
	      options: [
	        '_all',
	        'blocks',
	        'metadata',
	        'nodes',
	        'routing_table',
	        'master_node',
	        'version'
	      ]
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_cluster/reroute'
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [cluster.state](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-state.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - Limit the information returned to the specified metrics
	 */
	api.cluster.prototype.state = ca({
	  params: {
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cluster/state/<%=metric%>/<%=index%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'blocks',
	            'metadata',
	            'nodes',
	            'routing_table',
	            'routing_nodes',
	            'master_node',
	            'version'
	          ]
	        },
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cluster/state/<%=metric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'blocks',
	            'metadata',
	            'nodes',
	            'routing_table',
	            'routing_nodes',
	            'master_node',
	            'version'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_cluster/state'
	    }
	  ]
	});

	/**
	 * Perform a [cluster.stats](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-stats.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 */
	api.cluster.prototype.stats = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cluster/stats/nodes/<%=nodeId%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cluster/stats'
	    }
	  ]
	});

	/**
	 * Perform a [count](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-count.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-number,`Number`>>} params.minScore - Include only documents with a specific `_score` value in the result
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer to use for the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcard and prefix queries should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The field to use as default where no field prefix is given in the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of indices to restrict the results
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of types to restrict the results
	 */
	api.count = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    minScore: {
	      type: 'number',
	      name: 'min_score'
	    },
	    preference: {
	      type: 'string'
	    },
	    routing: {
	      type: 'string'
	    },
	    q: {
	      type: 'string'
	    },
	    analyzer: {
	      type: 'string'
	    },
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    lenient: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_count',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_count',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_count'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [countPercolate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-percolate.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>} params.percolateIndex - The index to count percolate the document into. Defaults to index.
	 * @param {<<api-param-type-string,`String`>>} params.percolateType - The type to count percolate document into. Defaults to type.
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.index - The index of the document being count percolated.
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document being count percolated.
	 * @param {<<api-param-type-string,`String`>>} params.id - Substitute the document in the request body with a document that is known by the specified id. On top of the id, the index and type parameter will be used to retrieve the document from within the cluster.
	 */
	api.countPercolate = ca({
	  params: {
	    routing: {
	      type: 'list'
	    },
	    preference: {
	      type: 'string'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    percolateIndex: {
	      type: 'string',
	      name: 'percolate_index'
	    },
	    percolateType: {
	      type: 'string',
	      name: 'percolate_type'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/<%=id%>/_percolate/count',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/<%=type%>/_percolate/count',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [create](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-index_.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the index operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>} params.parent - ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the affected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timestamp - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.ttl - Expiration time for the document
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.pipeline - The pipeline id to preprocess incoming documents with
	 * @param {<<api-param-type-string,`String`>>} params.id - Document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.create = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    parent: {
	      type: 'string'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    timestamp: {
	      type: 'time'
	    },
	    ttl: {
	      type: 'time'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    },
	    pipeline: {
	      type: 'string'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>/_create',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [delete](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-delete.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the delete operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>} params.parent - ID of parent document
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the effected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api['delete'] = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    parent: {
	      type: 'string'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [deleteByQuery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-delete-by-query.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer to use for the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcard and prefix queries should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The field to use as default where no field prefix is given in the query string
	 * @param {<<api-param-type-number,`Number`>>} params.from - Starting offset (default: 0)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.conflicts=abort] - What to do when the delete-by-query hits version conflicts?
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.scroll - Specify how long a consistent view of the index should be maintained for scrolled search
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.searchTimeout - Explicit timeout for each search request. Defaults to no timeout.
	 * @param {<<api-param-type-number,`Number`>>} params.size - Number of hits to return (default: 10)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.sort - A comma-separated list of <field>:<direction> pairs
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-number,`Number`>>} params.terminateAfter - The maximum number of documents to collect for each shard, upon reaching which the query execution will terminate early.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.stats - Specific 'tag' of the request for logging and statistical purposes
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.version - Specify whether to return document version as part of a hit
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.requestCache - Specify if request cache should be used for this request or not, defaults to index level setting
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Should the effected indexes be refreshed?
	 * @param {<<api-param-type-duration-string,`DurationString`>>} [params.timeout=1m] - Time each individual bulk request should wait for shards that are unavailable.
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the delete by query operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-number,`Number`>>} params.scrollSize - Size on the scroll request powering the update_by_query
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.waitForCompletion=true] - Should the request should block until the delete-by-query is complete.
	 * @param {<<api-param-type-number,`Number`>>} params.requestsPerSecond - The throttle for this request in sub-requests per second. -1 means no throttle.
	 * @param {<<api-param-type-number,`Number`>>} [params.slices=1] - The number of slices this task should be divided into. Defaults to 1 meaning the task isn't sliced into subtasks.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to search; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to search; leave empty to perform the operation on all types
	 */
	api.deleteByQuery = ca({
	  params: {
	    analyzer: {
	      type: 'string'
	    },
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    from: {
	      type: 'number'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    conflicts: {
	      type: 'enum',
	      'default': 'abort',
	      options: [
	        'abort',
	        'proceed'
	      ]
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    lenient: {
	      type: 'boolean'
	    },
	    preference: {
	      type: 'string'
	    },
	    q: {
	      type: 'string'
	    },
	    routing: {
	      type: 'list'
	    },
	    scroll: {
	      type: 'time'
	    },
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'dfs_query_then_fetch'
	      ],
	      name: 'search_type'
	    },
	    searchTimeout: {
	      type: 'time',
	      name: 'search_timeout'
	    },
	    size: {
	      type: 'number'
	    },
	    sort: {
	      type: 'list'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    terminateAfter: {
	      type: 'number',
	      name: 'terminate_after'
	    },
	    stats: {
	      type: 'list'
	    },
	    version: {
	      type: 'boolean'
	    },
	    requestCache: {
	      type: 'boolean',
	      name: 'request_cache'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    timeout: {
	      type: 'time',
	      'default': '1m'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    scrollSize: {
	      type: 'number',
	      name: 'scroll_size'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      'default': true,
	      name: 'wait_for_completion'
	    },
	    requestsPerSecond: {
	      type: 'number',
	      'default': 0,
	      name: 'requests_per_second'
	    },
	    slices: {
	      type: 'number',
	      'default': 1
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_delete_by_query',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_delete_by_query',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [deleteScript](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-scripting.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Script ID
	 * @param {<<api-param-type-string,`String`>>} params.lang - Script language
	 */
	api.deleteScript = ca({
	  urls: [
	    {
	      fmt: '/_scripts/<%=lang%>/<%=id%>',
	      req: {
	        lang: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_scripts/<%=lang%>',
	      req: {
	        lang: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  method: 'DELETE'
	});

	/**
	 * Perform a [deleteTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Template ID
	 */
	api.deleteTemplate = ca({
	  url: {
	    fmt: '/_search/template/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [exists](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-get.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.parent - The ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specify whether to perform the operation in realtime or search mode
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Refresh the shard containing the document before performing the operation
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document (use `_all` to fetch the first document matching the ID across all types)
	 */
	api.exists = ca({
	  params: {
	    parent: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    realtime: {
	      type: 'boolean'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    routing: {
	      type: 'string'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'HEAD'
	});

	/**
	 * Perform a [explain](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-explain.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcards and prefix queries in the query string query should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer for the query string query
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The default field for query string query (default: _all)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.storedFields - A comma-separated list of stored fields to return in the response
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-string,`String`>>} params.parent - The ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.explain = ca({
	  params: {
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    analyzer: {
	      type: 'string'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    storedFields: {
	      type: 'list',
	      name: 'stored_fields'
	    },
	    lenient: {
	      type: 'boolean'
	    },
	    parent: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    q: {
	      type: 'string'
	    },
	    routing: {
	      type: 'string'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>/_explain',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [fieldStats](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-field-stats.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields for to get field statistics for (min value, max value, and more)
	 * @param {<<api-param-type-string,`String`>>} [params.level=cluster] - Defines if field stats should be returned on a per index level or on a cluster wide level
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.fieldStats = ca({
	  params: {
	    fields: {
	      type: 'list'
	    },
	    level: {
	      type: 'enum',
	      'default': 'cluster',
	      options: [
	        'indices',
	        'cluster'
	      ]
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_field_stats',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_field_stats'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [get](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-get.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.storedFields - A comma-separated list of stored fields to return in the response
	 * @param {<<api-param-type-string,`String`>>} params.parent - The ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specify whether to perform the operation in realtime or search mode
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Refresh the shard containing the document before performing the operation
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document (use `_all` to fetch the first document matching the ID across all types)
	 */
	api.get = ca({
	  params: {
	    storedFields: {
	      type: 'list',
	      name: 'stored_fields'
	    },
	    parent: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    realtime: {
	      type: 'boolean'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    routing: {
	      type: 'string'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  }
	});

	/**
	 * Perform a [getScript](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-scripting.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Script ID
	 * @param {<<api-param-type-string,`String`>>} params.lang - Script language
	 */
	api.getScript = ca({
	  urls: [
	    {
	      fmt: '/_scripts/<%=lang%>/<%=id%>',
	      req: {
	        lang: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_scripts/<%=lang%>',
	      req: {
	        lang: {
	          type: 'string'
	        }
	      }
	    }
	  ]
	});

	/**
	 * Perform a [getSource](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-get.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.parent - The ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specify whether to perform the operation in realtime or search mode
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Refresh the shard containing the document before performing the operation
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document; use `_all` to fetch the first document matching the ID across all types
	 */
	api.getSource = ca({
	  params: {
	    parent: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    realtime: {
	      type: 'boolean'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    routing: {
	      type: 'string'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>/_source',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  }
	});

	/**
	 * Perform a [getTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Template ID
	 */
	api.getTemplate = ca({
	  url: {
	    fmt: '/_search/template/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  }
	});

	/**
	 * Perform a [index](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-index_.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the index operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>} [params.opType=index] - Explicit operation type
	 * @param {<<api-param-type-string,`String`>>} params.parent - ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the affected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timestamp - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.ttl - Expiration time for the document
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.pipeline - The pipeline id to preprocess incoming documents with
	 * @param {<<api-param-type-string,`String`>>} params.id - Document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.index = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    opType: {
	      type: 'enum',
	      'default': 'index',
	      options: [
	        'index',
	        'create'
	      ],
	      name: 'op_type'
	    },
	    parent: {
	      type: 'string'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    timestamp: {
	      type: 'time'
	    },
	    ttl: {
	      type: 'time'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    },
	    pipeline: {
	      type: 'string'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/<%=id%>',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/<%=type%>',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	api.indices = namespace();

	/**
	 * Perform a [indices.analyze](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-analyze.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The name of the analyzer to use
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.charFilter - A comma-separated list of character filters to use for the analysis
	 * @param {<<api-param-type-string,`String`>>} params.field - Use the analyzer configured for this field (instead of passing the analyzer name)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.filter - A comma-separated list of filters to use for the analysis
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index to scope the operation
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.preferLocal - With `true`, specify that a local shard should be used if available, with `false`, use a random shard (default: true)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.text - The text on which the analysis should be performed (when request body is not used)
	 * @param {<<api-param-type-string,`String`>>} params.tokenizer - The name of the tokenizer to use for the analysis
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.explain - With `true`, outputs more advanced details. (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.attributes - A comma-separated list of token attributes to output, this parameter works only with `explain=true`
	 * @param {<<api-param-type-string,`String`>>} [params.format=detailed] - Format of the output
	 */
	api.indices.prototype.analyze = ca({
	  params: {
	    analyzer: {
	      type: 'string'
	    },
	    charFilter: {
	      type: 'list',
	      name: 'char_filter'
	    },
	    field: {
	      type: 'string'
	    },
	    filter: {
	      type: 'list'
	    },
	    index: {
	      type: 'string'
	    },
	    preferLocal: {
	      type: 'boolean',
	      name: 'prefer_local'
	    },
	    text: {
	      type: 'list'
	    },
	    tokenizer: {
	      type: 'string'
	    },
	    explain: {
	      type: 'boolean'
	    },
	    attributes: {
	      type: 'list'
	    },
	    format: {
	      type: 'enum',
	      'default': 'detailed',
	      options: [
	        'detailed',
	        'text'
	      ]
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_analyze',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_analyze'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.clearCache](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-clearcache.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.fieldData - Clear field data
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.fielddata - Clear field data
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields to clear when using the `field_data` parameter (default: all)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.query - Clear query caches
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index name to limit the operation
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.recycler - Clear the recycler cache
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.request - Clear request cache
	 */
	api.indices.prototype.clearCache = ca({
	  params: {
	    fieldData: {
	      type: 'boolean',
	      name: 'field_data'
	    },
	    fielddata: {
	      type: 'boolean'
	    },
	    fields: {
	      type: 'list'
	    },
	    query: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    index: {
	      type: 'list'
	    },
	    recycler: {
	      type: 'boolean'
	    },
	    request: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_cache/clear',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cache/clear'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.close](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-open-close.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma separated list of indices to close
	 */
	api.indices.prototype.close = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_close',
	    req: {
	      index: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [indices.create](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-create-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Set the number of active shards to wait for before the operation returns.
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.updateAllTypes - Whether to update the mapping for all fields with the same name across all types or not
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 */
	api.indices.prototype.create = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    updateAllTypes: {
	      type: 'boolean',
	      name: 'update_all_types'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>',
	    req: {
	      index: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.delete](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-delete-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of indices to delete; use `_all` or `*` string to delete all indices
	 */
	api.indices.prototype['delete'] = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>',
	    req: {
	      index: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [indices.deleteAlias](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names (supports wildcards); use `_all` for all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - A comma-separated list of aliases to delete (supports wildcards); use `_all` to delete all aliases for the specified indices.
	 */
	api.indices.prototype.deleteAlias = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_alias/<%=name%>',
	    req: {
	      index: {
	        type: 'list'
	      },
	      name: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [indices.deleteTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>} params.name - The name of the template
	 */
	api.indices.prototype.deleteTemplate = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/_template/<%=name%>',
	    req: {
	      name: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [indices.exists](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-exists.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of indices to check
	 */
	api.indices.prototype.exists = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>',
	    req: {
	      index: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'HEAD'
	});

	/**
	 * Perform a [indices.existsAlias](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open,closed] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to filter aliases
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - A comma-separated list of alias names to return
	 */
	api.indices.prototype.existsAlias = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': [
	        'open',
	        'closed'
	      ],
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_alias/<%=name%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_alias/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_alias',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    }
	  ],
	  method: 'HEAD'
	});

	/**
	 * Perform a [indices.existsTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.name - The name of the template
	 */
	api.indices.prototype.existsTemplate = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  url: {
	    fmt: '/_template/<%=name%>',
	    req: {
	      name: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'HEAD'
	});

	/**
	 * Perform a [indices.existsType](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-types-exists.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` to check the types across all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to check
	 */
	api.indices.prototype.existsType = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_mapping/<%=type%>',
	    req: {
	      index: {
	        type: 'list'
	      },
	      type: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'HEAD'
	});

	/**
	 * Perform a [indices.flush](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-flush.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.force - Whether a flush should be forced even if it is not necessarily needed ie. if no changes will be committed to the index. This is useful if transaction log IDs should be incremented even if no uncommitted changes are present. (This setting can be considered as internal)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitIfOngoing - If set to true the flush operation will block until the flush can be executed if another flush operation is already executing. The default is true. If set to false the flush will be skipped iff if another flush operation is already running.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string for all indices
	 */
	api.indices.prototype.flush = ca({
	  params: {
	    force: {
	      type: 'boolean'
	    },
	    waitIfOngoing: {
	      type: 'boolean',
	      name: 'wait_if_ongoing'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_flush',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_flush'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.flushSynced](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-synced-flush.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string for all indices
	 */
	api.indices.prototype.flushSynced = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_flush/synced',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_flush/synced'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.forcemerge](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-forcemerge.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flush - Specify whether the index should be flushed after performing the operation (default: true)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-number,`Number`>>} params.maxNumSegments - The number of segments the index should be merged into (default: dynamic)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.onlyExpungeDeletes - Specify whether the operation should only expunge deleted documents
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForMerge - Specify whether the request should block until the merge process is finished (default: true)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.forcemerge = ca({
	  params: {
	    flush: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    maxNumSegments: {
	      type: 'number',
	      name: 'max_num_segments'
	    },
	    onlyExpungeDeletes: {
	      type: 'boolean',
	      name: 'only_expunge_deletes'
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    },
	    waitForMerge: {
	      type: 'boolean',
	      name: 'wait_for_merge'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_forcemerge',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_forcemerge'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.get](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-get-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Ignore unavailable indexes (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Ignore if a wildcard expression resolves to no concrete indices (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether wildcard expressions should get expanded to open or closed indices (default: open)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDefaults - Whether to return all default setting for each of the indices.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.feature - A comma-separated list of features
	 */
	api.indices.prototype.get = ca({
	  params: {
	    local: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    includeDefaults: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_defaults'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=feature%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        feature: {
	          type: 'list',
	          options: [
	            '_settings',
	            '_mappings',
	            '_aliases'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    }
	  ]
	});

	/**
	 * Perform a [indices.getAlias](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=all] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to filter aliases
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - A comma-separated list of alias names to return
	 */
	api.indices.prototype.getAlias = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'all',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_alias/<%=name%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_alias/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_alias',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_alias'
	    }
	  ]
	});

	/**
	 * Perform a [indices.getFieldMapping](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-get-field-mapping.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDefaults - Whether the default mapping values should be returned as well
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields
	 */
	api.indices.prototype.getFieldMapping = ca({
	  params: {
	    includeDefaults: {
	      type: 'boolean',
	      name: 'include_defaults'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_mapping/<%=type%>/field/<%=fields%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        },
	        fields: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mapping/field/<%=fields%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        fields: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping/<%=type%>/field/<%=fields%>',
	      req: {
	        type: {
	          type: 'list'
	        },
	        fields: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping/field/<%=fields%>',
	      req: {
	        fields: {
	          type: 'list'
	        }
	      }
	    }
	  ]
	});

	/**
	 * Perform a [indices.getMapping](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-get-mapping.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types
	 */
	api.indices.prototype.getMapping = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_mapping/<%=type%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mapping',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping/<%=type%>',
	      req: {
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping'
	    }
	  ]
	});

	/**
	 * Perform a [indices.getSettings](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-get-settings.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open,closed] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDefaults - Whether to return all default setting for each of the indices.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - The name of the settings that should be included
	 */
	api.indices.prototype.getSettings = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': [
	        'open',
	        'closed'
	      ],
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    local: {
	      type: 'boolean'
	    },
	    includeDefaults: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_defaults'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_settings/<%=name%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_settings',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_settings/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_settings'
	    }
	  ]
	});

	/**
	 * Perform a [indices.getTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - The comma separated names of the index templates
	 */
	api.indices.prototype.getTemplate = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_template/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_template'
	    }
	  ]
	});

	/**
	 * Perform a [indices.getUpgrade](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-upgrade.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.getUpgrade = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_upgrade',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_upgrade'
	    }
	  ]
	});

	/**
	 * Perform a [indices.open](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-open-close.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=closed] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma separated list of indices to open
	 */
	api.indices.prototype.open = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'closed',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_open',
	    req: {
	      index: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [indices.putAlias](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names the alias should point to (supports wildcards); use `_all` to perform the operation on all indices.
	 * @param {<<api-param-type-string,`String`>>} params.name - The name of the alias to be created or updated
	 */
	api.indices.prototype.putAlias = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_alias/<%=name%>',
	    req: {
	      index: {
	        type: 'list'
	      },
	      name: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.putMapping](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-put-mapping.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.updateAllTypes - Whether to update the mapping for all fields with the same name across all types or not
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names the mapping should be added to (supports wildcards); use `_all` or omit to add the mapping on all indices.
	 * @param {<<api-param-type-string,`String`>>} params.type - The name of the document type
	 */
	api.indices.prototype.putMapping = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    updateAllTypes: {
	      type: 'boolean',
	      name: 'update_all_types'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_mapping/<%=type%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping/<%=type%>',
	      req: {
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.putSettings](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-update-settings.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.preserveExisting - Whether to update existing settings. If set to `true` existing settings on an index remain unchanged, the default is `false`
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.putSettings = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    preserveExisting: {
	      type: 'boolean',
	      name: 'preserve_existing'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_settings',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_settings'
	    }
	  ],
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.putTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-number,`Number`>>} params.order - The order for this template when merging multiple matching ones (higher numbers are merged later, overriding the lower numbers)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.create - Whether the index template should only be added if new or can also replace an existing one
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.name - The name of the template
	 */
	api.indices.prototype.putTemplate = ca({
	  params: {
	    order: {
	      type: 'number'
	    },
	    create: {
	      type: 'boolean',
	      'default': false
	    },
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    }
	  },
	  url: {
	    fmt: '/_template/<%=name%>',
	    req: {
	      name: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.recovery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-recovery.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.detailed - Whether to display detailed information about shard recovery
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.activeOnly - Display only those recoveries that are currently on-going
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.recovery = ca({
	  params: {
	    detailed: {
	      type: 'boolean',
	      'default': false
	    },
	    activeOnly: {
	      type: 'boolean',
	      'default': false,
	      name: 'active_only'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_recovery',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_recovery'
	    }
	  ]
	});

	/**
	 * Perform a [indices.refresh](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-refresh.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.force - Force a refresh even if not required
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.refresh = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    force: {
	      type: 'boolean',
	      'default': false
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_refresh',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_refresh'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.rollover](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-rollover-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.dryRun - If set to true the rollover action will only be validated but not actually performed even if a condition matches. The default is false
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Set the number of active shards to wait for on the newly created rollover index before the operation returns.
	 * @param {<<api-param-type-string,`String`>>} params.alias - The name of the alias to rollover
	 * @param {<<api-param-type-string,`String`>>} params.newIndex - The name of the rollover index
	 */
	api.indices.prototype.rollover = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    dryRun: {
	      type: 'boolean',
	      name: 'dry_run'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=alias%>/_rollover/<%=newIndex%>',
	      req: {
	        alias: {
	          type: 'string'
	        },
	        newIndex: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=alias%>/_rollover',
	      req: {
	        alias: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.segments](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-segments.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.verbose - Includes detailed memory usage by Lucene.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.segments = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    },
	    verbose: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_segments',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_segments'
	    }
	  ]
	});

	/**
	 * Perform a [indices.shardStores](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-shards-stores.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.status - A comma-separated list of statuses used to filter on shards to get store information for
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.shardStores = ca({
	  params: {
	    status: {
	      type: 'list',
	      options: [
	        'green',
	        'yellow',
	        'red',
	        'all'
	      ]
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_shard_stores',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_shard_stores'
	    }
	  ]
	});

	/**
	 * Perform a [indices.shrink](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-shrink-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Set the number of active shards to wait for on the shrunken index before the operation returns.
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the source index to shrink
	 * @param {<<api-param-type-string,`String`>>} params.target - The name of the target index to shrink into
	 */
	api.indices.prototype.shrink = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_shrink/<%=target%>',
	    req: {
	      index: {
	        type: 'string'
	      },
	      target: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [indices.stats](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-stats.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.completionFields - A comma-separated list of fields for `fielddata` and `suggest` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fielddataFields - A comma-separated list of fields for `fielddata` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields for `fielddata` and `completion` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.groups - A comma-separated list of search groups for `search` index metric
	 * @param {<<api-param-type-string,`String`>>} [params.level=indices] - Return stats aggregated at cluster, index or shard level
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.types - A comma-separated list of document types for the `indexing` index metric
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeSegmentFileSizes - Whether to report the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - Limit the information returned the specific metrics.
	 */
	api.indices.prototype.stats = ca({
	  params: {
	    completionFields: {
	      type: 'list',
	      name: 'completion_fields'
	    },
	    fielddataFields: {
	      type: 'list',
	      name: 'fielddata_fields'
	    },
	    fields: {
	      type: 'list'
	    },
	    groups: {
	      type: 'list'
	    },
	    level: {
	      type: 'enum',
	      'default': 'indices',
	      options: [
	        'cluster',
	        'indices',
	        'shards'
	      ]
	    },
	    types: {
	      type: 'list'
	    },
	    includeSegmentFileSizes: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_segment_file_sizes'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_stats/<%=metric%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'completion',
	            'docs',
	            'fielddata',
	            'query_cache',
	            'flush',
	            'get',
	            'indexing',
	            'merge',
	            'percolate',
	            'request_cache',
	            'refresh',
	            'search',
	            'segments',
	            'store',
	            'warmer',
	            'suggest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_stats/<%=metric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'completion',
	            'docs',
	            'fielddata',
	            'query_cache',
	            'flush',
	            'get',
	            'indexing',
	            'merge',
	            'percolate',
	            'request_cache',
	            'refresh',
	            'search',
	            'segments',
	            'store',
	            'warmer',
	            'suggest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_stats',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_stats'
	    }
	  ]
	});

	/**
	 * Perform a [indices.updateAliases](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Request timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 */
	api.indices.prototype.updateAliases = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/_aliases'
	  },
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [indices.upgrade](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-upgrade.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForCompletion - Specify whether the request should block until the all segments are upgraded (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.onlyAncientSegments - If true, only ancient (an older Lucene major release) segments will be upgraded
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.upgrade = ca({
	  params: {
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      name: 'wait_for_completion'
	    },
	    onlyAncientSegments: {
	      type: 'boolean',
	      name: 'only_ancient_segments'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_upgrade',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_upgrade'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.validateQuery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-validate.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.explain - Return detailed information about the error
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer to use for the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcard and prefix queries should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The field to use as default where no field prefix is given in the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.rewrite - Provide a more detailed explanation showing the actual Lucene query that will be executed.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to restrict the operation; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to restrict the operation; leave empty to perform the operation on all types
	 */
	api.indices.prototype.validateQuery = ca({
	  params: {
	    explain: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    },
	    q: {
	      type: 'string'
	    },
	    analyzer: {
	      type: 'string'
	    },
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    lenient: {
	      type: 'boolean'
	    },
	    rewrite: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_validate/query',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_validate/query',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_validate/query'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [info](https://www.elastic.co/guide/) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 */
	api.info = ca({
	  url: {
	    fmt: '/'
	  }
	});

	api.ingest = namespace();

	/**
	 * Perform a [ingest.deletePipeline](https://www.elastic.co/guide/en/elasticsearch/plugins/5.x/ingest.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.id - Pipeline ID
	 */
	api.ingest.prototype.deletePipeline = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_ingest/pipeline/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [ingest.getPipeline](https://www.elastic.co/guide/en/elasticsearch/plugins/5.x/ingest.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>} params.id - Comma separated list of pipeline ids. Wildcards supported
	 */
	api.ingest.prototype.getPipeline = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_ingest/pipeline/<%=id%>',
	      req: {
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_ingest/pipeline'
	    }
	  ]
	});

	/**
	 * Perform a [ingest.putPipeline](https://www.elastic.co/guide/en/elasticsearch/plugins/5.x/ingest.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.id - Pipeline ID
	 */
	api.ingest.prototype.putPipeline = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_ingest/pipeline/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [ingest.simulate](https://www.elastic.co/guide/en/elasticsearch/plugins/5.x/ingest.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.verbose - Verbose mode. Display data output for each processor in executed pipeline
	 * @param {<<api-param-type-string,`String`>>} params.id - Pipeline ID
	 */
	api.ingest.prototype.simulate = ca({
	  params: {
	    verbose: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_ingest/pipeline/<%=id%>/_simulate',
	      req: {
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_ingest/pipeline/_simulate'
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [mget](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-multi-get.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.storedFields - A comma-separated list of stored fields to return in the response
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specify whether to perform the operation in realtime or search mode
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Refresh the shard containing the document before performing the operation
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.mget = ca({
	  params: {
	    storedFields: {
	      type: 'list',
	      name: 'stored_fields'
	    },
	    preference: {
	      type: 'string'
	    },
	    realtime: {
	      type: 'boolean'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    routing: {
	      type: 'string'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_mget',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mget',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_mget'
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [mpercolate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-percolate.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>} params.index - The index of the document being count percolated to use as default
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document being percolated to use as default.
	 */
	api.mpercolate = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_mpercolate',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mpercolate',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_mpercolate'
	    }
	  ],
	  needBody: true,
	  bulkBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [msearch](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-multi-search.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-number,`Number`>>} params.maxConcurrentSearches - Controls the maximum number of concurrent searches the multi search api will execute
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to use as default
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to use as default
	 */
	api.msearch = ca({
	  params: {
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'query_and_fetch',
	        'dfs_query_then_fetch',
	        'dfs_query_and_fetch'
	      ],
	      name: 'search_type'
	    },
	    maxConcurrentSearches: {
	      type: 'number',
	      name: 'max_concurrent_searches'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_msearch',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_msearch',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_msearch'
	    }
	  ],
	  needBody: true,
	  bulkBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [msearchTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to use as default
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to use as default
	 */
	api.msearchTemplate = ca({
	  params: {
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'query_and_fetch',
	        'dfs_query_then_fetch',
	        'dfs_query_and_fetch'
	      ],
	      name: 'search_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_msearch/template',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_msearch/template',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_msearch/template'
	    }
	  ],
	  needBody: true,
	  bulkBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [mtermvectors](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-multi-termvectors.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.ids - A comma-separated list of documents ids. You must define ids as parameter or set "ids" or "docs" in the request body
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.termStatistics - Specifies if total term frequency and document frequency should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.fieldStatistics=true] - Specifies if document count, sum of document frequencies and sum of total term frequencies should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields to return. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.offsets=true] - Specifies if term offsets should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.positions=true] - Specifies if term positions should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.payloads=true] - Specifies if term payloads should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random) .Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-string,`String`>>} params.parent - Parent id of documents. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specifies if requests are real-time as opposed to near-real-time (default: true).
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.index - The index in which the document resides.
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document.
	 */
	api.mtermvectors = ca({
	  params: {
	    ids: {
	      type: 'list',
	      required: false
	    },
	    termStatistics: {
	      type: 'boolean',
	      'default': false,
	      required: false,
	      name: 'term_statistics'
	    },
	    fieldStatistics: {
	      type: 'boolean',
	      'default': true,
	      required: false,
	      name: 'field_statistics'
	    },
	    fields: {
	      type: 'list',
	      required: false
	    },
	    offsets: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    positions: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    payloads: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    preference: {
	      type: 'string',
	      required: false
	    },
	    routing: {
	      type: 'string',
	      required: false
	    },
	    parent: {
	      type: 'string',
	      required: false
	    },
	    realtime: {
	      type: 'boolean',
	      required: false
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_mtermvectors',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mtermvectors',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_mtermvectors'
	    }
	  ],
	  method: 'POST'
	});

	api.nodes = namespace();

	/**
	 * Perform a [nodes.hotThreads](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-nodes-hot-threads.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.interval - The interval for the second sampling of threads
	 * @param {<<api-param-type-number,`Number`>>} params.snapshots - Number of samples of thread stacktrace (default: 10)
	 * @param {<<api-param-type-number,`Number`>>} params.threads - Specify the number of threads to provide information for (default: 3)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreIdleThreads - Don't show threads that are in known-idle places, such as waiting on a socket select or pulling from an empty task queue (default: true)
	 * @param {<<api-param-type-string,`String`>>} params.type - The type to sample (default: cpu)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 */
	api.nodes.prototype.hotThreads = ca({
	  params: {
	    interval: {
	      type: 'time'
	    },
	    snapshots: {
	      type: 'number'
	    },
	    threads: {
	      type: 'number'
	    },
	    ignoreIdleThreads: {
	      type: 'boolean',
	      name: 'ignore_idle_threads'
	    },
	    type: {
	      type: 'enum',
	      options: [
	        'cpu',
	        'wait',
	        'block'
	      ]
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_nodes/<%=nodeId%>/hotthreads',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/hotthreads'
	    }
	  ]
	});

	/**
	 * Perform a [nodes.info](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-nodes-info.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - A comma-separated list of metrics you wish returned. Leave empty to return all.
	 */
	api.nodes.prototype.info = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_nodes/<%=nodeId%>/<%=metric%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        },
	        metric: {
	          type: 'list',
	          options: [
	            'settings',
	            'os',
	            'process',
	            'jvm',
	            'thread_pool',
	            'transport',
	            'http',
	            'plugins',
	            'ingest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/<%=nodeId%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/<%=metric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            'settings',
	            'os',
	            'process',
	            'jvm',
	            'thread_pool',
	            'transport',
	            'http',
	            'plugins',
	            'ingest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes'
	    }
	  ]
	});

	/**
	 * Perform a [nodes.stats](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-nodes-stats.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.completionFields - A comma-separated list of fields for `fielddata` and `suggest` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fielddataFields - A comma-separated list of fields for `fielddata` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields for `fielddata` and `completion` index metric (supports wildcards)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.groups - A comma-separated list of search groups for `search` index metric
	 * @param {<<api-param-type-string,`String`>>} [params.level=node] - Return indices stats aggregated at index, node or shard level
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.types - A comma-separated list of document types for the `indexing` index metric
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeSegmentFileSizes - Whether to report the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - Limit the information returned to the specified metrics
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.indexMetric - Limit the information returned for `indices` metric to the specific index metrics. Isn't used if `indices` (or `all`) metric isn't specified.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 */
	api.nodes.prototype.stats = ca({
	  params: {
	    completionFields: {
	      type: 'list',
	      name: 'completion_fields'
	    },
	    fielddataFields: {
	      type: 'list',
	      name: 'fielddata_fields'
	    },
	    fields: {
	      type: 'list'
	    },
	    groups: {
	      type: 'boolean'
	    },
	    level: {
	      type: 'enum',
	      'default': 'node',
	      options: [
	        'indices',
	        'node',
	        'shards'
	      ]
	    },
	    types: {
	      type: 'list'
	    },
	    timeout: {
	      type: 'time'
	    },
	    includeSegmentFileSizes: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_segment_file_sizes'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_nodes/<%=nodeId%>/stats/<%=metric%>/<%=indexMetric%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        },
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'breaker',
	            'fs',
	            'http',
	            'indices',
	            'jvm',
	            'os',
	            'process',
	            'thread_pool',
	            'transport',
	            'discovery'
	          ]
	        },
	        indexMetric: {
	          type: 'list',
	          options: [
	            '_all',
	            'completion',
	            'docs',
	            'fielddata',
	            'query_cache',
	            'flush',
	            'get',
	            'indexing',
	            'merge',
	            'percolate',
	            'request_cache',
	            'refresh',
	            'search',
	            'segments',
	            'store',
	            'warmer',
	            'suggest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/<%=nodeId%>/stats/<%=metric%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        },
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'breaker',
	            'fs',
	            'http',
	            'indices',
	            'jvm',
	            'os',
	            'process',
	            'thread_pool',
	            'transport',
	            'discovery'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/stats/<%=metric%>/<%=indexMetric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'breaker',
	            'fs',
	            'http',
	            'indices',
	            'jvm',
	            'os',
	            'process',
	            'thread_pool',
	            'transport',
	            'discovery'
	          ]
	        },
	        indexMetric: {
	          type: 'list',
	          options: [
	            '_all',
	            'completion',
	            'docs',
	            'fielddata',
	            'query_cache',
	            'flush',
	            'get',
	            'indexing',
	            'merge',
	            'percolate',
	            'request_cache',
	            'refresh',
	            'search',
	            'segments',
	            'store',
	            'warmer',
	            'suggest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/<%=nodeId%>/stats',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/stats/<%=metric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'breaker',
	            'fs',
	            'http',
	            'indices',
	            'jvm',
	            'os',
	            'process',
	            'thread_pool',
	            'transport',
	            'discovery'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/stats'
	    }
	  ]
	});

	/**
	 * Perform a [percolate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-percolate.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>} params.percolateIndex - The index to percolate the document into. Defaults to index.
	 * @param {<<api-param-type-string,`String`>>} params.percolateType - The type to percolate document into. Defaults to type.
	 * @param {<<api-param-type-string,`String`>>} params.percolateRouting - The routing value to use when percolating the existing document.
	 * @param {<<api-param-type-string,`String`>>} params.percolatePreference - Which shard to prefer when executing the percolate request.
	 * @param {<<api-param-type-string,`String`>>} params.percolateFormat - Return an array of matching query IDs instead of objects
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.index - The index of the document being percolated.
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document being percolated.
	 * @param {<<api-param-type-string,`String`>>} params.id - Substitute the document in the request body with a document that is known by the specified id. On top of the id, the index and type parameter will be used to retrieve the document from within the cluster.
	 */
	api.percolate = ca({
	  params: {
	    routing: {
	      type: 'list'
	    },
	    preference: {
	      type: 'string'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    percolateIndex: {
	      type: 'string',
	      name: 'percolate_index'
	    },
	    percolateType: {
	      type: 'string',
	      name: 'percolate_type'
	    },
	    percolateRouting: {
	      type: 'string',
	      name: 'percolate_routing'
	    },
	    percolatePreference: {
	      type: 'string',
	      name: 'percolate_preference'
	    },
	    percolateFormat: {
	      type: 'enum',
	      options: [
	        'ids'
	      ],
	      name: 'percolate_format'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/<%=id%>/_percolate',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/<%=type%>/_percolate',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [ping](https://www.elastic.co/guide/) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 */
	api.ping = ca({
	  url: {
	    fmt: '/'
	  },
	  requestTimeout: 3000,
	  method: 'HEAD'
	});

	/**
	 * Perform a [putScript](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-scripting.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Script ID
	 * @param {<<api-param-type-string,`String`>>} params.lang - Script language
	 */
	api.putScript = ca({
	  urls: [
	    {
	      fmt: '/_scripts/<%=lang%>/<%=id%>',
	      req: {
	        lang: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_scripts/<%=lang%>',
	      req: {
	        lang: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [putTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Template ID
	 */
	api.putTemplate = ca({
	  url: {
	    fmt: '/_search/template/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [reindex](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-reindex.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Should the effected indexes be refreshed?
	 * @param {<<api-param-type-duration-string,`DurationString`>>} [params.timeout=1m] - Time each individual bulk request should wait for shards that are unavailable.
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the reindex operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.waitForCompletion=true] - Should the request should block until the reindex is complete.
	 * @param {<<api-param-type-number,`Number`>>} params.requestsPerSecond - The throttle to set on this request in sub-requests per second. -1 means no throttle.
	 * @param {<<api-param-type-number,`Number`>>} [params.slices=1] - The number of slices this task should be divided into. Defaults to 1 meaning the task isn't sliced into subtasks.
	 */
	api.reindex = ca({
	  params: {
	    refresh: {
	      type: 'boolean'
	    },
	    timeout: {
	      type: 'time',
	      'default': '1m'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      'default': true,
	      name: 'wait_for_completion'
	    },
	    requestsPerSecond: {
	      type: 'number',
	      'default': 0,
	      name: 'requests_per_second'
	    },
	    slices: {
	      type: 'number',
	      'default': 1
	    }
	  },
	  url: {
	    fmt: '/_reindex'
	  },
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [reindexRethrottle](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-reindex.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-number,`Number`>>} params.requestsPerSecond - The throttle to set on this request in floating sub-requests per second. -1 means set no throttle.
	 * @param {<<api-param-type-string,`String`>>} params.taskId - The task id to rethrottle
	 */
	api.reindexRethrottle = ca({
	  params: {
	    requestsPerSecond: {
	      type: 'number',
	      required: true,
	      name: 'requests_per_second'
	    }
	  },
	  url: {
	    fmt: '/_reindex/<%=taskId%>/_rethrottle',
	    req: {
	      taskId: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [renderSearchTemplate](http://www.elasticsearch.org/guide/en/elasticsearch/reference/5.x/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - The id of the stored search template
	 */
	api.renderSearchTemplate = ca({
	  urls: [
	    {
	      fmt: '/_render/template/<%=id%>',
	      req: {
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_render/template'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [scroll](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-request-scroll.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.scroll - Specify how long a consistent view of the index should be maintained for scrolled search
	 * @param {<<api-param-type-string,`String`>>} params.scrollId - The scroll ID
	 */
	api.scroll = ca({
	  params: {
	    scroll: {
	      type: 'time'
	    },
	    scrollId: {
	      type: 'string',
	      name: 'scroll_id'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_search/scroll/<%=scrollId%>',
	      req: {
	        scrollId: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_search/scroll'
	    }
	  ],
	  paramAsBody: {
	    param: 'scrollId',
	    body: 'scroll_id'
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [search](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-search.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer to use for the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcard and prefix queries should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The field to use as default where no field prefix is given in the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.explain - Specify whether to return detailed information about score computation as part of a hit
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.storedFields - A comma-separated list of stored fields to return as part of a hit
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.docvalueFields - A comma-separated list of fields to return as the docvalue representation of a field for each hit
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fielddataFields - A comma-separated list of fields to return as the docvalue representation of a field for each hit
	 * @param {<<api-param-type-number,`Number`>>} params.from - Starting offset (default: 0)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.scroll - Specify how long a consistent view of the index should be maintained for scrolled search
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-number,`Number`>>} params.size - Number of hits to return (default: 10)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.sort - A comma-separated list of <field>:<direction> pairs
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-number,`Number`>>} params.terminateAfter - The maximum number of documents to collect for each shard, upon reaching which the query execution will terminate early.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.stats - Specific 'tag' of the request for logging and statistical purposes
	 * @param {<<api-param-type-string,`String`>>} params.suggestField - Specify which field to use for suggestions
	 * @param {<<api-param-type-string,`String`>>} [params.suggestMode=missing] - Specify suggest mode
	 * @param {<<api-param-type-number,`Number`>>} params.suggestSize - How many suggestions to return in response
	 * @param {<<api-param-type-string,`String`>>} params.suggestText - The source text for which the suggestions should be returned
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.trackScores - Whether to calculate and return scores even if they are not used for sorting
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.version - Specify whether to return document version as part of a hit
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.requestCache - Specify if request cache should be used for this request or not, defaults to index level setting
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to search; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to search; leave empty to perform the operation on all types
	 */
	api.search = ca({
	  params: {
	    analyzer: {
	      type: 'string'
	    },
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    explain: {
	      type: 'boolean'
	    },
	    storedFields: {
	      type: 'list',
	      name: 'stored_fields'
	    },
	    docvalueFields: {
	      type: 'list',
	      name: 'docvalue_fields'
	    },
	    fielddataFields: {
	      type: 'list',
	      name: 'fielddata_fields'
	    },
	    from: {
	      type: 'number'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    lenient: {
	      type: 'boolean'
	    },
	    preference: {
	      type: 'string'
	    },
	    q: {
	      type: 'string'
	    },
	    routing: {
	      type: 'list'
	    },
	    scroll: {
	      type: 'time'
	    },
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'dfs_query_then_fetch'
	      ],
	      name: 'search_type'
	    },
	    size: {
	      type: 'number'
	    },
	    sort: {
	      type: 'list'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    terminateAfter: {
	      type: 'number',
	      name: 'terminate_after'
	    },
	    stats: {
	      type: 'list'
	    },
	    suggestField: {
	      type: 'string',
	      name: 'suggest_field'
	    },
	    suggestMode: {
	      type: 'enum',
	      'default': 'missing',
	      options: [
	        'missing',
	        'popular',
	        'always'
	      ],
	      name: 'suggest_mode'
	    },
	    suggestSize: {
	      type: 'number',
	      name: 'suggest_size'
	    },
	    suggestText: {
	      type: 'string',
	      name: 'suggest_text'
	    },
	    timeout: {
	      type: 'time'
	    },
	    trackScores: {
	      type: 'boolean',
	      name: 'track_scores'
	    },
	    version: {
	      type: 'boolean'
	    },
	    requestCache: {
	      type: 'boolean',
	      name: 'request_cache'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_search',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_search',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_search'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [searchShards](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-shards.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to search; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to search; leave empty to perform the operation on all types
	 */
	api.searchShards = ca({
	  params: {
	    preference: {
	      type: 'string'
	    },
	    routing: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_search_shards',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_search_shards',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_search_shards'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [searchTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.scroll - Specify how long a consistent view of the index should be maintained for scrolled search
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.explain - Specify whether to return detailed information about score computation as part of a hit
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.profile - Specify whether to profile the query execution
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to search; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to search; leave empty to perform the operation on all types
	 */
	api.searchTemplate = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    preference: {
	      type: 'string'
	    },
	    routing: {
	      type: 'list'
	    },
	    scroll: {
	      type: 'time'
	    },
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'query_and_fetch',
	        'dfs_query_then_fetch',
	        'dfs_query_and_fetch'
	      ],
	      name: 'search_type'
	    },
	    explain: {
	      type: 'boolean'
	    },
	    profile: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_search/template',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_search/template',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_search/template'
	    }
	  ],
	  method: 'POST'
	});

	api.snapshot = namespace();

	/**
	 * Perform a [snapshot.create](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForCompletion - Should this request wait until the operation has completed before returning
	 * @param {<<api-param-type-string,`String`>>} params.repository - A repository name
	 * @param {<<api-param-type-string,`String`>>} params.snapshot - A snapshot name
	 */
	api.snapshot.prototype.create = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      'default': false,
	      name: 'wait_for_completion'
	    }
	  },
	  url: {
	    fmt: '/_snapshot/<%=repository%>/<%=snapshot%>',
	    req: {
	      repository: {
	        type: 'string'
	      },
	      snapshot: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [snapshot.createRepository](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.verify - Whether to verify the repository after creation
	 * @param {<<api-param-type-string,`String`>>} params.repository - A repository name
	 */
	api.snapshot.prototype.createRepository = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    },
	    verify: {
	      type: 'boolean'
	    }
	  },
	  url: {
	    fmt: '/_snapshot/<%=repository%>',
	    req: {
	      repository: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [snapshot.delete](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>} params.repository - A repository name
	 * @param {<<api-param-type-string,`String`>>} params.snapshot - A snapshot name
	 */
	api.snapshot.prototype['delete'] = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/_snapshot/<%=repository%>/<%=snapshot%>',
	    req: {
	      repository: {
	        type: 'string'
	      },
	      snapshot: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [snapshot.deleteRepository](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.repository - A comma-separated list of repository names
	 */
	api.snapshot.prototype.deleteRepository = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_snapshot/<%=repository%>',
	    req: {
	      repository: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [snapshot.get](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether to ignore unavailable snapshots, defaults to false which means a SnapshotMissingException is thrown
	 * @param {<<api-param-type-string,`String`>>} params.repository - A repository name
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.snapshot - A comma-separated list of snapshot names
	 */
	api.snapshot.prototype.get = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    }
	  },
	  url: {
	    fmt: '/_snapshot/<%=repository%>/<%=snapshot%>',
	    req: {
	      repository: {
	        type: 'string'
	      },
	      snapshot: {
	        type: 'list'
	      }
	    }
	  }
	});

	/**
	 * Perform a [snapshot.getRepository](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.repository - A comma-separated list of repository names
	 */
	api.snapshot.prototype.getRepository = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_snapshot/<%=repository%>',
	      req: {
	        repository: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_snapshot'
	    }
	  ]
	});

	/**
	 * Perform a [snapshot.restore](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForCompletion - Should this request wait until the operation has completed before returning
	 * @param {<<api-param-type-string,`String`>>} params.repository - A repository name
	 * @param {<<api-param-type-string,`String`>>} params.snapshot - A snapshot name
	 */
	api.snapshot.prototype.restore = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      'default': false,
	      name: 'wait_for_completion'
	    }
	  },
	  url: {
	    fmt: '/_snapshot/<%=repository%>/<%=snapshot%>/_restore',
	    req: {
	      repository: {
	        type: 'string'
	      },
	      snapshot: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [snapshot.status](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether to ignore unavailable snapshots, defaults to false which means a SnapshotMissingException is thrown
	 * @param {<<api-param-type-string,`String`>>} params.repository - A repository name
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.snapshot - A comma-separated list of snapshot names
	 */
	api.snapshot.prototype.status = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_snapshot/<%=repository%>/<%=snapshot%>/_status',
	      req: {
	        repository: {
	          type: 'string'
	        },
	        snapshot: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_snapshot/<%=repository%>/_status',
	      req: {
	        repository: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_snapshot/_status'
	    }
	  ]
	});

	/**
	 * Perform a [snapshot.verifyRepository](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.repository - A repository name
	 */
	api.snapshot.prototype.verifyRepository = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_snapshot/<%=repository%>/_verify',
	    req: {
	      repository: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [suggest](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-suggesters.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to restrict the operation; use `_all` or empty string to perform the operation on all indices
	 */
	api.suggest = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    preference: {
	      type: 'string'
	    },
	    routing: {
	      type: 'string'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_suggest',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_suggest'
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	api.tasks = namespace();

	/**
	 * Perform a [tasks.cancel](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/tasks.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.actions - A comma-separated list of actions that should be cancelled. Leave empty to cancel all.
	 * @param {<<api-param-type-string,`String`>>} params.parentNode - Cancel tasks with specified parent node.
	 * @param {<<api-param-type-string,`String`>>} params.parentTask - Cancel tasks with specified parent task id (node_id:task_number). Set to -1 to cancel all.
	 * @param {<<api-param-type-string,`String`>>} params.taskId - Cancel the task with specified task id (node_id:task_number)
	 */
	api.tasks.prototype.cancel = ca({
	  params: {
	    nodeId: {
	      type: 'list',
	      name: 'node_id'
	    },
	    actions: {
	      type: 'list'
	    },
	    parentNode: {
	      type: 'string',
	      name: 'parent_node'
	    },
	    parentTask: {
	      type: 'string',
	      name: 'parent_task'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_tasks/<%=taskId%>/_cancel',
	      req: {
	        taskId: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_tasks/_cancel'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [tasks.get](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/tasks.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForCompletion - Wait for the matching tasks to complete (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.taskId - Return the task with specified id (node_id:task_number)
	 */
	api.tasks.prototype.get = ca({
	  params: {
	    waitForCompletion: {
	      type: 'boolean',
	      name: 'wait_for_completion'
	    }
	  },
	  url: {
	    fmt: '/_tasks/<%=taskId%>',
	    req: {
	      taskId: {
	        type: 'string'
	      }
	    }
	  }
	});

	/**
	 * Perform a [tasks.list](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/tasks.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.actions - A comma-separated list of actions that should be returned. Leave empty to return all.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.detailed - Return detailed task information (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.parentNode - Return tasks with specified parent node.
	 * @param {<<api-param-type-string,`String`>>} params.parentTask - Return tasks with specified parent task id (node_id:task_number). Set to -1 to return all.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForCompletion - Wait for the matching tasks to complete (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.groupBy=nodes] - Group tasks by nodes or parent/child relationships
	 */
	api.tasks.prototype.list = ca({
	  params: {
	    nodeId: {
	      type: 'list',
	      name: 'node_id'
	    },
	    actions: {
	      type: 'list'
	    },
	    detailed: {
	      type: 'boolean'
	    },
	    parentNode: {
	      type: 'string',
	      name: 'parent_node'
	    },
	    parentTask: {
	      type: 'string',
	      name: 'parent_task'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      name: 'wait_for_completion'
	    },
	    groupBy: {
	      type: 'enum',
	      'default': 'nodes',
	      options: [
	        'nodes',
	        'parents'
	      ],
	      name: 'group_by'
	    }
	  },
	  url: {
	    fmt: '/_tasks'
	  }
	});

	/**
	 * Perform a [termvectors](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-termvectors.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.termStatistics - Specifies if total term frequency and document frequency should be returned.
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.fieldStatistics=true] - Specifies if document count, sum of document frequencies and sum of total term frequencies should be returned.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields to return.
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.offsets=true] - Specifies if term offsets should be returned.
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.positions=true] - Specifies if term positions should be returned.
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.payloads=true] - Specifies if term payloads should be returned.
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random).
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value.
	 * @param {<<api-param-type-string,`String`>>} params.parent - Parent id of documents.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specifies if request is real-time as opposed to near-real-time (default: true).
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.index - The index in which the document resides.
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document.
	 * @param {<<api-param-type-string,`String`>>} params.id - The id of the document, when not specified a doc param should be supplied.
	 */
	api.termvectors = ca({
	  params: {
	    termStatistics: {
	      type: 'boolean',
	      'default': false,
	      required: false,
	      name: 'term_statistics'
	    },
	    fieldStatistics: {
	      type: 'boolean',
	      'default': true,
	      required: false,
	      name: 'field_statistics'
	    },
	    fields: {
	      type: 'list',
	      required: false
	    },
	    offsets: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    positions: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    payloads: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    preference: {
	      type: 'string',
	      required: false
	    },
	    routing: {
	      type: 'string',
	      required: false
	    },
	    parent: {
	      type: 'string',
	      required: false
	    },
	    realtime: {
	      type: 'boolean',
	      required: false
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/<%=id%>/_termvectors',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/<%=type%>/_termvectors',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [update](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-update.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the update operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields to return in the response
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-string,`String`>>} params.lang - The script language (default: painless)
	 * @param {<<api-param-type-string,`String`>>} params.parent - ID of the parent document. Is is only used for routing and when for the upsert request
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the effected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-number,`Number`>>} params.retryOnConflict - Specify how many times should the operation be retried when a conflict occurs (default: 0)
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timestamp - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.ttl - Expiration time for the document
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.id - Document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.update = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    fields: {
	      type: 'list'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    lang: {
	      type: 'string'
	    },
	    parent: {
	      type: 'string'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    retryOnConflict: {
	      type: 'number',
	      name: 'retry_on_conflict'
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    timestamp: {
	      type: 'time'
	    },
	    ttl: {
	      type: 'time'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>/_update',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [updateByQuery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-update-by-query.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer to use for the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcard and prefix queries should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The field to use as default where no field prefix is given in the query string
	 * @param {<<api-param-type-number,`Number`>>} params.from - Starting offset (default: 0)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.conflicts=abort] - What to do when the update by query hits version conflicts?
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-string,`String`>>} params.pipeline - Ingest pipeline to set on index requests made by this action. (default: none)
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.scroll - Specify how long a consistent view of the index should be maintained for scrolled search
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.searchTimeout - Explicit timeout for each search request. Defaults to no timeout.
	 * @param {<<api-param-type-number,`Number`>>} params.size - Number of hits to return (default: 10)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.sort - A comma-separated list of <field>:<direction> pairs
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-number,`Number`>>} params.terminateAfter - The maximum number of documents to collect for each shard, upon reaching which the query execution will terminate early.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.stats - Specific 'tag' of the request for logging and statistical purposes
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.version - Specify whether to return document version as part of a hit
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.versionType - Should the document increment the version number (internal) on hit or not (reindex)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.requestCache - Specify if request cache should be used for this request or not, defaults to index level setting
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Should the effected indexes be refreshed?
	 * @param {<<api-param-type-duration-string,`DurationString`>>} [params.timeout=1m] - Time each individual bulk request should wait for shards that are unavailable.
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the update by query operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-number,`Number`>>} params.scrollSize - Size on the scroll request powering the update_by_query
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.waitForCompletion=true] - Should the request should block until the update by query operation is complete.
	 * @param {<<api-param-type-number,`Number`>>} params.requestsPerSecond - The throttle to set on this request in sub-requests per second. -1 means no throttle.
	 * @param {<<api-param-type-number,`Number`>>} [params.slices=1] - The number of slices this task should be divided into. Defaults to 1 meaning the task isn't sliced into subtasks.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to search; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to search; leave empty to perform the operation on all types
	 */
	api.updateByQuery = ca({
	  params: {
	    analyzer: {
	      type: 'string'
	    },
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    from: {
	      type: 'number'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    conflicts: {
	      type: 'enum',
	      'default': 'abort',
	      options: [
	        'abort',
	        'proceed'
	      ]
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    lenient: {
	      type: 'boolean'
	    },
	    pipeline: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    q: {
	      type: 'string'
	    },
	    routing: {
	      type: 'list'
	    },
	    scroll: {
	      type: 'time'
	    },
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'dfs_query_then_fetch'
	      ],
	      name: 'search_type'
	    },
	    searchTimeout: {
	      type: 'time',
	      name: 'search_timeout'
	    },
	    size: {
	      type: 'number'
	    },
	    sort: {
	      type: 'list'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    terminateAfter: {
	      type: 'number',
	      name: 'terminate_after'
	    },
	    stats: {
	      type: 'list'
	    },
	    version: {
	      type: 'boolean'
	    },
	    versionType: {
	      type: 'boolean',
	      name: 'version_type'
	    },
	    requestCache: {
	      type: 'boolean',
	      name: 'request_cache'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    timeout: {
	      type: 'time',
	      'default': '1m'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    scrollSize: {
	      type: 'number',
	      name: 'scroll_size'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      'default': true,
	      name: 'wait_for_completion'
	    },
	    requestsPerSecond: {
	      type: 'number',
	      'default': 0,
	      name: 'requests_per_second'
	    },
	    slices: {
	      type: 'number',
	      'default': 1
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_update_by_query',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_update_by_query',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    }
	  ],
	  method: 'POST'
	});


/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	var ca = __webpack_require__(47).makeFactoryWithModifier(function (spec) {
	  return __webpack_require__(5).merge(spec, {
	    params: {
	      filterPath: {
	        type: 'list',
	        name: 'filter_path'
	      }
	    }
	  });
	});
	var namespace = __webpack_require__(47).namespaceFactory;
	var api = module.exports = {};

	api._namespaces = ['cat', 'cluster', 'indices', 'ingest', 'nodes', 'snapshot', 'tasks'];

	/**
	 * Perform a [bulk](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-bulk.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the bulk operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the effected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.type - Default document type for items which don't provide one
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - Default comma-separated list of fields to return in the response for updates, can be overridden on each sub-request
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or default list of fields to return, can be overridden on each sub-request
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - Default list of fields to exclude from the returned _source field, can be overridden on each sub-request
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - Default list of fields to extract and return from the _source field, can be overridden on each sub-request
	 * @param {<<api-param-type-string,`String`>>} params.pipeline - The pipeline id to preprocess incoming documents with
	 * @param {<<api-param-type-string,`String`>>} params.index - Default index for items which don't provide one
	 */
	api.bulk = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    type: {
	      type: 'string'
	    },
	    fields: {
	      type: 'list'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    pipeline: {
	      type: 'string'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_bulk',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_bulk',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_bulk'
	    }
	  ],
	  needBody: true,
	  bulkBody: true,
	  method: 'POST'
	});

	api.cat = namespace();

	/**
	 * Perform a [cat.aliases](http://www.elasticsearch.org/guide/en/elasticsearch/reference/master/cat.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - A comma-separated list of alias names to return
	 */
	api.cat.prototype.aliases = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/aliases/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/aliases'
	    }
	  ]
	});

	/**
	 * Perform a [cat.allocation](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-allocation.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.bytes - The unit in which to display byte values
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information
	 */
	api.cat.prototype.allocation = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    bytes: {
	      type: 'enum',
	      options: [
	        'b',
	        'k',
	        'kb',
	        'm',
	        'mb',
	        'g',
	        'gb',
	        't',
	        'tb',
	        'p',
	        'pb'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/allocation/<%=nodeId%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/allocation'
	    }
	  ]
	});

	/**
	 * Perform a [cat.count](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-count.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.count = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/count/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/count'
	    }
	  ]
	});

	/**
	 * Perform a [cat.fielddata](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-fielddata.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.bytes - The unit in which to display byte values
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields to return the fielddata size
	 */
	api.cat.prototype.fielddata = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    bytes: {
	      type: 'enum',
	      options: [
	        'b',
	        'k',
	        'kb',
	        'm',
	        'mb',
	        'g',
	        'gb',
	        't',
	        'tb',
	        'p',
	        'pb'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    },
	    fields: {
	      type: 'list'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/fielddata/<%=fields%>',
	      req: {
	        fields: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/fielddata'
	    }
	  ]
	});

	/**
	 * Perform a [cat.health](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-health.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.ts=true] - Set to false to disable timestamping
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.health = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    ts: {
	      type: 'boolean',
	      'default': true
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/health'
	  }
	});

	/**
	 * Perform a [cat.help](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 */
	api.cat.prototype.help = ca({
	  params: {
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    }
	  },
	  url: {
	    fmt: '/_cat'
	  }
	});

	/**
	 * Perform a [cat.indices](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-indices.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.bytes - The unit in which to display byte values
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-string,`String`>>} params.health - A health status ("green", "yellow", or "red" to filter only indices matching the specified health status
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.pri - Set to true to return stats only for primary shards
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.indices = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    bytes: {
	      type: 'enum',
	      options: [
	        'b',
	        'k',
	        'm',
	        'g'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    health: {
	      type: 'enum',
	      'default': null,
	      options: [
	        'green',
	        'yellow',
	        'red'
	      ]
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    pri: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/indices/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/indices'
	    }
	  ]
	});

	/**
	 * Perform a [cat.master](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-master.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.master = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/master'
	  }
	});

	/**
	 * Perform a [cat.nodeattrs](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-nodeattrs.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.nodeattrs = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/nodeattrs'
	  }
	});

	/**
	 * Perform a [cat.nodes](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-nodes.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.fullId - Return the full node ID instead of the shortened version (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.nodes = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    fullId: {
	      type: 'boolean',
	      name: 'full_id'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/nodes'
	  }
	});

	/**
	 * Perform a [cat.pendingTasks](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-pending-tasks.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.pendingTasks = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/pending_tasks'
	  }
	});

	/**
	 * Perform a [cat.plugins](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-plugins.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.plugins = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/plugins'
	  }
	});

	/**
	 * Perform a [cat.recovery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-recovery.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.bytes - The unit in which to display byte values
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.recovery = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    bytes: {
	      type: 'enum',
	      options: [
	        'b',
	        'k',
	        'kb',
	        'm',
	        'mb',
	        'g',
	        'gb',
	        't',
	        'tb',
	        'p',
	        'pb'
	      ]
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/recovery/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/recovery'
	    }
	  ]
	});

	/**
	 * Perform a [cat.repositories](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-repositories.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.repositories = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean',
	      'default': false
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/repositories'
	  }
	});

	/**
	 * Perform a [cat.segments](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-segments.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.segments = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/segments/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/segments'
	    }
	  ]
	});

	/**
	 * Perform a [cat.shards](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-shards.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to limit the returned information
	 */
	api.cat.prototype.shards = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/shards/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/shards'
	    }
	  ]
	});

	/**
	 * Perform a [cat.snapshots](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-snapshots.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Set to true to ignore unavailable snapshots
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.repository - Name of repository from which to fetch the snapshot information
	 */
	api.cat.prototype.snapshots = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      'default': false,
	      name: 'ignore_unavailable'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/snapshots/<%=repository%>',
	      req: {
	        repository: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/snapshots'
	    }
	  ]
	});

	/**
	 * Perform a [cat.tasks](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/tasks.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.actions - A comma-separated list of actions that should be returned. Leave empty to return all.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.detailed - Return detailed task information (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.parentNode - Return tasks with specified parent node.
	 * @param {<<api-param-type-number,`Number`>>} params.parentTask - Return tasks with specified parent task id. Set to -1 to return all.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 */
	api.cat.prototype.tasks = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    nodeId: {
	      type: 'list',
	      name: 'node_id'
	    },
	    actions: {
	      type: 'list'
	    },
	    detailed: {
	      type: 'boolean'
	    },
	    parentNode: {
	      type: 'string',
	      name: 'parent_node'
	    },
	    parentTask: {
	      type: 'number',
	      name: 'parent_task'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  url: {
	    fmt: '/_cat/tasks'
	  }
	});

	/**
	 * Perform a [cat.templates](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>} params.name - A pattern that returned template names must match
	 */
	api.cat.prototype.templates = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/templates/<%=name%>',
	      req: {
	        name: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/templates'
	    }
	  ]
	});

	/**
	 * Perform a [cat.threadPool](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cat-thread-pool.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.format - a short version of the Accept header, e.g. json, yaml
	 * @param {<<api-param-type-string,`String`>>} params.size - The multiplier in which to display values
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.h - Comma-separated list of column names to display
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.help - Return help information
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.s - Comma-separated list of column names or column aliases to sort by
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.v - Verbose mode. Display column headers
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.threadPoolPatterns - A comma-separated list of regular-expressions to filter the thread pools in the output
	 */
	api.cat.prototype.threadPool = ca({
	  params: {
	    format: {
	      type: 'string'
	    },
	    size: {
	      type: 'enum',
	      options: [
	        '',
	        'k',
	        'm',
	        'g',
	        't',
	        'p'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    h: {
	      type: 'list'
	    },
	    help: {
	      type: 'boolean',
	      'default': false
	    },
	    s: {
	      type: 'list'
	    },
	    v: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cat/thread_pool/<%=threadPoolPatterns%>',
	      req: {
	        threadPoolPatterns: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cat/thread_pool'
	    }
	  ]
	});

	/**
	 * Perform a [clearScroll](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-request-scroll.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.scrollId - A comma-separated list of scroll IDs to clear
	 */
	api.clearScroll = ca({
	  urls: [
	    {
	      fmt: '/_search/scroll/<%=scrollId%>',
	      req: {
	        scrollId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_search/scroll'
	    }
	  ],
	  paramAsBody: 'scrollId',
	  method: 'DELETE'
	});

	api.cluster = namespace();

	/**
	 * Perform a [cluster.allocationExplain](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-allocation-explain.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeYesDecisions - Return 'YES' decisions in explanation (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDiskInfo - Return information about disk usage and shard sizes (default: false)
	 */
	api.cluster.prototype.allocationExplain = ca({
	  params: {
	    includeYesDecisions: {
	      type: 'boolean',
	      name: 'include_yes_decisions'
	    },
	    includeDiskInfo: {
	      type: 'boolean',
	      name: 'include_disk_info'
	    }
	  },
	  url: {
	    fmt: '/_cluster/allocation/explain'
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [cluster.getSettings](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-update-settings.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDefaults - Whether to return all default clusters setting.
	 */
	api.cluster.prototype.getSettings = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    },
	    includeDefaults: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_defaults'
	    }
	  },
	  url: {
	    fmt: '/_cluster/settings'
	  }
	});

	/**
	 * Perform a [cluster.health](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-health.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} [params.level=cluster] - Specify the level of detail for returned information
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Wait until the specified number of shards is active
	 * @param {<<api-param-type-string,`String`>>} params.waitForNodes - Wait until the specified number of nodes is available
	 * @param {<<api-param-type-string,`String`>>} params.waitForEvents - Wait until all currently queued events with the given priority are processed
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForNoRelocatingShards - Whether to wait until there are no relocating shards in the cluster
	 * @param {<<api-param-type-string,`String`>>} params.waitForStatus - Wait until cluster is in a specific state
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - Limit the information returned to a specific index
	 */
	api.cluster.prototype.health = ca({
	  params: {
	    level: {
	      type: 'enum',
	      'default': 'cluster',
	      options: [
	        'cluster',
	        'indices',
	        'shards'
	      ]
	    },
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    waitForNodes: {
	      type: 'string',
	      name: 'wait_for_nodes'
	    },
	    waitForEvents: {
	      type: 'enum',
	      options: [
	        'immediate',
	        'urgent',
	        'high',
	        'normal',
	        'low',
	        'languid'
	      ],
	      name: 'wait_for_events'
	    },
	    waitForNoRelocatingShards: {
	      type: 'boolean',
	      name: 'wait_for_no_relocating_shards'
	    },
	    waitForStatus: {
	      type: 'enum',
	      'default': null,
	      options: [
	        'green',
	        'yellow',
	        'red'
	      ],
	      name: 'wait_for_status'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cluster/health/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cluster/health'
	    }
	  ]
	});

	/**
	 * Perform a [cluster.pendingTasks](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-pending.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 */
	api.cluster.prototype.pendingTasks = ca({
	  params: {
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/_cluster/pending_tasks'
	  }
	});

	/**
	 * Perform a [cluster.putSettings](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-update-settings.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 */
	api.cluster.prototype.putSettings = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_cluster/settings'
	  },
	  method: 'PUT'
	});

	/**
	 * Perform a [cluster.reroute](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-reroute.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.dryRun - Simulate the operation only and return the resulting state
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.explain - Return an explanation of why the commands can or cannot be executed
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.retryFailed - Retries allocation of shards that are blocked due to too many subsequent allocation failures
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - Limit the information returned to the specified metrics. Defaults to all but metadata
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 */
	api.cluster.prototype.reroute = ca({
	  params: {
	    dryRun: {
	      type: 'boolean',
	      name: 'dry_run'
	    },
	    explain: {
	      type: 'boolean'
	    },
	    retryFailed: {
	      type: 'boolean',
	      name: 'retry_failed'
	    },
	    metric: {
	      type: 'list',
	      options: [
	        '_all',
	        'blocks',
	        'metadata',
	        'nodes',
	        'routing_table',
	        'master_node',
	        'version'
	      ]
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_cluster/reroute'
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [cluster.state](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-state.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - Limit the information returned to the specified metrics
	 */
	api.cluster.prototype.state = ca({
	  params: {
	    local: {
	      type: 'boolean'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cluster/state/<%=metric%>/<%=index%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'blocks',
	            'metadata',
	            'nodes',
	            'routing_table',
	            'routing_nodes',
	            'master_node',
	            'version'
	          ]
	        },
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cluster/state/<%=metric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'blocks',
	            'metadata',
	            'nodes',
	            'routing_table',
	            'routing_nodes',
	            'master_node',
	            'version'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_cluster/state'
	    }
	  ]
	});

	/**
	 * Perform a [cluster.stats](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-stats.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return time and byte values in human-readable format.
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 */
	api.cluster.prototype.stats = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_cluster/stats/nodes/<%=nodeId%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cluster/stats'
	    }
	  ]
	});

	/**
	 * Perform a [count](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-count.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-number,`Number`>>} params.minScore - Include only documents with a specific `_score` value in the result
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer to use for the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcard and prefix queries should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The field to use as default where no field prefix is given in the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of indices to restrict the results
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of types to restrict the results
	 */
	api.count = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    minScore: {
	      type: 'number',
	      name: 'min_score'
	    },
	    preference: {
	      type: 'string'
	    },
	    routing: {
	      type: 'string'
	    },
	    q: {
	      type: 'string'
	    },
	    analyzer: {
	      type: 'string'
	    },
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    lenient: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_count',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_count',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_count'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [countPercolate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-percolate.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>} params.percolateIndex - The index to count percolate the document into. Defaults to index.
	 * @param {<<api-param-type-string,`String`>>} params.percolateType - The type to count percolate document into. Defaults to type.
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.index - The index of the document being count percolated.
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document being count percolated.
	 * @param {<<api-param-type-string,`String`>>} params.id - Substitute the document in the request body with a document that is known by the specified id. On top of the id, the index and type parameter will be used to retrieve the document from within the cluster.
	 */
	api.countPercolate = ca({
	  params: {
	    routing: {
	      type: 'list'
	    },
	    preference: {
	      type: 'string'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    percolateIndex: {
	      type: 'string',
	      name: 'percolate_index'
	    },
	    percolateType: {
	      type: 'string',
	      name: 'percolate_type'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/<%=id%>/_percolate/count',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/<%=type%>/_percolate/count',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [create](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-index_.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the index operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>} params.parent - ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the affected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timestamp - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.ttl - Expiration time for the document
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.pipeline - The pipeline id to preprocess incoming documents with
	 * @param {<<api-param-type-string,`String`>>} params.id - Document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.create = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    parent: {
	      type: 'string'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    timestamp: {
	      type: 'time'
	    },
	    ttl: {
	      type: 'time'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    },
	    pipeline: {
	      type: 'string'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>/_create',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [delete](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-delete.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the delete operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>} params.parent - ID of parent document
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the effected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api['delete'] = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    parent: {
	      type: 'string'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [deleteByQuery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-delete-by-query.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer to use for the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcard and prefix queries should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The field to use as default where no field prefix is given in the query string
	 * @param {<<api-param-type-number,`Number`>>} params.from - Starting offset (default: 0)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.conflicts=abort] - What to do when the delete-by-query hits version conflicts?
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.scroll - Specify how long a consistent view of the index should be maintained for scrolled search
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.searchTimeout - Explicit timeout for each search request. Defaults to no timeout.
	 * @param {<<api-param-type-number,`Number`>>} params.size - Number of hits to return (default: 10)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.sort - A comma-separated list of <field>:<direction> pairs
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-number,`Number`>>} params.terminateAfter - The maximum number of documents to collect for each shard, upon reaching which the query execution will terminate early.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.stats - Specific 'tag' of the request for logging and statistical purposes
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.version - Specify whether to return document version as part of a hit
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.requestCache - Specify if request cache should be used for this request or not, defaults to index level setting
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Should the effected indexes be refreshed?
	 * @param {<<api-param-type-duration-string,`DurationString`>>} [params.timeout=1m] - Time each individual bulk request should wait for shards that are unavailable.
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the delete by query operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-number,`Number`>>} params.scrollSize - Size on the scroll request powering the update_by_query
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForCompletion - Should the request should block until the delete-by-query is complete.
	 * @param {<<api-param-type-number,`Number`>>} params.requestsPerSecond - The throttle for this request in sub-requests per second. -1 means no throttle.
	 * @param {<<api-param-type-number,`Number`>>} [params.slices=1] - The number of slices this task should be divided into. Defaults to 1 meaning the task isn't sliced into subtasks.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to search; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to search; leave empty to perform the operation on all types
	 */
	api.deleteByQuery = ca({
	  params: {
	    analyzer: {
	      type: 'string'
	    },
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    from: {
	      type: 'number'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    conflicts: {
	      type: 'enum',
	      'default': 'abort',
	      options: [
	        'abort',
	        'proceed'
	      ]
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    lenient: {
	      type: 'boolean'
	    },
	    preference: {
	      type: 'string'
	    },
	    q: {
	      type: 'string'
	    },
	    routing: {
	      type: 'list'
	    },
	    scroll: {
	      type: 'time'
	    },
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'dfs_query_then_fetch'
	      ],
	      name: 'search_type'
	    },
	    searchTimeout: {
	      type: 'time',
	      name: 'search_timeout'
	    },
	    size: {
	      type: 'number'
	    },
	    sort: {
	      type: 'list'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    terminateAfter: {
	      type: 'number',
	      name: 'terminate_after'
	    },
	    stats: {
	      type: 'list'
	    },
	    version: {
	      type: 'boolean'
	    },
	    requestCache: {
	      type: 'boolean',
	      name: 'request_cache'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    timeout: {
	      type: 'time',
	      'default': '1m'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    scrollSize: {
	      type: 'number',
	      name: 'scroll_size'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      'default': false,
	      name: 'wait_for_completion'
	    },
	    requestsPerSecond: {
	      type: 'number',
	      'default': 0,
	      name: 'requests_per_second'
	    },
	    slices: {
	      type: 'number',
	      'default': 1
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_delete_by_query',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_delete_by_query',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [deleteScript](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-scripting.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Script ID
	 * @param {<<api-param-type-string,`String`>>} params.lang - Script language
	 */
	api.deleteScript = ca({
	  url: {
	    fmt: '/_scripts/<%=lang%>/<%=id%>',
	    req: {
	      lang: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [deleteTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Template ID
	 */
	api.deleteTemplate = ca({
	  url: {
	    fmt: '/_search/template/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [exists](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-get.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.parent - The ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specify whether to perform the operation in realtime or search mode
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Refresh the shard containing the document before performing the operation
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document (use `_all` to fetch the first document matching the ID across all types)
	 */
	api.exists = ca({
	  params: {
	    parent: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    realtime: {
	      type: 'boolean'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    routing: {
	      type: 'string'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'HEAD'
	});

	/**
	 * Perform a [explain](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-explain.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcards and prefix queries in the query string query should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer for the query string query
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The default field for query string query (default: _all)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.storedFields - A comma-separated list of stored fields to return in the response
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-string,`String`>>} params.parent - The ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.explain = ca({
	  params: {
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    analyzer: {
	      type: 'string'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    storedFields: {
	      type: 'list',
	      name: 'stored_fields'
	    },
	    lenient: {
	      type: 'boolean'
	    },
	    parent: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    q: {
	      type: 'string'
	    },
	    routing: {
	      type: 'string'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>/_explain',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [fieldStats](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-field-stats.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields for to get field statistics for (min value, max value, and more)
	 * @param {<<api-param-type-string,`String`>>} [params.level=cluster] - Defines if field stats should be returned on a per index level or on a cluster wide level
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.fieldStats = ca({
	  params: {
	    fields: {
	      type: 'list'
	    },
	    level: {
	      type: 'enum',
	      'default': 'cluster',
	      options: [
	        'indices',
	        'cluster'
	      ]
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_field_stats',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_field_stats'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [get](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-get.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.storedFields - A comma-separated list of stored fields to return in the response
	 * @param {<<api-param-type-string,`String`>>} params.parent - The ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specify whether to perform the operation in realtime or search mode
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Refresh the shard containing the document before performing the operation
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document (use `_all` to fetch the first document matching the ID across all types)
	 */
	api.get = ca({
	  params: {
	    storedFields: {
	      type: 'list',
	      name: 'stored_fields'
	    },
	    parent: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    realtime: {
	      type: 'boolean'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    routing: {
	      type: 'string'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  }
	});

	/**
	 * Perform a [getScript](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-scripting.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Script ID
	 * @param {<<api-param-type-string,`String`>>} params.lang - Script language
	 */
	api.getScript = ca({
	  url: {
	    fmt: '/_scripts/<%=lang%>/<%=id%>',
	    req: {
	      lang: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  }
	});

	/**
	 * Perform a [getSource](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-get.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.parent - The ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specify whether to perform the operation in realtime or search mode
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Refresh the shard containing the document before performing the operation
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.id - The document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document; use `_all` to fetch the first document matching the ID across all types
	 */
	api.getSource = ca({
	  params: {
	    parent: {
	      type: 'string'
	    },
	    preference: {
	      type: 'string'
	    },
	    realtime: {
	      type: 'boolean'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    routing: {
	      type: 'string'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/<%=type%>/<%=id%>/_source',
	    req: {
	      index: {
	        type: 'string'
	      },
	      type: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  }
	});

	/**
	 * Perform a [getTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Template ID
	 */
	api.getTemplate = ca({
	  url: {
	    fmt: '/_search/template/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  }
	});

	/**
	 * Perform a [index](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-index_.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets the number of shard copies that must be active before proceeding with the index operation. Defaults to 1, meaning the primary shard only. Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1)
	 * @param {<<api-param-type-string,`String`>>} [params.opType=index] - Explicit operation type
	 * @param {<<api-param-type-string,`String`>>} params.parent - ID of the parent document
	 * @param {<<api-param-type-string,`String`>>} params.refresh - If `true` then refresh the affected shards to make this operation visible to search, if `wait_for` then wait for a refresh to make this operation visible to search, if `false` (the default) then do nothing with refreshes.
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timestamp - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.ttl - Expiration time for the document
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.pipeline - The pipeline id to preprocess incoming documents with
	 * @param {<<api-param-type-string,`String`>>} params.id - Document ID
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.index = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    opType: {
	      type: 'enum',
	      'default': 'index',
	      options: [
	        'index',
	        'create'
	      ],
	      name: 'op_type'
	    },
	    parent: {
	      type: 'string'
	    },
	    refresh: {
	      type: 'enum',
	      options: [
	        'true',
	        'false',
	        'wait_for',
	        ''
	      ]
	    },
	    routing: {
	      type: 'string'
	    },
	    timeout: {
	      type: 'time'
	    },
	    timestamp: {
	      type: 'time'
	    },
	    ttl: {
	      type: 'time'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    },
	    pipeline: {
	      type: 'string'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/<%=id%>',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/<%=type%>',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	api.indices = namespace();

	/**
	 * Perform a [indices.analyze](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-analyze.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The name of the analyzer to use
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.charFilter - A comma-separated list of character filters to use for the analysis
	 * @param {<<api-param-type-string,`String`>>} params.field - Use the analyzer configured for this field (instead of passing the analyzer name)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.filter - A comma-separated list of filters to use for the analysis
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index to scope the operation
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.preferLocal - With `true`, specify that a local shard should be used if available, with `false`, use a random shard (default: true)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.text - The text on which the analysis should be performed (when request body is not used)
	 * @param {<<api-param-type-string,`String`>>} params.tokenizer - The name of the tokenizer to use for the analysis
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.explain - With `true`, outputs more advanced details. (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.attributes - A comma-separated list of token attributes to output, this parameter works only with `explain=true`
	 * @param {<<api-param-type-string,`String`>>} [params.format=detailed] - Format of the output
	 */
	api.indices.prototype.analyze = ca({
	  params: {
	    analyzer: {
	      type: 'string'
	    },
	    charFilter: {
	      type: 'list',
	      name: 'char_filter'
	    },
	    field: {
	      type: 'string'
	    },
	    filter: {
	      type: 'list'
	    },
	    index: {
	      type: 'string'
	    },
	    preferLocal: {
	      type: 'boolean',
	      name: 'prefer_local'
	    },
	    text: {
	      type: 'list'
	    },
	    tokenizer: {
	      type: 'string'
	    },
	    explain: {
	      type: 'boolean'
	    },
	    attributes: {
	      type: 'list'
	    },
	    format: {
	      type: 'enum',
	      'default': 'detailed',
	      options: [
	        'detailed',
	        'text'
	      ]
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_analyze',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_analyze'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.clearCache](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-clearcache.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.fieldData - Clear field data
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.fielddata - Clear field data
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields to clear when using the `field_data` parameter (default: all)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.query - Clear query caches
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index name to limit the operation
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.recycler - Clear the recycler cache
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.request - Clear request cache
	 */
	api.indices.prototype.clearCache = ca({
	  params: {
	    fieldData: {
	      type: 'boolean',
	      name: 'field_data'
	    },
	    fielddata: {
	      type: 'boolean'
	    },
	    fields: {
	      type: 'list'
	    },
	    query: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    index: {
	      type: 'list'
	    },
	    recycler: {
	      type: 'boolean'
	    },
	    request: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_cache/clear',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_cache/clear'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.close](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-open-close.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma separated list of indices to close
	 */
	api.indices.prototype.close = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_close',
	    req: {
	      index: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [indices.create](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-create-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Set the number of active shards to wait for before the operation returns.
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.updateAllTypes - Whether to update the mapping for all fields with the same name across all types or not
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 */
	api.indices.prototype.create = ca({
	  params: {
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    },
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    updateAllTypes: {
	      type: 'boolean',
	      name: 'update_all_types'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>',
	    req: {
	      index: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.delete](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-delete-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of indices to delete; use `_all` or `*` string to delete all indices
	 */
	api.indices.prototype['delete'] = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>',
	    req: {
	      index: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [indices.deleteAlias](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names (supports wildcards); use `_all` for all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - A comma-separated list of aliases to delete (supports wildcards); use `_all` to delete all aliases for the specified indices.
	 */
	api.indices.prototype.deleteAlias = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_alias/<%=name%>',
	    req: {
	      index: {
	        type: 'list'
	      },
	      name: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [indices.deleteTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>} params.name - The name of the template
	 */
	api.indices.prototype.deleteTemplate = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/_template/<%=name%>',
	    req: {
	      name: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [indices.exists](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-exists.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of indices to check
	 */
	api.indices.prototype.exists = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>',
	    req: {
	      index: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'HEAD'
	});

	/**
	 * Perform a [indices.existsAlias](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open,closed] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to filter aliases
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - A comma-separated list of alias names to return
	 */
	api.indices.prototype.existsAlias = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': [
	        'open',
	        'closed'
	      ],
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_alias/<%=name%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_alias/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_alias',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    }
	  ],
	  method: 'HEAD'
	});

	/**
	 * Perform a [indices.existsTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.name - The name of the template
	 */
	api.indices.prototype.existsTemplate = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  url: {
	    fmt: '/_template/<%=name%>',
	    req: {
	      name: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'HEAD'
	});

	/**
	 * Perform a [indices.existsType](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-types-exists.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` to check the types across all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to check
	 */
	api.indices.prototype.existsType = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_mapping/<%=type%>',
	    req: {
	      index: {
	        type: 'list'
	      },
	      type: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'HEAD'
	});

	/**
	 * Perform a [indices.flush](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-flush.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.force - Whether a flush should be forced even if it is not necessarily needed ie. if no changes will be committed to the index. This is useful if transaction log IDs should be incremented even if no uncommitted changes are present. (This setting can be considered as internal)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitIfOngoing - If set to true the flush operation will block until the flush can be executed if another flush operation is already executing. The default is true. If set to false the flush will be skipped iff if another flush operation is already running.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string for all indices
	 */
	api.indices.prototype.flush = ca({
	  params: {
	    force: {
	      type: 'boolean'
	    },
	    waitIfOngoing: {
	      type: 'boolean',
	      name: 'wait_if_ongoing'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_flush',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_flush'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.flushSynced](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-synced-flush.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string for all indices
	 */
	api.indices.prototype.flushSynced = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_flush/synced',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_flush/synced'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.forcemerge](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-forcemerge.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flush - Specify whether the index should be flushed after performing the operation (default: true)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-number,`Number`>>} params.maxNumSegments - The number of segments the index should be merged into (default: dynamic)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.onlyExpungeDeletes - Specify whether the operation should only expunge deleted documents
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForMerge - Specify whether the request should block until the merge process is finished (default: true)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.forcemerge = ca({
	  params: {
	    flush: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    maxNumSegments: {
	      type: 'number',
	      name: 'max_num_segments'
	    },
	    onlyExpungeDeletes: {
	      type: 'boolean',
	      name: 'only_expunge_deletes'
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    },
	    waitForMerge: {
	      type: 'boolean',
	      name: 'wait_for_merge'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_forcemerge',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_forcemerge'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.get](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-get-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Ignore unavailable indexes (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Ignore if a wildcard expression resolves to no concrete indices (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether wildcard expressions should get expanded to open or closed indices (default: open)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return version and creation date values in human-readable format.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDefaults - Whether to return all default setting for each of the indices.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.feature - A comma-separated list of features
	 */
	api.indices.prototype.get = ca({
	  params: {
	    local: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    },
	    includeDefaults: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_defaults'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=feature%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        feature: {
	          type: 'list',
	          options: [
	            '_settings',
	            '_mappings',
	            '_aliases'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    }
	  ]
	});

	/**
	 * Perform a [indices.getAlias](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=all] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to filter aliases
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - A comma-separated list of alias names to return
	 */
	api.indices.prototype.getAlias = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'all',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_alias/<%=name%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_alias/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_alias',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_alias'
	    }
	  ]
	});

	/**
	 * Perform a [indices.getFieldMapping](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-get-field-mapping.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDefaults - Whether the default mapping values should be returned as well
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields
	 */
	api.indices.prototype.getFieldMapping = ca({
	  params: {
	    includeDefaults: {
	      type: 'boolean',
	      name: 'include_defaults'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_mapping/<%=type%>/field/<%=fields%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        },
	        fields: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mapping/field/<%=fields%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        fields: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping/<%=type%>/field/<%=fields%>',
	      req: {
	        type: {
	          type: 'list'
	        },
	        fields: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping/field/<%=fields%>',
	      req: {
	        fields: {
	          type: 'list'
	        }
	      }
	    }
	  ]
	});

	/**
	 * Perform a [indices.getMapping](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-get-mapping.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types
	 */
	api.indices.prototype.getMapping = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_mapping/<%=type%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mapping',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping/<%=type%>',
	      req: {
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping'
	    }
	  ]
	});

	/**
	 * Perform a [indices.getSettings](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-get-settings.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open,closed] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return version and creation date values in human-readable format.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeDefaults - Whether to return all default setting for each of the indices.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - The name of the settings that should be included
	 */
	api.indices.prototype.getSettings = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': [
	        'open',
	        'closed'
	      ],
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    local: {
	      type: 'boolean'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    },
	    includeDefaults: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_defaults'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_settings/<%=name%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_settings',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_settings/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_settings'
	    }
	  ]
	});

	/**
	 * Perform a [indices.getTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.local - Return local information, do not retrieve the state from master node (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.name - The comma separated names of the index templates
	 */
	api.indices.prototype.getTemplate = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    local: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_template/<%=name%>',
	      req: {
	        name: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_template'
	    }
	  ]
	});

	/**
	 * Perform a [indices.getUpgrade](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-upgrade.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return time and byte values in human-readable format.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.getUpgrade = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_upgrade',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_upgrade'
	    }
	  ]
	});

	/**
	 * Perform a [indices.open](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-open-close.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=closed] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma separated list of indices to open
	 */
	api.indices.prototype.open = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'closed',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_open',
	    req: {
	      index: {
	        type: 'list'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [indices.putAlias](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit timestamp for the document
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names the alias should point to (supports wildcards); use `_all` to perform the operation on all indices.
	 * @param {<<api-param-type-string,`String`>>} params.name - The name of the alias to be created or updated
	 */
	api.indices.prototype.putAlias = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_alias/<%=name%>',
	    req: {
	      index: {
	        type: 'list'
	      },
	      name: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.putMapping](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-put-mapping.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.updateAllTypes - Whether to update the mapping for all fields with the same name across all types or not
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names the mapping should be added to (supports wildcards); use `_all` or omit to add the mapping on all indices.
	 * @param {<<api-param-type-string,`String`>>} params.type - The name of the document type
	 */
	api.indices.prototype.putMapping = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    updateAllTypes: {
	      type: 'boolean',
	      name: 'update_all_types'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_mapping/<%=type%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_mapping/<%=type%>',
	      req: {
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.putSettings](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-update-settings.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.preserveExisting - Whether to update existing settings. If set to `true` existing settings on an index remain unchanged, the default is `false`
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.putSettings = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    preserveExisting: {
	      type: 'boolean',
	      name: 'preserve_existing'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_settings',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_settings'
	    }
	  ],
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.putTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-templates.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-number,`Number`>>} params.order - The order for this template when merging multiple matching ones (higher numbers are merged later, overriding the lower numbers)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.create - Whether the index template should only be added if new or can also replace an existing one
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-string,`String`>>} params.name - The name of the template
	 */
	api.indices.prototype.putTemplate = ca({
	  params: {
	    order: {
	      type: 'number'
	    },
	    create: {
	      type: 'boolean',
	      'default': false
	    },
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    }
	  },
	  url: {
	    fmt: '/_template/<%=name%>',
	    req: {
	      name: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [indices.recovery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-recovery.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.detailed - Whether to display detailed information about shard recovery
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.activeOnly - Display only those recoveries that are currently on-going
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return time and byte values in human-readable format.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.recovery = ca({
	  params: {
	    detailed: {
	      type: 'boolean',
	      'default': false
	    },
	    activeOnly: {
	      type: 'boolean',
	      'default': false,
	      name: 'active_only'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_recovery',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_recovery'
	    }
	  ]
	});

	/**
	 * Perform a [indices.refresh](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-refresh.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.force - Force a refresh even if not required
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.refresh = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    force: {
	      type: 'boolean',
	      'default': false
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_refresh',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_refresh'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.rollover](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-rollover-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.dryRun - If set to true the rollover action will only be validated but not actually performed even if a condition matches. The default is false
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Set the number of active shards to wait for on the newly created rollover index before the operation returns.
	 * @param {<<api-param-type-string,`String`>>} params.alias - The name of the alias to rollover
	 * @param {<<api-param-type-string,`String`>>} params.newIndex - The name of the rollover index
	 */
	api.indices.prototype.rollover = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    dryRun: {
	      type: 'boolean',
	      name: 'dry_run'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=alias%>/_rollover/<%=newIndex%>',
	      req: {
	        alias: {
	          type: 'string'
	        },
	        newIndex: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=alias%>/_rollover',
	      req: {
	        alias: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.segments](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-segments.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return time and byte values in human-readable format.
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.verbose - Includes detailed memory usage by Lucene.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.segments = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    },
	    verbose: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_segments',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_segments'
	    }
	  ]
	});

	/**
	 * Perform a [indices.shardStores](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-shards-stores.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.status - A comma-separated list of statuses used to filter on shards to get store information for
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.shardStores = ca({
	  params: {
	    status: {
	      type: 'list',
	      options: [
	        'green',
	        'yellow',
	        'red',
	        'all'
	      ]
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_shard_stores',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_shard_stores'
	    }
	  ]
	});

	/**
	 * Perform a [indices.shrink](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-shrink-index.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Set the number of active shards to wait for on the shrunken index before the operation returns.
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the source index to shrink
	 * @param {<<api-param-type-string,`String`>>} params.target - The name of the target index to shrink into
	 */
	api.indices.prototype.shrink = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    waitForActiveShards: {
	      type: 'string',
	      name: 'wait_for_active_shards'
	    }
	  },
	  url: {
	    fmt: '/<%=index%>/_shrink/<%=target%>',
	    req: {
	      index: {
	        type: 'string'
	      },
	      target: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'POST'
	});

	/**
	 * Perform a [indices.stats](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-stats.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.completionFields - A comma-separated list of fields for `fielddata` and `suggest` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fielddataFields - A comma-separated list of fields for `fielddata` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields for `fielddata` and `completion` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.groups - A comma-separated list of search groups for `search` index metric
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return time and byte values in human-readable format.
	 * @param {<<api-param-type-string,`String`>>} [params.level=indices] - Return stats aggregated at cluster, index or shard level
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.types - A comma-separated list of document types for the `indexing` index metric
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeSegmentFileSizes - Whether to report the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - Limit the information returned the specific metrics.
	 */
	api.indices.prototype.stats = ca({
	  params: {
	    completionFields: {
	      type: 'list',
	      name: 'completion_fields'
	    },
	    fielddataFields: {
	      type: 'list',
	      name: 'fielddata_fields'
	    },
	    fields: {
	      type: 'list'
	    },
	    groups: {
	      type: 'list'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    },
	    level: {
	      type: 'enum',
	      'default': 'indices',
	      options: [
	        'cluster',
	        'indices',
	        'shards'
	      ]
	    },
	    types: {
	      type: 'list'
	    },
	    includeSegmentFileSizes: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_segment_file_sizes'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_stats/<%=metric%>',
	      req: {
	        index: {
	          type: 'list'
	        },
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'completion',
	            'docs',
	            'fielddata',
	            'query_cache',
	            'flush',
	            'get',
	            'indexing',
	            'merge',
	            'percolate',
	            'request_cache',
	            'refresh',
	            'search',
	            'segments',
	            'store',
	            'warmer',
	            'suggest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_stats/<%=metric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'completion',
	            'docs',
	            'fielddata',
	            'query_cache',
	            'flush',
	            'get',
	            'indexing',
	            'merge',
	            'percolate',
	            'request_cache',
	            'refresh',
	            'search',
	            'segments',
	            'store',
	            'warmer',
	            'suggest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_stats',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_stats'
	    }
	  ]
	});

	/**
	 * Perform a [indices.updateAliases](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-aliases.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Request timeout
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Specify timeout for connection to master
	 */
	api.indices.prototype.updateAliases = ca({
	  params: {
	    timeout: {
	      type: 'time'
	    },
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  url: {
	    fmt: '/_aliases'
	  },
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [indices.upgrade](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/indices-upgrade.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.waitForCompletion - Specify whether the request should block until the all segments are upgraded (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.onlyAncientSegments - If true, only ancient (an older Lucene major release) segments will be upgraded
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names; use `_all` or empty string to perform the operation on all indices
	 */
	api.indices.prototype.upgrade = ca({
	  params: {
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    waitForCompletion: {
	      type: 'boolean',
	      name: 'wait_for_completion'
	    },
	    onlyAncientSegments: {
	      type: 'boolean',
	      name: 'only_ancient_segments'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/_upgrade',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_upgrade'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [indices.validateQuery](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-validate.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.explain - Return detailed information about the error
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {anything} params.operationThreading - TODO: ?
	 * @param {<<api-param-type-string,`String`>>} params.q - Query in the Lucene query string syntax
	 * @param {<<api-param-type-string,`String`>>} params.analyzer - The analyzer to use for the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.analyzeWildcard - Specify whether wildcard and prefix queries should be analyzed (default: false)
	 * @param {<<api-param-type-string,`String`>>} [params.defaultOperator=OR] - The default operator for query string query (AND or OR)
	 * @param {<<api-param-type-string,`String`>>} params.df - The field to use as default where no field prefix is given in the query string
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.lenient - Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.rewrite - Provide a more detailed explanation showing the actual Lucene query that will be executed.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to restrict the operation; use `_all` or empty string to perform the operation on all indices
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to restrict the operation; leave empty to perform the operation on all types
	 */
	api.indices.prototype.validateQuery = ca({
	  params: {
	    explain: {
	      type: 'boolean'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    operationThreading: {
	      name: 'operation_threading'
	    },
	    q: {
	      type: 'string'
	    },
	    analyzer: {
	      type: 'string'
	    },
	    analyzeWildcard: {
	      type: 'boolean',
	      name: 'analyze_wildcard'
	    },
	    defaultOperator: {
	      type: 'enum',
	      'default': 'OR',
	      options: [
	        'AND',
	        'OR'
	      ],
	      name: 'default_operator'
	    },
	    df: {
	      type: 'string'
	    },
	    lenient: {
	      type: 'boolean'
	    },
	    rewrite: {
	      type: 'boolean'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_validate/query',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_validate/query',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_validate/query'
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [info](https://www.elastic.co/guide/) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 */
	api.info = ca({
	  url: {
	    fmt: '/'
	  }
	});

	api.ingest = namespace();

	/**
	 * Perform a [ingest.deletePipeline](https://www.elastic.co/guide/en/elasticsearch/plugins/5.x/ingest.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.id - Pipeline ID
	 */
	api.ingest.prototype.deletePipeline = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_ingest/pipeline/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  method: 'DELETE'
	});

	/**
	 * Perform a [ingest.getPipeline](https://www.elastic.co/guide/en/elasticsearch/plugins/5.x/ingest.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-string,`String`>>} params.id - Comma separated list of pipeline ids. Wildcards supported
	 */
	api.ingest.prototype.getPipeline = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_ingest/pipeline/<%=id%>',
	      req: {
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_ingest/pipeline'
	    }
	  ]
	});

	/**
	 * Perform a [ingest.putPipeline](https://www.elastic.co/guide/en/elasticsearch/plugins/5.x/ingest.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.masterTimeout - Explicit operation timeout for connection to master node
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>} params.id - Pipeline ID
	 */
	api.ingest.prototype.putPipeline = ca({
	  params: {
	    masterTimeout: {
	      type: 'time',
	      name: 'master_timeout'
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  url: {
	    fmt: '/_ingest/pipeline/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [ingest.simulate](https://www.elastic.co/guide/en/elasticsearch/plugins/5.x/ingest.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.verbose - Verbose mode. Display data output for each processor in executed pipeline
	 * @param {<<api-param-type-string,`String`>>} params.id - Pipeline ID
	 */
	api.ingest.prototype.simulate = ca({
	  params: {
	    verbose: {
	      type: 'boolean',
	      'default': false
	    }
	  },
	  urls: [
	    {
	      fmt: '/_ingest/pipeline/<%=id%>/_simulate',
	      req: {
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_ingest/pipeline/_simulate'
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [mget](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-multi-get.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.storedFields - A comma-separated list of stored fields to return in the response
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specify whether to perform the operation in realtime or search mode
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Refresh the shard containing the document before performing the operation
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._source - True or false to return the _source field or not, or a list of fields to return
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceExclude - A list of fields to exclude from the returned _source field
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params._sourceInclude - A list of fields to extract and return from the _source field
	 * @param {<<api-param-type-string,`String`>>} params.index - The name of the index
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document
	 */
	api.mget = ca({
	  params: {
	    storedFields: {
	      type: 'list',
	      name: 'stored_fields'
	    },
	    preference: {
	      type: 'string'
	    },
	    realtime: {
	      type: 'boolean'
	    },
	    refresh: {
	      type: 'boolean'
	    },
	    routing: {
	      type: 'string'
	    },
	    _source: {
	      type: 'list'
	    },
	    _sourceExclude: {
	      type: 'list',
	      name: '_source_exclude'
	    },
	    _sourceInclude: {
	      type: 'list',
	      name: '_source_include'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_mget',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mget',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_mget'
	    }
	  ],
	  needBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [mpercolate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-percolate.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>} params.index - The index of the document being count percolated to use as default
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document being percolated to use as default.
	 */
	api.mpercolate = ca({
	  params: {
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_mpercolate',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mpercolate',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_mpercolate'
	    }
	  ],
	  needBody: true,
	  bulkBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [msearch](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-multi-search.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-number,`Number`>>} params.maxConcurrentSearches - Controls the maximum number of concurrent searches the multi search api will execute
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to use as default
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to use as default
	 */
	api.msearch = ca({
	  params: {
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'query_and_fetch',
	        'dfs_query_then_fetch',
	        'dfs_query_and_fetch'
	      ],
	      name: 'search_type'
	    },
	    maxConcurrentSearches: {
	      type: 'number',
	      name: 'max_concurrent_searches'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_msearch',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_msearch',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_msearch'
	    }
	  ],
	  needBody: true,
	  bulkBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [msearchTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.searchType - Search operation type
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.index - A comma-separated list of index names to use as default
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.type - A comma-separated list of document types to use as default
	 */
	api.msearchTemplate = ca({
	  params: {
	    searchType: {
	      type: 'enum',
	      options: [
	        'query_then_fetch',
	        'query_and_fetch',
	        'dfs_query_then_fetch',
	        'dfs_query_and_fetch'
	      ],
	      name: 'search_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_msearch/template',
	      req: {
	        index: {
	          type: 'list'
	        },
	        type: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_msearch/template',
	      req: {
	        index: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_msearch/template'
	    }
	  ],
	  needBody: true,
	  bulkBody: true,
	  method: 'POST'
	});

	/**
	 * Perform a [mtermvectors](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-multi-termvectors.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.ids - A comma-separated list of documents ids. You must define ids as parameter or set "ids" or "docs" in the request body
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.termStatistics - Specifies if total term frequency and document frequency should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.fieldStatistics=true] - Specifies if document count, sum of document frequencies and sum of total term frequencies should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields to return. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.offsets=true] - Specifies if term offsets should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.positions=true] - Specifies if term positions should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} [params.payloads=true] - Specifies if term payloads should be returned. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random) .Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-string,`String`>>} params.routing - Specific routing value. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-string,`String`>>} params.parent - Parent id of documents. Applies to all returned documents unless otherwise specified in body "params" or "docs".
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.realtime - Specifies if requests are real-time as opposed to near-real-time (default: true).
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.index - The index in which the document resides.
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document.
	 */
	api.mtermvectors = ca({
	  params: {
	    ids: {
	      type: 'list',
	      required: false
	    },
	    termStatistics: {
	      type: 'boolean',
	      'default': false,
	      required: false,
	      name: 'term_statistics'
	    },
	    fieldStatistics: {
	      type: 'boolean',
	      'default': true,
	      required: false,
	      name: 'field_statistics'
	    },
	    fields: {
	      type: 'list',
	      required: false
	    },
	    offsets: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    positions: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    payloads: {
	      type: 'boolean',
	      'default': true,
	      required: false
	    },
	    preference: {
	      type: 'string',
	      required: false
	    },
	    routing: {
	      type: 'string',
	      required: false
	    },
	    parent: {
	      type: 'string',
	      required: false
	    },
	    realtime: {
	      type: 'boolean',
	      required: false
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/_mtermvectors',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/_mtermvectors',
	      req: {
	        index: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/_mtermvectors'
	    }
	  ],
	  method: 'POST'
	});

	api.nodes = namespace();

	/**
	 * Perform a [nodes.hotThreads](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-nodes-hot-threads.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.interval - The interval for the second sampling of threads
	 * @param {<<api-param-type-number,`Number`>>} params.snapshots - Number of samples of thread stacktrace (default: 10)
	 * @param {<<api-param-type-number,`Number`>>} params.threads - Specify the number of threads to provide information for (default: 3)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreIdleThreads - Don't show threads that are in known-idle places, such as waiting on a socket select or pulling from an empty task queue (default: true)
	 * @param {<<api-param-type-string,`String`>>} params.type - The type to sample (default: cpu)
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 */
	api.nodes.prototype.hotThreads = ca({
	  params: {
	    interval: {
	      type: 'time'
	    },
	    snapshots: {
	      type: 'number'
	    },
	    threads: {
	      type: 'number'
	    },
	    ignoreIdleThreads: {
	      type: 'boolean',
	      name: 'ignore_idle_threads'
	    },
	    type: {
	      type: 'enum',
	      options: [
	        'cpu',
	        'wait',
	        'block'
	      ]
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_nodes/<%=nodeId%>/hotthreads',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/hotthreads'
	    }
	  ]
	});

	/**
	 * Perform a [nodes.info](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-nodes-info.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.flatSettings - Return settings in flat format (default: false)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return time and byte values in human-readable format.
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - A comma-separated list of metrics you wish returned. Leave empty to return all.
	 */
	api.nodes.prototype.info = ca({
	  params: {
	    flatSettings: {
	      type: 'boolean',
	      name: 'flat_settings'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    },
	    timeout: {
	      type: 'time'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_nodes/<%=nodeId%>/<%=metric%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        },
	        metric: {
	          type: 'list',
	          options: [
	            'settings',
	            'os',
	            'process',
	            'jvm',
	            'thread_pool',
	            'transport',
	            'http',
	            'plugins',
	            'ingest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/<%=nodeId%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/<%=metric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            'settings',
	            'os',
	            'process',
	            'jvm',
	            'thread_pool',
	            'transport',
	            'http',
	            'plugins',
	            'ingest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes'
	    }
	  ]
	});

	/**
	 * Perform a [nodes.stats](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/cluster-nodes-stats.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.completionFields - A comma-separated list of fields for `fielddata` and `suggest` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fielddataFields - A comma-separated list of fields for `fielddata` index metric (supports wildcards)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.fields - A comma-separated list of fields for `fielddata` and `completion` index metric (supports wildcards)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.groups - A comma-separated list of search groups for `search` index metric
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.human - Whether to return time and byte values in human-readable format.
	 * @param {<<api-param-type-string,`String`>>} [params.level=node] - Return indices stats aggregated at index, node or shard level
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.types - A comma-separated list of document types for the `indexing` index metric
	 * @param {<<api-param-type-duration-string,`DurationString`>>} params.timeout - Explicit operation timeout
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.includeSegmentFileSizes - Whether to report the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested)
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.metric - Limit the information returned to the specified metrics
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.indexMetric - Limit the information returned for `indices` metric to the specific index metrics. Isn't used if `indices` (or `all`) metric isn't specified.
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.nodeId - A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
	 */
	api.nodes.prototype.stats = ca({
	  params: {
	    completionFields: {
	      type: 'list',
	      name: 'completion_fields'
	    },
	    fielddataFields: {
	      type: 'list',
	      name: 'fielddata_fields'
	    },
	    fields: {
	      type: 'list'
	    },
	    groups: {
	      type: 'boolean'
	    },
	    human: {
	      type: 'boolean',
	      'default': false
	    },
	    level: {
	      type: 'enum',
	      'default': 'node',
	      options: [
	        'indices',
	        'node',
	        'shards'
	      ]
	    },
	    types: {
	      type: 'list'
	    },
	    timeout: {
	      type: 'time'
	    },
	    includeSegmentFileSizes: {
	      type: 'boolean',
	      'default': false,
	      name: 'include_segment_file_sizes'
	    }
	  },
	  urls: [
	    {
	      fmt: '/_nodes/<%=nodeId%>/stats/<%=metric%>/<%=indexMetric%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        },
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'breaker',
	            'fs',
	            'http',
	            'indices',
	            'jvm',
	            'os',
	            'process',
	            'thread_pool',
	            'transport',
	            'discovery'
	          ]
	        },
	        indexMetric: {
	          type: 'list',
	          options: [
	            '_all',
	            'completion',
	            'docs',
	            'fielddata',
	            'query_cache',
	            'flush',
	            'get',
	            'indexing',
	            'merge',
	            'percolate',
	            'request_cache',
	            'refresh',
	            'search',
	            'segments',
	            'store',
	            'warmer',
	            'suggest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/<%=nodeId%>/stats/<%=metric%>',
	      req: {
	        nodeId: {
	          type: 'list'
	        },
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'breaker',
	            'fs',
	            'http',
	            'indices',
	            'jvm',
	            'os',
	            'process',
	            'thread_pool',
	            'transport',
	            'discovery'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/stats/<%=metric%>/<%=indexMetric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'breaker',
	            'fs',
	            'http',
	            'indices',
	            'jvm',
	            'os',
	            'process',
	            'thread_pool',
	            'transport',
	            'discovery'
	          ]
	        },
	        indexMetric: {
	          type: 'list',
	          options: [
	            '_all',
	            'completion',
	            'docs',
	            'fielddata',
	            'query_cache',
	            'flush',
	            'get',
	            'indexing',
	            'merge',
	            'percolate',
	            'request_cache',
	            'refresh',
	            'search',
	            'segments',
	            'store',
	            'warmer',
	            'suggest'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/<%=nodeId%>/stats',
	      req: {
	        nodeId: {
	          type: 'list'
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/stats/<%=metric%>',
	      req: {
	        metric: {
	          type: 'list',
	          options: [
	            '_all',
	            'breaker',
	            'fs',
	            'http',
	            'indices',
	            'jvm',
	            'os',
	            'process',
	            'thread_pool',
	            'transport',
	            'discovery'
	          ]
	        }
	      }
	    },
	    {
	      fmt: '/_nodes/stats'
	    }
	  ]
	});

	/**
	 * Perform a [percolate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-percolate.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>, <<api-param-type-string-array,`String[]`>>, <<api-param-type-boolean,`Boolean`>>} params.routing - A comma-separated list of specific routing values
	 * @param {<<api-param-type-string,`String`>>} params.preference - Specify the node or shard the operation should be performed on (default: random)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.ignoreUnavailable - Whether specified concrete indices should be ignored when unavailable (missing or closed)
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.allowNoIndices - Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified)
	 * @param {<<api-param-type-string,`String`>>} [params.expandWildcards=open] - Whether to expand wildcard expression to concrete indices that are open, closed or both.
	 * @param {<<api-param-type-string,`String`>>} params.percolateIndex - The index to percolate the document into. Defaults to index.
	 * @param {<<api-param-type-string,`String`>>} params.percolateType - The type to percolate document into. Defaults to type.
	 * @param {<<api-param-type-string,`String`>>} params.percolateRouting - The routing value to use when percolating the existing document.
	 * @param {<<api-param-type-string,`String`>>} params.percolatePreference - Which shard to prefer when executing the percolate request.
	 * @param {<<api-param-type-string,`String`>>} params.percolateFormat - Return an array of matching query IDs instead of objects
	 * @param {<<api-param-type-number,`Number`>>} params.version - Explicit version number for concurrency control
	 * @param {<<api-param-type-string,`String`>>} params.versionType - Specific version type
	 * @param {<<api-param-type-string,`String`>>} params.index - The index of the document being percolated.
	 * @param {<<api-param-type-string,`String`>>} params.type - The type of the document being percolated.
	 * @param {<<api-param-type-string,`String`>>} params.id - Substitute the document in the request body with a document that is known by the specified id. On top of the id, the index and type parameter will be used to retrieve the document from within the cluster.
	 */
	api.percolate = ca({
	  params: {
	    routing: {
	      type: 'list'
	    },
	    preference: {
	      type: 'string'
	    },
	    ignoreUnavailable: {
	      type: 'boolean',
	      name: 'ignore_unavailable'
	    },
	    allowNoIndices: {
	      type: 'boolean',
	      name: 'allow_no_indices'
	    },
	    expandWildcards: {
	      type: 'enum',
	      'default': 'open',
	      options: [
	        'open',
	        'closed',
	        'none',
	        'all'
	      ],
	      name: 'expand_wildcards'
	    },
	    percolateIndex: {
	      type: 'string',
	      name: 'percolate_index'
	    },
	    percolateType: {
	      type: 'string',
	      name: 'percolate_type'
	    },
	    percolateRouting: {
	      type: 'string',
	      name: 'percolate_routing'
	    },
	    percolatePreference: {
	      type: 'string',
	      name: 'percolate_preference'
	    },
	    percolateFormat: {
	      type: 'enum',
	      options: [
	        'ids'
	      ],
	      name: 'percolate_format'
	    },
	    version: {
	      type: 'number'
	    },
	    versionType: {
	      type: 'enum',
	      options: [
	        'internal',
	        'external',
	        'external_gte',
	        'force'
	      ],
	      name: 'version_type'
	    }
	  },
	  urls: [
	    {
	      fmt: '/<%=index%>/<%=type%>/<%=id%>/_percolate',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        },
	        id: {
	          type: 'string'
	        }
	      }
	    },
	    {
	      fmt: '/<%=index%>/<%=type%>/_percolate',
	      req: {
	        index: {
	          type: 'string'
	        },
	        type: {
	          type: 'string'
	        }
	      }
	    }
	  ],
	  method: 'POST'
	});

	/**
	 * Perform a [ping](https://www.elastic.co/guide/) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 */
	api.ping = ca({
	  url: {
	    fmt: '/'
	  },
	  requestTimeout: 3000,
	  method: 'HEAD'
	});

	/**
	 * Perform a [putScript](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/modules-scripting.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Script ID
	 * @param {<<api-param-type-string,`String`>>} params.lang - Script language
	 */
	api.putScript = ca({
	  url: {
	    fmt: '/_scripts/<%=lang%>/<%=id%>',
	    req: {
	      lang: {
	        type: 'string'
	      },
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [putTemplate](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/search-template.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-string,`String`>>} params.id - Template ID
	 */
	api.putTemplate = ca({
	  url: {
	    fmt: '/_search/template/<%=id%>',
	    req: {
	      id: {
	        type: 'string'
	      }
	    }
	  },
	  needBody: true,
	  method: 'PUT'
	});

	/**
	 * Perform a [reindex](https://www.elastic.co/guide/en/elasticsearch/reference/5.x/docs-reindex.html) request
	 *
	 * @param {Object} params - An object with parameters used to carry out this action
	 * @param {<<api-param-type-boolean,`Boolean`>>} params.refresh - Should the effected indexes be refreshed?
	 * @param {<<api-param-type-duration-string,`DurationString`>>} [params.timeout=1m] - Time each individual bulk request should wait for shards that are unavailable.
	 * @param {<<api-param-type-string,`String`>>} params.waitForActiveShards - Sets th