# From 7.1 to 7.2
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/7.1-to-7.2.md) for the most up to date instructions.*

## Editable labels

In GitLab 7.2 we replace Issue and Merge Request tags with labels, making it
possible to edit the label text and color. The characters `?`, `&` and `,` are
no longer allowed however so those will be removed from your tags during the
database migrations for GitLab 7.2.

### 0. Backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

### 1. Stop server

```bash
sudo service gitlab stop
```

### 2. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch --all
```

For GitLab Community Edition:

```bash
sudo -u git -H git checkout 7-2-stable
```

OR

For GitLab Enterprise Edition:

```bash
sudo -u git -H git checkout 7-2-stable-ee
```

### 3. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v1.9.8
```

### 4. Install new system dependencies

The latest version of the 'rugged' gem requires `pkg-config` and `cmake` to
build its native extensions.

```bash
sudo apt-get install pkg-config cmake
```

### 5. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL installations (note: the line below states '--without ... postgres')
sudo -u git -H bundle install --without development test postgres --deployment

# PostgreSQL installations (note: the line below states '--without ... mysql')
sudo -u git -H bundle install --without development test mysql --deployment

# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production

# Update init.d script
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```

### 6. Update config files

#### New configuration options for `gitlab.yml`

There are new configuration options available for `gitlab.yml`. View them with the command below and apply them to your current `gitlab.yml`.

```
git diff 7-1-stable:config/gitlab.yml.example 7-2-stable:config/gitlab.yml.example
```

* HTTP setups: Make `/etc/nginx/sites-available/nginx` the same as https://gitlab.com/gitlab-org/gitlab-ce/blob/7-0-stable/lib/support/nginx/gitlab but with your settings.
* HTTPS setups: Make `/etc/nginx/sites-available/nginx-ssl` the same as https://gitlab.com/gitlab-org/gitlab-ce/blob/7-0-stable/lib/support/nginx/gitlab-ssl but with your setting

Update rack attack middleware config

```
sudo -u git -H cp config/initializers/rack_attack.rb.example config/initializers/rack_attack.rb
```

### 7. Start application

    sudo service gitlab start
    sudo service nginx restart

### 8. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade is complete!

### 9. Update OmniAuth configuration

When using Google omniauth login, changes of the Google account required.
Ensure that `Contacts API` and the `Google+ API` are enabled in the [Google Developers Console](https://console.developers.google.com/).
More details can be found at the [integration documentation](../integration/google.md).

## Things went south? Revert to previous version (7.1)

### 1. Revert the code to the previous version
Follow the [upgrade guide from 7.0 to 7.1](7.0-to-7.1.md), except for the database migration
(The backup is already migrated to the previous version)

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
If you have more than one backup *.tar file(s) please add `BACKUP=timestamp_of_backup` to the command above.
