/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.ext_util;

import com.tonicsystems.jarjar.ext_util.ClassPathEntry;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathIterator
implements Iterator<ClassPathEntry> {
    private static final FileFilter CLASS_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || ClassPathIterator.isClass(file.getName());
        }
    };
    private static final FileFilter JAR_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return ClassPathIterator.hasExtension(file.getName(), ".jar");
        }
    };
    private final Iterator<File> files;
    private Iterator<ClassPathEntry> entries = Collections.emptyList().iterator();
    private ClassPathEntry next;
    private List<ZipFile> zips = new ArrayList<ZipFile>();

    public ClassPathIterator(String classPath) throws IOException {
        this(new File(System.getProperty("user.dir")), classPath, null);
    }

    public ClassPathIterator(File parent, String classPath, String delim) throws IOException {
        if (delim == null) {
            delim = System.getProperty("path.separator");
        }
        StringTokenizer st = new StringTokenizer(classPath, delim);
        ArrayList<File> fileList = new ArrayList<File>();
        while (st.hasMoreTokens()) {
            String part = (String)st.nextElement();
            boolean wildcard = false;
            if (part.endsWith("/*")) {
                if ((part = part.substring(0, part.length() - 1)).indexOf(42) >= 0) {
                    throw new IllegalArgumentException("Multiple wildcards are not allowed: " + part);
                }
                wildcard = true;
            } else if (part.indexOf(42) >= 0) {
                throw new IllegalArgumentException("Incorrect wildcard usage: " + part);
            }
            File file = new File(part);
            if (!file.isAbsolute()) {
                file = new File(parent, part);
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("File " + file + " does not exist");
            }
            if (wildcard) {
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("File " + file + " + is not a directory");
                }
                fileList.addAll(ClassPathIterator.findFiles(file, JAR_FILTER, false, new ArrayList<File>()));
                continue;
            }
            fileList.add(file);
        }
        this.files = fileList.iterator();
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public void close() throws IOException {
        this.next = null;
        for (ZipFile zip : this.zips) {
            zip.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassPathEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ClassPathEntry result = this.next;
        try {
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return result;
    }

    private void advance() throws IOException {
        if (!this.entries.hasNext()) {
            ZipFile zip;
            if (!this.files.hasNext()) {
                this.next = null;
                return;
            }
            File file = this.files.next();
            if (ClassPathIterator.hasExtension(file.getName(), ".jar")) {
                zip = new JarFile(file);
                this.zips.add(zip);
                this.entries = new ZipIterator(zip);
            } else if (ClassPathIterator.hasExtension(file.getName(), ".zip")) {
                zip = new ZipFile(file);
                this.zips.add(zip);
                this.entries = new ZipIterator(zip);
            } else if (file.isDirectory()) {
                this.entries = new FileIterator(file);
            } else {
                throw new IllegalArgumentException("Do not know how to handle " + file);
            }
        }
        boolean foundClass = false;
        while (!foundClass && this.entries.hasNext()) {
            this.next = this.entries.next();
            foundClass = ClassPathIterator.isClass(this.next.getName());
        }
        if (!foundClass) {
            this.advance();
        }
    }

    private static List<File> findFiles(File dir, FileFilter filter, boolean recurse, List<File> collect) {
        for (File file : dir.listFiles(filter)) {
            if (recurse && file.isDirectory()) {
                ClassPathIterator.findFiles(file, filter, recurse, collect);
                continue;
            }
            collect.add(file);
        }
        return collect;
    }

    private static boolean isClass(String name) {
        return ClassPathIterator.hasExtension(name, ".class");
    }

    private static boolean hasExtension(String name, String ext) {
        if (name.length() < ext.length()) {
            return false;
        }
        String actual = name.substring(name.length() - ext.length());
        return actual.equals(ext) || actual.equals(ext.toUpperCase());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileIterator
    implements Iterator<ClassPathEntry> {
        private final File dir;
        private final Iterator<File> entries;

        FileIterator(File dir) {
            this.dir = dir;
            this.entries = ClassPathIterator.findFiles(dir, CLASS_FILTER, true, new ArrayList()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassPathEntry next() {
            final File file = this.entries.next();
            return new ClassPathEntry(){

                public String getSource() throws IOException {
                    return FileIterator.this.dir.getCanonicalPath();
                }

                public String getName() {
                    return file.getName();
                }

                public InputStream openStream() throws IOException {
                    return new BufferedInputStream(new FileInputStream(file));
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipIterator
    implements Iterator<ClassPathEntry> {
        private final ZipFile zip;
        private final Enumeration<? extends ZipEntry> entries;

        ZipIterator(ZipFile zip) {
            this.zip = zip;
            this.entries = zip.entries();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasMoreElements();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassPathEntry next() {
            final ZipEntry entry = this.entries.nextElement();
            return new ClassPathEntry(){

                public String getSource() {
                    return ZipIterator.this.zip.getName();
                }

                public String getName() {
                    return entry.getName();
                }

                public InputStream openStream() throws IOException {
                    return ZipIterator.this.zip.getInputStream(entry);
                }
            };
        }
    }
}

