/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class ScriptCodegen
extends MemberCodegen<KtScript> {
    private final KtScript scriptDeclaration;
    private final ScriptContext context;
    private final ScriptDescriptor scriptDescriptor;
    private final Type classAsmType;

    public static ScriptCodegen createScriptCodegen(@NotNull KtScript declaration, @NotNull GenerationState state2, @NotNull CodegenContext parentContext) {
        if (declaration == null) {
            ScriptCodegen.$$$reportNull$$$0(0);
        }
        if (state2 == null) {
            ScriptCodegen.$$$reportNull$$$0(1);
        }
        if (parentContext == null) {
            ScriptCodegen.$$$reportNull$$$0(2);
        }
        BindingContext bindingContext = state2.getBindingContext();
        ScriptDescriptor scriptDescriptor = bindingContext.get(BindingContext.SCRIPT, declaration);
        assert (scriptDescriptor != null);
        Type classType = state2.getTypeMapper().mapType(scriptDescriptor);
        ClassBuilder builder = state2.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration, scriptDescriptor), classType, declaration.getContainingFile());
        List<ScriptDescriptor> earlierScripts = state2.getReplSpecific().getEarlierScriptsForReplInterpreter();
        ScriptContext scriptContext = parentContext.intoScript(scriptDescriptor, earlierScripts == null ? Collections.emptyList() : earlierScripts, scriptDescriptor, state2.getTypeMapper());
        return new ScriptCodegen(declaration, state2, scriptContext, builder);
    }

    private ScriptCodegen(@NotNull KtScript scriptDeclaration, @NotNull GenerationState state2, @NotNull ScriptContext context, @NotNull ClassBuilder builder) {
        if (scriptDeclaration == null) {
            ScriptCodegen.$$$reportNull$$$0(3);
        }
        if (state2 == null) {
            ScriptCodegen.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ScriptCodegen.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            ScriptCodegen.$$$reportNull$$$0(6);
        }
        super(state2, null, context, scriptDeclaration, builder);
        this.scriptDeclaration = scriptDeclaration;
        this.context = context;
        this.scriptDescriptor = context.getScriptDescriptor();
        this.classAsmType = this.typeMapper.mapClass((ClassifierDescriptor)context.getContextDescriptor());
    }

    @Override
    protected void generateDeclaration() {
        this.v.defineClass(this.scriptDeclaration, this.state.getClassFileVersion(), 33, this.classAsmType.getInternalName(), null, this.typeMapper.mapSupertype(DescriptorUtilsKt.getSuperClassOrAny(this.scriptDescriptor).getDefaultType(), null).getInternalName(), CodegenUtilKt.mapSupertypesNames(this.typeMapper, DescriptorUtilsKt.getSuperInterfaces(this.scriptDescriptor), null));
    }

    @Override
    protected void generateBody() {
        this.genMembers();
        this.genFieldsForParameters(this.v);
        this.genConstructor(this.scriptDescriptor, this.v, this.context.intoFunction(this.scriptDescriptor.getUnsubstitutedPrimaryConstructor()));
    }

    @Override
    protected void generateSyntheticPartsBeforeBody() {
        this.generatePropertyMetadataArrayFieldIfNeeded(this.classAsmType);
    }

    @Override
    protected void generateSyntheticPartsAfterBody() {
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        this.generateKotlinClassMetadataAnnotation(this.scriptDescriptor, true);
    }

    private void genConstructor(@NotNull ScriptDescriptor scriptDescriptor, @NotNull ClassBuilder classBuilder2, @NotNull MethodContext methodContext) {
        if (scriptDescriptor == null) {
            ScriptCodegen.$$$reportNull$$$0(7);
        }
        if (classBuilder2 == null) {
            ScriptCodegen.$$$reportNull$$$0(8);
        }
        if (methodContext == null) {
            ScriptCodegen.$$$reportNull$$$0(9);
        }
        JvmMethodSignature jvmSignature = this.typeMapper.mapScriptSignature(scriptDescriptor, this.context.getEarlierScripts());
        if (this.state.getReplSpecific().getShouldGenerateScriptResultValue()) {
            FieldInfo resultFieldInfo = this.context.getResultFieldInfo();
            classBuilder2.newField(JvmDeclarationOrigin.NO_ORIGIN, 17, resultFieldInfo.getFieldName(), resultFieldInfo.getFieldType().getDescriptor(), null, null);
        }
        MethodVisitor mv = classBuilder2.newMethod(JvmDeclarationOriginKt.OtherOrigin(this.scriptDeclaration, scriptDescriptor.getUnsubstitutedPrimaryConstructor()), 1, jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor(), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            Type classType = this.typeMapper.mapType(scriptDescriptor);
            ClassDescriptor superclass = DescriptorUtilsKt.getSuperClassNotAny(scriptDescriptor);
            if (superclass == null) {
                iv.load(0, classType);
                iv.invokespecial("java/lang/Object", "<init>", "()V", false);
            } else {
                ClassConstructorDescriptor ctorDesc = superclass.getUnsubstitutedPrimaryConstructor();
                if (ctorDesc == null) {
                    throw new RuntimeException("Primary constructor not found for script template " + superclass.toString());
                }
                iv.load(0, classType);
                int valueParamStart = this.context.getEarlierScripts().isEmpty() ? 1 : 2;
                List<ValueParameterDescriptor> valueParameters = scriptDescriptor.getUnsubstitutedPrimaryConstructor().getValueParameters();
                for (ValueParameterDescriptor superclassParam : ctorDesc.getValueParameters()) {
                    ValueParameterDescriptor valueParam = null;
                    for (ValueParameterDescriptor vpd : valueParameters) {
                        if (!vpd.getName().equals(superclassParam.getName())) continue;
                        valueParam = vpd;
                        break;
                    }
                    assert (valueParam != null);
                    iv.load(valueParam.getIndex() + valueParamStart, this.typeMapper.mapType(valueParam.getType()));
                }
                CallableMethod ctorMethod = this.typeMapper.mapToCallableMethod(ctorDesc, false);
                String sig = ctorMethod.getAsmMethod().getDescriptor();
                iv.invokespecial(this.typeMapper.mapSupertype(superclass.getDefaultType(), null).getInternalName(), "<init>", sig, false);
            }
            iv.load(0, classType);
            FrameMap frameMap = new FrameMap();
            frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
            if (!this.context.getEarlierScripts().isEmpty()) {
                int scriptsParamIndex = frameMap.enterTemp(AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE));
                int earlierScriptIndex = 0;
                for (ScriptDescriptor earlierScript : this.context.getEarlierScripts()) {
                    Type earlierClassType = this.typeMapper.mapClass(earlierScript);
                    iv.load(0, classType);
                    iv.load(scriptsParamIndex, earlierClassType);
                    iv.aconst(earlierScriptIndex++);
                    iv.aload(AsmTypes.OBJECT_TYPE);
                    iv.checkcast(earlierClassType);
                    iv.putfield(classType.getInternalName(), this.context.getScriptFieldName(earlierScript), earlierClassType.getDescriptor());
                }
            }
            ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, methodContext, this.state, this);
            this.generateInitializers(() -> codegen);
            iv.areturn(Type.VOID_TYPE);
        }
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void genFieldsForParameters(@NotNull ClassBuilder classBuilder2) {
        if (classBuilder2 == null) {
            ScriptCodegen.$$$reportNull$$$0(10);
        }
        for (ScriptDescriptor earlierScript : this.context.getEarlierScripts()) {
            Type earlierClassName = this.typeMapper.mapType(earlierScript);
            int access = 17;
            classBuilder2.newField(JvmDeclarationOrigin.NO_ORIGIN, access, this.context.getScriptFieldName(earlierScript), earlierClassName.getDescriptor(), null, null);
        }
    }

    private void genMembers() {
        for (KtDeclaration declaration : this.scriptDeclaration.getDeclarations()) {
            if (declaration instanceof KtProperty || declaration instanceof KtNamedFunction || declaration instanceof KtTypeAlias) {
                this.genSimpleMember(declaration);
                continue;
            }
            if (declaration instanceof KtClassOrObject) {
                this.genClassOrObject((KtClassOrObject)declaration);
                continue;
            }
            if (!(declaration instanceof KtDestructuringDeclaration)) continue;
            for (KtDestructuringDeclarationEntry entry : ((KtDestructuringDeclaration)declaration).getEntries()) {
                this.genSimpleMember(entry);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDeclaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDescriptor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/ScriptCodegen";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createScriptCodegen";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "genConstructor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "genFieldsForParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

