/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.AssignedVariablesSearcher;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002>?B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J*\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0010H\u0007J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J \u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010 \u001a\u00020\u001c2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J&\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.H\u0002J.\u0010/\u001a\u00020$2\u0006\u0010(\u001a\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\t\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0002J \u00102\u001a\u00020$2\u0006\u0010(\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0002J\u001e\u00103\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00104\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u00105\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00162\b\u00106\u001a\u0004\u0018\u00010\u0018J\u0018\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:H\u0002J\u001a\u0010;\u001a\u00020<2\u0006\u0010%\u001a\u00020&2\b\u00106\u001a\u0004\u0018\u00010\u0018H\u0002J*\u0010=\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u00162\b\u00106\u001a\u0004\u0018\u00010\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0002\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "", "()V", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolutionContext", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "createDataFlowValueForComplexExpression", "createDataFlowValueForProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "usageContainingModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createDataFlowValueForStableReceiver", "receiver", "getIdForImplicitReceiver", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "getIdForSimpleNameExpression", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getIdForStableIdentifier", "getIdForThisReceiver", "descriptorOfThisReceiver", "hasDefaultGetter", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "hasNoWritersInClosures", "variableContainingDeclaration", "writers", "", "Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "invisibleFromOtherModules", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "isAccessedBeforeAllClosureWriters", "accessElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isAccessedInsideClosure", "isAccessedInsideClosureAfterAllWriters", "isComplexExpression", "isStableValue", "usageModule", "postfix", "argumentInfo", "op", "Lorg/jetbrains/kotlin/lexer/KtToken;", "propertyKind", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "variableKind", "ExpressionIdentifierInfo", "PostfixIdentifierInfo", "kotlin-compiler"})
public final class DataFlowValueFactory {
    public static final DataFlowValueFactory INSTANCE;

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValue(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(resolutionContext, "resolutionContext");
        BindingContext bindingContext = resolutionContext.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "resolutionContext.trace.bindingContext");
        return DataFlowValueFactory.createDataFlowValue(expression2, type2, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    private final boolean isComplexExpression(KtExpression expression2) {
        KtExpression deparenthesized;
        KtExpression ktExpression = expression2;
        boolean bl = ktExpression instanceof KtBlockExpression || ktExpression instanceof KtIfExpression || ktExpression instanceof KtWhenExpression ? true : (ktExpression instanceof KtBinaryExpression ? ((KtBinaryExpression)expression2).getOperationToken() == KtTokens.ELVIS : (ktExpression instanceof KtParenthesizedExpression ? (deparenthesized = KtPsiUtil.deparenthesize(expression2)) != null && this.isComplexExpression(deparenthesized) : false));
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValue(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        if (expression2 instanceof KtConstantExpression && ((KtConstantExpression)expression2).getNode().getElementType() == KtNodeTypes.NULL) {
            return DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
        }
        if (KotlinTypeKt.isError(type2)) {
            return DataFlowValue.ERROR;
        }
        if (KotlinBuiltIns.isNullableNothing(type2)) {
            return DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
        }
        if (ExpressionTypingUtils.isExclExclExpression(KtPsiUtil.deparenthesize(expression2))) {
            return new DataFlowValue(new ExpressionIdentifierInfo(expression2, false, 2, null), type2, Nullability.NOT_NULL);
        }
        if (INSTANCE.isComplexExpression(expression2)) {
            return INSTANCE.createDataFlowValueForComplexExpression(expression2, type2);
        }
        IdentifierInfo result2 = INSTANCE.getIdForStableIdentifier(expression2, bindingContext, containingDeclarationOrModule);
        return new DataFlowValue(result2 == IdentifierInfo.NO.INSTANCE ? (IdentifierInfo)new ExpressionIdentifierInfo(expression2, false, 2, null) : result2, type2, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValueForStableReceiver(@NotNull ReceiverValue receiver) {
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        IdentifierInfo identifierInfo = new IdentifierInfo.Receiver(receiver);
        KotlinType kotlinType = receiver.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiver.type");
        return new DataFlowValue(identifierInfo, kotlinType, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkParameterIsNotNull(receiverValue, "receiverValue");
        Intrinsics.checkParameterIsNotNull(resolutionContext, "resolutionContext");
        BindingContext bindingContext = resolutionContext.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "resolutionContext.trace.bindingContext");
        return DataFlowValueFactory.createDataFlowValue(receiverValue, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        DataFlowValue dataFlowValue;
        Intrinsics.checkParameterIsNotNull(receiverValue, "receiverValue");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof TransientReceiver || receiverValue2 instanceof ImplicitReceiver) {
            dataFlowValue = DataFlowValueFactory.createDataFlowValueForStableReceiver(receiverValue);
        } else if (receiverValue2 instanceof ExpressionReceiver) {
            KtExpression ktExpression = ((ExpressionReceiver)receiverValue).getExpression();
            KotlinType kotlinType = receiverValue.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverValue.getType()");
            dataFlowValue = DataFlowValueFactory.createDataFlowValue(ktExpression, kotlinType, bindingContext, containingDeclarationOrModule);
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
        }
        return dataFlowValue;
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValueForProperty(@NotNull KtProperty property, @NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext, @Nullable ModuleDescriptor usageContainingModule) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        IdentifierInfo identifierInfo = new IdentifierInfo.Variable(variableDescriptor, INSTANCE.variableKind(variableDescriptor, usageContainingModule, bindingContext, property), (DataFlowValue)bindingContext.get(BindingContext.BOUND_INITIALIZER_VALUE, variableDescriptor));
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "variableDescriptor.type");
        return new DataFlowValue(identifierInfo, kotlinType, null, 4, null);
    }

    private final DataFlowValue createDataFlowValueForComplexExpression(KtExpression expression2, KotlinType type2) {
        return new DataFlowValue(new ExpressionIdentifierInfo(expression2, true), type2, null, 4, null);
    }

    private final IdentifierInfo postfix(IdentifierInfo argumentInfo, KtToken op) {
        return Intrinsics.areEqual(argumentInfo, IdentifierInfo.NO.INSTANCE) ? (IdentifierInfo)IdentifierInfo.NO.INSTANCE : (IdentifierInfo)new PostfixIdentifierInfo(argumentInfo, op);
    }

    private final IdentifierInfo getIdForStableIdentifier(KtExpression expression2, BindingContext bindingContext, DeclarationDescriptor containingDeclarationOrModule) {
        IdentifierInfo identifierInfo;
        KtExpression deparenthesized;
        if (expression2 != null && expression2 != (deparenthesized = KtPsiUtil.deparenthesize(expression2))) {
            return this.getIdForStableIdentifier(deparenthesized, bindingContext, containingDeclarationOrModule);
        }
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression receiverExpression = ((KtQualifiedExpression)expression2).getReceiverExpression();
            KtExpression selectorExpression = ((KtQualifiedExpression)expression2).getSelectorExpression();
            IdentifierInfo receiverInfo = this.getIdForStableIdentifier(receiverExpression, bindingContext, containingDeclarationOrModule);
            IdentifierInfo selectorInfo = this.getIdForStableIdentifier(selectorExpression, bindingContext, containingDeclarationOrModule);
            identifierInfo = IdentifierInfo.Companion.qualified(receiverInfo, bindingContext.getType(receiverExpression), selectorInfo, ((KtQualifiedExpression)expression2).getOperationSign() == KtTokens.SAFE_ACCESS);
        } else if (ktExpression instanceof KtBinaryExpressionWithTypeRHS) {
            KtExpression subjectExpression = ((KtBinaryExpressionWithTypeRHS)expression2).getLeft();
            KtTypeReference targetTypeReference = ((KtBinaryExpressionWithTypeRHS)expression2).getRight();
            IElementType operationToken = ((KtBinaryExpressionWithTypeRHS)expression2).getOperationReference().getReferencedNameElementType();
            identifierInfo = Intrinsics.areEqual(operationToken, KtTokens.IS_KEYWORD) || Intrinsics.areEqual(operationToken, KtTokens.AS_KEYWORD) ? (IdentifierInfo)IdentifierInfo.NO.INSTANCE : (IdentifierInfo)new IdentifierInfo.SafeCast(this.getIdForStableIdentifier(subjectExpression, bindingContext, containingDeclarationOrModule), bindingContext.getType(subjectExpression), (KotlinType)bindingContext.get(BindingContext.TYPE, targetTypeReference));
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            identifierInfo = this.getIdForSimpleNameExpression((KtSimpleNameExpression)expression2, bindingContext, containingDeclarationOrModule);
        } else if (ktExpression instanceof KtThisExpression) {
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression2).getInstanceReference());
            identifierInfo = this.getIdForThisReceiver(declarationDescriptor);
        } else {
            IElementType operationType;
            identifierInfo = ktExpression instanceof KtPostfixExpression ? ((operationType = ((KtPostfixExpression)expression2).getOperationReference().getReferencedNameElementType()) == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS ? this.postfix(this.getIdForStableIdentifier(((KtPostfixExpression)expression2).getBaseExpression(), bindingContext, containingDeclarationOrModule), (KtToken)operationType) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private final IdentifierInfo getIdForSimpleNameExpression(KtSimpleNameExpression simpleNameExpression, BindingContext bindingContext, DeclarationDescriptor containingDeclarationOrModule) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        if (declarationDescriptor2 instanceof VariableDescriptor) {
            IdentifierInfo receiverInfo;
            ReceiverValue implicitReceiver;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(simpleNameExpression, bindingContext);
            ModuleDescriptor usageModuleDescriptor = DescriptorUtils.getContainingModuleOrNull(containingDeclarationOrModule);
            IdentifierInfo.Variable selectorInfo = new IdentifierInfo.Variable((VariableDescriptor)declarationDescriptor, this.variableKind((VariableDescriptor)declarationDescriptor, usageModuleDescriptor, bindingContext, simpleNameExpression), (DataFlowValue)bindingContext.get(BindingContext.BOUND_INITIALIZER_VALUE, declarationDescriptor));
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            ReceiverValue receiverValue = implicitReceiver = resolvedCall3 != null ? resolvedCall3.getDispatchReceiver() : null;
            identifierInfo = implicitReceiver == null ? (IdentifierInfo)selectorInfo : ((receiverInfo = this.getIdForImplicitReceiver(implicitReceiver, simpleNameExpression)) == null ? (IdentifierInfo)selectorInfo : IdentifierInfo.Companion.qualified(receiverInfo, implicitReceiver.getType(), selectorInfo, CallUtilKt.isSafeCall(resolvedCall2.getCall())));
        } else {
            identifierInfo = declarationDescriptor2 instanceof PackageViewDescriptor || declarationDescriptor2 instanceof ClassDescriptor ? (IdentifierInfo)new IdentifierInfo.PackageOrClass(declarationDescriptor) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private final IdentifierInfo getIdForImplicitReceiver(ReceiverValue receiverValue, KtExpression expression2) {
        IdentifierInfo identifierInfo;
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof ImplicitReceiver) {
            identifierInfo = this.getIdForThisReceiver(((ImplicitReceiver)receiverValue).getDeclarationDescriptor());
        } else {
            if (receiverValue2 instanceof TransientReceiver) {
                throw (Throwable)((Object)new AssertionError((Object)("Transient receiver is implicit for an explicit expression: " + expression2 + ". Receiver: " + receiverValue)));
            }
            identifierInfo = null;
        }
        return identifierInfo;
    }

    private final IdentifierInfo getIdForThisReceiver(DeclarationDescriptor descriptorOfThisReceiver) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = descriptorOfThisReceiver;
        if (declarationDescriptor instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)descriptorOfThisReceiver).getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                String string = "'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            ReceiverValue receiverValue = receiverParameter.getValue();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "receiverParameter.value");
            identifierInfo = new IdentifierInfo.Receiver(receiverValue);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            ReceiverValue receiverValue = ((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter().getValue();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "descriptorOfThisReceiver\u2026AsReceiverParameter.value");
            identifierInfo = new IdentifierInfo.Receiver(receiverValue);
        } else {
            identifierInfo = IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private final boolean isAccessedInsideClosure(DeclarationDescriptor variableContainingDeclaration, BindingContext bindingContext, KtElement accessElement) {
        KtDeclaration parent2 = ControlFlowInformationProvider.Companion.getElementParentDeclaration(accessElement);
        return parent2 != null ? Intrinsics.areEqual(ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext, parent2), variableContainingDeclaration) ^ true : false;
    }

    private final boolean hasNoWritersInClosures(DeclarationDescriptor variableContainingDeclaration, Set<AssignedVariablesSearcher.Writer> writers, BindingContext bindingContext) {
        boolean bl;
        block5: {
            Iterable $receiver$iv = writers;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    DeclarationDescriptor writerDescriptor;
                    DeclarationDescriptor declarationDescriptor;
                    AssignedVariablesSearcher.Writer $$_$_writerDeclaration = (AssignedVariablesSearcher.Writer)element$iv;
                    KtDeclaration writerDeclaration = $$_$_writerDeclaration.component2();
                    if (writerDeclaration != null) {
                        KtDeclaration ktDeclaration;
                        KtDeclaration it = ktDeclaration;
                        declarationDescriptor = ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext, it);
                    } else {
                        declarationDescriptor = writerDescriptor = null;
                    }
                    boolean bl2 = writerDeclaration != null && Intrinsics.areEqual(variableContainingDeclaration, writerDescriptor) ^ true;
                    if (!bl2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isAccessedInsideClosureAfterAllWriters(Set<AssignedVariablesSearcher.Writer> writers, KtElement accessElement) {
        boolean bl;
        block4: {
            KtDeclaration ktDeclaration = ControlFlowInformationProvider.Companion.getElementParentDeclaration(accessElement);
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration parent2 = ktDeclaration;
            Iterable $receiver$iv = writers;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    AssignedVariablesSearcher.Writer $assignment = (AssignedVariablesSearcher.Writer)element$iv;
                    KtBinaryExpression assignment = $assignment.component1();
                    PsiElement psiElement = assignment;
                    KtDeclaration ktDeclaration2 = parent2;
                    Intrinsics.checkExpressionValueIsNotNull(ktDeclaration2, "parent");
                    if (!(!PsiUtilsKt.before(psiElement, ktDeclaration2))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAccessedBeforeAllClosureWriters(DeclarationDescriptor variableContainingDeclaration, Set<AssignedVariablesSearcher.Writer> writers, BindingContext bindingContext, KtElement accessElement) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = writers;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KtDeclaration ktDeclaration;
            Object element$iv$iv = element$iv$iv$iv;
            AssignedVariablesSearcher.Writer it = (AssignedVariablesSearcher.Writer)element$iv$iv;
            if (it.getDeclaration() == null) continue;
            KtDeclaration it$iv$iv = ktDeclaration;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            KtDeclaration writerDeclaration = (KtDeclaration)element$iv;
            DeclarationDescriptor writerDescriptor = ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext, writerDeclaration);
            if (!(Intrinsics.areEqual(variableContainingDeclaration, writerDescriptor) ^ true) || PsiUtilsKt.before(accessElement, writerDeclaration)) continue;
            return false;
        }
        return true;
    }

    private final DataFlowValue.Kind propertyKind(PropertyDescriptor propertyDescriptor, ModuleDescriptor usageModule) {
        if (propertyDescriptor.isVar()) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        if (ModalityKt.isOverridable(propertyDescriptor)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!this.hasDefaultGetter(propertyDescriptor)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!this.invisibleFromOtherModules(propertyDescriptor)) {
            ModuleDescriptor declarationModule = DescriptorUtils.getContainingModule(propertyDescriptor);
            if (usageModule == null || Intrinsics.areEqual(usageModule, declarationModule) ^ true) {
                return DataFlowValue.Kind.ALIEN_PUBLIC_PROPERTY;
            }
        }
        return DataFlowValue.Kind.STABLE_VALUE;
    }

    private final DataFlowValue.Kind variableKind(VariableDescriptor variableDescriptor, ModuleDescriptor usageModule, BindingContext bindingContext, KtElement accessElement) {
        DeclarationDescriptor variableContainingDeclaration;
        if (variableDescriptor instanceof PropertyDescriptor) {
            return this.propertyKind((PropertyDescriptor)variableDescriptor, usageModule);
        }
        if (!(variableDescriptor instanceof LocalVariableDescriptor) && !(variableDescriptor instanceof ParameterDescriptor)) {
            return DataFlowValue.Kind.OTHER;
        }
        if (!variableDescriptor.isVar()) {
            return DataFlowValue.Kind.STABLE_VALUE;
        }
        if (variableDescriptor instanceof SyntheticFieldDescriptor) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        PreliminaryDeclarationVisitor preliminaryDeclarationVisitor = PreliminaryDeclarationVisitor.Companion.getVisitorByVariable(variableDescriptor, bindingContext);
        if (preliminaryDeclarationVisitor == null) {
            return DataFlowValue.Kind.CAPTURED_VARIABLE;
        }
        PreliminaryDeclarationVisitor preliminaryVisitor = preliminaryDeclarationVisitor;
        Set<AssignedVariablesSearcher.Writer> writers = preliminaryVisitor.writers(variableDescriptor);
        if (writers.isEmpty()) {
            return DataFlowValue.Kind.STABLE_VARIABLE;
        }
        DeclarationDescriptor declarationDescriptor = variableContainingDeclaration = variableDescriptor.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "variableContainingDeclaration");
        if (this.isAccessedInsideClosure(declarationDescriptor, bindingContext, accessElement)) {
            return preliminaryVisitor.getLanguageVersionSettings().supportsFeature(LanguageFeature.CapturedInClosureSmartCasts) && this.hasNoWritersInClosures(variableContainingDeclaration, writers, bindingContext) && this.isAccessedInsideClosureAfterAllWriters(writers, accessElement) ? DataFlowValue.Kind.STABLE_VARIABLE : DataFlowValue.Kind.CAPTURED_VARIABLE;
        }
        return this.isAccessedBeforeAllClosureWriters(variableContainingDeclaration, writers, bindingContext, accessElement) ? DataFlowValue.Kind.STABLE_VARIABLE : DataFlowValue.Kind.CAPTURED_VARIABLE;
    }

    public final boolean isStableValue(@NotNull VariableDescriptor variableDescriptor, @Nullable ModuleDescriptor usageModule) {
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        if (variableDescriptor.isVar()) {
            return false;
        }
        return !(variableDescriptor instanceof PropertyDescriptor) || this.propertyKind((PropertyDescriptor)variableDescriptor, usageModule) == DataFlowValue.Kind.STABLE_VALUE;
    }

    private final boolean invisibleFromOtherModules(DeclarationDescriptorWithVisibility descriptor2) {
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains(descriptor2.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        return containingDeclaration instanceof DeclarationDescriptorWithVisibility && this.invisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private final boolean hasDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
        return getter2 == null || getter2.isDefault();
    }

    private DataFlowValueFactory() {
        INSTANCE = this;
    }

    static {
        new DataFlowValueFactory();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory$PostfixIdentifierInfo;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "argumentInfo", "op", "Lorg/jetbrains/kotlin/lexer/KtToken;", "(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;Lorg/jetbrains/kotlin/lexer/KtToken;)V", "getArgumentInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "kind", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "getKind", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "getOp", "()Lorg/jetbrains/kotlin/lexer/KtToken;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-compiler"})
    private static final class PostfixIdentifierInfo
    implements IdentifierInfo {
        @NotNull
        private final IdentifierInfo argumentInfo;
        @NotNull
        private final KtToken op;

        @Override
        @NotNull
        public DataFlowValue.Kind getKind() {
            return this.argumentInfo.getKind();
        }

        @NotNull
        public String toString() {
            return "" + this.argumentInfo + '(' + this.op + ')';
        }

        @NotNull
        public final IdentifierInfo getArgumentInfo() {
            return this.argumentInfo;
        }

        @NotNull
        public final KtToken getOp() {
            return this.op;
        }

        public PostfixIdentifierInfo(@NotNull IdentifierInfo argumentInfo, @NotNull KtToken op) {
            Intrinsics.checkParameterIsNotNull(argumentInfo, "argumentInfo");
            Intrinsics.checkParameterIsNotNull(op, "op");
            this.argumentInfo = argumentInfo;
            this.op = op;
        }

        @Override
        public boolean getCanBeBound() {
            return IdentifierInfo.DefaultImpls.getCanBeBound(this);
        }

        @NotNull
        public final IdentifierInfo component1() {
            return this.argumentInfo;
        }

        @NotNull
        public final KtToken component2() {
            return this.op;
        }

        @NotNull
        public final PostfixIdentifierInfo copy(@NotNull IdentifierInfo argumentInfo, @NotNull KtToken op) {
            Intrinsics.checkParameterIsNotNull(argumentInfo, "argumentInfo");
            Intrinsics.checkParameterIsNotNull(op, "op");
            return new PostfixIdentifierInfo(argumentInfo, op);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PostfixIdentifierInfo copy$default(PostfixIdentifierInfo postfixIdentifierInfo, IdentifierInfo identifierInfo, KtToken ktToken, int n, Object object) {
            if ((n & 1) != 0) {
                identifierInfo = postfixIdentifierInfo.argumentInfo;
            }
            if ((n & 2) != 0) {
                ktToken = postfixIdentifierInfo.op;
            }
            return postfixIdentifierInfo.copy(identifierInfo, ktToken);
        }

        public int hashCode() {
            IdentifierInfo identifierInfo = this.argumentInfo;
            KtToken ktToken = this.op;
            return (identifierInfo != null ? identifierInfo.hashCode() : 0) * 31 + (ktToken != null ? ((Object)ktToken).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PostfixIdentifierInfo)) break block3;
                    PostfixIdentifierInfo postfixIdentifierInfo = (PostfixIdentifierInfo)object;
                    if (!Intrinsics.areEqual(this.argumentInfo, postfixIdentifierInfo.argumentInfo) || !Intrinsics.areEqual(this.op, postfixIdentifierInfo.op)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory$ExpressionIdentifierInfo;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "stableComplex", "", "(Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "kind", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "getKind", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "equals", "other", "", "hashCode", "", "toString", "", "kotlin-compiler"})
    public static final class ExpressionIdentifierInfo
    implements IdentifierInfo {
        @NotNull
        private final DataFlowValue.Kind kind;
        @NotNull
        private final KtExpression expression;

        @Override
        @NotNull
        public DataFlowValue.Kind getKind() {
            return this.kind;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ExpressionIdentifierInfo && Intrinsics.areEqual(this.expression, ((ExpressionIdentifierInfo)other).expression);
        }

        public int hashCode() {
            return this.expression.hashCode();
        }

        @NotNull
        public String toString() {
            String string = this.expression.getText();
            if (string == null) {
                string = "(empty expression)";
            }
            return string;
        }

        @NotNull
        public final KtExpression getExpression() {
            return this.expression;
        }

        public ExpressionIdentifierInfo(@NotNull KtExpression expression2, boolean stableComplex) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            this.expression = expression2;
            this.kind = stableComplex ? DataFlowValue.Kind.STABLE_COMPLEX_EXPRESSION : DataFlowValue.Kind.OTHER;
        }

        public /* synthetic */ ExpressionIdentifierInfo(KtExpression ktExpression, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(ktExpression, bl);
        }

        @Override
        public boolean getCanBeBound() {
            return IdentifierInfo.DefaultImpls.getCanBeBound(this);
        }
    }
}

