#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: Agda
version: 2.5.3
id: Agda-2.5.3-CT4Ga04BC8W4vP0dS8sLi6
key: Agda-2.5.3-CT4Ga04BC8W4vP0dS8sLi6
license: OtherLicense
maintainer: Ulf Norell <ulfn@chalmers.se>
homepage: http://wiki.portal.chalmers.se/agda/
synopsis: A dependently typed functional programming language and proof assistant
description:
    Agda is a dependently typed functional programming language: It has
    inductive families, which are similar to Haskell'\''s GADTs, but they
    can be indexed by values and not just types. It also has
    parameterised modules, mixfix operators, Unicode characters, and an
    interactive Emacs interface (the type checker can assist in the
    development of your code).
    .
    Agda is also a proof assistant: It is an interactive system for
    writing and checking proofs. Agda is based on intuitionistic type
    theory, a foundational system for constructive mathematics developed
    by the Swedish logician Per Martin-L&#xf6;f. It has many
    similarities with other proof assistants based on dependent types,
    such as Coq, Epigram and NuPRL.
    .
    This package includes both a command-line program (agda) and an
    Emacs mode. If you want to use the Emacs mode you can set it up by
    running @agda-mode setup@ (see the README).
    .
    Note that the Agda package does not follow the package versioning
    policy, because it is not intended to be used by third-party
    packages.
category: Dependent types
author: Agda 2 was originally written by Ulf Norell, partially based on code from Agda 1 by Catarina Coquand and Makoto Takeyama, and from Agdalight by Ulf Norell and Andreas Abel. Agda 2 is currently actively developed mainly by Andreas Abel, Guillaume Allais, Jesper Cockx, Nils Anders Danielsson, Philipp Hausmann, Fredrik Nordvall Forsberg, Ulf Norell, Víctor López Juan, Andrés Sicard-Ramírez, and Andrea Vezzosi. Further, Agda 2 has received contributions by, amongst others, Stevan Andjelkovic, Marcin Benke, Jean-Philippe Bernardy, Guillaume Brunerie, James Chapman, Dominique Devriese, Péter Diviánszki, Olle Fredriksson, Adam Gundry, Daniel Gustafsson, Kuen-Bang Hou (favonia), Patrik Jansson, Alan Jeffrey, Wolfram Kahl, Pepijn Kokke, Fredrik Lindblad, Francesco Mazzoli, Stefan Monnier, Darin Morrison, Guilhem Moulin, Nicolas Pouillard, Nobuo Yamashita, Christian Sattler, and Makoto Takeyama and many more.
exposed: True
indefinite: False
exposed-modules:
    Agda.Auto.Auto Agda.Auto.CaseSplit Agda.Auto.Convert
    Agda.Auto.NarrowingSearch Agda.Auto.Options Agda.Auto.SearchControl
    Agda.Auto.Syntax Agda.Auto.Typecheck Agda.Benchmarking
    Agda.Compiler.Backend Agda.Compiler.CallCompiler
    Agda.Compiler.Common Agda.Compiler.JS.Compiler
    Agda.Compiler.JS.Pretty Agda.Compiler.JS.Substitution
    Agda.Compiler.JS.Syntax Agda.Compiler.MAlonzo.Compiler
    Agda.Compiler.MAlonzo.Encode Agda.Compiler.MAlonzo.HaskellTypes
    Agda.Compiler.MAlonzo.Misc Agda.Compiler.MAlonzo.Pragmas
    Agda.Compiler.MAlonzo.Pretty Agda.Compiler.MAlonzo.Primitives
    Agda.Compiler.ToTreeless Agda.Compiler.Treeless.AsPatterns
    Agda.Compiler.Treeless.Builtin Agda.Compiler.Treeless.Compare
    Agda.Compiler.Treeless.EliminateDefaults
    Agda.Compiler.Treeless.EliminateLiteralPatterns
    Agda.Compiler.Treeless.Erase Agda.Compiler.Treeless.GuardsToPrims
    Agda.Compiler.Treeless.Identity
    Agda.Compiler.Treeless.NormalizeNames Agda.Compiler.Treeless.Pretty
    Agda.Compiler.Treeless.Simplify Agda.Compiler.Treeless.Subst
    Agda.Compiler.Treeless.Uncase Agda.Compiler.Treeless.Unused
    Agda.ImpossibleTest Agda.Interaction.BasicOps
    Agda.Interaction.CommandLine Agda.Interaction.EmacsCommand
    Agda.Interaction.EmacsTop Agda.Interaction.FindFile
    Agda.Interaction.Highlighting.Dot
    Agda.Interaction.Highlighting.Emacs
    Agda.Interaction.Highlighting.Generate
    Agda.Interaction.Highlighting.HTML
    Agda.Interaction.Highlighting.LaTeX
    Agda.Interaction.Highlighting.Precise
    Agda.Interaction.Highlighting.Range
    Agda.Interaction.Highlighting.Vim Agda.Interaction.Imports
    Agda.Interaction.InteractionTop Agda.Interaction.Library
    Agda.Interaction.Library.Base Agda.Interaction.Library.Parse
    Agda.Interaction.MakeCase Agda.Interaction.Monad
    Agda.Interaction.Options Agda.Interaction.Options.Lenses
    Agda.Interaction.Response Agda.Interaction.SearchAbout Agda.Main
    Agda.Syntax.Abstract Agda.Syntax.Abstract.Copatterns
    Agda.Syntax.Abstract.Name Agda.Syntax.Abstract.Pattern
    Agda.Syntax.Abstract.Pretty Agda.Syntax.Abstract.Views
    Agda.Syntax.Common Agda.Syntax.Concrete
    Agda.Syntax.Concrete.Definitions Agda.Syntax.Concrete.Generic
    Agda.Syntax.Concrete.Name Agda.Syntax.Concrete.Operators
    Agda.Syntax.Concrete.Operators.Parser
    Agda.Syntax.Concrete.Operators.Parser.Monad
    Agda.Syntax.Concrete.Pretty Agda.Syntax.Fixity
    Agda.Syntax.IdiomBrackets Agda.Syntax.Info Agda.Syntax.Internal
    Agda.Syntax.Internal.Defs Agda.Syntax.Internal.Generic
    Agda.Syntax.Internal.Names Agda.Syntax.Internal.Pattern
    Agda.Syntax.Internal.SanityCheck Agda.Syntax.Literal
    Agda.Syntax.Notation Agda.Syntax.Parser Agda.Syntax.Parser.Alex
    Agda.Syntax.Parser.Comments Agda.Syntax.Parser.Layout
    Agda.Syntax.Parser.LexActions Agda.Syntax.Parser.Lexer
    Agda.Syntax.Parser.Literate Agda.Syntax.Parser.LookAhead
    Agda.Syntax.Parser.Monad Agda.Syntax.Parser.Parser
    Agda.Syntax.Parser.StringLiterals Agda.Syntax.Parser.Tokens
    Agda.Syntax.Position Agda.Syntax.Reflected Agda.Syntax.Scope.Base
    Agda.Syntax.Scope.Monad Agda.Syntax.Translation.AbstractToConcrete
    Agda.Syntax.Translation.ConcreteToAbstract
    Agda.Syntax.Translation.InternalToAbstract
    Agda.Syntax.Translation.ReflectedToAbstract Agda.Syntax.Treeless
    Agda.Termination.CallGraph Agda.Termination.CallMatrix
    Agda.Termination.CutOff Agda.Termination.Inlining
    Agda.Termination.Monad Agda.Termination.Order
    Agda.Termination.RecCheck Agda.Termination.Semiring
    Agda.Termination.SparseMatrix Agda.Termination.TermCheck
    Agda.Termination.Termination Agda.TheTypeChecker
    Agda.TypeChecking.Abstract Agda.TypeChecking.CheckInternal
    Agda.TypeChecking.CompiledClause
    Agda.TypeChecking.CompiledClause.Compile
    Agda.TypeChecking.CompiledClause.Match
    Agda.TypeChecking.Constraints Agda.TypeChecking.Conversion
    Agda.TypeChecking.Coverage Agda.TypeChecking.Coverage.Match
    Agda.TypeChecking.Coverage.SplitTree Agda.TypeChecking.Datatypes
    Agda.TypeChecking.DeadCode Agda.TypeChecking.DisplayForm
    Agda.TypeChecking.DropArgs Agda.TypeChecking.Empty
    Agda.TypeChecking.Errors Agda.TypeChecking.EtaContract
    Agda.TypeChecking.Forcing Agda.TypeChecking.Free
    Agda.TypeChecking.Free.Lazy Agda.TypeChecking.Free.Old
    Agda.TypeChecking.Functions Agda.TypeChecking.Implicit
    Agda.TypeChecking.Injectivity Agda.TypeChecking.InstanceArguments
    Agda.TypeChecking.Irrelevance Agda.TypeChecking.Level
    Agda.TypeChecking.LevelConstraints Agda.TypeChecking.MetaVars
    Agda.TypeChecking.MetaVars.Mention
    Agda.TypeChecking.MetaVars.Occurs Agda.TypeChecking.Monad
    Agda.TypeChecking.Monad.Base Agda.TypeChecking.Monad.Benchmark
    Agda.TypeChecking.Monad.Builtin Agda.TypeChecking.Monad.Caching
    Agda.TypeChecking.Monad.Closure Agda.TypeChecking.Monad.Constraints
    Agda.TypeChecking.Monad.Context Agda.TypeChecking.Monad.Debug
    Agda.TypeChecking.Monad.Env Agda.TypeChecking.Monad.Imports
    Agda.TypeChecking.Monad.Local Agda.TypeChecking.Monad.MetaVars
    Agda.TypeChecking.Monad.Mutual Agda.TypeChecking.Monad.Open
    Agda.TypeChecking.Monad.Options Agda.TypeChecking.Monad.Sharing
    Agda.TypeChecking.Monad.Signature
    Agda.TypeChecking.Monad.SizedTypes Agda.TypeChecking.Monad.State
    Agda.TypeChecking.Monad.Statistics Agda.TypeChecking.Monad.Trace
    Agda.TypeChecking.Patterns.Abstract
    Agda.TypeChecking.Patterns.Match Agda.TypeChecking.Polarity
    Agda.TypeChecking.Positivity
    Agda.TypeChecking.Positivity.Occurrence Agda.TypeChecking.Pretty
    Agda.TypeChecking.Primitive Agda.TypeChecking.ProjectionLike
    Agda.TypeChecking.Quote Agda.TypeChecking.ReconstructParameters
    Agda.TypeChecking.RecordPatterns Agda.TypeChecking.Records
    Agda.TypeChecking.Reduce Agda.TypeChecking.Reduce.Fast
    Agda.TypeChecking.Reduce.Monad Agda.TypeChecking.Rewriting
    Agda.TypeChecking.Rewriting.NonLinMatch
    Agda.TypeChecking.Rules.Builtin
    Agda.TypeChecking.Rules.Builtin.Coinduction
    Agda.TypeChecking.Rules.Data Agda.TypeChecking.Rules.Decl
    Agda.TypeChecking.Rules.Def Agda.TypeChecking.Rules.Display
    Agda.TypeChecking.Rules.LHS Agda.TypeChecking.Rules.LHS.AsPatterns
    Agda.TypeChecking.Rules.LHS.Implicit
    Agda.TypeChecking.Rules.LHS.Instantiate
    Agda.TypeChecking.Rules.LHS.Problem
    Agda.TypeChecking.Rules.LHS.ProblemRest
    Agda.TypeChecking.Rules.LHS.Split Agda.TypeChecking.Rules.LHS.Unify
    Agda.TypeChecking.Rules.Record Agda.TypeChecking.Rules.Term
    Agda.TypeChecking.Serialise Agda.TypeChecking.Serialise.Base
    Agda.TypeChecking.Serialise.Instances
    Agda.TypeChecking.Serialise.Instances.Abstract
    Agda.TypeChecking.Serialise.Instances.Common
    Agda.TypeChecking.Serialise.Instances.Compilers
    Agda.TypeChecking.Serialise.Instances.Errors
    Agda.TypeChecking.Serialise.Instances.Highlighting
    Agda.TypeChecking.Serialise.Instances.Internal
    Agda.TypeChecking.SizedTypes Agda.TypeChecking.SizedTypes.Solve
    Agda.TypeChecking.SizedTypes.Syntax
    Agda.TypeChecking.SizedTypes.Utils
    Agda.TypeChecking.SizedTypes.WarshallSolver
    Agda.TypeChecking.Substitute Agda.TypeChecking.Substitute.Class
    Agda.TypeChecking.Substitute.DeBruijn
    Agda.TypeChecking.SyntacticEquality Agda.TypeChecking.Telescope
    Agda.TypeChecking.Unquote Agda.TypeChecking.Warnings
    Agda.TypeChecking.With Agda.Utils.AssocList Agda.Utils.Bag
    Agda.Utils.Benchmark Agda.Utils.BiMap Agda.Utils.Char
    Agda.Utils.Cluster Agda.Utils.Either Agda.Utils.Empty
    Agda.Utils.Environment Agda.Utils.Except Agda.Utils.Favorites
    Agda.Utils.FileName Agda.Utils.Function Agda.Utils.Functor
    Agda.Utils.Geniplate Agda.Utils.Graph.AdjacencyMap.Unidirectional
    Agda.Utils.Hash Agda.Utils.HashMap Agda.Utils.Haskell.Syntax
    Agda.Utils.IO Agda.Utils.IO.Binary Agda.Utils.IO.Directory
    Agda.Utils.IO.UTF8 Agda.Utils.IORef Agda.Utils.Impossible
    Agda.Utils.IndexedList Agda.Utils.Lens Agda.Utils.Lens.Examples
    Agda.Utils.List Agda.Utils.ListT Agda.Utils.Map Agda.Utils.Maybe
    Agda.Utils.Maybe.Strict Agda.Utils.Memo Agda.Utils.Monad
    Agda.Utils.Monoid Agda.Utils.Null Agda.Utils.Parser.MemoisedCPS
    Agda.Utils.Parser.ReadP Agda.Utils.PartialOrd
    Agda.Utils.Permutation Agda.Utils.Pointer Agda.Utils.Pretty
    Agda.Utils.SemiRing Agda.Utils.Singleton Agda.Utils.Size
    Agda.Utils.String Agda.Utils.Suffix Agda.Utils.Three
    Agda.Utils.Time Agda.Utils.Trie Agda.Utils.Tuple
    Agda.Utils.TypeLevel Agda.Utils.Update Agda.Utils.VarSet
    Agda.Utils.Warshall Agda.Version Agda.VersionCommit
hidden-modules: Paths_Agda
abi: c8954041e24edbeeb7cf1919ec89d5ab
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/Agda-2.5.3
library-dirs: /usr/lib/ghc-8.2.1/site-local/Agda-2.5.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/agda
hs-libraries: HSAgda-2.5.3-CT4Ga04BC8W4vP0dS8sLi6
depends:
    array-0.5.2.0 async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc base-4.10.0.0
    binary-0.8.5.1 blaze-html-0.9.0.1-kPi4af1DH04kfw48f7OOh
    boxes-0.1.4-HAPiiiUo5K84zO4ajxwkGC bytestring-0.10.8.2
    containers-0.5.10.2 data-hash-0.2.0.1-FFXvsXkjc3Z7VKIGq0xacx
    deepseq-1.4.3.0 directory-1.3.0.2
    EdisonCore-1.3.1.1-ELnkizozKIbBwHjIvu54SK
    edit-distance-0.2.2.1-AKPitr2rEBj4k4CiafnDjW
    equivalence-0.3.2-1fY849ypB1L3JkIlpwTcSn filepath-1.4.1.2
    geniplate-mirror-0.7.5-5wdQhDVfb5iIhDZt2oHFT4
    gitrev-1.3.1-Cgp0kQsBgtmnAoUzRW7fU
    hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk
    hashtables-1.2.2.0-DWDZhHGT75K8Jt5bmmtiVH haskeline-0.7.4.0
    ieee754-0.8.0-HLjs1Vz4yYwDDe3V5nl83v
    monadplus-1.4.2-7nwAygjI0yyJgCQtGW8wrt
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    murmur-hash-0.1.0.9-Kb2RNFbk42fBtX0CoM74R5
    uri-encode-1.5.0.5-7LF5zrjw92bIXYU2d5xWls
    parallel-3.2.1.1-BDA8bigzIyf7HfOpmZ9w2K pretty-1.1.3.3
    process-1.6.1.0 regex-tdfa-1.2.2-1G5AA2OVGrl1AkVWQSHaiw
    stm-2.4.4.1-4JDnVtQYo787gU0ccBstsJ
    strict-0.3.2-7ZEebv7EabCEjNWrS66TpZ template-haskell-2.12.0.0
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz time-1.8.0.2
    transformers-0.5.2.0
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    zlib-0.6.1.2-6xNZGE39eOa1IjQdEzckzB
abi-depends: array-0.5.2.0=5abf025fb7bf60079ec1f42bab285152
             async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc=4ad1a36fd79247fdbaa53c120c46b6d7
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             binary-0.8.5.1=230c80b11ae3b1af831989b945ccdad4
             blaze-html-0.9.0.1-kPi4af1DH04kfw48f7OOh=4d7402d6bc242682528205229a7d9db9
             boxes-0.1.4-HAPiiiUo5K84zO4ajxwkGC=f19c15ba8a17cdd98552f820714ce180
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             data-hash-0.2.0.1-FFXvsXkjc3Z7VKIGq0xacx=75f51d76cf9295b8276cc65c9582be49
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             EdisonCore-1.3.1.1-ELnkizozKIbBwHjIvu54SK=97e4dadfd0d073f75dd57e0327f6e6ca
             edit-distance-0.2.2.1-AKPitr2rEBj4k4CiafnDjW=4b4b7a76d14a81f1561d10cf245fb147
             equivalence-0.3.2-1fY849ypB1L3JkIlpwTcSn=f519f221e1f7bc4e30586dec820ca9f8
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             geniplate-mirror-0.7.5-5wdQhDVfb5iIhDZt2oHFT4=6e0aa3795d54a205fbebe1642012fec9
             gitrev-1.3.1-Cgp0kQsBgtmnAoUzRW7fU=144a9a0126afbae34150c14c8b0b9fdd
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             hashtables-1.2.2.0-DWDZhHGT75K8Jt5bmmtiVH=c2042990dea59f2628c3db9b0c86298f
             haskeline-0.7.4.0=36adec7915bbe665923e4f83d1084101
             ieee754-0.8.0-HLjs1Vz4yYwDDe3V5nl83v=acb5571dc032cd2a7d95b9a68f22b301
             monadplus-1.4.2-7nwAygjI0yyJgCQtGW8wrt=bb0b22990403b747f171ba2fbef7cba7
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             murmur-hash-0.1.0.9-Kb2RNFbk42fBtX0CoM74R5=9c06752eea47efe8fead2e51d7943a6a
             uri-encode-1.5.0.5-7LF5zrjw92bIXYU2d5xWls=87f556a2d5407fd40b61b64c9e18a704
             parallel-3.2.1.1-BDA8bigzIyf7HfOpmZ9w2K=d3c5e50fff73217cc80d767e7d27ed7e
             pretty-1.1.3.3=5491220463456849eb660c64bb0df8c8
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             regex-tdfa-1.2.2-1G5AA2OVGrl1AkVWQSHaiw=a50652c6ce72d1a607b5e2d5892b65bc
             stm-2.4.4.1-4JDnVtQYo787gU0ccBstsJ=a88f5bbac4be96a38c5ca2a658c158a0
             strict-0.3.2-7ZEebv7EabCEjNWrS66TpZ=4518eff838eef304fcf7fcf40a435e3c
             template-haskell-2.12.0.0=612ee923b47f5e11502cef08338c9f82
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             zlib-0.6.1.2-6xNZGE39eOa1IjQdEzckzB=f9a6b8e404d4e5df9363e7202bb41dfe
haddock-interfaces: /usr/share/doc/agda/html/Agda.haddock
haddock-html: /usr/share/doc/agda/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

