/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.syncml.pim.vcard;

import a_vcard.android.syncml.pim.VBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardSourceDetector
implements VBuilder {
    static final int TYPE_UNKNOWN = 0;
    static final int TYPE_APPLE = 1;
    static final int TYPE_JAPANESE_MOBILE_PHONE = 2;
    static final int TYPE_FOMA = 3;
    static final int TYPE_WINDOWS_MOBILE_JP = 4;
    private static Set<String> APPLE_SIGNS = new HashSet<String>(Arrays.asList("X-PHONETIC-FIRST-NAME", "X-PHONETIC-MIDDLE-NAME", "X-PHONETIC-LAST-NAME", "X-ABADR", "X-ABUID"));
    private static Set<String> JAPANESE_MOBILE_PHONE_SIGNS = new HashSet<String>(Arrays.asList("X-GNO", "X-GN", "X-REDUCTION"));
    private static Set<String> WINDOWS_MOBILE_PHONE_SIGNS = new HashSet<String>(Arrays.asList("X-MICROSOFT-ASST_TEL", "X-MICROSOFT-ASSISTANT", "X-MICROSOFT-OFFICELOC"));
    private static Set<String> FOMA_SIGNS = new HashSet<String>(Arrays.asList("X-SD-VERN", "X-SD-FORMAT_VER", "X-SD-CATEGORIES", "X-SD-CLASS", "X-SD-DCREATED", "X-SD-DESCRIPTION"));
    private static String TYPE_FOMA_CHARSET_SIGN = "X-SD-CHAR_CODE";
    private int mType = 0;
    private boolean mNeedParseSpecifiedCharset;
    private String mSpecifiedCharset;

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }

    @Override
    public void startRecord(String type) {
    }

    @Override
    public void startProperty() {
        this.mNeedParseSpecifiedCharset = false;
    }

    @Override
    public void endProperty() {
    }

    @Override
    public void endRecord() {
    }

    @Override
    public void propertyGroup(String group) {
    }

    @Override
    public void propertyName(String name) {
        if (name.equalsIgnoreCase(TYPE_FOMA_CHARSET_SIGN)) {
            this.mType = 3;
            this.mNeedParseSpecifiedCharset = true;
            return;
        }
        if (this.mType != 0) {
            return;
        }
        if (WINDOWS_MOBILE_PHONE_SIGNS.contains(name)) {
            this.mType = 4;
        } else if (FOMA_SIGNS.contains(name)) {
            this.mType = 3;
        } else if (JAPANESE_MOBILE_PHONE_SIGNS.contains(name)) {
            this.mType = 2;
        } else if (APPLE_SIGNS.contains(name)) {
            this.mType = 1;
        }
    }

    @Override
    public void propertyParamType(String type) {
    }

    @Override
    public void propertyParamValue(String value) {
    }

    @Override
    public void propertyValues(List<String> values) {
        if (this.mNeedParseSpecifiedCharset && values.size() > 0) {
            this.mSpecifiedCharset = values.get(0);
        }
    }

    int getType() {
        return this.mType;
    }

    public String getEstimatedCharset() {
        if (this.mSpecifiedCharset != null) {
            return this.mSpecifiedCharset;
        }
        switch (this.mType) {
            case 2: 
            case 3: 
            case 4: {
                return "SHIFT_JIS";
            }
            case 1: {
                return "UTF-8";
            }
        }
        return null;
    }
}

