/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public class SVGLoader {
    private TranscoderInput input;
    private BufferedImage img;
    private float width;
    private float height;

    public static Image load(@Nullable URL url, @NotNull InputStream stream2, float scale) throws IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/SVGLoader", "load"));
        }
        try {
            return new SVGLoader(url, stream2, scale).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    private SVGLoader(@Nullable URL url, InputStream stream2, float scale) throws IOException {
        Document document = null;
        String uri = null;
        try {
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        document = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(uri, stream2);
        if (document == null) {
            throw new IOException("document not created");
        }
        this.input = new TranscoderInput(document);
        this.width = SizeAttr.width.value(document) * scale;
        this.height = SizeAttr.height.value(document) * scale;
    }

    private BufferedImage createImage() throws TranscoderException {
        MyTranscoder r = new MyTranscoder();
        r.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(this.width));
        r.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(this.height));
        r.transcode(this.input, null);
        return this.img;
    }

    private class MyTranscoder
    extends ImageTranscoder {
        private MyTranscoder() {
        }
    }

    private static class ViewBox {
        private final float x;
        private final float y;
        private final float width;
        private final float height;

        public ViewBox(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public static ViewBox fromString(String s) {
            List<String> values = StringUtil.split(s, " ");
            if (values.size() == 4) {
                return new ViewBox(Float.parseFloat(values.get(0)), Float.parseFloat(values.get(1)), Float.parseFloat(values.get(2)), Float.parseFloat(values.get(3)));
            }
            throw new IllegalArgumentException("String should be formatted like 'x y width height'");
        }
    }

    private static enum SizeAttr {
        width,
        height;


        public float value(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/SVGLoader$SizeAttr", "value"));
            }
            String value = document.getDocumentElement().getAttribute(this.name());
            if (value.endsWith("px")) {
                try {
                    return Float.parseFloat(value.substring(0, value.length() - 2));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                ViewBox viewBox = ViewBox.fromString(document.getDocumentElement().getAttribute("viewBox"));
                return this == width ? viewBox.width : viewBox.height;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 16.0f;
            }
        }
    }
}

