/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.BuildInfo;
import org.jetbrains.kotlin.incremental.CacheVersion;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.IncrementalCachesManager;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJsCache;
import org.jetbrains.kotlin.incremental.IncrementalJsCachesManager;
import org.jetbrains.kotlin.incremental.IncrementalJsCompilerRunner;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProviderFromCache;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\rH\u0014J6\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J.\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00072\u0006\u0010'\u001a\u00020(H\u0014\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCompilerRunner;", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "Lorg/jetbrains/kotlin/incremental/IncrementalJsCachesManager;", "workingDir", "Ljava/io/File;", "cacheVersions", "", "Lorg/jetbrains/kotlin/incremental/CacheVersion;", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "(Ljava/io/File;Ljava/util/List;Lorg/jetbrains/kotlin/incremental/ICReporter;)V", "calculateSourcesToCompile", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode;", "caches", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "args", "createCacheManager", "destinationDir", "isICEnabled", "", "makeServices", "Lorg/jetbrains/kotlin/config/Services$Builder;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "compilationMode", "runCompiler", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "sourcesToCompile", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "updateCaches", "", "generatedFiles", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "kotlin-compiler"})
public final class IncrementalJsCompilerRunner
extends IncrementalCompilerRunner<K2JSCompilerArguments, IncrementalJsCachesManager> {
    @Override
    protected boolean isICEnabled() {
        return IncrementalCompilation.isEnabled() && IncrementalCompilation.isEnabledForJs();
    }

    @Override
    @NotNull
    protected IncrementalJsCachesManager createCacheManager(@NotNull K2JSCompilerArguments args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        return new IncrementalJsCachesManager(this.getCacheDirectory(), this.getReporter());
    }

    @Override
    @NotNull
    protected File destinationDir(@NotNull K2JSCompilerArguments args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        File file = new File(args.getOutputFile()).getParentFile();
        Intrinsics.checkExpressionValueIsNotNull(file, "File(args.outputFile).parentFile");
        return file;
    }

    @Override
    @NotNull
    protected IncrementalCompilerRunner.CompilationMode calculateSourcesToCompile(@NotNull IncrementalJsCachesManager caches, @NotNull ChangedFiles.Known changedFiles, @NotNull K2JSCompilerArguments args) {
        Intrinsics.checkParameterIsNotNull(caches, "caches");
        Intrinsics.checkParameterIsNotNull(changedFiles, "changedFiles");
        Intrinsics.checkParameterIsNotNull(args, "args");
        if (BuildInfo.Companion.read(this.getLastBuildInfoFile()) == null) {
            return new IncrementalCompilerRunner.CompilationMode.Rebuild(calculateSourcesToCompile.1.INSTANCE);
        }
        return new IncrementalCompilerRunner.CompilationMode.Incremental((Set<? extends File>)this.getDirtyFiles(changedFiles));
    }

    @Override
    @NotNull
    protected Services.Builder makeServices(@NotNull K2JSCompilerArguments args, @NotNull LookupTracker lookupTracker, @NotNull IncrementalJsCachesManager caches, @NotNull IncrementalCompilerRunner.CompilationMode compilationMode) {
        Services.Builder builder;
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(lookupTracker, "lookupTracker");
        Intrinsics.checkParameterIsNotNull(caches, "caches");
        Intrinsics.checkParameterIsNotNull(compilationMode, "compilationMode");
        Services.Builder $receiver = builder = super.makeServices((CommonCompilerArguments)args, lookupTracker, (IncrementalCachesManager)caches, compilationMode);
        $receiver.register(IncrementalResultsConsumer.class, new IncrementalResultsConsumerImpl());
        if (compilationMode instanceof IncrementalCompilerRunner.CompilationMode.Incremental) {
            $receiver.register(IncrementalDataProvider.class, new IncrementalDataProviderFromCache(caches.getPlatformCache()));
        }
        return builder;
    }

    @Override
    protected void updateCaches(@NotNull Services services, @NotNull IncrementalJsCachesManager caches, @NotNull List<? extends GeneratedFile> generatedFiles, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull(services, "services");
        Intrinsics.checkParameterIsNotNull(caches, "caches");
        Intrinsics.checkParameterIsNotNull(generatedFiles, "generatedFiles");
        Intrinsics.checkParameterIsNotNull(changesCollector, "changesCollector");
        IncrementalResultsConsumer incrementalResultsConsumer = services.get(IncrementalResultsConsumer.class);
        if (incrementalResultsConsumer == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl");
        }
        IncrementalResultsConsumerImpl incrementalResults = (IncrementalResultsConsumerImpl)incrementalResultsConsumer;
        IncrementalJsCache jsCache = caches.getPlatformCache();
        jsCache.setHeader(incrementalResults.getHeaderMetadata());
        jsCache.compareAndUpdate(incrementalResults, changesCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode runCompiler(@NotNull Set<? extends File> sourcesToCompile2, @NotNull K2JSCompilerArguments args, @NotNull IncrementalJsCachesManager caches, @NotNull Services services, @NotNull MessageCollector messageCollector2) {
        Intrinsics.checkParameterIsNotNull(sourcesToCompile2, "sourcesToCompile");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(caches, "caches");
        Intrinsics.checkParameterIsNotNull(services, "services");
        Intrinsics.checkParameterIsNotNull(messageCollector2, "messageCollector");
        List<String> freeArgsBackup = CollectionsKt.toMutableList((Collection)args.getFreeArgs());
        try {
            void $receiver$iv;
            Iterable iterable = sourcesToCompile2;
            Collection destination$iv = args.getFreeArgs();
            for (Object item$iv : $receiver$iv) {
                String string;
                void it;
                File file = (File)item$iv;
                Collection collection = destination$iv;
                Intrinsics.checkExpressionValueIsNotNull(it.getAbsolutePath(), "it.absolutePath");
                collection.add(string);
            }
            ExitCode exitCode2 = new K2JSCompiler().exec(messageCollector2, services, (CommonToolArguments)args);
            this.getReporter().reportCompileIteration((Collection<? extends File>)sourcesToCompile2, exitCode2);
            ExitCode exitCode3 = exitCode2;
            return exitCode3;
        }
        finally {
            args.setFreeArgs(freeArgsBackup);
        }
    }

    public IncrementalJsCompilerRunner(@NotNull File workingDir, @NotNull List<CacheVersion> cacheVersions, @NotNull ICReporter reporter) {
        Intrinsics.checkParameterIsNotNull(workingDir, "workingDir");
        Intrinsics.checkParameterIsNotNull(cacheVersions, "cacheVersions");
        Intrinsics.checkParameterIsNotNull(reporter, "reporter");
        super(workingDir, "caches-js", cacheVersions, reporter, null, null);
    }
}

