/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrPropertyImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeParameterImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.util.StableDescriptorsComparator;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020-J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0014\u001a\u000200J\u001c\u00101\u001a\u00020\f2\f\u00102\u001a\b\u0012\u0004\u0012\u000200032\u0006\u0010\u0010\u001a\u000204J\u000e\u00105\u001a\u0002062\u0006\u0010\u0014\u001a\u000207J\u001c\u00108\u001a\u00020\f2\f\u00109\u001a\b\u0012\u0004\u0012\u0002070\u000e2\u0006\u0010:\u001a\u00020;R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "generateChildStubs", "", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "generateClassStub", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateConstructorStub", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "generateEmptyExternalPackageFragmentStub", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "generateEmptyModuleFragmentStub", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "generateEnumEntryStub", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "generateFunctionStub", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateMemberStub", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "generateMemberStubs", "memberScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "generatePropertyStub", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateTypeParameterStub", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "generateTypeParameterStubs", "typeParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "generateValueParameterStub", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "generateValueParametersStubs", "valueParameters", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "kotlin-compiler"})
public final class DeclarationStubGenerator {
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final IrDeclarationOrigin origin;

    @NotNull
    public final IrModuleFragment generateEmptyModuleFragmentStub(@NotNull ModuleDescriptor descriptor2, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(irBuiltIns, "irBuiltIns");
        return new IrModuleFragmentImpl(descriptor2, irBuiltIns);
    }

    @NotNull
    public final IrExternalPackageFragment generateEmptyExternalPackageFragmentStub(@NotNull PackageFragmentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return this.symbolTable.declareExternalPackageFragment(descriptor2);
    }

    @NotNull
    public final IrDeclaration generateMemberStub(@NotNull DeclarationDescriptor descriptor2) {
        IrDeclaration irDeclaration;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            irDeclaration = DescriptorUtils.isEnumEntry(descriptor2) ? (IrSymbolDeclaration)this.generateEnumEntryStub((ClassDescriptor)descriptor2) : (IrSymbolDeclaration)this.generateClassStub((ClassDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof ClassConstructorDescriptor) {
            irDeclaration = this.generateConstructorStub((ClassConstructorDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            irDeclaration = this.generateFunctionStub((FunctionDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            irDeclaration = this.generatePropertyStub((PropertyDescriptor)descriptor2);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected member descriptor: " + descriptor2)));
        }
        return irDeclaration;
    }

    @NotNull
    public final IrProperty generatePropertyStub(@NotNull PropertyDescriptor descriptor2) {
        IrSimpleFunction irSimpleFunction;
        IrPropertyImpl irPropertyImpl;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        IrPropertyImpl irProperty = irPropertyImpl = new IrPropertyImpl(-1, -1, this.origin, descriptor2);
        PropertyGetterDescriptor getterDescriptor = descriptor2.getGetter();
        if (getterDescriptor == null) {
            irProperty.setBackingField(this.symbolTable.declareField(-1, -1, this.origin, descriptor2));
        } else {
            irProperty.setGetter(this.generateFunctionStub(getterDescriptor));
        }
        IrPropertyImpl irPropertyImpl2 = irProperty;
        PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
        if (propertySetterDescriptor != null) {
            PropertySetterDescriptor it;
            PropertySetterDescriptor propertySetterDescriptor2 = propertySetterDescriptor;
            IrPropertyImpl irPropertyImpl3 = irPropertyImpl2;
            PropertySetterDescriptor propertySetterDescriptor3 = it = propertySetterDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(propertySetterDescriptor3, "it");
            IrSimpleFunction irSimpleFunction2 = this.generateFunctionStub(propertySetterDescriptor3);
            irPropertyImpl2 = irPropertyImpl3;
            irSimpleFunction = irSimpleFunction2;
        } else {
            irSimpleFunction = null;
        }
        irPropertyImpl2.setSetter(irSimpleFunction);
        return irPropertyImpl;
    }

    @NotNull
    public final IrSimpleFunction generateFunctionStub(@NotNull FunctionDescriptor descriptor2) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        FunctionDescriptor functionDescriptor = descriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "descriptor.original");
        IrSimpleFunction irFunction = irSimpleFunction = this.symbolTable.declareSimpleFunction(-1, -1, this.origin, functionDescriptor);
        List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.typeParameters");
        this.generateTypeParameterStubs(list2, irFunction);
        List<ValueParameterDescriptor> list3 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "descriptor.valueParameters");
        this.generateValueParametersStubs((Collection<? extends ValueParameterDescriptor>)list3, irFunction);
        return irSimpleFunction;
    }

    @NotNull
    public final IrConstructor generateConstructorStub(@NotNull ClassConstructorDescriptor descriptor2) {
        IrConstructor irConstructor;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        IrConstructor irConstructor2 = irConstructor = this.symbolTable.declareConstructor(-1, -1, this.origin, descriptor2.getOriginal());
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.valueParameters");
        this.generateValueParametersStubs((Collection<? extends ValueParameterDescriptor>)list2, irConstructor2);
        return irConstructor;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateValueParametersStubs(@NotNull Collection<? extends ValueParameterDescriptor> valueParameters, @NotNull IrFunction function2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(valueParameters, "valueParameters");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Iterable iterable = valueParameters;
        Collection destination$iv = function2.getValueParameters();
        for (Object item$iv : $receiver$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            Collection collection = destination$iv;
            IrValueParameter irValueParameter = this.generateValueParameterStub((ValueParameterDescriptor)it);
            collection.add(irValueParameter);
        }
    }

    @NotNull
    public final IrValueParameter generateValueParameterStub(@NotNull ValueParameterDescriptor descriptor2) {
        IrValueParameterImpl irValueParameterImpl;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        IrValueParameterImpl irValueParameter = irValueParameterImpl = new IrValueParameterImpl(-1, -1, this.origin, descriptor2);
        if (descriptor2.declaresDefaultValue()) {
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.type");
            irValueParameter.setDefaultValue(new IrExpressionBodyImpl(new IrErrorExpressionImpl(-1, -1, kotlinType, "Stub expression for default value of " + descriptor2.getName())));
        }
        return irValueParameterImpl;
    }

    @NotNull
    public final IrClass generateClassStub(@NotNull ClassDescriptor descriptor2) {
        IrClass irClass;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        IrClass irClass2 = irClass = this.symbolTable.declareClass(-1, -1, this.origin, descriptor2);
        List<TypeParameterDescriptor> list2 = descriptor2.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.declaredTypeParameters");
        this.generateTypeParameterStubs(list2, irClass2);
        Collection<ClassConstructorDescriptor> collection = descriptor2.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull(collection, "descriptor.constructors");
        this.generateChildStubs(collection, irClass2);
        this.generateMemberStubs(descriptor2.getDefaultType().getMemberScope(), irClass2);
        MemberScope memberScope2 = descriptor2.getStaticScope();
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "descriptor.staticScope");
        this.generateMemberStubs(memberScope2, irClass2);
        return irClass;
    }

    @NotNull
    public final IrEnumEntry generateEnumEntryStub(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return this.symbolTable.declareEnumEntry(-1, -1, this.origin, descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateTypeParameterStubs(@NotNull List<? extends TypeParameterDescriptor> typeParameters2, @NotNull IrTypeParametersContainer container2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(typeParameters2, "typeParameters");
        Intrinsics.checkParameterIsNotNull(container2, "container");
        Iterable iterable = typeParameters2;
        Collection destination$iv = container2.getTypeParameters();
        for (Object item$iv : $receiver$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv;
            Collection collection = destination$iv;
            IrTypeParameter irTypeParameter = this.generateTypeParameterStub((TypeParameterDescriptor)it);
            collection.add(irTypeParameter);
        }
    }

    @NotNull
    public final IrTypeParameter generateTypeParameterStub(@NotNull TypeParameterDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return new IrTypeParameterImpl(-1, -1, this.origin, descriptor2);
    }

    public final void generateMemberStubs(@NotNull MemberScope memberScope2, @NotNull IrDeclarationContainer container2) {
        Intrinsics.checkParameterIsNotNull(memberScope2, "memberScope");
        Intrinsics.checkParameterIsNotNull(container2, "container");
        this.generateChildStubs(ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null), container2);
    }

    /*
     * WARNING - void declaration
     */
    public final void generateChildStubs(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull IrDeclarationContainer container2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        Intrinsics.checkParameterIsNotNull(container2, "container");
        Iterable iterable = CollectionsKt.sortedWith((Iterable)descriptors, StableDescriptorsComparator.INSTANCE);
        Collection destination$iv = container2.getDeclarations();
        for (Object item$iv : $receiver$iv) {
            void it;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv;
            Collection collection = destination$iv;
            IrDeclaration irDeclaration = this.generateMemberStub((DeclarationDescriptor)it);
            collection.add(irDeclaration);
        }
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final IrDeclarationOrigin getOrigin() {
        return this.origin;
    }

    public DeclarationStubGenerator(@NotNull SymbolTable symbolTable, @NotNull IrDeclarationOrigin origin) {
        Intrinsics.checkParameterIsNotNull(symbolTable, "symbolTable");
        Intrinsics.checkParameterIsNotNull(origin, "origin");
        this.symbolTable = symbolTable;
        this.origin = origin;
    }
}

