/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.LongSentenceRule;

public class LongSentenceRuleTest {
    @Test
    public void testMatch() throws Exception {
        JLanguageTool languageTool = new JLanguageTool(TestTools.getDemoLanguage());
        LongSentenceRule rule = new LongSentenceRule(TestTools.getEnglishMessages());
        this.assertNoMatch(" is a rather short text.", rule, languageTool);
        this.assertMatch("Now this is not a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a rather that short text.", rule, languageTool);
        LongSentenceRule shortRule = new LongSentenceRule(TestTools.getEnglishMessages(), 6);
        this.assertNoMatch("This is a rather short text.", shortRule, languageTool);
        this.assertMatch("This is also a rather short text.", shortRule, languageTool);
        this.assertNoMatch("These ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ don't count.", shortRule, languageTool);
        this.assertNoMatch("one two three four five six.", shortRule, languageTool);
        this.assertNoMatch("one two three (four) five six.", shortRule, languageTool);
        this.assertMatch("one two three four five six seven.", shortRule, languageTool);
    }

    private void assertNoMatch(String input, LongSentenceRule rule, JLanguageTool languageTool) throws IOException {
        MatcherAssert.assertThat((Object)rule.match(languageTool.getAnalyzedSentence(input)).length, (Matcher)CoreMatchers.is((Object)0));
    }

    private void assertMatch(String input, LongSentenceRule rule, JLanguageTool languageTool) throws IOException {
        MatcherAssert.assertThat((Object)rule.match(languageTool.getAnalyzedSentence(input)).length, (Matcher)CoreMatchers.is((Object)1));
    }
}

