/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.OpenNMTRule;

public class OpenNMTRuleTest {
    @Test
    @Ignore(value="only works when OpenNMT server is running")
    public void testRule() throws IOException {
        OpenNMTRule rule = new OpenNMTRule();
        JLanguageTool lt = new JLanguageTool(Languages.getLanguageForShortCode((String)"xx"));
        String input = "This were an example.";
        Object[] matches = rule.match(lt.getAnalyzedSentence(input));
        System.out.println("-->" + Arrays.toString(matches));
    }

    @Test
    public void testGetFirstDiffPosition() throws IOException {
        OpenNMTRule r = new OpenNMTRule();
        this.testFirst(r, "", "", -1);
        this.testFirst(r, "a", "", 0);
        this.testFirst(r, "a", "a", -1);
        this.testFirst(r, "ab", "ab", -1);
        this.testFirst(r, "ab", "ba", 0);
        this.testFirst(r, "xa", "xb", 1);
        this.testFirst(r, "xax", "xbx", 1);
        this.testFirst(r, "xxxa", "xxxb", 3);
        this.testFirst(r, "xxxa", "xxx", 3);
        this.testFirst(r, "xxx", "xxxb", 3);
        this.testFirst(r, "xxxyyy", "xxxbyyy", 3);
        this.testFirst(r, "This were a example.", "This were an example.", 11);
    }

    @Test
    public void testGetLastDiffPosition() throws IOException {
        OpenNMTRule r = new OpenNMTRule();
        this.testLast(r, "", "", -1);
        this.testLast(r, "a", "", 1);
        this.testLast(r, "a", "a", -1);
        this.testLast(r, "ba", "a", 1);
        this.testLast(r, "a", "ba", 0);
        this.testLast(r, "xba", "bba", 1);
        this.testLast(r, "bba", "xba", 1);
        this.testLast(r, "aa", "aa", -1);
        this.testLast(r, "bbb", "bbb", -1);
        this.testLast(r, "bb", "b", 1);
        this.testLast(r, "bbb", "b", 2);
        this.testLast(r, "b", "bb", 0);
        this.testLast(r, "b", "bbb", 0);
        this.testLast(r, "This were a example.", "This were an example.", 11);
    }

    private void testFirst(OpenNMTRule rule, String text1, String text2, int expectedResult) {
        Assert.assertThat((Object)rule.getFirstDiffPosition(text1, text2), (Matcher)CoreMatchers.is((Object)expectedResult));
        Assert.assertThat((Object)rule.getFirstDiffPosition(text2, text1), (Matcher)CoreMatchers.is((Object)expectedResult));
    }

    private void testLast(OpenNMTRule rule, String text1, String text2, int expectedResult) {
        Assert.assertThat((Object)rule.getLastDiffPosition(text1, text2), (Matcher)CoreMatchers.is((Object)expectedResult));
    }
}

