/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.facet.specific.sequence_aio.DrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.HorizontalDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.Lifeline;
import com.baselet.element.facet.specific.sequence_aio.LifelineOccurrence;
import com.baselet.element.facet.specific.sequence_aio.Message;
import com.baselet.element.facet.specific.sequence_aio.OccurrenceSpecification;
import com.baselet.element.relation.helper.RelationDrawer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LostOrFoundMessage
implements LifelineOccurrence {
    private static final Logger log = LoggerFactory.getLogger(LostOrFoundMessage.class);
    private static final double CIRCLE_RADIUS = 10.0;
    private static final double LIFELINE_TEXT_PADDING = Math.max(13.0, 20.0) + 3.0;
    private final Lifeline lifeline;
    private final int sendTick;
    private final String[] textLines;
    private final Message.ArrowType arrowType;
    private final LineType lineType;
    private final boolean found;

    public LostOrFoundMessage(Lifeline lifeline, boolean found, int sendTick, String text, Message.ArrowType arrowType, LineType lineType) {
        this.lifeline = lifeline;
        this.found = found;
        this.sendTick = sendTick;
        this.textLines = text.split("\n");
        this.arrowType = arrowType;
        this.lineType = lineType;
    }

    public double getCenterXOffset() {
        if (this.found) {
            return -this.lifeline.getLifelineLeftPartWidth(this.sendTick);
        }
        return this.lifeline.getLifelineRightPartWidth(this.sendTick);
    }

    @Override
    public Line1D draw(DrawHandler drawHandler, PointDouble topLeft, PointDouble size) {
        double lineXEnd;
        double lineXStart;
        RelationDrawer.ArrowEndType arrowEndType = RelationDrawer.ArrowEndType.NORMAL;
        boolean fillArrow = false;
        switch (this.arrowType) {
            case OPEN: {
                arrowEndType = RelationDrawer.ArrowEndType.NORMAL;
                fillArrow = false;
                break;
            }
            case FILLED: {
                arrowEndType = RelationDrawer.ArrowEndType.CLOSED;
                fillArrow = true;
                break;
            }
            default: {
                log.error("Encountered unhandled enumeration value '" + (Object)((Object)this.arrowType) + "'.");
            }
        }
        LineType oldLt = drawHandler.getLineType();
        drawHandler.setLineType(this.lineType);
        double centerY = topLeft.y + size.y / 2.0;
        ColorOwn oldBg = drawHandler.getBackgroundColor();
        drawHandler.setBackgroundColor(drawHandler.getForegroundColor());
        if (this.found) {
            drawHandler.drawCircle(topLeft.x + 10.0, centerY, 10.0);
            lineXStart = topLeft.x + 20.0;
            lineXEnd = topLeft.x + size.x / 2.0 + this.getCenterXOffset();
        } else {
            drawHandler.drawCircle(topLeft.x + size.x - 10.0, topLeft.y + size.y / 2.0, 10.0);
            lineXStart = topLeft.x + size.x / 2.0 + this.getCenterXOffset();
            lineXEnd = topLeft.x + size.x - 20.0;
        }
        drawHandler.setBackgroundColor(oldBg);
        TextSplitter.drawText(drawHandler, this.textLines, lineXStart, topLeft.y, lineXEnd - lineXStart, size.y / 2.0, AlignHorizontal.CENTER, AlignVertical.BOTTOM);
        PointDouble arrowPoint = new PointDouble(lineXEnd, centerY);
        Line line = new Line(new PointDouble(lineXStart, centerY), arrowPoint);
        drawHandler.drawLine(line);
        RelationDrawer.drawArrowToLine(arrowPoint, drawHandler, line, false, arrowEndType, fillArrow, false);
        drawHandler.setLineType(oldLt);
        return null;
    }

    @Override
    public double getMinWidth(DrawHandler drawHandler) {
        return (TextSplitter.getTextMinWidth(this.textLines, drawHandler) + LIFELINE_TEXT_PADDING * 2.0 + Math.abs(this.getCenterXOffset())) * 2.0;
    }

    @Override
    public double getAdditionalYHeight(DrawHandler drawHandler, PointDouble size) {
        return TextSplitter.getSplitStringHeight(this.textLines, size.x / 2.0 - LIFELINE_TEXT_PADDING * 2.0 - Math.abs(this.getCenterXOffset()), drawHandler) * 2.0 - size.y;
    }

    public OccurrenceSpecification sendOccurrenceSpecification() {
        if (this.found) {
            throw new IllegalStateException("A found message has no send occurrence specification.");
        }
        return new LostOrFoundOccurrenceSpecification();
    }

    public OccurrenceSpecification receiveOccurrenceSpecification() {
        if (!this.found) {
            throw new IllegalStateException("A lost message has no receive occurrence specification.");
        }
        return new LostOrFoundOccurrenceSpecification();
    }

    private class LostOrFoundOccurrenceSpecification
    implements OccurrenceSpecification {
        private LostOrFoundOccurrenceSpecification() {
        }

        @Override
        public Lifeline getLifeline() {
            return LostOrFoundMessage.this.lifeline;
        }

        @Override
        public boolean hasFixedPosition() {
            return true;
        }

        @Override
        public AlignHorizontal getFixedPositionAlignment() {
            if (LostOrFoundMessage.this.getCenterXOffset() >= 0.0) {
                return AlignHorizontal.RIGHT;
            }
            return AlignHorizontal.LEFT;
        }

        @Override
        public double getHorizonatlPosition(HorizontalDrawingInfo hDrawingInfo) {
            return hDrawingInfo.getHDrawingInfo(this.getLifeline()).getHorizontalCenter() + LostOrFoundMessage.this.getCenterXOffset();
        }

        @Override
        public double getHorizontalPosition(HorizontalDrawingInfo llHDrawingInfo, boolean left) {
            return 0.0;
        }

        @Override
        public PointDouble getPosition(DrawingInfo drawingInfo) {
            return new PointDouble(this.getHorizonatlPosition(drawingInfo), drawingInfo.getVerticalCenter(LostOrFoundMessage.this.sendTick));
        }

        @Override
        public PointDouble getPosition(DrawingInfo drawingInfo, boolean left) {
            return new PointDouble(0.0, 0.0);
        }
    }
}

