/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.representations.CFGLinearizer;

public class FullInterpreterContext
extends InterpreterContext {
    private CFG cfg;
    private BasicBlock[] linearizedBBList = null;
    private int[] rescueIPCs = null;
    private Map<String, DataFlowProblem> dataFlowProblems;
    private List<CompilerPass> executedPasses = new ArrayList<CompilerPass>();

    public FullInterpreterContext(IRScope scope, Instr[] instructions) {
        super(scope, (List<Instr>)null);
        this.cfg = this.buildCFG(instructions);
    }

    @Override
    public boolean buildComplete() {
        return this.linearizedBBList != null;
    }

    public BasicBlock[] linearizeBasicBlocks() {
        this.linearizedBBList = CFGLinearizer.linearize(this.cfg);
        return this.linearizedBBList;
    }

    private CFG buildCFG(Instr[] instructions) {
        CFG newCFG = new CFG(this.getScope());
        newCFG.build(instructions);
        return newCFG;
    }

    @Override
    public boolean hasExplicitCallProtocol() {
        return this.getScope().getFlags().contains((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
    }

    @Override
    public boolean pushNewDynScope() {
        return !this.getScope().getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED) && !this.reuseParentDynScope();
    }

    @Override
    public boolean popDynScope() {
        return this.pushNewDynScope() || this.reuseParentDynScope();
    }

    @Override
    public boolean reuseParentDynScope() {
        return this.getScope().getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
    }

    public void generateInstructionsForInterpretation() {
        this.linearizeBasicBlocks();
        ArrayList<Instr> newInstrs = new ArrayList<Instr>();
        int ipc = 0;
        for (BasicBlock b2 : this.getLinearizedBBList()) {
            b2.getLabel().setTargetPC(ipc);
            List<Instr> bbInstrs = b2.getInstrs();
            int bbInstrsLength = bbInstrs.size();
            for (int i2 = 0; i2 < bbInstrsLength; ++i2) {
                Instr instr = bbInstrs.get(i2);
                if (instr instanceof ReceiveSelfInstr) continue;
                if (instr instanceof LabelInstr) {
                    ((LabelInstr)instr).getLabel().setTargetPC(ipc);
                }
                newInstrs.add(instr);
                ++ipc;
            }
        }
        this.cfg.getExitBB().getLabel().setTargetPC(ipc + 1);
        Instr[] linearizedInstrArray = newInstrs.toArray(new Instr[newInstrs.size()]);
        BasicBlock[] basicBlocks = this.getLinearizedBBList();
        this.rescueIPCs = new int[2 * basicBlocks.length];
        ipc = 0;
        for (int i3 = 0; i3 < basicBlocks.length; ++i3) {
            BasicBlock bb = basicBlocks[i3];
            BasicBlock rescuerBB = this.cfg.getRescuerBBFor(bb);
            int rescuerPC = rescuerBB == null ? -1 : rescuerBB.getLabel().getTargetPC();
            this.rescueIPCs[i3 * 2] = ipc + bb.getInstrs().size();
            this.rescueIPCs[i3 * 2 + 1] = rescuerPC;
            for (Instr instr : bb.getInstrs()) {
                if (!(instr instanceof ReceiveSelfInstr)) {
                    ++ipc;
                    continue;
                }
                int n = i3 * 2;
                this.rescueIPCs[n] = this.rescueIPCs[n] - 1;
            }
        }
        this.instructions = linearizedInstrArray;
        this.temporaryVariablecount = this.getScope().getTemporaryVariablesCount();
    }

    @Override
    public CFG getCFG() {
        return this.cfg;
    }

    @Override
    public void computeScopeFlagsFromInstructions() {
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            for (Instr i2 : b2.getInstrs()) {
                i2.computeScopeFlags(this.getScope());
            }
        }
    }

    public Map<String, DataFlowProblem> getDataFlowProblems() {
        if (this.dataFlowProblems == null) {
            this.dataFlowProblems = new HashMap<String, DataFlowProblem>();
        }
        return this.dataFlowProblems;
    }

    public List<CompilerPass> getExecutedPasses() {
        return this.executedPasses;
    }

    public BasicBlock[] getLinearizedBBList() {
        return this.linearizedBBList;
    }

    @Override
    public String toStringInstrs() {
        return "\nCFG:\n" + this.cfg.toStringGraph() + "\nInstructions:\n" + this.cfg.toStringInstrs();
    }

    public int determineRPC(int ipc) {
        int length2 = this.rescueIPCs.length;
        int i2 = 0;
        while (i2 + 1 < length2) {
            if (ipc <= this.rescueIPCs[i2]) {
                return this.rescueIPCs[i2 + 1];
            }
            i2 += 2;
        }
        throw new RuntimeException("BUG: no RPC found for " + this.getFileName() + ":" + this.getName() + ":" + ipc + this.getInstructions());
    }
}

