/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;

public final class DownloadNotesInViewAction
extends JosmAction {
    private DownloadNotesInViewAction(String string) {
        super(I18n.tr("Download notes in current view", new Object[0]), string, I18n.tr("Download notes in current view", new Object[0]), null, false, "dialogs/notes/download_in_view", true);
    }

    public static DownloadNotesInViewAction newActionWithNoteIcon() {
        return new DownloadNotesInViewAction("dialogs/notes/note_open");
    }

    public static DownloadNotesInViewAction newActionWithDownloadIcon() {
        return new DownloadNotesInViewAction("download");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Bounds bounds = MainApplication.getMap().mapView.getRealBounds();
        DownloadNotesTask downloadNotesTask = new DownloadNotesTask();
        downloadNotesTask.setZoomAfterDownload(false);
        Future<?> future = downloadNotesTask.download(false, bounds, null);
        MainApplication.worker.submit(new PostDownloadHandler(downloadNotesTask, future));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveLayer() != null && !Main.isOffline(OnlineResource.OSM_API));
    }
}

