/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class SessionLoadAction
extends DiskAccessAction {
    public SessionLoadAction() {
        super(I18n.tr("Load Session", new Object[0]), "open", I18n.tr("Load a session from file.", new Object[0]), null, true, "load-session", true);
        this.putValue("help", HelpUtil.ht("/Action/SessionLoad"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AbstractFileChooser abstractFileChooser = SessionLoadAction.createAndOpenFileChooser(true, false, I18n.tr("Open session", new Object[0]), Arrays.asList(SessionImporter.FILE_FILTER, FileFilterAllFiles.getInstance()), SessionImporter.FILE_FILTER, 0, "lastDirectory");
        if (abstractFileChooser == null) {
            return;
        }
        File file = abstractFileChooser.getSelectedFile();
        boolean bl = Utils.hasExtension(file, "joz");
        MainApplication.worker.submit(new Loader(file, bl));
    }

    public static class Loader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private File file;
        private final URI uri;
        private final InputStream is;
        private final boolean zip;
        private List<Layer> layers;
        private Layer active;
        private List<Runnable> postLoadTasks;
        private SessionReader.SessionViewportData viewport;
        private SessionReader.SessionProjectionChoiceData projectionChoice;

        public Loader(File file, boolean bl) {
            super(I18n.tr("Loading session ''{0}''", file.getName()));
            CheckParameterUtil.ensureParameterNotNull(file, "file");
            this.file = file;
            this.uri = null;
            this.is = null;
            this.zip = bl;
        }

        public Loader(InputStream inputStream, URI uRI, boolean bl) {
            super(I18n.tr("Loading session ''{0}''", uRI));
            CheckParameterUtil.ensureParameterNotNull(inputStream, "is");
            CheckParameterUtil.ensureParameterNotNull(uRI, "uri");
            this.file = null;
            this.uri = uRI;
            this.is = inputStream;
            this.zip = bl;
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(() -> {
                if (this.canceled) {
                    return;
                }
                if (this.projectionChoice != null) {
                    ProjectionPreference.setProjection(this.projectionChoice.getProjectionChoiceId(), this.projectionChoice.getSubPreferences(), false);
                }
                this.addLayers();
                this.runPostLoadTasks();
            });
        }

        private void addLayers() {
            if (this.layers != null && !this.layers.isEmpty()) {
                boolean bl = MainApplication.getMap() == null;
                for (Layer layer : this.layers) {
                    if (this.canceled) {
                        return;
                    }
                    MainApplication.getLayerManager().addLayer(layer);
                }
                if (this.active != null) {
                    MainApplication.getLayerManager().setActiveLayer(this.active);
                }
                if (bl && this.viewport != null) {
                    MainApplication.getMap().mapView.scheduleZoomTo(this.viewport.getEastNorthViewport(Main.getProjection()));
                }
            }
        }

        private void runPostLoadTasks() {
            if (this.postLoadTasks != null) {
                for (Runnable runnable : this.postLoadTasks) {
                    if (this.canceled) {
                        return;
                    }
                    if (runnable == null) continue;
                    runnable.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() {
            try {
                ProgressMonitor progressMonitor = this.getProgressMonitor();
                SessionReader sessionReader = new SessionReader();
                boolean bl = false;
                try {
                    if (this.file == null) {
                        this.file = File.createTempFile("session_", ".joz", Utils.getJosmTempDir());
                        bl = true;
                        Files.copy(this.is, this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    sessionReader.loadSession(this.file, this.zip, progressMonitor);
                    this.layers = sessionReader.getLayers();
                    this.active = sessionReader.getActive();
                    this.postLoadTasks = sessionReader.getPostLoadTasks();
                    this.viewport = sessionReader.getViewport();
                    this.projectionChoice = sessionReader.getProjectionChoice();
                }
                finally {
                    if (bl) {
                        Utils.deleteFile(this.file);
                        this.file = null;
                    }
                }
            }
            catch (IllegalDataException illegalDataException) {
                this.handleException(I18n.tr("Data Error", new Object[0]), illegalDataException);
            }
            catch (IOException iOException) {
                this.handleException(I18n.tr("IO Error", new Object[0]), iOException);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
                this.cancel();
                throw runtimeException;
            }
        }

        private void handleException(String string, Exception exception) {
            Logging.error(exception);
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not load session file ''{0}''.<br>Error is:<br>{1}</html>", this.uri != null ? this.uri : this.file.getName(), Utils.escapeReservedCharactersHTML(exception.getMessage())), string, 0, null);
            this.cancel();
        }
    }
}

