/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class ToggleAction
extends JosmAction {
    private final transient Set<ButtonModel> buttonModels = new HashSet<ButtonModel>();

    public ToggleAction(String string, ImageProvider imageProvider, String string2, Shortcut shortcut, boolean bl, String string3, boolean bl2) {
        super(string, imageProvider, string2, shortcut, bl, string3, bl2);
        this.setSelected(false);
    }

    public ToggleAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        super(string, string2, string3, shortcut, bl);
        this.setSelected(false);
    }

    protected final void setSelected(boolean bl) {
        this.putValue("SwingSelectedKey", bl);
    }

    public final boolean isSelected() {
        Object object = this.getValue("SwingSelectedKey");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        Logging.warn(this.getClass().getName() + " does not define a boolean for SELECTED_KEY but " + object + ". You should report it to JOSM developers.");
        return false;
    }

    public final void addButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && !this.buttonModels.contains(buttonModel)) {
            this.buttonModels.add(buttonModel);
            buttonModel.setSelected(this.isSelected());
        }
    }

    public final void removeButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && this.buttonModels.contains(buttonModel)) {
            this.buttonModels.remove(buttonModel);
        }
    }

    protected void notifySelectedState() {
        boolean bl = this.isSelected();
        for (ButtonModel buttonModel : this.buttonModels) {
            if (buttonModel.isSelected() == bl) continue;
            buttonModel.setSelected(bl);
        }
    }

    protected final void toggleSelectedState(ActionEvent actionEvent) {
        if (!(actionEvent != null && (actionEvent.getSource() instanceof JToggleButton || actionEvent.getSource() instanceof JCheckBox || actionEvent.getSource() instanceof JRadioButton || actionEvent.getSource() instanceof JCheckBoxMenuItem || actionEvent.getSource() instanceof JRadioButtonMenuItem))) {
            this.setSelected(!this.isSelected());
        }
    }
}

